/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CreateCollectionAPI;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collectionName}/shards")
public class CreateShardAPI
extends AdminAPIBase {
    @Inject
    public CreateShardAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse createShard(@PathParam(value="collectionName") String collectionName, CreateShardRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request-body is missing");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", requestBody.shardName);
        SolrIdentifierValidator.validateShardName((String)requestBody.shardName);
        String resolvedCollectionName = this.resolveAndValidateAliasIfEnabled(collectionName, Boolean.TRUE.equals(requestBody.followAliases));
        this.ensureCollectionUsesImplicitRouter(resolvedCollectionName);
        ZkNodeProps remoteMessage = CreateShardAPI.createRemoteMessage(resolvedCollectionName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.CREATESHARD, remoteMessage, requestBody.asyncId);
        return response;
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        CreateShardRequestBody requestBody = CreateShardRequestBody.fromV1Params(solrQueryRequest.getParams());
        CreateShardAPI createShardApi = new CreateShardAPI(coreContainer, solrQueryRequest, solrQueryResponse);
        SubResponseAccumulatingJerseyResponse response = createShardApi.createShard(solrQueryRequest.getParams().get("collection"), requestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, response);
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, CreateShardRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATESHARD.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("shard", requestBody.shardName);
        if (requestBody.createReplicas == null || requestBody.createReplicas.booleanValue()) {
            if (requestBody.nodeSet != null) {
                remoteMessage.put("createNodeSet", String.join((CharSequence)",", requestBody.nodeSet));
            }
        } else {
            remoteMessage.put("createNodeSet", "EMPTY");
        }
        CreateShardAPI.insertIfNotNull(remoteMessage, "replicationFactor", requestBody.replicationFactor);
        CreateShardAPI.insertIfNotNull(remoteMessage, "nrtReplicas", requestBody.nrtReplicas);
        CreateShardAPI.insertIfNotNull(remoteMessage, "tlogReplicas", requestBody.tlogReplicas);
        CreateShardAPI.insertIfNotNull(remoteMessage, "pullReplicas", requestBody.pullReplicas);
        CreateShardAPI.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
        CreateShardAPI.insertIfNotNull(remoteMessage, "followAliases", requestBody.followAliases);
        CreateShardAPI.insertIfNotNull(remoteMessage, "async", requestBody.asyncId);
        if (requestBody.properties != null) {
            requestBody.properties.entrySet().forEach(entry -> remoteMessage.put("property." + (String)entry.getKey(), entry.getValue()));
        }
        return new ZkNodeProps(remoteMessage);
    }

    private void ensureCollectionUsesImplicitRouter(String collectionName) {
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        if (!"implicit".equals(((Map)clusterState.getCollection(collectionName).get("router")).get("name"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
        }
    }

    public static class CreateShardRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(value="name")
        public String shardName;
        @JsonProperty(value="replicationFactor")
        public Integer replicationFactor;
        @JsonProperty(value="nrtReplicas")
        public Integer nrtReplicas;
        @JsonProperty(value="tlogReplicas")
        public Integer tlogReplicas;
        @JsonProperty(value="pullReplicas")
        public Integer pullReplicas;
        @JsonProperty(value="createReplicas")
        public Boolean createReplicas;
        @JsonProperty(value="nodeSet")
        public List<String> nodeSet;
        @JsonProperty(value="waitForFinalState")
        public Boolean waitForFinalState;
        @JsonProperty(value="followAliases")
        public Boolean followAliases;
        @JsonProperty(value="async")
        public String asyncId;
        @JsonProperty
        public Map<String, String> properties;

        public static CreateShardRequestBody fromV1Params(SolrParams params) {
            params.required().check(new String[]{"collection", "shard"});
            CreateShardRequestBody requestBody = new CreateShardRequestBody();
            requestBody.shardName = params.get("shard");
            requestBody.replicationFactor = params.getInt("replicationFactor");
            requestBody.nrtReplicas = params.getInt("nrtReplicas");
            requestBody.tlogReplicas = params.getInt("tlogReplicas");
            requestBody.pullReplicas = params.getInt("pullReplicas");
            if (params.get("createNodeSet") != null) {
                String nodeSetStr = params.get("createNodeSet");
                if ("EMPTY".equals(nodeSetStr)) {
                    requestBody.createReplicas = false;
                } else {
                    requestBody.nodeSet = Arrays.asList(nodeSetStr.split(","));
                }
            }
            requestBody.waitForFinalState = params.getBool("waitForFinalState");
            requestBody.followAliases = params.getBool("followAliases");
            requestBody.asyncId = params.get("async");
            requestBody.properties = CreateCollectionAPI.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
            return requestBody;
        }
    }
}

