/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.BackupDeletionData;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionAdminParams;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.BackupAPIBase;
import org.apache.solr.handler.admin.api.CreateCollectionAPI;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.common.StringUtils;

@Path(value="/collections/{collectionName}/backups/{backupName}/versions")
public class CreateCollectionBackupAPI
extends BackupAPIBase {
    private final ObjectMapper objectMapper = SolrJacksonMapper.getObjectMapper();

    @Inject
    public CreateCollectionBackupAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createCollectionBackup(@PathParam(value="collectionName") String collectionName, @PathParam(value="backupName") String backupName, CreateCollectionBackupRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        if (StringUtils.isBlank((String)backupName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: 'backupName'");
        }
        if (collectionName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: 'collection'");
        }
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        CreateCollectionBackupAPI.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        collectionName = this.resolveAndValidateAliasIfEnabled(collectionName, Boolean.TRUE.equals(requestBody.followAliases));
        requestBody.location = this.getAndValidateBackupLocation(requestBody.repository, requestBody.location);
        if (requestBody.incremental == null) {
            requestBody.incremental = Boolean.TRUE;
        }
        if (requestBody.backupStrategy == null) {
            requestBody.backupStrategy = "copy-files";
        }
        if (!CollectionAdminParams.INDEX_BACKUP_STRATEGIES.contains(requestBody.backupStrategy)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown index backup strategy " + requestBody.backupStrategy);
        }
        ZkNodeProps remoteMessage = CreateCollectionBackupAPI.createRemoteMessage(collectionName, backupName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.BACKUP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        SolrJerseyResponse response = (SolrJerseyResponse)this.objectMapper.convertValue((Object)remoteResponse.getResponse(), CreateCollectionBackupResponseBody.class);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String backupName, CreateCollectionBackupRequestBody requestBody) {
        Map remoteMessage = requestBody.toMap(new HashMap());
        remoteMessage.put("operation", CollectionParams.CollectionAction.BACKUP.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("name", backupName);
        if (!StringUtils.isBlank((String)requestBody.backupStrategy)) {
            remoteMessage.put("indexBackup", remoteMessage.remove("backupStrategy"));
        }
        if (!StringUtils.isBlank((String)requestBody.snapshotName)) {
            remoteMessage.put("commitName", remoteMessage.remove("snapshotName"));
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static CreateCollectionBackupRequestBody createRequestBodyFromV1Params(SolrParams params) {
        CreateCollectionBackupRequestBody requestBody = new CreateCollectionBackupRequestBody();
        requestBody.location = params.get("location");
        requestBody.repository = params.get("repository");
        requestBody.followAliases = params.getBool("followAliases");
        requestBody.backupStrategy = params.get("indexBackup");
        requestBody.snapshotName = params.get("commitName");
        requestBody.incremental = params.getBool("incremental");
        requestBody.backupConfigset = params.getBool("backupConfigset");
        requestBody.maxNumBackupPoints = params.getInt("maxNumBackupPoints");
        requestBody.extraProperties = CreateCollectionAPI.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
        requestBody.async = params.get("async");
        return requestBody;
    }

    public static SolrJerseyResponse invokeFromV1Params(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer coreContainer) throws Exception {
        req.getParams().required().check(new String[]{"name", "collection"});
        String collectionName = req.getParams().get("collection");
        String backupName = req.getParams().get("name");
        CreateCollectionBackupRequestBody requestBody = CreateCollectionBackupAPI.createRequestBodyFromV1Params(req.getParams());
        CreateCollectionBackupAPI createBackupApi = new CreateCollectionBackupAPI(coreContainer, req, rsp);
        return createBackupApi.createCollectionBackup(collectionName, backupName, requestBody);
    }

    public static class CollectionBackupDetails
    implements JacksonReflectMapWriter {
        @JsonProperty
        public String collection;
        @JsonProperty
        public Integer numShards;
        @JsonProperty
        public Integer backupId;
        @JsonProperty
        public String indexVersion;
        @JsonProperty
        public String startTime;
        @JsonProperty
        public String endTime;
        @JsonProperty
        public Integer indexFileCount;
        @JsonProperty
        public Integer uploadedIndexFileCount;
        @JsonProperty
        public Double indexSizeMB;
        @JsonProperty
        public Map<String, String> extraProperties;
        @JsonProperty(value="uploadedIndexFileMB")
        public Double uploadedIndexSizeMB;
        @JsonProperty
        public List<String> shardBackupIds;
    }

    public static class CreateCollectionBackupResponseBody
    extends SubResponseAccumulatingJerseyResponse {
        @JsonProperty(value="response")
        public CollectionBackupDetails backupDataResponse;
        @JsonProperty(value="deleted")
        public List<BackupDeletionData> deleted;
        @JsonProperty
        public String collection;
    }

    public static class CreateCollectionBackupRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty
        public String location;
        @JsonProperty
        public String repository;
        @JsonProperty
        public Boolean followAliases;
        @JsonProperty
        public String backupStrategy;
        @JsonProperty
        public String snapshotName;
        @JsonProperty
        public Boolean incremental;
        @JsonProperty
        public Boolean backupConfigset;
        @JsonProperty
        public Integer maxNumBackupPoints;
        @JsonProperty
        public String async;
        @JsonProperty
        public Map<String, String> extraProperties;
    }
}

