/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCollectionCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> okayExceptions = Collections.singleton(NonExistentCoreException.class.getName());
    private final CollectionCommandContext ccc;

    public DeleteCollectionCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        Object o = message.get("invokedByRoutedAlias");
        if (o != null) {
            ((Runnable)o).run();
        }
        String extCollection = message.getStr("name");
        ZkStateReader zkStateReader = this.ccc.getZkStateReader();
        if (zkStateReader.aliasesManager != null) {
            zkStateReader.aliasesManager.update();
        }
        boolean followAliases = message.getBool("followAliases", false);
        List<String> aliasReferences = this.checkAliasReference(zkStateReader, extCollection, followAliases);
        Aliases aliases = zkStateReader.getAliases();
        String collection = followAliases ? aliases.resolveSimpleAlias(extCollection) : extCollection;
        DocCollection coll = state.getCollectionOrNull(collection);
        if (coll != null) {
            Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
            assignStrategy.verifyDeleteCollection(this.ccc.getSolrCloudManager(), coll);
        }
        boolean removeCounterNode = true;
        try {
            String configSetName;
            SolrZkClient zkClient = zkStateReader.getZkClient();
            SolrSnapshotManager.cleanupCollectionLevelSnapshots(zkClient, collection);
            if (zkStateReader.getClusterState().getCollectionOrNull(collection) == null && zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            String asyncId = message.getStr("async");
            ZkNodeProps internalMsg = message.plus("name", (Object)collection);
            List<Replica> failedReplicas = CollectionHandlingUtils.collectionCmd(internalMsg, params, results, null, asyncId, okayExceptions, this.ccc, state);
            for (Replica failedReplica : failedReplicas) {
                boolean isSharedFS = failedReplica.getBool("shared_storage", false) && failedReplica.get("dataDir") != null;
                if (!isSharedFS) continue;
                removeCounterNode = false;
                break;
            }
            ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection});
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ClusterDeleteCollection, m, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate((MapWriter)m);
            }
            zkStateReader.waitForState(collection, 60L, TimeUnit.SECONDS, Objects::isNull);
            if (!aliasReferences.isEmpty()) {
                this.ccc.getZkStateReader().aliasesManager.applyModificationAndExportToZk(a -> {
                    for (String alias : aliasReferences) {
                        a = a.cloneWithCollectionAlias(alias, null);
                    }
                    return a;
                });
            }
            if (ConfigSetsHandler.isAutoGeneratedConfigSet(configSetName = coll.getConfigName())) {
                boolean configSetIsUsedByOtherCollection = false;
                for (Map.Entry entry : zkStateReader.getClusterState().getCollectionsMap().entrySet()) {
                    String otherConfigSetName = ((DocCollection)entry.getValue()).getConfigName();
                    if (!configSetName.equals(otherConfigSetName)) continue;
                    configSetIsUsedByOtherCollection = true;
                    break;
                }
                if (!configSetIsUsedByOtherCollection) {
                    this.ccc.getCoreContainer().getConfigSetService().deleteConfig(configSetName);
                }
            }
        }
        finally {
            try {
                String collectionPath = DocCollection.getCollectionPathRoot((String)collection);
                if (zkStateReader.getZkClient().exists(collectionPath, true).booleanValue()) {
                    if (removeCounterNode) {
                        zkStateReader.getZkClient().clean(collectionPath);
                    } else {
                        String counterNodePath = Assign.getCounterNodePath(collection);
                        zkStateReader.getZkClient().clean(collectionPath, s -> !s.equals(counterNodePath));
                    }
                }
            }
            catch (InterruptedException e) {
                log.error("Cleaning up collection in zk was interrupted: {}", (Object)collection, (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                log.error("Problem cleaning up collection in zk: {}", (Object)collection, (Object)e);
            }
        }
    }

    private List<String> checkAliasReference(ZkStateReader zkStateReader, String extCollection, boolean followAliases) throws Exception {
        Aliases aliases = zkStateReader.getAliases();
        List<String> aliasesRefs = DeleteCollectionCmd.referencedByAlias(extCollection, aliases, followAliases);
        ArrayList<String> aliasesToDelete = new ArrayList<String>();
        if (aliasesRefs.size() > 0) {
            String collection;
            zkStateReader.aliasesManager.update();
            aliases = zkStateReader.getAliases();
            aliasesRefs = DeleteCollectionCmd.referencedByAlias(extCollection, aliases, followAliases);
            String string = collection = followAliases ? aliases.resolveSimpleAlias(extCollection) : extCollection;
            if (aliasesRefs.size() > 0) {
                for (String alias : aliasesRefs) {
                    if (!extCollection.equals(alias)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection : " + collection + " is part of aliases: " + aliasesRefs + ", remove or modify the aliases before removing this collection.");
                    }
                    aliasesToDelete.add(alias);
                }
            }
        }
        return aliasesToDelete;
    }

    public static List<String> referencedByAlias(String extCollection, Aliases aliases, boolean followAliases) throws IllegalArgumentException {
        Objects.requireNonNull(aliases);
        String collection = followAliases ? aliases.resolveSimpleAlias(extCollection) : extCollection;
        return aliases.getCollectionAliasListMap().entrySet().stream().filter(e -> !((String)e.getKey()).equals(collection)).filter(e -> ((List)e.getValue()).contains(collection) || ((List)e.getValue()).contains(extCollection)).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

