/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;

public class TestFileInitializer
extends FileInitializer {
    public TestFileInitializer(BaseHome basehome) {
        super(basehome, new String[0]);
    }

    @Override
    public boolean isApplicable(URI uri) {
        return true;
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        Path destination = this.getDestination(uri, location);
        if (destination != null) {
            if (location.endsWith("/")) {
                FS.ensureDirectoryExists(destination);
            } else {
                FS.ensureDirectoryExists(destination.getParent());
            }
        }
        StartLog.info("Skipping download of %s", uri);
        return true;
    }
}

