/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.util.format.FormatElement;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum FormatElementEnum implements FormatElement
{
    D("F", "The weekday (Monday as the first day of the week) as a decimal number (1-7)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(7)));
        }
    }
    ,
    DAY("EEEE", "The full weekday name"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.eeeeFormat.format(date));
        }
    }
    ,
    DD("dd", "The day of the month as a decimal number (01-31)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(5)));
        }
    }
    ,
    DDD("D", "The day of the year as a decimal number (001-366)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%03d", calendar.get(6)));
        }
    }
    ,
    DY("EEE", "The abbreviated weekday name"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.eeeFormat.format(date));
        }
    }
    ,
    FF1("S", "Fractional seconds to 1 digit"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sFormat.format(date));
        }
    }
    ,
    FF2("SS", "Fractional seconds to 2 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.ssFormat.format(date));
        }
    }
    ,
    FF3("SSS", "Fractional seconds to 3 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date));
        }
    }
    ,
    FF4("SSSS", "Fractional seconds to 4 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.ssssFormat.format(date));
        }
    }
    ,
    FF5("SSSSS", "Fractional seconds to 5 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssssFormat.format(date));
        }
    }
    ,
    FF6("SSSSSS", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.ssssssFormat.format(date));
        }
    }
    ,
    HH12("h", "The hour (12-hour clock) as a decimal number (01-12)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            int hour = calendar.get(10);
            sb.append(String.format(Locale.ROOT, "%02d", hour == 0 ? 12 : hour));
        }
    }
    ,
    HH24("H", "The hour (24-hour clock) as a decimal number (00-23)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(11)));
        }
    }
    ,
    IW("w", "The ISO 8601 week number of the year (Monday as the first day of the week) as a decimal number (01-53)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            calendar.setFirstDayOfWeek(2);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(3)));
        }
    }
    ,
    MI("m", "The minute as a decimal number (00-59)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(12)));
        }
    }
    ,
    MM("MM", "The month as a decimal number (01-12)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(2) + 1));
        }
    }
    ,
    MON("MMM", "The abbreviated month name"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date));
        }
    }
    ,
    MONTH("MMMM", "The full month name (English)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date));
        }
    }
    ,
    PM("a", "Meridian indicator without periods"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            String meridian = calendar.get(11) < 12 ? "AM" : "PM";
            sb.append(meridian);
        }
    }
    ,
    Q("", "The quarter as a decimal number (1-4)"){

        @Override
        public void toPattern(StringBuilder sb) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Cannot convert 'Q' FormatElement to Java pattern");
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(2) / 3 + 1));
        }
    }
    ,
    MS("SSS", "The millisecond as a decimal number (000-999)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%03d", calendar.get(14)));
        }
    }
    ,
    SS("s", "The second as a decimal number (00-60)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(13)));
        }
    }
    ,
    TZR("z", "The time zone name"){

        @Override
        public void format(StringBuilder sb, Date date) {
        }
    }
    ,
    WW("w", "The week number of the year (Sunday as the first day of the week) as a decimal number (00-53)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            calendar.setFirstDayOfWeek(1);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(3)));
        }
    }
    ,
    YY("yy", "Last 2 digits of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.yyFormat.format(date));
        }
    }
    ,
    YYYY("yyyy", "The year with century as a decimal number"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(1)));
        }
    };

    private final String description;
    final String javaFmt;

    private FormatElementEnum(String javaFmt, String description) {
        this.javaFmt = Objects.requireNonNull(javaFmt, "javaFmt");
        this.description = Objects.requireNonNull(description, "description");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void toPattern(StringBuilder sb) {
        sb.append(this.javaFmt);
    }

    static class Work {
        private static final ThreadLocal<@Nullable Work> THREAD_WORK = ThreadLocal.withInitial(Work::new);
        final Calendar calendar = Calendar.getInstance(DateTimeUtils.DEFAULT_ZONE, Locale.ROOT);
        final DateFormat eeeeFormat;
        final DateFormat eeeFormat;
        final DateFormat mmmFormat;
        final DateFormat mmmmFormat;
        final DateFormat sFormat;
        final DateFormat ssFormat;
        final DateFormat sssFormat;
        final DateFormat ssssFormat;
        final DateFormat sssssFormat;
        final DateFormat ssssssFormat;
        final DateFormat yyFormat;

        Work() {
            this.eeeeFormat = new SimpleDateFormat(FormatElementEnum.DAY.javaFmt, Locale.US);
            this.eeeFormat = new SimpleDateFormat(FormatElementEnum.DY.javaFmt, Locale.ROOT);
            this.mmmFormat = new SimpleDateFormat(FormatElementEnum.MON.javaFmt, Locale.ROOT);
            this.mmmmFormat = new SimpleDateFormat(FormatElementEnum.MONTH.javaFmt, Locale.ROOT);
            this.sFormat = new SimpleDateFormat(FormatElementEnum.FF1.javaFmt, Locale.ROOT);
            this.ssFormat = new SimpleDateFormat(FormatElementEnum.FF2.javaFmt, Locale.ROOT);
            this.sssFormat = new SimpleDateFormat(FormatElementEnum.FF3.javaFmt, Locale.ROOT);
            this.ssssFormat = new SimpleDateFormat(FormatElementEnum.FF4.javaFmt, Locale.ROOT);
            this.sssssFormat = new SimpleDateFormat(FormatElementEnum.FF5.javaFmt, Locale.ROOT);
            this.ssssssFormat = new SimpleDateFormat(FormatElementEnum.FF6.javaFmt, Locale.ROOT);
            this.yyFormat = new SimpleDateFormat(FormatElementEnum.YY.javaFmt, Locale.ROOT);
        }

        static Work get() {
            return (Work)Nullness.castNonNull((Object)THREAD_WORK.get());
        }
    }
}

