/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.esri.RawRasterStore;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

@StoreMetadata(formatName="BIL/BIP/BSQ", fileSuffixes={"bil", "bip", "bsq"}, capabilities={Capability.READ}, resourceTypes={GridCoverageResource.class})
public final class RawRasterStoreProvider
extends PRJDataStore.Provider {
    static final String NAME = "BIL/BIP/BSQ";
    static final String HDR = "hdr";

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        Path path = storageConnector.getStorageAs(Path.class);
        if (path != null) {
            String string = path.getFileName().toString();
            int n = string.lastIndexOf(46);
            string = (n >= 0 ? string.substring(0, n + 1) : string.concat(".")).concat(HDR);
            if (Files.isRegularFile(path = path.resolveSibling(string), new LinkOption[0])) {
                return ProbeResult.SUPPORTED;
            }
        } else if (storageConnector.getStorageAs(URL.class) != null) {
            return ProbeResult.UNDETERMINED;
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new RawRasterStore(this, storageConnector);
    }
}

