/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LocalInfo;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterUtils;
import org.jf.dexlib2.rewriter.Rewriters;

public class DebugItemRewriter
implements Rewriter<DebugItem> {
    @Nonnull
    protected final Rewriters rewriters;

    public DebugItemRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public DebugItem rewrite(@Nonnull DebugItem value) {
        switch (value.getDebugItemType()) {
            case 3: {
                return new RewrittenStartLocal((StartLocal)value);
            }
            case 5: {
                return new RewrittenEndLocal((EndLocal)value);
            }
            case 6: {
                return new RewrittenRestartLocal((RestartLocal)value);
            }
        }
        return value;
    }

    protected class RewrittenRestartLocal
    extends BaseRewrittenLocalInfoDebugItem<RestartLocal>
    implements RestartLocal {
        public RewrittenRestartLocal(RestartLocal instruction) {
            super(DebugItemRewriter.this, (DebugItem)instruction);
        }

        @Override
        public int getRegister() {
            return ((RestartLocal)this.debugItem).getRegister();
        }
    }

    protected class RewrittenEndLocal
    extends BaseRewrittenLocalInfoDebugItem<EndLocal>
    implements EndLocal {
        public RewrittenEndLocal(EndLocal instruction) {
            super(DebugItemRewriter.this, (DebugItem)instruction);
        }

        @Override
        public int getRegister() {
            return ((EndLocal)this.debugItem).getRegister();
        }
    }

    protected class RewrittenStartLocal
    extends BaseRewrittenLocalInfoDebugItem<StartLocal>
    implements StartLocal {
        public RewrittenStartLocal(StartLocal debugItem) {
            super(DebugItemRewriter.this, (DebugItem)debugItem);
        }

        @Override
        public int getRegister() {
            return ((StartLocal)this.debugItem).getRegister();
        }

        @Override
        @Nullable
        public StringReference getNameReference() {
            return ((StartLocal)this.debugItem).getNameReference();
        }

        @Override
        @Nullable
        public TypeReference getTypeReference() {
            TypeReference typeReference = ((StartLocal)this.debugItem).getTypeReference();
            if (typeReference == null) {
                return null;
            }
            return RewriterUtils.rewriteTypeReference(DebugItemRewriter.this.rewriters.getTypeRewriter(), typeReference);
        }

        @Override
        @Nullable
        public StringReference getSignatureReference() {
            return ((StartLocal)this.debugItem).getSignatureReference();
        }
    }

    protected static class BaseRewrittenLocalInfoDebugItem<T extends DebugItem & LocalInfo>
    implements DebugItem,
    LocalInfo {
        @Nonnull
        protected T debugItem;
        final /* synthetic */ DebugItemRewriter this$0;

        public BaseRewrittenLocalInfoDebugItem(T debugItem) {
            this.this$0 = this$0;
            this.debugItem = debugItem;
        }

        @Override
        public int getDebugItemType() {
            return this.debugItem.getDebugItemType();
        }

        @Override
        public int getCodeAddress() {
            return this.debugItem.getCodeAddress();
        }

        @Override
        @Nullable
        public String getName() {
            return ((LocalInfo)this.debugItem).getName();
        }

        @Override
        @Nullable
        public String getType() {
            return RewriterUtils.rewriteNullable(this.this$0.rewriters.getTypeRewriter(), ((LocalInfo)this.debugItem).getType());
        }

        @Override
        @Nullable
        public String getSignature() {
            return ((LocalInfo)this.debugItem).getSignature();
        }
    }
}

