# Stubs for docutils.utils.math.math2html (Python 3.6)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from gettext import NullTranslations
from typing import Any, Callable, ClassVar, Dict, Iterator, List, Mapping, MutableSequence, Optional, Sequence, TextIO, Tuple, Type, TypeVar, Union

class Trace:
    debugmode: bool = ...
    quietmode: bool = ...
    showlinesmode: bool = ...
    prefix: ClassVar[Optional[str]] = ...
    def debug(cls: Any, message: str) -> None: ...
    def message(cls: Any, message: str) -> None: ...
    def error(cls: Any, message: str) -> None: ...
    def fatal(cls: Any, message: str) -> None: ...
    def show(cls: Any, message: str, channel: TextIO) -> None: ...
    debug: classmethod = ...  # type: ignore  # NOQA: F811
    message: classmethod = ...  # type: ignore  # NOQA: F811
    error: classmethod = ...  # type: ignore  # NOQA: F811
    fatal: classmethod = ...  # type: ignore  # NOQA: F811
    show: classmethod = ...  # type: ignore  # NOQA: F811

class BibStylesConfig:
    abbrvnat: Dict[str, str] = ...
    alpha: Dict[str, str] = ...
    authordate2: Dict[str, str] = ...
    default: Dict[str, str] = ...
    defaulttags: Dict[str, str] = ...
    ieeetr: Dict[str, str] = ...
    plain: Dict[str, str] = ...
    vancouver: Dict[str, str] = ...

class BibTeXConfig:
    replaced: Dict[str, str] = ...

class ContainerConfig:
    endings: Dict[str, str] = ...
    extracttext: Dict[str, str] = ...
    startendings: Dict[str, str] = ...
    starts: Dict[str, str] = ...
    string: Dict[str, str] = ...
    table: Dict[str, List[str]] = ...

class EscapeConfig:
    chars: Dict[str, str] = ...
    commands: Dict[str, str] = ...
    entities: Dict[str, str] = ...
    html: Dict[str, str] = ...
    iso885915: Dict[str, str] = ...
    nonunicode: Dict[str, str] = ...

class FormulaConfig:
    alphacommands: Dict[str, str] = ...
    array: Dict[str, str] = ...
    bigbrackets: Dict[str, List[str]] = ...
    bigsymbols: Dict[str, List[str]] = ...
    bracketcommands: Dict[str, str] = ...
    combiningfunctions: Dict[str, str] = ...
    commands: Dict[str, str] = ...
    decoratedcommand: Dict[Any, Any] = ...
    decoratingfunctions: Dict[str, str] = ...
    endings: Dict[str, str] = ...
    environments: Dict[str, List[str]] = ...
    fontfunctions: Dict[str, str] = ...
    hybridfunctions: Dict[str, List[str]] = ...
    hybridsizes: Dict[str, str] = ...
    labelfunctions: Dict[str, str] = ...
    limitcommands: Dict[str, str] = ...
    misccommands: Dict[str, str] = ...
    modified: Dict[str, str] = ...
    onefunctions: Dict[str, str] = ...
    spacedcommands: Dict[str, str] = ...
    starts: Dict[str, str] = ...
    symbolfunctions: Dict[str, str] = ...
    textfunctions: Dict[str, str] = ...
    unmodified: Dict[str, List[str]] = ...
    urls: Dict[str, str] = ...

class GeneralConfig:
    version: Dict[str, str] = ...

class HeaderConfig:
    parameters: Dict[str, str] = ...
    styles: Dict[str, List[str]] = ...

class ImageConfig:
    converters: Dict[str, str] = ...
    cropboxformats: Dict[str, str] = ...
    formats: Dict[str, Union[str, List[str]]] = ...

class LayoutConfig:
    groupable: Dict[str, List[str]] = ...

class NewfangleConfig:
    constants: Dict[str, str] = ...

class NumberingConfig:
    layouts: Dict[str, List[str]] = ...
    sequence: Dict[str, List[str]] = ...

class StyleConfig:
    hspaces: Dict[str, str] = ...
    quotes: Dict[str, str] = ...
    referenceformats: Dict[str, str] = ...
    size: Dict[str, List[str]] = ...
    vspaces: Dict[str, str] = ...

class TOCConfig:
    extractplain: Dict[str, List[str]] = ...
    extracttitle: Dict[str, List[str]] = ...

class TagConfig:
    barred: Dict[str, str] = ...
    family: Dict[str, str] = ...
    flex: Dict[str, str] = ...
    group: Dict[str, List[str]] = ...
    layouts: Dict[str, str] = ...
    listitems: Dict[str, str] = ...
    notes: Dict[str, str] = ...
    script: Dict[str, str] = ...
    shaped: Dict[str, str] = ...

class TranslationConfig:
    constants: Dict[str, str] = ...
    languages: Dict[str, str] = ...

class CommandLineParser:
    options: Type["Options"] = ...
    def __init__(self, options: Type["Options"]) -> None: ...
    def parseoptions(self, args: Sequence[str]) -> Optional[str]: ...
    def readoption(self, args: Sequence[str]) -> Tuple[str, Union[str, bool, None]]: ...
    def readquoted(self, args: Sequence[str], initial: str) -> Optional[str]: ...
    def readequalskey(self, arg: str, args: MutableSequence[str]) -> str: ...

class Options:
    instance: Any = ...
    location: str = ...
    nocopy: bool = ...
    copyright: bool = ...
    debug: bool = ...
    quiet: bool = ...
    version: bool = ...
    hardversion: bool = ...
    versiondate: bool = ...
    html: bool = ...
    help: bool = ...
    showlines: bool = ...
    str: bool = ...
    iso885915: bool = ...
    css: List[Any] = ...
    favicon: __builtins__.str = ...
    title: Any = ...
    directory: Any = ...
    destdirectory: Any = ...
    toc: bool = ...
    toctarget: __builtins__.str = ...
    tocfor: Any = ...
    forceformat: Any = ...
    lyxformat: bool = ...
    target: Any = ...
    splitpart: Any = ...
    memory: bool = ...
    lowmem: bool = ...
    nobib: bool = ...
    converter: __builtins__.str = ...
    raw: bool = ...
    jsmath: Any = ...
    mathjax: Any = ...
    nofooter: bool = ...
    simplemath: bool = ...
    template: Any = ...
    noconvert: bool = ...
    notoclabels: bool = ...
    letterfoot: bool = ...
    numberfoot: bool = ...
    symbolfoot: bool = ...
    hoverfoot: bool = ...
    marginfoot: bool = ...
    endfoot: bool = ...
    supfoot: bool = ...
    alignfoot: bool = ...
    footnotes: Optional[__builtins__.str] = ...
    imageformat: Optional[__builtins__.str] = ...
    copyimages: bool = ...
    googlecharts: bool = ...
    embedcss: List[Any] = ...
    branches: Dict[__builtins__.str, "BranchOptions"] = ...
    def parseoptions(self, args: MutableSequence[__builtins__.str]) -> None: ...
    def processoptions(self) -> None: ...
    def usage(self) -> None: ...
    def parsefootnotes(self) -> None: ...
    def showoptions(self) -> None: ...
    def showversion(self) -> None: ...
    def showhardversion(self) -> None: ...
    def showversiondate(self) -> None: ...
    def showlyxformat(self) -> None: ...

class BranchOptions:
    name: str = ...
    options: Dict[str, str] = ...
    def __init__(self, name: str) -> None: ...
    def set(self, key: str, value: str) -> None: ...
    def isselected(self) -> bool: ...
    def __unicode__(self) -> str: ...

_Class = TypeVar('_Class')

class Cloner:
    def clone(cls: Any, original: _Class) -> _Class: ...
    def create(cls: Any, type: Type[_Class]) -> _Class: ...
    clone: classmethod = ...  # type: ignore  # NOQA: F811
    create: classmethod = ...  # type: ignore  # NOQA: F811

_Container = TypeVar('_Container', bound="Container")

class ContainerExtractor:
    allowed: List[str] = ...
    cloned: List[str] = ...
    extracted: List[str] = ...
    def __init__(self, config: Mapping[str, MutableSequence[str]]) -> None: ...
    def extract(self, container: "Container") -> List["Container"]: ...
    def process(self, container: "Container", list: MutableSequence["Container"]) -> None: ...
    def safeclone(self, container: _Container) -> _Container: ...

class Parser:
    begin: int = ...
    parameters: Dict[str, Union[Dict[str, str], bool, str]] = ...
    def __init__(self) -> None: ...
    def parseheader(self, reader: "LineReader") -> List[str]: ...
    def parseparameter(self, reader: "LineReader") -> None: ...
    def parsexml(self, reader: "LineReader") -> Tuple[Optional[str], Optional[Dict[str, str]]]: ...
    def parseending(self, reader: "LineReader", process: Callable[..., None]) -> None: ...
    def parsecontainer(self, reader: "LineReader", contents: MutableSequence["Container"]) -> None: ...
    def __unicode__(self) -> str: ...

class LoneCommand(Parser):
    def parse(self, reader: "LineReader") -> List[Any]: ...

class TextParser(Parser):
    stack: List[str] = ...
    ending: str = ...
    endings: List[str] = ...
    def __init__(self, container: "Container") -> None: ...
    def parse(self, reader: "LineReader") -> List["Container"]: ...
    def isending(self, reader: "LineReader") -> bool: ...

class ExcludingParser(Parser):
    def parse(self, reader: "LineReader") -> List["Container"]: ...

class BoundedParser(ExcludingParser):
    def parse(self, reader: "LineReader") -> List["Container"]: ...

class BoundedDummy(Parser):
    def parse(self, reader: "LineReader") -> List["Container"]: ...

class StringParser(Parser):
    begin: int = ...
    def parseheader(self, reader: "LineReader") -> List[Any]: ...
    def parse(self, reader: "LineReader") -> List["Container"]: ...

class InsetParser(BoundedParser):
    def parse(self, reader: "LineReader") -> List["Container"]: ...

class ContainerOutput:
    def gethtml(self, container: "Container") -> Any: ...
    def isempty(self) -> bool: ...

class EmptyOutput(ContainerOutput):
    def gethtml(self, container: "Container") -> List[Any]: ...
    def isempty(self) -> bool: ...

class FixedOutput(ContainerOutput):
    def gethtml(self, container: "Container") -> List[str]: ...

class ContentsOutput(ContainerOutput):
    def gethtml(self, container: "Container") -> List[str]: ...

class TaggedOutput(ContentsOutput):
    tag: Optional[str] = ...
    breaklines: bool = ...
    empty: bool = ...
    def settag(self, tag: str, breaklines: bool = ..., empty: bool = ...) -> "TaggedOutput": ...
    def setbreaklines(self, breaklines: bool) -> "TaggedOutput": ...
    def gethtml(self, container: "Container") -> List[str]: ...
    def open(self, container: "Container") -> str: ...
    def close(self, container: "Container") -> str: ...
    def selfclosing(self, container: "Container") -> str: ...
    def checktag(self) -> bool: ...

class FilteredOutput(ContentsOutput):
    filters: List[Tuple[str, str]] = ...
    def __init__(self) -> None: ...
    def addfilter(self, original: str, replacement: str) -> None: ...
    def gethtml(self, container: "Container") -> List[str]: ...
    def filter(self, line: str) -> str: ...

class StringOutput(ContainerOutput):
    def gethtml(self, container: "Container") -> List[str]: ...

class LineReader:
    file: TextIO = ...
    linenumber: int = ...
    lastline: Optional[int] = ...
    current: Optional[str] = ...
    mustread: bool = ...
    depleted: bool = ...
    def __init__(self, filename: Union[TextIO, str]) -> None: ...
    def setstart(self, firstline: int) -> None: ...
    def setend(self, lastline: Optional[int]) -> None: ...
    def currentline(self) -> Optional[str]: ...
    def nextline(self) -> None: ...
    def readline(self) -> None: ...
    def finished(self) -> bool: ...
    def close(self) -> None: ...

class LineWriter:
    file: bool = ...
    filename: Optional[str] = ...
    def __init__(self, filename: Union[TextIO, str]) -> None: ...
    def write(self, strings: Sequence[str]) -> None: ...
    def writestring(self, string: str) -> None: ...
    def writeline(self, line: str) -> None: ...
    def close(self) -> None: ...

class Globable:
    leavepending: bool = ...
    endinglist: "EndingList" = ...
    def __init__(self) -> None: ...
    def checkbytemark(self) -> None: ...
    def isout(self) -> bool: ...
    def current(self) -> str: ...
    def checkfor(self, string: str) -> bool: ...
    def finished(self) -> bool: ...
    def skipcurrent(self) -> str: ...
    def glob(self, currentcheck: Callable[[], bool]) -> str: ...
    def globalpha(self) -> str: ...
    def globnumber(self) -> str: ...
    def isidentifier(self) -> bool: ...
    def globidentifier(self) -> str: ...
    def isvalue(self) -> bool: ...
    def globvalue(self) -> str: ...
    def skipspace(self) -> str: ...
    def globincluding(self, magicchar: str) -> str: ...
    def globexcluding(self, excluded: str) -> str: ...
    def pushending(self, ending: str, optional: bool = ...) -> None: ...
    def popending(self, expected: Optional[str] = ...) -> Optional[str]: ...
    def nextending(self) -> Optional[str]: ...

class EndingList:
    endings: List["PositionEnding"] = ...
    def __init__(self) -> None: ...
    def add(self, ending: str, optional: bool = ...) -> None: ...
    def pickpending(self, pos: "Position") -> None: ...
    def checkin(self, pos: "Position") -> bool: ...
    def pop(self, pos: "Position") -> str: ...
    def findending(self, pos: "Position") -> Optional[str]: ...
    def checkpending(self) -> None: ...
    def __unicode__(self) -> str: ...

class PositionEnding:
    ending: str = ...
    optional: bool = ...
    def __init__(self, ending: str, optional: bool) -> None: ...
    def checkin(self, pos: "Position") -> bool: ...
    def __unicode__(self) -> str: ...

class Position(Globable):
    def __init__(self) -> None: ...
    def skip(self, string: str) -> None: ...
    def identifier(self) -> str: ...
    def extract(self, length: int) -> Optional[str]: ...
    def checkfor(self, string: str) -> bool: ...
    def checkforlower(self, string: str) -> bool: ...
    def skipcurrent(self) -> str: ...
    def __next__(self) -> str: ...
    def checkskip(self, string: str) -> bool: ...
    def error(self, message: str) -> None: ...

class TextPosition(Position):
    pos: int = ...
    text: str = ...
    def __init__(self, text: str) -> None: ...
    def skip(self, string: str) -> None: ...
    def identifier(self) -> str: ...
    def isout(self) -> bool: ...
    def current(self) -> str: ...
    def extract(self, length: int) -> Optional[str]: ...

class FilePosition(Position):
    reader: LineReader = ...
    pos: int = ...
    def __init__(self, filename: Union[TextIO, str]) -> None: ...
    def skip(self, string: str) -> None: ...
    def currentline(self) -> Optional[str]: ...
    def nextline(self) -> None: ...
    def linenumber(self) -> int: ...
    def identifier(self) -> str: ...
    def isout(self) -> bool: ...
    def current(self) -> str: ...
    def extract(self, length: int) -> str: ...

class Container:
    partkey: Any = ...
    parent: "Container" = ...
    begin: Any = ...
    contents: List[Any] = ...
    def __init__(self) -> None: ...
    def process(self) -> None: ...
    def gethtml(self) -> List[str]: ...
    def escapeall(self, lines: Sequence[str]) -> List[str]: ...
    def escape(self, line: str, replacements: Dict[str, str] = ...) -> str: ...
    def escapeentities(self, line: str) -> str: ...
    def searchall(self, type: Type) -> List["Container"]: ...
    def searchremove(self, type: Type) -> List["Container"]: ...
    def searchprocess(self, type: Type, process: Callable[["Container"], List["Container"]]) -> None: ...
    def locateprocess(self, locate: Callable[["Container"], bool], process: Callable[["Container"], List["Container"]]) -> None: ...
    def recursivesearch(self, locate: Callable[["Container"], bool], recursive: Callable[["Container"], bool], process: Callable[["Container"], None]) -> None: ...
    def extracttext(self) -> str: ...
    def group(self, index: int, group, isingroup: Callable[[Any], bool]) -> None: ...
    def remove(self, index: int) -> None: ...
    def tree(self, level: int = ...) -> None: ...
    def getparameter(self, name: str) -> str: ...
    def getparameterlist(self, name: str) -> List[str]: ...
    def hasemptyoutput(self) -> bool: ...
    def __unicode__(self) -> str: ...

class BlackBox(Container):
    parser: LoneCommand = ...
    output: EmptyOutput = ...
    contents: List[Any] = ...
    def __init__(self) -> None: ...

class LyXFormat(BlackBox):
    def process(self) -> None: ...

class StringContainer(Container):
    parsed: Any = ...
    parser: StringParser = ...
    output: StringOutput = ...
    string: str = ...
    def __init__(self) -> None: ...
    def process(self) -> None: ...
    def replacespecial(self, line: str) -> str: ...
    def changeline(self, line: str) -> str: ...
    def extracttext(self) -> str: ...
    def __unicode__(self) -> str: ...

class Constant(StringContainer):
    contents: List[Any] = ...
    string: str = ...
    output: StringOutput = ...
    def __init__(self, text: str) -> None: ...
    def __unicode__(self) -> str: ...

class TaggedText(Container):
    output: ContentsOutput = ...
    parser: TextParser = ...
    def __init__(self) -> None: ...
    contents: List[Constant] = ...
    def complete(self, contents: List[Constant], tag: str, breaklines: bool = ...) -> TaggedText: ...  # NOQA: F821
    def constant(self, text: str, tag: str, breaklines: bool = ...) -> TaggedText: ...  # NOQA: F821
    def __unicode__(self) -> str: ...

class DocumentParameters:
    pdftitle: Any = ...
    indentstandard: bool = ...
    tocdepth: int = ...
    startinglevel: int = ...
    maxdepth: int = ...
    language: str = ...
    bibliography: Any = ...
    outputchanges: bool = ...
    displaymode: bool = ...

class FormulaParser(Parser):
    begin: int = ...
    def parseheader(self, reader: LineReader) -> List[str]: ...
    def parsetype(self, reader: LineReader) -> Optional[str]: ...
    def parse(self, reader: LineReader) -> str: ...
    def parseformula(self, reader: LineReader) -> str: ...
    def parsesingleliner(self, reader: LineReader, start: str, ending: str) -> str: ...
    def parsemultiliner(self, reader: LineReader, start: str, ending: str) -> str: ...

class MacroParser(FormulaParser):
    begin: int = ...
    def parseheader(self, reader: LineReader) -> List[str]: ...
    def parse(self, reader: LineReader) -> str: ...

class FormulaBit(Container):
    type: str = ...
    size: int = ...
    original: str = ...
    contents: List[Any] = ...
    output: ContentsOutput = ...
    def __init__(self) -> None: ...
    factory: "FormulaFactory" = ...
    def setfactory(self, factory: "FormulaFactory") -> "FormulaBit": ...
    def add(self, bit: "FormulaBit") -> None: ...
    def skiporiginal(self, string: str, pos: Position) -> None: ...
    def computesize(self) -> int: ...
    def clone(self) -> "FormulaBit": ...
    def __unicode__(self) -> str: ...

class TaggedBit(FormulaBit):
    output: TaggedOutput = ...
    def constant(self, constant: str, tag: str) -> "TaggedBit": ...
    contents: List[FormulaBit] = ...
    def complete(self, contents: List[FormulaBit], tag: str, breaklines: bool = ...) -> "TaggedBit": ...
    def selfcomplete(self, tag: str) -> "TaggedBit": ...

class FormulaConstant(Constant):
    original: str = ...
    size: int = ...
    type: str = ...
    def __init__(self, string: str) -> None: ...
    def computesize(self) -> int: ...
    def clone(self) -> "FormulaConstant": ...
    def __unicode__(self) -> str: ...

class RawText(FormulaBit):
    def detect(self, pos: Position) -> bool: ...
    type: str = ...
    def parsebit(self, pos: Position) -> None: ...

class FormulaSymbol(FormulaBit):
    modified: Dict[str, str] = ...
    unmodified: List[str] = ...
    def detect(self, pos: Position) -> bool: ...
    def parsebit(self, pos: Position) -> None: ...
    def addsymbol(self, symbol, pos: Position) -> None: ...

class FormulaNumber(FormulaBit):
    def detect(self, pos: Position) -> bool: ...
    type: str = ...
    def parsebit(self, pos: Position) -> None: ...

class Comment(FormulaBit):
    start: str = ...
    def detect(self, pos: Position) -> bool: ...
    def parsebit(self, pos: Position) -> None: ...

class WhiteSpace(FormulaBit):
    def detect(self, pos: Position) -> bool: ...
    def parsebit(self, pos: Position) -> None: ...
    def __unicode__(self) -> str: ...

class Bracket(FormulaBit):
    start: str = ...
    ending: str = ...
    inner: Any = ...
    def __init__(self) -> None: ...
    def detect(self, pos: Position) -> bool: ...
    def parsebit(self, pos: Position) -> "Bracket": ...
    def parsetext(self, pos: Position) -> "Bracket": ...
    def parseliteral(self, pos: Position) -> "Bracket": ...
    def parsecomplete(self, pos: Position, innerparser: Callable[[Position], None]) -> None: ...
    def innerformula(self, pos: Position) -> None: ...
    def innertext(self, pos: Position) -> None: ...
    literal: str = ...
    def innerliteral(self, pos: Position) -> None: ...

class SquareBracket(Bracket):
    start: str = ...
    ending: str = ...
    def clone(self) -> "SquareBracket": ...

class MathsProcessor:
    def process(self, contents, index) -> None: ...
    def __unicode__(self) -> str: ...

class FormulaProcessor:
    processors: List[MathsProcessor] = ...
    def process(self, bit: FormulaBit) -> None: ...
    def processcontents(self, bit: FormulaBit) -> None: ...
    def processinsides(self, bit: FormulaBit) -> None: ...
    def traversewhole(self, formula: FormulaBit) -> None: ...
    def traverse(self, bit: FormulaBit) -> Iterator[Tuple[FormulaBit, List[FormulaBit]]]: ...
    def italicize(self, bit: FormulaBit, contents) -> None: ...

class Formula(Container):
    parser: FormulaParser = ...
    output: TaggedOutput = ...
    def __init__(self) -> None: ...
    def process(self) -> None: ...
    contents: List[Any] = ...
    def jsmath(self) -> None: ...
    def mathjax(self) -> None: ...
    def googlecharts(self) -> None: ...
    def classic(self) -> None: ...
    def parse(self, pos: Position) -> "Formula": ...
    header: List[str] = ...
    def parsedollarinline(self, pos: Position) -> None: ...
    def parsedollarblock(self, pos: Position) -> None: ...
    parsed: str = ...
    def parsedollar(self, pos: Position) -> None: ...
    def parseinlineto(self, pos: Position, limit: str) -> None: ...
    def parseblockto(self, pos: Position, limit: str) -> None: ...
    def parseupto(self, pos: Position, limit: str) -> None: ...
    def __unicode__(self) -> str: ...

class WholeFormula(FormulaBit):
    def detect(self, pos: Position) -> bool: ...
    def parsebit(self, pos: Position) -> None: ...

_FB = TypeVar('_FB', bound=FormulaBit)

class FormulaFactory:
    types: List[Type[FormulaBit]] = ...
    skippedtypes: List[Type[FormulaBit]] = ...
    defining: bool = ...
    instances: Dict[Type[FormulaBit], FormulaBit] = ...
    def __init__(self) -> None: ...
    def detecttype(self, type: Type[_FB], pos: Position) -> _FB: ...
    def instance(self, type: Type[_FB]) -> _FB: ...
    def create(self, type: Type[_FB]) -> _FB: ...
    def clearskipped(self, pos: Position) -> None: ...
    def skipany(self, pos: Position) -> Optional[FormulaBit]: ...
    def parseany(self, pos: Position) -> FormulaConstant: ...
    def parsetype(self, type: Type[_FB], pos: Position) -> _FB: ...
    def parseformula(self, formula: str) -> WholeFormula: ...

class Translator:
    instance: "Translator" = ...
    def translate(cls: Any, key: str) -> str: ...
    translate: classmethod = ...  # type: ignore  # NOQA: F811
    translation: NullTranslations = ...
    first: bool = ...
    def __init__(self) -> None: ...
    langcodes: List[str] = ...
    def findtranslation(self) -> None: ...
    def getmessage(self, key: str) -> str: ...
    def getuntranslated(self, key: str) -> str: ...

class NumberCounter:
    name: str = ...
    value: int = ...
    mode: str = ...
    master: "NumberCounter" = ...
    letters: str = ...
    symbols: List[str] = ...
    romannumerals: List[Tuple[str, int]] = ...
    def __init__(self, name: str) -> None: ...
    def setmode(self, mode: str) -> "NumberCounter": ...
    def init(self, value: int) -> None: ...
    def gettext(self) -> str: ...
    def getletter(self) -> str: ...
    def getsymbol(self) -> str: ...
    def getsequence(self, sequence: Union[str, MutableSequence[str]]) -> str: ...
    def getroman(self) -> str: ...
    def getvalue(self) -> str: ...
    def getnext(self) -> int: ...
    def reset(self) -> None: ...
    def __unicode__(self) -> str: ...

class DependentCounter(NumberCounter):
    master: NumberCounter = ...
    last: str = ...
    def setmaster(self, master: NumberCounter) -> "DependentCounter": ...
    def getnext(self) -> int: ...
    def getvalue(self) -> str: ...

class NumberGenerator:
    chaptered: "ChapteredGenerator" = ...
    generator: "NumberGenerator" = ...
    romanlayouts: List[str] = ...
    orderedlayouts: List[str] = ...
    counters: Dict[str, NumberCounter] = ...
    appendix: Optional[bool] = ...
    def deasterisk(self, type: str) -> str: ...
    def isunique(self, type: str) -> bool: ...
    def isroman(self, type: str) -> bool: ...
    def isinordered(self, type: str) -> bool: ...
    def isnumbered(self, type: str) -> bool: ...
    def isunordered(self, type: str) -> bool: ...
    def getlevel(self, type: str) -> int: ...
    def getparttype(self, type: str) -> str: ...
    def generate(self, type: str) -> int: ...
    def getcounter(self, type: str) -> NumberCounter: ...
    def create(self, type: str) -> NumberCounter: ...
    def getdependentcounter(self, type: str, master: NumberCounter) -> NumberCounter: ...
    def createdependent(self, type: str, master: NumberCounter) -> DependentCounter: ...
    def startappendix(self) -> None: ...

class ChapteredGenerator(NumberGenerator):
    def generate(self, type: str) -> int: ...

class ContainerSize:
    width: Optional[str] = ...
    height: Optional[str] = ...
    maxwidth: Optional[str] = ...
    maxheight: Optional[str] = ...
    scale: Any = ...
    def set(self, width: Optional[str] = ..., height: Optional[str] = ...) -> "ContainerSize": ...
    def setmax(self, maxwidth: Optional[str] = ..., maxheight: Optional[str] = ...) -> "ContainerSize": ...
    def readparameters(self, container: Container) -> "ContainerSize": ...
    def setparameter(self, container: Container, name: str) -> None: ...
    def setvalue(self, name: str, value: str) -> None: ...
    def checkvalidheight(self, container: Container) -> None: ...
    def processparameter(self, value: str) -> Optional[str]: ...
    def extractnumber(self, text: str) -> str: ...
    def checkimage(self, width: int, height: int) -> None: ...
    def scalevalue(self, value: int) -> str: ...
    def removepercentwidth(self) -> Optional[str]: ...
    def addstyle(self, container: Container) -> None: ...
    def styleparameter(self, name: str) -> str: ...

class QuoteContainer(Container):
    parser: BoundedParser = ...
    output: FixedOutput = ...
    def __init__(self) -> None: ...
    type: str = ...
    html: List[str] = ...
    def process(self) -> None: ...

class LyXLine(Container):
    parser: LoneCommand = ...
    output: FixedOutput = ...
    def __init__(self) -> None: ...
    html: List[str] = ...
    def process(self) -> None: ...

class EmphaticText(TaggedText):
    def process(self) -> None: ...

class ShapedText(TaggedText):
    type: str = ...
    def process(self) -> None: ...

class VersalitasText(TaggedText):
    def process(self) -> None: ...

class ColorText(TaggedText):
    color: str = ...
    def process(self) -> None: ...

class SizeText(TaggedText):
    size: str = ...
    def process(self) -> None: ...

class BoldText(TaggedText):
    def process(self) -> None: ...

class TextFamily(TaggedText):
    type: str = ...
    def process(self) -> None: ...

class Hfill(TaggedText):
    def process(self) -> None: ...

class BarredText(TaggedText):
    type: str = ...
    def process(self) -> None: ...

class LangLine(TaggedText):
    output: ContentsOutput = ...
    def process(self) -> None: ...

class InsetLength(BlackBox):
    length: str = ...
    def process(self) -> None: ...

class Space(Container):
    parser: InsetParser = ...
    output: FixedOutput = ...
    def __init__(self) -> None: ...
    type: str = ...
    html: List[str] = ...
    def process(self) -> None: ...
    def getlength(self) -> Optional[str]: ...

class VerticalSpace(Container):
    parser: InsetParser = ...
    output: FixedOutput = ...
    def __init__(self) -> None: ...
    type: str = ...
    html: List[str] = ...
    def process(self) -> None: ...

class Align(Container):
    parser: ExcludingParser = ...
    output: TaggedOutput = ...
    def __init__(self) -> None: ...
    def process(self) -> None: ...

class Newline(Container):
    parser: LoneCommand = ...
    output: FixedOutput = ...
    def __init__(self) -> None: ...
    html: List[str] = ...
    def process(self) -> None: ...

class NewPage(Newline):
    html: List[str] = ...
    def process(self) -> None: ...

class Separator(Container):
    output: FixedOutput = ...
    contents: List[Any] = ...
    html: List[str] = ...
    def __init__(self, constant: str) -> None: ...

class StrikeOut(TaggedText):
    def process(self) -> None: ...

class StartAppendix(BlackBox):
    def process(self) -> None: ...

class Link(Container):
    anchor: str = ...
    url: str = ...
    type: str = ...
    page: str = ...
    target: str = ...
    destination: "Link" = ...
    title: str = ...
    contents: List[Constant] = ...
    parser: InsetParser = ...
    output: "LinkOutput" = ...
    def __init__(self) -> None: ...
    def complete(self, text: str, anchor: Optional[str] = ..., url: Optional[str] = ..., type: Optional[str] = ..., title: Optional[str] = ...) -> "Link": ...
    def computedestination(self) -> None: ...
    def setmutualdestination(self, destination: "Link") -> None: ...
    def __unicode__(self) -> str: ...

class URL(Link):
    url: str = ...
    contents: List[Constant] = ...
    def process(self) -> None: ...

class FlexURL(URL):
    url: str = ...
    def process(self) -> None: ...

class LinkOutput(ContainerOutput):
    def gethtml(self, link: Link) -> List[str]: ...  # type: ignore

class Postprocessor:
    stages: "StageDict" = ...
    current: Container = ...
    last: Container = ...
    def __init__(self) -> None: ...
    def postprocess(self, next: Optional[List[Any]]) -> Any: ...
    def postrecursive(self, container: Container) -> None: ...
    def postcurrent(self, next: Optional[List[Any]]) -> Any: ...

class StageDict:
    stagedict: Dict[Any, Any] = ...
    def __init__(self, classes: Sequence[Type], postprocessor: Postprocessor) -> None: ...
    def instantiate(self, classes: Sequence[Type], postprocessor: Postprocessor) -> List[Any]: ...
    def getstage(self, element: Any) -> Optional[Any]: ...

class Label(Link):
    names: ClassVar[Dict[str, "Label"]] = ...
    lastlayout: Any = ...
    lastnumbered: Any = ...
    def __init__(self) -> None: ...
    def process(self) -> None: ...
    key: str = ...
    def create(self, text: str, key: str, type: str = ...) -> "Label": ...
    def findpartkey(self) -> str: ...
    def numbered(self, container: Container) -> Optional[Container]: ...
    def __unicode__(self) -> str: ...

class Reference(Link):
    references: ClassVar[Dict[str, MutableSequence["Reference"]]] = ...
    key: str = ...
    direction: str = ...
    destination: Label = ...
    def process(self) -> None: ...
    formatted: str = ...
    contents: List[Constant] = ...
    def formatcontents(self) -> None: ...
    def replace(self, key: str, value: str) -> None: ...
    def __unicode__(self) -> str: ...

_CB = TypeVar('_CB', bound="CommandBit")

class FormulaCommand(FormulaBit):
    types: List[Type] = ...
    start: str = ...
    commandmap: Optional[Mapping] = ...
    def detect(self, pos: Position) -> bool: ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> Optional[_CB]: ...
    def parsewithcommand(self, command: str, pos: Position) -> Optional[_CB]: ...
    def parsecommandtype(self, command: str, type: _CB, pos: Position) -> _CB: ...
    def extractcommand(self, pos: Position) -> Optional[str]: ...
    def emptycommand(self, pos: Position) -> str: ...
    def parseupgreek(self, command: str, pos: Position) -> Optional[_CB]: ...

class CommandBit(FormulaCommand):
    command: Any = ...
    translated: Any = ...
    def setcommand(self, command) -> None: ...
    def parseparameter(self, pos: Position) -> FormulaConstant: ...
    def parsesquare(self, pos: Position) -> Optional[_FB]: ...
    def parseliteral(self, pos: Position) -> str: ...
    def parsesquareliteral(self, pos: Position) -> str: ...
    def parsetext(self, pos: Position) -> Bracket: ...

class EmptyCommand(CommandBit):
    commandmap: Dict[str, str] = ...
    contents: List[FormulaConstant] = ...
    def parsebit(self, pos: Position) -> None: ...

class SpacedCommand(CommandBit):
    commandmap: Dict[str, str] = ...
    contents: List[FormulaConstant] = ...
    def parsebit(self, pos: Position) -> None: ...

class AlphaCommand(EmptyCommand):
    commandmap: Dict[str, str] = ...
    type: str = ...
    def parsebit(self, pos: Position) -> None: ...

class OneParamFunction(CommandBit):
    commandmap: Dict[str, str] = ...
    simplified: bool = ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...
    html: List[str] = ...
    def simplifyifpossible(self) -> None: ...

class SymbolFunction(CommandBit):
    commandmap: Dict[str, str] = ...
    def detect(self, pos: Position) -> bool: ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...

class TextFunction(CommandBit):
    commandmap: Dict[str, str] = ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...
    type: str = ...
    def process(self) -> None: ...

class LabelFunction(CommandBit):
    commandmap: Dict[str, str] = ...
    key: Any = ...
    def parsebit(self, pos: Position) -> None: ...
    type: str = ...
    label: Label = ...
    contents: List[Label] = ...
    def process(self) -> None: ...

class FontFunction(OneParamFunction):
    commandmap: Dict[str, str] = ...
    type: str = ...
    def process(self) -> None: ...

class BigSymbol:
    symbols: Dict[str, List[str]] = ...
    symbol: str = ...
    def __init__(self, symbol: str) -> None: ...
    def getpieces(self) -> List[str]: ...
    def smalllimit(self) -> bool: ...

class BigBracket(BigSymbol):
    size: int = ...
    original: str = ...
    alignment: str = ...
    pieces: Optional[List[str]] = ...
    def __init__(self, size: int, bracket: str, alignment: str = ...) -> None: ...
    def getpiece(self, index: int) -> str: ...
    def getpiece1(self, index: int) -> str: ...
    def getpiece3(self, index: int) -> str: ...
    def getpiece4(self, index: int) -> str: ...
    def getcell(self, index: int) -> TaggedBit: ...
    def getcontents(self) -> List[TaggedBit]: ...
    def getsinglebracket(self) -> List[TaggedBit]: ...

class FormulaEquation(CommandBit):
    piece: str = ...
    output: ContentsOutput = ...  # type: ignore
    def parsebit(self, pos: Position) -> None: ...

class FormulaCell(FormulaCommand):
    alignment: str = ...
    output: TaggedOutput = ...
    def setalignment(self, alignment: str) -> "FormulaCell": ...
    def parsebit(self, pos: Position) -> None: ...

class FormulaRow(FormulaCommand):
    cellseparator: str = ...
    alignments: str = ...
    output: TaggedOutput = ...
    def setalignments(self, alignments: str) -> "FormulaRow": ...
    def parsebit(self, pos: Position) -> None: ...
    def createcell(self, index) -> FormulaCell: ...

class MultiRowFormula(CommandBit):
    rows: List = ...
    size: int = ...
    def parserows(self, pos: Position) -> None: ...
    def iteraterows(self, pos: Position) -> Iterator[FormulaRow]: ...
    def addempty(self) -> None: ...
    def addrow(self, row: FormulaRow) -> None: ...

class FormulaArray(MultiRowFormula):
    piece: str = ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...
    valign: str = ...
    alignments: List[str] = ...
    def parsealignments(self, pos: Position) -> None: ...

class FormulaMatrix(MultiRowFormula):
    piece: str = ...
    output: TaggedOutput = ...
    valign: str = ...
    alignments: List[str] = ...
    def parsebit(self, pos: Position) -> None: ...

class FormulaCases(MultiRowFormula):
    piece: str = ...
    output: ContentsOutput = ...  # type: ignore
    alignments: List[str] = ...
    contents: List[TaggedBit] = ...
    def parsebit(self, pos: Position) -> None: ...

class EquationEnvironment(MultiRowFormula):
    output: TaggedOutput = ...
    alignments: List[str] = ...
    def parsebit(self, pos: Position) -> None: ...

class BeginCommand(CommandBit):
    commandmap: Dict[str, str] = ...
    types: List[Type] = ...
    size: int = ...
    def parsebit(self, pos: Position) -> None: ...
    def findbit(self, piece: str) -> EquationEnvironment: ...

class CombiningFunction(OneParamFunction):
    commandmap: Dict[str, str] = ...
    type: str = ...
    def parsebit(self, pos: Position) -> None: ...
    def parsesingleparameter(self, pos: Position) -> FormulaConstant: ...

class DecoratingFunction(OneParamFunction):
    commandmap: Dict[str, str] = ...
    type: str = ...
    symbol: TaggedBit = ...
    parameter: FormulaConstant = ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...

class LimitCommand(EmptyCommand):
    commandmap: Dict[str, str] = ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...

class LimitPreviousCommand(LimitCommand):
    commandmap: Any = ...
    output: TaggedOutput = ...
    def parsebit(self, pos: Position) -> None: ...
    def __unicode__(self) -> str: ...

class LimitsProcessor(MathsProcessor):
    def process(self, contents: List[Any], index: int) -> None: ...
    def checklimits(self, contents: List[Any], index: int) -> bool: ...
    def limitsahead(self, contents: List[Any], index: int) -> None: ...
    def modifylimits(self, contents: List[Any], index: int) -> None: ...
    def getlimit(self, contents: List[Any], index: int) -> Any: ...
    def modifyscripts(self, contents: List[Any], index: int) -> None: ...
    def checkscript(self, contents: List[Any], index: int) -> bool: ...
    def checkcommand(self, contents: List[Any], index: int, type: Type) -> bool: ...
    def getscript(self, contents: List[Any], index: int) -> Any: ...

class BracketCommand(OneParamFunction):
    commandmap: Dict[str, str] = ...
    def parsebit(self, pos: Position) -> None: ...
    original: str = ...
    command: str = ...
    contents: List[FormulaConstant] = ...
    def create(self, direction: str, character: str) -> "BracketCommand": ...

class BracketProcessor(MathsProcessor):
    def process(self, contents: List[Any], index: int) -> None: ...
    def processleft(self, contents: List[Any], index: int) -> None: ...
    def checkleft(self, contents: List[Any], index: int) -> bool: ...
    def checkright(self, contents: List[Any], index: int) -> bool: ...
    def checkdirection(self, bit: BracketCommand, command: str) -> bool: ...
    def findright(self, contents: List[Any], index: int) -> Optional[int]: ...
    def findmax(self, contents: List[Any], leftindex: int, rightindex: int) -> int: ...
    def resize(self, command: BracketCommand, size: int) -> None: ...

class TodayCommand(EmptyCommand):
    commandmap: Any = ...
    output: FixedOutput = ...  # type: ignore
    html: List[str] = ...
    def parsebit(self, pos: Position) -> None: ...

class ParameterDefinition:
    parambrackets: List[Tuple[str, str]] = ...
    name: Optional[str] = ...
    literal: bool = ...
    optional: bool = ...
    value: Any = ...
    literalvalue: Any = ...
    def __init__(self) -> None: ...
    def parse(self, pos: Position) -> Optional["ParameterDefinition"]: ...
    def read(self, pos: Position, function: CommandBit) -> None: ...
    def __unicode__(self) -> str: ...

class ParameterFunction(CommandBit):
    params: Dict[str, "ParameterFunction"] = ...
    def readparams(self, readtemplate: str, pos: Position) -> None: ...
    def paramdefs(self, readtemplate: str) -> Iterator[ParameterDefinition]: ...
    def getparam(self, name: str) -> ParameterDefinition: ...
    def getvalue(self, name: str) -> ParameterDefinition: ...
    def getliteralvalue(self, name: str) -> Any: ...

class HybridFunction(ParameterFunction):
    commandmap: Dict[str, List[str]] = ...
    contents: Any = ...
    def parsebit(self, pos: Position) -> None: ...
    def writeparams(self, writetemplate) -> List[Any]: ...
    def writepos(self, pos: Position) -> List[Any]: ...
    def writeparam(self, pos: Position) -> Any: ...
    def writefunction(self, pos: Position) -> Optional[TaggedBit]: ...
    def readtag(self, pos: Position) -> Optional[str]: ...
    def writebracket(self, direction: str, character: str) -> BracketCommand: ...
    size: int = ...
    def computehybridsize(self) -> None: ...

class HybridSize:
    configsizes: Dict[str, str] = ...
    def getsize(self, function: ParameterFunction) -> int: ...

class HeaderParser(Parser):
    def parse(self, reader: LineReader) -> List[Any]: ...
    def parseline(self, reader: LineReader, contents: List[Any]) -> None: ...
    def parsebranch(self, reader: LineReader) -> None: ...
    ending: str = ...
    def complete(self, ending: str) -> "HeaderParser": ...

class PreambleParser(Parser):
    preamble: ClassVar[List[str]] = ...
    ending: str = ...
    def parse(self, reader: LineReader) -> List: ...
    def parsepreambleline(self, reader: LineReader) -> None: ...

class LstParser:
    globalparams: Dict[str, str] = ...
    def parselstset(self, reader: LineReader) -> None: ...
    def extractlstset(self, reader: LineReader) -> Optional[str]: ...
    def parsecontainer(self, container: Container) -> None: ...
    def parselstparams(self, paramlist: Sequence[str]) -> Dict[str, str]: ...

class MacroDefinition(CommandBit):
    macros: Dict[str, "MacroDefinition"] = ...
    output: EmptyOutput = ...  # type: ignore
    parameternumber: int = ...
    defaults: List[Any] = ...
    def parsebit(self, pos: Position) -> None: ...
    newcommand: str = ...
    definition: FormulaConstant = ...
    def parseparameters(self, pos: Position) -> None: ...
    def parsenewcommand(self, pos: Position) -> Union[str]: ...
    def instantiate(self) -> FormulaConstant: ...

class MacroParameter(FormulaBit):
    def detect(self, pos: Position) -> bool: ...
    number: int = ...
    original: str = ...
    contents: List[TaggedBit] = ...
    def parsebit(self, pos: Position) -> None: ...

class MacroFunction(CommandBit):
    commandmap: Any = ...
    output: FilteredOutput = ...  # type: ignore
    values: List[Any] = ...
    def parsebit(self, pos: Position) -> None: ...
    def parseparameters(self, pos: Position, macro: MacroDefinition) -> None: ...
    def parseoptional(self, pos: Position, defaults: List[Any]) -> None: ...
    def parsemandatory(self, pos: Position, number: int) -> None: ...
    def parsemacroparameter(self, pos: Position, remaining: int) -> Optional[Union[FormulaNumber, FormulaConstant]]: ...
    def parsenumbers(self, pos: Position, remaining: int) -> Optional[FormulaNumber]: ...
    contents: List[FormulaConstant] = ...
    def completemacro(self, macro: MacroDefinition) -> None: ...
    def addfilter(self, index: int, value: str) -> None: ...

class FormulaMacro(Formula):
    parser: MacroParser = ...
    output: EmptyOutput = ...  # type: ignore
    def __init__(self) -> None: ...
    def __unicode__(self) -> str: ...

def math2html(formula: str) -> str: ...
def main() -> None: ...
