/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import java.awt.Component;
import java.awt.Font;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.tool.MVSenderIconCache;
import org.apache.commons.lang3.SystemUtils;

public class CellRendererBase
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 4187677730323830219L;
    private final MVSenderIconCache senderIconCache;

    public CellRendererBase(MVSenderIconCache cache) {
        this.senderIconCache = cache;
    }

    protected void setSenderIcon(String sender, boolean small) {
        this.setHorizontalAlignment(0);
        Optional<ImageIcon> optIcon = this.senderIconCache.get(sender, small);
        optIcon.ifPresent(icon -> {
            this.setText("");
            this.setIcon((Icon)icon);
        });
    }

    protected void setSelectionFont(Component c, boolean isSelected) {
        if (!SystemUtils.IS_OS_MAC_OSX) {
            Font font = isSelected ? c.getFont().deriveFont(1) : c.getFont().deriveFont(0);
            c.setFont(font);
        }
    }
}

