/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Image;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import mediathek.config.Daten;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MVHttpClient;
import net.engio.mbassy.listener.Handler;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MVSenderIconCache {
    public static final String CONFIG_USE_LOCAL_SENDER_ICONS = "application.sender_icons.use_local";
    private static final int ICON_SIZE_LARGE = 32;
    private static final int ICON_SIZE_SMALL = 16;
    private static final Logger logger = LogManager.getLogger(MVSenderIconCache.class);
    private final AtomicBoolean useLocalIcons = new AtomicBoolean(false);
    private final LoadingCache<String, Optional<ImageIcon>> senderCache_small = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build(new IconCacheLoader(16));
    private final LoadingCache<String, Optional<ImageIcon>> senderCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build(new IconCacheLoader(32));

    public MVSenderIconCache(Daten d) {
        this.setupCleanupScheduler();
        d.getMessageBus().subscribe(this);
        this.useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
    }

    @Handler
    private void handleSenderIconStyleChangedEvent(SenderIconStyleChangedEvent e) {
        logger.trace("invalidating caches due to sender icon style change");
        this.useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
        this.senderCache_small.invalidateAll();
        this.senderCache.invalidateAll();
    }

    private void setupCleanupScheduler() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(() -> {
            this.senderCache.cleanUp();
            this.senderCache_small.cleanUp();
        }, 2L, 2L, TimeUnit.MINUTES);
    }

    public Optional<ImageIcon> get(String sender, boolean small) {
        Optional<ImageIcon> icon;
        try {
            icon = small ? this.senderCache_small.get(sender) : this.senderCache.get(sender);
        }
        catch (CacheLoader.InvalidCacheLoadException | ExecutionException ex) {
            icon = Optional.empty();
        }
        return icon;
    }

    class IconCacheLoader
    extends CacheLoader<String, Optional<ImageIcon>> {
        private static final String WIKI_BASE_URL = "https://upload.wikimedia.org/wikipedia/commons/thumb";
        private final int height;

        public IconCacheLoader(int height) {
            this.height = height;
        }

        private ImageIcon scaleImage(String source2, int maxHeight) {
            Image image = new ImageIcon(MVSenderIconCache.class.getResource(source2)).getImage();
            ImageIcon sizeImage = new ImageIcon(image);
            int priorHeight = sizeImage.getIconHeight();
            int priorWidth = sizeImage.getIconWidth();
            int newWidth = (int)((float)priorWidth / (float)priorHeight * (float)maxHeight);
            return new ImageIcon(image.getScaledInstance(newWidth, maxHeight, 16));
        }

        private ImageIcon scaleImage(ImageIcon icon, int maxHeight) {
            float priorHeight = icon.getIconHeight();
            float priorWidth = icon.getIconWidth();
            int newWidth = Math.round(priorWidth / priorHeight * (float)maxHeight);
            Image scaledImage = icon.getImage().getScaledInstance(newWidth, maxHeight, 16);
            return new ImageIcon(scaledImage);
        }

        private ImageIcon getIcon(@NotNull String networkResource, @NotNull String localResource) {
            ImageIcon icon = null;
            if (!MVSenderIconCache.this.useLocalIcons.get()) {
                Request request = new Request.Builder().url(networkResource).get().build();
                try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();
                     ResponseBody body = response.body();){
                    icon = response.isSuccessful() && body != null ? this.scaleImage(new ImageIcon(body.bytes()), this.height) : null;
                }
                catch (Exception ex) {
                    icon = null;
                }
            }
            if (icon == null || icon.getIconWidth() < 0 || icon.getIconHeight() < 0) {
                icon = this.scaleImage(localResource, this.height);
            }
            return icon;
        }

        @Override
        public Optional<ImageIcon> load(@NotNull String sender) {
            ImageIcon icon;
            switch (sender) {
                case "3Sat": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/f/f2/3sat-Logo.svg/775px-3sat-Logo.svg.png", "/mediathek/res/sender/3sat.png");
                    break;
                }
                case "ARD": 
                case "ARD.Podcast": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/68/ARD_logo.svg/320px-ARD_logo.svg.png", "/mediathek/res/sender/ard.png");
                    break;
                }
                case "ARTE.DE": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Arte_Logo_2011.svg/320px-Arte_Logo_2011.svg.png", "/mediathek/res/sender/arte-de.png");
                    break;
                }
                case "ARTE.FR": {
                    icon = this.scaleImage("/mediathek/res/sender/arte-fr.png", this.height);
                    break;
                }
                case "BR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/BR_Dachmarke.svg/320px-BR_Dachmarke.svg.png", "/mediathek/res/sender/br.png");
                    break;
                }
                case "HR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/63/HR_Logo.svg/519px-HR_Logo.svg.png", "/mediathek/res/sender/hr.png");
                    break;
                }
                case "KiKA": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/f/f5/Kika_2012.svg/320px-Kika_2012.svg.png", "/mediathek/res/sender/kika.png");
                    break;
                }
                case "MDR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/61/MDR_Logo_2017.svg/800px-MDR_Logo_2017.svg.png", "/mediathek/res/sender/mdr.png");
                    break;
                }
                case "DW": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/Deutsche_Welle_Logo.svg/743px-Deutsche_Welle_Logo.svg.png", "/mediathek/res/sender/dw.png");
                    break;
                }
                case "NDR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/0/08/NDR_Dachmarke.svg/308px-NDR_Dachmarke.svg.png", "/mediathek/res/sender/ndr.png");
                    break;
                }
                case "ORF": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/d/dd/ORF_logo.svg/709px-ORF_logo.svg.png", "/mediathek/res/sender/orf.png");
                    break;
                }
                case "RBB": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/7/79/Rbb_Logo_2017.08.svg/320px-Rbb_Logo_2017.08.svg.png", "/mediathek/res/sender/rbb.png");
                    break;
                }
                case "SR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/8/83/SR_Dachmarke.svg/602px-SR_Dachmarke.svg.png", "/mediathek/res/sender/sr.png");
                    break;
                }
                case "SRF": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/8/84/Schweizer_Radio_und_Fernsehen_Logo.svg/559px-Schweizer_Radio_und_Fernsehen_Logo.svg.png", "/mediathek/res/sender/srf.png");
                    break;
                }
                case "SRF.Podcast": {
                    icon = this.scaleImage("/mediathek/res/sender/srf-podcast.png", this.height);
                    break;
                }
                case "SWR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/SWR_Dachmarke.svg/320px-SWR_Dachmarke.svg.png", "/mediathek/res/sender/swr.png");
                    break;
                }
                case "WDR": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/9/9b/WDR_Dachmarke.svg/320px-WDR_Dachmarke.svg.png", "/mediathek/res/sender/wdr.png");
                    break;
                }
                case "ZDF": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/c/c1/ZDF_logo.svg/320px-ZDF_logo.svg.png", "/mediathek/res/sender/zdf.png");
                    break;
                }
                case "ZDF-tivi": {
                    icon = this.scaleImage("/mediathek/res/sender/zdf-tivi.png", this.height);
                    break;
                }
                case "PHOENIX": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/d/de/Phoenix_Logo_2018_ohne_Claim.svg/640px-Phoenix_Logo_2018_ohne_Claim.svg.png", "/mediathek/res/sender/phoenix.png");
                    break;
                }
                case "Funk.net": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/9/99/Funk_Logo.svg/454px-Funk_Logo.svg.png", "/mediathek/res/sender/funk_net.png");
                    break;
                }
                case "Radio Bremen TV": {
                    icon = this.getIcon("https://upload.wikimedia.org/wikipedia/commons/thumb/7/73/Logo_Radio_Bremen_TV.svg/320px-Logo_Radio_Bremen_TV.svg.png", "/mediathek/res/sender/rbtv.jpg");
                    break;
                }
                default: {
                    icon = null;
                }
            }
            Optional<Object> optIcon = icon == null ? Optional.empty() : Optional.of(icon);
            return optIcon;
        }
    }
}

