/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Locale;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

@DefaultProperty(value="children")
public class BarChartItem
extends Region
implements Comparable<BarChartItem> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 30.0;
    private static final double MINIMUM_WIDTH = 25.0;
    private static final double MINIMUM_HEIGHT = 3.6;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 0.12;
    private double width;
    private double height;
    private double size;
    private double parentWidth;
    private double parentHeight;
    private Text nameText;
    private Text valueText;
    private Rectangle barBackground;
    private Rectangle bar;
    private Pane pane;
    private ObjectProperty<Color> nameColor = new ObjectPropertyBase<Color>(Tile.FOREGROUND){

        @Override
        protected void invalidated() {
            BarChartItem.this.nameText.setFill((Paint)this.get());
        }

        @Override
        public Object getBean() {
            return BarChartItem.this;
        }

        @Override
        public String getName() {
            return "nameColor";
        }
    };
    private ObjectProperty<Color> valueColor = new ObjectPropertyBase<Color>(Tile.FOREGROUND){

        @Override
        protected void invalidated() {
            BarChartItem.this.valueText.setFill((Paint)this.get());
        }

        @Override
        public Object getBean() {
            return BarChartItem.this;
        }

        @Override
        public String getName() {
            return "valueColor";
        }
    };
    private ObjectProperty<Color> barBackgroundColor = new ObjectPropertyBase<Color>(Color.rgb(72, 72, 72)){

        @Override
        protected void invalidated() {
            BarChartItem.this.barBackground.setFill((Paint)this.get());
        }

        @Override
        public Object getBean() {
            return BarChartItem.this;
        }

        @Override
        public String getName() {
            return "barBackgroundColor";
        }
    };
    private String formatString = "%.0f";
    private Locale locale = Locale.US;
    private double maxValue = 100.0;
    private double stepSize;
    private ChartData chartData;

    public BarChartItem() {
        this("", 0.0, Tile.BLUE);
    }

    public BarChartItem(String NAME) {
        this(NAME, 0.0, Tile.BLUE);
    }

    public BarChartItem(String NAME, double VALUE) {
        this(NAME, VALUE, Tile.BLUE);
    }

    public BarChartItem(String NAME, double VALUE, Color COLOR) {
        this.chartData = new ChartData(NAME, VALUE, COLOR);
        this.stepSize = 212.5 / this.maxValue;
        this.parentWidth = 250.0;
        this.parentHeight = 250.0;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 30.0);
            }
        }
        this.nameText = new Text(this.getName());
        this.nameText.setTextOrigin(VPos.TOP);
        this.valueText = new Text(String.format(this.locale, this.formatString, this.getValue()));
        this.valueText.setTextOrigin(VPos.TOP);
        this.barBackground = new Rectangle();
        this.bar = new Rectangle();
        this.pane = new Pane(this.nameText, this.valueText, this.barBackground, this.bar);
        this.pane.setBackground(new Background(new BackgroundFill(Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)));
        this.getChildren().setAll((Node[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    @Override
    protected double computeMinWidth(double HEIGHT) {
        return 25.0;
    }

    @Override
    protected double computeMinHeight(double WIDTH) {
        return 3.6;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    @Override
    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    @Override
    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    @Override
    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getName() {
        return this.chartData.getName();
    }

    public void setName(String NAME) {
        this.chartData.setName(NAME);
        this.nameText.setText(NAME);
    }

    public double getValue() {
        return this.chartData.getValue();
    }

    public void setValue(double VALUE) {
        this.chartData.setValue(VALUE);
    }

    public Color getNameColor() {
        return (Color)this.nameColor.get();
    }

    public void setNameColor(Color COLOR) {
        this.nameColor.set(COLOR);
    }

    public ObjectProperty<Color> nameColorProperty() {
        return this.nameColor;
    }

    public Color getValueColor() {
        return (Color)this.valueColor.get();
    }

    public void setValueColor(Color COLOR) {
        this.valueColor.set(COLOR);
    }

    public ObjectProperty<Color> valueColorProperty() {
        return this.valueColor;
    }

    public ChartData getChartData() {
        return this.chartData;
    }

    public void setChartData(ChartData DATA) {
        this.chartData = DATA;
        this.chartData.fireChartDataEvent(new ChartDataEvent(ChartDataEvent.EventType.UPDATE, this.chartData));
    }

    public Color getBarBackgroundColor() {
        return (Color)this.barBackgroundColor.get();
    }

    public void setBarBackgroundColor(Color COLOR) {
        this.barBackgroundColor.set(COLOR);
    }

    public ObjectProperty<Color> barBackgroundColorProperty() {
        return this.barBackgroundColor;
    }

    public Color getBarColor() {
        return this.chartData.getFillColor();
    }

    public void setBarColor(Color COLOR) {
        this.chartData.setFillColor(COLOR);
    }

    @Override
    public int compareTo(BarChartItem ITEM) {
        return Double.compare(this.getValue(), ITEM.getValue());
    }

    public void setStepSize(double STEP_SIZE) {
        this.stepSize = STEP_SIZE;
        this.updateBar(this.getValue());
    }

    public void setMaxValue(double MAX_VALUE) {
        this.maxValue = MAX_VALUE;
        this.stepSize = (this.parentWidth - this.size * 0.15) / this.maxValue;
        this.updateBar(this.getValue());
    }

    public void setLocale(Locale LOCALE) {
        this.locale = LOCALE;
        this.valueText.setText(String.format(this.locale, this.formatString, this.getValue()));
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String FORMAT_STRING) {
        this.formatString = FORMAT_STRING;
        this.valueText.setText(String.format(this.locale, this.formatString, this.getValue()));
    }

    protected void setParentSize(double WIDTH, double HEIGHT) {
        this.parentWidth = WIDTH;
        this.parentHeight = HEIGHT;
        this.resize();
    }

    private void updateBar(double VALUE) {
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.valueText.setX(this.parentWidth - this.size * 0.05 - this.valueText.getLayoutBounds().getWidth());
        this.bar.setWidth(Helper.clamp(0.0, this.parentWidth - this.size * 0.15, VALUE * this.stepSize));
        this.bar.setFill(this.getBarColor());
    }

    public void setOnChartDataEvent(ChartDataEventListener LISTENER) {
        this.chartData.addChartDataEventListener(LISTENER);
    }

    public void addChartDataEventListener(ChartDataEventListener LISTENER) {
        this.chartData.addChartDataEventListener(LISTENER);
    }

    public void removeChartDataEventListener(ChartDataEventListener LISTENER) {
        this.chartData.removeChartDataEventListener(LISTENER);
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.parentWidth < this.parentHeight ? this.parentWidth : this.parentHeight;
        if (0.12 * this.width > this.height) {
            this.width = 1.0 / (0.12 / this.height);
        } else if (1.0 / (0.12 / this.height) > this.width) {
            this.height = 0.12 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.stepSize = (this.parentWidth - this.size * 0.15) / this.maxValue;
            this.pane.setMaxSize(this.parentWidth, this.height * 0.12);
            this.pane.setPrefSize(this.parentWidth, this.height * 0.12);
            this.nameText.setFont(Fonts.latoRegular(this.size * 0.06));
            this.nameText.setX(this.size * 0.05);
            this.nameText.setY(0.0);
            this.valueText.setFont(Fonts.latoRegular(this.size * 0.06));
            this.valueText.setX(this.parentWidth - this.size * 0.05 - this.valueText.getLayoutBounds().getWidth());
            this.valueText.setY(0.0);
            this.barBackground.setX(this.size * 0.075);
            this.barBackground.setY(this.size * 0.10333333);
            this.barBackground.setWidth(this.parentWidth - this.size * 0.15);
            this.barBackground.setHeight(this.size * 0.01);
            this.bar.setX(this.size * 0.075);
            this.bar.setY(this.size * 0.09666667);
            this.bar.setWidth(Helper.clamp(0.0, this.parentWidth - this.size * 0.15, this.getValue() * this.stepSize));
            this.bar.setHeight(this.size * 0.02333333);
            this.redraw();
        }
    }

    private void redraw() {
        this.nameText.setFill(this.getNameColor());
        this.valueText.setFill(this.getValueColor());
        this.barBackground.setFill(this.getBarBackgroundColor());
        this.bar.setFill(this.getBarColor());
    }

    @Override
    public String toString() {
        return this.getName() + "," + this.getValue() + "," + this.getBarColor();
    }
}

