/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import jadx.api.JadxArgs;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import say.swing.JFontChooser;

public class JadxSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -1804570470377354148L;
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsWindow.class);
    private final transient MainWindow mainWindow;
    private final transient JadxSettings settings;
    private final transient String startSettings;
    private final transient LangLocale prevLang;
    private transient boolean needReload = false;

    public JadxSettingsWindow(MainWindow mainWindow, JadxSettings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
        this.startSettings = JadxSettingsAdapter.makeString(settings);
        this.prevLang = settings.getLangLocale();
        this.initUI();
        this.setTitle(NLS.str("preferences.title", new Object[0]));
        this.setSize(400, 550);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.makeDeobfuscationGroup());
        panel.add(this.makeRenameGroup());
        panel.add(this.makeDecompilationGroup());
        panel.add(this.makeProjectGroup());
        panel.add(this.makeEditorGroup());
        panel.add(this.makeOtherGroup());
        JButton saveBtn = new JButton(NLS.str("preferences.save", new Object[0]));
        saveBtn.addActionListener(event -> {
            this.settings.sync();
            JadxSettingsWindow.enableComponents(this, false);
            SwingUtilities.invokeLater(() -> {
                if (this.needReload) {
                    this.mainWindow.reOpenFile();
                }
                if (!this.settings.getLangLocale().equals(this.prevLang)) {
                    JOptionPane.showMessageDialog(this, NLS.str("msg.language_changed", this.settings.getLangLocale()), NLS.str("msg.language_changed_title", this.settings.getLangLocale()), 1);
                }
                this.dispose();
            });
        });
        JButton cancelButton = new JButton(NLS.str("preferences.cancel", new Object[0]));
        cancelButton.addActionListener(event -> {
            JadxSettingsAdapter.fill(this.settings, this.startSettings);
            this.mainWindow.loadSettings();
            this.dispose();
        });
        JButton resetBtn = new JButton(NLS.str("preferences.reset", new Object[0]));
        resetBtn.addActionListener(event -> {
            int res = JOptionPane.showConfirmDialog(this, NLS.str("preferences.reset_message", new Object[0]), NLS.str("preferences.reset_title", new Object[0]), 0);
            if (res == 0) {
                String defaults = JadxSettingsAdapter.makeString(JadxSettings.makeDefault());
                JadxSettingsAdapter.fill(this.settings, defaults);
                this.mainWindow.loadSettings();
                this.needReload();
                this.getContentPane().removeAll();
                this.initUI();
                this.pack();
                this.repaint();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(resetBtn);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.getRootPane().setDefaultButton(saveBtn);
    }

    private static void enableComponents(Container container, boolean enable) {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                JadxSettingsWindow.enableComponents((Container)component, enable);
            }
            component.setEnabled(enable);
        }
    }

    private SettingsGroup makeDeobfuscationGroup() {
        JCheckBox deobfOn = new JCheckBox();
        deobfOn.setSelected(this.settings.isDeobfuscationOn());
        deobfOn.addItemListener(e -> {
            this.settings.setDeobfuscationOn(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox deobfForce = new JCheckBox();
        deobfForce.setSelected(this.settings.isDeobfuscationForceSave());
        deobfForce.addItemListener(e -> {
            this.settings.setDeobfuscationForceSave(e.getStateChange() == 1);
            this.needReload();
        });
        SpinnerNumberModel minLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMinLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner minLenSpinner = new JSpinner(minLenModel);
        minLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMinLength((Integer)minLenSpinner.getValue());
            this.needReload();
        });
        SpinnerNumberModel maxLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMaxLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner maxLenSpinner = new JSpinner(maxLenModel);
        maxLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMaxLength((Integer)maxLenSpinner.getValue());
            this.needReload();
        });
        JCheckBox deobfSourceAlias = new JCheckBox();
        deobfSourceAlias.setSelected(this.settings.isDeobfuscationUseSourceNameAsAlias());
        deobfSourceAlias.addItemListener(e -> {
            this.settings.setDeobfuscationUseSourceNameAsAlias(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup deobfGroup = new SettingsGroup(NLS.str("preferences.deobfuscation", new Object[0]));
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_on", new Object[0]), deobfOn);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_force", new Object[0]), deobfForce);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_min_len", new Object[0]), minLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_max_len", new Object[0]), maxLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_source_alias", new Object[0]), deobfSourceAlias);
        deobfGroup.end();
        List<JComponent> connectedComponents = Arrays.asList(deobfForce, minLenSpinner, maxLenSpinner, deobfSourceAlias);
        deobfOn.addItemListener(e -> this.enableComponentList(connectedComponents, e.getStateChange() == 1));
        this.enableComponentList(connectedComponents, this.settings.isDeobfuscationOn());
        return deobfGroup;
    }

    private SettingsGroup makeRenameGroup() {
        JCheckBox renameCaseSensitive = new JCheckBox();
        renameCaseSensitive.setSelected(this.settings.isRenameCaseSensitive());
        renameCaseSensitive.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.CASE, e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox renameValid = new JCheckBox();
        renameValid.setSelected(this.settings.isRenameValid());
        renameValid.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.VALID, e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox renamePrintable = new JCheckBox();
        renamePrintable.setSelected(this.settings.isRenamePrintable());
        renamePrintable.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.PRINTABLE, e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.rename", new Object[0]));
        group.addRow(NLS.str("preferences.rename_case", new Object[0]), renameCaseSensitive);
        group.addRow(NLS.str("preferences.rename_valid", new Object[0]), renameValid);
        group.addRow(NLS.str("preferences.rename_printable", new Object[0]), renamePrintable);
        return group;
    }

    private void enableComponentList(Collection<JComponent> connectedComponents, boolean enabled) {
        connectedComponents.forEach(comp -> comp.setEnabled(enabled));
    }

    private SettingsGroup makeProjectGroup() {
        JCheckBox autoSave = new JCheckBox();
        autoSave.setSelected(this.settings.isAutoSaveProject());
        autoSave.addItemListener(e -> this.settings.setAutoSaveProject(e.getStateChange() == 1));
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.project", new Object[0]));
        group.addRow(NLS.str("preferences.autoSave", new Object[0]), autoSave);
        return group;
    }

    private SettingsGroup makeEditorGroup() {
        JButton fontBtn = new JButton(NLS.str("preferences.select_font", new Object[0]));
        EditorTheme[] editorThemes = EditorTheme.getAllThemes();
        JComboBox<EditorTheme> themesCbx = new JComboBox<EditorTheme>(editorThemes);
        for (EditorTheme theme : editorThemes) {
            if (!theme.getPath().equals(this.settings.getEditorThemePath())) continue;
            themesCbx.setSelectedItem(theme);
            break;
        }
        themesCbx.addActionListener(e -> {
            int i = themesCbx.getSelectedIndex();
            EditorTheme editorTheme = editorThemes[i];
            this.settings.setEditorThemePath(editorTheme.getPath());
            this.mainWindow.loadSettings();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.editor", new Object[0]));
        final JLabel fontLabel = group.addRow(this.getFontLabelStr(), fontBtn);
        group.addRow(NLS.str("preferences.theme", new Object[0]), themesCbx);
        fontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFontChooser fontChooser = new JFontChooser();
                fontChooser.setSelectedFont(JadxSettingsWindow.this.settings.getFont());
                int result = fontChooser.showDialog(JadxSettingsWindow.this);
                if (result == 0) {
                    Font font = fontChooser.getSelectedFont();
                    LOG.debug("Selected Font: {}", (Object)font);
                    JadxSettingsWindow.this.settings.setFont(font);
                    JadxSettingsWindow.this.mainWindow.loadSettings();
                    fontLabel.setText(JadxSettingsWindow.this.getFontLabelStr());
                }
            }
        });
        return group;
    }

    private String getFontLabelStr() {
        Font font = this.settings.getFont();
        String fontStyleName = FontUtils.convertFontStyleToString(font.getStyle());
        return NLS.str("preferences.font", new Object[0]) + ": " + font.getFontName() + ' ' + fontStyleName + ' ' + font.getSize();
    }

    private SettingsGroup makeDecompilationGroup() {
        JCheckBox fallback = new JCheckBox();
        fallback.setSelected(this.settings.isFallbackMode());
        fallback.addItemListener(e -> {
            this.settings.setFallbackMode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox showInconsistentCode = new JCheckBox();
        showInconsistentCode.setSelected(this.settings.isShowInconsistentCode());
        showInconsistentCode.addItemListener(e -> {
            this.settings.setShowInconsistentCode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox resourceDecode = new JCheckBox();
        resourceDecode.setSelected(this.settings.isSkipResources());
        resourceDecode.addItemListener(e -> {
            this.settings.setSkipResources(e.getStateChange() == 1);
            this.needReload();
        });
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(this.settings.getThreadsCount(), 1, Runtime.getRuntime().availableProcessors() * 2, 1);
        JSpinner threadsCount = new JSpinner(spinnerModel);
        threadsCount.addChangeListener(e -> {
            this.settings.setThreadsCount((Integer)threadsCount.getValue());
            this.needReload();
        });
        JButton editExcludedPackages = new JButton(NLS.str("preferences.excludedPackages.button", new Object[0]));
        editExcludedPackages.addActionListener(event -> {
            String oldExcludedPackages = this.settings.getExcludedPackages();
            String result = JOptionPane.showInputDialog(this, NLS.str("preferences.excludedPackages.editDialog", new Object[0]), this.settings.getExcludedPackages());
            if (result != null) {
                this.settings.setExcludedPackages(result);
                if (!oldExcludedPackages.equals(result)) {
                    this.needReload();
                }
            }
        });
        JCheckBox autoStartJobs = new JCheckBox();
        autoStartJobs.setSelected(this.settings.isAutoStartJobs());
        autoStartJobs.addItemListener(e -> this.settings.setAutoStartJobs(e.getStateChange() == 1));
        JCheckBox escapeUnicode = new JCheckBox();
        escapeUnicode.setSelected(this.settings.isEscapeUnicode());
        escapeUnicode.addItemListener(e -> {
            this.settings.setEscapeUnicode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox replaceConsts = new JCheckBox();
        replaceConsts.setSelected(this.settings.isReplaceConsts());
        replaceConsts.addItemListener(e -> {
            this.settings.setReplaceConsts(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox respectBytecodeAccessModifiers = new JCheckBox();
        respectBytecodeAccessModifiers.setSelected(this.settings.isRespectBytecodeAccessModifiers());
        respectBytecodeAccessModifiers.addItemListener(e -> {
            this.settings.setRespectBytecodeAccessModifiers(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox useImports = new JCheckBox();
        useImports.setSelected(this.settings.isUseImports());
        useImports.addItemListener(e -> {
            this.settings.setUseImports(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox inlineAnonymous = new JCheckBox();
        inlineAnonymous.setSelected(this.settings.isInlineAnonymousClasses());
        inlineAnonymous.addItemListener(e -> {
            this.settings.setInlineAnonymousClasses(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox fsCaseSensitive = new JCheckBox();
        fsCaseSensitive.setSelected(this.settings.isFsCaseSensitive());
        fsCaseSensitive.addItemListener(e -> {
            this.settings.setFsCaseSensitive(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.decompile", new Object[0]));
        other.addRow(NLS.str("preferences.threads", new Object[0]), threadsCount);
        other.addRow(NLS.str("preferences.excludedPackages", new Object[0]), NLS.str("preferences.excludedPackages.tooltip", new Object[0]), editExcludedPackages);
        other.addRow(NLS.str("preferences.start_jobs", new Object[0]), autoStartJobs);
        other.addRow(NLS.str("preferences.showInconsistentCode", new Object[0]), showInconsistentCode);
        other.addRow(NLS.str("preferences.escapeUnicode", new Object[0]), escapeUnicode);
        other.addRow(NLS.str("preferences.replaceConsts", new Object[0]), replaceConsts);
        other.addRow(NLS.str("preferences.respectBytecodeAccessModifiers", new Object[0]), respectBytecodeAccessModifiers);
        other.addRow(NLS.str("preferences.useImports", new Object[0]), useImports);
        other.addRow(NLS.str("preferences.inlineAnonymous", new Object[0]), inlineAnonymous);
        other.addRow(NLS.str("preferences.fsCaseSensitive", new Object[0]), fsCaseSensitive);
        other.addRow(NLS.str("preferences.fallback", new Object[0]), fallback);
        other.addRow(NLS.str("preferences.skipResourcesDecode", new Object[0]), resourceDecode);
        return other;
    }

    private SettingsGroup makeOtherGroup() {
        JComboBox<LangLocale> languageCbx = new JComboBox<LangLocale>(NLS.getLangLocales());
        for (LangLocale locale : NLS.getLangLocales()) {
            if (!locale.equals(this.settings.getLangLocale())) continue;
            languageCbx.setSelectedItem(locale);
            break;
        }
        languageCbx.addActionListener(e -> this.settings.setLangLocale((LangLocale)languageCbx.getSelectedItem()));
        JCheckBox update = new JCheckBox();
        update.setSelected(this.settings.isCheckForUpdates());
        update.addItemListener(e -> this.settings.setCheckForUpdates(e.getStateChange() == 1));
        JCheckBox cfg = new JCheckBox();
        cfg.setSelected(this.settings.isCfgOutput());
        cfg.addItemListener(e -> {
            this.settings.setCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox rawCfg = new JCheckBox();
        rawCfg.setSelected(this.settings.isRawCfgOutput());
        rawCfg.addItemListener(e -> {
            this.settings.setRawCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.other", new Object[0]));
        group.addRow(NLS.str("preferences.language", new Object[0]), languageCbx);
        group.addRow(NLS.str("preferences.check_for_updates", new Object[0]), update);
        group.addRow(NLS.str("preferences.cfg", new Object[0]), cfg);
        group.addRow(NLS.str("preferences.raw_cfg", new Object[0]), rawCfg);
        return group;
    }

    private void needReload() {
        this.needReload = true;
    }

    private static class SettingsGroup
    extends JPanel {
        private static final long serialVersionUID = -6487309975896192544L;
        private final GridBagConstraints c;
        private int row;

        public SettingsGroup(String title) {
            this.setBorder(BorderFactory.createTitledBorder(title));
            this.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.insets = new Insets(5, 5, 5, 5);
            this.c.weighty = 1.0;
        }

        public JLabel addRow(String label, JComponent comp) {
            return this.addRow(label, null, comp);
        }

        public JLabel addRow(String label, String tooltip, JComponent comp) {
            this.c.gridy = this.row++;
            JLabel jLabel = new JLabel(label);
            jLabel.setLabelFor(comp);
            jLabel.setHorizontalAlignment(2);
            this.c.gridx = 0;
            this.c.gridwidth = 1;
            this.c.anchor = 21;
            this.c.weightx = 0.8;
            this.c.fill = 0;
            this.add((Component)jLabel, this.c);
            this.c.gridx = 1;
            this.c.gridwidth = 0;
            this.c.anchor = 10;
            this.c.weightx = 0.2;
            this.c.fill = 2;
            if (tooltip != null) {
                jLabel.setToolTipText(tooltip);
                comp.setToolTipText(tooltip);
            }
            this.add((Component)comp, this.c);
            comp.addPropertyChangeListener("enabled", evt -> jLabel.setEnabled((Boolean)evt.getNewValue()));
            return jLabel;
        }

        public void end() {
            this.add(Box.createVerticalGlue());
        }
    }
}

