/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import java.util.HashMap;
import java.util.Map;

public class InfoStorage {
    private final Map<ArgType, ClassInfo> classes = new HashMap<ArgType, ClassInfo>();
    private final Map<Integer, MethodInfo> methods = new HashMap<Integer, MethodInfo>();
    private final Map<FieldInfo, FieldInfo> fields = new HashMap<FieldInfo, FieldInfo>();

    public ClassInfo getCls(ArgType type) {
        return this.classes.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo putCls(ClassInfo cls) {
        Map<ArgType, ClassInfo> map = this.classes;
        synchronized (map) {
            ClassInfo prev = this.classes.put(cls.getType(), cls);
            return prev == null ? cls : prev;
        }
    }

    private int generateMethodLookupId(DexNode dex, int mthId) {
        return dex.getDexId() << 16 | mthId;
    }

    public MethodInfo getMethod(DexNode dex, int mtdId) {
        return this.methods.get(this.generateMethodLookupId(dex, mtdId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo putMethod(DexNode dex, int mthId, MethodInfo mth) {
        Map<Integer, MethodInfo> map = this.methods;
        synchronized (map) {
            MethodInfo prev = this.methods.put(this.generateMethodLookupId(dex, mthId), mth);
            return prev == null ? mth : prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getField(FieldInfo field) {
        Map<FieldInfo, FieldInfo> map = this.fields;
        synchronized (map) {
            FieldInfo f = this.fields.get(field);
            if (f != null) {
                return f;
            }
            this.fields.put(field, field);
            return field;
        }
    }
}

