
# Required packages
package require ::quartus::project
package require ::quartus::report
package require ::quartus::flow

proc print_database_to_file { project_name project_rev panel_names output_filepath } {
  project_open $project_name -revision $project_rev
  post_message "project opened"
  load_report $project_rev
  post_message "project loaded"

  set outfile [open $output_filepath w]
  
  set panel_name_list [split $panel_names ","]
  foreach panel_name $panel_name_list {
    puts $outfile "Starting the data for a new panel: $panel_name"
    if {[catch {get_report_panel_id "$panel_name"} panel_id] || $panel_id == -1} {
      return -2;
    }
    if {[catch {get_number_of_rows -id $panel_id} num_rows] || $num_rows == -1} {
        return -3;
    }
    for {set r 0} {$r < $num_rows} {incr r} {
      set row [get_report_panel_row -id $panel_id -row $r]
      # print the table to the output file
      puts $outfile "${row}"
    }
  }

  close $outfile
  unload_report
  return 0
}

# Parse input args
# args are:
#   project_name
#   project_rev
#   panel_name list, separated by commas, all as one string
#   output_path (work_dir + filename)
set expected_arg_len 4
set arglen [llength $quartus(args)]
if {$arglen != $expected_arg_len} {
  post_message "The expected number of arguments for this script should be ${expected_arg_len}. Please verify your arguments and retry.\n";
  exit -1
} else {
  set index 0
  while {$index < $arglen} {
    set arg [lindex $quartus(args) $index]
    switch -- $index 0 {
      set project_name $arg
    } 1 {
      set project_rev $arg
    } 2 {
      set panel_names $arg
    } 3 {
      set output_path $arg
    }
    incr index
  }
  if {[catch {print_database_to_file $project_name $project_rev $panel_names $output_path} errmsg]} {
    puts "Generating OpenCL report failed with the following error message:"
    puts $errmsg
    puts "Skipping report generation."
    exit -1
  }
}
