#pragma once

#include <sycl/CL/__spirv/spirv_ops.hpp>
#include <sycl/CL/__spirv/spirv_types.hpp>
#include <sycl/stl.hpp>
#include <sycl/ext/oneapi/properties/property.hpp>
#include <sycl/ext/oneapi/properties/property_value.hpp>

namespace sycl {
inline namespace _V1 {
namespace ext {
namespace intel {
namespace experimental {

template <class _dataT, bool uses_packets, bool use_Empty> struct StreamingBeat;
template <class _dataT>
struct StreamingBeat <_dataT, true, false> {
  [[clang::annotate("{data}")]] _dataT data;
  [[clang::annotate("{sideband:sop}")]] bool sop;
  [[clang::annotate("{sideband:eop}")]] bool eop;
  StreamingBeat() : sop(false), eop(false) {}
  StreamingBeat(_dataT _data, bool _sop, bool _eop){
    data = _data;
    sop = _sop;
    eop = _eop;
  }
  ~StreamingBeat() {}
  StreamingBeat(const StreamingBeat &p) {
    data = p.data;
    sop = p.sop;
    eop = p.eop;
  }
  StreamingBeat& operator=(const StreamingBeat &p) {
    data = p.data;
    sop = p.sop;
    eop = p.eop;
    return *this;
  }
};

template <class _dataT>
struct StreamingBeat <_dataT, true, true> {
  [[clang::annotate("{data}")]] _dataT data;
  [[clang::annotate("{sideband:sop}")]] bool sop;
  [[clang::annotate("{sideband:eop}")]] bool eop;
  [[clang::annotate("{sideband:empty}")]] int empty;
  StreamingBeat() : sop(false), eop(false), empty(0) {}
  StreamingBeat(_dataT _data, bool _sop, bool _eop, int _empty){
    data = _data;
    sop = _sop;
    eop = _eop;
    empty = _empty;
  }
  ~StreamingBeat() {}
  StreamingBeat(const StreamingBeat &p) {
    data = p.data;
    sop = p.sop;
    eop = p.eop;
    empty = p.empty;
  }
  StreamingBeat& operator=(const StreamingBeat &p) {
    data = p.data;
    sop = p.sop;
    eop = p.eop;
    empty = p.empty;
    return *this;
  }
};

template <class _dataT>
struct StreamingBeat <_dataT, false, true>{
  [[clang::annotate("{data}")]] _dataT data;
  [[clang::annotate("{sideband:empty}")]] int empty;
  StreamingBeat() {
    // static_assert(!"Can't use empty sideband signal without start of packet and end of packet signals.");
  }
  StreamingBeat(_dataT _data, int _empty){
    // static_assert(!"Can't use empty sideband signal without start of packet and end of packet signals.");
  }
};

template <class _dataT>
struct StreamingBeat <_dataT, false, false> {
  [[clang::annotate("{data}")]] _dataT data;
  StreamingBeat() {
    // static_assert(!"No Sideband Signals. Pass data to type directly.");
  }
  StreamingBeat(_dataT _data){
    // static_assert(!"No Sideband Signals. Pass data to type directly.");
  }
};

} // namespace experimental
} // namespace intel
} // namespace ext
} // inline namespace _V1
} // namespace sycl

