#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cipher-aes
version:              0.2.11
visibility:           public
id:                   cipher-aes-0.2.11-EvVJO8qmpr97KEqgYS4zMD
key:                  cipher-aes-0.2.11-EvVJO8qmpr97KEqgYS4zMD
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
homepage:             https://github.com/vincenthz/hs-cipher-aes
synopsis:
    Fast AES cipher implementation with advanced mode of operations

description:
    Fast AES cipher implementation with advanced mode of operations.

    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).

    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.

    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.

category:             Cryptography
abi:                  cddb01640ca2ac412587537800cfefe1
exposed:              True
exposed-modules:      Crypto.Cipher.AES
import-dirs:          /usr/lib/ghc-8.10.5/site-local/cipher-aes-0.2.11
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cipher-aes-0.2.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cipher-aes-0.2.11
hs-libraries:         HScipher-aes-0.2.11-EvVJO8qmpr97KEqgYS4zMD
depends:
    base-4.14.2.0 byteable-0.1.1-Gf4TH6XbSdI4yHpNVK8xgD
    bytestring-0.10.12.0
    crypto-cipher-types-0.0.9-LQo54bzmotf2im7aqpU2MN
    securemem-0.1.10-BEeIFImmh46Qes0xw1pUh

haddock-interfaces:   /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html:         /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

