/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.cmd.DeletePointCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;

public class InsertPointCmd
extends Command {
    private final DataPoint _point;
    private final int _pointIndex;
    private final boolean _nextSegmentFlag;

    public InsertPointCmd(DataPoint dataPoint, int n) {
        this(null, dataPoint, n, false);
    }

    InsertPointCmd(Command command, DataPoint dataPoint, int n, boolean bl) {
        super(command);
        this._point = dataPoint;
        this._pointIndex = n;
        this._nextSegmentFlag = bl;
    }

    @Override
    public int getUpdateFlags() {
        return 1;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        DataPoint dataPoint;
        boolean bl;
        if (this._point == null) {
            return false;
        }
        if (this._pointIndex < 0) {
            bl = trackInfo.getTrack().appendPoint(this._point);
            trackInfo.selectPoint(trackInfo.getTrack().getNumPoints() - 1);
        } else {
            bl = trackInfo.getTrack().insertPoint(this._point, this._pointIndex);
            trackInfo.getSelection().modifyPointInserted(this._pointIndex);
            trackInfo.selectPoint(this._pointIndex);
        }
        if (this.isUndo() && bl && this._pointIndex >= 0 && (dataPoint = trackInfo.getTrack().getNextTrackPoint(this._pointIndex + 1)) != null) {
            dataPoint.setSegmentStart(this._nextSegmentFlag);
        }
        return bl;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        return new DeletePointCmd(this, this._pointIndex);
    }
}

