/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import info.monitorenter.gui.util.HSBColor;
import java.awt.Color;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorIterator
implements Iterator<Color> {
    private boolean m_ascendingDirection = true;
    private boolean m_hasnext = true;
    private boolean m_firstTime = true;
    protected HSBColor m_iterate;
    private ISteppingModel m_resetModel;
    protected HSBColor m_startColor;
    private ISteppingModel m_stepModel;

    public ColorIterator() {
        this(Color.RED, new HueStepper(1000));
    }

    public ColorIterator(Color startColor, ISteppingModel stepper) {
        this.setStartColor(startColor);
        this.m_stepModel = stepper;
        this.m_resetModel = (ISteppingModel)this.m_stepModel.clone();
        this.m_firstTime = true;
    }

    public final Color getStartColor() {
        return this.m_startColor.getRGBColor();
    }

    @Override
    public boolean hasNext() {
        return this.m_hasnext;
    }

    @Override
    public Color next() throws NoSuchElementException {
        if (!this.m_hasnext) {
            throw new NoSuchElementException("No more colors to give (call reset for new run!)");
        }
        if (!this.m_firstTime) {
            this.m_stepModel.doStep(this);
            if (this.m_iterate.equals(this.m_startColor)) {
                this.m_hasnext = false;
            }
        } else {
            this.m_firstTime = false;
        }
        return this.m_iterate.getRGBColor();
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.m_iterate = (HSBColor)this.m_startColor.clone();
        this.m_stepModel = (ISteppingModel)this.m_resetModel.clone();
        this.m_hasnext = true;
        this.m_firstTime = true;
    }

    public final void setStartColor(Color startColor) {
        this.m_startColor = HSBColor.rgbToHSB(startColor);
        this.m_iterate = (HSBColor)this.m_startColor.clone();
    }

    public void setSteps(int steps) {
        this.m_resetModel.setSteps(steps);
        this.m_stepModel.setSteps(steps);
    }

    public final boolean isAscendingDirection() {
        return this.m_ascendingDirection;
    }

    public final void setAscendingDirection(boolean ascendingDirection) {
        this.m_ascendingDirection = ascendingDirection;
    }

    public static class AlphaStepper
    extends ADefaultStepping {
        public void setSteps(int steps) {
            this.m_stepping = 255.0 / (double)steps;
        }

        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_alpha;
            double bound = tostep.m_startColor.m_alpha;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_alpha < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 255.0 && (increment -= 255.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_alpha > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 255.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_alpha = increment;
        }
    }

    public static class SaturationStepper
    extends ADefaultStepping {
        public SaturationStepper() {
        }

        public SaturationStepper(int steps) {
            super(steps);
        }

        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_sat;
            double bound = tostep.m_startColor.m_sat;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_sat < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 1.0 && (increment -= 1.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_sat > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 1.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_sat = increment;
        }
    }

    public static class LuminanceStepper
    extends ADefaultStepping {
        public LuminanceStepper() {
        }

        public LuminanceStepper(int steps) {
            super(steps);
        }

        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_lum;
            double bound = tostep.m_startColor.m_lum;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_lum < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 1.0 && (increment -= 1.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_lum > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 1.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_lum = increment;
        }
    }

    public static interface ISteppingModel
    extends Cloneable {
        public Object clone();

        public void doStep(ColorIterator var1);

        public void setSteps(int var1);
    }

    public static class HueStepper
    extends ADefaultStepping {
        public HueStepper() {
        }

        public HueStepper(int steps) {
            super(steps);
        }

        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_hue;
            double bound = tostep.m_startColor.m_hue;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_hue < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 1.0 && (increment -= 1.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_hue > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 1.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_hue = increment;
        }
    }

    public static class HSStepper
    extends APiggyBackStepper {
        public void doStep(ColorIterator tostep) {
            this.m_huestep.doStep(tostep);
            if (tostep.m_iterate.m_hue == tostep.m_startColor.m_hue) {
                this.m_satstep.doStep(tostep);
            }
        }
    }

    public static class HSBStepper
    extends APiggyBackStepper {
        public void doStep(ColorIterator tostep) {
            this.m_huestep.doStep(tostep);
            if (tostep.m_iterate.m_hue == tostep.m_startColor.m_hue) {
                this.m_satstep.doStep(tostep);
                if (tostep.m_iterate.m_sat == tostep.m_startColor.m_sat) {
                    this.m_lumstep.doStep(tostep);
                }
            }
        }
    }

    public static abstract class APiggyBackStepper
    implements ISteppingModel {
        protected HueStepper m_huestep;
        protected LuminanceStepper m_lumstep;
        protected SaturationStepper m_satstep;

        public APiggyBackStepper() {
            this(100, 100, 100);
        }

        public APiggyBackStepper(int hueSteps, int satSteps, int lumSteps) {
            this.m_huestep = new HueStepper(hueSteps);
            this.m_satstep = new SaturationStepper(satSteps);
            this.m_lumstep = new LuminanceStepper(lumSteps);
        }

        public Object clone() {
            try {
                APiggyBackStepper ret = (APiggyBackStepper)super.clone();
                ret.m_huestep = (HueStepper)this.m_huestep.clone();
                ret.m_satstep = (SaturationStepper)this.m_satstep.clone();
                ret.m_lumstep = (LuminanceStepper)this.m_lumstep.clone();
                return ret;
            }
            catch (CloneNotSupportedException cne) {
                cne.printStackTrace(System.err);
                throw new RuntimeException(cne);
            }
        }

        public void setSteps(int steps) {
            this.m_huestep.setSteps(steps);
            this.m_lumstep.setSteps(steps);
            this.m_satstep.setSteps(steps);
        }
    }

    public static abstract class ADefaultStepping
    implements ISteppingModel {
        protected double m_stepping;

        public ADefaultStepping() {
            this(100);
        }

        public ADefaultStepping(int steps) {
            this.setSteps(steps);
        }

        public Object clone() {
            ADefaultStepping result = null;
            try {
                result = (ADefaultStepping)super.clone();
                result.m_stepping = this.m_stepping;
            }
            catch (Throwable f) {
                f.printStackTrace();
            }
            return result;
        }

        public void setSteps(int steps) {
            this.m_stepping = 1.0 / (double)steps;
        }
    }
}

