/* THIS FILE IS AUTOGENERATED FROM InstallTrigger.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "InstallTriggerBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsIGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


MOZ_CAN_RUN_SCRIPT void
InstallTriggerCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const nsAString& url, int16_t status, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 2;

  do {
    argv[1].setInt32(int32_t(status));
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, url, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}




InstallTriggerData::InstallTriggerData()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
InstallTriggerData::InitIds(JSContext* cx, InstallTriggerDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->URL_id.init(cx, "URL") ||
      !atomsCache->IconURL_id.init(cx, "IconURL") ||
      !atomsCache->Hash_id.init(cx, "Hash")) {
    return false;
  }
  return true;
}

bool
InstallTriggerData::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  InstallTriggerDataAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<InstallTriggerDataAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->Hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHash.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, (mHash.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->IconURL_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mIconURL.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, (mIconURL.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->URL_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mURL.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mURL.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
InstallTriggerData::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
InstallTriggerData::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InstallTriggerDataAtoms* atomsCache = GetAtomCache<InstallTriggerDataAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mHash.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mHash.InternalValue();
      if (!xpc::StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->Hash_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mIconURL.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mIconURL.InternalValue();
      if (!xpc::StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->IconURL_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mURL.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mURL.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->URL_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
InstallTriggerData::TraceDictionary(JSTracer* trc)
{
}

InstallTriggerData&
InstallTriggerData::operator=(const InstallTriggerData& aOther)
{
  DictionaryBase::operator=(aOther);
  mHash.Reset();
  if (aOther.mHash.WasPassed()) {
    mHash.Construct(aOther.mHash.Value());
  }
  mIconURL.Reset();
  if (aOther.mIconURL.WasPassed()) {
    mIconURL.Construct(aOther.mIconURL.Value());
  }
  mURL.Reset();
  if (aOther.mURL.WasPassed()) {
    mURL.Construct(aOther.mURL.Value());
  }
  return *this;
}


bool
StringOrInstallTriggerData::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
StringOrInstallTriggerData::TrySetToInstallTriggerData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastInstallTriggerData& memberSlot = RawSetAsInstallTriggerData();
    if (!IsConvertibleToDictionary(value)) {
      DestroyInstallTriggerData();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "InstallTriggerData branch of (DOMString or InstallTriggerData)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
StringOrInstallTriggerData::TrySetToInstallTriggerData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToInstallTriggerData(cx, value, tryNext, passedToJSImpl);
}







bool
StringOrInstallTriggerData::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToInstallTriggerData(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "InstallTriggerData");
    return false;
  }
  return true;
}

bool
StringOrInstallTriggerData::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
StringOrInstallTriggerData::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eInstallTriggerData: {
      if (!mValue.mInstallTriggerData.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningStringOrInstallTriggerData::OwningStringOrInstallTriggerData(OwningStringOrInstallTriggerData&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
    case eInstallTriggerData: {
      mType = eInstallTriggerData;
      mValue.mInstallTriggerData.SetValue(std::move(aOther.mValue.mInstallTriggerData.Value()));
      break;
    }
  }
}



bool
OwningStringOrInstallTriggerData::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningStringOrInstallTriggerData::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningStringOrInstallTriggerData::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningStringOrInstallTriggerData::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrInstallTriggerData::TrySetToInstallTriggerData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    InstallTriggerData& memberSlot = RawSetAsInstallTriggerData();
    if (!IsConvertibleToDictionary(value)) {
      DestroyInstallTriggerData();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "InstallTriggerData branch of (DOMString or InstallTriggerData)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningStringOrInstallTriggerData::TrySetToInstallTriggerData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToInstallTriggerData(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] InstallTriggerData&
OwningStringOrInstallTriggerData::RawSetAsInstallTriggerData()
{
  if (mType == eInstallTriggerData) {
    return mValue.mInstallTriggerData.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eInstallTriggerData;
  return mValue.mInstallTriggerData.SetValue();
}

[[nodiscard]] InstallTriggerData&
OwningStringOrInstallTriggerData::SetAsInstallTriggerData()
{
  if (mType == eInstallTriggerData) {
    return mValue.mInstallTriggerData.Value();
  }
  Uninit();
  mType = eInstallTriggerData;
  return mValue.mInstallTriggerData.SetValue();
}


void
OwningStringOrInstallTriggerData::DestroyInstallTriggerData()
{
  MOZ_RELEASE_ASSERT(IsInstallTriggerData(), "Wrong type!");
  mValue.mInstallTriggerData.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrInstallTriggerData::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToInstallTriggerData(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "InstallTriggerData");
    return false;
  }
  return true;
}

bool
OwningStringOrInstallTriggerData::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningStringOrInstallTriggerData::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
    case eInstallTriggerData: {
      DestroyInstallTriggerData();
      break;
    }
  }
}

bool
OwningStringOrInstallTriggerData::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eInstallTriggerData: {
      if (!mValue.mInstallTriggerData.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningStringOrInstallTriggerData&
OwningStringOrInstallTriggerData::operator=(OwningStringOrInstallTriggerData&& aOther)
{
  this->~OwningStringOrInstallTriggerData();
  new (this) OwningStringOrInstallTriggerData (std::move(aOther));
  return *this;
}


OwningStringOrInstallTriggerData&
OwningStringOrInstallTriggerData::operator=(const OwningStringOrInstallTriggerData& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      SetAsString() = aOther.GetAsString();
      break;
    }
    case eInstallTriggerData: {
      SetAsInstallTriggerData() = aOther.GetAsInstallTriggerData();
      break;
    }
  }
  return *this;
}


namespace InstallTriggerImpl_Binding {

MOZ_CAN_RUN_SCRIPT static bool
enabled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InstallTriggerImpl", "enabled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InstallTriggerImpl*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->Enabled(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InstallTriggerImpl.enabled"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo enabled_methodinfo = {
  { (JSJitGetterOp)enabled },
  { prototypes::id::InstallTriggerImpl },
  { PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
updateEnabled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InstallTriggerImpl", "updateEnabled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InstallTriggerImpl*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->UpdateEnabled(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InstallTriggerImpl.updateEnabled"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo updateEnabled_methodinfo = {
  { (JSJitGetterOp)updateEnabled },
  { prototypes::id::InstallTriggerImpl },
  { PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
install(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "InstallTriggerImpl.install");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InstallTriggerImpl", "install", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InstallTriggerImpl*>(void_self);
  if (!args.requireAtLeast(cx, "InstallTriggerImpl.install", 1)) {
    return false;
  }
  DeprecationWarning(cx, obj, DeprecatedOperations::eInstallTriggerInstallDeprecated);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  Record<nsString, OwningStringOrInstallTriggerData> arg0;
  if (args[0].isObject()) {
    auto& recordEntries = arg0.Entries();

    JS::Rooted<JSObject*> recordObj(cx, &args[0].toObject());
    JS::RootedVector<jsid> ids(cx);
    if (!js::GetPropertyKeys(cx, recordObj,
                             JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
      return false;
    }
    if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    JS::Rooted<JS::Value> propNameValue(cx);
    JS::Rooted<JS::Value> temp(cx);
    JS::Rooted<jsid> curId(cx);
    JS::Rooted<JS::Value> idVal(cx);
    // Use a hashset to keep track of ids seen, to avoid
    // introducing nasty O(N^2) behavior scanning for them all the
    // time.  Ideally we'd use a data structure with O(1) lookup
    // _and_ ordering for the MozMap, but we don't have one lying
    // around.
    nsTHashtable<nsStringHashKey> idsSeen;
    for (size_t i = 0; i < ids.length(); ++i) {
      curId = ids[i];

      JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
      if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                           &desc)) {
        return false;
      }

      if (desc.isNothing() || !desc->enumerable()) {
        continue;
      }

      idVal = js::IdToValue(curId);
      nsString propName;
      // This will just throw if idVal is a Symbol, like the spec says
      // to do.
      if (!ConvertJSValueToString(cx, idVal, "key of argument 1", propName)) {
        return false;
      }

      if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
        return false;
      }

      Record<nsString, OwningStringOrInstallTriggerData>::EntryType* entry;
      if (!idsSeen.EnsureInserted(propName)) {
        // Find the existing entry.
        auto idx = recordEntries.IndexOf(propName);
        MOZ_ASSERT(idx != recordEntries.NoIndex,
                   "Why is it not found?");
        // Now blow it away to make it look like it was just added
        // to the array, because it's not obvious that it's
        // safe to write to its already-initialized mValue via our
        // normal codegen conversions.  For example, the value
        // could be a union and this would change its type, but
        // codegen assumes we won't do that.
        entry = recordEntries.ReconstructElementAt(idx);
      } else {
        // Safe to do an infallible append here, because we did a
        // SetCapacity above to the right capacity.
        entry = recordEntries.AppendElement();
      }
      entry->mKey = propName;
      OwningStringOrInstallTriggerData& slot = entry->mValue;
      if (!slot.Init(cx, temp, "Value in argument 1", true)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Optional<OwningNonNull<InstallTriggerCallback>> arg1;
  if (args.hasDefined(1)) {
    arg1.Construct();
    if (args[1].isObject()) {
      if (JS::IsCallable(&args[1].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[1].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg1.Value() = new InstallTriggerCallback(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
      return false;
    }
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->Install(Constify(arg0), MOZ_KnownLive(NonNullHelper(Constify(arg1))), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InstallTriggerImpl.install"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo install_methodinfo = {
  { (JSJitGetterOp)install },
  { prototypes::id::InstallTriggerImpl },
  { PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
installChrome(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InstallTriggerImpl", "installChrome", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InstallTriggerImpl*>(void_self);
  if (!args.requireAtLeast(cx, "InstallTriggerImpl.installChrome", 3)) {
    return false;
  }
  DeprecationWarning(cx, obj, DeprecatedOperations::eInstallTriggerInstallDeprecated);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  uint16_t arg0;
  if (!ValueToPrimitive<uint16_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg2;
  if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->InstallChrome(arg0, NonNullHelper(Constify(arg1)), NonNullHelper(Constify(arg2)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InstallTriggerImpl.installChrome"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo installChrome_methodinfo = {
  { (JSJitGetterOp)installChrome },
  { prototypes::id::InstallTriggerImpl },
  { PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
startSoftwareUpdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InstallTriggerImpl", "startSoftwareUpdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InstallTriggerImpl*>(void_self);
  if (!args.requireAtLeast(cx, "InstallTriggerImpl.startSoftwareUpdate", 1)) {
    return false;
  }
  DeprecationWarning(cx, obj, DeprecatedOperations::eInstallTriggerInstallDeprecated);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Optional<uint16_t> arg1;
  if (args.hasDefined(1)) {
    arg1.Construct();
    if (!ValueToPrimitive<uint16_t, eDefault>(cx, args[1], "Argument 2", &arg1.Value())) {
      return false;
    }
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->StartSoftwareUpdate(NonNullHelper(Constify(arg0)), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InstallTriggerImpl.startSoftwareUpdate"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo startSoftwareUpdate_methodinfo = {
  { (JSJitGetterOp)startSoftwareUpdate },
  { prototypes::id::InstallTriggerImpl },
  { PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::InstallTriggerImpl* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::InstallTriggerImpl>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::InstallTriggerImpl>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sChromeStaticMethods_specs[] = {
  JS_FNSPEC("_create", InstallTriggerImpl::_Create, nullptr, 2, 0, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeStaticMethods[] = {
  { nullptr, &sChromeStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("enabled", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&enabled_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("updateEnabled", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&updateEnabled_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("install", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&install_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("installChrome", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&installChrome_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("startSoftwareUpdate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&startSoftwareUpdate_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(5 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "SKIN", JS::Int32Value(1) },
  { "LOCALE", JS::Int32Value(2) },
  { "CONTENT", JS::Int32Value(4) },
  { "PACKAGE", JS::Int32Value(7) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[9];
static PropertyInfo sNativeProperties_propertyInfos[9];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  true,  1 /* sConstants */,
  -1,
  9,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sConstants, &sNativeProperties_propertyInfos[5] }
  }
};
static_assert(9 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  true,  0 /* sChromeStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeStaticMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::InstallTriggerImpl,
  constructors::id::InstallTriggerImpl,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth,
  prototypes::id::InstallTriggerImpl,
  true,
  0,
  "InstallTriggerImpl",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "InstallTriggerImplPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::InstallTriggerImpl,
  PrototypeTraits<prototypes::id::InstallTriggerImpl>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "InstallTriggerImpl",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::InstallTriggerImpl>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::InstallTriggerImpl, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::InstallTriggerImpl>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::InstallTriggerImpl>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::InstallTriggerImpl>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::InstallTriggerImpl>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::InstallTriggerImpl* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::InstallTriggerImpl>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::InstallTriggerImpl*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::InstallTriggerImpl> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::InstallTriggerImpl);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::InstallTriggerImpl);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "InstallTriggerImpl",
                              ShouldExpose<InstallTriggerImpl_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::InstallTriggerImpl,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::InstallTriggerImpl,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace InstallTriggerImpl_Binding



bool
InstallTriggerImplJSImpl::Enabled(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "InstallTriggerImpl.enabled", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return bool(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  InstallTriggerImplAtoms* atomsCache = GetAtomCache<InstallTriggerImplAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->enabled_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return bool(0);
  }
  bool rvalDecl;
  if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of InstallTriggerImpl.enabled", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return rvalDecl;
}

bool
InstallTriggerImplJSImpl::UpdateEnabled(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "InstallTriggerImpl.updateEnabled", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return bool(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  InstallTriggerImplAtoms* atomsCache = GetAtomCache<InstallTriggerImplAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->updateEnabled_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return bool(0);
  }
  bool rvalDecl;
  if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of InstallTriggerImpl.updateEnabled", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return rvalDecl;
}

bool
InstallTriggerImplJSImpl::Install(const Record<nsString, OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "InstallTriggerImpl.install", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return bool(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return bool(0);
  }
  unsigned argc = 2;

  do {
    if (callback.WasPassed()) {
      argv[1].setObjectOrNull(GetCallbackFromCallbackObject(cx, callback.Value()));
      if (!MaybeWrapObjectValue(cx, argv[1])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return bool(0);
      }
      break;
    } else if (argc == 2) {
      // This is our current trailing argument; reduce argc
      --argc;
    } else {
      argv[1].setUndefined();
    }
  } while (false);

  do {

    JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
    if (!returnObj) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (auto& entry : installs.Entries()) {
        auto& recordValue0 = entry.mValue;
        // Control block to let us common up the JS_DefineUCProperty calls when there
        // are different ways to succeed at wrapping the value.
        do {
          if (!recordValue0.ToJSVal(cx, returnObj, &tmp)) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return bool(0);
          }
          break;
        } while (false);
        if (!JS_DefineUCProperty(cx, returnObj,
                                 entry.mKey.BeginReading(),
                                 entry.mKey.Length(), tmp,
                                 JSPROP_ENUMERATE)) {
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return bool(0);
        }
      }
    }
    argv[0].setObject(*returnObj);
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  InstallTriggerImplAtoms* atomsCache = GetAtomCache<InstallTriggerImplAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->install_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return bool(0);
  }
  bool rvalDecl;
  if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of InstallTriggerImpl.install", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return rvalDecl;
}

bool
InstallTriggerImplJSImpl::InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "InstallTriggerImpl.installChrome", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return bool(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return bool(0);
  }
  unsigned argc = 3;

  do {
    if (!xpc::NonVoidStringToJsval(cx, skin, argv[2])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, url, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  do {
    argv[0].setInt32(int32_t(type));
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  InstallTriggerImplAtoms* atomsCache = GetAtomCache<InstallTriggerImplAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->installChrome_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return bool(0);
  }
  bool rvalDecl;
  if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of InstallTriggerImpl.installChrome", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return rvalDecl;
}

bool
InstallTriggerImplJSImpl::StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "InstallTriggerImpl.startSoftwareUpdate", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return bool(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return bool(0);
  }
  unsigned argc = 2;

  do {
    if (flags.WasPassed()) {
      argv[1].setInt32(int32_t(flags.Value()));
      break;
    } else if (argc == 2) {
      // This is our current trailing argument; reduce argc
      --argc;
    } else {
      argv[1].setUndefined();
    }
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, url, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  InstallTriggerImplAtoms* atomsCache = GetAtomCache<InstallTriggerImplAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->startSoftwareUpdate_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return bool(0);
  }
  bool rvalDecl;
  if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of InstallTriggerImpl.startSoftwareUpdate", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return rvalDecl;
}

bool
InstallTriggerImplJSImpl::InitIds(JSContext* cx, InstallTriggerImplAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->startSoftwareUpdate_id.init(cx, "startSoftwareUpdate") ||
      !atomsCache->installChrome_id.init(cx, "installChrome") ||
      !atomsCache->install_id.init(cx, "install") ||
      !atomsCache->updateEnabled_id.init(cx, "updateEnabled") ||
      !atomsCache->enabled_id.init(cx, "enabled")) {
    return false;
  }
  return true;
}



NS_IMPL_CYCLE_COLLECTION_WRAPPERCACHE_CLASS(InstallTriggerImpl)
NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN(InstallTriggerImpl)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mImpl)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mParent)
  NS_IMPL_CYCLE_COLLECTION_UNLINK_PRESERVED_WRAPPER
  tmp->ClearWeakReferences();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN(InstallTriggerImpl)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mImpl)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mParent)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END
NS_IMPL_CYCLE_COLLECTING_ADDREF(InstallTriggerImpl)
NS_IMPL_CYCLE_COLLECTING_RELEASE(InstallTriggerImpl)
NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(InstallTriggerImpl)
  NS_WRAPPERCACHE_INTERFACE_MAP_ENTRY
  NS_INTERFACE_MAP_ENTRY(nsISupports)
  NS_INTERFACE_MAP_ENTRY(nsISupportsWeakReference)
NS_INTERFACE_MAP_END

InstallTriggerImpl::InstallTriggerImpl(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent)
  : mImpl(new InstallTriggerImplJSImpl(nullptr, aJSImplObject, aJSImplGlobal, /* aIncumbentGlobal = */ nullptr)),
    mParent(aParent)
{
}


InstallTriggerImpl::~InstallTriggerImpl()
{
}

nsISupports*
InstallTriggerImpl::GetParentObject() const
{
  return mParent;
}

JSObject*
InstallTriggerImpl::WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  JS::Rooted<JSObject*> obj(aCx, InstallTriggerImpl_Binding::Wrap(aCx, this, aGivenProto));
  if (!obj) {
    return nullptr;
  }

  // Now define it on our chrome object
  JSAutoRealm ar(aCx, mImpl->CallbackGlobalOrNull());
  if (!JS_WrapObject(aCx, &obj)) {
    return nullptr;
  }
  JS::Rooted<JSObject*> callback(aCx, mImpl->CallbackOrNull());
  if (!JS_DefineProperty(aCx, callback, "__DOM_IMPL__", obj, 0)) {
    return nullptr;
  }
  return obj;
}

bool
InstallTriggerImpl::Enabled(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->Enabled(aRv, aRealm);
}

bool
InstallTriggerImpl::UpdateEnabled(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->UpdateEnabled(aRv, aRealm);
}

bool
InstallTriggerImpl::Install(const Record<nsString, OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->Install(installs, callback, aRv, aRealm);
}

bool
InstallTriggerImpl::InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->InstallChrome(type, url, skin, aRv, aRealm);
}

bool
InstallTriggerImpl::StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->StartSoftwareUpdate(url, flags, aRv, aRealm);
}

bool
InstallTriggerImpl::_Create(JSContext* cx, unsigned argc, JS::Value* vp)
{
  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  if (!args.requireAtLeast(cx, "InstallTriggerImpl._create", 2)) {
    return false;
  }
  BindingCallContext callCx(cx, "InstallTriggerImpl._create");
  if (!args[0].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
  }
  if (!args[1].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
  }

  // GlobalObject will go through wrappers as needed for us, and
  // is simpler than the right UnwrapArg incantation.
  GlobalObject global(cx, &args[0].toObject());
  if (global.Failed()) {
    return false;
  }
  nsCOMPtr<nsIGlobalObject> globalHolder = do_QueryInterface(global.GetAsSupports());
  MOZ_ASSERT(globalHolder);
  JS::Rooted<JSObject*> arg(cx, &args[1].toObject());
  JS::Rooted<JSObject*> argGlobal(cx, JS::CurrentGlobalOrNull(cx));
  RefPtr<InstallTriggerImpl> impl = new InstallTriggerImpl(arg, argGlobal, globalHolder);
  MOZ_ASSERT(js::IsObjectInContextCompartment(arg, cx));
  return GetOrCreateDOMReflector(cx, impl, args.rval());
}


} // namespace mozilla::dom
