/* This file was autogenerated by toolkit/crashreporter/generate_crash_reporter_sources.py. DO NOT EDIT */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef CrashAnnotations_h
#define CrashAnnotations_h

#include <cstddef>
#include <cstdint>

#include "mozilla/Maybe.h"
#include "nsStringFwd.h"

namespace CrashReporter {

using mozilla::Maybe;

// Typed enum representing all crash annotations
enum class Annotation : uint32_t {
  AbortMessage = 0,
  Accessibility = 1,
  AccessibilityClient = 2,
  AccessibilityInProcClient = 3,
  AdapterDeviceID = 4,
  AdapterDriverVendor = 5,
  AdapterDriverVersion = 6,
  AdapterSubsysID = 7,
  AdapterVendorID = 8,
  additional_minidumps = 9,
  Addons = 10,
  Android_Board = 11,
  Android_Brand = 12,
  Android_CPU_ABI = 13,
  Android_CPU_ABI2 = 14,
  Android_Device = 15,
  Android_Display = 16,
  Android_Fingerprint = 17,
  Android_Hardware = 18,
  Android_Manufacturer = 19,
  Android_Model = 20,
  Android_PackageName = 21,
  Android_Version = 22,
  AppInitDLLs = 23,
  ApplicationBuildID = 24,
  AsyncShutdownTimeout = 25,
  AvailablePageFile = 26,
  AvailablePhysicalMemory = 27,
  AvailableSwapMemory = 28,
  AvailableVirtualMemory = 29,
  BackgroundTaskMode = 30,
  BackgroundTaskName = 31,
  BlockedDllList = 32,
  BlocklistInitFailed = 33,
  Breadcrumbs = 34,
  BuildID = 35,
  Comments = 36,
  ContentSandboxCapabilities = 37,
  ContentSandboxCapable = 38,
  ContentSandboxEnabled = 39,
  ContentSandboxLevel = 40,
  ContentSandboxWin32kState = 41,
  CPUMicrocodeVersion = 42,
  CrashTime = 43,
  CycleCollector = 44,
  DesktopEnvironment = 45,
  DeviceResetReason = 46,
  DOMFissionEnabled = 47,
  DOMIPCEnabled = 48,
  DumperError = 49,
  EMCheckCompatibility = 50,
  EventLoopNestingLevel = 51,
  FontName = 52,
  GMPLibraryPath = 53,
  GMPPlugin = 54,
  GPUProcessLaunchCount = 55,
  GPUProcessStatus = 56,
  GpuSandboxLevel = 57,
  GraphicsCompileShader = 58,
  GraphicsCriticalError = 59,
  GraphicsDrawShader = 60,
  GraphicsNumActiveRenderers = 61,
  GraphicsNumRenderers = 62,
  GraphicsStartupTest = 63,
  Hang = 64,
  HasDeviceTouchScreen = 65,
  HeadlessMode = 66,
  InstallTime = 67,
  ipc_channel_error = 68,
  IpcCreatePipeCloExecErrno = 69,
  IpcCreatePipeFcntlErrno = 70,
  IpcCreatePipeSocketPairErrno = 71,
  IPCFatalErrorMsg = 72,
  IPCFatalErrorProtocol = 73,
  IPCMessageLargeBufferShmemFailureSize = 74,
  IPCMessageName = 75,
  IPCMessageSize = 76,
  IPCReadErrorReason = 77,
  IPCShutdownState = 78,
  IPCSystemError = 79,
  IsGarbageCollecting = 80,
  IsWayland = 81,
  IsWebRenderResourcePathOverridden = 82,
  JavaException = 83,
  JavaStackTrace = 84,
  JSActorMessage = 85,
  JSActorName = 86,
  JSLargeAllocationFailure = 87,
  JSModuleLoadError = 88,
  JSOutOfMemory = 89,
  LastInteractionDuration = 90,
  LastStartupWasCrash = 91,
  LauncherProcessState = 92,
  LinuxUnderMemoryPressure = 93,
  LowPhysicalMemoryEvents = 94,
  MacAvailableMemorySysctl = 95,
  MacMemoryPressure = 96,
  MacMemoryPressureCriticalTime = 97,
  MacMemoryPressureNormalTime = 98,
  MacMemoryPressureSysctl = 99,
  MacMemoryPressureWarningTime = 100,
  MainThreadRunnableName = 101,
  Marionette = 102,
  MemtestOutput = 103,
  ModuleSignatureInfo = 104,
  MozCrashReason = 105,
  NimbusEnrollments = 106,
  Notes = 107,
  OOMAllocationSize = 108,
  PHCAllocStack = 109,
  PHCBaseAddress = 110,
  PHCFreeStack = 111,
  PHCKind = 112,
  PHCUsableSize = 113,
  PluginFilename = 114,
  PluginName = 115,
  PluginVersion = 116,
  ProcessType = 117,
  ProductID = 118,
  ProductName = 119,
  ProfileDirectory = 120,
  ProfilerChildShutdownPhase = 121,
  PurgeablePhysicalMemory = 122,
  QuotaManagerShutdownTimeout = 123,
  QuotaManagerStorageIsNetworkResource = 124,
  RDDProcessStatus = 125,
  ReleaseChannel = 126,
  RemoteAgent = 127,
  RemoteType = 128,
  SafeMode = 129,
  SecondsSinceLastCrash = 130,
  ServerURL = 131,
  ShutdownProgress = 132,
  ShutdownReason = 133,
  StackTraces = 134,
  StartupCacheValid = 135,
  StartupCrash = 136,
  StartupTime = 137,
  StorageConnectionNotClosed = 138,
  SubmittedFrom = 139,
  SystemMemoryUsePercentage = 140,
  TelemetryClientId = 141,
  TelemetryEnvironment = 142,
  TelemetryProfileGroupId = 143,
  TelemetryServerURL = 144,
  TelemetrySessionId = 145,
  TestBoolean = 146,
  TestInteger = 147,
  TestKey = 148,
  TestUnicode = 149,
  TextureUsage = 150,
  Throttleable = 151,
  TotalPageFile = 152,
  TotalPhysicalMemory = 153,
  TotalVirtualMemory = 154,
  UnknownNetAddrSocketFamily = 155,
  UptimeTS = 156,
  URL = 157,
  URLSegments = 158,
  User32BeforeBlocklist = 159,
  useragent_locale = 160,
  UtilityActorsName = 161,
  UtilityProcessStatus = 162,
  Vendor = 163,
  Version = 164,
  VRProcessStatus = 165,
  WasmLibrarySandboxMallocFailed = 166,
  WindowsErrorReporting = 167,
  WindowsFileDialogErrorCode = 168,
  WindowsPackageFamilyName = 169,
  Winsock_LSP = 170,
  XPCOMSpinEventLoopStack = 171,
  Count = 172
};

// Stringified crash annotation names
const char* const kAnnotationStrings[] = {
  "AbortMessage",
  "Accessibility",
  "AccessibilityClient",
  "AccessibilityInProcClient",
  "AdapterDeviceID",
  "AdapterDriverVendor",
  "AdapterDriverVersion",
  "AdapterSubsysID",
  "AdapterVendorID",
  "additional_minidumps",
  "Add-ons",
  "Android_Board",
  "Android_Brand",
  "Android_CPU_ABI",
  "Android_CPU_ABI2",
  "Android_Device",
  "Android_Display",
  "Android_Fingerprint",
  "Android_Hardware",
  "Android_Manufacturer",
  "Android_Model",
  "Android_PackageName",
  "Android_Version",
  "AppInitDLLs",
  "ApplicationBuildID",
  "AsyncShutdownTimeout",
  "AvailablePageFile",
  "AvailablePhysicalMemory",
  "AvailableSwapMemory",
  "AvailableVirtualMemory",
  "BackgroundTaskMode",
  "BackgroundTaskName",
  "BlockedDllList",
  "BlocklistInitFailed",
  "Breadcrumbs",
  "BuildID",
  "Comments",
  "ContentSandboxCapabilities",
  "ContentSandboxCapable",
  "ContentSandboxEnabled",
  "ContentSandboxLevel",
  "ContentSandboxWin32kState",
  "CPUMicrocodeVersion",
  "CrashTime",
  "CycleCollector",
  "DesktopEnvironment",
  "DeviceResetReason",
  "DOMFissionEnabled",
  "DOMIPCEnabled",
  "DumperError",
  "EMCheckCompatibility",
  "EventLoopNestingLevel",
  "FontName",
  "GMPLibraryPath",
  "GMPPlugin",
  "GPUProcessLaunchCount",
  "GPUProcessStatus",
  "GpuSandboxLevel",
  "GraphicsCompileShader",
  "GraphicsCriticalError",
  "GraphicsDrawShader",
  "GraphicsNumActiveRenderers",
  "GraphicsNumRenderers",
  "GraphicsStartupTest",
  "Hang",
  "HasDeviceTouchScreen",
  "HeadlessMode",
  "InstallTime",
  "ipc_channel_error",
  "IpcCreatePipeCloExecErrno",
  "IpcCreatePipeFcntlErrno",
  "IpcCreatePipeSocketPairErrno",
  "IPCFatalErrorMsg",
  "IPCFatalErrorProtocol",
  "IPCMessageLargeBufferShmemFailureSize",
  "IPCMessageName",
  "IPCMessageSize",
  "IPCReadErrorReason",
  "IPCShutdownState",
  "IPCSystemError",
  "IsGarbageCollecting",
  "IsWayland",
  "IsWebRenderResourcePathOverridden",
  "JavaException",
  "JavaStackTrace",
  "JSActorMessage",
  "JSActorName",
  "JSLargeAllocationFailure",
  "JSModuleLoadError",
  "JSOutOfMemory",
  "LastInteractionDuration",
  "LastStartupWasCrash",
  "LauncherProcessState",
  "LinuxUnderMemoryPressure",
  "LowPhysicalMemoryEvents",
  "MacAvailableMemorySysctl",
  "MacMemoryPressure",
  "MacMemoryPressureCriticalTime",
  "MacMemoryPressureNormalTime",
  "MacMemoryPressureSysctl",
  "MacMemoryPressureWarningTime",
  "MainThreadRunnableName",
  "Marionette",
  "MemtestOutput",
  "ModuleSignatureInfo",
  "MozCrashReason",
  "NimbusEnrollments",
  "Notes",
  "OOMAllocationSize",
  "PHCAllocStack",
  "PHCBaseAddress",
  "PHCFreeStack",
  "PHCKind",
  "PHCUsableSize",
  "PluginFilename",
  "PluginName",
  "PluginVersion",
  "ProcessType",
  "ProductID",
  "ProductName",
  "ProfileDirectory",
  "ProfilerChildShutdownPhase",
  "PurgeablePhysicalMemory",
  "QuotaManagerShutdownTimeout",
  "QuotaManagerStorageIsNetworkResource",
  "RDDProcessStatus",
  "ReleaseChannel",
  "RemoteAgent",
  "RemoteType",
  "SafeMode",
  "SecondsSinceLastCrash",
  "ServerURL",
  "ShutdownProgress",
  "ShutdownReason",
  "StackTraces",
  "StartupCacheValid",
  "StartupCrash",
  "StartupTime",
  "StorageConnectionNotClosed",
  "SubmittedFrom",
  "SystemMemoryUsePercentage",
  "TelemetryClientId",
  "TelemetryEnvironment",
  "TelemetryProfileGroupId",
  "TelemetryServerURL",
  "TelemetrySessionId",
  "TestBoolean",
  "TestInteger",
  "TestKey",
  "TestUnicode",
  "TextureUsage",
  "Throttleable",
  "TotalPageFile",
  "TotalPhysicalMemory",
  "TotalVirtualMemory",
  "UnknownNetAddrSocketFamily",
  "UptimeTS",
  "URL",
  "URLSegments",
  "User32BeforeBlocklist",
  "useragent_locale",
  "UtilityActorsName",
  "UtilityProcessStatus",
  "Vendor",
  "Version",
  "VRProcessStatus",
  "WasmLibrarySandboxMallocFailed",
  "WindowsErrorReporting",
  "WindowsFileDialogErrorCode",
  "WindowsPackageFamilyName",
  "Winsock_LSP",
  "XPCOMSpinEventLoopStack"
};

// Type of each annotation
enum class AnnotationType : uint8_t {
  String = 0,   // Any type of string, const char*, nsCString, etc...
  Boolean = 1,  // Stored as a byte
  U32 = 2,      // C/C++'s uint32_t or Rust's u32
  U64 = 3,      // C/C++'s uint64_t or Rust's u64
  USize = 4,    // C/C++'s size_t or Rust's usize
  Object = 5,   // Not able to be read/written from the C++ API.
};

// Type of each annotation
const AnnotationType kAnnotationTypes[] = {
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U64,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U64,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Object,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U64,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::USize,
  AnnotationType::Boolean,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::USize,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::Boolean,
  AnnotationType::Boolean,
  AnnotationType::U32,
  AnnotationType::String,
  AnnotationType::String,
  AnnotationType::String
};

// Allowlist of crash annotations that can be included in a crash ping
const Annotation kCrashPingAllowedList[] = {
  Annotation::AsyncShutdownTimeout,
  Annotation::AvailablePageFile,
  Annotation::AvailablePhysicalMemory,
  Annotation::AvailableSwapMemory,
  Annotation::AvailableVirtualMemory,
  Annotation::BackgroundTaskName,
  Annotation::BlockedDllList,
  Annotation::BlocklistInitFailed,
  Annotation::BuildID,
  Annotation::CrashTime,
  Annotation::DOMFissionEnabled,
  Annotation::EventLoopNestingLevel,
  Annotation::FontName,
  Annotation::GPUProcessLaunchCount,
  Annotation::Hang,
  Annotation::HeadlessMode,
  Annotation::ipc_channel_error,
  Annotation::IsGarbageCollecting,
  Annotation::LastInteractionDuration,
  Annotation::LowPhysicalMemoryEvents,
  Annotation::MainThreadRunnableName,
  Annotation::MozCrashReason,
  Annotation::NimbusEnrollments,
  Annotation::OOMAllocationSize,
  Annotation::ProductID,
  Annotation::ProductName,
  Annotation::ProfilerChildShutdownPhase,
  Annotation::PurgeablePhysicalMemory,
  Annotation::QuotaManagerShutdownTimeout,
  Annotation::ReleaseChannel,
  Annotation::RemoteType,
  Annotation::SecondsSinceLastCrash,
  Annotation::ShutdownProgress,
  Annotation::ShutdownReason,
  Annotation::StartupCrash,
  Annotation::SystemMemoryUsePercentage,
  Annotation::TextureUsage,
  Annotation::TotalPageFile,
  Annotation::TotalPhysicalMemory,
  Annotation::TotalVirtualMemory,
  Annotation::UptimeTS,
  Annotation::User32BeforeBlocklist,
  Annotation::UtilityActorsName,
  Annotation::Version,
  Annotation::WindowsErrorReporting,
  Annotation::WindowsFileDialogErrorCode,
  Annotation::WindowsPackageFamilyName
};

// Allowlist of crash annotations that can be included in a crash report
// (excludes those in kCrashPingAllowedList).
const Annotation kCrashReportAllowedList[] = {
  Annotation::AbortMessage,
  Annotation::Accessibility,
  Annotation::AccessibilityClient,
  Annotation::AccessibilityInProcClient,
  Annotation::AdapterDeviceID,
  Annotation::AdapterDriverVendor,
  Annotation::AdapterDriverVersion,
  Annotation::AdapterSubsysID,
  Annotation::AdapterVendorID,
  Annotation::additional_minidumps,
  Annotation::Addons,
  Annotation::Android_Board,
  Annotation::Android_Brand,
  Annotation::Android_CPU_ABI,
  Annotation::Android_CPU_ABI2,
  Annotation::Android_Device,
  Annotation::Android_Display,
  Annotation::Android_Fingerprint,
  Annotation::Android_Hardware,
  Annotation::Android_Manufacturer,
  Annotation::Android_Model,
  Annotation::Android_PackageName,
  Annotation::Android_Version,
  Annotation::AppInitDLLs,
  Annotation::ApplicationBuildID,
  Annotation::BackgroundTaskMode,
  Annotation::Breadcrumbs,
  Annotation::Comments,
  Annotation::ContentSandboxCapabilities,
  Annotation::ContentSandboxCapable,
  Annotation::ContentSandboxEnabled,
  Annotation::ContentSandboxLevel,
  Annotation::ContentSandboxWin32kState,
  Annotation::CPUMicrocodeVersion,
  Annotation::CycleCollector,
  Annotation::DesktopEnvironment,
  Annotation::DeviceResetReason,
  Annotation::DOMIPCEnabled,
  Annotation::DumperError,
  Annotation::EMCheckCompatibility,
  Annotation::GMPLibraryPath,
  Annotation::GMPPlugin,
  Annotation::GPUProcessStatus,
  Annotation::GpuSandboxLevel,
  Annotation::GraphicsCompileShader,
  Annotation::GraphicsCriticalError,
  Annotation::GraphicsDrawShader,
  Annotation::GraphicsNumActiveRenderers,
  Annotation::GraphicsNumRenderers,
  Annotation::GraphicsStartupTest,
  Annotation::HasDeviceTouchScreen,
  Annotation::InstallTime,
  Annotation::IpcCreatePipeCloExecErrno,
  Annotation::IpcCreatePipeFcntlErrno,
  Annotation::IpcCreatePipeSocketPairErrno,
  Annotation::IPCFatalErrorMsg,
  Annotation::IPCFatalErrorProtocol,
  Annotation::IPCMessageLargeBufferShmemFailureSize,
  Annotation::IPCMessageName,
  Annotation::IPCMessageSize,
  Annotation::IPCReadErrorReason,
  Annotation::IPCShutdownState,
  Annotation::IPCSystemError,
  Annotation::IsWayland,
  Annotation::IsWebRenderResourcePathOverridden,
  Annotation::JavaException,
  Annotation::JavaStackTrace,
  Annotation::JSActorMessage,
  Annotation::JSActorName,
  Annotation::JSLargeAllocationFailure,
  Annotation::JSModuleLoadError,
  Annotation::JSOutOfMemory,
  Annotation::LastStartupWasCrash,
  Annotation::LauncherProcessState,
  Annotation::LinuxUnderMemoryPressure,
  Annotation::MacAvailableMemorySysctl,
  Annotation::MacMemoryPressure,
  Annotation::MacMemoryPressureCriticalTime,
  Annotation::MacMemoryPressureNormalTime,
  Annotation::MacMemoryPressureSysctl,
  Annotation::MacMemoryPressureWarningTime,
  Annotation::Marionette,
  Annotation::MemtestOutput,
  Annotation::ModuleSignatureInfo,
  Annotation::Notes,
  Annotation::PHCAllocStack,
  Annotation::PHCBaseAddress,
  Annotation::PHCFreeStack,
  Annotation::PHCKind,
  Annotation::PHCUsableSize,
  Annotation::PluginFilename,
  Annotation::PluginName,
  Annotation::PluginVersion,
  Annotation::ProcessType,
  Annotation::QuotaManagerStorageIsNetworkResource,
  Annotation::RDDProcessStatus,
  Annotation::RemoteAgent,
  Annotation::SafeMode,
  Annotation::StartupCacheValid,
  Annotation::StartupTime,
  Annotation::StorageConnectionNotClosed,
  Annotation::SubmittedFrom,
  Annotation::TelemetryEnvironment,
  Annotation::TestBoolean,
  Annotation::TestInteger,
  Annotation::TestKey,
  Annotation::TestUnicode,
  Annotation::Throttleable,
  Annotation::UnknownNetAddrSocketFamily,
  Annotation::URL,
  Annotation::URLSegments,
  Annotation::useragent_locale,
  Annotation::UtilityProcessStatus,
  Annotation::Vendor,
  Annotation::VRProcessStatus,
  Annotation::WasmLibrarySandboxMallocFailed,
  Annotation::Winsock_LSP,
  Annotation::XPCOMSpinEventLoopStack
};

// Annotations which should be skipped when they have specific values
struct AnnotationSkipValue {
  Annotation annotation;
  const char* value;
};

const AnnotationSkipValue kSkipIfList[] = {
  { Annotation::BlocklistInitFailed, "0" },
  { Annotation::EventLoopNestingLevel, "0" },
  { Annotation::IsGarbageCollecting, "0" },
  { Annotation::LowPhysicalMemoryEvents, "0" },
  { Annotation::OOMAllocationSize, "0" },
  { Annotation::TextureUsage, "0" },
  { Annotation::User32BeforeBlocklist, "0" }
};

/**
 * Return the type of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns The type of this annotation
 */
static inline AnnotationType TypeOfAnnotation(Annotation aAnnotation) {
  return kAnnotationTypes[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Return the string representation of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns A constant string holding the annotation name
 */
static inline const char* AnnotationToString(Annotation aAnnotation) {
  return kAnnotationStrings[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Converts a string to its corresponding crash annotation.
 *
 * @param aValue the string to be converted
 * @return the annotation corresponding to the string or nothing
 */
Maybe<Annotation> AnnotationFromString(const nsACString& aValue);

/**
 * Checks if the given crash annotation is allowed for inclusion in a crash
 * ping.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in a crash ping, false
 *         otherwise
 */
bool IsAnnotationAllowedForPing(Annotation aAnnotation);

/**
 * Checks if the given crash annotation is allowed for inclusion in a crash
 * report.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in a crash report, false
 *         otherwise
 */
bool IsAnnotationAllowedForReport(Annotation aAnnotation);

/**
 * Checks if the annotation should be included. Some annotations are skipped if
 * their value matches a specific one (like the value 0).
 *
 * @param aAnnotation the crash annotation to be checked
 * @param aValue the contents of the annotation as a string
 * @return true if the annotation should be included, false otherwise
 */
bool ShouldIncludeAnnotation(Annotation aAnnotation, const char* aValue);

/**
 * Abstract annotation writer, this is needed only for code that writes out
 * annotations in the exception handler.
 */
class AnnotationWriter {
 public:
  virtual void Write(Annotation aAnnotation, const char* aValue,
                     size_t aLen = 0) = 0;
  virtual void Write(Annotation aAnnotation, bool aValue) = 0;
  virtual void Write(Annotation aAnnotation, uint64_t aValue) = 0;
};

#ifdef XP_WIN

extern void RecordDllAnnotations(bool* aBlocklistInitFailed,
                                 bool* aUser32BeforeBlocklist);

#endif  // XP_WIN

}  // namespace CrashReporter

#endif  // CrashAnnotations_h
