// -*- mode: Rust -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

use crate::private::Ping;
use once_cell::sync::Lazy;

#[allow(non_upper_case_globals)]
/// This is a ping representing single events triggered by the messaging system
/// and captures some pings from About:Welcome, ASRouter, and other corners.
pub static messaging_system: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "messaging-system",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// Newtab-related instrumentation.
/// Can be disabled via the `newtabPingEnabled` variable of the `glean` Nimbus
/// feature, or the `browser.newtabpage.ping.enabled` pref.
pub static newtab: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "newtab",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["component_init".into(), "newtab_session_end".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping for submitting the pocket sponsored content's `shim`.
/// Does not contain a `client_id`.
pub static spoc: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "spoc",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["click".into(), "impression".into(), "save".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing a single event happening with or to a TopSite.
/// Distinguishable by its `ping_type`.
/// Does not contain a `client_id`, preferring a `context_id` instead.
pub static top_sites: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "top-sites",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// Reinstrumentation of the Activity Stream "pocket-button" ping.
/// Submitted when actions are taken around the pocket button.
/// Does not contain any `client_id`.
/// Instead uses an `impression_id`.
pub static pocket_button: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "pocket-button",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing a "This time, search with" event with a partner search.
/// Does not contain a `client_id`, preferring a `context_id` instead.
/// The `context_id` is used internally for counting unique sers as well as for
/// anti-fraud. It is shared with other Contextual Services. It is not shared
/// externally.
pub static search_with: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "search-with",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing a series of SERP loads that have been categorized. Does
/// not contain `client_id`. Is sent after a threshold of SERP loads is reached.
pub static serp_categorization: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "serp-categorization",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec!["inactivity".into(), "startup".into(), "threshold_reached".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing an impression, selection, or dismissmal of an AMP
/// suggestion. It contains metrics in the `quick_suggest` category. Its type is
/// defined in the `ping_type` metric. It does not contain a `client_id`,
/// preferring a `context_id` instead. `follows_collection_enabled` is set to
/// false because the ping is conditioned on Suggest and AMP suggestions being
/// enabled. It will be enabled when Suggest and AMP suggestions are enabled and
/// it will be disabled otherwise. When it becomes disabled, a separate
/// `quick-suggest-deletion-request` ping will be submitted.
pub static quick_suggest: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "quick-suggest",
        false,
        false,
        true,
        true,
        false,
        vec![],
        vec![],
        false,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when either AMP suggestions or the entire Suggest
/// feature becomes disabled. Like the `quick-suggest` ping, it will contain a
/// `context_id` metric in the `quick_suggest` category.
pub static quick_suggest_deletion_request: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "quick-suggest-deletion-request",
        false,
        false,
        true,
        true,
        false,
        vec![],
        vec![],
        false,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted only when urlbar keyword exposures are enabled. See
/// the `keywordExposureResults` urlbar Nimbus variable. When enabled, the ping
/// is submitted at the end of urlbar sessions during which one or more exposure
/// results are matched. (A "session" begins when the user focuses the urlbar
/// and ends with an engagement or abandonment.) Exposure results include all
/// results defined in the `exposureResults` variable. They also include the
/// "rust_exposure" result type if the `quickSuggestExposureSuggestionTypes`
/// variable is defined. The ping will contain one `urlbar.keyword_exposure`
/// event for each instance where a result is matched during the session. The
/// ping is not submitted for sessions in private windows.
pub static urlbar_keyword_exposure: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "urlbar-keyword-exposure",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// **Prototype-only ping not for general use!**
/// Transport for no-code Firefox Desktop frontend instrumentation,
/// should mostly contain no-code events in browser.ui.* categories.
/// Submitted whenever the next flow of events begins (including startup).
pub static prototype_no_code_events: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "prototype-no-code-events",
        true,
        false,
        true,
        true,
        false,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// Instrumentation collected during a page load.
pub static pageload: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "pageload",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["startup".into(), "threshold".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// Collects counts of uses of web platform features.
/// See [Use Counters Documentation](https://firefox-source-docs.mozilla.org/dom/use-counters.html)
/// for more information.
pub static use_counters: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "use-counters",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["app_shutdown_confirmed".into(), "idle_startup".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping for information about Mozilla Account usage. Sent at the same cadence
/// as the baseline ping.
pub static fx_accounts: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "fx-accounts",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["active".into(), "dirty_startup".into(), "inactive".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing Bounce Tracking Protection stats.  Note that this
/// ping does not include client_id.  More details are available in Bug 1889444
pub static bounce_tracking_protection: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "bounce-tracking-protection",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is generic for background tasks. Each background task can
/// gather its metrics under this ping and submit it when the task finishes.
/// Note that the ping submission must be done manually.
pub static background_tasks: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "background-tasks",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is used to analyze the occurrence of CAPTCHAs in the wild
/// by users' protection settings.
pub static captcha_detection: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "captcha-detection",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping to report crash information. This information is sent as soon as possible after a crash occurs (whether the crash is a background/content process or the main process). It is expected to be used for crash report analysis and to reduce blind spots in crash reporting.
pub static crash: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "crash",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["crash".into(), "event_found".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// Minimal ping to measure DAU.
/// Sent on the baseline schedule.
/// 
/// **NOTE**: This ping is deprecated and replaced by the `usage-reporting` ping.
pub static dau_reporting: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "dau-reporting",
        false,
        true,
        true,
        true,
        true,
        vec![],
        vec!["active".into(), "dirty_startup".into(), "inactive".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static collection_disabled_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "collection-disabled-ping",
        false,
        true,
        true,
        true,
        false,
        vec![],
        vec![],
        false,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static disabled_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "disabled-ping",
        false,
        true,
        true,
        true,
        false,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static one_ping_only: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "one-ping-only",
        false,
        true,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static ride_along_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "ride-along-ping",
        false,
        true,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
/// Resembles how OHTTP pings are defined.
pub static test_ohttp_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "test-ohttp-ping",
        false,
        true,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is for tests only.
pub static test_ping: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "test-ping",
        false,
        true,
        true,
        true,
        true,
        vec!["ride-along-ping".into()],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// Sent by Nimbus during every experiment update cycle.
pub static nimbus_targeting_context: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "nimbus-targeting-context",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping containing the data for a user-initiated report for a broken site.
/// Does not contain a `client_id`. All report data is self-contained.
pub static broken_site_report: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "broken-site-report",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// A ping representing user hardware and software settings.  Note that this
/// ping does not include client_id.  More details are available in Bug 1879151
pub static user_characteristics: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "user-characteristics",
        false,
        false,
        true,
        false,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when a user opts out of sending Firefox
/// technical and usage telemetry to Mozilla specifically during
/// preonboarding.  (After preonboarding, opting out of sending
/// technical and usage telemetry triggers a `deletion-request` ping.)
/// Sent in response to user action.
pub static onboarding_opt_out: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "onboarding-opt-out",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec!["set_upload_enabled".into()],
        false,
    )
});

#[allow(non_upper_case_globals)]
/// This ping is submitted when a user opts out of sending usage
/// frequency of Firefox to Mozilla.
/// Sent in response to user action.
pub static usage_deletion_request: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "usage-deletion-request",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec!["set_upload_enabled".into()],
        false,
    )
});

#[allow(non_upper_case_globals)]
/// Minimal ping to measure the usage frequency of Firefox.
/// Sent on the baseline schedule.
pub static usage_reporting: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "usage-reporting",
        false,
        true,
        true,
        false,
        false,
        vec![],
        vec!["active".into(), "dirty_startup".into(), "inactive".into()],
        false,
    )
});

#[allow(non_upper_case_globals)]
/// Sent during startup if Firefox was launched by the installer.
pub static first_startup: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "first-startup",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec![],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This opt-out ping is sent from the Default Agent, which is a Windows-only Firefox Background Task that is registered during Firefox installation with the Windows scheduled tasks system so that it runs automatically every 24 hours, whether Firefox is running or not.
/// Opting out of telemetry is handled via the pref value being copied to the registry so that the Default Agent can read it without needing to work with profiles. Relevant policies are consulted as well. The agent also has its own pref, `default-agent.enabled`, which if set to false disables all agent functionality, including generating this ping.
/// Each installation of Firefox has its own copy of the agent and its own scheduled task which shares a common `LastPingSentAt` user registry key with other installations. Installations race to send a single ping per 24 hour window per installing user. If multiple operating system-level users are all using one copy of Firefox, only one scheduled task will have been created and only one ping will be sent, even though the users might have different default browser settings. If multiple users have installed Firefox then each installing user will have a scheduled task and ping.
/// Additional information for the Default Agent can be found in the [Default Browser Agent docs](https://firefox-source-docs.mozilla.org/toolkit/mozapps/defaultagent/default-browser-agent/index.html).
pub static default_agent: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "default-agent",
        false,
        false,
        true,
        true,
        true,
        vec![],
        vec!["daily_ping".into()],
        true,
    )
});

#[allow(non_upper_case_globals)]
/// This ping measures the technical health of the background update system.
/// Said system downloads and processes updates when Firefox is not running.  It
/// is expected that this ping will be analyzed by humans to gain confidence in
/// the implementation as the staged rollout of the system proceeds to the
/// release channel, before settling into an automated analysis to detect spikes
/// in background update failure rates.  This ping will also help to
/// characterize the update-related settings of our user population.
/// 
/// Right now the background update system, and therefore this ping, is
/// restricted to Windows.
/// 
/// This ping is submitted only by the background update task.  It should be
/// submitted once per background update task invocation.  The expected schedule
/// is every 7 hours, controlled by the pref `app.update.background.interval`,
/// and subject to scheduling decisions made by the OS.
pub static background_update: Lazy<Ping> = Lazy::new(|| {
    Ping::new(
        "background-update",
        true,
        false,
        true,
        true,
        true,
        vec![],
        vec!["backgroundupdate_task".into()],
        true,
    )
});


/// Instantiate custom pings once to trigger registration.
///
/// # Arguments
///
/// application_id: If present, limit to only registering custom pings
///                 assigned to the identified application.
#[doc(hidden)]
pub fn register_pings(application_id: Option<&str>) {
    match application_id {
        Some("firefox.desktop") => {
            log::info!("Registering pings bounce-tracking-protection, broken-site-report, captcha-detection, collection-disabled-ping, crash, dau-reporting, disabled-ping, first-startup, fx-accounts, messaging-system, newtab, nimbus-targeting-context, onboarding-opt-out, one-ping-only, pageload, pocket-button, prototype-no-code-events, quick-suggest, quick-suggest-deletion-request, ride-along-ping, search-with, serp-categorization, spoc, test-ohttp-ping, test-ping, top-sites, urlbar-keyword-exposure, usage-deletion-request, usage-reporting, use-counters, user-characteristics for firefox.desktop");
            let _ = &*bounce_tracking_protection;
            let _ = &*broken_site_report;
            let _ = &*captcha_detection;
            let _ = &*collection_disabled_ping;
            let _ = &*crash;
            let _ = &*dau_reporting;
            let _ = &*disabled_ping;
            let _ = &*first_startup;
            let _ = &*fx_accounts;
            let _ = &*messaging_system;
            let _ = &*newtab;
            let _ = &*nimbus_targeting_context;
            let _ = &*onboarding_opt_out;
            let _ = &*one_ping_only;
            let _ = &*pageload;
            let _ = &*pocket_button;
            let _ = &*prototype_no_code_events;
            let _ = &*quick_suggest;
            let _ = &*quick_suggest_deletion_request;
            let _ = &*ride_along_ping;
            let _ = &*search_with;
            let _ = &*serp_categorization;
            let _ = &*spoc;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*top_sites;
            let _ = &*urlbar_keyword_exposure;
            let _ = &*usage_deletion_request;
            let _ = &*usage_reporting;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        Some("firefox.desktop.background.update") => {
            log::info!("Registering pings background-update, bounce-tracking-protection, captcha-detection, collection-disabled-ping, crash, dau-reporting, disabled-ping, one-ping-only, pageload, ride-along-ping, test-ohttp-ping, test-ping, use-counters, user-characteristics for firefox.desktop.background.update");
            let _ = &*background_update;
            let _ = &*bounce_tracking_protection;
            let _ = &*captcha_detection;
            let _ = &*collection_disabled_ping;
            let _ = &*crash;
            let _ = &*dau_reporting;
            let _ = &*disabled_ping;
            let _ = &*one_ping_only;
            let _ = &*pageload;
            let _ = &*ride_along_ping;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        Some("firefox.desktop.background.tasks") => {
            log::info!("Registering pings background-tasks, bounce-tracking-protection, captcha-detection, crash, dau-reporting, default-agent, nimbus-targeting-context, pageload, use-counters, user-characteristics for firefox.desktop.background.tasks");
            let _ = &*background_tasks;
            let _ = &*bounce_tracking_protection;
            let _ = &*captcha_detection;
            let _ = &*crash;
            let _ = &*dau_reporting;
            let _ = &*default_agent;
            let _ = &*nimbus_targeting_context;
            let _ = &*pageload;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        Some("gecko") => {
            log::info!("Registering pings bounce-tracking-protection, captcha-detection, collection-disabled-ping, dau-reporting, disabled-ping, one-ping-only, pageload, ride-along-ping, test-ohttp-ping, test-ping, use-counters, user-characteristics for gecko");
            let _ = &*bounce_tracking_protection;
            let _ = &*captcha_detection;
            let _ = &*collection_disabled_ping;
            let _ = &*dau_reporting;
            let _ = &*disabled_ping;
            let _ = &*one_ping_only;
            let _ = &*pageload;
            let _ = &*ride_along_ping;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*use_counters;
            let _ = &*user_characteristics;
        },
        _ => {
            let _ = &*messaging_system;
            let _ = &*newtab;
            let _ = &*spoc;
            let _ = &*top_sites;
            let _ = &*pocket_button;
            let _ = &*search_with;
            let _ = &*serp_categorization;
            let _ = &*quick_suggest;
            let _ = &*quick_suggest_deletion_request;
            let _ = &*urlbar_keyword_exposure;
            let _ = &*prototype_no_code_events;
            let _ = &*pageload;
            let _ = &*use_counters;
            let _ = &*fx_accounts;
            let _ = &*bounce_tracking_protection;
            let _ = &*background_tasks;
            let _ = &*captcha_detection;
            let _ = &*crash;
            let _ = &*dau_reporting;
            let _ = &*collection_disabled_ping;
            let _ = &*disabled_ping;
            let _ = &*one_ping_only;
            let _ = &*ride_along_ping;
            let _ = &*test_ohttp_ping;
            let _ = &*test_ping;
            let _ = &*nimbus_targeting_context;
            let _ = &*broken_site_report;
            let _ = &*user_characteristics;
            let _ = &*onboarding_opt_out;
            let _ = &*usage_deletion_request;
            let _ = &*usage_reporting;
            let _ = &*first_startup;
            let _ = &*default_agent;
            let _ = &*background_update;
        }
    }
    extern "C" {
        fn JOG_MaybeReload();
    }
    unsafe {
      JOG_MaybeReload();
    }
}

/// Map from pings to the pings scheduled along with them.
///
#[doc(hidden)]
pub fn ping_schedule() -> std::collections::HashMap<String, Vec<String>> {
  std::collections::HashMap::from([
      (
        "baseline".into(),
        vec!["fx-accounts".into(), "usage-reporting".into()]
      ),
      (
        "test-ping".into(),
        vec!["ride-along-ping".into()]
      ),
  ])
}

#[cfg(feature = "with_gecko")]
pub(crate) fn submit_ping_by_id(id: u32, reason: Option<&str>) {
    if id & (1 << crate::factory::DYNAMIC_PING_BIT) > 0 {
        let map = crate::factory::__jog_metric_maps::PING_MAP
            .read()
            .expect("Read lock for dynamic ping map was poisoned!");
        if let Some(ping) = map.get(&id) {
            ping.submit(reason);
        } else {
            // TODO: instrument this error.
            log::error!("Cannot submit unknown dynamic ping {} by id.", id);
        }
        return;
    }
    match id {
        1 => messaging_system.submit(reason),
        2 => newtab.submit(reason),
        3 => spoc.submit(reason),
        4 => top_sites.submit(reason),
        5 => pocket_button.submit(reason),
        6 => search_with.submit(reason),
        7 => serp_categorization.submit(reason),
        8 => quick_suggest.submit(reason),
        9 => quick_suggest_deletion_request.submit(reason),
        10 => urlbar_keyword_exposure.submit(reason),
        11 => prototype_no_code_events.submit(reason),
        12 => pageload.submit(reason),
        13 => use_counters.submit(reason),
        14 => fx_accounts.submit(reason),
        15 => bounce_tracking_protection.submit(reason),
        16 => background_tasks.submit(reason),
        17 => captcha_detection.submit(reason),
        18 => crash.submit(reason),
        19 => dau_reporting.submit(reason),
        20 => collection_disabled_ping.submit(reason),
        21 => disabled_ping.submit(reason),
        22 => one_ping_only.submit(reason),
        23 => ride_along_ping.submit(reason),
        24 => test_ohttp_ping.submit(reason),
        25 => test_ping.submit(reason),
        26 => nimbus_targeting_context.submit(reason),
        27 => broken_site_report.submit(reason),
        28 => user_characteristics.submit(reason),
        29 => onboarding_opt_out.submit(reason),
        30 => usage_deletion_request.submit(reason),
        31 => usage_reporting.submit(reason),
        32 => first_startup.submit(reason),
        33 => default_agent.submit(reason),
        34 => background_update.submit(reason),
        _ => {
            // TODO: instrument this error.
            log::error!("Cannot submit unknown ping {} by id.", id);
        }
    }
}

#[cfg(feature = "with_gecko")]
pub(crate) fn set_ping_enabled_by_id(id: u32, enabled: bool) {
    if id & (1 << crate::factory::DYNAMIC_PING_BIT) > 0 {
        let map = crate::factory::__jog_metric_maps::PING_MAP
            .read()
            .expect("Read lock for dynamic ping map was poisoned!");
        if let Some(ping) = map.get(&id) {
            ping.set_enabled(enabled);
        } else {
            // TODO: instrument this error.
            log::error!("Cannot set_enabled on unknown dynamic ping {} by id.", id);
        }
        return;
    }
    match id {
        1 => messaging_system.set_enabled(enabled),
        2 => newtab.set_enabled(enabled),
        3 => spoc.set_enabled(enabled),
        4 => top_sites.set_enabled(enabled),
        5 => pocket_button.set_enabled(enabled),
        6 => search_with.set_enabled(enabled),
        7 => serp_categorization.set_enabled(enabled),
        8 => quick_suggest.set_enabled(enabled),
        9 => quick_suggest_deletion_request.set_enabled(enabled),
        10 => urlbar_keyword_exposure.set_enabled(enabled),
        11 => prototype_no_code_events.set_enabled(enabled),
        12 => pageload.set_enabled(enabled),
        13 => use_counters.set_enabled(enabled),
        14 => fx_accounts.set_enabled(enabled),
        15 => bounce_tracking_protection.set_enabled(enabled),
        16 => background_tasks.set_enabled(enabled),
        17 => captcha_detection.set_enabled(enabled),
        18 => crash.set_enabled(enabled),
        19 => dau_reporting.set_enabled(enabled),
        20 => collection_disabled_ping.set_enabled(enabled),
        21 => disabled_ping.set_enabled(enabled),
        22 => one_ping_only.set_enabled(enabled),
        23 => ride_along_ping.set_enabled(enabled),
        24 => test_ohttp_ping.set_enabled(enabled),
        25 => test_ping.set_enabled(enabled),
        26 => nimbus_targeting_context.set_enabled(enabled),
        27 => broken_site_report.set_enabled(enabled),
        28 => user_characteristics.set_enabled(enabled),
        29 => onboarding_opt_out.set_enabled(enabled),
        30 => usage_deletion_request.set_enabled(enabled),
        31 => usage_reporting.set_enabled(enabled),
        32 => first_startup.set_enabled(enabled),
        33 => default_agent.set_enabled(enabled),
        34 => background_update.set_enabled(enabled),
        _ => {
            // TODO: instrument this error.
            log::error!("Cannot set_enabled on unknown ping {} by id.", id);
        }
    }
}
