// -*- mode: Rust -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */


pub enum DynamicLabel { }

pub mod a11y {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from a11y.always_underline_links
    ///
    /// Bool tracking if the user has always underline links enabled in firefox. This metric was generated to correspond to the Legacy Telemetry scalar a11y.always_underline_links.
    pub static always_underline_links: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "always_underline_links".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(1), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.backplate
    ///
    /// Boolean tracking if the user has the backplate preference enabled or disabled. This metric was generated to correspond to the Legacy Telemetry scalar a11y.backplate.
    pub static backplate: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "backplate".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(2), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.consumers
    ///
    /// A list of known accessibility clients that inject into Firefox process space (see https://searchfox.org/mozilla-central/source/accessible/windows/msaa/Compatibility.h).
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram A11Y_CONSUMERS.
    pub static consumers: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "consumers".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(3), meta, 0, 11, 12, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.hcm_background
    ///
    /// Unsigned int tracking the user's prefered background color \ (logged when HCM is enabled). This metric was generated to correspond to the Legacy Telemetry scalar a11y.HCM_background.
    pub static hcm_background: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "hcm_background".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(4), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.hcm_foreground
    ///
    /// Unsigned int tracking the user's prefered foreground color \ (logged when HCM is enabled). This metric was generated to correspond to the Legacy Telemetry scalar a11y.HCM_foreground.
    pub static hcm_foreground: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "hcm_foreground".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(5), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.instantiators
    ///
    /// The leaf name and version number of the binary for the process responsible for remotely instantiating a11y. This metric was generated to correspond to the Legacy Telemetry scalar a11y.instantiators.
    pub static instantiators: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "instantiators".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(6), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.invert_colors
    ///
    /// Boolean tracking if the user has an invert colors OS setting enabled. This metric was generated to correspond to the Legacy Telemetry scalar a11y.invert_colors.
    pub static invert_colors: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "invert_colors".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(7), meta)
    });

    #[repr(u16)]
    pub enum ThemeLabel {
        EDefault = 0,
        EAlways = 1,
        ENever = 2,
        __Other__,
    }
    impl From<u16> for ThemeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EDefault,
                1 => Self::EAlways,
                2 => Self::ENever,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for ThemeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EDefault => "default",
                Self::EAlways => "always",
                Self::ENever => "never",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from a11y.theme
    ///
    /// OS high contrast or other accessibility theme is enabled. The result is split into keys which represent the values of browser.display.document_color_use: "default", "always", or "never". This metric was generated to correspond to the Legacy Telemetry scalar a11y.theme.
    pub static theme: Lazy<LabeledMetric<LabeledBooleanMetric, ThemeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "theme".into(),
                    category: "a11y".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(8), meta, Some(vec![::std::borrow::Cow::from("always"), ::std::borrow::Cow::from("default"), ::std::borrow::Cow::from("never")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.tree_update_timing
    ///
    /// The amount of time taken to update the accessibility tree (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram A11Y_TREE_UPDATE_TIMING_MS.
    pub static tree_update_timing: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "tree_update_timing".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(9), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from a11y.use_system_colors
    ///
    /// Bool tracking if the user has system colors enabled in firefox. This metric was generated to correspond to the Legacy Telemetry scalar a11y.use_system_colors.
    pub static use_system_colors: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "use_system_colors".into(),
                category: "a11y".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(10), meta)
    });

}
pub mod fullscreen {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from fullscreen.change
    ///
    /// The time content uses to enter/exit fullscreen regardless of fullscreen transition timeout
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FULLSCREEN_CHANGE_MS.
    pub static change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "change".into(),
                category: "fullscreen".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(11), meta, TimeUnit::Millisecond)
    });

}
pub mod browser_engagement {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.bookmarks_toolbar_bookmark_added
    ///
    /// The count of bookmarks added to the bookmarks toolbar. This counts bookmarks created on the bookmarks toolbar and bookmarks moved to the bookmarks toolbar. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.bookmarks_toolbar_bookmark_added.
    pub static bookmarks_toolbar_bookmark_added: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            12,
            "browser.engagement",
            "bookmarks_toolbar_bookmark_added",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.bookmarks_toolbar_bookmark_opened
    ///
    /// The count of bookmarks opened from the Bookmarks Toolbar. This counts bookmarks opened on the toolbar and bookmarks opened from the 'symlinked' Other Bookmarks folder on the Bookmarks Toolbar. It does not count Bookmarks Toolbar bookmarks opened via the Library, Bookmarks Menu, or other UI since the goal is to measure interactions that pass through the toolbar. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.bookmarks_toolbar_bookmark_opened.
    pub static bookmarks_toolbar_bookmark_opened: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            13,
            "browser.engagement",
            "bookmarks_toolbar_bookmark_opened",
            "metrics"
        )
    });

    #[repr(u16)]
    pub enum TotalTopVisitsLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for TotalTopVisitsLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TotalTopVisitsLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.total_top_visits
    ///
    /// Count the number of times a new top page was starting to load
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram FX_TOTAL_TOP_VISITS.
    pub static total_top_visits: Lazy<LabeledMetric<LabeledCounterMetric, TotalTopVisitsLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "total_top_visits".into(),
                    category: "browser.engagement".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(14), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.sessionrestore_interstitial
    ///
    /// Whether we show about:sessionrestore or not. Split by key, which indicates why we showed the item or not. Specifically, 'deferred_restore' means we didn't autorestore and thus didn't show the interstitial; 'autorestore' indicates we autorestored without showing the interstitial. 'shown_old_session', 'shown_only_about_welcomeback', 'shown_many_crashes', 'shown_many_crashes_old_session' all indicate we did show the interstitial because of a crash, and the text after 'shown' indicates what secondary reason there was to show this page (as we don't show it for 'just' one crash). This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.sessionrestore_interstitial.
    pub static sessionrestore_interstitial: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "sessionrestore_interstitial".into(),
                    category: "browser.engagement".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(15), meta, None)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TabExplicitUnloadExtra {
        pub r#all_tabs_unloaded: Option<bool>,
        pub r#memory_after: Option<u32>,
        pub r#memory_before: Option<u32>,
        pub r#tabs_unloaded: Option<u32>,
        pub r#time_to_unload_in_ms: Option<u32>,
        pub r#unload_selected_tab: Option<bool>,
    }

    impl ExtraKeys for TabExplicitUnloadExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["all_tabs_unloaded", "memory_after", "memory_before", "tabs_unloaded", "time_to_unload_in_ms", "unload_selected_tab"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#all_tabs_unloaded.and_then(|val| map.insert("all_tabs_unloaded".into(), val.to_string()));
          self.r#memory_after.and_then(|val| map.insert("memory_after".into(), val.to_string()));
          self.r#memory_before.and_then(|val| map.insert("memory_before".into(), val.to_string()));
          self.r#tabs_unloaded.and_then(|val| map.insert("tabs_unloaded".into(), val.to_string()));
          self.r#time_to_unload_in_ms.and_then(|val| map.insert("time_to_unload_in_ms".into(), val.to_string()));
          self.r#unload_selected_tab.and_then(|val| map.insert("unload_selected_tab".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.tab_explicit_unload
    ///
    /// Recorded when the user explicitly unloads tab(s) from memory via the tab context menu.
    pub static tab_explicit_unload: Lazy<EventMetric<TabExplicitUnloadExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "tab_explicit_unload".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(16), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.tab_reload_count
    ///
    /// The count of tab reload events by the user after unloaded. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_reload_count.
    pub static tab_reload_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            17,
            "browser.engagement",
            "tab_reload_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.tab_unload_count
    ///
    /// The count of tab unload events by TabUnloader due to a low-memory situation. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_unload_count.
    pub static tab_unload_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            18,
            "browser.engagement",
            "tab_unload_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.active_ticks
    ///
    /// The number of five-second intervals ('ticks') the user was considered
    /// 'active'.
    /// 
    /// 'active' means keyboard or mouse interaction with the application.
    /// It doesn't take into account whether or not the window has focus or is in
    /// the foreground, only if it is receiving these interaction events.
    /// 
    /// Migrated from Telemetry's `browser.engagement.active_ticks`.
    pub static active_ticks: Lazy<CounterMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "active_ticks".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["baseline".into(), "metrics".into(), "usage-reporting".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CounterMetric::new(MetricId(19), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.max_concurrent_tab_count
    ///
    /// The count of maximum number of tabs open during a subsession, across all windows, including tabs in private windows and restored at startup. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_tab_count.
    pub static max_concurrent_tab_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "max_concurrent_tab_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(20), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.max_concurrent_tab_pinned_count
    ///
    /// The count of maximum number of pinned tabs open during a subsession. This includes private windows and the ones opened when starting the browser. Starting Firefox 85 this includes number of restored pinned tabs at startup. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_tab_pinned_count.
    pub static max_concurrent_tab_pinned_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "max_concurrent_tab_pinned_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(21), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.max_concurrent_vertical_tab_count
    ///
    /// The count of maximum number of tabs with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_vertical_tab_count.
    pub static max_concurrent_vertical_tab_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "max_concurrent_vertical_tab_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(22), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.max_concurrent_vertical_tab_pinned_count
    ///
    /// The count of maximum number of pinned tabs with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_vertical_tab_pinned_count.
    pub static max_concurrent_vertical_tab_pinned_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "max_concurrent_vertical_tab_pinned_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(23), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.max_concurrent_window_count
    ///
    /// The count of maximum number of browser windows open during a subsession. This includes private windows and the ones opened when starting the browser. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_window_count.
    pub static max_concurrent_window_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "max_concurrent_window_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(24), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.profile_count
    ///
    /// Windows only count of the browser profiles on the current system. This
    /// counts profiles that have been used across all Windows user accounts on
    /// machine since this probe was added. The value persists across installs.
    /// A value of 0 is reported if there is an error determining the correct
    /// count. Unset on other platforms.
    pub static profile_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "profile_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(25), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.tab_open_event_count
    ///
    /// The count of tab open events per subsession, across all windows, after the session has been restored. This includes tab open events from private windows and from manual session restorations (i.e. after crashes and from about:home), but excludes tabs opened vertically. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_open_event_count.
    pub static tab_open_event_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            26,
            "browser.engagement",
            "tab_open_event_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.tab_pinned_event_count
    ///
    /// The count of tab pinned events per subsession, across all windows, after the session has been restored. This includes tab pinned events from private windows. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_pinned_event_count.
    pub static tab_pinned_event_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            27,
            "browser.engagement",
            "tab_pinned_event_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.unfiltered_uri_count
    ///
    /// The count of the total non-unique URIs visited in a subsession, not restricted to a specific protocol, including page reloads and about:* pages (other than initial pages such as about:blank, ...), after the session has been restored. This does not include background page requests and URIs from embedded pages or private browsing. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.unfiltered_uri_count.
    pub static unfiltered_uri_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            28,
            "browser.engagement",
            "unfiltered_uri_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.unique_domains_count
    ///
    /// The count of the unique domains visited in a subsession, after the session has been restored. Subdomains under eTLD are aggregated after the first level (i.e. test.example.com and other.example.com are only counted once). This does not include background page requests and domains from embedded pages or private browsing. The count is limited to 100 unique domains. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.unique_domains_count.
    pub static unique_domains_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "unique_domains_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(29), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.uri_count
    ///
    /// The number of total non-unique http(s) URIs visited, including page
    /// reloads, after the session has been restored. URIs on minimized or
    /// background tabs may also be counted. Private browsing uris are included.
    /// 
    /// Migrated from Telemetry's
    /// `browser.engagement.total_uri_count_normal_and_private_mode`.
    pub static uri_count: Lazy<CounterMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "uri_count".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["baseline".into(), "metrics".into(), "usage-reporting".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CounterMetric::new(MetricId(30), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.uri_count_normal_mode
    ///
    /// The count of the total non-unique http(s) URIs visited in a subsession, including page reloads, after the session has been restored. URIs on minimized or background tabs may also be counted towards this. Private browsing is not included in this count. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.total_uri_count.
    pub static uri_count_normal_mode: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            31,
            "browser.engagement",
            "uri_count_normal_mode",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.vertical_tab_open_event_count
    ///
    /// The count of tab open events with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.vertical_tab_open_event_count.
    pub static vertical_tab_open_event_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            32,
            "browser.engagement",
            "vertical_tab_open_event_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.vertical_tab_pinned_event_count
    ///
    /// The count of tab pinned events with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.vertical_tab_pinned_event_count.
    pub static vertical_tab_pinned_event_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            33,
            "browser.engagement",
            "vertical_tab_pinned_event_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.window_open_event_count
    ///
    /// The count of browser window open events per subsession, after the session has been restored. The count includes private windows and the ones from manual session restorations (i.e. after crashes and from about:home). This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.window_open_event_count.
    pub static window_open_event_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            34,
            "browser.engagement",
            "window_open_event_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.session_time_excluding_suspend
    ///
    /// The duration of the session in milliseconds, excluding the time the device was suspended. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.session_time_excluding_suspend.
    pub static session_time_excluding_suspend: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "session_time_excluding_suspend".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(35), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.session_time_including_suspend
    ///
    /// The duration of the session in milliseconds, including the time the device was suspended. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.session_time_including_suspend.
    pub static session_time_including_suspend: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "session_time_including_suspend".into(),
                category: "browser.engagement".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(36), meta)
    });

}
pub mod browser_timings {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.timings.new_window
    ///
    /// Firefox: Time taken to open a new browser window (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_NEW_WINDOW_MS.
    pub static new_window: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "new_window".into(),
                category: "browser.timings".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(37), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.timings.page_load
    ///
    /// Firefox: Time taken to load a page (ms). This includes all static contents, no dynamic content. Page reloads and loading of about: pages are not included.
    /// This metric was generated to correspond to the Legacy Telemetry linear histogram FX_PAGE_LOAD_MS_2.
    pub static page_load: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "page_load".into(),
                category: "browser.timings".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(38), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.timings.page_reload_normal
    ///
    /// Firefox: Time taken to reload a page (ms) when using the LOAD_RELOAD_NORMAL flag
    /// This metric was generated to correspond to the Legacy Telemetry linear histogram FX_PAGE_RELOAD_NORMAL_MS.
    pub static page_reload_normal: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "page_reload_normal".into(),
                category: "browser.timings".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(39), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.timings.page_reload_skip_cache
    ///
    /// Firefox: Time taken to reload a page (ms) when caches are skipped
    /// This metric was generated to correspond to the Legacy Telemetry linear histogram FX_PAGE_RELOAD_SKIP_CACHE_MS.
    pub static page_reload_skip_cache: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "page_reload_skip_cache".into(),
                category: "browser.timings".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(40), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.timings.tab_click
    ///
    /// Firefox: Time in ms spent on switching tabs in response to a tab click
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_CLICK_MS.
    pub static tab_click: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "tab_click".into(),
                category: "browser.timings".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(41), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.timings.last_shutdown
    ///
    /// The time, in milliseconds, it took to complete the last shutdown. On successful shutdown, Telemetry saves this to disk into Telemetry.ShutdownTime.txt. On the next startup this is loaded and recorded. This metric was generated to correspond to the Legacy Telemetry scalar browser.timings.last_shutdown.
    pub static last_shutdown: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "last_shutdown".into(),
                category: "browser.timings".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(42), meta)
    });

}
pub mod networking {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[repr(u16)]
    pub enum CaptivePortalBannerDisplayTimeLabel {
        ESuccess = 0,
        EAbort = 1,
        EDismiss = 2,
        __Other__,
    }
    impl From<u16> for CaptivePortalBannerDisplayTimeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccess,
                1 => Self::EAbort,
                2 => Self::EDismiss,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for CaptivePortalBannerDisplayTimeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccess => "success",
                Self::EAbort => "abort",
                Self::EDismiss => "dismiss",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.captive_portal_banner_display_time
    ///
    /// Number of seconds the captive portal banner was displayed for, keyed by close reason:
    ///   "success" - the portal login was completed
    ///   "abort"   - the portal login was aborted (e.g. loss of network)
    ///   "dismiss" - the user dismissed the banner
    /// This metric was generated to correspond to the Legacy Telemetry scalar networking.captive_portal_banner_display_time.
    pub static captive_portal_banner_display_time: Lazy<LabeledMetric<LabeledCounterMetric, CaptivePortalBannerDisplayTimeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "captive_portal_banner_display_time".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(43), meta, Some(vec![::std::borrow::Cow::from("abort"), ::std::borrow::Cow::from("dismiss"), ::std::borrow::Cow::from("success")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.captive_portal_banner_displayed
    ///
    /// Number of times the captive portal banner was displayed in this session. This metric was generated to correspond to the Legacy Telemetry scalar networking.captive_portal_banner_displayed.
    pub static captive_portal_banner_displayed: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            44,
            "networking",
            "captive_portal_banner_displayed",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.doh_heuristic_ever_tripped
    ///
    /// True if this heuristic (key) was ever tripped during the session. This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristic_ever_tripped.
    pub static doh_heuristic_ever_tripped: Lazy<LabeledMetric<LabeledBooleanMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "doh_heuristic_ever_tripped".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(45), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.doh_heuristics_attempts
    ///
    /// The number of times we ran DoH heuristics. This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristics_attempts.
    pub static doh_heuristics_attempts: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            46,
            "networking",
            "doh_heuristics_attempts",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.doh_heuristics_pass_count
    ///
    /// The number of times we passed DoH heuristics. This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristics_pass_count.
    pub static doh_heuristics_pass_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            47,
            "networking",
            "doh_heuristics_pass_count",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.doh_heuristics_result
    ///
    /// The value of this scalar indicates the result of the last heuristic run. 0: "incomplete" 1: "pass" 2: "opt-out" 3: "manually-disabled" 4: "manually-enabled" 5: "enterprise-disabled" 6: "enterprise- present" 7: "enterprise-enabled" 8: "vpn" 9: "proxy" 10: "nrpt" 11: "parental" 12: "modifiedRoots" 13: "thirdPartyRoots" 14: "google" 15: "youtube" 16: "zscaler" 17: "canary" 18: "ignored" This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristics_result.
    pub static doh_heuristics_result: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "doh_heuristics_result".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(48), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cache_metadata_first_read_time
    ///
    /// Time spent to read the first part of the metadata from the cache entry file.
    pub static cache_metadata_first_read_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cache_metadata_first_read_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(49), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cache_metadata_second_read_time
    ///
    /// Time spent to read the missing part of the metadata from the cache entry file.
    pub static cache_metadata_second_read_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cache_metadata_second_read_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(50), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cache_metadata_size
    ///
    /// Size of the metadata in bytes parsed from the disk.
    pub static cache_metadata_size: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cache_metadata_size".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(51), meta, MemoryUnit::Byte)
    });

    #[repr(u16)]
    pub enum CachePurgeDueToMemoryLimitLabel {
        EMetaDataFileSizeLimit = 0,
        ECacheMemoryLimit = 1,
        __Other__,
    }
    impl From<u16> for CachePurgeDueToMemoryLimitLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMetaDataFileSizeLimit,
                1 => Self::ECacheMemoryLimit,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for CachePurgeDueToMemoryLimitLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMetaDataFileSizeLimit => "meta_data_file_size_limit",
                Self::ECacheMemoryLimit => "cache_memory_limit",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.cache_purge_due_to_memory_limit
    ///
    /// Counts how often we purge cache entries from memory due to memory limits.
    pub static cache_purge_due_to_memory_limit: Lazy<LabeledMetric<LabeledCounterMetric, CachePurgeDueToMemoryLimitLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "cache_purge_due_to_memory_limit".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(52), meta, Some(vec![::std::borrow::Cow::from("cache_memory_limit"), ::std::borrow::Cow::from("meta_data_file_size_limit")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_access_fixup_diff
    ///
    /// If we fix up a cookie lastAccessed timestamp that is in the future this metric records the number of seconds that timestamp was off from NOW.
    pub static cookie_access_fixup_diff: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_access_fixup_diff".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(53), meta, 0, 315360000000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_chips_partition_limit_overflow
    ///
    /// The number of cookie bytes exceeding chips partition limit capacity for a single partition
    pub static cookie_chips_partition_limit_overflow: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_chips_partition_limit_overflow".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(54), meta, 0, 16000000, 22, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_count_invalid_first_party_partitioned_in_db
    ///
    /// This counts the number of invalid first-party partitioned cookies that don't have the partitioned cookie attribution(CHIPS).
    pub static cookie_count_invalid_first_party_partitioned_in_db: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            55,
            "networking",
            "cookie_count_invalid_first_party_partitioned_in_db",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_count_part_by_key
    ///
    /// A distribution of the partitioned cookies in storage belonging to a particular cookie key (host + origin attributes)
    pub static cookie_count_part_by_key: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_count_part_by_key".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(56), meta, 1, 220, 10, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_count_partitioned
    ///
    /// Reports the number of partitioned cookies in storage
    pub static cookie_count_partitioned: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_count_partitioned".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(57), meta, 0, 4000, 22, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_count_total
    ///
    /// Reports the total number of cookies in storage
    pub static cookie_count_total: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_count_total".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(58), meta, 0, 4000, 22, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_count_unpart_by_key
    ///
    /// A distribution of the unpartitioned cookies in storage belonging to a particular cookie key (host + origin attributes)
    pub static cookie_count_unpart_by_key: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_count_unpart_by_key".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(59), meta, 1, 220, 10, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_count_unpartitioned
    ///
    /// Reports the number of unpartitioned cookies in storage
    pub static cookie_count_unpartitioned: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_count_unpartitioned".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(60), meta, 0, 4000, 22, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_creation_fixup_diff
    ///
    /// If we fix up a cookie creation timestamp that is in the future this metric records the number of seconds that timestamp was off from NOW.
    pub static cookie_creation_fixup_diff: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_creation_fixup_diff".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(61), meta, 0, 315360000000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_purge_entry_max
    ///
    /// A distribution of the number of cookies purged for a single host + OA entry as a result of exceeding the maximum threshold for the given host + OA (single purge)
    pub static cookie_purge_entry_max: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_purge_entry_max".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(62), meta, 1, 220, 10, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_purge_max
    ///
    /// A distribution of the number of cookies purged across all host + OAs as a result of exceeding the cookie maximum threshold (single purge)
    pub static cookie_purge_max: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookie_purge_max".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(63), meta, 1, 4000, 22, HistogramType::Exponential)
    });

    #[repr(u16)]
    pub enum CookieTimestampFixedCountLabel {
        ECreationtime = 0,
        ELastaccessed = 1,
        __Other__,
    }
    impl From<u16> for CookieTimestampFixedCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECreationtime,
                1 => Self::ELastaccessed,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for CookieTimestampFixedCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECreationtime => "creationTime",
                Self::ELastaccessed => "lastAccessed",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.cookie_timestamp_fixed_count
    ///
    /// Counts the number of times a cookie's invalid timestamp was fixed when reading it from the DB.
    pub static cookie_timestamp_fixed_count: Lazy<LabeledMetric<LabeledCounterMetric, CookieTimestampFixedCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "cookie_timestamp_fixed_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(64), meta, Some(vec![::std::borrow::Cow::from("creationTime"), ::std::borrow::Cow::from("lastAccessed")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.dns_failed_lookup_time
    ///
    /// Time for an unsuccessful DNS OS resolution (msec) | Migrated from Firefox Telemetry's `DNS_FAILED_LOOKUP_TIME`.
    pub static dns_failed_lookup_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dns_failed_lookup_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(65), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.dns_lookup_time
    ///
    /// Time for a successful DNS resolution (msec) | Migrated from Firefox Telemetry's `DNS_LOOKUP_TIME`.
    pub static dns_lookup_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dns_lookup_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(66), meta, TimeUnit::Millisecond)
    });

    #[repr(u16)]
    pub enum DnsNativeCountLabel {
        ERegular = 0,
        EPrivate = 1,
        EHttpsRegular = 2,
        EHttpsPrivate = 3,
        __Other__,
    }
    impl From<u16> for DnsNativeCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ERegular,
                1 => Self::EPrivate,
                2 => Self::EHttpsRegular,
                3 => Self::EHttpsPrivate,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for DnsNativeCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ERegular => "regular",
                Self::EPrivate => "private",
                Self::EHttpsRegular => "https_regular",
                Self::EHttpsPrivate => "https_private",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.dns_native_count
    ///
    /// The count of calls to the native DNS APIs
    pub static dns_native_count: Lazy<LabeledMetric<LabeledCounterMetric, DnsNativeCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "dns_native_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(67), meta, Some(vec![::std::borrow::Cow::from("https_private"), ::std::borrow::Cow::from("https_regular"), ::std::borrow::Cow::from("private"), ::std::borrow::Cow::from("regular")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.dns_native_https_call_time
    ///
    /// Time spent in the call to the native OS DNS resolution.
    pub static dns_native_https_call_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dns_native_https_call_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(68), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.dns_renewal_time
    ///
    /// Time for a renewed DNS OS resolution (msec) | Migrated from Firefox Telemetry's `DNS_RENEWAL_TIME`.
    pub static dns_renewal_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dns_renewal_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(69), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.dns_renewal_time_for_ttl
    ///
    /// Time for a DNS OS resolution (msec) used to get TTL | Migrated from Firefox Telemetry's `DNS_RENEWAL_TIME_FOR_TTL`.
    pub static dns_renewal_time_for_ttl: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dns_renewal_time_for_ttl".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(70), meta, TimeUnit::Millisecond)
    });

    #[repr(u16)]
    pub enum FetchKeepaliveDiscardCountLabel {
        ETotalKeepaliveLimit = 0,
        EPerOriginLimit = 1,
        __Other__,
    }
    impl From<u16> for FetchKeepaliveDiscardCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ETotalKeepaliveLimit,
                1 => Self::EPerOriginLimit,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for FetchKeepaliveDiscardCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ETotalKeepaliveLimit => "total_keepalive_limit",
                Self::EPerOriginLimit => "per_origin_limit",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.fetch_keepalive_discard_count
    ///
    /// Counts how many fetch keepalive requests are dropped due to configured resource limits.
    pub static fetch_keepalive_discard_count: Lazy<LabeledMetric<LabeledCounterMetric, FetchKeepaliveDiscardCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "fetch_keepalive_discard_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(71), meta, Some(vec![::std::borrow::Cow::from("per_origin_limit"), ::std::borrow::Cow::from("total_keepalive_limit")]))
    });

    #[repr(u16)]
    pub enum FetchKeepaliveRequestCountLabel {
        EWorker = 0,
        EMain = 1,
        __Other__,
    }
    impl From<u16> for FetchKeepaliveRequestCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EWorker,
                1 => Self::EMain,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for FetchKeepaliveRequestCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EWorker => "worker",
                Self::EMain => "main",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.fetch_keepalive_request_count
    ///
    /// Counts how many fetch keepalive requests are made. This counter helps us to understand the adoption of fetch keepalive for firefox.
    pub static fetch_keepalive_request_count: Lazy<LabeledMetric<LabeledCounterMetric, FetchKeepaliveRequestCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "fetch_keepalive_request_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(72), meta, Some(vec![::std::borrow::Cow::from("main"), ::std::borrow::Cow::from("worker")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_download_throughput
    ///
    /// The download throughput for  http/1.0, http/1.1 requests larger than 10MB. Measured in megabits per second, Mbps.
    pub static http_1_download_throughput: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_download_throughput".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(73), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_download_throughput_100
    ///
    /// The download throughput for http/1.0 and http/1.1 requests size larger than 100MB. Measured in megabits per second, Mbps.
    pub static http_1_download_throughput_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_download_throughput_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(74), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_download_throughput_10_50
    ///
    /// The download throughput for http/1.0 and http/1.1 requests between 10MB and 50MB. Measured in megabits per second, Mbps.
    pub static http_1_download_throughput_10_50: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_download_throughput_10_50".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(75), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_download_throughput_50_100
    ///
    /// The download throughput for http/1.0 and http/1.1 requests between 50MB and 100MB. Measured in megabits per second, Mbps.
    pub static http_1_download_throughput_50_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_download_throughput_50_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(76), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_upload_throughput
    ///
    /// The upload throughput for http/1.0, http/1.1 requests larger than 10MB. Measured in megabits per second, Mbps.
    pub static http_1_upload_throughput: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_upload_throughput".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(77), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_upload_throughput_100
    ///
    /// The upload throughput for http/1.0, http/1.1 request size larger than 100MB. Measured in megabits per second, Mbps.
    pub static http_1_upload_throughput_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_upload_throughput_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(78), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_upload_throughput_10_50
    ///
    /// The upload throughput for http/1.0, http/1.1 request size between 10MB and 50MB. Measured in megabits per second, Mbps.
    pub static http_1_upload_throughput_10_50: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_upload_throughput_10_50".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(79), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_1_upload_throughput_50_100
    ///
    /// The upload throughput for http/1.0, http/1.1 request size between 50MB and 100MB. Measured in megabits per second, Mbps.
    pub static http_1_upload_throughput_50_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_1_upload_throughput_50_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(80), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_download_throughput
    ///
    /// The download throughput for http/2 requests larger than 10MB. Measured in megabits per second, Mbps.
    pub static http_2_download_throughput: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_download_throughput".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(81), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_download_throughput_100
    ///
    /// The download throughput for http/2 requests size larger than 100MB. Measured in megabits per second, Mbps.
    pub static http_2_download_throughput_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_download_throughput_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(82), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_download_throughput_10_50
    ///
    /// The download throughput for http/2 requests between 10MB and 50MB. Measured in megabits per second, Mbps.
    pub static http_2_download_throughput_10_50: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_download_throughput_10_50".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(83), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_download_throughput_50_100
    ///
    /// The download throughput for http/2 requests between 50MB and 100MB. Measured in megabits per second, Mbps.
    pub static http_2_download_throughput_50_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_download_throughput_50_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(84), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_upload_throughput
    ///
    /// The upload throughput for http/2 requests larger than 10MB. Measured in megabits per second, Mbps.
    pub static http_2_upload_throughput: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_upload_throughput".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(85), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_upload_throughput_100
    ///
    /// The upload throughput for http/2 request size larger than 100MB. Measured in megabits per second, Mbps.
    pub static http_2_upload_throughput_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_upload_throughput_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(86), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_upload_throughput_10_50
    ///
    /// The upload throughput for http/2 request size between 10MB and 50MB. Measured in megabits per second, Mbps.
    pub static http_2_upload_throughput_10_50: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_upload_throughput_10_50".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(87), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_2_upload_throughput_50_100
    ///
    /// The upload throughput for http/2 request size between 50MB and 100MB. Measured in megabits per second, Mbps.
    pub static http_2_upload_throughput_50_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_2_upload_throughput_50_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(88), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[repr(u16)]
    pub enum Http3ConnectionCloseReasonLabel {
        EApplication = 0,
        ENoerror = 1,
        EInternalerror = 2,
        EConnectionrefused = 3,
        EFlowcontrolerror = 4,
        EStreamlimiterror = 5,
        EStreamstateerror = 6,
        EFinalsizeerror = 7,
        EFrameencodingerror = 8,
        ETransportparametererror = 9,
        EProtocolviolation = 10,
        EInvalidtoken = 11,
        EApplicationerror = 12,
        ECryptobufferexceeded = 13,
        ECryptoerror = 14,
        EQlogerror = 15,
        ECryptoalert = 16,
        EEchretry = 17,
        EAckedunsentpacket = 18,
        EConnectionidlimitexceeded = 19,
        EConnectionidsexhausted = 20,
        EConnectionstate = 21,
        EDecodingframe = 22,
        EDecrypterror = 23,
        EDisabledversion = 24,
        EIdletimeout = 25,
        EIntegeroverflow = 26,
        EInvalidinput = 27,
        EInvalidmigration = 28,
        EInvalidpacket = 29,
        EInvalidresumptiontoken = 30,
        EInvalidretry = 31,
        EInvalidstreamid = 32,
        EKeysdiscarded = 33,
        EKeysexhausted = 34,
        EKeyspending = 35,
        EKeyupdateblocked = 36,
        ENoavailablepath = 37,
        ENomoredata = 38,
        ENotavailable = 39,
        ENotconnected = 40,
        EPacketnumberoverlap = 41,
        EPeerapplicationerror = 42,
        EPeererror = 43,
        EStatelessreset = 44,
        EToomuchdata = 45,
        EUnexpectedmessage = 46,
        EUnknownconnectionid = 47,
        EUnknownframetype = 48,
        EVersionnegotiation = 49,
        EWrongrole = 50,
        __Other__,
    }
    impl From<u16> for Http3ConnectionCloseReasonLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EApplication,
                1 => Self::ENoerror,
                2 => Self::EInternalerror,
                3 => Self::EConnectionrefused,
                4 => Self::EFlowcontrolerror,
                5 => Self::EStreamlimiterror,
                6 => Self::EStreamstateerror,
                7 => Self::EFinalsizeerror,
                8 => Self::EFrameencodingerror,
                9 => Self::ETransportparametererror,
                10 => Self::EProtocolviolation,
                11 => Self::EInvalidtoken,
                12 => Self::EApplicationerror,
                13 => Self::ECryptobufferexceeded,
                14 => Self::ECryptoerror,
                15 => Self::EQlogerror,
                16 => Self::ECryptoalert,
                17 => Self::EEchretry,
                18 => Self::EAckedunsentpacket,
                19 => Self::EConnectionidlimitexceeded,
                20 => Self::EConnectionidsexhausted,
                21 => Self::EConnectionstate,
                22 => Self::EDecodingframe,
                23 => Self::EDecrypterror,
                24 => Self::EDisabledversion,
                25 => Self::EIdletimeout,
                26 => Self::EIntegeroverflow,
                27 => Self::EInvalidinput,
                28 => Self::EInvalidmigration,
                29 => Self::EInvalidpacket,
                30 => Self::EInvalidresumptiontoken,
                31 => Self::EInvalidretry,
                32 => Self::EInvalidstreamid,
                33 => Self::EKeysdiscarded,
                34 => Self::EKeysexhausted,
                35 => Self::EKeyspending,
                36 => Self::EKeyupdateblocked,
                37 => Self::ENoavailablepath,
                38 => Self::ENomoredata,
                39 => Self::ENotavailable,
                40 => Self::ENotconnected,
                41 => Self::EPacketnumberoverlap,
                42 => Self::EPeerapplicationerror,
                43 => Self::EPeererror,
                44 => Self::EStatelessreset,
                45 => Self::EToomuchdata,
                46 => Self::EUnexpectedmessage,
                47 => Self::EUnknownconnectionid,
                48 => Self::EUnknownframetype,
                49 => Self::EVersionnegotiation,
                50 => Self::EWrongrole,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for Http3ConnectionCloseReasonLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EApplication => "Application",
                Self::ENoerror => "NoError",
                Self::EInternalerror => "InternalError",
                Self::EConnectionrefused => "ConnectionRefused",
                Self::EFlowcontrolerror => "FlowControlError",
                Self::EStreamlimiterror => "StreamLimitError",
                Self::EStreamstateerror => "StreamStateError",
                Self::EFinalsizeerror => "FinalSizeError",
                Self::EFrameencodingerror => "FrameEncodingError",
                Self::ETransportparametererror => "TransportParameterError",
                Self::EProtocolviolation => "ProtocolViolation",
                Self::EInvalidtoken => "InvalidToken",
                Self::EApplicationerror => "ApplicationError",
                Self::ECryptobufferexceeded => "CryptoBufferExceeded",
                Self::ECryptoerror => "CryptoError",
                Self::EQlogerror => "QlogError",
                Self::ECryptoalert => "CryptoAlert",
                Self::EEchretry => "EchRetry",
                Self::EAckedunsentpacket => "AckedUnsentPacket",
                Self::EConnectionidlimitexceeded => "ConnectionIdLimitExceeded",
                Self::EConnectionidsexhausted => "ConnectionIdsExhausted",
                Self::EConnectionstate => "ConnectionState",
                Self::EDecodingframe => "DecodingFrame",
                Self::EDecrypterror => "DecryptError",
                Self::EDisabledversion => "DisabledVersion",
                Self::EIdletimeout => "IdleTimeout",
                Self::EIntegeroverflow => "IntegerOverflow",
                Self::EInvalidinput => "InvalidInput",
                Self::EInvalidmigration => "InvalidMigration",
                Self::EInvalidpacket => "InvalidPacket",
                Self::EInvalidresumptiontoken => "InvalidResumptionToken",
                Self::EInvalidretry => "InvalidRetry",
                Self::EInvalidstreamid => "InvalidStreamId",
                Self::EKeysdiscarded => "KeysDiscarded",
                Self::EKeysexhausted => "KeysExhausted",
                Self::EKeyspending => "KeysPending",
                Self::EKeyupdateblocked => "KeyUpdateBlocked",
                Self::ENoavailablepath => "NoAvailablePath",
                Self::ENomoredata => "NoMoreData",
                Self::ENotavailable => "NotAvailable",
                Self::ENotconnected => "NotConnected",
                Self::EPacketnumberoverlap => "PacketNumberOverlap",
                Self::EPeerapplicationerror => "PeerApplicationError",
                Self::EPeererror => "PeerError",
                Self::EStatelessreset => "StatelessReset",
                Self::EToomuchdata => "TooMuchData",
                Self::EUnexpectedmessage => "UnexpectedMessage",
                Self::EUnknownconnectionid => "UnknownConnectionId",
                Self::EUnknownframetype => "UnknownFrameType",
                Self::EVersionnegotiation => "VersionNegotiation",
                Self::EWrongrole => "WrongRole",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_connection_close_reason
    ///
    /// Number of HTTP3 connections closed, labeled by reason.
    pub static http_3_connection_close_reason: Lazy<LabeledMetric<LabeledCounterMetric, Http3ConnectionCloseReasonLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_3_connection_close_reason".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(89), meta, Some(vec![::std::borrow::Cow::from("AckedUnsentPacket"), ::std::borrow::Cow::from("Application"), ::std::borrow::Cow::from("ApplicationError"), ::std::borrow::Cow::from("ConnectionIdLimitExceeded"), ::std::borrow::Cow::from("ConnectionIdsExhausted"), ::std::borrow::Cow::from("ConnectionRefused"), ::std::borrow::Cow::from("ConnectionState"), ::std::borrow::Cow::from("CryptoAlert"), ::std::borrow::Cow::from("CryptoBufferExceeded"), ::std::borrow::Cow::from("CryptoError"), ::std::borrow::Cow::from("DecodingFrame"), ::std::borrow::Cow::from("DecryptError"), ::std::borrow::Cow::from("DisabledVersion"), ::std::borrow::Cow::from("EchRetry"), ::std::borrow::Cow::from("FinalSizeError"), ::std::borrow::Cow::from("FlowControlError"), ::std::borrow::Cow::from("FrameEncodingError"), ::std::borrow::Cow::from("IdleTimeout"), ::std::borrow::Cow::from("IntegerOverflow"), ::std::borrow::Cow::from("InternalError"), ::std::borrow::Cow::from("InvalidInput"), ::std::borrow::Cow::from("InvalidMigration"), ::std::borrow::Cow::from("InvalidPacket"), ::std::borrow::Cow::from("InvalidResumptionToken"), ::std::borrow::Cow::from("InvalidRetry"), ::std::borrow::Cow::from("InvalidStreamId"), ::std::borrow::Cow::from("InvalidToken"), ::std::borrow::Cow::from("KeyUpdateBlocked"), ::std::borrow::Cow::from("KeysDiscarded"), ::std::borrow::Cow::from("KeysExhausted"), ::std::borrow::Cow::from("KeysPending"), ::std::borrow::Cow::from("NoAvailablePath"), ::std::borrow::Cow::from("NoError"), ::std::borrow::Cow::from("NoMoreData"), ::std::borrow::Cow::from("NotAvailable"), ::std::borrow::Cow::from("NotConnected"), ::std::borrow::Cow::from("PacketNumberOverlap"), ::std::borrow::Cow::from("PeerApplicationError"), ::std::borrow::Cow::from("PeerError"), ::std::borrow::Cow::from("ProtocolViolation"), ::std::borrow::Cow::from("QlogError"), ::std::borrow::Cow::from("StatelessReset"), ::std::borrow::Cow::from("StreamLimitError"), ::std::borrow::Cow::from("StreamStateError"), ::std::borrow::Cow::from("TooMuchData"), ::std::borrow::Cow::from("TransportParameterError"), ::std::borrow::Cow::from("UnexpectedMessage"), ::std::borrow::Cow::from("UnknownConnectionId"), ::std::borrow::Cow::from("UnknownFrameType"), ::std::borrow::Cow::from("VersionNegotiation"), ::std::borrow::Cow::from("WrongRole")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_download_throughput
    ///
    /// The download throughput for http/3 requests larger than 10MB. Measured in megabits per second, Mbps.
    pub static http_3_download_throughput: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_download_throughput".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(90), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_download_throughput_100
    ///
    /// The download throughput for http/3 requests size larger than 100MB. Measured in megabits per second, Mbps.
    pub static http_3_download_throughput_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_download_throughput_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(91), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_download_throughput_10_50
    ///
    /// The download throughput for http/3 requests between 10MB and 50MB. Measured in megabits per second, Mbps.
    pub static http_3_download_throughput_10_50: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_download_throughput_10_50".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(92), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_download_throughput_50_100
    ///
    /// The download throughput for http/3 requests between 50MB and 100MB. Measured in megabits per second, Mbps.
    pub static http_3_download_throughput_50_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_download_throughput_50_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(93), meta, 0, 10000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_ecn_ce_ect0_ratio_received
    ///
    /// HTTP3: ECN CE to ECT0 ratio (multiply by 10000) received.
    pub static http_3_ecn_ce_ect0_ratio_received: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_ecn_ce_ect0_ratio_received".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(94), meta, 0, 2000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_ecn_ce_ect0_ratio_sent
    ///
    /// HTTP3: ECN CE to ECT0 ratio (multiply by 10000) sent.
    pub static http_3_ecn_ce_ect0_ratio_sent: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_ecn_ce_ect0_ratio_sent".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(95), meta, 0, 2000, 100, HistogramType::Exponential)
    });

    #[repr(u16)]
    pub enum Http3EcnPathCapabilityLabel {
        ECapable = 0,
        EBlackHole = 1,
        EBleaching = 2,
        EReceivedUnsentEct1 = 3,
        __Other__,
    }
    impl From<u16> for Http3EcnPathCapabilityLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECapable,
                1 => Self::EBlackHole,
                2 => Self::EBleaching,
                3 => Self::EReceivedUnsentEct1,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for Http3EcnPathCapabilityLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECapable => "capable",
                Self::EBlackHole => "black-hole",
                Self::EBleaching => "bleaching",
                Self::EReceivedUnsentEct1 => "received-unsent-ect-1",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_ecn_path_capability
    ///
    /// Number of paths known to be ECN capable or not-capable.
    pub static http_3_ecn_path_capability: Lazy<LabeledMetric<LabeledCounterMetric, Http3EcnPathCapabilityLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_3_ecn_path_capability".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(96), meta, Some(vec![::std::borrow::Cow::from("black-hole"), ::std::borrow::Cow::from("bleaching"), ::std::borrow::Cow::from("capable"), ::std::borrow::Cow::from("received-unsent-ect-1")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_loss_ratio
    ///
    /// HTTP3: packet loss ratio (multiply by 10000).
    pub static http_3_loss_ratio: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_loss_ratio".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(97), meta, 0, 2000, 100, HistogramType::Exponential)
    });

    #[repr(u16)]
    pub enum Http3QuicFrameCountLabel {
        EAckTx = 0,
        EAckRx = 1,
        ECryptoTx = 2,
        ECryptoRx = 3,
        EStreamTx = 4,
        EStreamRx = 5,
        EResetStreamTx = 6,
        EResetStreamRx = 7,
        EStopSendingTx = 8,
        EStopSendingRx = 9,
        EPingTx = 10,
        EPingRx = 11,
        EPaddingTx = 12,
        EPaddingRx = 13,
        EMaxStreamsTx = 14,
        EMaxStreamsRx = 15,
        EStreamsBlockedTx = 16,
        EStreamsBlockedRx = 17,
        EMaxDataTx = 18,
        EMaxDataRx = 19,
        EDataBlockedTx = 20,
        EDataBlockedRx = 21,
        EMaxStreamDataTx = 22,
        EMaxStreamDataRx = 23,
        EStreamDataBlockedTx = 24,
        EStreamDataBlockedRx = 25,
        ENewConnectionIdTx = 26,
        ENewConnectionIdRx = 27,
        ERetireConnectionIdTx = 28,
        ERetireConnectionIdRx = 29,
        EPathChallengeTx = 30,
        EPathChallengeRx = 31,
        EPathResponseTx = 32,
        EPathResponseRx = 33,
        EConnectionCloseTx = 34,
        EConnectionCloseRx = 35,
        EHandshakeDoneTx = 36,
        EHandshakeDoneRx = 37,
        ENewTokenTx = 38,
        ENewTokenRx = 39,
        EAckFrequencyTx = 40,
        EAckFrequencyRx = 41,
        EDatagramTx = 42,
        EDatagramRx = 43,
        __Other__,
    }
    impl From<u16> for Http3QuicFrameCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EAckTx,
                1 => Self::EAckRx,
                2 => Self::ECryptoTx,
                3 => Self::ECryptoRx,
                4 => Self::EStreamTx,
                5 => Self::EStreamRx,
                6 => Self::EResetStreamTx,
                7 => Self::EResetStreamRx,
                8 => Self::EStopSendingTx,
                9 => Self::EStopSendingRx,
                10 => Self::EPingTx,
                11 => Self::EPingRx,
                12 => Self::EPaddingTx,
                13 => Self::EPaddingRx,
                14 => Self::EMaxStreamsTx,
                15 => Self::EMaxStreamsRx,
                16 => Self::EStreamsBlockedTx,
                17 => Self::EStreamsBlockedRx,
                18 => Self::EMaxDataTx,
                19 => Self::EMaxDataRx,
                20 => Self::EDataBlockedTx,
                21 => Self::EDataBlockedRx,
                22 => Self::EMaxStreamDataTx,
                23 => Self::EMaxStreamDataRx,
                24 => Self::EStreamDataBlockedTx,
                25 => Self::EStreamDataBlockedRx,
                26 => Self::ENewConnectionIdTx,
                27 => Self::ENewConnectionIdRx,
                28 => Self::ERetireConnectionIdTx,
                29 => Self::ERetireConnectionIdRx,
                30 => Self::EPathChallengeTx,
                31 => Self::EPathChallengeRx,
                32 => Self::EPathResponseTx,
                33 => Self::EPathResponseRx,
                34 => Self::EConnectionCloseTx,
                35 => Self::EConnectionCloseRx,
                36 => Self::EHandshakeDoneTx,
                37 => Self::EHandshakeDoneRx,
                38 => Self::ENewTokenTx,
                39 => Self::ENewTokenRx,
                40 => Self::EAckFrequencyTx,
                41 => Self::EAckFrequencyRx,
                42 => Self::EDatagramTx,
                43 => Self::EDatagramRx,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for Http3QuicFrameCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EAckTx => "ack_tx",
                Self::EAckRx => "ack_rx",
                Self::ECryptoTx => "crypto_tx",
                Self::ECryptoRx => "crypto_rx",
                Self::EStreamTx => "stream_tx",
                Self::EStreamRx => "stream_rx",
                Self::EResetStreamTx => "reset_stream_tx",
                Self::EResetStreamRx => "reset_stream_rx",
                Self::EStopSendingTx => "stop_sending_tx",
                Self::EStopSendingRx => "stop_sending_rx",
                Self::EPingTx => "ping_tx",
                Self::EPingRx => "ping_rx",
                Self::EPaddingTx => "padding_tx",
                Self::EPaddingRx => "padding_rx",
                Self::EMaxStreamsTx => "max_streams_tx",
                Self::EMaxStreamsRx => "max_streams_rx",
                Self::EStreamsBlockedTx => "streams_blocked_tx",
                Self::EStreamsBlockedRx => "streams_blocked_rx",
                Self::EMaxDataTx => "max_data_tx",
                Self::EMaxDataRx => "max_data_rx",
                Self::EDataBlockedTx => "data_blocked_tx",
                Self::EDataBlockedRx => "data_blocked_rx",
                Self::EMaxStreamDataTx => "max_stream_data_tx",
                Self::EMaxStreamDataRx => "max_stream_data_rx",
                Self::EStreamDataBlockedTx => "stream_data_blocked_tx",
                Self::EStreamDataBlockedRx => "stream_data_blocked_rx",
                Self::ENewConnectionIdTx => "new_connection_id_tx",
                Self::ENewConnectionIdRx => "new_connection_id_rx",
                Self::ERetireConnectionIdTx => "retire_connection_id_tx",
                Self::ERetireConnectionIdRx => "retire_connection_id_rx",
                Self::EPathChallengeTx => "path_challenge_tx",
                Self::EPathChallengeRx => "path_challenge_rx",
                Self::EPathResponseTx => "path_response_tx",
                Self::EPathResponseRx => "path_response_rx",
                Self::EConnectionCloseTx => "connection_close_tx",
                Self::EConnectionCloseRx => "connection_close_rx",
                Self::EHandshakeDoneTx => "handshake_done_tx",
                Self::EHandshakeDoneRx => "handshake_done_rx",
                Self::ENewTokenTx => "new_token_tx",
                Self::ENewTokenRx => "new_token_rx",
                Self::EAckFrequencyTx => "ack_frequency_tx",
                Self::EAckFrequencyRx => "ack_frequency_rx",
                Self::EDatagramTx => "datagram_tx",
                Self::EDatagramRx => "datagram_rx",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_quic_frame_count
    ///
    /// Number of QUIC frames send and received by type.
    pub static http_3_quic_frame_count: Lazy<LabeledMetric<LabeledCounterMetric, Http3QuicFrameCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_3_quic_frame_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(98), meta, Some(vec![::std::borrow::Cow::from("ack_frequency_rx"), ::std::borrow::Cow::from("ack_frequency_tx"), ::std::borrow::Cow::from("ack_rx"), ::std::borrow::Cow::from("ack_tx"), ::std::borrow::Cow::from("connection_close_rx"), ::std::borrow::Cow::from("connection_close_tx"), ::std::borrow::Cow::from("crypto_rx"), ::std::borrow::Cow::from("crypto_tx"), ::std::borrow::Cow::from("data_blocked_rx"), ::std::borrow::Cow::from("data_blocked_tx"), ::std::borrow::Cow::from("datagram_rx"), ::std::borrow::Cow::from("datagram_tx"), ::std::borrow::Cow::from("handshake_done_rx"), ::std::borrow::Cow::from("handshake_done_tx"), ::std::borrow::Cow::from("max_data_rx"), ::std::borrow::Cow::from("max_data_tx"), ::std::borrow::Cow::from("max_stream_data_rx"), ::std::borrow::Cow::from("max_stream_data_tx"), ::std::borrow::Cow::from("max_streams_rx"), ::std::borrow::Cow::from("max_streams_tx"), ::std::borrow::Cow::from("new_connection_id_rx"), ::std::borrow::Cow::from("new_connection_id_tx"), ::std::borrow::Cow::from("new_token_rx"), ::std::borrow::Cow::from("new_token_tx"), ::std::borrow::Cow::from("padding_rx"), ::std::borrow::Cow::from("padding_tx"), ::std::borrow::Cow::from("path_challenge_rx"), ::std::borrow::Cow::from("path_challenge_tx"), ::std::borrow::Cow::from("path_response_rx"), ::std::borrow::Cow::from("path_response_tx"), ::std::borrow::Cow::from("ping_rx"), ::std::borrow::Cow::from("ping_tx"), ::std::borrow::Cow::from("reset_stream_rx"), ::std::borrow::Cow::from("reset_stream_tx"), ::std::borrow::Cow::from("retire_connection_id_rx"), ::std::borrow::Cow::from("retire_connection_id_tx"), ::std::borrow::Cow::from("stop_sending_rx"), ::std::borrow::Cow::from("stop_sending_tx"), ::std::borrow::Cow::from("stream_data_blocked_rx"), ::std::borrow::Cow::from("stream_data_blocked_tx"), ::std::borrow::Cow::from("stream_rx"), ::std::borrow::Cow::from("stream_tx"), ::std::borrow::Cow::from("streams_blocked_rx"), ::std::borrow::Cow::from("streams_blocked_tx")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_udp_datagram_segment_size_received
    ///
    /// HTTP3 UDP datagram size received.
    pub static http_3_udp_datagram_segment_size_received: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_udp_datagram_segment_size_received".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(99), meta, MemoryUnit::Byte)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_udp_datagram_segment_size_sent
    ///
    /// HTTP3 UDP datagram segment size sent.
    pub static http_3_udp_datagram_segment_size_sent: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_udp_datagram_segment_size_sent".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(100), meta, MemoryUnit::Byte)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_udp_datagram_segments_received
    ///
    /// HTTP3 UDP number of segments per datagram received.
    pub static http_3_udp_datagram_segments_received: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_udp_datagram_segments_received".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(101), meta, 0, 128, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_udp_datagram_size_received
    ///
    /// HTTP3 UDP datagram size received.
    pub static http_3_udp_datagram_size_received: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_udp_datagram_size_received".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(102), meta, MemoryUnit::Byte)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_upload_throughput
    ///
    /// The upload throughput for http/3 requests larger than 10MB. Measured in megabits per second, Mbps.
    pub static http_3_upload_throughput: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_upload_throughput".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(103), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_upload_throughput_100
    ///
    /// The upload throughput for http/3 request size larger than 100MB. Measured in megabits per second, Mbps.
    pub static http_3_upload_throughput_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_upload_throughput_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(104), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_upload_throughput_10_50
    ///
    /// The upload throughput for http/3 request size between 10MB and 50MB. Measured in megabits per second, Mbps.
    pub static http_3_upload_throughput_10_50: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_upload_throughput_10_50".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(105), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_3_upload_throughput_50_100
    ///
    /// The upload throughput for http/3 request size between 50MB and 100MB. Measured in megabits per second, Mbps.
    pub static http_3_upload_throughput_50_100: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_3_upload_throughput_50_100".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(106), meta, 0, 5000, 100, HistogramType::Exponential)
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionLabel {
        EHttpCancelled = 0,
        EHttpDisk = 1,
        EHttpNetOk = 2,
        EHttpNetEarlyFail = 3,
        EHttpNetLateFail = 4,
        EHttpsCancelled = 5,
        EHttpsDisk = 6,
        EHttpsNetOk = 7,
        EHttpsNetEarlyFail = 8,
        EHttpsNetLateFail = 9,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EHttpCancelled,
                1 => Self::EHttpDisk,
                2 => Self::EHttpNetOk,
                3 => Self::EHttpNetEarlyFail,
                4 => Self::EHttpNetLateFail,
                5 => Self::EHttpsCancelled,
                6 => Self::EHttpsDisk,
                7 => Self::EHttpsNetOk,
                8 => Self::EHttpsNetEarlyFail,
                9 => Self::EHttpsNetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EHttpCancelled => "http_cancelled",
                Self::EHttpDisk => "http_disk",
                Self::EHttpNetOk => "http_net_ok",
                Self::EHttpNetEarlyFail => "http_net_early_fail",
                Self::EHttpNetLateFail => "http_net_late_fail",
                Self::EHttpsCancelled => "https_cancelled",
                Self::EHttpsDisk => "https_disk",
                Self::EHttpsNetOk => "https_net_ok",
                Self::EHttpsNetEarlyFail => "https_net_early_fail",
                Self::EHttpsNetLateFail => "https_net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition
    ///
    /// Channel Disposition for HTTP and HTTPS: cancel, disk, net_ok, net_early_fail, and net_late_fail
    pub static http_channel_disposition: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(107), meta, Some(vec![::std::borrow::Cow::from("http_cancelled"), ::std::borrow::Cow::from("http_disk"), ::std::borrow::Cow::from("http_net_early_fail"), ::std::borrow::Cow::from("http_net_late_fail"), ::std::borrow::Cow::from("http_net_ok"), ::std::borrow::Cow::from("https_cancelled"), ::std::borrow::Cow::from("https_disk"), ::std::borrow::Cow::from("https_net_early_fail"), ::std::borrow::Cow::from("https_net_late_fail"), ::std::borrow::Cow::from("https_net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionDisabledNoReasonLabel {
        ECancel = 0,
        EDisk = 1,
        ENetOk = 2,
        ENetEarlyFail = 3,
        ENetLateFail = 4,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionDisabledNoReasonLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECancel,
                1 => Self::EDisk,
                2 => Self::ENetOk,
                3 => Self::ENetEarlyFail,
                4 => Self::ENetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionDisabledNoReasonLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECancel => "cancel",
                Self::EDisk => "disk",
                Self::ENetOk => "net_ok",
                Self::ENetEarlyFail => "net_early_fail",
                Self::ENetLateFail => "net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition_disabled_no_reason
    ///
    /// Upgrading display content Channel Disposition (key: disabled_no_reason)
    pub static http_channel_disposition_disabled_no_reason: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionDisabledNoReasonLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition_disabled_no_reason".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(108), meta, Some(vec![::std::borrow::Cow::from("cancel"), ::std::borrow::Cow::from("disk"), ::std::borrow::Cow::from("net_early_fail"), ::std::borrow::Cow::from("net_late_fail"), ::std::borrow::Cow::from("net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionDisabledUpgradeLabel {
        ECancel = 0,
        EDisk = 1,
        ENetOk = 2,
        ENetEarlyFail = 3,
        ENetLateFail = 4,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionDisabledUpgradeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECancel,
                1 => Self::EDisk,
                2 => Self::ENetOk,
                3 => Self::ENetEarlyFail,
                4 => Self::ENetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionDisabledUpgradeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECancel => "cancel",
                Self::EDisk => "disk",
                Self::ENetOk => "net_ok",
                Self::ENetEarlyFail => "net_early_fail",
                Self::ENetLateFail => "net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition_disabled_upgrade
    ///
    /// Upgrading display content Channel Disposition (key: disable_upgrade)
    pub static http_channel_disposition_disabled_upgrade: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionDisabledUpgradeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition_disabled_upgrade".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(109), meta, Some(vec![::std::borrow::Cow::from("cancel"), ::std::borrow::Cow::from("disk"), ::std::borrow::Cow::from("net_early_fail"), ::std::borrow::Cow::from("net_late_fail"), ::std::borrow::Cow::from("net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionDisabledWontLabel {
        ECancel = 0,
        EDisk = 1,
        ENetOk = 2,
        ENetEarlyFail = 3,
        ENetLateFail = 4,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionDisabledWontLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECancel,
                1 => Self::EDisk,
                2 => Self::ENetOk,
                3 => Self::ENetEarlyFail,
                4 => Self::ENetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionDisabledWontLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECancel => "cancel",
                Self::EDisk => "disk",
                Self::ENetOk => "net_ok",
                Self::ENetEarlyFail => "net_early_fail",
                Self::ENetLateFail => "net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition_disabled_wont
    ///
    /// Upgrading display content Channel Disposition (key: disabled_wont)
    pub static http_channel_disposition_disabled_wont: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionDisabledWontLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition_disabled_wont".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(110), meta, Some(vec![::std::borrow::Cow::from("cancel"), ::std::borrow::Cow::from("disk"), ::std::borrow::Cow::from("net_early_fail"), ::std::borrow::Cow::from("net_late_fail"), ::std::borrow::Cow::from("net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionEnabledNoReasonLabel {
        ECancel = 0,
        EDisk = 1,
        ENetOk = 2,
        ENetEarlyFail = 3,
        ENetLateFail = 4,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionEnabledNoReasonLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECancel,
                1 => Self::EDisk,
                2 => Self::ENetOk,
                3 => Self::ENetEarlyFail,
                4 => Self::ENetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionEnabledNoReasonLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECancel => "cancel",
                Self::EDisk => "disk",
                Self::ENetOk => "net_ok",
                Self::ENetEarlyFail => "net_early_fail",
                Self::ENetLateFail => "net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition_enabled_no_reason
    ///
    /// Upgrading display content Channel Disposition (key: enabled_no_reason)
    pub static http_channel_disposition_enabled_no_reason: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionEnabledNoReasonLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition_enabled_no_reason".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(111), meta, Some(vec![::std::borrow::Cow::from("cancel"), ::std::borrow::Cow::from("disk"), ::std::borrow::Cow::from("net_early_fail"), ::std::borrow::Cow::from("net_late_fail"), ::std::borrow::Cow::from("net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionEnabledUpgradeLabel {
        ECancel = 0,
        EDisk = 1,
        ENetOk = 2,
        ENetEarlyFail = 3,
        ENetLateFail = 4,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionEnabledUpgradeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECancel,
                1 => Self::EDisk,
                2 => Self::ENetOk,
                3 => Self::ENetEarlyFail,
                4 => Self::ENetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionEnabledUpgradeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECancel => "cancel",
                Self::EDisk => "disk",
                Self::ENetOk => "net_ok",
                Self::ENetEarlyFail => "net_early_fail",
                Self::ENetLateFail => "net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition_enabled_upgrade
    ///
    /// Upgrading display content Channel Disposition (key: enable_upgrade)
    pub static http_channel_disposition_enabled_upgrade: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionEnabledUpgradeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition_enabled_upgrade".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(112), meta, Some(vec![::std::borrow::Cow::from("cancel"), ::std::borrow::Cow::from("disk"), ::std::borrow::Cow::from("net_early_fail"), ::std::borrow::Cow::from("net_late_fail"), ::std::borrow::Cow::from("net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelDispositionEnabledWontLabel {
        ECancel = 0,
        EDisk = 1,
        ENetOk = 2,
        ENetEarlyFail = 3,
        ENetLateFail = 4,
        __Other__,
    }
    impl From<u16> for HttpChannelDispositionEnabledWontLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ECancel,
                1 => Self::EDisk,
                2 => Self::ENetOk,
                3 => Self::ENetEarlyFail,
                4 => Self::ENetLateFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelDispositionEnabledWontLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ECancel => "cancel",
                Self::EDisk => "disk",
                Self::ENetOk => "net_ok",
                Self::ENetEarlyFail => "net_early_fail",
                Self::ENetLateFail => "net_late_fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_disposition_enabled_wont
    ///
    /// Upgrading display content Channel Disposition (key: enabled_wont)
    pub static http_channel_disposition_enabled_wont: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelDispositionEnabledWontLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_disposition_enabled_wont".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(113), meta, Some(vec![::std::borrow::Cow::from("cancel"), ::std::borrow::Cow::from("disk"), ::std::borrow::Cow::from("net_early_fail"), ::std::borrow::Cow::from("net_late_fail"), ::std::borrow::Cow::from("net_ok")]))
    });

    #[repr(u16)]
    pub enum HttpChannelOnstartStatusLabel {
        ESuccessful = 0,
        EFail = 1,
        __Other__,
    }
    impl From<u16> for HttpChannelOnstartStatusLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccessful,
                1 => Self::EFail,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelOnstartStatusLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccessful => "successful",
                Self::EFail => "fail",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_onstart_status
    ///
    /// Whether successfully started HTTP channels
    pub static http_channel_onstart_status: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelOnstartStatusLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_onstart_status".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(114), meta, Some(vec![::std::borrow::Cow::from("fail"), ::std::borrow::Cow::from("successful")]))
    });

    #[repr(u16)]
    pub enum HttpChannelOnstartSuccessHttpsRrLabel {
        ESuccess = 0,
        EFailure = 1,
        ESuccessEchUsed = 2,
        EFailureEchUsed = 3,
        __Other__,
    }
    impl From<u16> for HttpChannelOnstartSuccessHttpsRrLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccess,
                1 => Self::EFailure,
                2 => Self::ESuccessEchUsed,
                3 => Self::EFailureEchUsed,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpChannelOnstartSuccessHttpsRrLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccess => "success",
                Self::EFailure => "failure",
                Self::ESuccessEchUsed => "success_ech_used",
                Self::EFailureEchUsed => "failure_ech_used",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_onstart_success_https_rr
    ///
    /// Successfully started HTTP channels when HTTPS RR is used
    pub static http_channel_onstart_success_https_rr: Lazy<LabeledMetric<LabeledCounterMetric, HttpChannelOnstartSuccessHttpsRrLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_channel_onstart_success_https_rr".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(115), meta, Some(vec![::std::borrow::Cow::from("failure"), ::std::borrow::Cow::from("failure_ech_used"), ::std::borrow::Cow::from("success"), ::std::borrow::Cow::from("success_ech_used")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_page_open_to_first_sent
    ///
    /// Time in milliseconds from AsyncOpen to first byte of request sent, applicable for page loads without HTTPS RR
    pub static http_channel_page_open_to_first_sent: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_channel_page_open_to_first_sent".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(116), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_page_open_to_first_sent_https_rr
    ///
    /// Time in milliseconds from AsyncOpen to first byte of request sent, applicable for page loads with HTTPS RR
    pub static http_channel_page_open_to_first_sent_https_rr: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_channel_page_open_to_first_sent_https_rr".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(117), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_sub_open_to_first_sent
    ///
    /// Time in milliseconds from AsyncOpen to first byte of request sent, applicable for sub-resource loads without HTTPS RR
    pub static http_channel_sub_open_to_first_sent: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_channel_sub_open_to_first_sent".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(118), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_channel_sub_open_to_first_sent_https_rr
    ///
    /// Time in milliseconds from AsyncOpen to first byte of request sent, applicable for sub-resource loads with HTTPS RR
    pub static http_channel_sub_open_to_first_sent_https_rr: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_channel_sub_open_to_first_sent_https_rr".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(119), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_cssloader_ondatafinished_to_onstop_delay
    ///
    /// The time between processing OnDataFinished and processing OnStopRequest for CSSLoader in the content process
    pub static http_content_cssloader_ondatafinished_to_onstop_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_cssloader_ondatafinished_to_onstop_delay".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(120), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_html5parser_ondatafinished_to_onstop_delay
    ///
    /// The time between processing OnDataFinished and processing OnStopRequest (if OnDataFinished comes first)
    pub static http_content_html5parser_ondatafinished_to_onstop_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_html5parser_ondatafinished_to_onstop_delay".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(121), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_ondatafinished_delay
    ///
    /// The time between dispatching OnDataFinished from the socket thread and processing it on main/background thread.
    pub static http_content_ondatafinished_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_ondatafinished_delay".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(122), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_ondatafinished_delay_2
    ///
    /// The time between dispatching OnDataFinished from the socket thread and processing it on the background thread.
    pub static http_content_ondatafinished_delay_2: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_ondatafinished_delay_2".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(123), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_ondatafinished_to_onstop_delay
    ///
    /// The time between processing OnDataFinished and processing OnStopRequest (if OnDataFinished comes first)
    pub static http_content_ondatafinished_to_onstop_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_ondatafinished_to_onstop_delay".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(124), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_onstart_delay
    ///
    /// The time between dispatching OnStartRequest from the socket thread and processing it on the main thread (content process).
    pub static http_content_onstart_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_onstart_delay".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(125), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_content_onstop_delay
    ///
    /// The time between dispatching OnStopRequest from the socket thread and processing it on the main thread (content process).
    pub static http_content_onstop_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_onstop_delay".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(126), meta, TimeUnit::Millisecond)
    });

    #[repr(u16)]
    pub enum HttpIpAddrAnyCountLabel {
        ENotBlockedRequests = 0,
        EBlockedRequests = 1,
        __Other__,
    }
    impl From<u16> for HttpIpAddrAnyCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ENotBlockedRequests,
                1 => Self::EBlockedRequests,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpIpAddrAnyCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ENotBlockedRequests => "not_blocked_requests",
                Self::EBlockedRequests => "blocked_requests",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_ip_addr_any_count
    ///
    /// The number of times we see the IP address 0.0.0.0 or its IPv6 equivalent.
    pub static http_ip_addr_any_count: Lazy<LabeledMetric<LabeledCounterMetric, HttpIpAddrAnyCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_ip_addr_any_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(127), meta, Some(vec![::std::borrow::Cow::from("blocked_requests"), ::std::borrow::Cow::from("not_blocked_requests")]))
    });

    #[repr(u16)]
    pub enum HttpIpAddrAnyHostnamesLabel {
        ESuccess = 0,
        EFailure = 1,
        __Other__,
    }
    impl From<u16> for HttpIpAddrAnyHostnamesLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccess,
                1 => Self::EFailure,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpIpAddrAnyHostnamesLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccess => "success",
                Self::EFailure => "failure",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_ip_addr_any_hostnames
    ///
    /// The number of times we see the IP address 0.0.0.0 or its IPv6 equivalent used as hostnames
    pub static http_ip_addr_any_hostnames: Lazy<LabeledMetric<LabeledCounterMetric, HttpIpAddrAnyHostnamesLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_ip_addr_any_hostnames".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(128), meta, Some(vec![::std::borrow::Cow::from("failure"), ::std::borrow::Cow::from("success")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_onstart_suspend_total_time
    ///
    /// Time in milliseconds that http channel spent suspended between AsyncOpen and OnStartRequest.
    pub static http_onstart_suspend_total_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_onstart_suspend_total_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(129), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_redirect_to_scheme_subresource
    ///
    /// Count of the HTTP redirection that triggered by subresource, keyed by the URL scheme redirected to
    pub static http_redirect_to_scheme_subresource: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_redirect_to_scheme_subresource".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(130), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http_redirect_to_scheme_top_level
    ///
    /// Count of the HTTP redirection that triggered by top-level document, keyed by the URL scheme redirected to
    pub static http_redirect_to_scheme_top_level: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_redirect_to_scheme_top_level".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(131), meta, None)
    });

    #[repr(u16)]
    pub enum HttpResponseStatusCodeLabel {
        E200Ok = 0,
        E301MovedPermanently = 1,
        E302Found = 2,
        E304NotModified = 3,
        E307TemporaryRedirect = 4,
        E308PermanentRedirect = 5,
        E400BadRequest = 6,
        E401Unauthorized = 7,
        E403Forbidden = 8,
        E404NotFound = 9,
        E421MisdirectedRequest = 10,
        E425TooEarly = 11,
        E429TooManyRequests = 12,
        EOther4xx = 13,
        EOther5xx = 14,
        EOther = 15,
        __Other__,
    }
    impl From<u16> for HttpResponseStatusCodeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::E200Ok,
                1 => Self::E301MovedPermanently,
                2 => Self::E302Found,
                3 => Self::E304NotModified,
                4 => Self::E307TemporaryRedirect,
                5 => Self::E308PermanentRedirect,
                6 => Self::E400BadRequest,
                7 => Self::E401Unauthorized,
                8 => Self::E403Forbidden,
                9 => Self::E404NotFound,
                10 => Self::E421MisdirectedRequest,
                11 => Self::E425TooEarly,
                12 => Self::E429TooManyRequests,
                13 => Self::EOther4xx,
                14 => Self::EOther5xx,
                15 => Self::EOther,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpResponseStatusCodeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::E200Ok => "200_ok",
                Self::E301MovedPermanently => "301_moved_permanently",
                Self::E302Found => "302_found",
                Self::E304NotModified => "304_not_modified",
                Self::E307TemporaryRedirect => "307_temporary_redirect",
                Self::E308PermanentRedirect => "308_permanent_redirect",
                Self::E400BadRequest => "400_bad_request",
                Self::E401Unauthorized => "401_unauthorized",
                Self::E403Forbidden => "403_forbidden",
                Self::E404NotFound => "404_not_found",
                Self::E421MisdirectedRequest => "421_misdirected_request",
                Self::E425TooEarly => "425_too_early",
                Self::E429TooManyRequests => "429_too_many_requests",
                Self::EOther4xx => "other_4xx",
                Self::EOther5xx => "other_5xx",
                Self::EOther => "other",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_response_status_code
    ///
    /// HTTP Response Status Code (200, 301, 302, 304, 307, 308, 400, 401, 403, 404, 421, 425, 429, other 400 and 500)
    pub static http_response_status_code: Lazy<LabeledMetric<LabeledCounterMetric, HttpResponseStatusCodeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_response_status_code".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(132), meta, Some(vec![::std::borrow::Cow::from("200_ok"), ::std::borrow::Cow::from("301_moved_permanently"), ::std::borrow::Cow::from("302_found"), ::std::borrow::Cow::from("304_not_modified"), ::std::borrow::Cow::from("307_temporary_redirect"), ::std::borrow::Cow::from("308_permanent_redirect"), ::std::borrow::Cow::from("400_bad_request"), ::std::borrow::Cow::from("401_unauthorized"), ::std::borrow::Cow::from("403_forbidden"), ::std::borrow::Cow::from("404_not_found"), ::std::borrow::Cow::from("421_misdirected_request"), ::std::borrow::Cow::from("425_too_early"), ::std::borrow::Cow::from("429_too_many_requests"), ::std::borrow::Cow::from("other"), ::std::borrow::Cow::from("other_4xx"), ::std::borrow::Cow::from("other_5xx")]))
    });

    #[repr(u16)]
    pub enum HttpResponseVersionLabel {
        EUnknown = 0,
        EHttp1 = 1,
        EHttp2 = 2,
        EHttp3 = 3,
        __Other__,
    }
    impl From<u16> for HttpResponseVersionLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EUnknown,
                1 => Self::EHttp1,
                2 => Self::EHttp2,
                3 => Self::EHttp3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpResponseVersionLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EUnknown => "unknown",
                Self::EHttp1 => "http_1",
                Self::EHttp2 => "http_2",
                Self::EHttp3 => "http_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_response_version
    ///
    /// HTTP protocol version used on response from nsHttp.h
    pub static http_response_version: Lazy<LabeledMetric<LabeledCounterMetric, HttpResponseVersionLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_response_version".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(133), meta, Some(vec![::std::borrow::Cow::from("http_1"), ::std::borrow::Cow::from("http_2"), ::std::borrow::Cow::from("http_3"), ::std::borrow::Cow::from("unknown")]))
    });

    #[repr(u16)]
    pub enum HttpToHttpsUpgradeReasonLabel {
        ENotInitialized = 0,
        ENotInitializedHttps = 1,
        ENoUpgrade = 2,
        ENoUpgradeHttps = 3,
        EAlreadyHttps = 4,
        EHsts = 5,
        EHttpsOnlyUpgrade = 6,
        EHttpsOnlyUpgradeDowngrade = 7,
        EHttpsFirstUpgrade = 8,
        EHttpsFirstUpgradeDowngrade = 9,
        EHttpsFirstSchemelessUpgrade = 10,
        EHttpsFirstSchemelessUpgradeDowngrade = 11,
        ECspUir = 12,
        EHttpsRr = 13,
        EWebExtensionUpgrade = 14,
        EUpgradeException = 15,
        ESkipUpgrade = 16,
        __Other__,
    }
    impl From<u16> for HttpToHttpsUpgradeReasonLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ENotInitialized,
                1 => Self::ENotInitializedHttps,
                2 => Self::ENoUpgrade,
                3 => Self::ENoUpgradeHttps,
                4 => Self::EAlreadyHttps,
                5 => Self::EHsts,
                6 => Self::EHttpsOnlyUpgrade,
                7 => Self::EHttpsOnlyUpgradeDowngrade,
                8 => Self::EHttpsFirstUpgrade,
                9 => Self::EHttpsFirstUpgradeDowngrade,
                10 => Self::EHttpsFirstSchemelessUpgrade,
                11 => Self::EHttpsFirstSchemelessUpgradeDowngrade,
                12 => Self::ECspUir,
                13 => Self::EHttpsRr,
                14 => Self::EWebExtensionUpgrade,
                15 => Self::EUpgradeException,
                16 => Self::ESkipUpgrade,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpToHttpsUpgradeReasonLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ENotInitialized => "not_initialized",
                Self::ENotInitializedHttps => "not_initialized_https",
                Self::ENoUpgrade => "no_upgrade",
                Self::ENoUpgradeHttps => "no_upgrade_https",
                Self::EAlreadyHttps => "already_https",
                Self::EHsts => "hsts",
                Self::EHttpsOnlyUpgrade => "https_only_upgrade",
                Self::EHttpsOnlyUpgradeDowngrade => "https_only_upgrade_downgrade",
                Self::EHttpsFirstUpgrade => "https_first_upgrade",
                Self::EHttpsFirstUpgradeDowngrade => "https_first_upgrade_downgrade",
                Self::EHttpsFirstSchemelessUpgrade => "https_first_schemeless_upgrade",
                Self::EHttpsFirstSchemelessUpgradeDowngrade => "https_first_schemeless_upgrade_downgrade",
                Self::ECspUir => "csp_uir",
                Self::EHttpsRr => "https_rr",
                Self::EWebExtensionUpgrade => "web_extension_upgrade",
                Self::EUpgradeException => "upgrade_exception",
                Self::ESkipUpgrade => "skip_upgrade",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.http_to_https_upgrade_reason
    ///
    /// Whether a top-level HTTP request gets upgraded to HTTPS and the reason for it
    pub static http_to_https_upgrade_reason: Lazy<LabeledMetric<LabeledCounterMetric, HttpToHttpsUpgradeReasonLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "http_to_https_upgrade_reason".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(134), meta, Some(vec![::std::borrow::Cow::from("already_https"), ::std::borrow::Cow::from("csp_uir"), ::std::borrow::Cow::from("hsts"), ::std::borrow::Cow::from("https_first_schemeless_upgrade"), ::std::borrow::Cow::from("https_first_schemeless_upgrade_downgrade"), ::std::borrow::Cow::from("https_first_upgrade"), ::std::borrow::Cow::from("https_first_upgrade_downgrade"), ::std::borrow::Cow::from("https_only_upgrade"), ::std::borrow::Cow::from("https_only_upgrade_downgrade"), ::std::borrow::Cow::from("https_rr"), ::std::borrow::Cow::from("no_upgrade"), ::std::borrow::Cow::from("no_upgrade_https"), ::std::borrow::Cow::from("not_initialized"), ::std::borrow::Cow::from("not_initialized_https"), ::std::borrow::Cow::from("skip_upgrade"), ::std::borrow::Cow::from("upgrade_exception"), ::std::borrow::Cow::from("web_extension_upgrade")]))
    });

    #[repr(u16)]
    pub enum HttpsHttpOrLocalLabel {
        ELoadIsHttps = 0,
        ELoadIsHttp = 1,
        ELoadIsHttpForLocalDomain = 2,
        __Other__,
    }
    impl From<u16> for HttpsHttpOrLocalLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ELoadIsHttps,
                1 => Self::ELoadIsHttp,
                2 => Self::ELoadIsHttpForLocalDomain,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpsHttpOrLocalLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ELoadIsHttps => "load_is_https",
                Self::ELoadIsHttp => "load_is_http",
                Self::ELoadIsHttpForLocalDomain => "load_is_http_for_local_domain",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.https_http_or_local
    ///
    /// Whether a top-level request is HTTPS, HTTP, or HTTP for local domain
    pub static https_http_or_local: Lazy<LabeledMetric<LabeledCounterMetric, HttpsHttpOrLocalLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "https_http_or_local".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(135), meta, Some(vec![::std::borrow::Cow::from("load_is_http"), ::std::borrow::Cow::from("load_is_http_for_local_domain"), ::std::borrow::Cow::from("load_is_https")]))
    });

    #[repr(u16)]
    pub enum HttpsRrPresentedLabel {
        EPresented = 0,
        EPresentedWithHttp3 = 1,
        ENone = 2,
        __Other__,
    }
    impl From<u16> for HttpsRrPresentedLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EPresented,
                1 => Self::EPresentedWithHttp3,
                2 => Self::ENone,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpsRrPresentedLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EPresented => "presented",
                Self::EPresentedWithHttp3 => "presented_with_http3",
                Self::ENone => "none",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.https_rr_presented
    ///
    /// HTTPS RR is presented or not
    pub static https_rr_presented: Lazy<LabeledMetric<LabeledCounterMetric, HttpsRrPresentedLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "https_rr_presented".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(136), meta, Some(vec![::std::borrow::Cow::from("none"), ::std::borrow::Cow::from("presented"), ::std::borrow::Cow::from("presented_with_http3")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.os_socket_limit_reached
    ///
    /// Counts the number of times the os socket limit was reached. i.e. CanAttachSocket() returned false.
    pub static os_socket_limit_reached: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            137,
            "networking",
            "os_socket_limit_reached",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_tcp_blocking_time_connectivity_change
    ///
    /// Time spent blocked in PR_Close when there has been the connectivity change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_CONNECTIVITY_CHANGE.
    pub static prclose_tcp_blocking_time_connectivity_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_tcp_blocking_time_connectivity_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(138), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_tcp_blocking_time_link_change
    ///
    /// Time spent blocked in PR_Close when there has been a link change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_LINK_CHANGE.
    pub static prclose_tcp_blocking_time_link_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_tcp_blocking_time_link_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(139), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_tcp_blocking_time_normal
    ///
    /// Time spent blocked in PR_Close when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_NORMAL.
    pub static prclose_tcp_blocking_time_normal: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_tcp_blocking_time_normal".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(140), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_tcp_blocking_time_offline
    ///
    /// Time spent blocked in PR_Close when the offline state has changed in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_OFFLINE.
    pub static prclose_tcp_blocking_time_offline: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_tcp_blocking_time_offline".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(141), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_tcp_blocking_time_shutdown
    ///
    /// Time spent blocked in PR_Close during a shutdown (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_SHUTDOWN.
    pub static prclose_tcp_blocking_time_shutdown: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_tcp_blocking_time_shutdown".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(142), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_udp_blocking_time_connectivity_change
    ///
    /// Time spent blocked in PR_Close when there has been the connectivity change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_CONNECTIVITY_CHANGE.
    pub static prclose_udp_blocking_time_connectivity_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_udp_blocking_time_connectivity_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(143), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_udp_blocking_time_link_change
    ///
    /// Time spent blocked in PR_Close when there has been a link change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_LINK_CHANGE.
    pub static prclose_udp_blocking_time_link_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_udp_blocking_time_link_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(144), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_udp_blocking_time_normal
    ///
    /// Time spent blocked in PR_Close when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_NORMAL.
    pub static prclose_udp_blocking_time_normal: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_udp_blocking_time_normal".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(145), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_udp_blocking_time_offline
    ///
    /// Time spent blocked in PR_Close when the offline state has changed in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_OFFLINE.
    pub static prclose_udp_blocking_time_offline: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_udp_blocking_time_offline".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(146), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prclose_udp_blocking_time_shutdown
    ///
    /// Time spent blocked in PR_Close during a shutdown (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_SHUTDOWN.
    pub static prclose_udp_blocking_time_shutdown: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prclose_udp_blocking_time_shutdown".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(147), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_blocking_time_connectivity_change
    ///
    /// Time spent blocked in PR_Connect when there has been the connectiviy change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_CONNECTIVITY_CHANGE.
    pub static prconnect_blocking_time_connectivity_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_blocking_time_connectivity_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(148), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_blocking_time_link_change
    ///
    /// Time spent blocked in PR_Connect when there has been a link change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_LINK_CHANGE.
    pub static prconnect_blocking_time_link_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_blocking_time_link_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(149), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_blocking_time_normal
    ///
    /// Time spent blocked in PR_Connect when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_NORMAL.
    pub static prconnect_blocking_time_normal: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_blocking_time_normal".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(150), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_blocking_time_offline
    ///
    /// Time spent blocked in PR_Connect when the offline state has changed in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_OFFLINE.
    pub static prconnect_blocking_time_offline: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_blocking_time_offline".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(151), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_blocking_time_shutdown
    ///
    /// Time spent blocked in PR_Connect during a shutdown (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_SHUTDOWN.
    pub static prconnect_blocking_time_shutdown: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_blocking_time_shutdown".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(152), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_fail_blocking_time_connectivity_change
    ///
    /// Time spent blocked in a failed PR_Connect when there has been the connectiviy change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_CONNECTIVITY_CHANGE.
    pub static prconnect_fail_blocking_time_connectivity_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_fail_blocking_time_connectivity_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(153), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_fail_blocking_time_link_change
    ///
    /// Time spent blocked in a failed PR_Connect when there has been a link change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_LINK_CHANGE.
    pub static prconnect_fail_blocking_time_link_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_fail_blocking_time_link_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(154), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_fail_blocking_time_normal
    ///
    /// Time spent blocked in a failed PR_Connect when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_NORMAL.
    pub static prconnect_fail_blocking_time_normal: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_fail_blocking_time_normal".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(155), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_fail_blocking_time_offline
    ///
    /// Time spent blocked in a failed PR_Connect when the offline state has changed in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_OFFLINE.
    pub static prconnect_fail_blocking_time_offline: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_fail_blocking_time_offline".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(156), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnect_fail_blocking_time_shutdown
    ///
    /// Time spent blocked in a failed PR_Connect during a shutdown (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_SHUTDOWN.
    pub static prconnect_fail_blocking_time_shutdown: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnect_fail_blocking_time_shutdown".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(157), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnectcontinue_blocking_time_connectivity_change
    ///
    /// Time spent blocked in PR_ConnectContinue when there has been the connectivity change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_CONNECTIVITY_CHANGE.
    pub static prconnectcontinue_blocking_time_connectivity_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnectcontinue_blocking_time_connectivity_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(158), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnectcontinue_blocking_time_link_change
    ///
    /// Time spent blocked in PR_ConnectContinue when there has been a link change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_LINK_CHANGE.
    pub static prconnectcontinue_blocking_time_link_change: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnectcontinue_blocking_time_link_change".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(159), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnectcontinue_blocking_time_normal
    ///
    /// Time spent blocked in PR_ConnectContinue when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_NORMAL.
    pub static prconnectcontinue_blocking_time_normal: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnectcontinue_blocking_time_normal".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(160), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnectcontinue_blocking_time_offline
    ///
    /// Time spent blocked in PR_ConnectContinue when the offline state has changed in the last 60s (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_OFFLINE.
    pub static prconnectcontinue_blocking_time_offline: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnectcontinue_blocking_time_offline".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(161), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.prconnectcontinue_blocking_time_shutdown
    ///
    /// Time spent blocked in PR_ConnectContinue during a shutdown (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_SHUTDOWN.
    pub static prconnectcontinue_blocking_time_shutdown: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prconnectcontinue_blocking_time_shutdown".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(162), meta, TimeUnit::Millisecond)
    });

    #[repr(u16)]
    pub enum ProxyInfoTypeLabel {
        EHttp = 0,
        EHttps = 1,
        ESocks4 = 2,
        ESocks4a = 3,
        ESocks5 = 4,
        ESocks5h = 5,
        EDirect = 6,
        EUnknown = 7,
        __Other__,
    }
    impl From<u16> for ProxyInfoTypeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EHttp,
                1 => Self::EHttps,
                2 => Self::ESocks4,
                3 => Self::ESocks4a,
                4 => Self::ESocks5,
                5 => Self::ESocks5h,
                6 => Self::EDirect,
                7 => Self::EUnknown,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for ProxyInfoTypeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EHttp => "http",
                Self::EHttps => "https",
                Self::ESocks4 => "socks4",
                Self::ESocks4a => "socks4a",
                Self::ESocks5 => "socks5",
                Self::ESocks5h => "socks5h",
                Self::EDirect => "direct",
                Self::EUnknown => "unknown",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.proxy_info_type
    ///
    /// The proxies configurations created in the browser session (SOCKSv4, SOCKSv5, HTTP, HTTPS)
    pub static proxy_info_type: Lazy<LabeledMetric<LabeledCounterMetric, ProxyInfoTypeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "proxy_info_type".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(163), meta, Some(vec![::std::borrow::Cow::from("direct"), ::std::borrow::Cow::from("http"), ::std::borrow::Cow::from("https"), ::std::borrow::Cow::from("socks4"), ::std::borrow::Cow::from("socks4a"), ::std::borrow::Cow::from("socks5"), ::std::borrow::Cow::from("socks5h"), ::std::borrow::Cow::from("unknown")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.residual_cache_folder_count
    ///
    /// Counts how often we find a cache folder that wasn't purged at shutdown by a background task process.
    pub static residual_cache_folder_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            164,
            "networking",
            "residual_cache_folder_count",
            "metrics"
        )
    });

    #[repr(u16)]
    pub enum ResidualCacheFolderRemovalLabel {
        ESuccess = 0,
        EFailure = 1,
        __Other__,
    }
    impl From<u16> for ResidualCacheFolderRemovalLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccess,
                1 => Self::EFailure,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for ResidualCacheFolderRemovalLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccess => "success",
                Self::EFailure => "failure",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.residual_cache_folder_removal
    ///
    /// Counts how often succeed/fail in removing cache folder that wasn't purged at shutdown
    pub static residual_cache_folder_removal: Lazy<LabeledMetric<LabeledCounterMetric, ResidualCacheFolderRemovalLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "residual_cache_folder_removal".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(165), meta, Some(vec![::std::borrow::Cow::from("failure"), ::std::borrow::Cow::from("success")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.set_cookie
    ///
    /// This counts the number of times we set a cookie. Introduced as a denomenator for measuring CHIPS adoption.
    pub static set_cookie: Lazy<DenominatorMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_cookie".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        DenominatorMetric::new(MetricId(166), meta, vec![CommonMetricData {name: "set_cookie_foreign".into(), category: "networking".into(), send_in_pings: vec!["metrics".into()], lifetime: Lifetime::Ping, disabled: false,  ..Default::default()}, CommonMetricData {name: "set_cookie_foreign_partitioned".into(), category: "networking".into(), send_in_pings: vec!["metrics".into()], lifetime: Lifetime::Ping, disabled: false,  ..Default::default()}, CommonMetricData {name: "set_cookie_partitioned".into(), category: "networking".into(), send_in_pings: vec!["metrics".into()], lifetime: Lifetime::Ping, disabled: false,  ..Default::default()}])
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.set_cookie_foreign
    ///
    /// This counts the number of times we set a cookie from a foreign (not same-site) context. Introduced as a denomenator for measuring CHIPS adoption.
    pub static set_cookie_foreign: Lazy<NumeratorMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_cookie_foreign".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        NumeratorMetric::new(MetricId(167), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.set_cookie_foreign_partitioned
    ///
    /// This counts the number of times we set a cookie that has the Partitioned attribute in a foreign (not same-site) context. This tracks the adoption of CHIPS.
    pub static set_cookie_foreign_partitioned: Lazy<NumeratorMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_cookie_foreign_partitioned".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        NumeratorMetric::new(MetricId(168), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.set_cookie_partitioned
    ///
    /// This counts the number of times we set a cookie that has the Partitioned attribute. This tracks the adoption of CHIPS.
    pub static set_cookie_partitioned: Lazy<NumeratorMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_cookie_partitioned".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        NumeratorMetric::new(MetricId(169), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.set_invalid_first_party_partitioned_cookie
    ///
    /// This counts the number of times we set an invalid first-party partitioned cookie.
    pub static set_invalid_first_party_partitioned_cookie: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            170,
            "networking",
            "set_invalid_first_party_partitioned_cookie",
            "metrics"
        )
    });

    #[repr(u16)]
    pub enum SpeculativeConnectOutcomeLabel {
        ESuccessful = 0,
        EAbortedSocketLimit = 1,
        EAbortedSocketFail = 2,
        EAbortedHttpsNotEnabled = 3,
        __Other__,
    }
    impl From<u16> for SpeculativeConnectOutcomeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccessful,
                1 => Self::EAbortedSocketLimit,
                2 => Self::EAbortedSocketFail,
                3 => Self::EAbortedHttpsNotEnabled,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for SpeculativeConnectOutcomeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccessful => "successful",
                Self::EAbortedSocketLimit => "aborted_socket_limit",
                Self::EAbortedSocketFail => "aborted_socket_fail",
                Self::EAbortedHttpsNotEnabled => "aborted_https_not_enabled",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.speculative_connect_outcome
    ///
    /// Counts the occurrence of each outcome of a speculative connection
    pub static speculative_connect_outcome: Lazy<LabeledMetric<LabeledCounterMetric, SpeculativeConnectOutcomeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "speculative_connect_outcome".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(171), meta, Some(vec![::std::borrow::Cow::from("aborted_https_not_enabled"), ::std::borrow::Cow::from("aborted_socket_fail"), ::std::borrow::Cow::from("aborted_socket_limit"), ::std::borrow::Cow::from("successful")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.sqlite_cookies_block_main_thread
    ///
    /// Time spent on blocking main thread by startup cookie database read (in milliseconds), only for blocking case
    pub static sqlite_cookies_block_main_thread: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sqlite_cookies_block_main_thread".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(172), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.sqlite_cookies_time_to_block_main_thread
    ///
    /// How long (in milliseconds) after we finished reading the cookie db until the first cookie request came in (0 implies we blocked the main thread)
    pub static sqlite_cookies_time_to_block_main_thread: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sqlite_cookies_time_to_block_main_thread".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(173), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.transaction_wait_time
    ///
    /// Time from submission to dispatch of transaction without HTTPS RR (ms)
    pub static transaction_wait_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "transaction_wait_time".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(174), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.transaction_wait_time_https_rr
    ///
    /// Time from submission to dispatch of transaction when HTTPS RR is used (ms)
    pub static transaction_wait_time_https_rr: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "transaction_wait_time_https_rr".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(175), meta, TimeUnit::Millisecond)
    });

    #[repr(u16)]
    pub enum TrrCompleteLoadLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrCompleteLoadLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrCompleteLoadLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_complete_load
    ///
    /// In TRR channel, overall load time.
    pub static trr_complete_load: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrCompleteLoadLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_complete_load".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(176), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrDnsEndLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrDnsEndLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrDnsEndLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_dns_end
    ///
    /// In TRR channel, time from the DNS request being issued to the response.
    pub static trr_dns_end: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrDnsEndLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_dns_end".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(177), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrDnsStartLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrDnsStartLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrDnsStartLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_dns_start
    ///
    /// In TRR channel, time from connection open to the DNS request being issued.
    pub static trr_dns_start: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrDnsStartLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_dns_start".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(178), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrFetchDurationLabel {
        EH1 = 0,
        EH1NetworkOnly = 1,
        EH2 = 2,
        EH2NetworkOnly = 3,
        EH3 = 4,
        EH3NetworkOnly = 5,
        __Other__,
    }
    impl From<u16> for TrrFetchDurationLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EH1,
                1 => Self::EH1NetworkOnly,
                2 => Self::EH2,
                3 => Self::EH2NetworkOnly,
                4 => Self::EH3,
                5 => Self::EH3NetworkOnly,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrFetchDurationLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EH1 => "h1",
                Self::EH1NetworkOnly => "h1_network_only",
                Self::EH2 => "h2",
                Self::EH2NetworkOnly => "h2_network_only",
                Self::EH3 => "h3",
                Self::EH3NetworkOnly => "h3_network_only",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_fetch_duration
    ///
    /// Time for a successful DoH request, from AsyncOpen to ReturnData
    pub static trr_fetch_duration: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrFetchDurationLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_fetch_duration".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(179), meta, Some(vec![::std::borrow::Cow::from("h1"), ::std::borrow::Cow::from("h1_network_only"), ::std::borrow::Cow::from("h2"), ::std::borrow::Cow::from("h2_network_only"), ::std::borrow::Cow::from("h3"), ::std::borrow::Cow::from("h3_network_only")]))
    });

    #[repr(u16)]
    pub enum TrrFirstSentToLastReceivedLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrFirstSentToLastReceivedLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrFirstSentToLastReceivedLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_first_sent_to_last_received
    ///
    /// In TRR channel, time from first byte of request sent to last byte of response received.
    pub static trr_first_sent_to_last_received: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrFirstSentToLastReceivedLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_first_sent_to_last_received".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(180), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrOpenToFirstReceivedLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrOpenToFirstReceivedLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrOpenToFirstReceivedLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_open_to_first_received
    ///
    /// In TRR channel, time from open to first byte of reply received.
    pub static trr_open_to_first_received: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrOpenToFirstReceivedLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_open_to_first_received".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(181), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrOpenToFirstSentLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrOpenToFirstSentLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrOpenToFirstSentLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_open_to_first_sent
    ///
    /// In TRR channel, time from open to first byte of request.
    pub static trr_open_to_first_sent: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrOpenToFirstSentLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_open_to_first_sent".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(182), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrRequestCountLabel {
        ERegular = 0,
        EPrivate = 1,
        __Other__,
    }
    impl From<u16> for TrrRequestCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ERegular,
                1 => Self::EPrivate,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrRequestCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ERegular => "regular",
                Self::EPrivate => "private",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_request_count
    ///
    /// The count of successful TRR requests keyed by regular/private browsing
    pub static trr_request_count: Lazy<LabeledMetric<LabeledCounterMetric, TrrRequestCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "trr_request_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(183), meta, Some(vec![::std::borrow::Cow::from("private"), ::std::borrow::Cow::from("regular")]))
    });

    #[repr(u16)]
    pub enum TrrRequestCountPerConnLabel {
        EH1 = 0,
        EH2 = 1,
        EH3 = 2,
        __Other__,
    }
    impl From<u16> for TrrRequestCountPerConnLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EH1,
                1 => Self::EH2,
                2 => Self::EH3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrRequestCountPerConnLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EH1 => "h1",
                Self::EH2 => "h2",
                Self::EH3 => "h3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_request_count_per_conn
    ///
    /// Number of DOH requests per connection keyed by HTTP version
    pub static trr_request_count_per_conn: Lazy<LabeledMetric<LabeledCounterMetric, TrrRequestCountPerConnLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "trr_request_count_per_conn".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(184), meta, Some(vec![::std::borrow::Cow::from("h1"), ::std::borrow::Cow::from("h2"), ::std::borrow::Cow::from("h3")]))
    });

    #[repr(u16)]
    pub enum TrrTcpConnectionLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrTcpConnectionLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrTcpConnectionLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_tcp_connection
    ///
    /// In TRR channel, time from the TCP SYN packet is received to the connection is established and ready for HTTP.
    pub static trr_tcp_connection: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrTcpConnectionLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_tcp_connection".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(185), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[repr(u16)]
    pub enum TrrTlsHandshakeLabel {
        EMozillaCloudflareDnsCom = 0,
        EFirefoxDnsNextdnsIo = 1,
        EPrivateCanadianshieldCiraCa = 2,
        EDohXfinityCom = 3,
        EDnsShawCa = 4,
        EDoohCloudflareDnsCom = 5,
        EMozillaCloudflareDnsCom2 = 6,
        EFirefoxDnsNextdnsIo2 = 7,
        EPrivateCanadianshieldCiraCa2 = 8,
        EDohXfinityCom2 = 9,
        EDnsShawCa2 = 10,
        EDoohCloudflareDnsCom2 = 11,
        EMozillaCloudflareDnsCom3 = 12,
        EFirefoxDnsNextdnsIo3 = 13,
        EPrivateCanadianshieldCiraCa3 = 14,
        EDohXfinityCom3 = 15,
        EDnsShawCa3 = 16,
        EDoohCloudflareDnsCom3 = 17,
        __Other__,
    }
    impl From<u16> for TrrTlsHandshakeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EMozillaCloudflareDnsCom,
                1 => Self::EFirefoxDnsNextdnsIo,
                2 => Self::EPrivateCanadianshieldCiraCa,
                3 => Self::EDohXfinityCom,
                4 => Self::EDnsShawCa,
                5 => Self::EDoohCloudflareDnsCom,
                6 => Self::EMozillaCloudflareDnsCom2,
                7 => Self::EFirefoxDnsNextdnsIo2,
                8 => Self::EPrivateCanadianshieldCiraCa2,
                9 => Self::EDohXfinityCom2,
                10 => Self::EDnsShawCa2,
                11 => Self::EDoohCloudflareDnsCom2,
                12 => Self::EMozillaCloudflareDnsCom3,
                13 => Self::EFirefoxDnsNextdnsIo3,
                14 => Self::EPrivateCanadianshieldCiraCa3,
                15 => Self::EDohXfinityCom3,
                16 => Self::EDnsShawCa3,
                17 => Self::EDoohCloudflareDnsCom3,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for TrrTlsHandshakeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EMozillaCloudflareDnsCom => "mozilla.cloudflare-dns.com",
                Self::EFirefoxDnsNextdnsIo => "firefox.dns.nextdns.io",
                Self::EPrivateCanadianshieldCiraCa => "private.canadianshield.cira.ca",
                Self::EDohXfinityCom => "doh.xfinity.com",
                Self::EDnsShawCa => "dns.shaw.ca",
                Self::EDoohCloudflareDnsCom => "dooh.cloudflare-dns.com",
                Self::EMozillaCloudflareDnsCom2 => "mozilla.cloudflare-dns.com_2",
                Self::EFirefoxDnsNextdnsIo2 => "firefox.dns.nextdns.io_2",
                Self::EPrivateCanadianshieldCiraCa2 => "private.canadianshield.cira.ca_2",
                Self::EDohXfinityCom2 => "doh.xfinity.com_2",
                Self::EDnsShawCa2 => "dns.shaw.ca_2",
                Self::EDoohCloudflareDnsCom2 => "dooh.cloudflare-dns.com_2",
                Self::EMozillaCloudflareDnsCom3 => "mozilla.cloudflare-dns.com_3",
                Self::EFirefoxDnsNextdnsIo3 => "firefox.dns.nextdns.io_3",
                Self::EPrivateCanadianshieldCiraCa3 => "private.canadianshield.cira.ca_3",
                Self::EDohXfinityCom3 => "doh.xfinity.com_3",
                Self::EDnsShawCa3 => "dns.shaw.ca_3",
                Self::EDoohCloudflareDnsCom3 => "dooh.cloudflare-dns.com_3",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_tls_handshake
    ///
    /// In TRR channel, time from after the TCP SYN packet is received to the secure connection is established and ready for HTTP.
    pub static trr_tls_handshake: Lazy<LabeledMetric<LabeledTimingDistributionMetric, TrrTlsHandshakeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::TimingDistribution {
                cmd: CommonMetricData {
                    name: "trr_tls_handshake".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, unit: TimeUnit::Millisecond};
        LabeledMetric::new(MetricId(186), meta, Some(vec![::std::borrow::Cow::from("dns.shaw.ca"), ::std::borrow::Cow::from("dns.shaw.ca_2"), ::std::borrow::Cow::from("dns.shaw.ca_3"), ::std::borrow::Cow::from("doh.xfinity.com"), ::std::borrow::Cow::from("doh.xfinity.com_2"), ::std::borrow::Cow::from("doh.xfinity.com_3"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_2"), ::std::borrow::Cow::from("dooh.cloudflare-dns.com_3"), ::std::borrow::Cow::from("firefox.dns.nextdns.io"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_2"), ::std::borrow::Cow::from("firefox.dns.nextdns.io_3"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_2"), ::std::borrow::Cow::from("mozilla.cloudflare-dns.com_3"), ::std::borrow::Cow::from("private.canadianshield.cira.ca"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_2"), ::std::borrow::Cow::from("private.canadianshield.cira.ca_3")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.data_transferred_v3_kb
    ///
    /// How many KB of HTTP data transferred by type, there are some categories separated by keys based on 5 parameters:
    ///   1. normal browsing or private browsing
    ///   2. system principal or not
    ///   3. first party or third party
    ///   4. class of service (Leader/Background/Others)
    ///   5. tracking classification (Basic/Content/FingerprintingContent)
    /// 
    /// Available keys are:
    ///   "Y0_N1Sys",
    ///   "Y1_N1",
    ///   "Y2_N3Oth",
    ///   "Y3_N3BasicLead",
    ///   "Y4_N3BasicBg",
    ///   "Y5_N3BasicOth",
    ///   "Y6_N3ContentLead",
    ///   "Y7_N3ContentBg",
    ///   "Y8_N3ContentOth",
    ///   "Y9_N3FpLead",
    ///   "Y10_N3FpBg",
    ///   "Y11_N3FpOth",
    ///   "Y12_P1Sys",
    ///   "Y13_P1",
    ///   "Y14_P3Oth",
    ///   "Y15_P3BasicLead",
    ///   "Y16_P3BasicBg",
    ///   "Y17_P3BasicOth",
    ///   "Y18_P3ContentLead",
    ///   "Y19_P3ContentBg",
    ///   "Y20_P3ContentOth",
    ///   "Y21_P3FpLead",
    ///   "Y22_P3FpBg",
    ///   "Y23_P3FpOth"
    /// 
    /// This metric was generated to correspond to the Legacy Telemetry scalar networking.data_transferred_v3_kb.
    pub static data_transferred_v3_kb: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "data_transferred_v3_kb".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(187), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.http3_enabled
    ///
    /// True if HTTP3 is enabled at the start of a session. This metric was generated to correspond to the Legacy Telemetry scalar networking.http3_enabled.
    pub static http3_enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http3_enabled".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(188), meta)
    });

    #[repr(u16)]
    pub enum HttpsRecordStateLabel {
        EInvalid = 0,
        ESucceeded = 1,
        EUnmatchedCname = 2,
        EAllExcluded = 3,
        ENoDefaultAlpn = 4,
        EOthers = 5,
        __Other__,
    }
    impl From<u16> for HttpsRecordStateLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EInvalid,
                1 => Self::ESucceeded,
                2 => Self::EUnmatchedCname,
                3 => Self::EAllExcluded,
                4 => Self::ENoDefaultAlpn,
                5 => Self::EOthers,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HttpsRecordStateLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EInvalid => "invalid",
                Self::ESucceeded => "succeeded",
                Self::EUnmatchedCname => "unmatched_cname",
                Self::EAllExcluded => "all_excluded",
                Self::ENoDefaultAlpn => "no_default_alpn",
                Self::EOthers => "others",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from networking.https_record_state
    ///
    /// Gather the outcome of checking if a HTTPS record can be used: - "invalid" - "succeeded" - "unmatched_cname" - "all_excluded" - "no_default_alpn" - "others"
    pub static https_record_state: Lazy<LabeledMetric<LabeledCounterMetric, HttpsRecordStateLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "https_record_state".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(189), meta, Some(vec![::std::borrow::Cow::from("all_excluded"), ::std::borrow::Cow::from("invalid"), ::std::borrow::Cow::from("no_default_alpn"), ::std::borrow::Cow::from("others"), ::std::borrow::Cow::from("succeeded"), ::std::borrow::Cow::from("unmatched_cname")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.https_rr_prefs_usage
    ///
    /// A bitfield representation for the usage of HTTPS RR prefs. bit 0: network.dns.upgrade_with_https_rr is enabled or not. bit 1: network.dns.use_https_rr_as_altsvc is enabled or not. bit 2: network.dns.echconfig.enabled is enabled or not. This metric was generated to correspond to the Legacy Telemetry scalar networking.https_rr_prefs_usage.
    pub static https_rr_prefs_usage: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "https_rr_prefs_usage".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(190), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.trr_connection_cycle_count
    ///
    /// Number of times we cycled the TRR connection during a subsession. Keyed by TRR provider URL. This metric was generated to correspond to the Legacy Telemetry scalar networking.trr_connection_cycle_count.
    pub static trr_connection_cycle_count: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "trr_connection_cycle_count".into(),
                    category: "networking".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(191), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.loading_certs_task
    ///
    /// The time in milliseconds to load any external certificates. This occurs off of the main-thread, but can block main-thread operations. This metric was generated to correspond to the Legacy Telemetry scalar networking.loading_certs_task.
    pub static loading_certs_task: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "loading_certs_task".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(192), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from networking.nss_initialization
    ///
    /// The time in milliseconds to initialize the NSS component in the parent process. This metric was generated to correspond to the Legacy Telemetry scalar networking.nss_initialization.
    pub static nss_initialization: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "nss_initialization".into(),
                category: "networking".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(193), meta)
    });

}
pub mod privacy_sanitize {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClearExtra {
        pub r#cache: Option<bool>,
        pub r#context: Option<String>,
        pub r#cookies_and_storage: Option<bool>,
        pub r#form_data: Option<bool>,
        pub r#history_and_downloads: Option<bool>,
        pub r#site_settings: Option<bool>,
    }

    impl ExtraKeys for ClearExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["cache", "context", "cookies_and_storage", "form_data", "history_and_downloads", "site_settings"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#cache.and_then(|val| map.insert("cache".into(), val.to_string()));
          self.r#context.and_then(|val| map.insert("context".into(), val.to_string()));
          self.r#cookies_and_storage.and_then(|val| map.insert("cookies_and_storage".into(), val.to_string()));
          self.r#form_data.and_then(|val| map.insert("form_data".into(), val.to_string()));
          self.r#history_and_downloads.and_then(|val| map.insert("history_and_downloads".into(), val.to_string()));
          self.r#site_settings.and_then(|val| map.insert("site_settings".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from privacy.sanitize.clear
    ///
    /// Dispatched when the dialog is accepted (to clear)
    pub static clear: Lazy<EventMetric<ClearExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "clear".into(),
                category: "privacy.sanitize".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(194), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClearingTimeSpanSelectedExtra {
        pub r#time_span: Option<String>,
    }

    impl ExtraKeys for ClearingTimeSpanSelectedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["time_span"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#time_span.and_then(|val| map.insert("time_span".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from privacy.sanitize.clearing_time_span_selected
    ///
    /// The time span range selected to sanitize
    pub static clearing_time_span_selected: Lazy<EventMetric<ClearingTimeSpanSelectedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "clearing_time_span_selected".into(),
                category: "privacy.sanitize".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(195), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct DialogOpenExtra {
        pub r#context: Option<String>,
    }

    impl ExtraKeys for DialogOpenExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["context"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#context.and_then(|val| map.insert("context".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from privacy.sanitize.dialog_open
    ///
    /// Dispatched when one of the sanitize dialogs opens
    pub static dialog_open: Lazy<EventMetric<DialogOpenExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dialog_open".into(),
                category: "privacy.sanitize".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(196), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from privacy.sanitize.load_time
    ///
    /// How much time was spent to open the dialog, including loading data sizes
    pub static load_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "load_time".into(),
                category: "privacy.sanitize".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(197), meta, TimeUnit::Millisecond)
    });

}
pub mod security_ui_protectionspopup {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_cookieb_toggle_off
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cookieb_toggle_off.
    pub static click_cookieb_toggle_off: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_cookieb_toggle_off".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(198), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_cookieb_toggle_on
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cookieb_toggle_on.
    pub static click_cookieb_toggle_on: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_cookieb_toggle_on".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(199), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_cookies
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cookies.
    pub static click_cookies: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_cookies".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(200), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_cryptominers
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cryptominers.
    pub static click_cryptominers: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_cryptominers".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(201), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_etp_toggle_off
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#etp_toggle_off.
    pub static click_etp_toggle_off: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_etp_toggle_off".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(202), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_etp_toggle_on
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#etp_toggle_on.
    pub static click_etp_toggle_on: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_etp_toggle_on".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(203), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_fingerprinters
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#fingerprinters.
    pub static click_fingerprinters: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_fingerprinters".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(204), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_full_report
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#full_report.
    pub static click_full_report: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_full_report".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(205), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_milestone_message
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#milestone_message.
    pub static click_milestone_message: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_milestone_message".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(206), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickProtectionspopupCfrExtra {
        pub r#message: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickProtectionspopupCfrExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["message", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#message.and_then(|val| map.insert("message".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_protectionspopup_cfr
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#protectionspopup_cfr.
    pub static click_protectionspopup_cfr: Lazy<EventMetric<ClickProtectionspopupCfrExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_protectionspopup_cfr".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(207), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_settings
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#settings.
    pub static click_settings: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_settings".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(208), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickSmartblockembedsToggleExtra {
        pub r#isBlock: Option<bool>,
        pub r#openingReason: Option<String>,
    }

    impl ExtraKeys for ClickSmartblockembedsToggleExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["isBlock", "openingReason"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#isBlock.and_then(|val| map.insert("isBlock".into(), val.to_string()));
          self.r#openingReason.and_then(|val| map.insert("openingReason".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_smartblockembeds_toggle
    ///
    /// Triggered when SmartBlock embed toggles are clicked by the user
    pub static click_smartblockembeds_toggle: Lazy<EventMetric<ClickSmartblockembedsToggleExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_smartblockembeds_toggle".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(209), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_social
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#social.
    pub static click_social: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_social".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(210), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickSubviewSettingsExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickSubviewSettingsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_subview_settings
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#subview_settings.
    pub static click_subview_settings: Lazy<EventMetric<ClickSubviewSettingsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_subview_settings".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(211), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.click_trackers
    ///
    /// User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#trackers.
    pub static click_trackers: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_trackers".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(212), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CloseProtectionsPopupExtra {
        pub r#openingReason: Option<String>,
        pub r#smartblockToggleClicked: Option<bool>,
    }

    impl ExtraKeys for CloseProtectionsPopupExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["openingReason", "smartblockToggleClicked"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#openingReason.and_then(|val| map.insert("openingReason".into(), val.to_string()));
          self.r#smartblockToggleClicked.and_then(|val| map.insert("smartblockToggleClicked".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.close_protections_popup
    ///
    /// Triggered when the protections panel is closed. Records how the panel was opened and if the SmartBlock section had any interactions
    pub static close_protections_popup: Lazy<EventMetric<CloseProtectionsPopupExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "close_protections_popup".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(213), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OpenProtectionsPopupExtra {
        pub r#openingReason: Option<String>,
        pub r#smartblockEmbedTogglesShown: Option<bool>,
    }

    impl ExtraKeys for OpenProtectionsPopupExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["openingReason", "smartblockEmbedTogglesShown"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#openingReason.and_then(|val| map.insert("openingReason".into(), val.to_string()));
          self.r#smartblockEmbedTogglesShown.and_then(|val| map.insert("smartblockEmbedTogglesShown".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.open_protections_popup
    ///
    /// How many times the protections panel was opened.
    pub static open_protections_popup: Lazy<EventMetric<OpenProtectionsPopupExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "open_protections_popup".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(214), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OpenProtectionspopupCfrExtra {
        pub r#message: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for OpenProtectionspopupCfrExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["message", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#message.and_then(|val| map.insert("message".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.open_protectionspopup_cfr
    ///
    /// How many times the protections panel was opened.
    pub static open_protectionspopup_cfr: Lazy<EventMetric<OpenProtectionspopupCfrExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "open_protectionspopup_cfr".into(),
                category: "security.ui.protectionspopup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(215), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protectionspopup.smartblockembeds_shown
    ///
    /// How many times the SmartBlock placeholders are shown on the page
    pub static smartblockembeds_shown: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            216,
            "security.ui.protectionspopup",
            "smartblockembeds_shown",
            "metrics"
        )
    });

}
pub mod messaging_system {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.addon_version
    ///
    /// Used to hold the system addon's version, now is almost certainly an echo of the app's build id.
    pub static addon_version: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "addon_version".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(217), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.browser_session_id
    ///
    /// The Legacy Telemetry browser "session id". Identifies a specific period from application start to shutdown. See [the "main" ping docs](https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/main-ping.html) for details.
    pub static browser_session_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "browser_session_id".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(218), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.bucket_id
    ///
    /// A name shared between multiple messages that may individually be too targetted. e.g. a message that gets shown on specific websites or a message asking about personal information.
    pub static bucket_id: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "bucket_id".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(219), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.client_id
    ///
    /// The client_id according to Telemetry.
    /// Might not always have a value due to policy around specific types of
    /// ping being sent. Value may be the canary client id
    /// `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
    /// in pings near when the data upload pref is disabled (if Telemetry gets
    /// to go first), or between when a client_id has been removed and when it
    /// has been regenerated.
    /// Present only in some circumstances (see
    /// [bug 1484035]https://bugzilla.mozilla.org/show_bug.cgi?id=1484035)).
    pub static client_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "client_id".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(220), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event
    ///
    /// The type of event. Any user defined string (e.g. “IMPRESSION”, “CLICK_BUTTON”, "INDEXEDDB_OPEN_FAILED", “SESSION_END”)
    pub static event: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(221), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_context
    ///
    /// The stringified JSON of `event_context`.
    pub static event_context: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_context".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(222), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_context_parse_error
    ///
    /// How often we failed to parse event_context as JSON.
    pub static event_context_parse_error: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            223,
            "messaging_system",
            "event_context_parse_error",
            "messaging-system"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_page
    ///
    /// The event_context's `page`. Almost always "about:welcome".
    pub static event_page: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_page".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(224), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_reason
    ///
    /// The event_context's `reason`. Likely something like
    /// "welcome-window-closed" or "app-shut-down",.
    pub static event_reason: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_reason".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(225), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_screen_family
    ///
    /// A string identifier of the message family derived from the message id
    /// (e.g. MR_WELCOME_DEFAULT).
    pub static event_screen_family: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_screen_family".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(226), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_screen_id
    ///
    /// A string identifier of the message screen id
    /// (e.g. AW_MOBILE_DOWNLOAD).
    pub static event_screen_id: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_screen_id".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(227), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_screen_index
    ///
    /// A number identifier of the screen index in a sequence of screens
    /// (e.g. 0 for first message).
    pub static event_screen_index: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_screen_index".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(228), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_screen_initials
    ///
    /// A string identifier of the message screen initials
    /// (e.g. 'EMAG' for EASY_SETUP, MOBILE_DOWNLOADS, AMO, GRATITUDE).
    pub static event_screen_initials: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_screen_initials".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(229), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.event_source
    ///
    /// The event_context's `source`. Likely something like "primary_button".
    pub static event_source: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_source".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(230), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.glean_ping_for_ping_failures
    ///
    /// How often something went awry within
    /// `AboutWelcome.submitGleanPingForPing`, preventing ping submission.
    pub static glean_ping_for_ping_failures: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            231,
            "messaging_system",
            "glean_ping_for_ping_failures",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.impression_id
    ///
    /// The unique impression identifier for a specific client.
    pub static impression_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression_id".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(232), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.invalid_nested_data
    ///
    /// We received a ping with non-scalar data on a field of this name.
    /// If this is existing pre-PingCentre-replacement data, you may need to
    /// augment the logic in
    /// `AboutWelcome.submitGleanPingForPing` like the other `handledKeys`.
    /// If this is for new, post-PingCentre-replacement data, you should
    /// probably prefer a flat structure.
    /// If you're unsure, please ask in
    /// [the #glean channel](https://chat.mozilla.org/#/room/#glean:mozilla.org).
    pub static invalid_nested_data: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "invalid_nested_data".into(),
                    category: "messaging_system".into(),
                    send_in_pings: vec!["messaging-system".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(233), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.locale
    ///
    /// The locale as supplied to the messaging system by `Services.locale.appLocaleAsBCP47`.
    pub static locale: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "locale".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(234), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.message_id
    ///
    /// A string identifier of the message in Activity Stream Router.
    pub static message_id: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "message_id".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(235), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.message_request_time
    ///
    /// Firefox: Time in ms spent selecting and matching messages to user profile.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram MS_MESSAGE_REQUEST_TIME_MS.
    pub static message_request_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "message_request_time".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(236), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.ping_type
    ///
    /// Type of event the ping is capturing. e.g. "cfr", "onboarding"
    pub static ping_type: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "ping_type".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(237), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.source
    ///
    /// The source of the interaction described by the other metrics. e.g. "frecent_links", "newtab", "CFR"
    pub static source: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "source".into(),
                category: "messaging_system".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(238), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.unknown_key_count
    ///
    /// The sum of all unknown keys counted.
    /// Useful for testing.
    /// Can be removed after bug 1600008 is resolved.
    pub static unknown_key_count: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            239,
            "messaging_system",
            "unknown_key_count",
            "messaging-system"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.unknown_keys
    ///
    /// Ping keys supplied to the messaging system for which
    /// we did not have a corresponding metric mapped to how often they attempted
    /// to be recorded.
    /// You may have forgotten to define an appropriate metric in
    /// `browser/components/newtab/metrics.yaml`.
    pub static unknown_keys: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "unknown_keys".into(),
                    category: "messaging_system".into(),
                    send_in_pings: vec!["messaging-system".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(240), meta, None)
    });

}
pub mod messaging_system_attribution {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.campaign
    ///
    /// Attribution's campaign, possibly derived from the utm parameter of the
    /// same name.
    pub static campaign: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "campaign".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(241), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.content
    ///
    /// Attribution's content, possibly derived from the utm parameter of the
    /// same name.
    pub static content: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "content".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(242), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.dlsource
    ///
    /// Mozilla-specific download "source" name. Could be something like
    /// "mozillaci" to identify that the installer came from
    /// `{archive|ftp}.mozilla.org`.
    pub static dlsource: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dlsource".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(243), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.dltoken
    ///
    /// String representation of the dltoken identifying the particular
    /// installer used to install this Firefox.
    /// Likely a UUID, if present.
    pub static dltoken: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dltoken".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(244), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.experiment
    ///
    /// Attribution's experiment key.
    pub static experiment: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "experiment".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(245), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.medium
    ///
    /// Attribution's medium, possibly derived from the utm parameter of the same
    /// name.
    pub static medium: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "medium".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(246), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.msstoresignedin
    ///
    /// Either the string "true" or the string "false" to indicate whether the
    /// attributed install came from the Microsoft store and, if so, whether the
    /// user was signed in at the time.
    pub static msstoresignedin: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "msstoresignedin".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(247), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.source
    ///
    /// Attribution's source, possibly derived from the utm parameter of the same
    /// name.
    pub static source: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "source".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(248), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.ua
    ///
    /// Attribution's ua key.
    pub static ua: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "ua".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(249), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.unknown_keys
    ///
    /// Attribution keys supplied to the messaging system for which
    /// we did not have a corresponding metric, and the count of how
    /// often that happened.
    /// Either add this key to a list of known attribution keys in
    /// `AboutWelcomeTelemetry` to suppress or define an appropriate metric in
    /// `browser/components/newtab/metrics.yaml` to collect.
    pub static unknown_keys: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "unknown_keys".into(),
                    category: "messaging_system.attribution".into(),
                    send_in_pings: vec!["messaging-system".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(250), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from messaging_system.attribution.variation
    ///
    /// Attribution's variation key.
    pub static variation: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "variation".into(),
                category: "messaging_system.attribution".into(),
                send_in_pings: vec!["messaging-system".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(251), meta)
    });

}
pub mod browser_backup {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.browser_extension_data_size
    ///
    /// The total size of the current profiles storage.local legacy JSON backend in the browser-extension-data directory, rounded to the nearest 10 kilobytes.
    pub static browser_extension_data_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "browser_extension_data_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(252), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.change_location
    ///
    /// Dispatched when the backup destination location is changed.
    pub static change_location: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "change_location".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(253), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.compressed_archive_size
    ///
    /// The total compressed size of a single-file profile data backup archive. To reduce fingerprintability, we round to the nearest 1 mebibyte.
    pub static compressed_archive_size: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "compressed_archive_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(254), meta, MemoryUnit::Megabyte)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.cookies_size
    ///
    /// The total file size of the cookies.sqlite db located in the current profile directory, in kilobytes.
    pub static cookies_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cookies_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(255), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.created
    ///
    /// Dispatched when a backup is successfully created.
    pub static created: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "created".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(256), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.credentials_data_size
    ///
    /// The total size of logins, payment method, and form autofill related files in the current profile directory, in kilobytes.
    pub static credentials_data_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "credentials_data_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(257), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.enabled
    ///
    /// True if the BackupService is enabled by default.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(258), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ErrorExtra {
        pub r#backup_step: Option<String>,
        pub r#error_code: Option<String>,
    }

    impl ExtraKeys for ErrorExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["backup_step", "error_code"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#backup_step.and_then(|val| map.insert("backup_step".into(), val.to_string()));
          self.r#error_code.and_then(|val| map.insert("error_code".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.error
    ///
    /// Dispatched when a backup fails to be created. We encode the error code as well as the stage the backup failed in in the extra data.
    pub static error: Lazy<EventMetric<ErrorExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "error".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(259), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.extension_store_permissions_data_size
    ///
    /// The file size of the current profiles extension-store-permissions/data.safe.bin file, rounded to the nearest 10 kilobytes.
    pub static extension_store_permissions_data_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "extension_store_permissions_data_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(260), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.extensions_json_size
    ///
    /// The total file size of the current profiles extensions metadata files, rounded to the nearest 10 kilobytes. Files included are:
    ///   - extensions.json
    ///   - extension-settings.json
    ///   - extension-preferences.json
    ///   - addonStartup.json.lz4
    pub static extensions_json_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "extensions_json_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(261), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.extensions_storage_size
    ///
    /// The total size of all extensions storage directories, rounded to the nearest 10 kilobytes.
    pub static extensions_storage_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "extensions_storage_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(262), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.extensions_xpi_directory_size
    ///
    /// The total size of the current profiles extensions directory, rounded to the nearest 10 kilobytes.
    pub static extensions_xpi_directory_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "extensions_xpi_directory_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(263), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.favicons_size
    ///
    /// The total file size of the favicons.sqlite db located in the current profile directory, in kilobytes.
    pub static favicons_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "favicons_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(264), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.favicons_time
    ///
    /// Total time, in milliseconds, required to back up a profile's favicons database.
    pub static favicons_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "favicons_time".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(265), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.form_history_size
    ///
    /// The file size of the formhistory.sqlite db located in the current profile directory, in kilobytes.
    pub static form_history_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "form_history_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(266), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.location_on_device
    ///
    /// 1 = the default location, 2 = a non-default location
    pub static location_on_device: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "location_on_device".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(267), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.misc_data_size
    ///
    /// The total size of files for telemetry, site storage, media device origin mapping, chrome privileged IndexedDB databases, and Mozilla Accounts in the current profile directory, rounded to the nearest tenth kilobyte.
    pub static misc_data_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "misc_data_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(268), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.password_added
    ///
    /// Dispatched when the backup encryption is enabled.
    pub static password_added: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "password_added".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(269), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.password_changed
    ///
    /// Dispatched when the backup encryption password is changed.
    pub static password_changed: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "password_changed".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(270), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.password_removed
    ///
    /// Dispatched when the backup encryption is removed.
    pub static password_removed: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "password_removed".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(271), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.places_size
    ///
    /// The total file size of the places.sqlite db located in the current profile directory, in kilobytes.
    pub static places_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "places_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(272), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.places_time
    ///
    /// Total time, in milliseconds, required to back up a profile's places database.
    pub static places_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "places_time".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(273), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.preferences_size
    ///
    /// The total size of files relating to user preferences and permissions in the current profile directory, in kilobytes.
    pub static preferences_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "preferences_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(274), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.prof_d_disk_space
    ///
    /// The total disk space available on the storage device that the profile directory is stored on. To reduce fingerprintability, we round to the nearest 10 megabytes and return the result in kilobytes.
    pub static prof_d_disk_space: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "prof_d_disk_space".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(275), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.pswd_encrypted
    ///
    /// True if the BackupService is configured to encrypt backups.
    pub static pswd_encrypted: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "pswd_encrypted".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(276), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.scheduler_enabled
    ///
    /// True if the BackupService is configured to automatically create backups in the background.
    pub static scheduler_enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "scheduler_enabled".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(277), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.security_data_size
    ///
    /// The total size of files needed for NSS initialization parameters and security certificate settings in the current profile directory, in kilobytes.
    pub static security_data_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "security_data_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(278), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.session_store_backups_directory_size
    ///
    /// The total size of the session store backups directory, in kilobytes.
    pub static session_store_backups_directory_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "session_store_backups_directory_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(279), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.session_store_size
    ///
    /// The size of uncompressed session store json, in kilobytes.
    pub static session_store_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "session_store_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(280), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.storage_sync_size
    ///
    /// The file size of the current profiles storage-sync-v2.sqlite db, rounded to the nearest 10 kilobytes.
    pub static storage_sync_size: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "storage_sync_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(281), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.toggle_off
    ///
    /// Dispatched when scheduled backups are disabled.
    pub static toggle_off: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "toggle_off".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(282), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.toggle_on
    ///
    /// Dispatched when scheduled backups are enabled.
    pub static toggle_on: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "toggle_on".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(283), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.total_backup_size
    ///
    /// The total uncompressed size of all profile data included in a completed backup. To reduce fingerprintability, we round to the nearest 1 mebibyte.
    pub static total_backup_size: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "total_backup_size".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(284), meta, MemoryUnit::Megabyte)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.backup.total_backup_time
    ///
    /// Total time elapsed, in milliseconds, between the start and end of the profile backup creation process
    pub static total_backup_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "total_backup_time".into(),
                category: "browser.backup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(285), meta, TimeUnit::Millisecond)
    });

}
pub mod doh {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EvaluateV2HeuristicsExtra {
        pub r#canaries: Option<String>,
        pub r#captiveState: Option<String>,
        pub r#enterprise: Option<String>,
        pub r#evaluateReason: Option<String>,
        pub r#filtering: Option<String>,
        pub r#networkID: Option<String>,
        pub r#platform: Option<String>,
        pub r#steeredProvider: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EvaluateV2HeuristicsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["canaries", "captiveState", "enterprise", "evaluateReason", "filtering", "networkID", "platform", "steeredProvider", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#canaries.and_then(|val| map.insert("canaries".into(), val.to_string()));
          self.r#captiveState.and_then(|val| map.insert("captiveState".into(), val.to_string()));
          self.r#enterprise.and_then(|val| map.insert("enterprise".into(), val.to_string()));
          self.r#evaluateReason.and_then(|val| map.insert("evaluateReason".into(), val.to_string()));
          self.r#filtering.and_then(|val| map.insert("filtering".into(), val.to_string()));
          self.r#networkID.and_then(|val| map.insert("networkID".into(), val.to_string()));
          self.r#platform.and_then(|val| map.insert("platform".into(), val.to_string()));
          self.r#steeredProvider.and_then(|val| map.insert("steeredProvider".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.evaluate_v2_heuristics
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.evaluate_v2#heuristics.
    pub static evaluate_v2_heuristics: Lazy<EventMetric<EvaluateV2HeuristicsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "evaluate_v2_heuristics".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(286), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateDisabledExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateDisabledExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_disabled
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#disabled.
    pub static state_disabled: Lazy<EventMetric<StateDisabledExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_disabled".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(287), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateEnabledExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateEnabledExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_enabled
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#enabled.
    pub static state_enabled: Lazy<EventMetric<StateEnabledExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_enabled".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(288), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateManuallyDisabledExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateManuallyDisabledExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_manually_disabled
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#manuallyDisabled.
    pub static state_manually_disabled: Lazy<EventMetric<StateManuallyDisabledExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_manually_disabled".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(289), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StatePolicyDisabledExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StatePolicyDisabledExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_policy_disabled
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#policyDisabled.
    pub static state_policy_disabled: Lazy<EventMetric<StatePolicyDisabledExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_policy_disabled".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(290), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateRollbackExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateRollbackExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_rollback
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#rollback.
    pub static state_rollback: Lazy<EventMetric<StateRollbackExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_rollback".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(291), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateShutdownExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateShutdownExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_shutdown
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#shutdown.
    pub static state_shutdown: Lazy<EventMetric<StateShutdownExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_shutdown".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(292), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateUidisabledExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateUidisabledExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_uidisabled
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#UIDisabled.
    pub static state_uidisabled: Lazy<EventMetric<StateUidisabledExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_uidisabled".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(293), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateUiokExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateUiokExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_uiok
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#UIOk.
    pub static state_uiok: Lazy<EventMetric<StateUiokExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_uiok".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(294), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StateUninstalledExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for StateUninstalledExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from doh.state_uninstalled
    ///
    /// Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#uninstalled.
    pub static state_uninstalled: Lazy<EventMetric<StateUninstalledExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "state_uninstalled".into(),
                category: "doh".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(295), meta)
    });

}
pub mod security_doh_trr_performance {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ResolvedRecordExtra {
        pub r#captivePortal: Option<String>,
        pub r#domain: Option<String>,
        pub r#networkUnstable: Option<String>,
        pub r#retryCount: Option<String>,
        pub r#status: Option<String>,
        pub r#time: Option<String>,
        pub r#trr: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ResolvedRecordExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["captivePortal", "domain", "networkUnstable", "retryCount", "status", "time", "trr", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#captivePortal.and_then(|val| map.insert("captivePortal".into(), val.to_string()));
          self.r#domain.and_then(|val| map.insert("domain".into(), val.to_string()));
          self.r#networkUnstable.and_then(|val| map.insert("networkUnstable".into(), val.to_string()));
          self.r#retryCount.and_then(|val| map.insert("retryCount".into(), val.to_string()));
          self.r#status.and_then(|val| map.insert("status".into(), val.to_string()));
          self.r#time.and_then(|val| map.insert("time".into(), val.to_string()));
          self.r#trr.and_then(|val| map.insert("trr".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.doh.trr_performance.resolved_record
    ///
    /// How long it took to resolve a test domain using TRR. This event was generated to correspond to the Legacy Telemetry event security.doh.trrPerformance.resolved#record.
    pub static resolved_record: Lazy<EventMetric<ResolvedRecordExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "resolved_record".into(),
                category: "security.doh.trr_performance".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(296), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TrrselectDryrunresultExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for TrrselectDryrunresultExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.doh.trr_performance.trrselect_dryrunresult
    ///
    /// The URL of the DoH provider chosen by the TRR selection dry-run This event was generated to correspond to the Legacy Telemetry event security.doh.trrPerformance.trrselect#dryrunresult.
    pub static trrselect_dryrunresult: Lazy<EventMetric<TrrselectDryrunresultExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "trrselect_dryrunresult".into(),
                category: "security.doh.trr_performance".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(297), meta)
    });

}
pub mod downloads {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from downloads.panel_shown
    ///
    /// The count of how many times the downloads panel was shown per session. This metric was generated to correspond to the Legacy Telemetry scalar downloads.panel_shown.
    pub static panel_shown: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            298,
            "downloads",
            "panel_shown",
            "metrics"
        )
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AddedFileExtensionExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AddedFileExtensionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from downloads.added_file_extension
    ///
    /// Sent when downloading a new file. This event was generated to correspond to the Legacy Telemetry event downloads.added#fileExtension.
    pub static added_file_extension: Lazy<EventMetric<AddedFileExtensionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "added_file_extension".into(),
                category: "downloads".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(299), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from downloads.file_opened
    ///
    /// The count of how many times files were opened from the download panel. This metric was generated to correspond to the Legacy Telemetry scalar downloads.file_opened.
    pub static file_opened: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            300,
            "downloads",
            "file_opened",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from downloads.user_action_on_blocked_download
    ///
    /// Users action on blocked download, keyed by verdict type (0=Number of blocked downloads, 1=Confirm block, 2=Confirm unblock)
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram DOWNLOADS_USER_ACTION_ON_BLOCKED_DOWNLOAD.
    pub static user_action_on_blocked_download: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "user_action_on_blocked_download".into(),
                    category: "downloads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 0, range_max: 3, bucket_count: 4, histogram_type: HistogramType::Linear};
        LabeledMetric::new(MetricId(301), meta, None)
    });

}
pub mod glam_experiment {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.panel_shown
    ///
    /// Duplicate of: `downloads.panel_shown`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static panel_shown: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_disabled_new(
            302,
            "glam_experiment",
            "panel_shown",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.active_ticks
    ///
    /// Duplicate of:
    /// `browser.engagement.active_ticks`
    /// 
    /// Intended for the purpose of testing client side sampling of data. This
    /// metric is disabled by default and will be enabled only for the purpose
    /// of the experiment. See Bug 1947604 for more information.
    pub static active_ticks: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_disabled_new(
            303,
            "glam_experiment",
            "active_ticks",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.largest_contentful_paint
    ///
    /// Duplicate of: `perf.largest_contentful_paint`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static largest_contentful_paint: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "largest_contentful_paint".into(),
                category: "glam_experiment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: true,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(304), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.protect_time
    ///
    /// Duplicate of: `javascript_pageload.protect_time`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static protect_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "protect_time".into(),
                category: "glam_experiment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: true,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(305), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.time
    ///
    /// Duplicate of: `performance.clone.deserialize.time`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "time".into(),
                category: "glam_experiment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: true,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(306), meta, TimeUnit::Microsecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.async_sheet_load
    ///
    /// Duplicate of: `performance.pageload.async_sheet_load`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static async_sheet_load: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "async_sheet_load".into(),
                category: "glam_experiment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: true,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(307), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.http_content_html5parser_ondatafinished_to_onstop_delay
    ///
    /// Duplicate of: `networking.http_content_html5parser_ondatafinished_to_onstop_delay`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static http_content_html5parser_ondatafinished_to_onstop_delay: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "http_content_html5parser_ondatafinished_to_onstop_delay".into(),
                category: "glam_experiment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: true,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(308), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.os_socket_limit_reached
    ///
    /// Duplicate of: `networking.os_socket_limit_reached`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static os_socket_limit_reached: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_disabled_new(
            309,
            "glam_experiment",
            "os_socket_limit_reached",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.sub_complete_load_net
    ///
    /// Duplicate of: `network.sub_complete_load_net`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static sub_complete_load_net: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sub_complete_load_net".into(),
                category: "glam_experiment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: true,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(310), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.used
    ///
    /// Duplicate of: `pdfjs.used`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static used: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_disabled_new(
            311,
            "glam_experiment",
            "used",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.cpu_time_bogus_values
    ///
    /// Duplicate of: `power.cpu_time_bogus_values`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static cpu_time_bogus_values: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_disabled_new(
            312,
            "glam_experiment",
            "cpu_time_bogus_values",
            "metrics"
        )
    });

    #[allow(non_upper_case_globals)]
    /// generated from glam_experiment.total_cpu_time_ms
    ///
    /// Duplicate of: `power.total_cpu_time_ms`
    /// Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
    pub static total_cpu_time_ms: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_disabled_new(
            313,
            "glam_experiment",
            "total_cpu_time_ms",
            "metrics"
        )
    });

}
pub mod firefoxview {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[repr(u16)]
    pub enum CumulativeSearchesLabel {
        ERecentbrowsing = 0,
        EOpentabs = 1,
        ERecentlyclosed = 2,
        EHistory = 3,
        ESyncedtabs = 4,
        __Other__,
    }
    impl From<u16> for CumulativeSearchesLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ERecentbrowsing,
                1 => Self::EOpentabs,
                2 => Self::ERecentlyclosed,
                3 => Self::EHistory,
                4 => Self::ESyncedtabs,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for CumulativeSearchesLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ERecentbrowsing => "recentbrowsing",
                Self::EOpentabs => "opentabs",
                Self::ERecentlyclosed => "recentlyclosed",
                Self::EHistory => "history",
                Self::ESyncedtabs => "syncedtabs",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview.cumulative_searches
    ///
    /// Cumulative no. of searches performed before selecting a resulting tab.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram FIREFOX_VIEW_CUMULATIVE_SEARCHES.
    pub static cumulative_searches: Lazy<LabeledMetric<LabeledCustomDistributionMetric, CumulativeSearchesLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "cumulative_searches".into(),
                    category: "firefoxview".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 0, range_max: 100, bucket_count: 101, histogram_type: HistogramType::Linear};
        LabeledMetric::new(MetricId(314), meta, Some(vec![::std::borrow::Cow::from("history"), ::std::borrow::Cow::from("opentabs"), ::std::borrow::Cow::from("recentbrowsing"), ::std::borrow::Cow::from("recentlyclosed"), ::std::borrow::Cow::from("syncedtabs")]))
    });

}
pub mod firefoxview_next {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct BrowserContextMenuTabsExtra {
        pub r#menu_action: Option<String>,
        pub r#page: Option<String>,
    }

    impl ExtraKeys for BrowserContextMenuTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["menu_action", "page"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#menu_action.and_then(|val| map.insert("menu_action".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.browser_context_menu_tabs
    ///
    /// Recorded when a browser context menu selection is made in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.browser_context_menu#tabs.
    pub static browser_context_menu_tabs: Lazy<EventMetric<BrowserContextMenuTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "browser_context_menu_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(315), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CardCollapsedCardContainerExtra {
        pub r#data_type: Option<String>,
    }

    impl ExtraKeys for CardCollapsedCardContainerExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["data_type"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#data_type.and_then(|val| map.insert("data_type".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.card_collapsed_card_container
    ///
    /// Recorded when a card-container is collapsed on the 'Recent browsing' page This event was generated to correspond to the Legacy Telemetry event firefoxview_next.card_collapsed#card_container.
    pub static card_collapsed_card_container: Lazy<EventMetric<CardCollapsedCardContainerExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "card_collapsed_card_container".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(316), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CardExpandedCardContainerExtra {
        pub r#data_type: Option<String>,
    }

    impl ExtraKeys for CardExpandedCardContainerExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["data_type"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#data_type.and_then(|val| map.insert("data_type".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.card_expanded_card_container
    ///
    /// Recorded when a card-container is expanded on the 'Recent browsing' page This event was generated to correspond to the Legacy Telemetry event firefoxview_next.card_expanded#card_container.
    pub static card_expanded_card_container: Lazy<EventMetric<CardExpandedCardContainerExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "card_expanded_card_container".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(317), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ChangePageNavigationExtra {
        pub r#page: Option<String>,
        pub r#source: Option<String>,
    }

    impl ExtraKeys for ChangePageNavigationExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["page", "source"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#source.and_then(|val| map.insert("source".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.change_page_navigation
    ///
    /// Recorded when the page/view is changed in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.change_page#navigation.
    pub static change_page_navigation: Lazy<EventMetric<ChangePageNavigationExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "change_page_navigation".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(318), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.close_open_tab_tabs
    ///
    /// Recorded when a tab is closed via the close button on an open tab row. This event was generated to correspond to the Legacy Telemetry event firefoxview_next.close_open_tab#tabs.
    pub static close_open_tab_tabs: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "close_open_tab_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(319), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ContextMenuTabsExtra {
        pub r#data_type: Option<String>,
        pub r#menu_action: Option<String>,
    }

    impl ExtraKeys for ContextMenuTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["data_type", "menu_action"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#data_type.and_then(|val| map.insert("data_type".into(), val.to_string()));
          self.r#menu_action.and_then(|val| map.insert("menu_action".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.context_menu_tabs
    ///
    /// Recorded when a context menu selection is made in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.context_menu#tabs.
    pub static context_menu_tabs: Lazy<EventMetric<ContextMenuTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "context_menu_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(320), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct DismissClosedTabTabsExtra {
        pub r#delta: Option<String>,
        pub r#page: Option<String>,
        pub r#position: Option<u32>,
    }

    impl ExtraKeys for DismissClosedTabTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["delta", "page", "position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#delta.and_then(|val| map.insert("delta".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.dismiss_closed_tab_tabs
    ///
    /// Recorded when a recently closed tab is dismissed This event was generated to correspond to the Legacy Telemetry event firefoxview_next.dismiss_closed_tab#tabs.
    pub static dismiss_closed_tab_tabs: Lazy<EventMetric<DismissClosedTabTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dismiss_closed_tab_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(321), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EnteredFirefoxviewExtra {
        pub r#page: Option<String>,
    }

    impl ExtraKeys for EnteredFirefoxviewExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["page"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.entered_firefoxview
    ///
    /// Recorded when the Firefox View tab is selected This event was generated to correspond to the Legacy Telemetry event firefoxview_next.entered#firefoxview.
    pub static entered_firefoxview: Lazy<EventMetric<EnteredFirefoxviewExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "entered_firefoxview".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(322), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.fxa_continue_sync
    ///
    /// Recorded when button to sign in or sign up is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.fxa_continue#sync.
    pub static fxa_continue_sync: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fxa_continue_sync".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(323), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FxaMobileSyncExtra {
        pub r#has_devices: Option<bool>,
    }

    impl ExtraKeys for FxaMobileSyncExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["has_devices"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#has_devices.and_then(|val| map.insert("has_devices".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.fxa_mobile_sync
    ///
    /// Recorded when the 'Try Firefox for mobile' button is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.fxa_mobile#sync.
    pub static fxa_mobile_sync: Lazy<EventMetric<FxaMobileSyncExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fxa_mobile_sync".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(324), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.history_visits
    ///
    /// Recorded when a history tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.history#visits.
    pub static history_visits: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "history_visits".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(325), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OpenTabTabsExtra {
        pub r#page: Option<String>,
        pub r#window: Option<String>,
    }

    impl ExtraKeys for OpenTabTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["page", "window"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#window.and_then(|val| map.insert("window".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.open_tab_tabs
    ///
    /// Recorded when an open tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.open_tab#tabs.
    pub static open_tab_tabs: Lazy<EventMetric<OpenTabTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "open_tab_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(326), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct RecentlyClosedTabsExtra {
        pub r#delta: Option<String>,
        pub r#page: Option<String>,
        pub r#position: Option<u32>,
    }

    impl ExtraKeys for RecentlyClosedTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["delta", "page", "position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#delta.and_then(|val| map.insert("delta".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.recently_closed_tabs
    ///
    /// Recorded when a recently closed tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.recently_closed#tabs.
    pub static recently_closed_tabs: Lazy<EventMetric<RecentlyClosedTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "recently_closed_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(327), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SearchInitiatedSearchExtra {
        pub r#page: Option<String>,
    }

    impl ExtraKeys for SearchInitiatedSearchExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["page"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.search_initiated_search
    ///
    /// Recorded when search is initiated and from what page. This event was generated to correspond to the Legacy Telemetry event firefoxview_next.search_initiated#search.
    pub static search_initiated_search: Lazy<EventMetric<SearchInitiatedSearchExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "search_initiated_search".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(328), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SearchShowAllShowallbuttonExtra {
        pub r#section: Option<String>,
    }

    impl ExtraKeys for SearchShowAllShowallbuttonExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["section"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.search_show_all_showallbutton
    ///
    /// Recorded when the show all button is clicked to show more search results. This event was generated to correspond to the Legacy Telemetry event firefoxview_next.search_show_all#showallbutton.
    pub static search_show_all_showallbutton: Lazy<EventMetric<SearchShowAllShowallbuttonExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "search_show_all_showallbutton".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(329), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.show_all_history_tabs
    ///
    /// Recorded when the 'Show all history' button is clicked on the History page in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.show_all_history#tabs.
    pub static show_all_history_tabs: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_all_history_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(330), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SortHistoryTabsExtra {
        pub r#search_start: Option<String>,
        pub r#sort_type: Option<String>,
    }

    impl ExtraKeys for SortHistoryTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["search_start", "sort_type"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#search_start.and_then(|val| map.insert("search_start".into(), val.to_string()));
          self.r#sort_type.and_then(|val| map.insert("sort_type".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.sort_history_tabs
    ///
    /// Recorded when the sort option is changed for History in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.sort_history#tabs.
    pub static sort_history_tabs: Lazy<EventMetric<SortHistoryTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sort_history_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(331), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SyncedTabsTabsExtra {
        pub r#page: Option<String>,
    }

    impl ExtraKeys for SyncedTabsTabsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["page"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.synced_tabs_tabs
    ///
    /// Recorded when a synced tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.synced_tabs#tabs.
    pub static synced_tabs_tabs: Lazy<EventMetric<SyncedTabsTabsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "synced_tabs_tabs".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(332), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from firefoxview_next.tab_selected_toolbarbutton
    ///
    /// Recorded when the Firefox View tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.tab_selected#toolbarbutton.
    pub static tab_selected_toolbarbutton: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "tab_selected_toolbarbutton".into(),
                category: "firefoxview_next".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(333), meta)
    });

}
pub mod genai_chatbot {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ContextmenuPromptClickExtra {
        pub r#prompt: Option<String>,
        pub r#provider: Option<String>,
        pub r#selection: Option<u32>,
    }

    impl ExtraKeys for ContextmenuPromptClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["prompt", "provider", "selection"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#prompt.and_then(|val| map.insert("prompt".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#selection.and_then(|val| map.insert("selection".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.contextmenu_prompt_click
    ///
    /// Chatbot prompt was clicked from the context menu.
    pub static contextmenu_prompt_click: Lazy<EventMetric<ContextmenuPromptClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "contextmenu_prompt_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(334), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ContextmenuRemoveExtra {
        pub r#provider: Option<String>,
    }

    impl ExtraKeys for ContextmenuRemoveExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.contextmenu_remove
    ///
    /// Chatbot provider was removed from the context menu.
    pub static contextmenu_remove: Lazy<EventMetric<ContextmenuRemoveExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "contextmenu_remove".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(335), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.enabled
    ///
    /// Indicates if the chatbot feature is enabled.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(336), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ExperimentCheckboxClickExtra {
        pub r#enabled: Option<bool>,
    }

    impl ExtraKeys for ExperimentCheckboxClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["enabled"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#enabled.and_then(|val| map.insert("enabled".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.experiment_checkbox_click
    ///
    /// Chatbot experiment checkbox was clicked to enable/disable.
    pub static experiment_checkbox_click: Lazy<EventMetric<ExperimentCheckboxClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "experiment_checkbox_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(337), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct KeyboardShortcutExtra {
        pub r#enabled: Option<bool>,
        pub r#sidebar: Option<String>,
    }

    impl ExtraKeys for KeyboardShortcutExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["enabled", "sidebar"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#enabled.and_then(|val| map.insert("enabled".into(), val.to_string()));
          self.r#sidebar.and_then(|val| map.insert("sidebar".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.keyboard_shortcut
    ///
    /// Chatbot sidebar toggled with keyboard shortcut.
    pub static keyboard_shortcut: Lazy<EventMetric<KeyboardShortcutExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "keyboard_shortcut".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(338), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingCloseExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingCloseExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_close
    ///
    /// Chatbot onboarding closed from provider choice.
    pub static onboarding_close: Lazy<EventMetric<OnboardingCloseExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_close".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(339), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingContinueExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingContinueExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_continue
    ///
    /// Chatbot onboarding continued from provider choice.
    pub static onboarding_continue: Lazy<EventMetric<OnboardingContinueExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_continue".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(340), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingFinishExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingFinishExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_finish
    ///
    /// Chatbot onboarding finished with start chatting button.
    pub static onboarding_finish: Lazy<EventMetric<OnboardingFinishExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_finish".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(341), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingLearnMoreExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingLearnMoreExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_learn_more
    ///
    /// Chatbot onboarding opened feature learn more link.
    pub static onboarding_learn_more: Lazy<EventMetric<OnboardingLearnMoreExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_learn_more".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(342), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingProviderChoiceDisplayedExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingProviderChoiceDisplayedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_provider_choice_displayed
    ///
    /// Chatbot onboarding impression for provider choice screen.
    pub static onboarding_provider_choice_displayed: Lazy<EventMetric<OnboardingProviderChoiceDisplayedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_provider_choice_displayed".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(343), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingProviderLearnExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingProviderLearnExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_provider_learn
    ///
    /// Chatbot onboarding opened provider learn more link.
    pub static onboarding_provider_learn: Lazy<EventMetric<OnboardingProviderLearnExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_provider_learn".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(344), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingProviderSelectionExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingProviderSelectionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_provider_selection
    ///
    /// Chatbot onboarding selected a provider.
    pub static onboarding_provider_selection: Lazy<EventMetric<OnboardingProviderSelectionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_provider_selection".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(345), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingProviderTermsExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
        pub r#text: Option<String>,
    }

    impl ExtraKeys for OnboardingProviderTermsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step", "text"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          self.r#text.and_then(|val| map.insert("text".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_provider_terms
    ///
    /// Chatbot onboarding opened provider terms link.
    pub static onboarding_provider_terms: Lazy<EventMetric<OnboardingProviderTermsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_provider_terms".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(346), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OnboardingTextHighlightDisplayedExtra {
        pub r#provider: Option<String>,
        pub r#step: Option<u32>,
    }

    impl ExtraKeys for OnboardingTextHighlightDisplayedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "step"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#step.and_then(|val| map.insert("step".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.onboarding_text_highlight_displayed
    ///
    /// Chatbot onboarding impression for text highlight screen.
    pub static onboarding_text_highlight_displayed: Lazy<EventMetric<OnboardingTextHighlightDisplayedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "onboarding_text_highlight_displayed".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(347), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.provider
    ///
    /// Indicates id of activated chatbot provider or "custom" or "none"
    pub static provider: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "provider".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(348), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ProviderChangeExtra {
        pub r#current: Option<String>,
        pub r#previous: Option<String>,
        pub r#surface: Option<String>,
    }

    impl ExtraKeys for ProviderChangeExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["current", "previous", "surface"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#current.and_then(|val| map.insert("current".into(), val.to_string()));
          self.r#previous.and_then(|val| map.insert("previous".into(), val.to_string()));
          self.r#surface.and_then(|val| map.insert("surface".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.provider_change
    ///
    /// Chatbot provider UI changed providers.
    pub static provider_change: Lazy<EventMetric<ProviderChangeExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "provider_change".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(349), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts
    ///
    /// Indicates if the chatbot feature would show shortcuts on selection.
    pub static shortcuts: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(350), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShortcutsCheckboxClickExtra {
        pub r#enabled: Option<bool>,
    }

    impl ExtraKeys for ShortcutsCheckboxClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["enabled"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#enabled.and_then(|val| map.insert("enabled".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts_checkbox_click
    ///
    /// Chatbot shortcuts checkbox was clicked to enable/disable.
    pub static shortcuts_checkbox_click: Lazy<EventMetric<ShortcutsCheckboxClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts_checkbox_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(351), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts_custom
    ///
    /// Indicates if the chatbot feature would show shortcuts custom input.
    pub static shortcuts_custom: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts_custom".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(352), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShortcutsDisplayedExtra {
        pub r#delay: Option<u32>,
        pub r#inputType: Option<String>,
        pub r#selection: Option<u32>,
    }

    impl ExtraKeys for ShortcutsDisplayedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["delay", "inputType", "selection"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#delay.and_then(|val| map.insert("delay".into(), val.to_string()));
          self.r#inputType.and_then(|val| map.insert("inputType".into(), val.to_string()));
          self.r#selection.and_then(|val| map.insert("selection".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts_displayed
    ///
    /// Shortcuts displayed on text selection.
    pub static shortcuts_displayed: Lazy<EventMetric<ShortcutsDisplayedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts_displayed".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(353), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShortcutsExpandedExtra {
        pub r#provider: Option<String>,
        pub r#selection: Option<u32>,
        pub r#warning: Option<bool>,
    }

    impl ExtraKeys for ShortcutsExpandedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider", "selection", "warning"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#selection.and_then(|val| map.insert("selection".into(), val.to_string()));
          self.r#warning.and_then(|val| map.insert("warning".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts_expanded
    ///
    /// Shortcuts expanded to show prompts.
    pub static shortcuts_expanded: Lazy<EventMetric<ShortcutsExpandedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts_expanded".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(354), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShortcutsHideClickExtra {
        pub r#selection: Option<u32>,
    }

    impl ExtraKeys for ShortcutsHideClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["selection"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#selection.and_then(|val| map.insert("selection".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts_hide_click
    ///
    /// Chatbot hide shortcuts was clicked from the shortcuts.
    pub static shortcuts_hide_click: Lazy<EventMetric<ShortcutsHideClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts_hide_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(355), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShortcutsPromptClickExtra {
        pub r#prompt: Option<String>,
        pub r#provider: Option<String>,
        pub r#selection: Option<u32>,
    }

    impl ExtraKeys for ShortcutsPromptClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["prompt", "provider", "selection"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#prompt.and_then(|val| map.insert("prompt".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#selection.and_then(|val| map.insert("selection".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.shortcuts_prompt_click
    ///
    /// Chatbot prompt was clicked from the shortcuts.
    pub static shortcuts_prompt_click: Lazy<EventMetric<ShortcutsPromptClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shortcuts_prompt_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(356), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.sidebar
    ///
    /// Indicates if the chatbot feature would open in sidebar.
    pub static sidebar: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sidebar".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(357), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SidebarCloseClickExtra {
        pub r#provider: Option<String>,
    }

    impl ExtraKeys for SidebarCloseClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.sidebar_close_click
    ///
    /// Chatbot close X clicked.
    pub static sidebar_close_click: Lazy<EventMetric<SidebarCloseClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sidebar_close_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(358), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SidebarMoreMenuClickExtra {
        pub r#action: Option<String>,
        pub r#provider: Option<String>,
    }

    impl ExtraKeys for SidebarMoreMenuClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action", "provider"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action.and_then(|val| map.insert("action".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.sidebar_more_menu_click
    ///
    /// Chatbot more menu clicked an action.
    pub static sidebar_more_menu_click: Lazy<EventMetric<SidebarMoreMenuClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sidebar_more_menu_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(359), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SidebarMoreMenuDisplayExtra {
        pub r#provider: Option<String>,
    }

    impl ExtraKeys for SidebarMoreMenuDisplayExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["provider"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.sidebar_more_menu_display
    ///
    /// Chatbot more menu opened.
    pub static sidebar_more_menu_display: Lazy<EventMetric<SidebarMoreMenuDisplayExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sidebar_more_menu_display".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(360), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SidebarProviderMenuClickExtra {
        pub r#action: Option<String>,
        pub r#provider: Option<String>,
    }

    impl ExtraKeys for SidebarProviderMenuClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action", "provider"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action.and_then(|val| map.insert("action".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.sidebar_provider_menu_click
    ///
    /// Chatbot provider menu clicked an action.
    pub static sidebar_provider_menu_click: Lazy<EventMetric<SidebarProviderMenuClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sidebar_provider_menu_click".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(361), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SidebarToggleExtra {
        pub r#opened: Option<bool>,
        pub r#provider: Option<String>,
        pub r#reason: Option<String>,
        pub r#version: Option<String>,
    }

    impl ExtraKeys for SidebarToggleExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["opened", "provider", "reason", "version"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#opened.and_then(|val| map.insert("opened".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#reason.and_then(|val| map.insert("reason".into(), val.to_string()));
          self.r#version.and_then(|val| map.insert("version".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.chatbot.sidebar_toggle
    ///
    /// Chatbot sidebar panel was toggled open/close.
    pub static sidebar_toggle: Lazy<EventMetric<SidebarToggleExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sidebar_toggle".into(),
                category: "genai.chatbot".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(362), meta)
    });

}
pub mod genai_linkpreview {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CardCloseExtra {
        pub r#duration: Option<u32>,
    }

    impl ExtraKeys for CardCloseExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["duration"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#duration.and_then(|val| map.insert("duration".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.card_close
    ///
    /// Recorded when the user closes the card
    pub static card_close: Lazy<EventMetric<CardCloseExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "card_close".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(363), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CardLinkExtra {
        pub r#source: Option<String>,
    }

    impl ExtraKeys for CardLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["source"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#source.and_then(|val| map.insert("source".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.card_link
    ///
    /// Recorded when the user clicks on a link from the card
    pub static card_link: Lazy<EventMetric<CardLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "card_link".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(364), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.enabled
    ///
    /// Records if the user has link previews enabled
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(365), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FetchExtra {
        pub r#description: Option<bool>,
        pub r#image: Option<bool>,
        pub r#length: Option<u32>,
        pub r#outcome: Option<String>,
        pub r#sitename: Option<bool>,
        pub r#skipped: Option<bool>,
        pub r#time: Option<u32>,
        pub r#title: Option<bool>,
    }

    impl ExtraKeys for FetchExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["description", "image", "length", "outcome", "sitename", "skipped", "time", "title"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#description.and_then(|val| map.insert("description".into(), val.to_string()));
          self.r#image.and_then(|val| map.insert("image".into(), val.to_string()));
          self.r#length.and_then(|val| map.insert("length".into(), val.to_string()));
          self.r#outcome.and_then(|val| map.insert("outcome".into(), val.to_string()));
          self.r#sitename.and_then(|val| map.insert("sitename".into(), val.to_string()));
          self.r#skipped.and_then(|val| map.insert("skipped".into(), val.to_string()));
          self.r#time.and_then(|val| map.insert("time".into(), val.to_string()));
          self.r#title.and_then(|val| map.insert("title".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.fetch
    ///
    /// Recorded when the browser fetches the page to be previewed
    pub static fetch: Lazy<EventMetric<FetchExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fetch".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(366), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct GenerateExtra {
        pub r#delay: Option<u32>,
        pub r#download: Option<u32>,
        pub r#latency: Option<u32>,
        pub r#outcome: Option<String>,
        pub r#sentences: Option<u32>,
        pub r#time: Option<u32>,
    }

    impl ExtraKeys for GenerateExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["delay", "download", "latency", "outcome", "sentences", "time"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#delay.and_then(|val| map.insert("delay".into(), val.to_string()));
          self.r#download.and_then(|val| map.insert("download".into(), val.to_string()));
          self.r#latency.and_then(|val| map.insert("latency".into(), val.to_string()));
          self.r#outcome.and_then(|val| map.insert("outcome".into(), val.to_string()));
          self.r#sentences.and_then(|val| map.insert("sentences".into(), val.to_string()));
          self.r#time.and_then(|val| map.insert("time".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.generate
    ///
    /// Recorded when the model finishes generating the preview
    pub static generate: Lazy<EventMetric<GenerateExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "generate".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(367), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct LabsCheckboxExtra {
        pub r#enabled: Option<bool>,
    }

    impl ExtraKeys for LabsCheckboxExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["enabled"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#enabled.and_then(|val| map.insert("enabled".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.labs_checkbox
    ///
    /// Recorded when the user clicks on the Labs checkbox
    pub static labs_checkbox: Lazy<EventMetric<LabsCheckboxExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "labs_checkbox".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(368), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct StartExtra {
        pub r#cached: Option<bool>,
        pub r#source: Option<String>,
    }

    impl ExtraKeys for StartExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["cached", "source"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#cached.and_then(|val| map.insert("cached".into(), val.to_string()));
          self.r#source.and_then(|val| map.insert("source".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from genai.linkpreview.start
    ///
    /// Recorded when the user initiates a link preview
    pub static start: Lazy<EventMetric<StartExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "start".into(),
                category: "genai.linkpreview".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(369), meta)
    });

}
pub mod background_update {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from background_update.reasons_to_not_update
    ///
    /// Records which error was causing the background updater to fail. This list supercedes the `background-update.reason` in `mozapps/update/metrics.yaml`
    pub static reasons_to_not_update: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reasons_to_not_update".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into(), "metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(370), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.time_last_update_scheduled
    ///
    /// Last time the background update was triggered.
    pub static time_last_update_scheduled: Lazy<DatetimeMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "time_last_update_scheduled".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into(), "metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        DatetimeMetric::new(MetricId(371), meta, TimeUnit::Day)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.automatic_restart_attempted
    ///
    /// True if the background update task successfully attempted an automatic restart.
    pub static automatic_restart_attempted: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "automatic_restart_attempted".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(372), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.automatic_restart_success
    ///
    /// True if the background update task successfully restarted after an automatic restart.
    pub static automatic_restart_success: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "automatic_restart_success".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(373), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.client_id
    ///
    /// The legacy Telemetry client ID of this installation's default profile.
    /// The default profile is as determined by the Profile Service, namely `nsIToolkitProfileService.defaultProfile`.  The majority of users have only one Firefox installation and only one profile, so the default profile is their regular browsing profile.
    /// It is possible for a Firefox installation to not have a default profile, but in such cases the background update task will abort before sending any telemetry; therefore, the legacy Telemetry client ID should always be present.
    pub static client_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "client_id".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into(), "baseline".into(), "events".into(), "metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(374), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.exit_code_exception
    ///
    /// True if the exit code/status of the background update task is 3, which means an exception was thrown.
    pub static exit_code_exception: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "exit_code_exception".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(375), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.exit_code_success
    ///
    /// True if the exit code/status of the background update task is 0, which means success.
    pub static exit_code_success: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "exit_code_success".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(376), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.final_state
    ///
    /// String description of the final state the update state machine reached.
    pub static final_state: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "final_state".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(377), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.reasons
    ///
    /// List of reasons that the background update task did not run.
    pub static reasons: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reasons".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(378), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.states
    ///
    /// Ordered list of string descriptions of the states that the update state machine reached.
    pub static states: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "states".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(379), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.targeting_env_current_date
    ///
    /// The `environment.currentDate` of the default profile's serialized targeting snapshot.
    pub static targeting_env_current_date: Lazy<DatetimeMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "targeting_env_current_date".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        DatetimeMetric::new(MetricId(380), meta, TimeUnit::Day)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.targeting_env_firefox_version
    ///
    /// The `environment.firefoxVersion` of the default profile's serialized targeting snapshot.  At the time of writing, this version is an integer representing the Firefox major version, e.g., `109`.
    pub static targeting_env_firefox_version: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "targeting_env_firefox_version".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(381), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.targeting_env_profile_age
    ///
    /// The `environment.profileAgeCreated` of the default profile's serialized targeting snapshot.
    pub static targeting_env_profile_age: Lazy<DatetimeMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "targeting_env_profile_age".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        DatetimeMetric::new(MetricId(382), meta, TimeUnit::Day)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.targeting_exception
    ///
    /// True if the default profile had a targeting snapshot serialized to disk, but an exception was thrown reading it.
    pub static targeting_exception: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "targeting_exception".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(383), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.targeting_exists
    ///
    /// True if the default profile had a targeting snapshot serialized to disk, and there was no exception thrown reading it.
    pub static targeting_exists: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "targeting_exists".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(384), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from background_update.targeting_version
    ///
    /// If the default profile had a targeting snapshot serialized to disk, the `version` of the snapshot.
    /// This version number does not have a physical unit: it's only useful to compare between versions.
    pub static targeting_version: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "targeting_version".into(),
                category: "background_update".into(),
                send_in_pings: vec!["background-update".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(385), meta)
    });

}
pub mod browser {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[repr(u16)]
    pub enum AttributionErrorsLabel {
        EReadError = 0,
        EDecodeError = 1,
        EWriteError = 2,
        EQuarantineError = 3,
        EEmptyError = 4,
        ENullError = 5,
        __Other__,
    }
    impl From<u16> for AttributionErrorsLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EReadError,
                1 => Self::EDecodeError,
                2 => Self::EWriteError,
                3 => Self::EQuarantineError,
                4 => Self::EEmptyError,
                5 => Self::ENullError,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for AttributionErrorsLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EReadError => "read_error",
                Self::EDecodeError => "decode_error",
                Self::EWriteError => "write_error",
                Self::EQuarantineError => "quarantine_error",
                Self::EEmptyError => "empty_error",
                Self::ENullError => "null_error",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.attribution_errors
    ///
    /// Count for the number of errors encountered trying to determine attribution data: on Windows, from the installers (stub and full); on macOS, from an extended attributed on the .app bundle.
    /// This metric was generated to correspond to the Legacy Telemetry categorical histogram BROWSER_ATTRIBUTION_ERRORS.
    pub static attribution_errors: Lazy<LabeledMetric<LabeledCounterMetric, AttributionErrorsLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "attribution_errors".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(386), meta, Some(vec![::std::borrow::Cow::from("decode_error"), ::std::borrow::Cow::from("empty_error"), ::std::borrow::Cow::from("null_error"), ::std::borrow::Cow::from("quarantine_error"), ::std::borrow::Cow::from("read_error"), ::std::borrow::Cow::from("write_error")]))
    });

    #[repr(u16)]
    pub enum IsUserDefaultLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for IsUserDefaultLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for IsUserDefaultLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.is_user_default
    ///
    /// Whether Firefox is the system default browser on startup. A true value is also recorded here, and a false value is recorded to set_default_error, if a user clicked 'Use Firefox as my default browser' on an in-product prompt. (Note that on Windows 8+ the latter action opens the right settings dialog but does not actually change the default browser without further user action.) On Windows, 'system default browser' is operationalized as whether Firefox is the default HTTP protocol handler.
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_IS_USER_DEFAULT.
    pub static is_user_default: Lazy<LabeledMetric<LabeledCounterMetric, IsUserDefaultLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "is_user_default".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(387), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[repr(u16)]
    pub enum IsUserDefaultErrorLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for IsUserDefaultErrorLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for IsUserDefaultErrorLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.is_user_default_error
    ///
    /// True if the browser was unable to determine if the browser was set as default.
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_IS_USER_DEFAULT_ERROR.
    pub static is_user_default_error: Lazy<LabeledMetric<LabeledCounterMetric, IsUserDefaultErrorLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "is_user_default_error".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(388), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[repr(u16)]
    pub enum SetDefaultAlwaysCheckLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for SetDefaultAlwaysCheckLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for SetDefaultAlwaysCheckLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.set_default_always_check
    ///
    /// True if the profile has `browser.shell.checkDefaultBrowser` set to true.
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_SET_DEFAULT_ALWAYS_CHECK.
    pub static set_default_always_check: Lazy<LabeledMetric<LabeledCounterMetric, SetDefaultAlwaysCheckLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "set_default_always_check".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(389), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.set_default_dialog_prompt_rawcount
    ///
    /// The number of times that a profile has seen the 'Set Default Browser' dialog.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram BROWSER_SET_DEFAULT_DIALOG_PROMPT_RAWCOUNT.
    pub static set_default_dialog_prompt_rawcount: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_default_dialog_prompt_rawcount".into(),
                category: "browser".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(390), meta, 1, 250, 15, HistogramType::Exponential)
    });

    #[repr(u16)]
    pub enum SetDefaultErrorLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for SetDefaultErrorLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for SetDefaultErrorLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.set_default_error
    ///
    /// True if the browser was unable to set Firefox as the default browser
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_SET_DEFAULT_ERROR.
    pub static set_default_error: Lazy<LabeledMetric<LabeledCounterMetric, SetDefaultErrorLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "set_default_error".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(391), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[repr(u16)]
    pub enum SetDefaultPdfHandlerUserChoiceResultLabel {
        ESuccess = 0,
        EErrprogid = 1,
        EErrhash = 2,
        EErrlaunchexe = 3,
        EErrexetimeout = 4,
        EErrexeprogid = 5,
        EErrexehash = 6,
        EErrexerejected = 7,
        EErrexeother = 8,
        EErrother = 9,
        EErrbuild = 10,
        __Other__,
    }
    impl From<u16> for SetDefaultPdfHandlerUserChoiceResultLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccess,
                1 => Self::EErrprogid,
                2 => Self::EErrhash,
                3 => Self::EErrlaunchexe,
                4 => Self::EErrexetimeout,
                5 => Self::EErrexeprogid,
                6 => Self::EErrexehash,
                7 => Self::EErrexerejected,
                8 => Self::EErrexeother,
                9 => Self::EErrother,
                10 => Self::EErrbuild,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for SetDefaultPdfHandlerUserChoiceResultLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccess => "Success",
                Self::EErrprogid => "ErrProgID",
                Self::EErrhash => "ErrHash",
                Self::EErrlaunchexe => "ErrLaunchExe",
                Self::EErrexetimeout => "ErrExeTimeout",
                Self::EErrexeprogid => "ErrExeProgID",
                Self::EErrexehash => "ErrExeHash",
                Self::EErrexerejected => "ErrExeRejected",
                Self::EErrexeother => "ErrExeOther",
                Self::EErrother => "ErrOther",
                Self::EErrbuild => "ErrBuild",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.set_default_pdf_handler_user_choice_result
    ///
    /// Result of each attempt to set the default browser with SetDefaultExtensionHandlersUserChoice() for pdf extension
    /// This metric was generated to correspond to the Legacy Telemetry categorical histogram BROWSER_SET_DEFAULT_PDF_HANDLER_USER_CHOICE_RESULT.
    pub static set_default_pdf_handler_user_choice_result: Lazy<LabeledMetric<LabeledCounterMetric, SetDefaultPdfHandlerUserChoiceResultLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "set_default_pdf_handler_user_choice_result".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(392), meta, Some(vec![::std::borrow::Cow::from("ErrBuild"), ::std::borrow::Cow::from("ErrExeHash"), ::std::borrow::Cow::from("ErrExeOther"), ::std::borrow::Cow::from("ErrExeProgID"), ::std::borrow::Cow::from("ErrExeRejected"), ::std::borrow::Cow::from("ErrExeTimeout"), ::std::borrow::Cow::from("ErrHash"), ::std::borrow::Cow::from("ErrLaunchExe"), ::std::borrow::Cow::from("ErrOther"), ::std::borrow::Cow::from("ErrProgID"), ::std::borrow::Cow::from("Success")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.set_default_result
    ///
    /// Result of the Set Default Browser dialog. After Firefox 89 the these values are: (0=Use Firefox + 'Don't ask again' checked, 1=Use Firefox + 'Don't ask again' unchecked, 2=Not Now + 'Don't ask again' checked, 3=Not Now + 'Don't ask again' unchecked). Before Firefox 89 these values were: (0=Use Firefox + 'Always perform check' unchecked, 1=Use Firefox + 'Always perform check' checked, 2=Not Now + 'Always perform check' unchecked, 3=Not Now + 'Always perform check' checked).
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram BROWSER_SET_DEFAULT_RESULT.
    pub static set_default_result: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_default_result".into(),
                category: "browser".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(393), meta, 0, 4, 5, HistogramType::Linear)
    });

    #[repr(u16)]
    pub enum SetDefaultUserChoiceResultLabel {
        ESuccess = 0,
        EErrprogid = 1,
        EErrhash = 2,
        EErrlaunchexe = 3,
        EErrexetimeout = 4,
        EErrexeprogid = 5,
        EErrexehash = 6,
        EErrexerejected = 7,
        EErrexeother = 8,
        EErrother = 9,
        EErrbuild = 10,
        __Other__,
    }
    impl From<u16> for SetDefaultUserChoiceResultLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESuccess,
                1 => Self::EErrprogid,
                2 => Self::EErrhash,
                3 => Self::EErrlaunchexe,
                4 => Self::EErrexetimeout,
                5 => Self::EErrexeprogid,
                6 => Self::EErrexehash,
                7 => Self::EErrexerejected,
                8 => Self::EErrexeother,
                9 => Self::EErrother,
                10 => Self::EErrbuild,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for SetDefaultUserChoiceResultLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESuccess => "Success",
                Self::EErrprogid => "ErrProgID",
                Self::EErrhash => "ErrHash",
                Self::EErrlaunchexe => "ErrLaunchExe",
                Self::EErrexetimeout => "ErrExeTimeout",
                Self::EErrexeprogid => "ErrExeProgID",
                Self::EErrexehash => "ErrExeHash",
                Self::EErrexerejected => "ErrExeRejected",
                Self::EErrexeother => "ErrExeOther",
                Self::EErrother => "ErrOther",
                Self::EErrbuild => "ErrBuild",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.set_default_user_choice_result
    ///
    /// Result of each attempt to set the default browser with SetDefaultBrowserUserChoice()
    /// This metric was generated to correspond to the Legacy Telemetry categorical histogram BROWSER_SET_DEFAULT_USER_CHOICE_RESULT.
    pub static set_default_user_choice_result: Lazy<LabeledMetric<LabeledCounterMetric, SetDefaultUserChoiceResultLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "set_default_user_choice_result".into(),
                    category: "browser".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(394), meta, Some(vec![::std::borrow::Cow::from("ErrBuild"), ::std::borrow::Cow::from("ErrExeHash"), ::std::borrow::Cow::from("ErrExeOther"), ::std::borrow::Cow::from("ErrExeProgID"), ::std::borrow::Cow::from("ErrExeRejected"), ::std::borrow::Cow::from("ErrExeTimeout"), ::std::borrow::Cow::from("ErrHash"), ::std::borrow::Cow::from("ErrLaunchExe"), ::std::borrow::Cow::from("ErrOther"), ::std::borrow::Cow::from("ErrProgID"), ::std::borrow::Cow::from("Success")]))
    });

}
pub mod browser_launched_to_handle {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SystemNotificationExtra {
        pub r#action: Option<String>,
        pub r#name: Option<String>,
    }

    impl ExtraKeys for SystemNotificationExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action", "name"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action.and_then(|val| map.insert("action".into(), val.to_string()));
          self.r#name.and_then(|val| map.insert("name".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.launched_to_handle.system_notification
    ///
    /// Recorded when Firefox launches to complete a native notification popped by a system (chrome privileged) alert.  Windows-only at the time of writing.
    pub static system_notification: Lazy<EventMetric<SystemNotificationExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "system_notification".into(),
                category: "browser.launched_to_handle".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(395), meta)
    });

}
pub mod browser_startup {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.startup.abouthome_cache_result
    ///
    /// How the about:home startup cache functioned on startup.
    /// 0: Result value was never set (error case) 1: Cache did not exist 2: Cache page stream was corrupt / inaccessible 3: Cache script stream was corrupt / inaccessible 4: Cache was invalidated by a version bump 5: Cache was valid, but read too late to be useful. 6: Cache was valid and used. 7: Cache is disabled. 8: User did not load about:home on its own by default. 9: Cache is disabled because about:newtab preloading is disabled.
    /// This metric was generated to correspond to the Legacy Telemetry scalar browser.startup.abouthome_cache_result.
    pub static abouthome_cache_result: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "abouthome_cache_result".into(),
                category: "browser.startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(396), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.startup.abouthome_cache_shutdownwrite
    ///
    /// True if the about:home startup cache was written via the AsyncShutdown blocker. This metric was generated to correspond to the Legacy Telemetry scalar browser.startup.abouthome_cache_shutdownwrite.
    pub static abouthome_cache_shutdownwrite: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "abouthome_cache_shutdownwrite".into(),
                category: "browser.startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(397), meta)
    });

}
pub mod datasanitization {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_cache
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.cache pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_cache.
    pub static privacy_clear_on_shutdown_cache: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_cache".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(398), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_cookies
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.cookies pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_cookies.
    pub static privacy_clear_on_shutdown_cookies: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_cookies".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(399), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_downloads
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.downloads pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_downloads.
    pub static privacy_clear_on_shutdown_downloads: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_downloads".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(400), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_formdata
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.formdata pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_formdata.
    pub static privacy_clear_on_shutdown_formdata: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_formdata".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(401), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_history
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.history pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_history.
    pub static privacy_clear_on_shutdown_history: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_history".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(402), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_offline_apps
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.offlineApps pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_offlineApps.
    pub static privacy_clear_on_shutdown_offline_apps: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_offline_apps".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(403), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_open_windows
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.openWindows pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_openWindows.
    pub static privacy_clear_on_shutdown_open_windows: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_open_windows".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(404), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_sessions
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.sessions pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_sessions.
    pub static privacy_clear_on_shutdown_sessions: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_sessions".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(405), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_clear_on_shutdown_site_settings
    ///
    /// A boolean reporting the value of the privacy.clearOnShutdown.siteSettings pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_siteSettings.
    pub static privacy_clear_on_shutdown_site_settings: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_clear_on_shutdown_site_settings".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(406), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.privacy_sanitize_sanitize_on_shutdown
    ///
    /// A boolean reporting the value of the privacy.sanitize.sanitizeOnShutdown pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_sanitize_sanitizeOnShutdown.
    pub static privacy_sanitize_sanitize_on_shutdown: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "privacy_sanitize_sanitize_on_shutdown".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(407), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from datasanitization.session_permission_exceptions
    ///
    /// A count of how many "session" cookie exceptions a user has set. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.session_permission_exceptions.
    pub static session_permission_exceptions: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "session_permission_exceptions".into(),
                category: "datasanitization".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(408), meta)
    });

}
pub mod launch_on_login {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from launch_on_login.last_profile_disable_startup
    ///
    /// Recorded when Launch on login is disabled because the start with last profile setting has been disabled. This event was generated to correspond to the Legacy Telemetry event launch_on_login.last_profile_disable#startup.
    pub static last_profile_disable_startup: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "last_profile_disable_startup".into(),
                category: "launch_on_login".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(409), meta)
    });

}
pub mod os_environment {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.invoked_to_handle
    ///
    /// Records counts for when Firefox was invoked (i.e., was already running and was not launched) to handle a file type or protocol with `-osint -url ...`.  The result is split into keys which represent the file extension: currently, the set of file types Firefox registers to handle, namely ".avif", ".htm", ".html", ".pdf", ".shtml", ".xht", ".xhtml", ".svg", ".webp", and the set of protocol schemes that Firefox registers to handle, namely "about", "http", "https", "mailto".  If Firefox was invoked to handle a file type or protocol it does not register to handle by default, the count is recorded as ".<other extension>" or "<other protocol>", respectively (neither of which are valid extension or protocol identifiers). This metric was generated to correspond to the Legacy Telemetry scalar os.environment.invoked_to_handle.
    pub static invoked_to_handle: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "invoked_to_handle".into(),
                    category: "os.environment".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(410), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.is_default_handler
    ///
    /// Records whether Firefox was the default handler for particular file types or protocols.  The result is split into keys which represent the file extension or scheme: currently, a subset of the file types Firefox registers to handle, namely ".pdf" and "mailto" as protocol. In the future, more file types may be recorded. This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_default_handler.
    pub static is_default_handler: Lazy<LabeledMetric<LabeledBooleanMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "is_default_handler".into(),
                    category: "os.environment".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(411), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.is_kept_in_dock
    ///
    /// Whether this app was kept in macOS Dock on startup This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_kept_in_dock.
    pub static is_kept_in_dock: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "is_kept_in_dock".into(),
                category: "os.environment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(412), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.is_taskbar_pinned
    ///
    /// Whether the non-Private Browsing version of this app was pinned to taskbar on startup This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_taskbar_pinned.
    pub static is_taskbar_pinned: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "is_taskbar_pinned".into(),
                category: "os.environment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(413), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.is_taskbar_pinned_private
    ///
    /// Whether the Private Browsing version of this app was pinned to taskbar on startup This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_taskbar_pinned_private.
    pub static is_taskbar_pinned_private: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "is_taskbar_pinned_private".into(),
                category: "os.environment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(414), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.launch_method
    ///
    /// Records how Firefox was started on Windows. Currently will be one of "Desktop", "DesktopPrivate", "StartMenu" (including pins), "StartMenuPrivate", "Taskbar", "TaskbarPrivate", "OtherShortcut", or "Other" This metric was generated to correspond to the Legacy Telemetry scalar os.environment.launch_method.
    pub static launch_method: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "launch_method".into(),
                category: "os.environment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(415), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.launched_to_handle
    ///
    /// Records counts for when Firefox was launched afresh (i.e., was not already running) to handle a file type or protocol with `-osint -url ...`.  The result is split into keys which represent the file extension: currently, the set of file types Firefox registers to handle, namely ".avif", ".htm", ".html", ".pdf", ".shtml", ".xht", ".xhtml", ".svg", ".webp", and the set of protocol schemes that Firefox registers to handle, namely "about", "http", "https", "mailto".  If Firefox was launched to handle a file type or protocol it does not register to handle by default, the count is recorded as ".<other extension>" or "<other protocol>", respectively (neither of which are valid extension or protocol identifiers). This metric was generated to correspond to the Legacy Telemetry scalar os.environment.launched_to_handle.
    pub static launched_to_handle: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "launched_to_handle".into(),
                    category: "os.environment".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(416), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.allowed_app_sources
    ///
    /// Indicates what sources the OS is currently configured to allow apps to be installed from. Possible values are "Anywhere", "Recommendations", "PreferStore", "StoreOnly", "NoSuchFeature", or "Error". "Recommendations" allows installs from anywhere, but recommends a comparable app from the store, if available. "NoSuchFeature" will be reported on versions of Windows that do not have an app source setting. This metric was generated to correspond to the Legacy Telemetry scalar os.environment.allowed_app_sources.
    pub static allowed_app_sources: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "allowed_app_sources".into(),
                category: "os.environment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(417), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from os.environment.is_admin_without_uac
    ///
    /// Indicates that the process is lauched with Admin privileges but without UAC. This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_admin_without_uac.
    pub static is_admin_without_uac: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "is_admin_without_uac".into(),
                category: "os.environment".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(418), meta)
    });

}
pub mod primary_password {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from primary.password.enabled
    ///
    /// If a primary-password is enabled for this profile. Set soon after browser startup. Does not update if a primary password is added or removed after startup.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "primary.password".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(419), meta)
    });

}
pub mod security {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from security.global_privacy_control_enabled
    ///
    /// Measures user retention of the Global Privacy Control. 0 = never enabled, 1 = enabled, 2 = disabled (but was enabled) This metric was generated to correspond to the Legacy Telemetry scalar security.global_privacy_control_enabled.
    pub static global_privacy_control_enabled: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "global_privacy_control_enabled".into(),
                category: "security".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(420), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.https_only_mode_enabled
    ///
    /// Measures user retention of the HTTPS-Only Mode. 0 = never enabled, 1 = enabled, 2 = disabled (but was enabled) This metric was generated to correspond to the Legacy Telemetry scalar security.https_only_mode_enabled.
    pub static https_only_mode_enabled: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "https_only_mode_enabled".into(),
                category: "security".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(421), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.https_only_mode_enabled_pbm
    ///
    /// Measures user retention of the HTTPS-Only Mode in Private Browsing. 0 = https-only never enabled in PBM, 1 = https-only enabled in PBM, 2 = https-only disabled in PBM (but was enabled) This metric was generated to correspond to the Legacy Telemetry scalar security.https_only_mode_enabled_pbm.
    pub static https_only_mode_enabled_pbm: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "https_only_mode_enabled_pbm".into(),
                category: "security".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(422), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FissionPrincipalsExtra {
        pub r#principalType: Option<String>,
        pub r#scheme: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for FissionPrincipalsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["principalType", "scheme", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#principalType.and_then(|val| map.insert("principalType".into(), val.to_string()));
          self.r#scheme.and_then(|val| map.insert("scheme".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.fission_principals
    ///
    /// When running with Fission, we received an unexpected principal from the content process. Expected values for this telemetry event are the method names in ContentParent that received the unexpected principal. This event was generated to correspond to the Legacy Telemetry event security.fissionPrincipals#contentParent.
    pub static fission_principals: Lazy<EventMetric<FissionPrincipalsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fission_principals".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(423), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CspViolationInternalPageExtra {
        pub r#blockeduridetails: Option<String>,
        pub r#blockeduritype: Option<String>,
        pub r#columnnumber: Option<u32>,
        pub r#directive: Option<String>,
        pub r#linenumber: Option<u32>,
        pub r#sample: Option<String>,
        pub r#selfdetails: Option<String>,
        pub r#selftype: Option<String>,
        pub r#sourcedetails: Option<String>,
        pub r#sourcetype: Option<String>,
    }

    impl ExtraKeys for CspViolationInternalPageExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["blockeduridetails", "blockeduritype", "columnnumber", "directive", "linenumber", "sample", "selfdetails", "selftype", "sourcedetails", "sourcetype"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#blockeduridetails.and_then(|val| map.insert("blockeduridetails".into(), val.to_string()));
          self.r#blockeduritype.and_then(|val| map.insert("blockeduritype".into(), val.to_string()));
          self.r#columnnumber.and_then(|val| map.insert("columnnumber".into(), val.to_string()));
          self.r#directive.and_then(|val| map.insert("directive".into(), val.to_string()));
          self.r#linenumber.and_then(|val| map.insert("linenumber".into(), val.to_string()));
          self.r#sample.and_then(|val| map.insert("sample".into(), val.to_string()));
          self.r#selfdetails.and_then(|val| map.insert("selfdetails".into(), val.to_string()));
          self.r#selftype.and_then(|val| map.insert("selftype".into(), val.to_string()));
          self.r#sourcedetails.and_then(|val| map.insert("sourcedetails".into(), val.to_string()));
          self.r#sourcetype.and_then(|val| map.insert("sourcetype".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.csp_violation_internal_page
    ///
    /// Information about Content-Security-Policy violations that happen in internal pages like chrome://
    pub static csp_violation_internal_page: Lazy<EventMetric<CspViolationInternalPageExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "csp_violation_internal_page".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(424), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EvalUsageParentProcessExtra {
        pub r#fileinfo: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EvalUsageParentProcessExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["fileinfo", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#fileinfo.and_then(|val| map.insert("fileinfo".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.eval_usage_parent_process
    ///
    /// eval() (or an eval()-like method) was called while running in the System Principal context or the Parent Process. Expected values are: chromeuri - chrome:// file   resourceuri - resource:// file datauri - a data URI   bloburi - a blob URI   abouturi - an about URI   singlestring - A single file or string with no slashes mozillaextension - An extension claiming to be from *mozilla.org (Deprecated)   otherextension - Another extension not from Mozilla (Deprecated)   mozillaextension_file - An extension claiming to be from *mozilla.org, loaded from a file://   otherextension_file - Another extension not from Mozilla, loaded from a file:// extension_uri - A URI with the moz-extension:// scheme suspectedUserChromeJS - A filepath ending in .uc.js sanitizedWindowsPath - A filepath, on Windows, sanitized by WinUtils::PreparePathForTelemetry                          which is a bare filename or a subpath of %ProgramFiles%, %SystemRoot%, or %TEMP%   sanitizedWindowsURL - A partial URL, on Windows, consisting of either file://../ followed by the value prepared as for sanitizedWindowsPath, or the bare scheme of                         the original url   other - Unknown other-on-worker - We cannot do a regex; it is not a chrome, resource, data, or blob uri, but                     could be any other.   regexfailure - Our Regex Matching code threw an error The fileinfo key may contain additional information about the file that caused the eval() depending on the above value. Resource, Chrome, About, and SingleString will contain the full value. (About URIs will remove any querystring values.) Extensions-from-file will contain the full value; however .xpi! will be shortened to !, shield.mozilla.org! to s! and mozilla.org! to m!.  Data, Blob, UserChromeJS, Other, and Regexfailure should have no value. This event was generated to correspond to the Legacy Telemetry event security.evalUsage#parentProcess.
    pub static eval_usage_parent_process: Lazy<EventMetric<EvalUsageParentProcessExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "eval_usage_parent_process".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(425), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EvalUsageSystemContextExtra {
        pub r#fileinfo: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EvalUsageSystemContextExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["fileinfo", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#fileinfo.and_then(|val| map.insert("fileinfo".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.eval_usage_system_context
    ///
    /// eval() (or an eval()-like method) was called while running in the System Principal context or the Parent Process. Expected values are:
    ///   - chromeuri - chrome:// file
    ///   - resourceuri - resource:// file
    ///   - datauri - a data URI
    ///   - bloburi - a blob URI
    ///   - abouturi - an about URI
    ///   - singlestring - A single file or string with no slashes
    ///   - mozillaextension - An extension claiming to be from *mozilla.org (Deprecated)
    ///   - otherextension - Another extension not from Mozilla (Deprecated)
    ///   - mozillaextension_file - An extension claiming to be from *mozilla.org, loaded from a file://
    ///   - otherextension_file - Another extension not from Mozilla, loaded from a file://
    ///   - extension_uri - A URI with the moz-extension:// scheme
    ///   - suspectedUserChromeJS - A filepath ending in .uc.js
    ///   - sanitizedWindowsPath - A filepath, on Windows, sanitized by WinUtils::PreparePathForTelemetry which is a bare filename or a subpath of %ProgramFiles%, %SystemRoot%, or %TEMP%
    ///   - sanitizedWindowsURL - A partial URL, on Windows, consisting of either file://../ followed by the value prepared as for sanitizedWindowsPath, or the bare scheme of the original url
    ///   - other - Unknown
    ///   - other-on-worker - We cannot do a regex; it is not a chrome, resource, data, or blob uri, but could be any other.
    ///   - regexfailure - Our Regex Matching code threw an error
    /// 
    /// The fileinfo key may contain additional information about the file that caused the eval() depending on the above value. Resource, Chrome, About, and SingleString will contain the full value. (About URIs will remove any querystring values.)
    /// Extensions-from-file will contain the full value; however .xpi! will be shortened to !, shield.mozilla.org! to s! and mozilla.org! to m!.  Data, Blob, UserChromeJS, Other, and Regexfailure should have no value.
    /// This event was generated to correspond to the Legacy Telemetry event security.evalUsage#systemContext.
    pub static eval_usage_system_context: Lazy<EventMetric<EvalUsageSystemContextExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "eval_usage_system_context".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(426), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct JavascriptLoadParentProcessExtra {
        pub r#fileinfo: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for JavascriptLoadParentProcessExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["fileinfo", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#fileinfo.and_then(|val| map.insert("fileinfo".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.javascript_load_parent_process
    ///
    /// The javascript engine requested to load a filename that was not allowed. Expected values, and fileinfo key, are the same possible values as above in 'evalUsage' This event was generated to correspond to the Legacy Telemetry event security.javascriptLoad#parentProcess.
    pub static javascript_load_parent_process: Lazy<EventMetric<JavascriptLoadParentProcessExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "javascript_load_parent_process".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(427), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct UnexpectedLoadExtra {
        pub r#contenttype: Option<String>,
        pub r#filedetails: Option<String>,
        pub r#redirects: Option<String>,
        pub r#remotetype: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for UnexpectedLoadExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["contenttype", "filedetails", "redirects", "remotetype", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#contenttype.and_then(|val| map.insert("contenttype".into(), val.to_string()));
          self.r#filedetails.and_then(|val| map.insert("filedetails".into(), val.to_string()));
          self.r#redirects.and_then(|val| map.insert("redirects".into(), val.to_string()));
          self.r#remotetype.and_then(|val| map.insert("remotetype".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.unexpected_load
    ///
    /// Long term want to block all loads from the system principal that cause us to parse non-trivial data. We don't look to break existing functionality and will allow exceptions, for this we are collecting information about unexpected requests triggered by the system principal Our measurement *excludes* acceptable requests. Those are: - annotated using the 'AllowedDeprecatedSystemRequests' loadinfo flag - using a nsContentPolicyType of FETCH, XMLHTTPREQUEST, WEBSOCKET, SAVEAS_DOWNLOAD or IMAGE - with a requested URI object has the flag URI_IS_UI_RESOURCE - if the URL scheme is 'view-source' - if the URL scheme is 'file' and the Content-Type is STYLESHEET or OTHER - if the scheme is 'jar', 'about' or 'moz-extension' This event was generated to correspond to the Legacy Telemetry event security.unexpectedload#systemprincipal.
    pub static unexpected_load: Lazy<EventMetric<UnexpectedLoadExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "unexpected_load".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(428), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct PrefUsageContentProcessExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for PrefUsageContentProcessExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.pref_usage_content_process
    ///
    /// We block certain preferences from being sent to the content process because they contain sensitive user data. Some preferences are blocked by name, others by heuristic. If one of the preferences so blocked is accidently accessed we want to know about it so we can allowlist it or refactor the access. This event was generated to correspond to the Legacy Telemetry event security.prefUsage#contentProcess.
    pub static pref_usage_content_process: Lazy<EventMetric<PrefUsageContentProcessExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "pref_usage_content_process".into(),
                category: "security".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(429), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from security.client_auth_cert_usage
    ///
    /// Measures how many servers have requested a client authentication certificate (key: "requested") and how many times the user has opted to send one in response (key: "sent"). This metric was generated to correspond to the Legacy Telemetry scalar security.client_auth_cert_usage.
    pub static client_auth_cert_usage: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "client_auth_cert_usage".into(),
                    category: "security".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(430), meta, None)
    });

}
pub mod sslkeylogging {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from sslkeylogging.enabled
    ///
    /// Records whether TLS key logging has been enabled via the environment variable SSLKEYLOGFILE.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "sslkeylogging".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(431), meta)
    });

}
pub mod start_menu {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from start_menu.manually_unpinned_since_last_launch
    ///
    /// Records whether Firefox has been unpinned from the Windows start menu since last launch. This will only be recorded on MSIX due to the underlying API only being available for packaged applications.
    pub static manually_unpinned_since_last_launch: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "manually_unpinned_since_last_launch".into(),
                category: "start_menu".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(432), meta)
    });

}
pub mod startup {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from startup.is_cold
    ///
    /// Whether or not this startup is the first startup since OS reboot (according to our best guess.) This metric was generated to correspond to the Legacy Telemetry scalar startup.is_cold.
    pub static is_cold: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "is_cold".into(),
                category: "startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(433), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from startup.seconds_since_last_os_restart
    ///
    /// The time in seconds between the first browser window loading, and the time the OS started. This can give us an indication of whether starting the browser may have been the first thing the user did after starting their computer. This metric was generated to correspond to the Legacy Telemetry scalar startup.seconds_since_last_os_restart.
    pub static seconds_since_last_os_restart: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "seconds_since_last_os_restart".into(),
                category: "startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(434), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from startup.profile_count
    ///
    /// This records the number of known profiles after startup completes. This includes any profiles that were created during startup. This metric was generated to correspond to the Legacy Telemetry scalar startup.profile_count.
    pub static profile_count: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "profile_count".into(),
                category: "startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(435), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from startup.profile_database_version
    ///
    /// The version of the profiles.ini database loaded during startup. A value of "0" is used to indicate that no file was present during startup. This metric was generated to correspond to the Legacy Telemetry scalar startup.profile_database_version.
    pub static profile_database_version: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "profile_database_version".into(),
                category: "startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(436), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from startup.profile_selection_reason
    ///
    /// How the profile was selected during startup. One of the following reasons:
    ///   unknown:
    ///     Generally should not happen, set as a default in case no other reason
    ///     occured.
    ///   profile-manager:
    ///     The profile was selected by the profile manager.
    ///   profile-selector:
    ///     The profile was selected by the profile selector window.
    ///   profile-reset:
    ///     The profile was selected for reset, normally this would mean a restart.
    ///   restart:
    ///     The user restarted the application, the same profile as previous will
    ///     be used.
    ///   argument-profile:
    ///     The profile was selected by the --profile command line argument.
    ///   argument-p:
    ///     The profile was selected by the -p command line argument.
    ///   firstrun-claimed-default:
    ///     A first run of a dedicated profiles build chose the old default
    ///     profile to be the default for this install.
    ///   firstrun-skipped-default:
    ///     A first run of a dedicated profiles build skipped over the old default
    ///     profile and created a new profile.
    ///   restart-claimed-default:
    ///     A first run of a dedicated profiles build after a restart chose the
    ///     old default profile to be the default for this install.
    ///   restart-skipped-default:
    ///     A first run of a dedicated profiles build after a restart skipped over
    ///     the old default profile and created a new profile.
    ///   firstrun-created-default:
    ///     A first run of the application created a new profile to use.
    ///   default:
    ///     The default profile was selected as normal.
    /// This metric was generated to correspond to the Legacy Telemetry scalar startup.profile_selection_reason.
    pub static profile_selection_reason: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "profile_selection_reason".into(),
                category: "startup".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(437), meta)
    });

}
pub mod upgrade_dialog {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TriggerReasonExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for TriggerReasonExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from upgrade_dialog.trigger_reason
    ///
    /// Triggering behaviors of the upgrade dialog. Value indicates which condition failed or all satisfied. This event was generated to correspond to the Legacy Telemetry event upgrade_dialog.trigger#reason.
    pub static trigger_reason: Lazy<EventMetric<TriggerReasonExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "trigger_reason".into(),
                category: "upgrade_dialog".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(438), meta)
    });

}
pub mod browser_migration {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.bookmarks_quantity
    ///
    /// How many bookmarks we imported from another browser, keyed by the name of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_BOOKMARKS_QUANTITY.
    pub static bookmarks_quantity: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "bookmarks_quantity".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 1, range_max: 1000, bucket_count: 20, histogram_type: HistogramType::Exponential};
        LabeledMetric::new(MetricId(439), meta, None)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct BrowserSelectedWizardExtra {
        pub r#migrator_key: Option<String>,
    }

    impl ExtraKeys for BrowserSelectedWizardExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["migrator_key"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#migrator_key.and_then(|val| map.insert("migrator_key".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.browser_selected_wizard
    ///
    /// Recorded when the user selects a browser to migrate from. This event was generated to correspond to the Legacy Telemetry event browser.migration.browser_selected#wizard.
    pub static browser_selected_wizard: Lazy<EventMetric<BrowserSelectedWizardExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "browser_selected_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(440), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.cards_quantity
    ///
    /// How many credit card entries we imported from another browser, keyed by the name of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_CARDS_QUANTITY.
    pub static cards_quantity: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "cards_quantity".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 1, range_max: 1000, bucket_count: 20, histogram_type: HistogramType::Exponential};
        LabeledMetric::new(MetricId(441), meta, None)
    });

    #[repr(u16)]
    pub enum EntryPointCategoricalLabel {
        EUnknown = 0,
        EFirstrun = 1,
        EFxrefresh = 2,
        EPlaces = 3,
        EPasswords = 4,
        ENewtab = 5,
        EFileMenu = 6,
        EHelpMenu = 7,
        EBookmarksToolbar = 8,
        EPreferences = 9,
        __Other__,
    }
    impl From<u16> for EntryPointCategoricalLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EUnknown,
                1 => Self::EFirstrun,
                2 => Self::EFxrefresh,
                3 => Self::EPlaces,
                4 => Self::EPasswords,
                5 => Self::ENewtab,
                6 => Self::EFileMenu,
                7 => Self::EHelpMenu,
                8 => Self::EBookmarksToolbar,
                9 => Self::EPreferences,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for EntryPointCategoricalLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EUnknown => "unknown",
                Self::EFirstrun => "firstrun",
                Self::EFxrefresh => "fxrefresh",
                Self::EPlaces => "places",
                Self::EPasswords => "passwords",
                Self::ENewtab => "newtab",
                Self::EFileMenu => "file_menu",
                Self::EHelpMenu => "help_menu",
                Self::EBookmarksToolbar => "bookmarks_toolbar",
                Self::EPreferences => "preferences",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.entry_point_categorical
    ///
    /// Where the migration wizard was entered from.
    /// This metric was generated to correspond to the Legacy Telemetry categorical histogram FX_MIGRATION_ENTRY_POINT_CATEGORICAL.
    pub static entry_point_categorical: Lazy<LabeledMetric<LabeledCounterMetric, EntryPointCategoricalLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "entry_point_categorical".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(442), meta, Some(vec![::std::borrow::Cow::from("bookmarks_toolbar"), ::std::borrow::Cow::from("file_menu"), ::std::borrow::Cow::from("firstrun"), ::std::borrow::Cow::from("fxrefresh"), ::std::borrow::Cow::from("help_menu"), ::std::borrow::Cow::from("newtab"), ::std::borrow::Cow::from("passwords"), ::std::borrow::Cow::from("places"), ::std::borrow::Cow::from("preferences"), ::std::borrow::Cow::from("unknown")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.errors
    ///
    /// Errors encountered during migration in buckets defined by the datatype, keyed by the string description of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_MIGRATION_ERRORS.
    pub static errors: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "errors".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 0, range_max: 12, bucket_count: 13, histogram_type: HistogramType::Linear};
        LabeledMetric::new(MetricId(443), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.extensions_quantity
    ///
    /// How many extensions were matched to be imported from another browser, keyed by the name of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_EXTENSIONS_QUANTITY.
    pub static extensions_quantity: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "extensions_quantity".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 1, range_max: 1000, bucket_count: 20, histogram_type: HistogramType::Exponential};
        LabeledMetric::new(MetricId(444), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.history_quantity
    ///
    /// How many history visits we imported from another browser, keyed by the name of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_HISTORY_QUANTITY.
    pub static history_quantity: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "history_quantity".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 1, range_max: 10000, bucket_count: 40, histogram_type: HistogramType::Exponential};
        LabeledMetric::new(MetricId(445), meta, None)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct LinuxPermsWizardExtra {
        pub r#migrator_key: Option<String>,
    }

    impl ExtraKeys for LinuxPermsWizardExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["migrator_key"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#migrator_key.and_then(|val| map.insert("migrator_key".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.linux_perms_wizard
    ///
    /// Recorded if the user is on Linux and the browser is installed in a sandboxed environment that prevents it from reading other browser's data, and the user is presented with instructions and an option to grant the browser permission to read that other data. This event was generated to correspond to the Legacy Telemetry event browser.migration.linux_perms#wizard.
    pub static linux_perms_wizard: Lazy<EventMetric<LinuxPermsWizardExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "linux_perms_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(446), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.logins_quantity
    ///
    /// How many logins (passwords) we imported from another browser, keyed by the name of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_LOGINS_QUANTITY.
    pub static logins_quantity: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "logins_quantity".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 1, range_max: 1000, bucket_count: 20, histogram_type: HistogramType::Exponential};
        LabeledMetric::new(MetricId(447), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.matched_extensions
    ///
    /// Records a list of the Chrome extension IDs that were successfully matched to Firefox equivalents from the list downloaded from AMO.
    pub static matched_extensions: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "matched_extensions".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(448), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct MigrationFinishedWizardExtra {
        pub r#bookmarks: Option<String>,
        pub r#extensions: Option<String>,
        pub r#formdata: Option<String>,
        pub r#history: Option<String>,
        pub r#migrator_key: Option<String>,
        pub r#other: Option<u32>,
        pub r#passwords: Option<String>,
        pub r#payment_methods: Option<String>,
    }

    impl ExtraKeys for MigrationFinishedWizardExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["bookmarks", "extensions", "formdata", "history", "migrator_key", "other", "passwords", "payment_methods"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#bookmarks.and_then(|val| map.insert("bookmarks".into(), val.to_string()));
          self.r#extensions.and_then(|val| map.insert("extensions".into(), val.to_string()));
          self.r#formdata.and_then(|val| map.insert("formdata".into(), val.to_string()));
          self.r#history.and_then(|val| map.insert("history".into(), val.to_string()));
          self.r#migrator_key.and_then(|val| map.insert("migrator_key".into(), val.to_string()));
          self.r#other.and_then(|val| map.insert("other".into(), val.to_string()));
          self.r#passwords.and_then(|val| map.insert("passwords".into(), val.to_string()));
          self.r#payment_methods.and_then(|val| map.insert("payment_methods".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.migration_finished_wizard
    ///
    /// Recorded when the user finishes a migration. This event was generated to correspond to the Legacy Telemetry event browser.migration.migration_finished#wizard.
    pub static migration_finished_wizard: Lazy<EventMetric<MigrationFinishedWizardExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "migration_finished_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(449), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct MigrationStartedWizardExtra {
        pub r#bookmarks: Option<String>,
        pub r#extensions: Option<String>,
        pub r#formdata: Option<String>,
        pub r#history: Option<String>,
        pub r#migrator_key: Option<String>,
        pub r#other: Option<u32>,
        pub r#passwords: Option<String>,
        pub r#payment_methods: Option<String>,
    }

    impl ExtraKeys for MigrationStartedWizardExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["bookmarks", "extensions", "formdata", "history", "migrator_key", "other", "passwords", "payment_methods"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#bookmarks.and_then(|val| map.insert("bookmarks".into(), val.to_string()));
          self.r#extensions.and_then(|val| map.insert("extensions".into(), val.to_string()));
          self.r#formdata.and_then(|val| map.insert("formdata".into(), val.to_string()));
          self.r#history.and_then(|val| map.insert("history".into(), val.to_string()));
          self.r#migrator_key.and_then(|val| map.insert("migrator_key".into(), val.to_string()));
          self.r#other.and_then(|val| map.insert("other".into(), val.to_string()));
          self.r#passwords.and_then(|val| map.insert("passwords".into(), val.to_string()));
          self.r#payment_methods.and_then(|val| map.insert("payment_methods".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.migration_started_wizard
    ///
    /// Recorded when the user begins a migration. This event was generated to correspond to the Legacy Telemetry event browser.migration.migration_started#wizard.
    pub static migration_started_wizard: Lazy<EventMetric<MigrationStartedWizardExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "migration_started_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(450), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.no_browsers_found_wizard
    ///
    /// Recorded when the migration wizard reports that there are no browsers to migrate from. This event was generated to correspond to the Legacy Telemetry event browser.migration.no_browsers_found#wizard.
    pub static no_browsers_found_wizard: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "no_browsers_found_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(451), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.opened_wizard
    ///
    /// Recorded when the migration wizard opens. This event was generated to correspond to the Legacy Telemetry event browser.migration.opened#wizard.
    pub static opened_wizard: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "opened_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(452), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ProfileSelectedWizardExtra {
        pub r#migrator_key: Option<String>,
    }

    impl ExtraKeys for ProfileSelectedWizardExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["migrator_key"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#migrator_key.and_then(|val| map.insert("migrator_key".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.profile_selected_wizard
    ///
    /// Recorded when the user selects a profile to migrate from. If the browser doesn't support multiple profiles, this will not be recorded. This event was generated to correspond to the Legacy Telemetry event browser.migration.profile_selected#wizard.
    pub static profile_selected_wizard: Lazy<EventMetric<ProfileSelectedWizardExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "profile_selected_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(453), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ResourcesSelectedWizardExtra {
        pub r#bookmarks: Option<String>,
        pub r#configured: Option<String>,
        pub r#extensions: Option<String>,
        pub r#formdata: Option<String>,
        pub r#history: Option<String>,
        pub r#migrator_key: Option<String>,
        pub r#other: Option<u32>,
        pub r#passwords: Option<String>,
        pub r#payment_methods: Option<String>,
    }

    impl ExtraKeys for ResourcesSelectedWizardExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["bookmarks", "configured", "extensions", "formdata", "history", "migrator_key", "other", "passwords", "payment_methods"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#bookmarks.and_then(|val| map.insert("bookmarks".into(), val.to_string()));
          self.r#configured.and_then(|val| map.insert("configured".into(), val.to_string()));
          self.r#extensions.and_then(|val| map.insert("extensions".into(), val.to_string()));
          self.r#formdata.and_then(|val| map.insert("formdata".into(), val.to_string()));
          self.r#history.and_then(|val| map.insert("history".into(), val.to_string()));
          self.r#migrator_key.and_then(|val| map.insert("migrator_key".into(), val.to_string()));
          self.r#other.and_then(|val| map.insert("other".into(), val.to_string()));
          self.r#passwords.and_then(|val| map.insert("passwords".into(), val.to_string()));
          self.r#payment_methods.and_then(|val| map.insert("payment_methods".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.resources_selected_wizard
    ///
    /// Recorded when the user selects resources from the browser / profile to import. This event was generated to correspond to the Legacy Telemetry event browser.migration.resources_selected#wizard.
    pub static resources_selected_wizard: Lazy<EventMetric<ResourcesSelectedWizardExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "resources_selected_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(454), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.safari_password_file_wizard
    ///
    /// Recorded if the user is on macOS, chose to migrate from Safari, and was presented with the page of the wizard requesting to import passwords from a file. This only gets recorded in the new migration wizard. This event was generated to correspond to the Legacy Telemetry event browser.migration.safari_password_file#wizard.
    pub static safari_password_file_wizard: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "safari_password_file_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(455), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.safari_perms_wizard
    ///
    /// Recorded if the user is on macOS, chose to migrate from Safari, and was presented with the page of the wizard requesting permission to read from the Safari profile folder. This event was generated to correspond to the Legacy Telemetry event browser.migration.safari_perms#wizard.
    pub static safari_perms_wizard: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "safari_perms_wizard".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(456), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.source_browser
    ///
    /// The browser that data is pulled from. The values correspond to the internal browser ID (see MigrationUtils.sys.mjs)
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_MIGRATION_SOURCE_BROWSER.
    pub static source_browser: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "source_browser".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(457), meta, 0, 15, 16, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.unmatched_extensions
    ///
    /// Records a list of the Chrome extension IDs that were unsuccessfully matched to Firefox equivalents from the list downloaded from AMO.
    pub static unmatched_extensions: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "unmatched_extensions".into(),
                category: "browser.migration".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(458), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.migration.usage
    ///
    /// Usage of migration for each datatype when migration is run through the post-firstrun flow which allows individual datatypes, keyed by the string description of the browser.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_MIGRATION_USAGE.
    pub static usage: Lazy<LabeledMetric<LabeledCustomDistributionMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::CustomDistribution {
                cmd: CommonMetricData {
                    name: "usage".into(),
                    category: "browser.migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                }, range_min: 0, range_max: 12, bucket_count: 13, histogram_type: HistogramType::Linear};
        LabeledMetric::new(MetricId(459), meta, None)
    });

}
pub mod migration {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from migration.discovered_migrators
    ///
    /// A keyed uint recording how many times the migration wizard detected a browser / profile pair for a particular browser. This is incremented every time the discovery occurs, so multiple openings of the wizard will increase the counts each time. This metric was generated to correspond to the Legacy Telemetry scalar migration.discovered_migrators.
    pub static discovered_migrators: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "discovered_migrators".into(),
                    category: "migration".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(460), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from migration.time_to_produce_migrator_list
    ///
    /// The amount of time it took in milliseconds to produce the list of migrators and profiles for the first time the migration wizard opened during the process lifetime. This metric was generated to correspond to the Legacy Telemetry scalar migration.time_to_produce_migrator_list.
    pub static time_to_produce_migrator_list: Lazy<TimespanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "time_to_produce_migrator_list".into(),
                category: "migration".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimespanMetric::new(MetricId(461), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from migration.uninstaller_profile_refresh
    ///
    /// Set when a profile refresh is initiated from the uninstaller. This metric was generated to correspond to the Legacy Telemetry scalar migration.uninstaller_profile_refresh.
    pub static uninstaller_profile_refresh: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "uninstaller_profile_refresh".into(),
                category: "migration".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(462), meta)
    });

}
pub mod activity_stream {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EndSessionExtra {
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<u32>,
    }

    impl ExtraKeys for EndSessionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.end_session
    ///
    /// This is recorded with every session ended in Activity Stream. This event was generated to correspond to the Legacy Telemetry event activity_stream.end#session.
    pub static end_session: Lazy<EventMetric<EndSessionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "end_session".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(463), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventArchiveFromPocketExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventArchiveFromPocketExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_archive_from_pocket
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#ARCHIVE_FROM_POCKET.
    pub static event_archive_from_pocket: Lazy<EventMetric<EventArchiveFromPocketExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_archive_from_pocket".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(464), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventBlockExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventBlockExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_block
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#BLOCK.
    pub static event_block: Lazy<EventMetric<EventBlockExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_block".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(465), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventBookmarkAddExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventBookmarkAddExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_bookmark_add
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#BOOKMARK_ADD.
    pub static event_bookmark_add: Lazy<EventMetric<EventBookmarkAddExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_bookmark_add".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(466), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventBookmarkDeleteExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventBookmarkDeleteExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_bookmark_delete
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#BOOKMARK_DELETE.
    pub static event_bookmark_delete: Lazy<EventMetric<EventBookmarkDeleteExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_bookmark_delete".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(467), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventClickExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_click
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#CLICK.
    pub static event_click: Lazy<EventMetric<EventClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_click".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(468), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventClickPrivacyInfoExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventClickPrivacyInfoExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_click_privacy_info
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#CLICK_PRIVACY_INFO.
    pub static event_click_privacy_info: Lazy<EventMetric<EventClickPrivacyInfoExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_click_privacy_info".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(469), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventCloseNewtabPrefsExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventCloseNewtabPrefsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_close_newtab_prefs
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#CLOSE_NEWTAB_PREFS.
    pub static event_close_newtab_prefs: Lazy<EventMetric<EventCloseNewtabPrefsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_close_newtab_prefs".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(470), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDeleteExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDeleteExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_delete
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DELETE.
    pub static event_delete: Lazy<EventMetric<EventDeleteExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_delete".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(471), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDeleteConfirmExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDeleteConfirmExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_delete_confirm
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DELETE_CONFIRM.
    pub static event_delete_confirm: Lazy<EventMetric<EventDeleteConfirmExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_delete_confirm".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(472), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDeleteFromPocketExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDeleteFromPocketExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_delete_from_pocket
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DELETE_FROM_POCKET.
    pub static event_delete_from_pocket: Lazy<EventMetric<EventDeleteFromPocketExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_delete_from_pocket".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(473), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDialogCancelExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDialogCancelExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_dialog_cancel
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DIALOG_CANCEL.
    pub static event_dialog_cancel: Lazy<EventMetric<EventDialogCancelExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_dialog_cancel".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(474), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDialogOpenExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDialogOpenExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_dialog_open
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DIALOG_OPEN.
    pub static event_dialog_open: Lazy<EventMetric<EventDialogOpenExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_dialog_open".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(475), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDisclaimerAckedExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDisclaimerAckedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_disclaimer_acked
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DISCLAIMER_ACKED.
    pub static event_disclaimer_acked: Lazy<EventMetric<EventDisclaimerAckedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_disclaimer_acked".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(476), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDragExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDragExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_drag
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DRAG.
    pub static event_drag: Lazy<EventMetric<EventDragExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_drag".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(477), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventDropExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventDropExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_drop
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DROP.
    pub static event_drop: Lazy<EventMetric<EventDropExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_drop".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(478), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventFakespotCategoryExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventFakespotCategoryExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_fakespot_category
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#FAKESPOT_CATEGORY.
    pub static event_fakespot_category: Lazy<EventMetric<EventFakespotCategoryExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_fakespot_category".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(479), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventFakespotClickExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventFakespotClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_fakespot_click
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#FAKESPOT_CLICK.
    pub static event_fakespot_click: Lazy<EventMetric<EventFakespotClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_fakespot_click".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(480), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventHidePersonalizeExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventHidePersonalizeExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_hide_personalize
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#HIDE_PERSONALIZE.
    pub static event_hide_personalize: Lazy<EventMetric<EventHidePersonalizeExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_hide_personalize".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(481), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventImpressionExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_impression
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#IMPRESSION.
    pub static event_impression: Lazy<EventMetric<EventImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_impression".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(482), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuAddSearchExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuAddSearchExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_add_search
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_ADD_SEARCH.
    pub static event_menu_add_search: Lazy<EventMetric<EventMenuAddSearchExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_add_search".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(483), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuAddTopsiteExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuAddTopsiteExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_add_topsite
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_ADD_TOPSITE.
    pub static event_menu_add_topsite: Lazy<EventMetric<EventMenuAddTopsiteExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_add_topsite".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(484), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuCollapseExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuCollapseExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_collapse
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_COLLAPSE.
    pub static event_menu_collapse: Lazy<EventMetric<EventMenuCollapseExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_collapse".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(485), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuExpandExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuExpandExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_expand
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_EXPAND.
    pub static event_menu_expand: Lazy<EventMetric<EventMenuExpandExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_expand".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(486), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuManageExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuManageExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_manage
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_MANAGE.
    pub static event_menu_manage: Lazy<EventMetric<EventMenuManageExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_manage".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(487), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuMoveDownExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuMoveDownExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_move_down
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_MOVE_DOWN.
    pub static event_menu_move_down: Lazy<EventMetric<EventMenuMoveDownExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_move_down".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(488), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuMoveUpExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuMoveUpExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_move_up
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_MOVE_UP.
    pub static event_menu_move_up: Lazy<EventMetric<EventMenuMoveUpExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_move_up".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(489), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuPrivacyNoticeExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuPrivacyNoticeExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_privacy_notice
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_PRIVACY_NOTICE.
    pub static event_menu_privacy_notice: Lazy<EventMetric<EventMenuPrivacyNoticeExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_privacy_notice".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(490), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMenuRemoveExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMenuRemoveExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_menu_remove
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_REMOVE.
    pub static event_menu_remove: Lazy<EventMetric<EventMenuRemoveExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_menu_remove".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(491), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMigrationCancelExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMigrationCancelExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_migration_cancel
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MIGRATION_CANCEL.
    pub static event_migration_cancel: Lazy<EventMetric<EventMigrationCancelExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_migration_cancel".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(492), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventMigrationStartExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventMigrationStartExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_migration_start
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MIGRATION_START.
    pub static event_migration_start: Lazy<EventMetric<EventMigrationStartExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_migration_start".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(493), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventOpenNewWindowExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventOpenNewWindowExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_open_new_window
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#OPEN_NEW_WINDOW.
    pub static event_open_new_window: Lazy<EventMetric<EventOpenNewWindowExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_open_new_window".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(494), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventOpenNewtabPrefsExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventOpenNewtabPrefsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_open_newtab_prefs
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#OPEN_NEWTAB_PREFS.
    pub static event_open_newtab_prefs: Lazy<EventMetric<EventOpenNewtabPrefsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_open_newtab_prefs".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(495), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventOpenPrivateWindowExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventOpenPrivateWindowExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_open_private_window
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#OPEN_PRIVATE_WINDOW.
    pub static event_open_private_window: Lazy<EventMetric<EventOpenPrivateWindowExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_open_private_window".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(496), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventPinExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventPinExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_pin
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#PIN.
    pub static event_pin: Lazy<EventMetric<EventPinExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_pin".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(497), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventPocketThumbsDownExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventPocketThumbsDownExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_pocket_thumbs_down
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#POCKET_THUMBS_DOWN.
    pub static event_pocket_thumbs_down: Lazy<EventMetric<EventPocketThumbsDownExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_pocket_thumbs_down".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(498), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventPocketThumbsUpExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventPocketThumbsUpExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_pocket_thumbs_up
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#POCKET_THUMBS_UP.
    pub static event_pocket_thumbs_up: Lazy<EventMetric<EventPocketThumbsUpExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_pocket_thumbs_up".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(499), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventPrefChangedExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventPrefChangedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_pref_changed
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#PREF_CHANGED.
    pub static event_pref_changed: Lazy<EventMetric<EventPrefChangedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_pref_changed".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(500), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventPreviewRequestExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventPreviewRequestExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_preview_request
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#PREVIEW_REQUEST.
    pub static event_preview_request: Lazy<EventMetric<EventPreviewRequestExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_preview_request".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(501), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSaveToPocketExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSaveToPocketExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_save_to_pocket
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SAVE_TO_POCKET.
    pub static event_save_to_pocket: Lazy<EventMetric<EventSaveToPocketExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_save_to_pocket".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(502), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSearchExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSearchExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_search
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH.
    pub static event_search: Lazy<EventMetric<EventSearchExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_search".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(503), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSearchEditAddExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSearchEditAddExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_search_edit_add
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_EDIT_ADD.
    pub static event_search_edit_add: Lazy<EventMetric<EventSearchEditAddExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_search_edit_add".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(504), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSearchEditCloseExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSearchEditCloseExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_search_edit_close
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_EDIT_CLOSE.
    pub static event_search_edit_close: Lazy<EventMetric<EventSearchEditCloseExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_search_edit_close".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(505), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSearchEditDeleteExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSearchEditDeleteExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_search_edit_delete
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_EDIT_DELETE.
    pub static event_search_edit_delete: Lazy<EventMetric<EventSearchEditDeleteExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_search_edit_delete".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(506), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSearchHandoffExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSearchHandoffExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_search_handoff
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_HANDOFF.
    pub static event_search_handoff: Lazy<EventMetric<EventSearchHandoffExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_search_handoff".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(507), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventShowPersonalizeExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventShowPersonalizeExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_show_personalize
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SHOW_PERSONALIZE.
    pub static event_show_personalize: Lazy<EventMetric<EventShowPersonalizeExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_show_personalize".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(508), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventShowPrivacyInfoExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventShowPrivacyInfoExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_show_privacy_info
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SHOW_PRIVACY_INFO.
    pub static event_show_privacy_info: Lazy<EventMetric<EventShowPrivacyInfoExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_show_privacy_info".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(509), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSkippedSigninExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSkippedSigninExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_skipped_signin
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SKIPPED_SIGNIN.
    pub static event_skipped_signin: Lazy<EventMetric<EventSkippedSigninExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_skipped_signin".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(510), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventSubmitEmailExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventSubmitEmailExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_submit_email
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SUBMIT_EMAIL.
    pub static event_submit_email: Lazy<EventMetric<EventSubmitEmailExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_submit_email".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(511), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventTopSitesEditExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventTopSitesEditExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_top_sites_edit
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#TOP_SITES_EDIT.
    pub static event_top_sites_edit: Lazy<EventMetric<EventTopSitesEditExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_top_sites_edit".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(512), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventTopSitesEditCloseExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventTopSitesEditCloseExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_top_sites_edit_close
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#TOP_SITES_EDIT_CLOSE.
    pub static event_top_sites_edit_close: Lazy<EventMetric<EventTopSitesEditCloseExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_top_sites_edit_close".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(513), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventTopsiteSponsorInfoExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventTopsiteSponsorInfoExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_topsite_sponsor_info
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#TOPSITE_SPONSOR_INFO.
    pub static event_topsite_sponsor_info: Lazy<EventMetric<EventTopsiteSponsorInfoExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_topsite_sponsor_info".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(514), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EventUnpinExtra {
        pub r#action_position: Option<u32>,
        pub r#addon_version: Option<String>,
        pub r#page: Option<String>,
        pub r#session_id: Option<String>,
        pub r#user_prefs: Option<u32>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for EventUnpinExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action_position", "addon_version", "page", "session_id", "user_prefs", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action_position.and_then(|val| map.insert("action_position".into(), val.to_string()));
          self.r#addon_version.and_then(|val| map.insert("addon_version".into(), val.to_string()));
          self.r#page.and_then(|val| map.insert("page".into(), val.to_string()));
          self.r#session_id.and_then(|val| map.insert("session_id".into(), val.to_string()));
          self.r#user_prefs.and_then(|val| map.insert("user_prefs".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from activity_stream.event_unpin
    ///
    /// This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#UNPIN.
    pub static event_unpin: Lazy<EventMetric<EventUnpinExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_unpin".into(),
                category: "activity_stream".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(515), meta)
    });

}
pub mod contextual_services_topsites {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from contextual.services.topsites.click
    ///
    /// A keyed uint recording how many times the user has clicked on the sponsored TopSites on the newtab page. The key is a combination of the source and the placement of the TopSites tile (1-based). such as 'urlbar_1', 'newtab_2'. This metric was generated to correspond to the Legacy Telemetry scalar contextual.services.topsites.click.
    pub static click: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "click".into(),
                    category: "contextual.services.topsites".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(516), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from contextual.services.topsites.impression
    ///
    /// A keyed uint recording how many times the user has viewed the sponsored TopSites on the newtab page. The key is a combination of the source and the placement of the TopSites tile (1-based). such as 'urlbar_1', 'newtab_2'. This metric was generated to correspond to the Legacy Telemetry scalar contextual.services.topsites.impression.
    pub static impression: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "impression".into(),
                    category: "contextual.services.topsites".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(517), meta, None)
    });

}
pub mod deletion_request {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from deletion.request.context_id
    ///
    /// An identifier to identify users for Contextual Services user interaction pings. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.context_id.
    pub static context_id: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "context_id".into(),
                category: "deletion.request".into(),
                send_in_pings: vec!["deletion-request".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(518), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from deletion.request.impression_id
    ///
    /// An identifier used by user interaction pings in Pocket/newtab and Messaging System. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.impression_id.
    pub static impression_id: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression_id".into(),
                category: "deletion.request".into(),
                send_in_pings: vec!["deletion-request".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(519), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from deletion.request.sync_device_id
    ///
    /// An identifier used by sync ping, to identify the current Firefox profile for a specific Account. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.sync_device_id.
    pub static sync_device_id: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sync_device_id".into(),
                category: "deletion.request".into(),
                send_in_pings: vec!["deletion-request".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(520), meta)
    });

}
pub mod newtab {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from newtab.abouthome_cache_construction
    ///
    /// The length of time (in milliseconds) that it takes for the cache worker to generate the cache and return it to the main thread
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_ABOUTHOME_CACHE_CONSTRUCTION.
    pub static abouthome_cache_construction: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "abouthome_cache_construction".into(),
                category: "newtab".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(521), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.blocked_sponsors
    ///
    /// The advertiser names that have been dismissed by the user.
    pub static blocked_sponsors: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "blocked_sponsors".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(522), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClosedExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for ClosedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.closed
    ///
    /// Recorded when newtab UI is closed by * navigation * closing the tab
    /// Doesn't mean that the newtab was ever visible to a user.
    pub static closed: Lazy<EventMetric<ClosedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "closed".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(523), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FakespotAboutClickExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for FakespotAboutClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.fakespot_about_click
    ///
    /// Recorded when a user the 'About Fakespot' link in TBR fakespot feed context menu
    pub static fakespot_about_click: Lazy<EventMetric<FakespotAboutClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fakespot_about_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(524), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FakespotCategoryExtra {
        pub r#category: Option<String>,
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for FakespotCategoryExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.fakespot_category
    ///
    /// Recorded when a user changes the category in TBR fakespot feed
    pub static fakespot_category: Lazy<EventMetric<FakespotCategoryExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fakespot_category".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(525), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FakespotClickExtra {
        pub r#category: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#product_id: Option<String>,
    }

    impl ExtraKeys for FakespotClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "newtab_visit_id", "product_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#product_id.and_then(|val| map.insert("product_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.fakespot_click
    ///
    /// Recorded when a user clicks on a card in TBR fakespot feed
    pub static fakespot_click: Lazy<EventMetric<FakespotClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fakespot_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(526), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FakespotCtaClickExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for FakespotCtaClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.fakespot_cta_click
    ///
    /// Recorded when a user clicks on the CTA in TBR fakespot feed
    pub static fakespot_cta_click: Lazy<EventMetric<FakespotCtaClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fakespot_cta_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(527), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FakespotDismissExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for FakespotDismissExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.fakespot_dismiss
    ///
    /// Recorded when a user dissmisses TBR fakespot feed
    pub static fakespot_dismiss: Lazy<EventMetric<FakespotDismissExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fakespot_dismiss".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(528), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct FakespotProductImpressionExtra {
        pub r#category: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#product_id: Option<String>,
        pub r#product_title: Option<String>,
    }

    impl ExtraKeys for FakespotProductImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "newtab_visit_id", "product_id", "product_title"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#product_id.and_then(|val| map.insert("product_id".into(), val.to_string()));
          self.r#product_title.and_then(|val| map.insert("product_title".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.fakespot_product_impression
    ///
    /// Recorded when a user triggers an impression on a card in TBR fakespot feed
    pub static fakespot_product_impression: Lazy<EventMetric<FakespotProductImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fakespot_product_impression".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(529), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.homepage_category
    ///
    /// The current setting of the home page. One of ["enabled", "disabled", "extension"] or any value from SiteClassifier like "known-hijacker" or "social-media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's `home_url_category`. Sampled once after newtab init.
    pub static homepage_category: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "homepage_category".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(530), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct InlineSelectionClickExtra {
        pub r#is_followed: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#section_position: Option<String>,
        pub r#topic: Option<String>,
        pub r#topic_position: Option<String>,
    }

    impl ExtraKeys for InlineSelectionClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["is_followed", "newtab_visit_id", "section_position", "topic", "topic_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#is_followed.and_then(|val| map.insert("is_followed".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          self.r#topic.and_then(|val| map.insert("topic".into(), val.to_string()));
          self.r#topic_position.and_then(|val| map.insert("topic_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.inline_selection_click
    ///
    /// Recorded when there is a click on the inline selection component
    pub static inline_selection_click: Lazy<EventMetric<InlineSelectionClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "inline_selection_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(531), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct InlineSelectionImpressionExtra {
        pub r#newtab_visit_id: Option<String>,
        pub r#section_position: Option<String>,
    }

    impl ExtraKeys for InlineSelectionImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id", "section_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.inline_selection_impression
    ///
    /// Recorded when there is an impression on the inline selection component
    pub static inline_selection_impression: Lazy<EventMetric<InlineSelectionImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "inline_selection_impression".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(532), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.locale
    ///
    /// The application's locale as of when newtab's TelemetryFeed was init. Comes from `Services.local.appLocaleAsBCP47`. Looks like `en-US`.
    pub static locale: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "locale".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(533), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.newtab_category
    ///
    /// The current setting of the newtab page. One of ["enabled", "disabled", "extension"] or any value from SiteClassifier like "known-hijacker" or "social-media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's `newtab_url_category`. Sampled once after newtab init.
    pub static newtab_category: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "newtab_category".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(534), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct OpenedExtra {
        pub r#newtab_visit_id: Option<String>,
        pub r#source: Option<String>,
        pub r#window_inner_height: Option<String>,
        pub r#window_inner_width: Option<String>,
    }

    impl ExtraKeys for OpenedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id", "source", "window_inner_height", "window_inner_width"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#source.and_then(|val| map.insert("source".into(), val.to_string()));
          self.r#window_inner_height.and_then(|val| map.insert("window_inner_height".into(), val.to_string()));
          self.r#window_inner_width.and_then(|val| map.insert("window_inner_width".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.opened
    ///
    /// Recorded when newtab UI is opened via `about:newtab` or `about:home` or `about:welcome` and has been made visible (see `visibility_event_rcvd_ts` in [detect-user-session-start.js](https://searchfox.org/mozilla-central/source/browser/components/newtab/content-src/lib/detect-user-session-start.js)).
    pub static opened: Lazy<EventMetric<OpenedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "opened".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(535), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SectionsBlockSectionExtra {
        pub r#event_source: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
    }

    impl ExtraKeys for SectionsBlockSectionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["event_source", "newtab_visit_id", "section", "section_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#event_source.and_then(|val| map.insert("event_source".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.sections_block_section
    ///
    /// Recorded when a section is blocked
    pub static sections_block_section: Lazy<EventMetric<SectionsBlockSectionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sections_block_section".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(536), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SectionsFollowSectionExtra {
        pub r#event_source: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
    }

    impl ExtraKeys for SectionsFollowSectionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["event_source", "newtab_visit_id", "section", "section_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#event_source.and_then(|val| map.insert("event_source".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.sections_follow_section
    ///
    /// Recorded when a section is followed
    pub static sections_follow_section: Lazy<EventMetric<SectionsFollowSectionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sections_follow_section".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(537), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SectionsImpressionExtra {
        pub r#is_secton_followed: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
    }

    impl ExtraKeys for SectionsImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["is_secton_followed", "newtab_visit_id", "section", "section_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#is_secton_followed.and_then(|val| map.insert("is_secton_followed".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.sections_impression
    ///
    /// Recorded when a section is viewport and triggers an impression event
    pub static sections_impression: Lazy<EventMetric<SectionsImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sections_impression".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(538), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SectionsUnblockSectionExtra {
        pub r#event_source: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
    }

    impl ExtraKeys for SectionsUnblockSectionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["event_source", "newtab_visit_id", "section", "section_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#event_source.and_then(|val| map.insert("event_source".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.sections_unblock_section
    ///
    /// Recorded when a section is unblocked
    pub static sections_unblock_section: Lazy<EventMetric<SectionsUnblockSectionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sections_unblock_section".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(539), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SectionsUnfollowSectionExtra {
        pub r#event_source: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
    }

    impl ExtraKeys for SectionsUnfollowSectionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["event_source", "newtab_visit_id", "section", "section_position"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#event_source.and_then(|val| map.insert("event_source".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.sections_unfollow_section
    ///
    /// Recorded when a section is unfollowed
    pub static sections_unfollow_section: Lazy<EventMetric<SectionsUnfollowSectionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sections_unfollow_section".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(540), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.selected_topics
    ///
    /// The list of topics the user selected
    pub static selected_topics: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "selected_topics".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(541), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.sov_allocation
    ///
    /// The partner group assignment for sov
    pub static sov_allocation: Lazy<StringListMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sov_allocation".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        StringListMetric::new(MetricId(542), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TooltipClickExtra {
        pub r#feature: Option<String>,
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for TooltipClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["feature", "newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#feature.and_then(|val| map.insert("feature".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.tooltip_click
    ///
    /// Recorded when a feature highlight tooltip is opened.
    pub static tooltip_click: Lazy<EventMetric<TooltipClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "tooltip_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(543), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TopicSelectionDismissExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for TopicSelectionDismissExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.topic_selection_dismiss
    ///
    /// Recorded when the topic selection modal is dismissed (topics are not saved)
    pub static topic_selection_dismiss: Lazy<EventMetric<TopicSelectionDismissExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "topic_selection_dismiss".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(544), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TopicSelectionOpenExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for TopicSelectionOpenExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.topic_selection_open
    ///
    /// Recorded when the topic selection modal is opened
    pub static topic_selection_open: Lazy<EventMetric<TopicSelectionOpenExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "topic_selection_open".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(545), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TopicSelectionTopicsSavedExtra {
        pub r#first_save: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#previous_topics: Option<String>,
        pub r#topics: Option<String>,
    }

    impl ExtraKeys for TopicSelectionTopicsSavedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["first_save", "newtab_visit_id", "previous_topics", "topics"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#first_save.and_then(|val| map.insert("first_save".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#previous_topics.and_then(|val| map.insert("previous_topics".into(), val.to_string()));
          self.r#topics.and_then(|val| map.insert("topics".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.topic_selection_topics_saved
    ///
    /// Recorded when topics are saved from the topics selection modal
    pub static topic_selection_topics_saved: Lazy<EventMetric<TopicSelectionTopicsSavedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "topic_selection_topics_saved".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(546), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WallpaperCategoryClickExtra {
        pub r#newtab_visit_id: Option<String>,
        pub r#selected_category: Option<String>,
    }

    impl ExtraKeys for WallpaperCategoryClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id", "selected_category"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#selected_category.and_then(|val| map.insert("selected_category".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.wallpaper_category_click
    ///
    /// Recorded when a user clicks a wallpaper category option
    pub static wallpaper_category_click: Lazy<EventMetric<WallpaperCategoryClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "wallpaper_category_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(547), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WallpaperClickExtra {
        pub r#had_previous_wallpaper: Option<bool>,
        pub r#had_uploaded_previously: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#selected_wallpaper: Option<String>,
    }

    impl ExtraKeys for WallpaperClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["had_previous_wallpaper", "had_uploaded_previously", "newtab_visit_id", "selected_wallpaper"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#had_previous_wallpaper.and_then(|val| map.insert("had_previous_wallpaper".into(), val.to_string()));
          self.r#had_uploaded_previously.and_then(|val| map.insert("had_uploaded_previously".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#selected_wallpaper.and_then(|val| map.insert("selected_wallpaper".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.wallpaper_click
    ///
    /// Recorded when a user clicks on a wallpaper option
    pub static wallpaper_click: Lazy<EventMetric<WallpaperClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "wallpaper_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(548), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WallpaperHighlightCtaClickExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for WallpaperHighlightCtaClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.wallpaper_highlight_cta_click
    ///
    /// Recorded when a user clicks the CTA on the wallpaper feature highlight
    pub static wallpaper_highlight_cta_click: Lazy<EventMetric<WallpaperHighlightCtaClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "wallpaper_highlight_cta_click".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(549), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WallpaperHighlightDismissedExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for WallpaperHighlightDismissedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.wallpaper_highlight_dismissed
    ///
    /// Recorded when a user dismisses the wallpaper feature highlight
    pub static wallpaper_highlight_dismissed: Lazy<EventMetric<WallpaperHighlightDismissedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "wallpaper_highlight_dismissed".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(550), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WeatherChangeDisplayExtra {
        pub r#newtab_visit_id: Option<String>,
        pub r#weather_display_mode: Option<String>,
    }

    impl ExtraKeys for WeatherChangeDisplayExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id", "weather_display_mode"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#weather_display_mode.and_then(|val| map.insert("weather_display_mode".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.weather_change_display
    ///
    /// Recorded when a user changes the weather display.
    pub static weather_change_display: Lazy<EventMetric<WeatherChangeDisplayExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "weather_change_display".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(551), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from newtab.weather_enabled
    ///
    /// Whether the weather widget is enabled on the newtab. Corresponds to the value of the `browser.newtabpage.activity-stream.showWeather` pref.
    pub static weather_enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "weather_enabled".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(552), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WeatherImpressionExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for WeatherImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.weather_impression
    ///
    /// Recorded when the weather widget is viewed
    pub static weather_impression: Lazy<EventMetric<WeatherImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "weather_impression".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(553), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WeatherLoadErrorExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for WeatherLoadErrorExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.weather_load_error
    ///
    /// Recorded when the weather widget is not available
    pub static weather_load_error: Lazy<EventMetric<WeatherLoadErrorExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "weather_load_error".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(554), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WeatherLocationSelectedExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for WeatherLocationSelectedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.weather_location_selected
    ///
    /// Recorded when a user selects a location for weather widget
    pub static weather_location_selected: Lazy<EventMetric<WeatherLocationSelectedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "weather_location_selected".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(555), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct WeatherOpenProviderUrlExtra {
        pub r#newtab_visit_id: Option<String>,
    }

    impl ExtraKeys for WeatherOpenProviderUrlExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.weather_open_provider_url
    ///
    /// Recorded when a user opens a link to the Weather provider website.
    pub static weather_open_provider_url: Lazy<EventMetric<WeatherOpenProviderUrlExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "weather_open_provider_url".into(),
                category: "newtab".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(556), meta)
    });

}
pub mod newtab_handoff_preference {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from newtab.handoff_preference.enabled
    ///
    /// Records whether the browser.newtabpage.activity-stream.improvesearch.handoffToAwesomebar preference is enabled or disabled
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "newtab.handoff_preference".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(557), meta)
    });

}
pub mod newtab_search {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from newtab.search.enabled
    ///
    /// Whether the search input is enabled on the newtab. Corresponds to the value of the `browser.newtabpage.activity-stream.showSearch` pref.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "newtab.search".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(558), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct IssuedExtra {
        pub r#newtab_visit_id: Option<String>,
        pub r#search_access_point: Option<String>,
        pub r#telemetry_id: Option<String>,
    }

    impl ExtraKeys for IssuedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id", "search_access_point", "telemetry_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#search_access_point.and_then(|val| map.insert("search_access_point".into(), val.to_string()));
          self.r#telemetry_id.and_then(|val| map.insert("telemetry_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.search.issued
    ///
    /// When Firefox was asked to issue a search from a Search Access Point (SAP) on a newtab page. Doesn't record searches in Private Browsing Mode unless `browser.engagement.search_counts.pbm` is set to `true`.
    pub static issued: Lazy<EventMetric<IssuedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "issued".into(),
                category: "newtab.search".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(559), meta)
    });

}
pub mod pocket {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickExtra {
        pub r#corpus_item_id: Option<String>,
        pub r#format: Option<String>,
        pub r#is_list_card: Option<bool>,
        pub r#is_secton_followed: Option<bool>,
        pub r#is_sponsored: Option<bool>,
        pub r#matches_selected_topic: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#received_rank: Option<u32>,
        pub r#recommendation_id: Option<String>,
        pub r#recommended_at: Option<u32>,
        pub r#scheduled_corpus_item_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
        pub r#selected_topics: Option<String>,
        pub r#tile_id: Option<u32>,
        pub r#topic: Option<String>,
    }

    impl ExtraKeys for ClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["corpus_item_id", "format", "is_list_card", "is_secton_followed", "is_sponsored", "matches_selected_topic", "newtab_visit_id", "position", "received_rank", "recommendation_id", "recommended_at", "scheduled_corpus_item_id", "section", "section_position", "selected_topics", "tile_id", "topic"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#corpus_item_id.and_then(|val| map.insert("corpus_item_id".into(), val.to_string()));
          self.r#format.and_then(|val| map.insert("format".into(), val.to_string()));
          self.r#is_list_card.and_then(|val| map.insert("is_list_card".into(), val.to_string()));
          self.r#is_secton_followed.and_then(|val| map.insert("is_secton_followed".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#matches_selected_topic.and_then(|val| map.insert("matches_selected_topic".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#received_rank.and_then(|val| map.insert("received_rank".into(), val.to_string()));
          self.r#recommendation_id.and_then(|val| map.insert("recommendation_id".into(), val.to_string()));
          self.r#recommended_at.and_then(|val| map.insert("recommended_at".into(), val.to_string()));
          self.r#scheduled_corpus_item_id.and_then(|val| map.insert("scheduled_corpus_item_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          self.r#selected_topics.and_then(|val| map.insert("selected_topics".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          self.r#topic.and_then(|val| map.insert("topic".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from pocket.click
    ///
    /// Recorded when a pocket tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
    pub static click: Lazy<EventMetric<ClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(560), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct DismissExtra {
        pub r#corpus_item_id: Option<String>,
        pub r#format: Option<String>,
        pub r#is_list_card: Option<bool>,
        pub r#is_secton_followed: Option<bool>,
        pub r#is_sponsored: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#received_rank: Option<u32>,
        pub r#recommendation_id: Option<String>,
        pub r#recommended_at: Option<u32>,
        pub r#scheduled_corpus_item_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
        pub r#tile_id: Option<u32>,
    }

    impl ExtraKeys for DismissExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["corpus_item_id", "format", "is_list_card", "is_secton_followed", "is_sponsored", "newtab_visit_id", "position", "received_rank", "recommendation_id", "recommended_at", "scheduled_corpus_item_id", "section", "section_position", "tile_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#corpus_item_id.and_then(|val| map.insert("corpus_item_id".into(), val.to_string()));
          self.r#format.and_then(|val| map.insert("format".into(), val.to_string()));
          self.r#is_list_card.and_then(|val| map.insert("is_list_card".into(), val.to_string()));
          self.r#is_secton_followed.and_then(|val| map.insert("is_secton_followed".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#received_rank.and_then(|val| map.insert("received_rank".into(), val.to_string()));
          self.r#recommendation_id.and_then(|val| map.insert("recommendation_id".into(), val.to_string()));
          self.r#recommended_at.and_then(|val| map.insert("recommended_at".into(), val.to_string()));
          self.r#scheduled_corpus_item_id.and_then(|val| map.insert("scheduled_corpus_item_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from pocket.dismiss
    ///
    /// Recorded when a pocket tile is dismissed.
    pub static dismiss: Lazy<EventMetric<DismissExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dismiss".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(561), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.enabled
    ///
    /// Whether Pocket is enabled on the newtab. AKA the "Recommended by Pocket" section. Corresponds to the value of the `browser.newtabpage.activity-stream.feeds.section.topstories` pref.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(562), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.fetch_timestamp
    ///
    /// Timestamp of when the spoc was fetched by the client
    pub static fetch_timestamp: Lazy<DatetimeMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "fetch_timestamp".into(),
                category: "pocket".into(),
                send_in_pings: vec!["spoc".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        DatetimeMetric::new(MetricId(563), meta, TimeUnit::Millisecond)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ImpressionExtra {
        pub r#corpus_item_id: Option<String>,
        pub r#format: Option<String>,
        pub r#is_list_card: Option<bool>,
        pub r#is_secton_followed: Option<bool>,
        pub r#is_sponsored: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#received_rank: Option<u32>,
        pub r#recommendation_id: Option<String>,
        pub r#recommended_at: Option<u32>,
        pub r#scheduled_corpus_item_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
        pub r#selected_topics: Option<String>,
        pub r#tile_id: Option<u32>,
        pub r#topic: Option<String>,
    }

    impl ExtraKeys for ImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["corpus_item_id", "format", "is_list_card", "is_secton_followed", "is_sponsored", "newtab_visit_id", "position", "received_rank", "recommendation_id", "recommended_at", "scheduled_corpus_item_id", "section", "section_position", "selected_topics", "tile_id", "topic"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#corpus_item_id.and_then(|val| map.insert("corpus_item_id".into(), val.to_string()));
          self.r#format.and_then(|val| map.insert("format".into(), val.to_string()));
          self.r#is_list_card.and_then(|val| map.insert("is_list_card".into(), val.to_string()));
          self.r#is_secton_followed.and_then(|val| map.insert("is_secton_followed".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#received_rank.and_then(|val| map.insert("received_rank".into(), val.to_string()));
          self.r#recommendation_id.and_then(|val| map.insert("recommendation_id".into(), val.to_string()));
          self.r#recommended_at.and_then(|val| map.insert("recommended_at".into(), val.to_string()));
          self.r#scheduled_corpus_item_id.and_then(|val| map.insert("scheduled_corpus_item_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          self.r#selected_topics.and_then(|val| map.insert("selected_topics".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          self.r#topic.and_then(|val| map.insert("topic".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from pocket.impression
    ///
    /// Recorded when a pocket tile is visible to the user.
    pub static impression: Lazy<EventMetric<ImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(564), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.is_signed_in
    ///
    /// Whether the Firefox user is signed in to Pocket. Does not correspond to a pref, so its value is resampled at newtab's component init and whenever there is a Discovery Stream user event.
    pub static is_signed_in: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "is_signed_in".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(565), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.newtab_creation_timestamp
    ///
    /// Timestamp of when this instance of the newtab was first visible to the user.
    pub static newtab_creation_timestamp: Lazy<DatetimeMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "newtab_creation_timestamp".into(),
                category: "pocket".into(),
                send_in_pings: vec!["spoc".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        DatetimeMetric::new(MetricId(566), meta, TimeUnit::Millisecond)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SaveExtra {
        pub r#corpus_item_id: Option<String>,
        pub r#format: Option<String>,
        pub r#is_list_card: Option<bool>,
        pub r#is_secton_followed: Option<bool>,
        pub r#is_sponsored: Option<bool>,
        pub r#matches_selected_topic: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#received_rank: Option<u32>,
        pub r#recommendation_id: Option<String>,
        pub r#recommended_at: Option<u32>,
        pub r#scheduled_corpus_item_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
        pub r#selected_topics: Option<String>,
        pub r#tile_id: Option<u32>,
        pub r#topic: Option<String>,
    }

    impl ExtraKeys for SaveExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["corpus_item_id", "format", "is_list_card", "is_secton_followed", "is_sponsored", "matches_selected_topic", "newtab_visit_id", "position", "received_rank", "recommendation_id", "recommended_at", "scheduled_corpus_item_id", "section", "section_position", "selected_topics", "tile_id", "topic"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#corpus_item_id.and_then(|val| map.insert("corpus_item_id".into(), val.to_string()));
          self.r#format.and_then(|val| map.insert("format".into(), val.to_string()));
          self.r#is_list_card.and_then(|val| map.insert("is_list_card".into(), val.to_string()));
          self.r#is_secton_followed.and_then(|val| map.insert("is_secton_followed".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#matches_selected_topic.and_then(|val| map.insert("matches_selected_topic".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#received_rank.and_then(|val| map.insert("received_rank".into(), val.to_string()));
          self.r#recommendation_id.and_then(|val| map.insert("recommendation_id".into(), val.to_string()));
          self.r#recommended_at.and_then(|val| map.insert("recommended_at".into(), val.to_string()));
          self.r#scheduled_corpus_item_id.and_then(|val| map.insert("scheduled_corpus_item_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          self.r#selected_topics.and_then(|val| map.insert("selected_topics".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          self.r#topic.and_then(|val| map.insert("topic".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from pocket.save
    ///
    /// Recorded when a user decides to save a pocket tile. Does not mean it ends up successfully saved. Just that the user clicked on "Save to Pocket" in the little pocket tile menu.
    pub static save: Lazy<EventMetric<SaveExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "save".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(567), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.shim
    ///
    /// Opaque partner identifier for a given ad impression or engagement action,
    /// unique per market and region.
    /// Pocket
    /// [proxies requests to ad partners](https://github.com/Pocket/proxy-server/)
    /// and provides them solely with market, region, and action to generate these
    /// shims. Thus, though the contents of this field are obscure, they cannot
    /// identify clients.
    /// At time of writing this information is a comma-separated trio.
    /// The first item is an index into the proxy server's list of acceptable http
    /// endpoints for contacting the ad service. The second item is a
    /// several-hundred-byte base64-encoded JSON-encoded struct with fields for,
    /// amongst other things, market and region. The third is unknown, but appears
    /// to be a signature or checksum.
    /// This shim should not be sent with the client_id.
    pub static shim: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shim".into(),
                category: "pocket".into(),
                send_in_pings: vec!["spoc".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(568), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.sponsored_stories_enabled
    ///
    /// Whether Pocket sponsored stories are enabled on the newtab. Corresponds to the value of the `browser.newtabpage.activity-stream.showSponsored` pref. Can be `true` even if pocket.enabled is `false`.
    pub static sponsored_stories_enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sponsored_stories_enabled".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(569), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ThumbVotingInteractionExtra {
        pub r#corpus_item_id: Option<String>,
        pub r#is_list_card: Option<bool>,
        pub r#is_secton_followed: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#received_rank: Option<u32>,
        pub r#recommendation_id: Option<String>,
        pub r#recommended_at: Option<u32>,
        pub r#scheduled_corpus_item_id: Option<String>,
        pub r#section: Option<String>,
        pub r#section_position: Option<String>,
        pub r#thumbs_down: Option<bool>,
        pub r#thumbs_up: Option<bool>,
        pub r#tile_id: Option<u32>,
        pub r#topic: Option<String>,
    }

    impl ExtraKeys for ThumbVotingInteractionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["corpus_item_id", "is_list_card", "is_secton_followed", "newtab_visit_id", "received_rank", "recommendation_id", "recommended_at", "scheduled_corpus_item_id", "section", "section_position", "thumbs_down", "thumbs_up", "tile_id", "topic"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#corpus_item_id.and_then(|val| map.insert("corpus_item_id".into(), val.to_string()));
          self.r#is_list_card.and_then(|val| map.insert("is_list_card".into(), val.to_string()));
          self.r#is_secton_followed.and_then(|val| map.insert("is_secton_followed".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#received_rank.and_then(|val| map.insert("received_rank".into(), val.to_string()));
          self.r#recommendation_id.and_then(|val| map.insert("recommendation_id".into(), val.to_string()));
          self.r#recommended_at.and_then(|val| map.insert("recommended_at".into(), val.to_string()));
          self.r#scheduled_corpus_item_id.and_then(|val| map.insert("scheduled_corpus_item_id".into(), val.to_string()));
          self.r#section.and_then(|val| map.insert("section".into(), val.to_string()));
          self.r#section_position.and_then(|val| map.insert("section_position".into(), val.to_string()));
          self.r#thumbs_down.and_then(|val| map.insert("thumbs_down".into(), val.to_string()));
          self.r#thumbs_up.and_then(|val| map.insert("thumbs_up".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          self.r#topic.and_then(|val| map.insert("topic".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from pocket.thumb_voting_interaction
    ///
    /// Recorded when a thumbs up/down on a tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
    pub static thumb_voting_interaction: Lazy<EventMetric<ThumbVotingInteractionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "thumb_voting_interaction".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(570), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct TopicClickExtra {
        pub r#newtab_visit_id: Option<String>,
        pub r#topic: Option<String>,
    }

    impl ExtraKeys for TopicClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["newtab_visit_id", "topic"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#topic.and_then(|val| map.insert("topic".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from pocket.topic_click
    ///
    /// Recorded when a pocket "Popular Topic" is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
    pub static topic_click: Lazy<EventMetric<TopicClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "topic_click".into(),
                category: "pocket".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(571), meta)
    });

}
pub mod top_sites {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.advertiser
    ///
    /// The name of the advertiser providing the sponsored TopSite.
    pub static advertiser: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "advertiser".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(572), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.context_id
    ///
    /// An identifier to identify users for Contextual Services user interaction pings.
    pub static context_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "context_id".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(573), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.ping_type
    ///
    /// The ping's type. In other situations might be designated by an event's name or an interaction field. E.g. "topsites-impression", "topsites-click".
    pub static ping_type: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "ping_type".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(574), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.position
    ///
    /// The position (1-based) of the topsites item being interatcted with.
    pub static position: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "position".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(575), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.reporting_url
    ///
    /// The url to report this interaction to.
    pub static reporting_url: Lazy<UrlMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reporting_url".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UrlMetric::new(MetricId(576), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.source
    ///
    /// The source of the interaction. Always set to "newtab".
    pub static source: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "source".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(577), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from top_sites.tile_id
    ///
    /// String-encoded number for the tile's sponsored tile id.
    pub static tile_id: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "tile_id".into(),
                category: "top_sites".into(),
                send_in_pings: vec!["top-sites".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(578), meta)
    });

}
pub mod topsites {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickExtra {
        pub r#advertiser_name: Option<String>,
        pub r#is_sponsored: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#tile_id: Option<u32>,
    }

    impl ExtraKeys for ClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["advertiser_name", "is_sponsored", "newtab_visit_id", "position", "tile_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#advertiser_name.and_then(|val| map.insert("advertiser_name".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from topsites.click
    ///
    /// Recorded when a topsite tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
    pub static click: Lazy<EventMetric<ClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(579), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct DismissExtra {
        pub r#advertiser_name: Option<String>,
        pub r#is_sponsored: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#tile_id: Option<u32>,
    }

    impl ExtraKeys for DismissExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["advertiser_name", "is_sponsored", "newtab_visit_id", "position", "tile_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#advertiser_name.and_then(|val| map.insert("advertiser_name".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from topsites.dismiss
    ///
    /// Recorded when the "Dismiss" menu item in the three-dots menu of a topsite is clicked. Corresponds to the receipt of a dispatched `BLOCK_URL` action by `TelemetryFeed`. Applies to both sponsored and non-sponsored topsites. `advertiser_name` is only provided for sponsored topsites.
    pub static dismiss: Lazy<EventMetric<DismissExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "dismiss".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(580), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from topsites.enabled
    ///
    /// Whether "topsites" is enabled on the newtab. AKA the "Shortcuts" section. Corresponds to the value of the `browser.newtabpage.activity-stream.feeds.topsites` pref.
    pub static enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "enabled".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(581), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ImpressionExtra {
        pub r#advertiser_name: Option<String>,
        pub r#is_sponsored: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#tile_id: Option<u32>,
    }

    impl ExtraKeys for ImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["advertiser_name", "is_sponsored", "newtab_visit_id", "position", "tile_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#advertiser_name.and_then(|val| map.insert("advertiser_name".into(), val.to_string()));
          self.r#is_sponsored.and_then(|val| map.insert("is_sponsored".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from topsites.impression
    ///
    /// Recorded when topsite tiles are loaded.
    pub static impression: Lazy<EventMetric<ImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(582), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct PrefChangedExtra {
        pub r#new_value: Option<bool>,
        pub r#pref_name: Option<String>,
    }

    impl ExtraKeys for PrefChangedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["new_value", "pref_name"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#new_value.and_then(|val| map.insert("new_value".into(), val.to_string()));
          self.r#pref_name.and_then(|val| map.insert("pref_name".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from topsites.pref_changed
    ///
    /// Recorded when specific topsites prefs have changed.
    /// The list of possible prefs is presently:
    ///  * browser.newtabpage.activity-stream.feeds.topsites
    ///  * browser.newtabpage.activity-stream.showSponsoredTopSites
    pub static pref_changed: Lazy<EventMetric<PrefChangedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "pref_changed".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(583), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from topsites.rows
    ///
    /// The number of topsite tile rows configured to be shown on the newtab page. Corresponds to the value of the `browser.newtabpage.activity-stream.topSitesRows` pref. This is not the number of rows actually seen by the user: if the browser window is partially off-screen, or isn't wide enough to accommodate eight tiles per row, the actual number of rows may be different.
    pub static rows: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "rows".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(584), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowPrivacyClickExtra {
        pub r#advertiser_name: Option<String>,
        pub r#newtab_visit_id: Option<String>,
        pub r#position: Option<u32>,
        pub r#tile_id: Option<u32>,
    }

    impl ExtraKeys for ShowPrivacyClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["advertiser_name", "newtab_visit_id", "position", "tile_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#advertiser_name.and_then(|val| map.insert("advertiser_name".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#position.and_then(|val| map.insert("position".into(), val.to_string()));
          self.r#tile_id.and_then(|val| map.insert("tile_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from topsites.show_privacy_click
    ///
    /// Recorded when the "Our Sponsors and Your Privacy" menu item in the three- dots menu of a sponsored topsite is clicked. Corresponds to the receipt of a dispatched `ABOUT_SPONSORED_TOP_SITES` action by `TelemetryFeed`.
    pub static show_privacy_click: Lazy<EventMetric<ShowPrivacyClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_privacy_click".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(585), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from topsites.sponsored_enabled
    ///
    /// Whether sponsored topsites are enabled on the newtab. AKA the "Sponsored Shortcuts" section. Corresponds to the value of the `browser.newtabpage.activity-stream.showSponsoredTopSites` pref. Can be `true` even if topsites.enabled is `false`.
    pub static sponsored_enabled: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sponsored_enabled".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(586), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from topsites.sponsored_tiles_configured
    ///
    /// The number of topsite tiles configured to be shown on newtab.
    pub static sponsored_tiles_configured: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sponsored_tiles_configured".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(587), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from topsites.sponsored_tiles_received
    ///
    /// The stringified JSON of tiles processed for display (array of objects). Includes tiles not displayed and reason for not displaying. Fields included: advertiser, provider, display_position, display_fail_reason.
    pub static sponsored_tiles_received: Lazy<TextMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "sponsored_tiles_received".into(),
                category: "topsites".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Application,
                disabled: false,
                ..Default::default()
            };
        TextMetric::new(MetricId(588), meta)
    });

}
pub mod bookmarks_sidebar {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from bookmarks_sidebar.cumulative_searches
    ///
    /// Cumulative no. bookmark of searches performed before selecting a link.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_BOOKMARKS_SEARCHBAR_CUMULATIVE_SEARCHES.
    pub static cumulative_searches: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cumulative_searches".into(),
                category: "bookmarks_sidebar".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(589), meta, 0, 20, 21, HistogramType::Linear)
    });

}
pub mod bookmarks_toolbar {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from bookmarks_toolbar.init
    ///
    /// Firefox: Time to initialize the bookmarks toolbar view (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_BOOKMARKS_TOOLBAR_INIT_MS.
    pub static init: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "init".into(),
                category: "bookmarks_toolbar".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(590), meta, TimeUnit::Millisecond)
    });

}
pub mod history_sidebar {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from history_sidebar.cumulative_filter_count
    ///
    /// Cumulative no. of search filters applied performed before selecting a link.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_SEARCHBAR_CUMULATIVE_FILTER_COUNT.
    pub static cumulative_filter_count: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cumulative_filter_count".into(),
                category: "history_sidebar".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(591), meta, 0, 20, 21, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from history_sidebar.cumulative_searches
    ///
    /// Cumulative no. of searches performed before selecting a link.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_SEARCHBAR_CUMULATIVE_SEARCHES.
    pub static cumulative_searches: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cumulative_searches".into(),
                category: "history_sidebar".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(592), meta, 0, 20, 21, HistogramType::Linear)
    });

    #[repr(u16)]
    pub enum FilterTypeLabel {
        EVisited = 0,
        ELastvisited = 1,
        EDayandsite = 2,
        ESite = 3,
        EDay = 4,
        __Other__,
    }
    impl From<u16> for FilterTypeLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EVisited,
                1 => Self::ELastvisited,
                2 => Self::EDayandsite,
                3 => Self::ESite,
                4 => Self::EDay,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for FilterTypeLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EVisited => "visited",
                Self::ELastvisited => "lastvisited",
                Self::EDayandsite => "dayandsite",
                Self::ESite => "site",
                Self::EDay => "day",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from history_sidebar.filter_type
    ///
    /// The type of search filters used for the sidebar search.
    /// This metric was generated to correspond to the Legacy Telemetry categorical histogram PLACES_SEARCHBAR_FILTER_TYPE.
    pub static filter_type: Lazy<LabeledMetric<LabeledCounterMetric, FilterTypeLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "filter_type".into(),
                    category: "history_sidebar".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(593), meta, Some(vec![::std::borrow::Cow::from("day"), ::std::borrow::Cow::from("dayandsite"), ::std::borrow::Cow::from("lastvisited"), ::std::borrow::Cow::from("site"), ::std::borrow::Cow::from("visited")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from history_sidebar.lastvisited_tree_query_time
    ///
    /// PLACES: Time to load the sidebar history tree sorted by last visit (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram HISTORY_LASTVISITED_TREE_QUERY_TIME_MS.
    pub static lastvisited_tree_query_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "lastvisited_tree_query_time".into(),
                category: "history_sidebar".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(594), meta, TimeUnit::Millisecond)
    });

}
pub mod library {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from library.cumulative_bookmark_searches
    ///
    /// Cumulative no. of Bookmark-specific searches performed before selecting a bookmark link in Library.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_LIBRARY_CUMULATIVE_BOOKMARK_SEARCHES.
    pub static cumulative_bookmark_searches: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cumulative_bookmark_searches".into(),
                category: "library".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(595), meta, 0, 20, 21, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from library.cumulative_history_searches
    ///
    /// Cumulative no. of History-specific searches performed before selecting a History link in Library.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram PLACES_LIBRARY_CUMULATIVE_HISTORY_SEARCHES.
    pub static cumulative_history_searches: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cumulative_history_searches".into(),
                category: "library".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(596), meta, 0, 20, 21, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from library.history_search_time
    ///
    /// PLACES: Time to search the history library (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_HISTORY_LIBRARY_SEARCH_TIME_MS.
    pub static history_search_time: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "history_search_time".into(),
                category: "library".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(597), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from library.link
    ///
    /// The number of history or bookmark items opened from the Library window This metric was generated to correspond to the Legacy Telemetry scalar library.link.
    pub static link: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "link".into(),
                    category: "library".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(598), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from library.opened
    ///
    /// The number of times the Library window was opened, keyed by 'history' or 'bookmarks' This metric was generated to correspond to the Legacy Telemetry scalar library.opened.
    pub static opened: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "opened".into(),
                    category: "library".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(599), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from library.search
    ///
    /// The number of history-specific or bookmark-specific searches made from the Library window This metric was generated to correspond to the Legacy Telemetry scalar library.search.
    pub static search: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "search".into(),
                    category: "library".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(600), meta, None)
    });

}
pub mod pocket_button {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.event_action
    ///
    /// The action that was taken, like "click" or... actually, it might only ever be "click".
    pub static event_action: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_action".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(601), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.event_position
    ///
    /// 0-based index of the item on which the action was performed. Not always provided.
    pub static event_position: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_position".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(602), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.event_source
    ///
    /// The source of the taken action, like "save_button", "home_button", "on_save_recs", or the like.
    pub static event_source: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "event_source".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(603), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.impression_id
    ///
    /// A UUID representing this profile. This isn't client_id, nor can it be used to link to a client_id. This also means it should never be sent in a ping with a client_id.
    pub static impression_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression_id".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(604), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.model
    ///
    /// A string that identifies the ML model (if any) used to generate on-save recommendations. Like "doc2vec-incremental-best-article-pubspread".
    pub static model: Lazy<StringMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "model".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        StringMetric::new(MetricId(605), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.pocket_logged_in_status
    ///
    /// Whether there was a logged-in Pocket account in the Pocket-Firefox integration at the point in time this action occurred.
    pub static pocket_logged_in_status: Lazy<BooleanMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "pocket_logged_in_status".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        BooleanMetric::new(MetricId(606), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from pocket.button.profile_creation_date
    ///
    /// The days since Jan 1, 1970 that the oldest file in the profile dir was modified. Or created. Or just the day and time of the first thing to ask for the profile age called in. Or something earlier or later than that.
    /// You may not want to use this.
    pub static profile_creation_date: Lazy<QuantityMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "profile_creation_date".into(),
                category: "pocket.button".into(),
                send_in_pings: vec!["pocket-button".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        QuantityMetric::new(MetricId(607), meta)
    });

}
pub mod aboutpreferences {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowClickExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ShowClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from aboutpreferences.show_click
    ///
    /// This is recorded when a pane is shown when user clicks category name inside about:preferences. This event was generated to correspond to the Legacy Telemetry event aboutpreferences.show#click.
    pub static show_click: Lazy<EventMetric<ShowClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_click".into(),
                category: "aboutpreferences".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(608), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowHashExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ShowHashExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from aboutpreferences.show_hash
    ///
    /// This is recorded when a pane is shown via a hash change in url. This event was generated to correspond to the Legacy Telemetry event aboutpreferences.show#hash.
    pub static show_hash: Lazy<EventMetric<ShowHashExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_hash".into(),
                category: "aboutpreferences".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(609), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowInitialExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ShowInitialExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from aboutpreferences.show_initial
    ///
    /// This is recorded when a pane is shown direclty. This happens with or without a hash in the URL. The "general" pane loads without such a hash, when the pane is loaded via the "main" entrypoints in the menu system or with shortcuts. This event was generated to correspond to the Legacy Telemetry event aboutpreferences.show#initial.
    pub static show_initial: Lazy<EventMetric<ShowInitialExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_initial".into(),
                category: "aboutpreferences".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(610), meta)
    });

}
pub mod intl_ui_browser_language {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AcceptDialogExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AcceptDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.accept_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.accept#dialog.
    pub static accept_dialog: Lazy<EventMetric<AcceptDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "accept_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(611), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AddDialogExtra {
        pub r#installId: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AddDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["installId", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#installId.and_then(|val| map.insert("installId".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.add_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.add#dialog.
    pub static add_dialog: Lazy<EventMetric<AddDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "add_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(612), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.apply_main
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.apply#main.
    pub static apply_main: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "apply_main".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(613), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CancelDialogExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for CancelDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.cancel_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.cancel#dialog.
    pub static cancel_dialog: Lazy<EventMetric<CancelDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cancel_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(614), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ManageMainExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ManageMainExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.manage_main
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.manage#main.
    pub static manage_main: Lazy<EventMetric<ManageMainExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "manage_main".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(615), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct RemoveDialogExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for RemoveDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.remove_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.remove#dialog.
    pub static remove_dialog: Lazy<EventMetric<RemoveDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "remove_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(616), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ReorderDialogExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ReorderDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.reorder_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.reorder#dialog.
    pub static reorder_dialog: Lazy<EventMetric<ReorderDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reorder_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(617), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.reorder_main
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.reorder#main.
    pub static reorder_main: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reorder_main".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(618), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SearchDialogExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for SearchDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.search_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.search#dialog.
    pub static search_dialog: Lazy<EventMetric<SearchDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "search_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(619), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SearchMainExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for SearchMainExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.search_main
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.search#main.
    pub static search_main: Lazy<EventMetric<SearchMainExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "search_main".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(620), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SetFallbackDialogExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for SetFallbackDialogExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from intl.ui.browser_language.set_fallback_dialog
    ///
    /// User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.set_fallback#dialog.
    pub static set_fallback_dialog: Lazy<EventMetric<SetFallbackDialogExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "set_fallback_dialog".into(),
                category: "intl.ui.browser_language".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(621), meta)
    });

}
pub mod network_proxy_settings {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ProxyTypePreferenceExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ProxyTypePreferenceExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from network.proxy.settings.proxy_type_preference
    ///
    /// This metric tracks what proxy types users are choosing in the Network Settings dialog at the bottom of about:preferences#general. It gets recorded when pressing OK in the dialog box.
    pub static proxy_type_preference: Lazy<EventMetric<ProxyTypePreferenceExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "proxy_type_preference".into(),
                category: "network.proxy.settings".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(622), meta)
    });

}
pub mod privacy_ui_fpp_click {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CheckboxExtra {
        pub r#checked: Option<bool>,
    }

    impl ExtraKeys for CheckboxExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["checked"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#checked.and_then(|val| map.insert("checked".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from privacy.ui.fpp.click.checkbox
    ///
    /// User interaction by click events on fingerprinting protection checkbox in the ETP Custom subpanel.
    pub static checkbox: Lazy<EventMetric<CheckboxExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "checkbox".into(),
                category: "privacy.ui.fpp.click".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(623), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct MenuExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for MenuExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from privacy.ui.fpp.click.menu
    ///
    /// User interaction by click events on fingerprinting protection menulist in the ETP Custom subpanel.
    pub static menu: Lazy<EventMetric<MenuExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "menu".into(),
                category: "privacy.ui.fpp.click".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(624), meta)
    });

}
pub mod security_doh_settings {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ModeChangedButtonExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ModeChangedButtonExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.doh.settings.mode_changed_button
    ///
    /// User changed the TRR mode in about:preferences#privacy settings Value is id of the clicked button. This event was generated to correspond to the Legacy Telemetry event security.doh.settings.mode_changed#button.
    pub static mode_changed_button: Lazy<EventMetric<ModeChangedButtonExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "mode_changed_button".into(),
                category: "security.doh.settings".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(625), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ProviderChoiceValueExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ProviderChoiceValueExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.doh.settings.provider_choice_value
    ///
    /// User changed their DoH provider. Recorded value is URL of one of the existing providers or "custom". This event was generated to correspond to the Legacy Telemetry event security.doh.settings.provider_choice#value.
    pub static provider_choice_value: Lazy<EventMetric<ProviderChoiceValueExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "provider_choice_value".into(),
                category: "security.doh.settings".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(626), meta)
    });

}
pub mod aboutprivatebrowsing {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from aboutprivatebrowsing.click_dismiss_button
    ///
    /// This is recorded when a user clicks a link on the private browsing newtab. This event was generated to correspond to the Legacy Telemetry event aboutprivatebrowsing.click#dismiss_button.
    pub static click_dismiss_button: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_dismiss_button".into(),
                category: "aboutprivatebrowsing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(627), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from aboutprivatebrowsing.click_info_link
    ///
    /// This is recorded when a user clicks a link on the private browsing newtab. This event was generated to correspond to the Legacy Telemetry event aboutprivatebrowsing.click#info_link.
    pub static click_info_link: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_info_link".into(),
                category: "aboutprivatebrowsing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(628), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from aboutprivatebrowsing.click_promo_link
    ///
    /// This is recorded when a user clicks a link on the private browsing newtab. This event was generated to correspond to the Legacy Telemetry event aboutprivatebrowsing.click#promo_link.
    pub static click_promo_link: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_promo_link".into(),
                category: "aboutprivatebrowsing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(629), meta)
    });

}
pub mod private_browsing_reset_pbm {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ConfirmPanelExtra {
        pub r#action: Option<String>,
        pub r#reason: Option<String>,
    }

    impl ExtraKeys for ConfirmPanelExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action", "reason"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action.and_then(|val| map.insert("action".into(), val.to_string()));
          self.r#reason.and_then(|val| map.insert("reason".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from private_browsing.reset_pbm.confirm_panel
    ///
    /// Confirm panel show / hide event.
    pub static confirm_panel: Lazy<EventMetric<ConfirmPanelExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "confirm_panel".into(),
                category: "private_browsing.reset_pbm".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(630), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ResetActionExtra {
        pub r#did_confirm: Option<bool>,
    }

    impl ExtraKeys for ResetActionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["did_confirm"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#did_confirm.and_then(|val| map.insert("did_confirm".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from private_browsing.reset_pbm.reset_action
    ///
    /// Dispatched whenever PBM is restarted / reset via the resetPBM feature.
    pub static reset_action: Lazy<EventMetric<ResetActionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reset_action".into(),
                category: "private_browsing.reset_pbm".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(631), meta)
    });

}
pub mod profiles_default {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from profiles.default.updated
    ///
    /// Recorded when a new profile from a profile group becomes the default startup profile for the group. This may happen when a profile other than the current default is launched from the profile selector window, or when the user has multiple profiles running at the same time and switches app focus to a profile other than the current default. An event is not recorded if the current default profile is launched or gains app focus.
    pub static updated: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "updated".into(),
                category: "profiles.default".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(632), meta)
    });

}
pub mod profiles_delete {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from profiles.delete.cancel
    ///
    /// Recorded when the user clicks the "Cancel" button on the about:deleteprofile page, canceling deletion of the current profile and closing the page.
    pub static cancel: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "cancel".into(),
                category: "profiles.delete".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(633), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.delete.confirm
    ///
    /// Recorded when the user clicks the "Delete" button on the about:deleteprofile page, triggering deletion of the current profile.
    pub static confirm: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "confirm".into(),
                category: "profiles.delete".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(634), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.delete.displayed
    ///
    /// Recorded when the about:deleteprofile page is loaded.
    pub static displayed: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "displayed".into(),
                category: "profiles.delete".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(635), meta)
    });

}
pub mod profiles_existing {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AlertExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AlertExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.alert
    ///
    /// Recorded when the user tries to close the about:editprofile page without setting a name. A beforeunload alert is then displayed. We record the user's decision to stay on the page or leave in the `extra` value.
    pub static alert: Lazy<EventMetric<AlertExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "alert".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(636), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AvatarExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AvatarExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.avatar
    ///
    /// Recorded when the user selects a different avatar.
    pub static avatar: Lazy<EventMetric<AvatarExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "avatar".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(637), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClosedExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClosedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.closed
    ///
    /// Recorded when the page is closed.
    pub static closed: Lazy<EventMetric<ClosedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "closed".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(638), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.deleted
    ///
    /// Recorded when the user clicks the delete button.
    pub static deleted: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "deleted".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(639), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.displayed
    ///
    /// Recorded when the page is loaded.
    pub static displayed: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "displayed".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(640), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.learn_more
    ///
    /// Recorded when the "explore more addons" link is clicked.
    pub static learn_more: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "learn_more".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(641), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.name
    ///
    /// Recorded when the name is changed. This event is fired either after the user has stopped typing in the name input field for 2 seconds, or if they have edited the name, then quickly closed the tab.
    pub static name: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "name".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(642), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ThemeExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ThemeExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.existing.theme
    ///
    /// Recorded when the user selects a different theme.
    pub static theme: Lazy<EventMetric<ThemeExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "theme".into(),
                category: "profiles.existing".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(643), meta)
    });

}
pub mod profiles_new {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AlertExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AlertExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.alert
    ///
    /// Recorded when the user tries to close the about:newprofile page without setting a name. A beforeunload alert is then displayed. We record the user's decision to stay on the page or leave in the `extra` value.
    pub static alert: Lazy<EventMetric<AlertExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "alert".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(644), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AvatarExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for AvatarExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.avatar
    ///
    /// Recorded when the user selects a different avatar.
    pub static avatar: Lazy<EventMetric<AvatarExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "avatar".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(645), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClosedExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClosedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.closed
    ///
    /// Recorded when the page is closed.
    pub static closed: Lazy<EventMetric<ClosedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "closed".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(646), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.deleted
    ///
    /// Recorded when the user clicks the delete button.
    pub static deleted: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "deleted".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(647), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.displayed
    ///
    /// Recorded when the page is loaded.
    pub static displayed: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "displayed".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(648), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.learn_more
    ///
    /// Recorded when the "explore more addons" link is clicked.
    pub static learn_more: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "learn_more".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(649), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.name
    ///
    /// Recorded when the name is changed. This event is fired either after the user has stopped typing in the name input field for 2 seconds, or if they have edited the name, then quickly closed the tab.
    pub static name: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "name".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(650), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ThemeExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ThemeExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.new.theme
    ///
    /// Recorded when the user selects a different theme.
    pub static theme: Lazy<EventMetric<ThemeExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "theme".into(),
                category: "profiles.new".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(651), meta)
    });

}
pub mod profiles_selector_window {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from profiles.selector_window.launch
    ///
    /// Recorded when the user clicks a profile card in the profile selector window, launching the profile in a new Firefox instance.
    pub static launch: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "launch".into(),
                category: "profiles.selector_window".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(652), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowAtStartupExtra {
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ShowAtStartupExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from profiles.selector_window.show_at_startup
    ///
    /// Recorded when the user toggles the checkbox that determines if the profile selector window is shown at startup.
    pub static show_at_startup: Lazy<EventMetric<ShowAtStartupExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_at_startup".into(),
                category: "profiles.selector_window".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(653), meta)
    });

}
pub mod security_ui_protections {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickLwAboutLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickLwAboutLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_lw_about_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#lw_about_link.
    pub static click_lw_about_link: Lazy<EventMetric<ClickLwAboutLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_lw_about_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(654), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickLwOpenButtonExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickLwOpenButtonExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_lw_open_button
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#lw_open_button.
    pub static click_lw_open_button: Lazy<EventMetric<ClickLwOpenButtonExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_lw_open_button".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(655), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickLwSyncLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickLwSyncLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_lw_sync_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#lw_sync_link.
    pub static click_lw_sync_link: Lazy<EventMetric<ClickLwSyncLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_lw_sync_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(656), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickMobileAppLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickMobileAppLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_mobile_app_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#mobile_app_link.
    pub static click_mobile_app_link: Lazy<EventMetric<ClickMobileAppLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_mobile_app_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(657), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickMtrAboutLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickMtrAboutLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_mtr_about_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#mtr_about_link.
    pub static click_mtr_about_link: Lazy<EventMetric<ClickMtrAboutLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_mtr_about_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(658), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickMtrReportLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickMtrReportLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_mtr_report_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#mtr_report_link.
    pub static click_mtr_report_link: Lazy<EventMetric<ClickMtrReportLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_mtr_report_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(659), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickMtrSignupButtonExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickMtrSignupButtonExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_mtr_signup_button
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#mtr_signup_button.
    pub static click_mtr_signup_button: Lazy<EventMetric<ClickMtrSignupButtonExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_mtr_signup_button".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(660), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickSettingsLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickSettingsLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_settings_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#settings_link.
    pub static click_settings_link: Lazy<EventMetric<ClickSettingsLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_settings_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(661), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickTrackersAboutLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickTrackersAboutLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_trackers_about_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#trackers_about_link.
    pub static click_trackers_about_link: Lazy<EventMetric<ClickTrackersAboutLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_trackers_about_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(662), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickVpnAppLinkAndroidExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickVpnAppLinkAndroidExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_vpn_app_link_android
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#vpn_app_link_android.
    pub static click_vpn_app_link_android: Lazy<EventMetric<ClickVpnAppLinkAndroidExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_vpn_app_link_android".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(663), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickVpnAppLinkIosExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickVpnAppLinkIosExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_vpn_app_link_ios
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#vpn_app_link_ios.
    pub static click_vpn_app_link_ios: Lazy<EventMetric<ClickVpnAppLinkIosExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_vpn_app_link_ios".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(664), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickVpnBannerCloseExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickVpnBannerCloseExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_vpn_banner_close
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#vpn_banner_close.
    pub static click_vpn_banner_close: Lazy<EventMetric<ClickVpnBannerCloseExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_vpn_banner_close".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(665), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickVpnBannerLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickVpnBannerLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_vpn_banner_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#vpn_banner_link.
    pub static click_vpn_banner_link: Lazy<EventMetric<ClickVpnBannerLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_vpn_banner_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(666), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickVpnCardLinkExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ClickVpnCardLinkExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.click_vpn_card_link
    ///
    /// User interaction by click events on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.click#vpn_card_link.
    pub static click_vpn_card_link: Lazy<EventMetric<ClickVpnCardLinkExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click_vpn_card_link".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(667), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CloseProtectionReportExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for CloseProtectionReportExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.close_protection_report
    ///
    /// User closed on the protection report. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.close#protection_report.
    pub static close_protection_report: Lazy<EventMetric<CloseProtectionReportExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "close_protection_report".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(668), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowProtectionReportExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ShowProtectionReportExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.show_protection_report
    ///
    /// User arrived on the protection report. This also includes a 'value' attribute which defaults to 'direct' or will be the value that a referring website addds to the url. This also indicates if the vpn banner has been seen. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.show#protection_report.
    pub static show_protection_report: Lazy<EventMetric<ShowProtectionReportExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_protection_report".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(669), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShowVpnBannerExtra {
        pub r#category: Option<String>,
        pub r#value: Option<String>,
    }

    impl ExtraKeys for ShowVpnBannerExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["category", "value"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#category.and_then(|val| map.insert("category".into(), val.to_string()));
          self.r#value.and_then(|val| map.insert("value".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from security.ui.protections.show_vpn_banner
    ///
    /// User arrived on the protection report. This also includes a 'value' attribute which defaults to 'direct' or will be the value that a referring website addds to the url. This also indicates if the vpn banner has been seen. This event was generated to correspond to the Legacy Telemetry event security.ui.protections.show#vpn_banner.
    pub static show_vpn_banner: Lazy<EventMetric<ShowVpnBannerExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "show_vpn_banner".into(),
                category: "security.ui.protections".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(670), meta)
    });

}
pub mod protocolhandler_mailto {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[repr(u16)]
    pub enum HandlerPromptShownLabel {
        EOsDefault = 0,
        EFxDefault = 1,
        __Other__,
    }
    impl From<u16> for HandlerPromptShownLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EOsDefault,
                1 => Self::EFxDefault,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for HandlerPromptShownLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EOsDefault => "os_default",
                Self::EFxDefault => "fx_default",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from protocolhandler.mailto.handler_prompt_shown
    ///
    /// A website was visited, which called registerProtocolHandler for mailto://
    pub static handler_prompt_shown: Lazy<LabeledMetric<LabeledCounterMetric, HandlerPromptShownLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "handler_prompt_shown".into(),
                    category: "protocolhandler.mailto".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(671), meta, Some(vec![::std::borrow::Cow::from("fx_default"), ::std::borrow::Cow::from("os_default")]))
    });

    #[repr(u16)]
    pub enum PromptClickedLabel {
        ESetOsDefault = 0,
        ESetOsDefaultError = 1,
        ESetOsDefaultImpossible = 2,
        EDismissOsDefault = 3,
        ESetLocalDefault = 4,
        EDismissLocalDefault = 5,
        __Other__,
    }
    impl From<u16> for PromptClickedLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::ESetOsDefault,
                1 => Self::ESetOsDefaultError,
                2 => Self::ESetOsDefaultImpossible,
                3 => Self::EDismissOsDefault,
                4 => Self::ESetLocalDefault,
                5 => Self::EDismissLocalDefault,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for PromptClickedLabel {
        fn into(self) -> &'static str {
            match self {
                Self::ESetOsDefault => "set_os_default",
                Self::ESetOsDefaultError => "set_os_default_error",
                Self::ESetOsDefaultImpossible => "set_os_default_impossible",
                Self::EDismissOsDefault => "dismiss_os_default",
                Self::ESetLocalDefault => "set_local_default",
                Self::EDismissLocalDefault => "dismiss_local_default",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from protocolhandler.mailto.prompt_clicked
    ///
    /// User clicked on a button to approve setting the current site as default web mail site. The sum of all counters is the total amount of user interactions and dismissing the same dialog often could be a sign of a bug.
    pub static prompt_clicked: Lazy<LabeledMetric<LabeledCounterMetric, PromptClickedLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "prompt_clicked".into(),
                    category: "protocolhandler.mailto".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(672), meta, Some(vec![::std::borrow::Cow::from("dismiss_local_default"), ::std::borrow::Cow::from("dismiss_os_default"), ::std::borrow::Cow::from("set_local_default"), ::std::borrow::Cow::from("set_os_default"), ::std::borrow::Cow::from("set_os_default_error"), ::std::borrow::Cow::from("set_os_default_impossible")]))
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct VisitExtra {
        pub r#triggered_externally: Option<bool>,
    }

    impl ExtraKeys for VisitExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["triggered_externally"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#triggered_externally.and_then(|val| map.insert("triggered_externally".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from protocolhandler.mailto.visit
    ///
    /// a URI of type mailto was visited. Furthermore we want to know if from within the browser.
    pub static visit: Lazy<EventMetric<VisitExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "visit".into(),
                category: "protocolhandler.mailto".into(),
                send_in_pings: vec!["events".into(), "metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(673), meta)
    });

}
pub mod screenshots {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_context_menu
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#context_menu.
    pub static canceled_context_menu: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_context_menu".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(674), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_escape
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#escape.
    pub static canceled_escape: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_escape".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(675), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_navigation
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#navigation.
    pub static canceled_navigation: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_navigation".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(676), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_overlay_cancel
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#overlay_cancel.
    pub static canceled_overlay_cancel: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_overlay_cancel".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(677), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_preview_cancel
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#preview_cancel.
    pub static canceled_preview_cancel: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_preview_cancel".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(678), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_quick_actions
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#quick_actions.
    pub static canceled_quick_actions: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_quick_actions".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(679), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_shortcut
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#shortcut.
    pub static canceled_shortcut: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_shortcut".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(680), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.canceled_toolbar_button
    ///
    /// Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#toolbar_button.
    pub static canceled_toolbar_button: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "canceled_toolbar_button".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(681), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CopyOverlayCopyExtra {
        pub r#element: Option<String>,
        pub r#fullpage: Option<String>,
        pub r#move: Option<String>,
        pub r#region: Option<String>,
        pub r#resize: Option<String>,
        pub r#visible: Option<String>,
    }

    impl ExtraKeys for CopyOverlayCopyExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["element", "fullpage", "move", "region", "resize", "visible"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#element.and_then(|val| map.insert("element".into(), val.to_string()));
          self.r#fullpage.and_then(|val| map.insert("fullpage".into(), val.to_string()));
          self.r#move.and_then(|val| map.insert("move".into(), val.to_string()));
          self.r#region.and_then(|val| map.insert("region".into(), val.to_string()));
          self.r#resize.and_then(|val| map.insert("resize".into(), val.to_string()));
          self.r#visible.and_then(|val| map.insert("visible".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from screenshots.copy_overlay_copy
    ///
    /// Recorded when a user copies a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.copy#overlay_copy.
    pub static copy_overlay_copy: Lazy<EventMetric<CopyOverlayCopyExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "copy_overlay_copy".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(682), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CopyPreviewCopyExtra {
        pub r#element: Option<String>,
        pub r#fullpage: Option<String>,
        pub r#move: Option<String>,
        pub r#region: Option<String>,
        pub r#resize: Option<String>,
        pub r#visible: Option<String>,
    }

    impl ExtraKeys for CopyPreviewCopyExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["element", "fullpage", "move", "region", "resize", "visible"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#element.and_then(|val| map.insert("element".into(), val.to_string()));
          self.r#fullpage.and_then(|val| map.insert("fullpage".into(), val.to_string()));
          self.r#move.and_then(|val| map.insert("move".into(), val.to_string()));
          self.r#region.and_then(|val| map.insert("region".into(), val.to_string()));
          self.r#resize.and_then(|val| map.insert("resize".into(), val.to_string()));
          self.r#visible.and_then(|val| map.insert("visible".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from screenshots.copy_preview_copy
    ///
    /// Recorded when a user copies a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.copy#preview_copy.
    pub static copy_preview_copy: Lazy<EventMetric<CopyPreviewCopyExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "copy_preview_copy".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(683), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct DownloadOverlayDownloadExtra {
        pub r#element: Option<String>,
        pub r#fullpage: Option<String>,
        pub r#move: Option<String>,
        pub r#region: Option<String>,
        pub r#resize: Option<String>,
        pub r#visible: Option<String>,
    }

    impl ExtraKeys for DownloadOverlayDownloadExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["element", "fullpage", "move", "region", "resize", "visible"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#element.and_then(|val| map.insert("element".into(), val.to_string()));
          self.r#fullpage.and_then(|val| map.insert("fullpage".into(), val.to_string()));
          self.r#move.and_then(|val| map.insert("move".into(), val.to_string()));
          self.r#region.and_then(|val| map.insert("region".into(), val.to_string()));
          self.r#resize.and_then(|val| map.insert("resize".into(), val.to_string()));
          self.r#visible.and_then(|val| map.insert("visible".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from screenshots.download_overlay_download
    ///
    /// Recorded when a user downloads a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.download#overlay_download.
    pub static download_overlay_download: Lazy<EventMetric<DownloadOverlayDownloadExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "download_overlay_download".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(684), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct DownloadPreviewDownloadExtra {
        pub r#element: Option<String>,
        pub r#fullpage: Option<String>,
        pub r#move: Option<String>,
        pub r#region: Option<String>,
        pub r#resize: Option<String>,
        pub r#visible: Option<String>,
    }

    impl ExtraKeys for DownloadPreviewDownloadExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["element", "fullpage", "move", "region", "resize", "visible"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#element.and_then(|val| map.insert("element".into(), val.to_string()));
          self.r#fullpage.and_then(|val| map.insert("fullpage".into(), val.to_string()));
          self.r#move.and_then(|val| map.insert("move".into(), val.to_string()));
          self.r#region.and_then(|val| map.insert("region".into(), val.to_string()));
          self.r#resize.and_then(|val| map.insert("resize".into(), val.to_string()));
          self.r#visible.and_then(|val| map.insert("visible".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from screenshots.download_preview_download
    ///
    /// Recorded when a user downloads a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.download#preview_download.
    pub static download_preview_download: Lazy<EventMetric<DownloadPreviewDownloadExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "download_preview_download".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(685), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.failed_screenshot_too_large
    ///
    /// Recorded when a screenshot is too big to capture and we have to crop the screenshot. This event was generated to correspond to the Legacy Telemetry event screenshots.failed#screenshot_too_large.
    pub static failed_screenshot_too_large: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "failed_screenshot_too_large".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(686), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.selected_element
    ///
    /// Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#element.
    pub static selected_element: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "selected_element".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(687), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.selected_full_page
    ///
    /// Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#full_page.
    pub static selected_full_page: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "selected_full_page".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(688), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.selected_region_selection
    ///
    /// Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#region_selection.
    pub static selected_region_selection: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "selected_region_selection".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(689), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.selected_visible
    ///
    /// Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#visible.
    pub static selected_visible: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "selected_visible".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(690), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.started_context_menu
    ///
    /// Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#context_menu.
    pub static started_context_menu: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "started_context_menu".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(691), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.started_overlay_retry
    ///
    /// Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#overlay_retry.
    pub static started_overlay_retry: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "started_overlay_retry".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(692), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.started_preview_retry
    ///
    /// Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#preview_retry.
    pub static started_preview_retry: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "started_preview_retry".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(693), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.started_quick_actions
    ///
    /// Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#quick_actions.
    pub static started_quick_actions: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "started_quick_actions".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(694), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.started_shortcut
    ///
    /// Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#shortcut.
    pub static started_shortcut: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "started_shortcut".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(695), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from screenshots.started_toolbar_button
    ///
    /// Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#toolbar_button.
    pub static started_toolbar_button: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "started_toolbar_button".into(),
                category: "screenshots".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(696), meta)
    });

}
pub mod browser_engagement_navigation {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.about_home
    ///
    /// The count URI loads triggered in a subsession from about:home, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.about_home.
    pub static about_home: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_home".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(697), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.about_newtab
    ///
    /// The count URI loads triggered in a subsession from about:newtab, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.about_newtab.
    pub static about_newtab: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_newtab".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(698), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.contextmenu
    ///
    /// The count URI loads triggered in a subsession from the contextmenu, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.contextmenu.
    pub static contextmenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "contextmenu".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(699), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.searchbar
    ///
    /// The count URI loads triggered in a subsession from the searchbar, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.searchbar.
    pub static searchbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "searchbar".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(700), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.urlbar
    ///
    /// The count URI loads triggered in a subsession from the urlbar, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar.
    pub static urlbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(701), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.urlbar_handoff
    ///
    /// The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar_handoff.
    pub static urlbar_handoff: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_handoff".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(702), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.urlbar_persisted
    ///
    /// The count of URI loads triggered in a subsession from the urlbar after the search term was shown in the urlbar, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar_persisted.
    pub static urlbar_persisted: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_persisted".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(703), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.urlbar_searchmode
    ///
    /// The count URI loads triggered in a subsession from the urlbar's search mode, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.urlbar_searchmode.
    pub static urlbar_searchmode: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_searchmode".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(704), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.engagement.navigation.webextension
    ///
    /// The count URI loads triggered in a subsession from a webextension. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.navigation.webextension.
    pub static webextension: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "webextension".into(),
                    category: "browser.engagement.navigation".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(705), meta, None)
    });

}
pub mod browser_search_adclicks {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.about_home
    ///
    /// Records clicks of adverts on SERP pages where the search was started from about:home. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source- docs.mozilla.org/browser/search/telemetry.html#browser-search- content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.about_home.
    pub static about_home: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_home".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(706), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.about_newtab
    ///
    /// Records clicks of adverts on SERP pages where the search was started from about:newtab. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.about_newtab.
    pub static about_newtab: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_newtab".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(707), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.contextmenu
    ///
    /// Records clicks of adverts on SERP pages where the search was started from the context menu. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.contextmenu.
    pub static contextmenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "contextmenu".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(708), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.reload
    ///
    /// Records clicks of adverts on SERP pages where the search was loaded by reloading the page. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.reload.
    pub static reload: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "reload".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(709), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.searchbar
    ///
    /// Records clicks of adverts on SERP pages where the search was started from the search bar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.searchbar.
    pub static searchbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "searchbar".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(710), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.system
    ///
    /// Records clicks of adverts on SERP pages where the search was started from the system, e.g. command line. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.system.
    pub static system: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "system".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(711), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.tabhistory
    ///
    /// Records clicks of adverts on SERP pages where the search was loaded from the tab history. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.tabhistory.
    pub static tabhistory: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "tabhistory".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(712), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.unknown
    ///
    /// Records clicks of adverts on SERP pages where the search was started from a place not categorized by the other scalars. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.unknown.
    pub static unknown: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "unknown".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(713), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.urlbar
    ///
    /// Records clicks of adverts on SERP pages where the search was started from the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source- docs.mozilla.org/browser/search/telemetry.html#browser-search- content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar.
    pub static urlbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(714), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.urlbar_handoff
    ///
    /// The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar_handoff.
    pub static urlbar_handoff: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_handoff".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(715), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.urlbar_persisted
    ///
    /// Records clicks of adverts on SERP pages where the search was started from the urlbar after the search term was shown in the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar_persisted.
    pub static urlbar_persisted: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_persisted".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(716), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.urlbar_searchmode
    ///
    /// Records clicks of adverts on SERP pages where the search was started from the urlbar in search mode. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.urlbar_searchmode.
    pub static urlbar_searchmode: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_searchmode".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(717), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.adclicks.webextension
    ///
    /// Records clicks of adverts on SERP pages where the search was started from a webextension. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.adclicks.webextension.
    pub static webextension: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "webextension".into(),
                    category: "browser.search.adclicks".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(718), meta, None)
    });

}
pub mod browser_search_content {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.about_home
    ///
    /// Records counts for in-content searches where the search was most likely started from the about:home. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.about_home.
    pub static about_home: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_home".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(719), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.about_newtab
    ///
    /// Records counts for in-content searches where the search was most likely started from the about:newtab. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.about_newtab.
    pub static about_newtab: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_newtab".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(720), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.contextmenu
    ///
    /// Records counts for in-content searches where the search was most likely started from the context menu. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.contextmenu.
    pub static contextmenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "contextmenu".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(721), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.reload
    ///
    /// Records counts for in-content searches where the search was loaded by reloading the page. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.reload.
    pub static reload: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "reload".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(722), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.searchbar
    ///
    /// Records counts for in-content searches where the search was most likely started from the search bar. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.searchbar.
    pub static searchbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "searchbar".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(723), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.system
    ///
    /// Records counts for in-content searches where the search was most likely started from the system, e.g. command line. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.system.
    pub static system: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "system".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(724), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.tabhistory
    ///
    /// Records counts for in-content searches where the search was loaded from the tab history. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.tabhistory.
    pub static tabhistory: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "tabhistory".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(725), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.unknown
    ///
    /// Records counts for in-content searches where the search was started from a place that could not be determined or not categorized by the other scalars. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.unknown.
    pub static unknown: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "unknown".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(726), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.urlbar
    ///
    /// Records counts for in-content searches where the search was most likely started from the urlbar. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar.
    pub static urlbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(727), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.urlbar_handoff
    ///
    /// The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar_handoff.
    pub static urlbar_handoff: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_handoff".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(728), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.urlbar_persisted
    ///
    /// Records counts for in-content searches where the search was most likely started from the urlbar after the search term was shown in the urlbar. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar_persisted.
    pub static urlbar_persisted: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_persisted".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(729), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.urlbar_searchmode
    ///
    /// Records counts for in-content searches where the search was most likely started from the urlbar in search mode. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.urlbar_searchmode.
    pub static urlbar_searchmode: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_searchmode".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(730), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.content.webextension
    ///
    /// Records counts for in-content searches where the search was most likely started from a webextension. The key format is <provider>:[tagged|tagged-follow-on|organic]:[code|other|none] See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.content.webextension.
    pub static webextension: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "webextension".into(),
                    category: "browser.search.content".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(731), meta, None)
    });

}
pub mod browser_search_withads {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.about_home
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from about:home. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.about_home.
    pub static about_home: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_home".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(732), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.about_newtab
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from about:newtab. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.about_newtab.
    pub static about_newtab: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "about_newtab".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(733), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.contextmenu
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from the context menu. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.contextmenu.
    pub static contextmenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "contextmenu".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(734), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.reload
    ///
    /// Records counts of SERP pages with adverts displayed where the search was loaded by reloading the page. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.reload.
    pub static reload: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "reload".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(735), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.searchbar
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from the search bar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.searchbar.
    pub static searchbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "searchbar".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(736), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.system
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from the system, e.g. command line. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.system.
    pub static system: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "system".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(737), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.tabhistory
    ///
    /// Records counts of SERP pages with adverts displayed where the search was loaded from the tab history. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.tabhistory.
    pub static tabhistory: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "tabhistory".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(738), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.unknown
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from a place not categorized by the other scalars. The key format is ‘<provider>:<tagged|organic>’ See https://firefox- source-docs.mozilla.org/browser/search/telemetry.html#browser- search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.unknown.
    pub static unknown: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "unknown".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(739), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.urlbar
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar.
    pub static urlbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(740), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.urlbar_handoff
    ///
    /// The count URI loads triggered in a subsession from the urlbar via handoff, broken down by the originating action. This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar_handoff.
    pub static urlbar_handoff: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_handoff".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(741), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.urlbar_persisted
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from the urlbar after the search term was shown in the urlbar. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar_persisted.
    pub static urlbar_persisted: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_persisted".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(742), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.urlbar_searchmode
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from the urlbar in search mode. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source-docs.mozilla.org/browser/search/telemetry.html#browser-search-content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.urlbar_searchmode.
    pub static urlbar_searchmode: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "urlbar_searchmode".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(743), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from browser.search.withads.webextension
    ///
    /// Records counts of SERP pages with adverts displayed where the search was started from a webextension. The key format is ‘<provider>:<tagged|organic>’ See https://firefox-source- docs.mozilla.org/browser/search/telemetry.html#browser-search- content This metric was generated to correspond to the Legacy Telemetry scalar browser.search.withads.webextension.
    pub static webextension: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "webextension".into(),
                    category: "browser.search.withads".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(744), meta, None)
    });

}
pub mod newtab_search_ad {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ClickExtra {
        pub r#is_follow_on: Option<bool>,
        pub r#is_tagged: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#search_access_point: Option<String>,
        pub r#telemetry_id: Option<String>,
    }

    impl ExtraKeys for ClickExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["is_follow_on", "is_tagged", "newtab_visit_id", "search_access_point", "telemetry_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#is_follow_on.and_then(|val| map.insert("is_follow_on".into(), val.to_string()));
          self.r#is_tagged.and_then(|val| map.insert("is_tagged".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#search_access_point.and_then(|val| map.insert("search_access_point".into(), val.to_string()));
          self.r#telemetry_id.and_then(|val| map.insert("telemetry_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.search.ad.click
    ///
    /// Recorded when an ad link is clicked on a Search Engine Result Page (SERP) which was loaded by a seach that began on a newtab page.
    pub static click: Lazy<EventMetric<ClickExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "click".into(),
                category: "newtab.search.ad".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(745), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ImpressionExtra {
        pub r#is_follow_on: Option<bool>,
        pub r#is_tagged: Option<bool>,
        pub r#newtab_visit_id: Option<String>,
        pub r#search_access_point: Option<String>,
        pub r#telemetry_id: Option<String>,
    }

    impl ExtraKeys for ImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["is_follow_on", "is_tagged", "newtab_visit_id", "search_access_point", "telemetry_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#is_follow_on.and_then(|val| map.insert("is_follow_on".into(), val.to_string()));
          self.r#is_tagged.and_then(|val| map.insert("is_tagged".into(), val.to_string()));
          self.r#newtab_visit_id.and_then(|val| map.insert("newtab_visit_id".into(), val.to_string()));
          self.r#search_access_point.and_then(|val| map.insert("search_access_point".into(), val.to_string()));
          self.r#telemetry_id.and_then(|val| map.insert("telemetry_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from newtab.search.ad.impression
    ///
    /// Recorded when a newtab visit resulted in a search that loaded a Search Engine Result Page (SERP) that contains an ad link. And the SERP is visible.
    pub static impression: Lazy<EventMetric<ImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression".into(),
                category: "newtab.search.ad".into(),
                send_in_pings: vec!["newtab".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(746), meta)
    });

}
pub mod sap {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CountsExtra {
        pub r#overridden_by_third_party: Option<bool>,
        pub r#partner_code: Option<String>,
        pub r#provider_id: Option<String>,
        pub r#provider_name: Option<String>,
        pub r#source: Option<String>,
    }

    impl ExtraKeys for CountsExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["overridden_by_third_party", "partner_code", "provider_id", "provider_name", "source"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#overridden_by_third_party.and_then(|val| map.insert("overridden_by_third_party".into(), val.to_string()));
          self.r#partner_code.and_then(|val| map.insert("partner_code".into(), val.to_string()));
          self.r#provider_id.and_then(|val| map.insert("provider_id".into(), val.to_string()));
          self.r#provider_name.and_then(|val| map.insert("provider_name".into(), val.to_string()));
          self.r#source.and_then(|val| map.insert("source".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from sap.counts
    ///
    /// Recorded search counts when a user initiates a search from a search access point (SAP). It does not guarantee that the search engine result page was loaded successfully (use SERP telemetry).
    pub static counts: Lazy<EventMetric<CountsExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "counts".into(),
                category: "sap".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(747), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from sap.deprecated_counts
    ///
    /// This is deprecated metric that should not be incoporated into dashboards. Use the `sap.counts` event instead.
    /// This metric has been added to Glean to aid transition of histograms and allow the legacy telemetry SEARCH_COUNTS to continue to be recorded.
    /// Records search counts for search access points. The format is: <engine-name>.<search-access-point>. For the urlbar when in search mode, the format is <engine name>.urlbar-searchmode. For the urlbar when an internal @engine shortcut is used, the format is: <engine-name>.alias.
    /// This metric was generated to correspond to the Legacy Telemetry count histogram SEARCH_COUNTS.
    pub static deprecated_counts: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "deprecated_counts".into(),
                    category: "sap".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(748), meta, None)
    });

}
pub mod search_with {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from search_with.context_id
    ///
    /// An identifier for Contextual Services user interaction pings. This is used internally for counting unique users as well as for anti-fraud. It is shared with other Contextual Services. It is not shared externally.
    pub static context_id: Lazy<UuidMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "context_id".into(),
                category: "search_with".into(),
                send_in_pings: vec!["search-with".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UuidMetric::new(MetricId(749), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from search_with.reporting_url
    ///
    /// The external url to report this interaction to.
    pub static reporting_url: Lazy<UrlMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "reporting_url".into(),
                category: "search_with".into(),
                send_in_pings: vec!["search-with".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        UrlMetric::new(MetricId(750), meta)
    });

}
pub mod searchbar {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[repr(u16)]
    pub enum SelectedResultMethodLabel {
        EEnter = 0,
        EEnterselection = 1,
        EClick = 2,
        __Other__,
    }
    impl From<u16> for SelectedResultMethodLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EEnter,
                1 => Self::EEnterselection,
                2 => Self::EClick,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for SelectedResultMethodLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EEnter => "enter",
                Self::EEnterselection => "enterSelection",
                Self::EClick => "click",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from searchbar.selected_result_method
    ///
    /// The input method the user used to select a result in the searchbar. 'enter' => The user hit the Enter key without choosing a result in the popup. 'enterSelection' => The user chose a result and then hit the Enter key. 'click' => The user clicked a result with the mouse.
    /// This metric was generated to correspond to the Legacy Telemetry categorical histogram FX_SEARCHBAR_SELECTED_RESULT_METHOD.
    pub static selected_result_method: Lazy<LabeledMetric<LabeledCounterMetric, SelectedResultMethodLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "selected_result_method".into(),
                    category: "searchbar".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(751), meta, Some(vec![::std::borrow::Cow::from("click"), ::std::borrow::Cow::from("enter"), ::std::borrow::Cow::from("enterSelection")]))
    });

}
pub mod serp {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AbandonmentExtra {
        pub r#impression_id: Option<String>,
        pub r#reason: Option<String>,
    }

    impl ExtraKeys for AbandonmentExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["impression_id", "reason"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#impression_id.and_then(|val| map.insert("impression_id".into(), val.to_string()));
          self.r#reason.and_then(|val| map.insert("reason".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from serp.abandonment
    ///
    /// Recorded when there is no engagement with the SERP before the tab is closed, the window is closed, the app is closed, or the tab is navigated away from.
    pub static abandonment: Lazy<EventMetric<AbandonmentExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "abandonment".into(),
                category: "serp".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(752), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AdImpressionExtra {
        pub r#ads_hidden: Option<u32>,
        pub r#ads_loaded: Option<u32>,
        pub r#ads_visible: Option<u32>,
        pub r#component: Option<String>,
        pub r#impression_id: Option<String>,
    }

    impl ExtraKeys for AdImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["ads_hidden", "ads_loaded", "ads_visible", "component", "impression_id"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#ads_hidden.and_then(|val| map.insert("ads_hidden".into(), val.to_string()));
          self.r#ads_loaded.and_then(|val| map.insert("ads_loaded".into(), val.to_string()));
          self.r#ads_visible.and_then(|val| map.insert("ads_visible".into(), val.to_string()));
          self.r#component.and_then(|val| map.insert("component".into(), val.to_string()));
          self.r#impression_id.and_then(|val| map.insert("impression_id".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from serp.ad_impression
    ///
    /// Recorded when a user loads a SERP and ads are detected.
    pub static ad_impression: Lazy<EventMetric<AdImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "ad_impression".into(),
                category: "serp".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(753), meta)
    });

    #[repr(u16)]
    pub enum AdsBlockedCountLabel {
        EBeyondViewport = 0,
        EHiddenParent = 1,
        EHiddenChild = 2,
        __Other__,
    }
    impl From<u16> for AdsBlockedCountLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EBeyondViewport,
                1 => Self::EHiddenParent,
                2 => Self::EHiddenChild,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for AdsBlockedCountLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EBeyondViewport => "beyond_viewport",
                Self::EHiddenParent => "hidden_parent",
                Self::EHiddenChild => "hidden_child",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from serp.ads_blocked_count
    ///
    /// Counts the specific type of block.
    pub static ads_blocked_count: Lazy<LabeledMetric<LabeledCounterMetric, AdsBlockedCountLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "ads_blocked_count".into(),
                    category: "serp".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(754), meta, Some(vec![::std::borrow::Cow::from("beyond_viewport"), ::std::borrow::Cow::from("hidden_child"), ::std::borrow::Cow::from("hidden_parent")]))
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct CategorizationExtra {
        pub r#app_version: Option<u32>,
        pub r#channel: Option<String>,
        pub r#is_shopping_page: Option<bool>,
        pub r#mappings_version: Option<u32>,
        pub r#num_ads_clicked: Option<u32>,
        pub r#num_ads_hidden: Option<u32>,
        pub r#num_ads_loaded: Option<u32>,
        pub r#num_ads_visible: Option<u32>,
        pub r#organic_category: Option<u32>,
        pub r#organic_num_domains: Option<u32>,
        pub r#organic_num_inconclusive: Option<u32>,
        pub r#organic_num_unknown: Option<u32>,
        pub r#partner_code: Option<String>,
        pub r#provider: Option<String>,
        pub r#region: Option<String>,
        pub r#sponsored_category: Option<u32>,
        pub r#sponsored_num_domains: Option<u32>,
        pub r#sponsored_num_inconclusive: Option<u32>,
        pub r#sponsored_num_unknown: Option<u32>,
        pub r#tagged: Option<bool>,
    }

    impl ExtraKeys for CategorizationExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["app_version", "channel", "is_shopping_page", "mappings_version", "num_ads_clicked", "num_ads_hidden", "num_ads_loaded", "num_ads_visible", "organic_category", "organic_num_domains", "organic_num_inconclusive", "organic_num_unknown", "partner_code", "provider", "region", "sponsored_category", "sponsored_num_domains", "sponsored_num_inconclusive", "sponsored_num_unknown", "tagged"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#app_version.and_then(|val| map.insert("app_version".into(), val.to_string()));
          self.r#channel.and_then(|val| map.insert("channel".into(), val.to_string()));
          self.r#is_shopping_page.and_then(|val| map.insert("is_shopping_page".into(), val.to_string()));
          self.r#mappings_version.and_then(|val| map.insert("mappings_version".into(), val.to_string()));
          self.r#num_ads_clicked.and_then(|val| map.insert("num_ads_clicked".into(), val.to_string()));
          self.r#num_ads_hidden.and_then(|val| map.insert("num_ads_hidden".into(), val.to_string()));
          self.r#num_ads_loaded.and_then(|val| map.insert("num_ads_loaded".into(), val.to_string()));
          self.r#num_ads_visible.and_then(|val| map.insert("num_ads_visible".into(), val.to_string()));
          self.r#organic_category.and_then(|val| map.insert("organic_category".into(), val.to_string()));
          self.r#organic_num_domains.and_then(|val| map.insert("organic_num_domains".into(), val.to_string()));
          self.r#organic_num_inconclusive.and_then(|val| map.insert("organic_num_inconclusive".into(), val.to_string()));
          self.r#organic_num_unknown.and_then(|val| map.insert("organic_num_unknown".into(), val.to_string()));
          self.r#partner_code.and_then(|val| map.insert("partner_code".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#region.and_then(|val| map.insert("region".into(), val.to_string()));
          self.r#sponsored_category.and_then(|val| map.insert("sponsored_category".into(), val.to_string()));
          self.r#sponsored_num_domains.and_then(|val| map.insert("sponsored_num_domains".into(), val.to_string()));
          self.r#sponsored_num_inconclusive.and_then(|val| map.insert("sponsored_num_inconclusive".into(), val.to_string()));
          self.r#sponsored_num_unknown.and_then(|val| map.insert("sponsored_num_unknown".into(), val.to_string()));
          self.r#tagged.and_then(|val| map.insert("tagged".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from serp.categorization
    ///
    /// A high-level categorization of a SERP (a best guess as to its topic), using buckets such as "sports" or "travel".
    pub static categorization: Lazy<EventMetric<CategorizationExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "categorization".into(),
                category: "serp".into(),
                send_in_pings: vec!["serp-categorization".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(755), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from serp.categorization_duration
    ///
    /// The time it takes to categorize elements on a SERP.
    pub static categorization_duration: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "categorization_duration".into(),
                category: "serp".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(756), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from serp.categorization_no_map_found
    ///
    /// A count incremented upon a SERP categorization event being recorded without a corresponding impression event being recorded. This metric effectively counts missing impressions due to issues with the domain-to-categories map.
    pub static categorization_no_map_found: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            757,
            "serp",
            "categorization_no_map_found",
            "serp-categorization"
        )
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct EngagementExtra {
        pub r#action: Option<String>,
        pub r#impression_id: Option<String>,
        pub r#target: Option<String>,
    }

    impl ExtraKeys for EngagementExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action", "impression_id", "target"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action.and_then(|val| map.insert("action".into(), val.to_string()));
          self.r#impression_id.and_then(|val| map.insert("impression_id".into(), val.to_string()));
          self.r#target.and_then(|val| map.insert("target".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from serp.engagement
    ///
    /// Recorded user actions on a SERP.
    pub static engagement: Lazy<EventMetric<EngagementExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "engagement".into(),
                category: "serp".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(758), meta)
    });

        #[derive(Debug, Hash, Eq, PartialEq, Clone, ::glean::traits::__serde::Serialize, ::glean::traits::__serde::Deserialize)]
    #[allow(non_snake_case)]
    #[serde(deny_unknown_fields)]
    pub struct ExperimentInfoObject {
          #[serde(skip_serializing_if = "Option::is_none")]
          pub slug: Option<String>,
          #[serde(skip_serializing_if = "Option::is_none")]
          pub branch: Option<String>,
    }

    #[allow(non_upper_case_globals)]
    /// generated from serp.experiment_info
    ///
    /// Whether the client is enrolled in a specified experiment and if so, which branch the client is assigned to. The target experiment is specified in the Nimbus config by creating a "targetExperiment" key and setting its value to the experiment's slug (and ensuring the featureId is "search").
    pub static experiment_info: Lazy<ObjectMetric<ExperimentInfoObject>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "experiment_info".into(),
                category: "serp".into(),
                send_in_pings: vec!["serp-categorization".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        ObjectMetric::new(MetricId(759), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ImpressionExtra {
        pub r#impression_id: Option<String>,
        pub r#is_private: Option<bool>,
        pub r#is_shopping_page: Option<bool>,
        pub r#is_signed_in: Option<bool>,
        pub r#partner_code: Option<String>,
        pub r#provider: Option<String>,
        pub r#shopping_tab_displayed: Option<bool>,
        pub r#source: Option<String>,
        pub r#tagged: Option<bool>,
    }

    impl ExtraKeys for ImpressionExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["impression_id", "is_private", "is_shopping_page", "is_signed_in", "partner_code", "provider", "shopping_tab_displayed", "source", "tagged"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#impression_id.and_then(|val| map.insert("impression_id".into(), val.to_string()));
          self.r#is_private.and_then(|val| map.insert("is_private".into(), val.to_string()));
          self.r#is_shopping_page.and_then(|val| map.insert("is_shopping_page".into(), val.to_string()));
          self.r#is_signed_in.and_then(|val| map.insert("is_signed_in".into(), val.to_string()));
          self.r#partner_code.and_then(|val| map.insert("partner_code".into(), val.to_string()));
          self.r#provider.and_then(|val| map.insert("provider".into(), val.to_string()));
          self.r#shopping_tab_displayed.and_then(|val| map.insert("shopping_tab_displayed".into(), val.to_string()));
          self.r#source.and_then(|val| map.insert("source".into(), val.to_string()));
          self.r#tagged.and_then(|val| map.insert("tagged".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from serp.impression
    ///
    /// Recorded when a search engine results page (SERP) is shown to a user. The feature began rolling out to all users with Firefox 115, and was permanently enabled in Firefox 119.
    pub static impression: Lazy<EventMetric<ImpressionExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "impression".into(),
                category: "serp".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(760), meta)
    });

}
pub mod urlbar_searchmode {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.bookmarkmenu
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecing the Search Bookmarks menu item in the Library menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.bookmarkmenu.
    pub static bookmarkmenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "bookmarkmenu".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(761), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.handoff
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after being handed off from the search bar on the new tab page. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.handoff.
    pub static handoff: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "handoff".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(762), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.historymenu
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecing the Search History menu item in a History menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.historymenu.
    pub static historymenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "historymenu".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(763), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.keywordoffer
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a keyword offer result. The scalar key for local search modes entered using a restrict keyword will be suffixed with "keyword". For example: tabs_keyword, bookmarks_keyword, history_keyword, and actions_keyword. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.keywordoffer.
    pub static keywordoffer: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "keywordoffer".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(764), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.oneoff
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a one-off. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.oneoff.
    pub static oneoff: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "oneoff".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(765), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.other
    ///
    /// A keyed uint recording how many times the user entered a particular search mode from an unknown entry point. If values appear for this probe in Telemetry, we should review the entry points to search mode. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.other.
    pub static other: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "other".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(766), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.searchbutton
    ///
    /// A keyed uint recording how many times the user entered a particular search mode by unified search button. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.searchbutton.
    pub static searchbutton: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "searchbutton".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(767), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.shortcut
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after pressing a keyboard shortcut. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.shortcut.
    pub static shortcut: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "shortcut".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(768), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.tabmenu
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting the Search Tabs menu item in the Tab Overflow menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.tabmenu.
    pub static tabmenu: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "tabmenu".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(769), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.tabtosearch
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a tab-to-search result. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.tabtosearch.
    pub static tabtosearch: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "tabtosearch".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(770), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.tabtosearch_onboard
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a tab-to-search onboarding result. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.tabtosearch_onboard.
    pub static tabtosearch_onboard: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "tabtosearch_onboard".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(771), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.topsites_newtab
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a search shortcut Top Site on the New Tab Page. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.topsites_newtab.
    pub static topsites_newtab: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "topsites_newtab".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(772), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.topsites_urlbar
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a search shortcut Top Site in the Urlbar. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.topsites_urlbar.
    pub static topsites_urlbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "topsites_urlbar".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(773), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.touchbar
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after selecting a search shortcut on the macOS Touch Bar. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.touchbar.
    pub static touchbar: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "touchbar".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(774), meta, None)
    });

    #[allow(non_upper_case_globals)]
    /// generated from urlbar.searchmode.typed
    ///
    /// A keyed uint recording how many times the user entered a particular search mode after typing an alias. The scalar keys for local search modes entered by typing a restrict keyword will be suffixed with "keyword". For example: tabs_keyword, bookmarks_keyword, history_keyword, and actions_keyword. If instead search mode was entered by typing a restrict symbol the key will be suffixed with "symbol" (e.g. typing "%" will generate "tabs_symbol"). This metric was generated to correspond to the Legacy Telemetry scalar urlbar.searchmode.typed.
    pub static typed: Lazy<LabeledMetric<LabeledCounterMetric, super::DynamicLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "typed".into(),
                    category: "urlbar.searchmode".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(775), meta, None)
    });

}
pub mod session_restore {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[repr(u16)]
    pub enum AllFilesCorruptLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for AllFilesCorruptLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for AllFilesCorruptLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from session_restore.all_files_corrupt
    ///
    /// Session restore: Whether none of the backup files contained parse-able JSON
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram FX_SESSION_RESTORE_ALL_FILES_CORRUPT.
    pub static all_files_corrupt: Lazy<LabeledMetric<LabeledCounterMetric, AllFilesCorruptLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "all_files_corrupt".into(),
                    category: "session_restore".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(776), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.auto_restore_duration_until_eager_tabs_restored
    ///
    /// Session restore: If the browser is setup to auto-restore tabs, this probe measures the time elapsed between the instant we start Session Restore and the instant we have finished restoring tabs eagerly. At this stage, the tabs that are restored on demand are not restored yet.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_AUTO_RESTORE_DURATION_UNTIL_EAGER_TABS_RESTORED_MS.
    pub static auto_restore_duration_until_eager_tabs_restored: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "auto_restore_duration_until_eager_tabs_restored".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(777), meta, TimeUnit::Millisecond)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct BackupCanBeLoadedSessionFileExtra {
        pub r#can_load: Option<String>,
        pub r#loadfail_reason: Option<String>,
        pub r#path_key: Option<String>,
    }

    impl ExtraKeys for BackupCanBeLoadedSessionFileExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["can_load", "loadfail_reason", "path_key"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#can_load.and_then(|val| map.insert("can_load".into(), val.to_string()));
          self.r#loadfail_reason.and_then(|val| map.insert("loadfail_reason".into(), val.to_string()));
          self.r#path_key.and_then(|val| map.insert("path_key".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from session_restore.backup_can_be_loaded_session_file
    ///
    /// Recorded when a file is able to be successfully read on startup This event was generated to correspond to the Legacy Telemetry event session_restore.backup_can_be_loaded#session_file.
    pub static backup_can_be_loaded_session_file: Lazy<EventMetric<BackupCanBeLoadedSessionFileExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "backup_can_be_loaded_session_file".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(778), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.collect_all_windows_data
    ///
    /// Session restore: Time to collect all window data (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_COLLECT_ALL_WINDOWS_DATA_MS.
    pub static collect_all_windows_data: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "collect_all_windows_data".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(779), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.collect_data
    ///
    /// Session restore: Time to collect all window and tab data (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_COLLECT_DATA_MS.
    pub static collect_data: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "collect_data".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(780), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.collect_session_history
    ///
    /// Session restore: Duration of session history collection in the parent process (ms).
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_COLLECT_SESSION_HISTORY_MS.
    pub static collect_session_history: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "collect_session_history".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(781), meta, TimeUnit::Millisecond)
    });

    #[repr(u16)]
    pub enum CorruptFileLabel {
        EFalse = 0,
        ETrue = 1,
        __Other__,
    }
    impl From<u16> for CorruptFileLabel {
        fn from(v: u16) -> Self {
            match v {
                0 => Self::EFalse,
                1 => Self::ETrue,
                _ => Self::__Other__,
            }
        }
    }
    impl Into<&'static str> for CorruptFileLabel {
        fn into(self) -> &'static str {
            match self {
                Self::EFalse => "false",
                Self::ETrue => "true",
                Self::__Other__ => "__other__",
            }
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from session_restore.corrupt_file
    ///
    /// Session restore: Whether the file read on startup contained parse-able JSON
    /// This metric was generated to correspond to the Legacy Telemetry boolean histogram FX_SESSION_RESTORE_CORRUPT_FILE.
    pub static corrupt_file: Lazy<LabeledMetric<LabeledCounterMetric, CorruptFileLabel>> = Lazy::new(|| {
        let meta =
            LabeledMetricData::Common {
                cmd: CommonMetricData {
                    name: "corrupt_file".into(),
                    category: "session_restore".into(),
                    send_in_pings: vec!["metrics".into()],
                    lifetime: Lifetime::Ping,
                    disabled: false,
                    ..Default::default()
                },
            };
        LabeledMetric::new(MetricId(782), meta, Some(vec![::std::borrow::Cow::from("false"), ::std::borrow::Cow::from("true")]))
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.file_size_bytes
    ///
    /// Session restore: The size of file sessionstore.js (bytes)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_FILE_SIZE_BYTES.
    pub static file_size_bytes: Lazy<MemoryDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "file_size_bytes".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        MemoryDistributionMetric::new(MetricId(783), meta, MemoryUnit::Byte)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.manual_restore_duration_until_eager_tabs_restored
    ///
    /// Session restore: If a session is restored by the user clicking on 'Restore Session', this probe measures the time elapsed between the instant the user has clicked and the instant we have finished restoring tabs eagerly. At this stage, the tabs that are restored on demand are not restored yet.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_MANUAL_RESTORE_DURATION_UNTIL_EAGER_TABS_RESTORED_MS.
    pub static manual_restore_duration_until_eager_tabs_restored: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "manual_restore_duration_until_eager_tabs_restored".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(784), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.number_of_eager_tabs_restored
    ///
    /// Session restore: Number of tabs restored eagerly in the session that has just been restored.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_SESSION_RESTORE_NUMBER_OF_EAGER_TABS_RESTORED.
    pub static number_of_eager_tabs_restored: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "number_of_eager_tabs_restored".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(785), meta, 0, 50, 51, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.number_of_tabs_restored
    ///
    /// Session restore: Number of tabs in the session that has just been restored.
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_NUMBER_OF_TABS_RESTORED.
    pub static number_of_tabs_restored: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "number_of_tabs_restored".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(786), meta, 1, 500, 20, HistogramType::Exponential)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.number_of_windows_restored
    ///
    /// Session restore: Number of windows in the session that has just been restored.
    /// This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_SESSION_RESTORE_NUMBER_OF_WINDOWS_RESTORED.
    pub static number_of_windows_restored: Lazy<CustomDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "number_of_windows_restored".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        CustomDistributionMetric::new(MetricId(787), meta, 0, 50, 51, HistogramType::Linear)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.read_file
    ///
    /// Session restore: Time to read the session data from the file on disk (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_READ_FILE_MS.
    pub static read_file: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "read_file".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(788), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.restore_window
    ///
    /// Session restore: Time spent blocking the main thread while restoring a window state (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_RESTORE_WINDOW_MS.
    pub static restore_window: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "restore_window".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(789), meta, TimeUnit::Millisecond)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct ShutdownSuccessSessionStartupExtra {
        pub r#shutdown_ok: Option<String>,
        pub r#shutdown_reason: Option<String>,
    }

    impl ExtraKeys for ShutdownSuccessSessionStartupExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["shutdown_ok", "shutdown_reason"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#shutdown_ok.and_then(|val| map.insert("shutdown_ok".into(), val.to_string()));
          self.r#shutdown_reason.and_then(|val| map.insert("shutdown_reason".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from session_restore.shutdown_success_session_startup
    ///
    /// Report shutdown success This event was generated to correspond to the Legacy Telemetry event session_restore.shutdown_success#session_startup.
    pub static shutdown_success_session_startup: Lazy<EventMetric<ShutdownSuccessSessionStartupExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "shutdown_success_session_startup".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(790), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.startup_init_session
    ///
    /// Session restore: Time it takes to prepare the data structures for restoring a session (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_STARTUP_INIT_SESSION_MS.
    pub static startup_init_session: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "startup_init_session".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(791), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.startup_onload_initial_window
    ///
    /// Session restore: Time it takes to finish restoration once we have first opened a window (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_STARTUP_ONLOAD_INITIAL_WINDOW_MS.
    pub static startup_onload_initial_window: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "startup_onload_initial_window".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(792), meta, TimeUnit::Millisecond)
    });

    #[allow(non_upper_case_globals)]
    /// generated from session_restore.write_file
    ///
    /// Session restore: Time to write the session data to the file on disk (ms)
    /// This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_WRITE_FILE_MS.
    pub static write_file: Lazy<TimingDistributionMetric> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "write_file".into(),
                category: "session_restore".into(),
                send_in_pings: vec!["metrics".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        TimingDistributionMetric::new(MetricId(793), meta, TimeUnit::Millisecond)
    });

}
pub mod shopping {
    use crate::private::*;
    #[allow(unused_imports)] // CommonMetricData might be unused, let's avoid warnings
    use glean::CommonMetricData;
    #[allow(unused_imports)] // HistogramType might be unusued, let's avoid warnings
    use glean::HistogramType;
    use once_cell::sync::Lazy;

    #[allow(unused_imports)]
    use std::convert::TryFrom;

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AddressBarFeatureCalloutDisplayedExtra {
        pub r#configuration: Option<String>,
    }

    impl ExtraKeys for AddressBarFeatureCalloutDisplayedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["configuration"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#configuration.and_then(|val| map.insert("configuration".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from shopping.address_bar_feature_callout_displayed
    ///
    /// The user was shown the feature callout for the Shopping component.
    pub static address_bar_feature_callout_displayed: Lazy<EventMetric<AddressBarFeatureCalloutDisplayedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "address_bar_feature_callout_displayed".into(),
                category: "shopping".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(794), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct AddressBarIconClickedExtra {
        pub r#action: Option<String>,
    }

    impl ExtraKeys for AddressBarIconClickedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["action"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#action.and_then(|val| map.insert("action".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from shopping.address_bar_icon_clicked
    ///
    /// The Shopping product Address Bar Icon was clicked by the user.
    pub static address_bar_icon_clicked: Lazy<EventMetric<AddressBarIconClickedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "address_bar_icon_clicked".into(),
                category: "shopping".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(795), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from shopping.address_bar_icon_displayed
    ///
    /// The Shopping product Address Bar Icon was displayed to the user.
    pub static address_bar_icon_displayed: Lazy<EventMetric<NoExtraKeys>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "address_bar_icon_displayed".into(),
                category: "shopping".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(796), meta)
    });

    #[allow(non_upper_case_globals)]
    /// generated from shopping.product_page_visits
    ///
    /// Counts number of visits to a supported retailer product page
    /// while enrolled in either the control or treatment branches
    /// of the shopping experiment.
    pub static product_page_visits: Lazy<CounterMetric> = Lazy::new(|| {
        CounterMetric::codegen_new(
            797,
            "shopping",
            "product_page_visits",
            "metrics"
        )
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SurfaceAdsClickedExtra {
        pub r#sponsored: Option<bool>,
    }

    impl ExtraKeys for SurfaceAdsClickedExtra {
        const ALLOWED_KEYS: &'static [&'static str] = &["sponsored"];

        fn into_ffi_extra(self) -> ::std::collections::HashMap<String, String> {
          let mut map = ::std::collections::HashMap::new();
          self.r#sponsored.and_then(|val| map.insert("sponsored".into(), val.to_string()));
          map
        }
    }
    #[allow(non_upper_case_globals)]
    /// generated from shopping.surface_ads_clicked
    ///
    /// An ad shown in the sidebar was clicked.
    pub static surface_ads_clicked: Lazy<EventMetric<SurfaceAdsClickedExtra>> = Lazy::new(|| {
        let meta =
            CommonMetricData {
                name: "surface_ads_clicked".into(),
                category: "shopping".into(),
                send_in_pings: vec!["events".into()],
                lifetime: Lifetime::Ping,
                disabled: false,
                ..Default::default()
            };
        EventMetric::new(MetricId(798), meta)
    });

    #[derive(Default, Debug, Clone, Hash, Eq, PartialEq)]
    #[allow(non_snake_case)]
    pub struct SurfaceAdsImpressionExtra 