// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mozilla/glean/bindings/GleanJSPingsLookup.h"

#include "mozilla/PerfectHash.h"
#include "nsString.h"

#include "mozilla/PerfectHash.h"

#define GLEAN_PING_INDEX_BITS (16)
#define GLEAN_PING_ID(entry) ((entry) >> GLEAN_PING_INDEX_BITS)
#define GLEAN_PING_INDEX(entry) ((entry) & ((1UL << GLEAN_PING_INDEX_BITS) - 1))

namespace mozilla::glean {

// Contains the ping id and the index into the ping string table.
using ping_entry_t = uint32_t;

Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry);

#if defined(_MSC_VER) && !defined(__clang__)
const char gPingStringTable[] = {
#else
constexpr char gPingStringTable[] = {
#endif
  /*     0 - "messagingSystem" */ 'm', 'e', 's', 's', 'a', 'g', 'i', 'n', 'g', 'S', 'y', 's', 't', 'e', 'm', '\0',
  /*    16 - "newtab" */ 'n', 'e', 'w', 't', 'a', 'b', '\0',
  /*    23 - "spoc" */ 's', 'p', 'o', 'c', '\0',
  /*    28 - "topSites" */ 't', 'o', 'p', 'S', 'i', 't', 'e', 's', '\0',
  /*    37 - "pocketButton" */ 'p', 'o', 'c', 'k', 'e', 't', 'B', 'u', 't', 't', 'o', 'n', '\0',
  /*    50 - "searchWith" */ 's', 'e', 'a', 'r', 'c', 'h', 'W', 'i', 't', 'h', '\0',
  /*    61 - "serpCategorization" */ 's', 'e', 'r', 'p', 'C', 'a', 't', 'e', 'g', 'o', 'r', 'i', 'z', 'a', 't', 'i', 'o', 'n', '\0',
  /*    80 - "quickSuggest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', '\0',
  /*    93 - "quickSuggestDeletionRequest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   121 - "urlbarKeywordExposure" */ 'u', 'r', 'l', 'b', 'a', 'r', 'K', 'e', 'y', 'w', 'o', 'r', 'd', 'E', 'x', 'p', 'o', 's', 'u', 'r', 'e', '\0',
  /*   143 - "prototypeNoCodeEvents" */ 'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e', 'N', 'o', 'C', 'o', 'd', 'e', 'E', 'v', 'e', 'n', 't', 's', '\0',
  /*   165 - "pageload" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', '\0',
  /*   174 - "useCounters" */ 'u', 's', 'e', 'C', 'o', 'u', 'n', 't', 'e', 'r', 's', '\0',
  /*   186 - "fxAccounts" */ 'f', 'x', 'A', 'c', 'c', 'o', 'u', 'n', 't', 's', '\0',
  /*   197 - "bounceTrackingProtection" */ 'b', 'o', 'u', 'n', 'c', 'e', 'T', 'r', 'a', 'c', 'k', 'i', 'n', 'g', 'P', 'r', 'o', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   222 - "backgroundTasks" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'T', 'a', 's', 'k', 's', '\0',
  /*   238 - "captchaDetection" */ 'c', 'a', 'p', 't', 'c', 'h', 'a', 'D', 'e', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   255 - "crash" */ 'c', 'r', 'a', 's', 'h', '\0',
  /*   261 - "dauReporting" */ 'd', 'a', 'u', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   274 - "collectionDisabledPing" */ 'c', 'o', 'l', 'l', 'e', 'c', 't', 'i', 'o', 'n', 'D', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   297 - "disabledPing" */ 'd', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   310 - "onePingOnly" */ 'o', 'n', 'e', 'P', 'i', 'n', 'g', 'O', 'n', 'l', 'y', '\0',
  /*   322 - "rideAlongPing" */ 'r', 'i', 'd', 'e', 'A', 'l', 'o', 'n', 'g', 'P', 'i', 'n', 'g', '\0',
  /*   336 - "testOhttpPing" */ 't', 'e', 's', 't', 'O', 'h', 't', 't', 'p', 'P', 'i', 'n', 'g', '\0',
  /*   350 - "testPing" */ 't', 'e', 's', 't', 'P', 'i', 'n', 'g', '\0',
  /*   359 - "nimbusTargetingContext" */ 'n', 'i', 'm', 'b', 'u', 's', 'T', 'a', 'r', 'g', 'e', 't', 'i', 'n', 'g', 'C', 'o', 'n', 't', 'e', 'x', 't', '\0',
  /*   382 - "brokenSiteReport" */ 'b', 'r', 'o', 'k', 'e', 'n', 'S', 'i', 't', 'e', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   399 - "userCharacteristics" */ 'u', 's', 'e', 'r', 'C', 'h', 'a', 'r', 'a', 'c', 't', 'e', 'r', 'i', 's', 't', 'i', 'c', 's', '\0',
  /*   419 - "onboardingOptOut" */ 'o', 'n', 'b', 'o', 'a', 'r', 'd', 'i', 'n', 'g', 'O', 'p', 't', 'O', 'u', 't', '\0',
  /*   436 - "usageDeletionRequest" */ 'u', 's', 'a', 'g', 'e', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   457 - "usageReporting" */ 'u', 's', 'a', 'g', 'e', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   472 - "firstStartup" */ 'f', 'i', 'r', 's', 't', 'S', 't', 'a', 'r', 't', 'u', 'p', '\0',
  /*   485 - "defaultAgent" */ 'd', 'e', 'f', 'a', 'u', 'l', 't', 'A', 'g', 'e', 'n', 't', '\0',
  /*   498 - "backgroundUpdate" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'U', 'p', 'd', 'a', 't', 'e', '\0',
};



const ping_entry_t sPingByNameLookupEntries[] = {
  1573200,
  1507650,
  2228722,
  589917,
  1048798,
  852142,
  1442102,
  327717,
  983237,
  131088,
  1769854,
  1310994,
  1966516,
  2163173,
  2097624,
  1376553,
  1179903,
  393266,
  1835407,
  262172,
  786597,
  655481,
  196631,
  1638750,
  524368,
  1245445,
  1114350,
  917690,
  65536,
  721039,
  2032073,
  458813,
  1900963,
  1704295
};



Maybe<uint32_t>
PingByNameLookup(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   2,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
       0,   5,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  34,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  52,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,  18,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             sPingByNameLookupEntries);
  return ping_result_check(aKey, entry);
}


/**
 * Get a ping's name given its entry from the PHF.
 */
const char* GetPingName(ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  MOZ_ASSERT(idx < sizeof(gPingStringTable), "Ping index larger than string table");
  return &gPingStringTable[idx];
}

/**
 * Check if the found entry is pointing at the correct ping.
 * PHF can false-positive a result when the key isn't present, so we check
 * for a string match. If it fails, return Nothing(). If we found it,
 * return the ping's id.
 */
Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  uint32_t id = GLEAN_PING_ID(aEntry);

  if (MOZ_UNLIKELY(idx > sizeof(gPingStringTable))) {
    return Nothing();
  }

  if (aKey.EqualsASCII(&gPingStringTable[idx])) {
    return Some(id);
  }

  return Nothing();
}

#undef GLEAN_PING_INDEX_BITS
#undef GLEAN_PING_ID
#undef GLEAN_PING_INDEX

}  // namespace mozilla::glean
