/* Automatically generated by wasm2c */
#include <assert.h>
#include <math.h>
#include <stdarg.h>
#include <stddef.h>
#include <string.h>
#if defined(__MINGW32__)
#include <malloc.h>
#elif defined(_MSC_VER)
#include <intrin.h>
#include <malloc.h>
#define alloca _alloca
#elif defined(__FreeBSD__) || defined(__OpenBSD__)
#include <stdlib.h>
#else
#include <alloca.h>
#endif

#include "rlboxsoundtouch.wasm.h"
#define IS_SINGLE_UNSHARED_MEMORY 1

// Computes a pointer to an object of the given size in a little-endian memory.
//
// On a little-endian host, this is just &mem->data[addr] - the object's size is
// unused. On a big-endian host, it's &mem->data[mem->size - addr - n], where n
// is the object's size.
//
// Note that mem may be evaluated multiple times.
//
// Parameters:
// mem - The memory.
// addr - The address.
// n - The size of the object.
//
// Result:
// A pointer for an object of size n.
#if WABT_BIG_ENDIAN
#define MEM_ADDR(mem, addr, n) &(mem)->data[(mem)->size - (addr) - (n)]
#else
#define MEM_ADDR(mem, addr, n) &(mem)->data[addr]
#endif

// We can only use Segue for this module if it uses a single unshared imported
// or exported memory
#if WASM_RT_USE_SEGUE && IS_SINGLE_UNSHARED_MEMORY
#define WASM_RT_USE_SEGUE_FOR_THIS_MODULE 1
#else
#define WASM_RT_USE_SEGUE_FOR_THIS_MODULE 0
#endif

#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
// POSIX uses FS for TLS, GS is free
static inline void* wasm_rt_segue_read_base() {
  if (wasm_rt_fsgsbase_inst_supported) {
    return (void*)__builtin_ia32_rdgsbase64();
  } else {
    return wasm_rt_syscall_get_segue_base();
  }
}
static inline void wasm_rt_segue_write_base(void* base) {
#if WASM_RT_SEGUE_FREE_SEGMENT
  if (wasm_rt_last_segment_val == base) {
    return;
  }

  wasm_rt_last_segment_val = base;
#endif

  if (wasm_rt_fsgsbase_inst_supported) {
    __builtin_ia32_wrgsbase64((uintptr_t)base);
  } else {
    wasm_rt_syscall_set_segue_base(base);
  }
}
#define MEM_ADDR_MEMOP(mem, addr, n) ((uint8_t __seg_gs*)(uintptr_t)addr)
#else
#define MEM_ADDR_MEMOP(mem, addr, n) MEM_ADDR(mem, addr, n)
#endif

#define TRAP(x) (wasm_rt_trap(WASM_RT_TRAP_##x), 0)

#if WASM_RT_STACK_DEPTH_COUNT
#define FUNC_PROLOGUE                                            \
  if (++wasm_rt_call_stack_depth > WASM_RT_MAX_CALL_STACK_DEPTH) \
    TRAP(EXHAUSTION);

#define FUNC_EPILOGUE --wasm_rt_call_stack_depth
#else
#define FUNC_PROLOGUE

#define FUNC_EPILOGUE
#endif

#define UNREACHABLE TRAP(UNREACHABLE)

static inline bool func_types_eq(const wasm_rt_func_type_t a,
                                 const wasm_rt_func_type_t b) {
  return (a == b) || LIKELY(a && b && !memcmp(a, b, 32));
}

#define CHECK_CALL_INDIRECT(table, ft, x)                \
  (LIKELY((x) < table.size && table.data[x].func &&      \
          func_types_eq(ft, table.data[x].func_type)) || \
   TRAP(CALL_INDIRECT))

#define DO_CALL_INDIRECT(table, t, x, ...) ((t)table.data[x].func)(__VA_ARGS__)

#define CALL_INDIRECT(table, t, ft, x, ...) \
  (CHECK_CALL_INDIRECT(table, ft, x),       \
   DO_CALL_INDIRECT(table, t, x, __VA_ARGS__))

#ifdef SUPPORT_MEMORY64
#define RANGE_CHECK(mem, offset, len)              \
  do {                                             \
    uint64_t res;                                  \
    if (__builtin_add_overflow(offset, len, &res)) \
      TRAP(OOB);                                   \
    if (UNLIKELY(res > mem->size))                 \
      TRAP(OOB);                                   \
  } while (0);
#else
#define RANGE_CHECK(mem, offset, len)               \
  if (UNLIKELY(offset + (uint64_t)len > mem->size)) \
    TRAP(OOB);
#endif

#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && WASM_RT_SANITY_CHECKS
#include <stdio.h>
#define WASM_RT_CHECK_BASE(mem)                                               \
  if (((uintptr_t)((mem)->data)) != ((uintptr_t)wasm_rt_segue_read_base())) { \
    puts("Segment register mismatch\n");                                      \
    abort();                                                                  \
  }
#else
#define WASM_RT_CHECK_BASE(mem)
#endif

#if WASM_RT_MEMCHECK_GUARD_PAGES
#define MEMCHECK(mem, a, t) WASM_RT_CHECK_BASE(mem);
#else
#define MEMCHECK(mem, a, t) \
  WASM_RT_CHECK_BASE(mem);  \
  RANGE_CHECK(mem, a, sizeof(t))
#endif

#ifdef __GNUC__
#define FORCE_READ_INT(var) __asm__("" ::"r"(var));
// Clang on Mips requires "f" constraints on floats
// See https://github.com/llvm/llvm-project/issues/64241
#if defined(__clang__) && \
    (defined(mips) || defined(__mips__) || defined(__mips))
#define FORCE_READ_FLOAT(var) __asm__("" ::"f"(var));
#else
#define FORCE_READ_FLOAT(var) __asm__("" ::"r"(var));
#endif
#else
#define FORCE_READ_INT(var)
#define FORCE_READ_FLOAT(var)
#endif

static inline void load_data(void* dest, const void* src, size_t n) {
  if (!n) {
    return;
  }
  wasm_rt_memcpy(dest, src, n);
#if WABT_BIG_ENDIAN
  u8* dest_chars = dest;
  for (size_t i = 0; i < (n >> 1); i++) {
    u8 cursor = dest_chars[i];
    dest_chars[i] = dest_chars[n - i - 1];
    dest_chars[n - i - 1] = cursor;
  }
#endif
}

#define LOAD_DATA(m, o, i, s)            \
  do {                                   \
    RANGE_CHECK((&m), o, s);             \
    load_data(MEM_ADDR(&m, o, s), i, s); \
  } while (0)

#define DEFINE_LOAD(name, t1, t2, t3, force_read)                  \
  static inline t3 name(wasm_rt_memory_t* mem, u64 addr) {         \
    MEMCHECK(mem, addr, t1);                                       \
    t1 result;                                                     \
    wasm_rt_memcpy(&result, MEM_ADDR_MEMOP(mem, addr, sizeof(t1)), \
                   sizeof(t1));                                    \
    force_read(result);                                            \
    return (t3)(t2)result;                                         \
  }

#define DEFINE_STORE(name, t1, t2)                                     \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, t2 value) { \
    MEMCHECK(mem, addr, t1);                                           \
    t1 wrapped = (t1)value;                                            \
    wasm_rt_memcpy(MEM_ADDR_MEMOP(mem, addr, sizeof(t1)), &wrapped,    \
                   sizeof(t1));                                        \
  }

DEFINE_LOAD(i32_load, u32, u32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load, u64, u64, u64, FORCE_READ_INT)
DEFINE_LOAD(f32_load, f32, f32, f32, FORCE_READ_FLOAT)
DEFINE_LOAD(f64_load, f64, f64, f64, FORCE_READ_FLOAT)
DEFINE_LOAD(i32_load8_s, s8, s32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load8_s, s8, s64, u64, FORCE_READ_INT)
DEFINE_LOAD(i32_load8_u, u8, u32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load8_u, u8, u64, u64, FORCE_READ_INT)
DEFINE_LOAD(i32_load16_s, s16, s32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load16_s, s16, s64, u64, FORCE_READ_INT)
DEFINE_LOAD(i32_load16_u, u16, u32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load16_u, u16, u64, u64, FORCE_READ_INT)
DEFINE_LOAD(i64_load32_s, s32, s64, u64, FORCE_READ_INT)
DEFINE_LOAD(i64_load32_u, u32, u64, u64, FORCE_READ_INT)
DEFINE_STORE(i32_store, u32, u32)
DEFINE_STORE(i64_store, u64, u64)
DEFINE_STORE(f32_store, f32, f32)
DEFINE_STORE(f64_store, f64, f64)
DEFINE_STORE(i32_store8, u8, u32)
DEFINE_STORE(i32_store16, u16, u32)
DEFINE_STORE(i64_store8, u8, u64)
DEFINE_STORE(i64_store16, u16, u64)
DEFINE_STORE(i64_store32, u32, u64)

#if defined(_MSC_VER)

// Adapted from
// https://github.com/nemequ/portable-snippets/blob/master/builtin/builtin.h

static inline int I64_CLZ(unsigned long long v) {
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  if (_BitScanReverse64(&r, v)) {
    return 63 - r;
  }
#else
  if (_BitScanReverse(&r, (unsigned long)(v >> 32))) {
    return 31 - r;
  } else if (_BitScanReverse(&r, (unsigned long)v)) {
    return 63 - r;
  }
#endif
  return 64;
}

static inline int I32_CLZ(unsigned long v) {
  unsigned long r = 0;
  if (_BitScanReverse(&r, v)) {
    return 31 - r;
  }
  return 32;
}

static inline int I64_CTZ(unsigned long long v) {
  if (!v) {
    return 64;
  }
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  _BitScanForward64(&r, v);
  return (int)r;
#else
  if (_BitScanForward(&r, (unsigned int)(v))) {
    return (int)(r);
  }

  _BitScanForward(&r, (unsigned int)(v >> 32));
  return (int)(r + 32);
#endif
}

static inline int I32_CTZ(unsigned long v) {
  if (!v) {
    return 32;
  }
  unsigned long r = 0;
  _BitScanForward(&r, v);
  return (int)r;
}

#define POPCOUNT_DEFINE_PORTABLE(f_n, T)                            \
  static inline u32 f_n(T x) {                                      \
    x = x - ((x >> 1) & (T) ~(T)0 / 3);                             \
    x = (x & (T) ~(T)0 / 15 * 3) + ((x >> 2) & (T) ~(T)0 / 15 * 3); \
    x = (x + (x >> 4)) & (T) ~(T)0 / 255 * 15;                      \
    return (T)(x * ((T) ~(T)0 / 255)) >> (sizeof(T) - 1) * 8;       \
  }

POPCOUNT_DEFINE_PORTABLE(I32_POPCNT, u32)
POPCOUNT_DEFINE_PORTABLE(I64_POPCNT, u64)

#undef POPCOUNT_DEFINE_PORTABLE

#else

#define I32_CLZ(x) ((x) ? __builtin_clz(x) : 32)
#define I64_CLZ(x) ((x) ? __builtin_clzll(x) : 64)
#define I32_CTZ(x) ((x) ? __builtin_ctz(x) : 32)
#define I64_CTZ(x) ((x) ? __builtin_ctzll(x) : 64)
#define I32_POPCNT(x) (__builtin_popcount(x))
#define I64_POPCNT(x) (__builtin_popcountll(x))

#endif

#define DIV_S(ut, min, x, y)                                      \
  ((UNLIKELY((y) == 0))                                           \
       ? TRAP(DIV_BY_ZERO)                                        \
       : (UNLIKELY((x) == min && (y) == -1)) ? TRAP(INT_OVERFLOW) \
                                             : (ut)((x) / (y)))

#define REM_S(ut, min, x, y) \
  ((UNLIKELY((y) == 0))      \
       ? TRAP(DIV_BY_ZERO)   \
       : (UNLIKELY((x) == min && (y) == -1)) ? 0 : (ut)((x) % (y)))

#define I32_DIV_S(x, y) DIV_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_DIV_S(x, y) DIV_S(u64, INT64_MIN, (s64)x, (s64)y)
#define I32_REM_S(x, y) REM_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_REM_S(x, y) REM_S(u64, INT64_MIN, (s64)x, (s64)y)

#define DIVREM_U(op, x, y) \
  ((UNLIKELY((y) == 0)) ? TRAP(DIV_BY_ZERO) : ((x)op(y)))

#define DIV_U(x, y) DIVREM_U(/, x, y)
#define REM_U(x, y) DIVREM_U(%, x, y)

#define ROTL(x, y, mask) \
  (((x) << ((y) & (mask))) | ((x) >> (((mask) - (y) + 1) & (mask))))
#define ROTR(x, y, mask) \
  (((x) >> ((y) & (mask))) | ((x) << (((mask) - (y) + 1) & (mask))))

#define I32_ROTL(x, y) ROTL(x, y, 31)
#define I64_ROTL(x, y) ROTL(x, y, 63)
#define I32_ROTR(x, y) ROTR(x, y, 31)
#define I64_ROTR(x, y) ROTR(x, y, 63)

#define FMIN(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? x : y) \
                                                : (x < y) ? x : y)

#define FMAX(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? y : x) \
                                                : (x > y) ? x : y)

#define TRUNC_S(ut, st, ft, min, minop, max, x)                           \
  ((UNLIKELY((x) != (x)))                                                 \
       ? TRAP(INVALID_CONVERSION)                                         \
       : (UNLIKELY(!((x)minop(min) && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                     : (ut)(st)(x))

#define I32_TRUNC_S_F32(x) \
  TRUNC_S(u32, s32, f32, (f32)INT32_MIN, >=, 2147483648.f, x)
#define I64_TRUNC_S_F32(x) \
  TRUNC_S(u64, s64, f32, (f32)INT64_MIN, >=, (f32)INT64_MAX, x)
#define I32_TRUNC_S_F64(x) \
  TRUNC_S(u32, s32, f64, -2147483649., >, 2147483648., x)
#define I64_TRUNC_S_F64(x) \
  TRUNC_S(u64, s64, f64, (f64)INT64_MIN, >=, (f64)INT64_MAX, x)

#define TRUNC_U(ut, ft, max, x)                                          \
  ((UNLIKELY((x) != (x)))                                                \
       ? TRAP(INVALID_CONVERSION)                                        \
       : (UNLIKELY(!((x) > (ft)-1 && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                    : (ut)(x))

#define I32_TRUNC_U_F32(x) TRUNC_U(u32, f32, 4294967296.f, x)
#define I64_TRUNC_U_F32(x) TRUNC_U(u64, f32, (f32)UINT64_MAX, x)
#define I32_TRUNC_U_F64(x) TRUNC_U(u32, f64, 4294967296., x)
#define I64_TRUNC_U_F64(x) TRUNC_U(u64, f64, (f64)UINT64_MAX, x)

#define TRUNC_SAT_S(ut, st, ft, min, smin, minop, max, smax, x) \
  ((UNLIKELY((x) != (x)))                                       \
       ? 0                                                      \
       : (UNLIKELY(!((x)minop(min))))                           \
             ? smin                                             \
             : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(st)(x))

#define I32_TRUNC_SAT_S_F32(x)                                            \
  TRUNC_SAT_S(u32, s32, f32, (f32)INT32_MIN, INT32_MIN, >=, 2147483648.f, \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F32(x)                                              \
  TRUNC_SAT_S(u64, s64, f32, (f32)INT64_MIN, INT64_MIN, >=, (f32)INT64_MAX, \
              INT64_MAX, x)
#define I32_TRUNC_SAT_S_F64(x)                                        \
  TRUNC_SAT_S(u32, s32, f64, -2147483649., INT32_MIN, >, 2147483648., \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F64(x)                                              \
  TRUNC_SAT_S(u64, s64, f64, (f64)INT64_MIN, INT64_MIN, >=, (f64)INT64_MAX, \
              INT64_MAX, x)

#define TRUNC_SAT_U(ut, ft, max, smax, x)               \
  ((UNLIKELY((x) != (x))) ? 0                           \
                          : (UNLIKELY(!((x) > (ft)-1))) \
                                ? 0                     \
                                : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(x))

#define I32_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u32, f32, 4294967296.f, UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u64, f32, (f32)UINT64_MAX, UINT64_MAX, x)
#define I32_TRUNC_SAT_U_F64(x) TRUNC_SAT_U(u32, f64, 4294967296., UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F64(x) \
  TRUNC_SAT_U(u64, f64, (f64)UINT64_MAX, UINT64_MAX, x)

#define DEFINE_REINTERPRET(name, t1, t2)         \
  static inline t2 name(t1 x) {                  \
    t2 result;                                   \
    wasm_rt_memcpy(&result, &x, sizeof(result)); \
    return result;                               \
  }

DEFINE_REINTERPRET(f32_reinterpret_i32, u32, f32)
DEFINE_REINTERPRET(i32_reinterpret_f32, f32, u32)
DEFINE_REINTERPRET(f64_reinterpret_i64, u64, f64)
DEFINE_REINTERPRET(i64_reinterpret_f64, f64, u64)

static float quiet_nanf(float x) {
  uint32_t tmp;
  wasm_rt_memcpy(&tmp, &x, 4);
  tmp |= 0x7fc00000lu;
  wasm_rt_memcpy(&x, &tmp, 4);
  return x;
}

static double quiet_nan(double x) {
  uint64_t tmp;
  wasm_rt_memcpy(&tmp, &x, 8);
  tmp |= 0x7ff8000000000000llu;
  wasm_rt_memcpy(&x, &tmp, 8);
  return x;
}

static double wasm_quiet(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return x;
}

static float wasm_quietf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return x;
}

static double wasm_floor(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return floor(x);
}

static float wasm_floorf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return floorf(x);
}

static double wasm_ceil(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return ceil(x);
}

static float wasm_ceilf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return ceilf(x);
}

static double wasm_trunc(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return trunc(x);
}

static float wasm_truncf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return truncf(x);
}

static float wasm_nearbyintf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return nearbyintf(x);
}

static double wasm_nearbyint(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return nearbyint(x);
}

static float wasm_fabsf(float x) {
  if (UNLIKELY(isnan(x))) {
    uint32_t tmp;
    wasm_rt_memcpy(&tmp, &x, 4);
    tmp = tmp & ~(1UL << 31);
    wasm_rt_memcpy(&x, &tmp, 4);
    return x;
  }
  return fabsf(x);
}

static double wasm_fabs(double x) {
  if (UNLIKELY(isnan(x))) {
    uint64_t tmp;
    wasm_rt_memcpy(&tmp, &x, 8);
    tmp = tmp & ~(1ULL << 63);
    wasm_rt_memcpy(&x, &tmp, 8);
    return x;
  }
  return fabs(x);
}

static double wasm_sqrt(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return sqrt(x);
}

static float wasm_sqrtf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return sqrtf(x);
}

static inline void memory_fill(wasm_rt_memory_t* mem, u32 d, u32 val, u32 n) {
  RANGE_CHECK(mem, d, n);
  memset(MEM_ADDR(mem, d, n), val, n);
}

static inline void memory_copy(wasm_rt_memory_t* dest,
                               const wasm_rt_memory_t* src,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  RANGE_CHECK(dest, dest_addr, n);
  RANGE_CHECK(src, src_addr, n);
  memmove(MEM_ADDR(dest, dest_addr, n), MEM_ADDR(src, src_addr, n), n);
}

static inline void memory_init(wasm_rt_memory_t* dest,
                               const u8* src,
                               u32 src_size,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  LOAD_DATA((*dest), dest_addr, src + src_addr, n);
}

typedef struct {
  enum { RefFunc, RefNull, GlobalGet } expr_type;
  wasm_rt_func_type_t type;
  wasm_rt_function_ptr_t func;
  wasm_rt_tailcallee_t func_tailcallee;
  size_t module_offset;
} wasm_elem_segment_expr_t;

static inline void funcref_table_init(wasm_rt_funcref_table_t* dest,
                                      const wasm_elem_segment_expr_t* src,
                                      u32 src_size,
                                      u32 dest_addr,
                                      u32 src_addr,
                                      u32 n,
                                      void* module_instance) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    const wasm_elem_segment_expr_t* const src_expr = &src[src_addr + i];
    wasm_rt_funcref_t* const dest_val = &(dest->data[dest_addr + i]);
    switch (src_expr->expr_type) {
      case RefFunc:
        *dest_val = (wasm_rt_funcref_t){
            src_expr->type, src_expr->func, src_expr->func_tailcallee,
            (char*)module_instance + src_expr->module_offset};
        break;
      case RefNull:
        *dest_val = wasm_rt_funcref_null_value;
        break;
      case GlobalGet:
        *dest_val = **(wasm_rt_funcref_t**)((char*)module_instance +
                                            src_expr->module_offset);
        break;
    }
  }
}

// Currently wasm2c only supports initializing externref tables with ref.null.
static inline void externref_table_init(wasm_rt_externref_table_t* dest,
                                        u32 src_size,
                                        u32 dest_addr,
                                        u32 src_addr,
                                        u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    dest->data[dest_addr + i] = wasm_rt_externref_null_value;
  }
}

#define DEFINE_TABLE_COPY(type)                                              \
  static inline void type##_table_copy(wasm_rt_##type##_table_t* dest,       \
                                       const wasm_rt_##type##_table_t* src,  \
                                       u32 dest_addr, u32 src_addr, u32 n) { \
    if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))                      \
      TRAP(OOB);                                                             \
    if (UNLIKELY(src_addr + (uint64_t)n > src->size))                        \
      TRAP(OOB);                                                             \
                                                                             \
    memmove(dest->data + dest_addr, src->data + src_addr,                    \
            n * sizeof(wasm_rt_##type##_t));                                 \
  }

DEFINE_TABLE_COPY(funcref)
DEFINE_TABLE_COPY(externref)

#define DEFINE_TABLE_GET(type)                        \
  static inline wasm_rt_##type##_t type##_table_get(  \
      const wasm_rt_##type##_table_t* table, u32 i) { \
    if (UNLIKELY(i >= table->size))                   \
      TRAP(OOB);                                      \
    return table->data[i];                            \
  }

DEFINE_TABLE_GET(funcref)
DEFINE_TABLE_GET(externref)

#define DEFINE_TABLE_SET(type)                                               \
  static inline void type##_table_set(const wasm_rt_##type##_table_t* table, \
                                      u32 i, const wasm_rt_##type##_t val) { \
    if (UNLIKELY(i >= table->size))                                          \
      TRAP(OOB);                                                             \
    table->data[i] = val;                                                    \
  }

DEFINE_TABLE_SET(funcref)
DEFINE_TABLE_SET(externref)

#define DEFINE_TABLE_FILL(type)                                               \
  static inline void type##_table_fill(const wasm_rt_##type##_table_t* table, \
                                       u32 d, const wasm_rt_##type##_t val,   \
                                       u32 n) {                               \
    if (UNLIKELY((uint64_t)d + n > table->size))                              \
      TRAP(OOB);                                                              \
    for (uint32_t i = d; i < d + n; i++) {                                    \
      table->data[i] = val;                                                   \
    }                                                                         \
  }

DEFINE_TABLE_FILL(funcref)
DEFINE_TABLE_FILL(externref)

#if defined(__GNUC__) || defined(__clang__)
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char* const x
#define FUNC_TYPE_EXTERN_T(x) const char* const x
#define FUNC_TYPE_T(x) static const char* const x
#else
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char x[]
#define FUNC_TYPE_EXTERN_T(x) const char x[]
#define FUNC_TYPE_T(x) static const char x[]
#endif

#if (__STDC_VERSION__ < 201112L) && !defined(static_assert)
#define static_assert(X) \
  extern int(*assertion(void))[!!sizeof(struct { int x : (X) ? 2 : -1; })];
#endif

#ifdef _MSC_VER
#define WEAK_FUNC_DECL(func, fallback)                             \
  __pragma(comment(linker, "/alternatename:" #func "=" #fallback)) \
                                                                   \
      void                                                         \
      fallback(void** instance_ptr, void* tail_call_stack,         \
               wasm_rt_tailcallee_t* next)
#else
#define WEAK_FUNC_DECL(func, fallback)                                        \
  __attribute__((weak)) void func(void** instance_ptr, void* tail_call_stack, \
                                  wasm_rt_tailcallee_t* next)
#endif

#include <simde/wasm/simd128.h>

#ifndef WASM_RT_SIMD_TYPE_DEFINED
#define WASM_RT_SIMD_TYPE_DEFINED
typedef simde_v128_t v128;
#endif

#if defined(__GNUC__) && defined(__x86_64__)
#define SIMD_FORCE_READ(var) __asm__("" ::"x"(var));
#elif defined(__GNUC__) && defined(__aarch64__)
#define SIMD_FORCE_READ(var) __asm__("" ::"w"(var));
#else
#define SIMD_FORCE_READ(var)
#endif
// TODO: equivalent constraint for ARM and other architectures

#define DEFINE_SIMD_LOAD_FUNC(name, func, t)                 \
  static inline v128 name(wasm_rt_memory_t* mem, u64 addr) { \
    MEMCHECK(mem, addr, t);                                  \
    v128 result = func(MEM_ADDR(mem, addr, sizeof(t)));      \
    SIMD_FORCE_READ(result);                                 \
    return result;                                           \
  }

#define DEFINE_SIMD_LOAD_LANE(name, func, t, lane)                     \
  static inline v128 name(wasm_rt_memory_t* mem, u64 addr, v128 vec) { \
    MEMCHECK(mem, addr, t);                                            \
    v128 result = func(MEM_ADDR(mem, addr, sizeof(t)), vec, lane);     \
    SIMD_FORCE_READ(result);                                           \
    return result;                                                     \
  }

#define DEFINE_SIMD_STORE(name, t)                                       \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, v128 value) { \
    MEMCHECK(mem, addr, t);                                              \
    simde_wasm_v128_store(MEM_ADDR(mem, addr, sizeof(t)), value);        \
  }

#define DEFINE_SIMD_STORE_LANE(name, func, t, lane)                      \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, v128 value) { \
    MEMCHECK(mem, addr, t);                                              \
    func(MEM_ADDR(mem, addr, sizeof(t)), value, lane);                   \
  }

// clang-format off
#if WABT_BIG_ENDIAN
static inline v128 v128_impl_load32_zero(const void* a) {
  return simde_wasm_i8x16_swizzle(
      simde_wasm_v128_load32_zero(a),
      simde_wasm_i8x16_const(12,13,14,15,8,9,10,11,4,5,6,7,0,1,2,3));
}
static inline v128 v128_impl_load64_zero(const void* a) {
  return simde_wasm_i8x16_swizzle(
      simde_wasm_v128_load64_zero(a),
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7));
}
#else
#define v128_impl_load32_zero simde_wasm_v128_load32_zero
#define v128_impl_load64_zero simde_wasm_v128_load64_zero
#endif

DEFINE_SIMD_LOAD_FUNC(v128_load, simde_wasm_v128_load, v128)

DEFINE_SIMD_LOAD_FUNC(v128_load8_splat, simde_wasm_v128_load8_splat, u8)
DEFINE_SIMD_LOAD_FUNC(v128_load16_splat, simde_wasm_v128_load16_splat, u16)
DEFINE_SIMD_LOAD_FUNC(v128_load32_splat, simde_wasm_v128_load32_splat, u32)
DEFINE_SIMD_LOAD_FUNC(v128_load64_splat, simde_wasm_v128_load64_splat, u64)

DEFINE_SIMD_LOAD_FUNC(i16x8_load8x8, simde_wasm_i16x8_load8x8, u64)
DEFINE_SIMD_LOAD_FUNC(u16x8_load8x8, simde_wasm_u16x8_load8x8, u64)
DEFINE_SIMD_LOAD_FUNC(i32x4_load16x4, simde_wasm_i32x4_load16x4, u64)
DEFINE_SIMD_LOAD_FUNC(u32x4_load16x4, simde_wasm_u32x4_load16x4, u64)
DEFINE_SIMD_LOAD_FUNC(i64x2_load32x2, simde_wasm_i64x2_load32x2, u64)
DEFINE_SIMD_LOAD_FUNC(u64x2_load32x2, simde_wasm_u64x2_load32x2, u64)

DEFINE_SIMD_LOAD_FUNC(v128_load32_zero, v128_impl_load32_zero, u32)
DEFINE_SIMD_LOAD_FUNC(v128_load64_zero, v128_impl_load64_zero, u64)

#if WABT_BIG_ENDIAN
DEFINE_SIMD_LOAD_LANE(v128_load8_lane0, simde_wasm_v128_load8_lane, u8, 15)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane1, simde_wasm_v128_load8_lane, u8, 14)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane2, simde_wasm_v128_load8_lane, u8, 13)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane3, simde_wasm_v128_load8_lane, u8, 12)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane4, simde_wasm_v128_load8_lane, u8, 11)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane5, simde_wasm_v128_load8_lane, u8, 10)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane6, simde_wasm_v128_load8_lane, u8, 9)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane7, simde_wasm_v128_load8_lane, u8, 8)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane8, simde_wasm_v128_load8_lane, u8, 7)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane9, simde_wasm_v128_load8_lane, u8, 6)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane10, simde_wasm_v128_load8_lane, u8, 5)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane11, simde_wasm_v128_load8_lane, u8, 4)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane12, simde_wasm_v128_load8_lane, u8, 3)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane13, simde_wasm_v128_load8_lane, u8, 2)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane14, simde_wasm_v128_load8_lane, u8, 1)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane15, simde_wasm_v128_load8_lane, u8, 0)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane0, simde_wasm_v128_load16_lane, u16, 7)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane1, simde_wasm_v128_load16_lane, u16, 6)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane2, simde_wasm_v128_load16_lane, u16, 5)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane3, simde_wasm_v128_load16_lane, u16, 4)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane4, simde_wasm_v128_load16_lane, u16, 3)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane5, simde_wasm_v128_load16_lane, u16, 2)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane6, simde_wasm_v128_load16_lane, u16, 1)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane7, simde_wasm_v128_load16_lane, u16, 0)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane0, simde_wasm_v128_load32_lane, u32, 3)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane1, simde_wasm_v128_load32_lane, u32, 2)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane2, simde_wasm_v128_load32_lane, u32, 1)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane3, simde_wasm_v128_load32_lane, u32, 0)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane0, simde_wasm_v128_load64_lane, u64, 1)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane1, simde_wasm_v128_load64_lane, u64, 0)
#else
DEFINE_SIMD_LOAD_LANE(v128_load8_lane0, simde_wasm_v128_load8_lane, u8, 0)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane1, simde_wasm_v128_load8_lane, u8, 1)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane2, simde_wasm_v128_load8_lane, u8, 2)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane3, simde_wasm_v128_load8_lane, u8, 3)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane4, simde_wasm_v128_load8_lane, u8, 4)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane5, simde_wasm_v128_load8_lane, u8, 5)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane6, simde_wasm_v128_load8_lane, u8, 6)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane7, simde_wasm_v128_load8_lane, u8, 7)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane8, simde_wasm_v128_load8_lane, u8, 8)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane9, simde_wasm_v128_load8_lane, u8, 9)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane10, simde_wasm_v128_load8_lane, u8, 10)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane11, simde_wasm_v128_load8_lane, u8, 11)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane12, simde_wasm_v128_load8_lane, u8, 12)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane13, simde_wasm_v128_load8_lane, u8, 13)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane14, simde_wasm_v128_load8_lane, u8, 14)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane15, simde_wasm_v128_load8_lane, u8, 15)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane0, simde_wasm_v128_load16_lane, u16, 0)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane1, simde_wasm_v128_load16_lane, u16, 1)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane2, simde_wasm_v128_load16_lane, u16, 2)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane3, simde_wasm_v128_load16_lane, u16, 3)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane4, simde_wasm_v128_load16_lane, u16, 4)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane5, simde_wasm_v128_load16_lane, u16, 5)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane6, simde_wasm_v128_load16_lane, u16, 6)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane7, simde_wasm_v128_load16_lane, u16, 7)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane0, simde_wasm_v128_load32_lane, u32, 0)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane1, simde_wasm_v128_load32_lane, u32, 1)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane2, simde_wasm_v128_load32_lane, u32, 2)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane3, simde_wasm_v128_load32_lane, u32, 3)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane0, simde_wasm_v128_load64_lane, u64, 0)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane1, simde_wasm_v128_load64_lane, u64, 1)
#endif

DEFINE_SIMD_STORE(v128_store, v128)

#if WABT_BIG_ENDIAN
DEFINE_SIMD_STORE_LANE(v128_store8_lane0, simde_wasm_v128_store8_lane, u8, 15)
DEFINE_SIMD_STORE_LANE(v128_store8_lane1, simde_wasm_v128_store8_lane, u8, 14)
DEFINE_SIMD_STORE_LANE(v128_store8_lane2, simde_wasm_v128_store8_lane, u8, 13)
DEFINE_SIMD_STORE_LANE(v128_store8_lane3, simde_wasm_v128_store8_lane, u8, 12)
DEFINE_SIMD_STORE_LANE(v128_store8_lane4, simde_wasm_v128_store8_lane, u8, 11)
DEFINE_SIMD_STORE_LANE(v128_store8_lane5, simde_wasm_v128_store8_lane, u8, 10)
DEFINE_SIMD_STORE_LANE(v128_store8_lane6, simde_wasm_v128_store8_lane, u8, 9)
DEFINE_SIMD_STORE_LANE(v128_store8_lane7, simde_wasm_v128_store8_lane, u8, 8)
DEFINE_SIMD_STORE_LANE(v128_store8_lane8, simde_wasm_v128_store8_lane, u8, 7)
DEFINE_SIMD_STORE_LANE(v128_store8_lane9, simde_wasm_v128_store8_lane, u8, 6)
DEFINE_SIMD_STORE_LANE(v128_store8_lane10, simde_wasm_v128_store8_lane, u8, 5)
DEFINE_SIMD_STORE_LANE(v128_store8_lane11, simde_wasm_v128_store8_lane, u8, 4)
DEFINE_SIMD_STORE_LANE(v128_store8_lane12, simde_wasm_v128_store8_lane, u8, 3)
DEFINE_SIMD_STORE_LANE(v128_store8_lane13, simde_wasm_v128_store8_lane, u8, 2)
DEFINE_SIMD_STORE_LANE(v128_store8_lane14, simde_wasm_v128_store8_lane, u8, 1)
DEFINE_SIMD_STORE_LANE(v128_store8_lane15, simde_wasm_v128_store8_lane, u8, 0)
DEFINE_SIMD_STORE_LANE(v128_store16_lane0, simde_wasm_v128_store16_lane, u16, 7)
DEFINE_SIMD_STORE_LANE(v128_store16_lane1, simde_wasm_v128_store16_lane, u16, 6)
DEFINE_SIMD_STORE_LANE(v128_store16_lane2, simde_wasm_v128_store16_lane, u16, 5)
DEFINE_SIMD_STORE_LANE(v128_store16_lane3, simde_wasm_v128_store16_lane, u16, 4)
DEFINE_SIMD_STORE_LANE(v128_store16_lane4, simde_wasm_v128_store16_lane, u16, 3)
DEFINE_SIMD_STORE_LANE(v128_store16_lane5, simde_wasm_v128_store16_lane, u16, 2)
DEFINE_SIMD_STORE_LANE(v128_store16_lane6, simde_wasm_v128_store16_lane, u16, 1)
DEFINE_SIMD_STORE_LANE(v128_store16_lane7, simde_wasm_v128_store16_lane, u16, 0)
DEFINE_SIMD_STORE_LANE(v128_store32_lane0, simde_wasm_v128_store32_lane, u32, 3)
DEFINE_SIMD_STORE_LANE(v128_store32_lane1, simde_wasm_v128_store32_lane, u32, 2)
DEFINE_SIMD_STORE_LANE(v128_store32_lane2, simde_wasm_v128_store32_lane, u32, 1)
DEFINE_SIMD_STORE_LANE(v128_store32_lane3, simde_wasm_v128_store32_lane, u32, 0)
DEFINE_SIMD_STORE_LANE(v128_store64_lane0, simde_wasm_v128_store64_lane, u64, 1)
DEFINE_SIMD_STORE_LANE(v128_store64_lane1, simde_wasm_v128_store64_lane, u64, 0)
#else
DEFINE_SIMD_STORE_LANE(v128_store8_lane0, simde_wasm_v128_store8_lane, u8, 0)
DEFINE_SIMD_STORE_LANE(v128_store8_lane1, simde_wasm_v128_store8_lane, u8, 1)
DEFINE_SIMD_STORE_LANE(v128_store8_lane2, simde_wasm_v128_store8_lane, u8, 2)
DEFINE_SIMD_STORE_LANE(v128_store8_lane3, simde_wasm_v128_store8_lane, u8, 3)
DEFINE_SIMD_STORE_LANE(v128_store8_lane4, simde_wasm_v128_store8_lane, u8, 4)
DEFINE_SIMD_STORE_LANE(v128_store8_lane5, simde_wasm_v128_store8_lane, u8, 5)
DEFINE_SIMD_STORE_LANE(v128_store8_lane6, simde_wasm_v128_store8_lane, u8, 6)
DEFINE_SIMD_STORE_LANE(v128_store8_lane7, simde_wasm_v128_store8_lane, u8, 7)
DEFINE_SIMD_STORE_LANE(v128_store8_lane8, simde_wasm_v128_store8_lane, u8, 8)
DEFINE_SIMD_STORE_LANE(v128_store8_lane9, simde_wasm_v128_store8_lane, u8, 9)
DEFINE_SIMD_STORE_LANE(v128_store8_lane10, simde_wasm_v128_store8_lane, u8, 10)
DEFINE_SIMD_STORE_LANE(v128_store8_lane11, simde_wasm_v128_store8_lane, u8, 11)
DEFINE_SIMD_STORE_LANE(v128_store8_lane12, simde_wasm_v128_store8_lane, u8, 12)
DEFINE_SIMD_STORE_LANE(v128_store8_lane13, simde_wasm_v128_store8_lane, u8, 13)
DEFINE_SIMD_STORE_LANE(v128_store8_lane14, simde_wasm_v128_store8_lane, u8, 14)
DEFINE_SIMD_STORE_LANE(v128_store8_lane15, simde_wasm_v128_store8_lane, u8, 15)
DEFINE_SIMD_STORE_LANE(v128_store16_lane0, simde_wasm_v128_store16_lane, u16, 0)
DEFINE_SIMD_STORE_LANE(v128_store16_lane1, simde_wasm_v128_store16_lane, u16, 1)
DEFINE_SIMD_STORE_LANE(v128_store16_lane2, simde_wasm_v128_store16_lane, u16, 2)
DEFINE_SIMD_STORE_LANE(v128_store16_lane3, simde_wasm_v128_store16_lane, u16, 3)
DEFINE_SIMD_STORE_LANE(v128_store16_lane4, simde_wasm_v128_store16_lane, u16, 4)
DEFINE_SIMD_STORE_LANE(v128_store16_lane5, simde_wasm_v128_store16_lane, u16, 5)
DEFINE_SIMD_STORE_LANE(v128_store16_lane6, simde_wasm_v128_store16_lane, u16, 6)
DEFINE_SIMD_STORE_LANE(v128_store16_lane7, simde_wasm_v128_store16_lane, u16, 7)
DEFINE_SIMD_STORE_LANE(v128_store32_lane0, simde_wasm_v128_store32_lane, u32, 0)
DEFINE_SIMD_STORE_LANE(v128_store32_lane1, simde_wasm_v128_store32_lane, u32, 1)
DEFINE_SIMD_STORE_LANE(v128_store32_lane2, simde_wasm_v128_store32_lane, u32, 2)
DEFINE_SIMD_STORE_LANE(v128_store32_lane3, simde_wasm_v128_store32_lane, u32, 3)
DEFINE_SIMD_STORE_LANE(v128_store64_lane0, simde_wasm_v128_store64_lane, u64, 0)
DEFINE_SIMD_STORE_LANE(v128_store64_lane1, simde_wasm_v128_store64_lane, u64, 1)
#endif

#if WABT_BIG_ENDIAN
#define v128_const(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) simde_wasm_i8x16_const(p,o,n,m,l,k,j,i,h,g,f,e,d,c,b,a)
#define v128_i8x16_extract_lane(v, l) simde_wasm_i8x16_extract_lane(v, 15-(l))
#define v128_u8x16_extract_lane(v, l) simde_wasm_u8x16_extract_lane(v, 15-(l))
#define v128_i16x8_extract_lane(v, l) simde_wasm_i16x8_extract_lane(v, 7-(l))
#define v128_u16x8_extract_lane(v, l) simde_wasm_u16x8_extract_lane(v, 7-(l))
#define v128_i32x4_extract_lane(v, l) simde_wasm_i32x4_extract_lane(v, 3-(l))
#define v128_i64x2_extract_lane(v, l) simde_wasm_i64x2_extract_lane(v, 1-(l))
#define v128_f32x4_extract_lane(v, l) simde_wasm_f32x4_extract_lane(v, 3-(l))
#define v128_f64x2_extract_lane(v, l) simde_wasm_f64x2_extract_lane(v, 1-(l))
#define v128_i8x16_replace_lane(v, l, x) simde_wasm_i8x16_replace_lane(v, 15-(l), x)
#define v128_u8x16_replace_lane(v, l, x) simde_wasm_u8x16_replace_lane(v, 15-(l), x)
#define v128_i16x8_replace_lane(v, l, x) simde_wasm_i16x8_replace_lane(v, 7-(l), x)
#define v128_u16x8_replace_lane(v, l, x) simde_wasm_u16x8_replace_lane(v, 7-(l), x)
#define v128_i32x4_replace_lane(v, l, x) simde_wasm_i32x4_replace_lane(v, 3-(l), x)
#define v128_i64x2_replace_lane(v, l, x) simde_wasm_i64x2_replace_lane(v, 1-(l), x)
#define v128_f32x4_replace_lane(v, l, x) simde_wasm_f32x4_replace_lane(v, 3-(l), x)
#define v128_f64x2_replace_lane(v, l, x) simde_wasm_f64x2_replace_lane(v, 1-(l), x)
#define v128_i8x16_bitmask(v) simde_wasm_i8x16_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0)))
#define v128_i16x8_bitmask(v) simde_wasm_i16x8_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(14,15,12,13,10,11,8,9,6,7,4,5,2,3,0,1)))
#define v128_i32x4_bitmask(v) simde_wasm_i32x4_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(12,13,14,15,8,9,10,11,4,5,6,7,0,1,2,3)))
#define v128_i64x2_bitmask(v) simde_wasm_i64x2_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#define v128_i8x16_swizzle(v1, v2) simde_wasm_i8x16_swizzle(v1, simde_wasm_v128_xor(v2, simde_wasm_i8x16_splat(15)))
#define v128_i8x16_shuffle(v1,v2,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) simde_wasm_i8x16_shuffle(v2,v1,31-(p),31-(o),31-(n),31-(m),31-(l),31-(k),31-(j),31-(i),31-(h),31-(g),31-(f),31-(e),31-(d),31-(c),31-(b),31-(a))
#define v128_i16x8_extmul_high_i8x16 simde_wasm_i16x8_extmul_low_i8x16
#define v128_u16x8_extmul_high_u8x16 simde_wasm_u16x8_extmul_low_u8x16
#define v128_i16x8_extmul_low_i8x16  simde_wasm_i16x8_extmul_high_i8x16
#define v128_u16x8_extmul_low_u8x16  simde_wasm_u16x8_extmul_high_u8x16
#define v128_i32x4_extmul_high_i16x8 simde_wasm_i32x4_extmul_low_i16x8
#define v128_u32x4_extmul_high_u16x8 simde_wasm_u32x4_extmul_low_u16x8
#define v128_i32x4_extmul_low_i16x8  simde_wasm_i32x4_extmul_high_i16x8
#define v128_u32x4_extmul_low_u16x8  simde_wasm_u32x4_extmul_high_u16x8
#define v128_i64x2_extmul_high_i32x4 simde_wasm_i64x2_extmul_low_i32x4
#define v128_u64x2_extmul_high_u32x4 simde_wasm_u64x2_extmul_low_u32x4
#define v128_i64x2_extmul_low_i32x4  simde_wasm_i64x2_extmul_high_i32x4
#define v128_u64x2_extmul_low_u32x4  simde_wasm_u64x2_extmul_high_u32x4
#define v128_i16x8_extend_high_i8x16 simde_wasm_i16x8_extend_low_i8x16
#define v128_u16x8_extend_high_u8x16 simde_wasm_u16x8_extend_low_u8x16
#define v128_i16x8_extend_low_i8x16  simde_wasm_i16x8_extend_high_i8x16
#define v128_u16x8_extend_low_u8x16  simde_wasm_u16x8_extend_high_u8x16
#define v128_i32x4_extend_high_i16x8 simde_wasm_i32x4_extend_low_i16x8
#define v128_u32x4_extend_high_u16x8 simde_wasm_u32x4_extend_low_u16x8
#define v128_i32x4_extend_low_i16x8  simde_wasm_i32x4_extend_high_i16x8
#define v128_u32x4_extend_low_u16x8  simde_wasm_u32x4_extend_high_u16x8
#define v128_i64x2_extend_high_i32x4 simde_wasm_i64x2_extend_low_i32x4
#define v128_u64x2_extend_high_u32x4 simde_wasm_u64x2_extend_low_u32x4
#define v128_i64x2_extend_low_i32x4  simde_wasm_i64x2_extend_high_i32x4
#define v128_u64x2_extend_low_u32x4  simde_wasm_u64x2_extend_high_u32x4
#define v128_i32x4_trunc_sat_f64x2_zero(a)      \
  simde_wasm_i8x16_swizzle(                     \
      simde_wasm_i32x4_trunc_sat_f64x2_zero(a), \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7))
#define v128_u32x4_trunc_sat_f64x2_zero(a)      \
  simde_wasm_i8x16_swizzle(                     \
      simde_wasm_u32x4_trunc_sat_f64x2_zero(a), \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7))
#define v128_i16x8_narrow_i32x4(a,b) simde_wasm_i16x8_narrow_i32x4(b,a)
#define v128_u16x8_narrow_i32x4(a,b) simde_wasm_u16x8_narrow_i32x4(b,a)
#define v128_i8x16_narrow_i16x8(a,b) simde_wasm_i8x16_narrow_i16x8(b,a)
#define v128_u8x16_narrow_i16x8(a,b) simde_wasm_u8x16_narrow_i16x8(b,a)
#define v128_f64x2_promote_low_f32x4(a)                        \
  simde_wasm_f64x2_promote_low_f32x4(simde_wasm_i8x16_swizzle( \
      a,                                                       \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#define v128_f32x4_demote_f64x2_zero(a)      \
  simde_wasm_i8x16_swizzle(                  \
      simde_wasm_f32x4_demote_f64x2_zero(a), \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7))
#define v128_f64x2_convert_low_i32x4(a)                        \
  simde_wasm_f64x2_convert_low_i32x4(simde_wasm_i8x16_swizzle( \
      a,                                                       \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#define v128_f64x2_convert_low_u32x4(a)                        \
  simde_wasm_f64x2_convert_low_u32x4(simde_wasm_i8x16_swizzle( \
      a,                                                       \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#else
#define v128_const simde_wasm_i8x16_const
#define v128_i8x16_extract_lane simde_wasm_i8x16_extract_lane
#define v128_u8x16_extract_lane simde_wasm_u8x16_extract_lane
#define v128_i16x8_extract_lane simde_wasm_i16x8_extract_lane
#define v128_u16x8_extract_lane simde_wasm_u16x8_extract_lane
#define v128_i32x4_extract_lane simde_wasm_i32x4_extract_lane
#define v128_i64x2_extract_lane simde_wasm_i64x2_extract_lane
#define v128_f32x4_extract_lane simde_wasm_f32x4_extract_lane
#define v128_f64x2_extract_lane simde_wasm_f64x2_extract_lane
#define v128_i8x16_replace_lane simde_wasm_i8x16_replace_lane
#define v128_u8x16_replace_lane simde_wasm_u8x16_replace_lane
#define v128_i16x8_replace_lane simde_wasm_i16x8_replace_lane
#define v128_u16x8_replace_lane simde_wasm_u16x8_replace_lane
#define v128_i32x4_replace_lane simde_wasm_i32x4_replace_lane
#define v128_i64x2_replace_lane simde_wasm_i64x2_replace_lane
#define v128_f32x4_replace_lane simde_wasm_f32x4_replace_lane
#define v128_f64x2_replace_lane simde_wasm_f64x2_replace_lane
#define v128_i8x16_bitmask simde_wasm_i8x16_bitmask
#define v128_i16x8_bitmask simde_wasm_i16x8_bitmask
#define v128_i32x4_bitmask simde_wasm_i32x4_bitmask
#define v128_i64x2_bitmask simde_wasm_i64x2_bitmask
#define v128_i8x16_swizzle simde_wasm_i8x16_swizzle
#define v128_i8x16_shuffle simde_wasm_i8x16_shuffle
#define v128_i16x8_extmul_high_i8x16 simde_wasm_i16x8_extmul_high_i8x16
#define v128_u16x8_extmul_high_u8x16 simde_wasm_u16x8_extmul_high_u8x16
#define v128_i16x8_extmul_low_i8x16  simde_wasm_i16x8_extmul_low_i8x16
#define v128_u16x8_extmul_low_u8x16  simde_wasm_u16x8_extmul_low_u8x16
#define v128_i32x4_extmul_high_i16x8 simde_wasm_i32x4_extmul_high_i16x8
#define v128_u32x4_extmul_high_u16x8 simde_wasm_u32x4_extmul_high_u16x8
#define v128_i32x4_extmul_low_i16x8  simde_wasm_i32x4_extmul_low_i16x8
#define v128_u32x4_extmul_low_u16x8  simde_wasm_u32x4_extmul_low_u16x8
#define v128_i64x2_extmul_high_i32x4 simde_wasm_i64x2_extmul_high_i32x4
#define v128_u64x2_extmul_high_u32x4 simde_wasm_u64x2_extmul_high_u32x4
#define v128_i64x2_extmul_low_i32x4  simde_wasm_i64x2_extmul_low_i32x4
#define v128_u64x2_extmul_low_u32x4  simde_wasm_u64x2_extmul_low_u32x4
#define v128_i16x8_extend_high_i8x16 simde_wasm_i16x8_extend_high_i8x16
#define v128_u16x8_extend_high_u8x16 simde_wasm_u16x8_extend_high_u8x16
#define v128_i16x8_extend_low_i8x16  simde_wasm_i16x8_extend_low_i8x16
#define v128_u16x8_extend_low_u8x16  simde_wasm_u16x8_extend_low_u8x16
#define v128_i32x4_extend_high_i16x8 simde_wasm_i32x4_extend_high_i16x8
#define v128_u32x4_extend_high_u16x8 simde_wasm_u32x4_extend_high_u16x8
#define v128_i32x4_extend_low_i16x8  simde_wasm_i32x4_extend_low_i16x8
#define v128_u32x4_extend_low_u16x8  simde_wasm_u32x4_extend_low_u16x8
#define v128_i64x2_extend_high_i32x4 simde_wasm_i64x2_extend_high_i32x4
#define v128_u64x2_extend_high_u32x4 simde_wasm_u64x2_extend_high_u32x4
#define v128_i64x2_extend_low_i32x4  simde_wasm_i64x2_extend_low_i32x4
#define v128_u64x2_extend_low_u32x4  simde_wasm_u64x2_extend_low_u32x4
#define v128_i32x4_trunc_sat_f64x2_zero simde_wasm_i32x4_trunc_sat_f64x2_zero
#define v128_u32x4_trunc_sat_f64x2_zero simde_wasm_u32x4_trunc_sat_f64x2_zero
#define v128_i16x8_narrow_i32x4 simde_wasm_i16x8_narrow_i32x4
#define v128_u16x8_narrow_i32x4 simde_wasm_u16x8_narrow_i32x4
#define v128_i8x16_narrow_i16x8 simde_wasm_i8x16_narrow_i16x8
#define v128_u8x16_narrow_i16x8 simde_wasm_u8x16_narrow_i16x8
#define v128_f64x2_promote_low_f32x4 simde_wasm_f64x2_promote_low_f32x4
#define v128_f32x4_demote_f64x2_zero simde_wasm_f32x4_demote_f64x2_zero
#define v128_f64x2_convert_low_i32x4 simde_wasm_f64x2_convert_low_i32x4
#define v128_f64x2_convert_low_u32x4 simde_wasm_f64x2_convert_low_u32x4
#endif
// clang-format on


static void w2c_rlboxsoundtouch_0x5F_wasm_call_ctors_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_0x5F_wasm_init_memory_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_0x5Fstart_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_main(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AAAFilter0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AcalculateCoeffs0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetLength0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3A0x7EAAFilter0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetCutoffFreq0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AgetLength0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Arewind0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrEnd0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AgetCapacity0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AaddSilent0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AFIRFilter0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AgetLength0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aoperator0x20new0x28unsigned0x20long0x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AnewInstance0x280x29(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AInterpolateCubic0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3A0x7EInterpolateCubic0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AInterpolateLinearInteger0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AInterpolateLinearFloat0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3A0x7EInterpolateLinearInteger0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3A0x7EInterpolateLinearFloat0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AInterpolateShannon0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3A0x7EInterpolateShannon0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_SetSampleRate_0(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_SetChannels_0(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_SetPitch_0(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_SetSetting_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_SetTempo_0(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_SetRate_0(w2c_rlboxsoundtouch*, u32, f64);
static u32 w2c_rlboxsoundtouch_NumChannels_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_NumSamples_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_NumUnprocessedSamples_0(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_PutSamples_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_ReceiveSamples_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_Flush_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3ARateTransposer0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AnewInstance0x280x29(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AenableAAFilter0x28bool0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisAAFilterEnabled0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetAAFilter0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AprocessSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisEmpty0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetAlgorithm0x28soundtouch0x3A0x3ATransposerBase0x3A0x3AALGORITHM0x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3Atranspose0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AptrBegin0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AnumSamples0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch_ac_test_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3ASoundTouch0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetVersionString0x280x29(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetVersionId0x280x29(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetChannels0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRateChange0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempo0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempoChange0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitch0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchOctaves0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchSemiTones0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchSemiTones0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSampleRate0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aflush0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSetting0x28int0x2C0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetSetting0x28int0x290x20const(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AnumUnprocessedSamples0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32);
static f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetInputOutputSampleRatio0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AisEmpty0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_createSoundTouchObj_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_destroySoundTouchObj_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3ATDStretch0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AacceptNewOverlapLength0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetTempo0x28double0x29(w2c_rlboxsoundtouch*, u32, f64);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalculateOverlapLength0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMono0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearMidBuffer0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearInput0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AenableQuickSeek0x28bool0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AisQuickSeekEnabled0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPosition0x28float0x20const0x2A0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionFull0x28float0x20const0x2A0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionQuick0x28float0x20const0x2A0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AadaptNormalizer0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearCrossCorrState0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AprocessSamples0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aoperator0x20new0x28unsigned0x20long0x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AnewInstance0x280x29(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapStereo0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMulti0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_disableExtensions0x28unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_detectCPUextensions0x280x29(w2c_rlboxsoundtouch*);
static f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AFIRFilterSSE0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3A0x7ETDStretchSSE0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_moz_xmalloc_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_moz_xcalloc_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_moz_xrealloc_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_moz_xstrdup_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_moz_xmemdup_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_moz_malloc_usable_size_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_moz_malloc_size_of_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_moz_malloc_enclosing_size_of_0(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_0x5F_cxa_deleted_virtual_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_abort_message_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Abad_alloc0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Abad_array_new_length0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Abad_cast0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Abad_typeid0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_found_base_class0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aset_unexpected0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aset_terminate0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aset_new_handler0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aget_unexpected0x280x29(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_std0x3A0x3A_0x5Funexpected0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Aunexpected0x280x29(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aget_terminate0x280x29(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_std0x3A0x3A_0x5Fterminate0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_std0x3A0x3Aterminate0x280x29(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_std0x3A0x3Aget_new_handler0x280x29(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_malloc_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_dlmalloc(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_prepend_alloc(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_free_0(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_dlfree(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_calloc_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_realloc_0(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_dispose_chunk(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_posix_memalign_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_internal_memalign(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_aligned_alloc_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_malloc_usable_size_0(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5FExit_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_main_void_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_args_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_args_sizes_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_environ_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_environ_sizes_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_clock_res_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_clock_time_get_0(w2c_rlboxsoundtouch*, u32, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_advise_0(w2c_rlboxsoundtouch*, u32, u64, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_allocate_0(w2c_rlboxsoundtouch*, u32, u64, u64);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_close_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_datasync_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_set_flags_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_set_rights_0(w2c_rlboxsoundtouch*, u32, u64, u64);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_set_size_0(w2c_rlboxsoundtouch*, u32, u64);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_set_times_0(w2c_rlboxsoundtouch*, u32, u64, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_pread_0(w2c_rlboxsoundtouch*, u32, u32, u32, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_prestat_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_prestat_dir_name_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_pwrite_0(w2c_rlboxsoundtouch*, u32, u32, u32, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_read_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_readdir_0(w2c_rlboxsoundtouch*, u32, u32, u32, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_renumber_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_seek_0(w2c_rlboxsoundtouch*, u32, u64, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_sync_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_tell_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_write_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_create_directory_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_filestat_get_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_filestat_set_times_0(w2c_rlboxsoundtouch*, u32, u32, u32, u64, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_link_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_open_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u64, u64, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_readlink_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_remove_directory_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_rename_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_symlink_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_path_unlink_file_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_poll_oneoff_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_wasi_proc_exit_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_sched_yield_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_random_get_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_accept_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_recv_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_send_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_shutdown_0(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_abort_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_sbrk_0(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_dummy(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_0x5F_wasm_call_dtors_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_exit_0(w2c_rlboxsoundtouch*, u32);
static f64 w2c_rlboxsoundtouch_0x5F_cos_0(w2c_rlboxsoundtouch*, f64, f64);
static u32 w2c_rlboxsoundtouch_0x5F_rem_pio2_large_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_rem_pio2_0(w2c_rlboxsoundtouch*, f64, u32);
static f64 w2c_rlboxsoundtouch_0x5F_sin_0(w2c_rlboxsoundtouch*, f64, f64, u32);
static f64 w2c_rlboxsoundtouch_cos_0(w2c_rlboxsoundtouch*, f64);
static f64 w2c_rlboxsoundtouch_0x5F_math_xflow_0(w2c_rlboxsoundtouch*, u32, f64);
static f64 w2c_rlboxsoundtouch_0x5F_math_uflow_0(w2c_rlboxsoundtouch*, u32);
static f64 w2c_rlboxsoundtouch_0x5F_math_oflow_0(w2c_rlboxsoundtouch*, u32);
static f64 w2c_rlboxsoundtouch_exp_0(w2c_rlboxsoundtouch*, f64);
static f64 w2c_rlboxsoundtouch_specialcase(w2c_rlboxsoundtouch*, f64, u64, u64);
static f64 w2c_rlboxsoundtouch_ldexp_0(w2c_rlboxsoundtouch*, f64, u32);
static f64 w2c_rlboxsoundtouch_scalbn_0(w2c_rlboxsoundtouch*, f64, u32);
static f64 w2c_rlboxsoundtouch_sin_0(w2c_rlboxsoundtouch*, f64);
static void w2c_rlboxsoundtouch_0x5F_stdio_exit_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_0x5F_towrite_0(w2c_rlboxsoundtouch*, u32);
static void w2c_rlboxsoundtouch_0x5F_towrite_needs_stdio_exit_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_0x5F_overflow_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_fputc_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_fwritex_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_fwrite_0(w2c_rlboxsoundtouch*, u32, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_ofl_lock_0(w2c_rlboxsoundtouch*);
static void w2c_rlboxsoundtouch_0x5F_ofl_unlock_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_printf_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_wasilibc_fd_renumber_0(w2c_rlboxsoundtouch*, u32, u32);
static void w2c_rlboxsoundtouch_0x5F_wasilibc_populate_preopens_0(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_close_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_stdio_close_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_writev_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_stdio_write_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u64 w2c_rlboxsoundtouch_0x5F_lseek_0(w2c_rlboxsoundtouch*, u32, u64, u32);
static u64 w2c_rlboxsoundtouch_0x5F_stdio_seek_0(w2c_rlboxsoundtouch*, u32, u64, u32);
static u32 w2c_rlboxsoundtouch_0x5F_isatty_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_stdout_write_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_dummy0x2E1(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_lctrans_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_0x5F_lctrans_cur_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_0x5F_strerror_l_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_strerror_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_wcrtomb_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_wctomb_0(w2c_rlboxsoundtouch*, u32, u32);
static f64 w2c_rlboxsoundtouch_frexp_0(w2c_rlboxsoundtouch*, f64, u32);
static u32 w2c_rlboxsoundtouch_fputs_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_vfprintf_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_printf_core(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_pop_arg(w2c_rlboxsoundtouch*, u32, u32, u32);
static void w2c_rlboxsoundtouch_pad(w2c_rlboxsoundtouch*, u32, u32, u32, u32, u32);
static void w2c_rlboxsoundtouch_long_double_not_supported(w2c_rlboxsoundtouch*);
static u32 w2c_rlboxsoundtouch_memcpy_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_memmove_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_memset_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_strcmp_0(w2c_rlboxsoundtouch*, u32, u32);
static u32 w2c_rlboxsoundtouch_strdup_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_strlen_0(w2c_rlboxsoundtouch*, u32);
static u32 w2c_rlboxsoundtouch_memchr_0(w2c_rlboxsoundtouch*, u32, u32, u32);
static u32 w2c_rlboxsoundtouch_strnlen_0(w2c_rlboxsoundtouch*, u32, u32);

FUNC_TYPE_T(w2c_rlboxsoundtouch_t0) = "\xff\x57\x1f\x83\x74\x67\x5d\x67\x2a\xc8\x0d\x92\x3d\xe8\x47\xa1\x1e\x73\xc7\x03\xa1\xee\x83\x72\x66\xa9\x1c\x9d\xe7\x8c\xdd\xfb";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t1) = "\x89\x3a\x3d\x2c\x8f\x4d\x7f\x6d\x6c\x9d\x62\x67\x29\xaf\x3d\x44\x39\x8e\xc3\xf3\xe8\x51\xc1\x99\xb9\xdd\x9f\xd5\x3d\x1f\xd3\xe4";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t2) = "\x07\x80\x96\x7a\x42\xf7\x3e\xe6\x70\x5c\x2f\xac\x83\xf5\x67\xd2\xa2\xa0\x69\x41\x5f\xf8\xe7\x96\x7f\x23\xab\x00\x03\x5f\x4a\x3c";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t3) = "\x92\xfb\x6a\xdf\x49\x07\x0a\x83\xbe\x08\x02\x68\xcd\xf6\x95\x27\x4a\xc2\xf3\xe5\xe4\x7d\x29\x49\xe8\xed\x42\x92\x6a\x9d\xda\xf0";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t4) = "\x26\x10\x81\xe2\x21\x43\xd6\x01\x3e\x2d\x2f\x16\x17\x78\x6f\xba\xb3\x2f\x4d\x54\x9b\x8a\xa9\xdd\xbf\x53\x92\x3c\xd3\x71\xc6\xb2";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t5) = "\xf6\x98\x1b\xc6\x10\xda\xb7\xb2\x63\x37\xcd\xdc\x72\xca\xe9\x50\x00\x13\xba\x10\x6c\xde\x87\x27\x10\xf8\x86\x2f\xe3\xdb\x94\xe4";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t6) = "\x81\x39\xe9\x80\x36\x86\x39\xf3\xbe\x5e\x29\xbf\x55\x64\xbe\x61\xa7\x82\x5c\x6d\x98\x51\xff\xf0\x20\x11\x16\xc8\x91\x9f\xb9\xb5";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t7) = "\x78\xde\x71\xb6\x49\x9a\x33\x9d\xd3\x70\x88\x4c\x50\xd4\xea\xdf\xe1\x2a\x18\x12\xf6\xf3\x64\xf7\xea\x4f\x94\x19\xa7\x20\x28\xe8";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t8) = "\xcd\xad\x8f\x6a\xaf\x3e\xd0\x86\xf0\x9a\xd7\xf0\xc7\x0d\x48\x9f\x27\x59\xf3\x8d\x71\xa1\x81\xa8\xcc\x06\x53\x98\x62\x34\xaa\xf5";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t9) = "\xe4\x86\x49\x6b\x60\x0c\x7a\x58\xb1\x3b\x19\xea\x31\xd4\xe1\x7a\x30\x21\xd5\x4b\x6b\x69\xfc\x41\xc9\x51\x70\xf2\xf9\x17\x44\xed";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t10) = "\xe7\x04\xae\x29\x69\xbd\x17\x5a\xa1\x81\x7d\x2a\xb4\xd8\x29\x23\x92\x1d\x12\xa2\x88\x3d\xab\x82\xe3\xd9\xfb\x9d\xa5\xf2\x0c\x89";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t11) = "\xfe\x25\x30\xe2\x9b\x00\xea\x69\xb9\xd5\x80\xfe\x99\x3b\x59\x29\x77\xcb\x00\x18\x3b\x9c\x72\x83\x2d\x2e\xac\x0a\x70\xf6\x32\x31";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t12) = "\x10\x14\x42\x90\xbf\xa8\x37\x8c\xdc\x81\x9f\x4c\x63\x4e\x62\xb7\x11\x29\xaa\x09\x68\x89\x5f\x5e\x13\x9c\xcc\xe2\xcb\x51\x7a\x78";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t13) = "\x36\xa9\xe7\xf1\xc9\x5b\x82\xff\xb9\x97\x43\xe0\xc5\xc4\xce\x95\xd8\x3c\x9a\x43\x0a\xac\x59\xf8\x4e\xf3\xcb\xfa\xb6\x14\x50\x68";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t14) = "\x72\x95\xc9\x03\x14\x98\x9d\xfa\xa4\x71\xa5\x52\x41\xef\x01\x2b\x0c\x44\x92\x47\x2d\x6a\xf2\x42\x1b\x46\x76\x98\x74\x7e\x94\x3c";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t15) = "\x16\x62\x73\x5a\x4c\xd9\x16\x37\xb0\x31\x49\x80\x8b\x55\x54\x52\x0f\x1a\x5d\x5f\x0f\x0e\x03\x34\xe2\xe0\x42\x9a\x12\xa6\xbb\x31";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t16) = "\x39\x76\x1c\xc1\xf6\x8b\x63\xd1\x4f\x26\x9a\x9d\x2c\xd4\x2c\x21\x2a\x8f\x7f\xf2\xa5\xfd\xf4\x02\xf5\xb5\xe9\x92\x25\x47\x55\x60";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t17) = "\x14\xc4\xea\xf1\xb5\xbd\x85\xb0\xb6\x57\x8b\x98\x9f\x3a\x34\xe6\xa2\x62\x23\x7e\xb1\x4a\x4f\x01\xe2\x30\x7a\x55\x18\x51\xba\xa7";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t18) = "\xd6\x9b\x96\x20\xd5\x85\xd0\xbe\x78\x95\x77\x65\xc8\xf4\x4e\x73\x96\xed\xf8\x84\x48\xb3\x80\x16\x37\x37\x65\x94\xe1\xed\x5a\x69";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t19) = "\x6c\x9c\x53\x1a\xdd\x7f\xe5\x69\x16\x4e\x66\x8f\xa2\x8f\x87\xd9\xf8\x67\x49\x93\xe3\x5b\x65\x89\xc6\xca\xf0\x41\x42\xb5\x6e\x82";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t20) = "\x94\x12\x2b\x98\xca\x29\xf3\x2c\xff\x5f\xc8\x3f\xc2\x8f\xd7\x70\x9f\x6c\x7f\xc7\x68\x16\x42\xe0\x46\x64\xbb\x79\x3d\xbf\x91\x63";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t21) = "\xf0\xcf\x3c\x13\x35\x18\x96\x31\xe2\x88\x8f\x72\xcd\x97\x45\xfe\x7c\x55\xf0\x67\x0a\xde\xf3\xd7\x66\xa6\x10\xb6\x69\x67\x6c\x55";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t22) = "\x1e\x50\xdc\xcf\x7e\xfa\x1a\xc1\x60\x2d\x95\x37\x07\x01\x3a\xe3\x24\x35\xc1\x7e\x9b\xe9\xae\x59\x29\xae\xc8\x96\x23\x1e\x25\x28";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t23) = "\xc8\xb4\x32\x7f\x30\xd6\x74\x1d\x89\x51\xbd\x55\x66\xa6\xfc\x17\x99\x53\xb1\x2b\xb7\x54\xd3\xed\xd0\x03\x38\xd2\x22\x94\xfa\x72";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t24) = "\xe3\xe1\xd3\x75\x5f\x41\x96\xa4\xe0\xe2\x50\x99\x37\x4f\xf5\x5e\xe1\x88\xd0\x58\xd1\x33\xdb\xb3\xac\xd6\x1a\x23\xbf\xd4\xc0\x31";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t25) = "\x72\xab\x00\xdf\x20\x3d\xce\xa1\xf2\x29\xc7\x9d\x13\x40\x7e\x98\xac\x7d\x41\x4a\x53\x2e\x42\x42\x61\x55\x2e\xaa\xeb\xbe\xc6\x35";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t26) = "\x3d\x0f\x16\xf6\x24\x19\x30\xd2\xbf\x7c\x25\x94\xb5\xdf\x90\x3d\x74\x62\xde\x34\x41\x83\xb0\xaf\x1a\xd8\x82\x63\xdc\xdf\xfe\x21";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t27) = "\xfa\xc8\x6c\x10\xa2\x0c\x23\xd1\x5e\x62\x83\x60\x5d\x8f\xb0\xe4\x84\xd4\x26\x8a\xd3\x19\xe9\xf9\x99\xe9\xcb\x05\xc2\xdd\x25\x96";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t28) = "\x56\x5c\xfc\x6d\xf4\xe5\xd5\x06\x01\x90\x7d\x20\x97\x74\xa1\x67\x3e\x00\x21\xa4\x0b\xc6\x06\x23\x7f\x60\xe5\xbf\x23\x2b\x7c\xe9";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t29) = "\xb6\x3b\xb2\x62\x4c\x1e\xcd\x51\x72\xc5\xe7\x8f\x90\xbb\xf3\x60\x66\xb2\x0e\x8f\x5f\xa6\x1b\xc1\xa4\x65\x1b\x40\xb9\x77\x96\x12";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t30) = "\x52\xec\xe2\x9a\xa4\x1f\x49\xbb\x12\x93\xbd\x8f\x1d\x54\xad\x3a\x78\x4f\x97\xe3\x55\xae\x9c\x66\x0b\xcc\x2e\xb8\xed\xf1\xcd\xf2";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t31) = "\x47\xfc\x2e\xe3\x05\xcd\x0b\x8a\x25\xfe\xf0\x84\x0d\x78\xb4\x86\x81\x83\x15\xbb\x08\xa0\x7c\xd5\x1c\x8a\x40\x98\xe9\xdf\x8e\x74";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t32) = "\x0a\xb9\x50\x3c\x6a\xf0\x79\x2e\x9c\x53\x4a\xd4\xf1\x68\x37\xd4\xe0\xdf\x32\xf6\x00\xb4\x45\xdf\x75\x1e\xd7\x52\xa6\x86\xd7\xac";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t33) = "\x79\x0a\x5d\xd5\xc8\xe4\xb5\x86\xbf\x9a\xcb\x8e\xd8\xfe\x49\x6d\x55\xb2\x68\x1e\x7c\xfc\x99\x61\xe0\x3e\x54\xa4\x15\xc4\xec\x84";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t34) = "\x17\x84\x41\xc0\xbf\x9a\x66\xa4\x60\xa5\x4d\x2f\x27\x12\xa0\x0b\x9b\x28\xd5\xdb\x47\x67\x97\xd1\x33\xe2\xb5\x0e\x29\xcc\xc6\x6f";
FUNC_TYPE_T(w2c_rlboxsoundtouch_t35) = "\xcb\x35\x33\x48\x99\xc7\xee\xd1\xbe\xa0\x97\x29\x0e\x3b\x53\x63\xfd\x8d\x79\x66\x0e\xa8\xd0\xa5\xac\x96\xb0\x15\x44\x8e\x99\xa8";

static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AresetRegisters0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AresetRegisters0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3A0x7EInterpolateCubic0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3A0x7EInterpolateCubic0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AgetLatency0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AgetLatency0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AresetRegisters0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AresetRegisters0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AsetRate0x28double0x29(void *instance, u32 var_0, f64 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AsetRate0x28double0x29(instance, var_0, var_1);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AresetRegisters0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AresetRegisters0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3A0x7EInterpolateLinearInteger0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3A0x7EInterpolateLinearInteger0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AgetLatency0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AgetLatency0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3A0x7EInterpolateLinearFloat0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3A0x7EInterpolateLinearFloat0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AgetLatency0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AgetLatency0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AresetRegisters0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AresetRegisters0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3A0x7EInterpolateShannon0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3A0x7EInterpolateShannon0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AgetLatency0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AgetLatency0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetRate0x28double0x29(void *instance, u32 var_0, f64 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetRate0x28double0x29(instance, var_0, var_1);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3Aclear0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3Aclear0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisEmpty0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisEmpty0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3Atranspose0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3Atranspose0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetChannels0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetChannels0x28int0x29(instance, var_0, var_1);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(void *instance, u32 var_0, f64 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AptrBegin0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AptrBegin0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AnumSamples0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AnumSamples0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aclear0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aclear0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AnumUnprocessedSamples0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AnumUnprocessedSamples0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AisEmpty0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AisEmpty0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMono0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMono0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aclear0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aclear0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPosition0x28float0x20const0x2A0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPosition0x28float0x20const0x2A0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionFull0x28float0x20const0x2A0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionFull0x28float0x20const0x2A0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionQuick0x28float0x20const0x2A0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionQuick0x28float0x20const0x2A0x29(instance, var_0, var_1);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearCrossCorrState0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearCrossCorrState0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapStereo0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapStereo0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMulti0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMulti0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static f64 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_0, var_1, var_2, var_3);
}
static f64 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_0, var_1, var_2, var_3);
}
static f64 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_0, var_1, var_2, var_3);
}
static f64 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3A0x7ETDStretchSSE0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3A0x7ETDStretchSSE0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual_0(void *instance) {
  return w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual_0(instance);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29(instance, var_0);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static void wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static void wrap_w2c_rlboxsoundtouch_std0x3A0x3Aterminate0x280x29(void *instance) {
  return w2c_rlboxsoundtouch_std0x3A0x3Aterminate0x280x29(instance);
}
static void wrap_w2c_rlboxsoundtouch_abort_0(void *instance) {
  return w2c_rlboxsoundtouch_abort_0(instance);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_stdio_close_0(void *instance, u32 var_0) {
  return w2c_rlboxsoundtouch_0x5F_stdio_close_0(instance, var_0);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_stdio_write_0(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_stdio_write_0(instance, var_0, var_1, var_2);
}
static u64 wrap_w2c_rlboxsoundtouch_0x5F_stdio_seek_0(void *instance, u32 var_0, u64 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_stdio_seek_0(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlboxsoundtouch_0x5F_stdout_write_0(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlboxsoundtouch_0x5F_stdout_write_0(instance, var_0, var_1, var_2);
}

static void init_globals(w2c_rlboxsoundtouch* instance) {
  instance->w2c_0x5F_stack_pointer = 262144u;
  instance->w2c_GOT0x2Edata0x2Einternal0x2E_0x5Fmemory_base = 0u;
  instance->w2c_0x5F_memory_base = 0u;
  instance->w2c_0x5FZTVN10soundtouch16FIFOSampleBufferE = 262144u;
  instance->w2c_0x5FZTIN10soundtouch16FIFOSampleBufferE = 262268u;
  instance->w2c_0x5FZTSN10soundtouch16FIFOSampleBufferE = 262196u;
  instance->w2c_0x5FZTSN10soundtouch14FIFOSamplePipeE = 262229u;
  instance->w2c_0x5FZTIN10soundtouch14FIFOSamplePipeE = 262260u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv117_0x5Fclass_type_infoE = 266296u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE = 266336u;
  instance->w2c_0x5FZTVN10soundtouch9FIRFilterE = 262280u;
  instance->w2c_0x5FZTIN10soundtouch9FIRFilterE = 262340u;
  instance->w2c_0x5FZTSN10soundtouch9FIRFilterE = 262312u;
  instance->w2c_0x5FZTVN10soundtouch16InterpolateCubicE = 262348u;
  instance->w2c_0x5FZTIN10soundtouch16InterpolateCubicE = 262432u;
  instance->w2c_0x5FZTSN10soundtouch16InterpolateCubicE = 262396u;
  instance->w2c_0x5FZTIN10soundtouch14TransposerBaseE = 262964u;
  instance->w2c_0x5FZTVN10soundtouch24InterpolateLinearIntegerE = 262444u;
  instance->w2c_0x5FZTVN10soundtouch22InterpolateLinearFloatE = 262492u;
  instance->w2c_0x5FZTIN10soundtouch24InterpolateLinearIntegerE = 262584u;
  instance->w2c_0x5FZTIN10soundtouch22InterpolateLinearFloatE = 262636u;
  instance->w2c_0x5FZTSN10soundtouch24InterpolateLinearIntegerE = 262540u;
  instance->w2c_0x5FZTSN10soundtouch22InterpolateLinearFloatE = 262596u;
  instance->w2c_0x5FZTVN10soundtouch18InterpolateShannonE = 262648u;
  instance->w2c_0x5FZTIN10soundtouch18InterpolateShannonE = 262732u;
  instance->w2c_0x5FZTSN10soundtouch18InterpolateShannonE = 262696u;
  instance->w2c_0x5FZTVN10soundtouch14RateTransposerE = 262744u;
  instance->w2c_0x5FZN10soundtouch14TransposerBase9algorithmE = 273824u;
  instance->w2c_0x5FZTVN10soundtouch14TransposerBaseE = 262796u;
  instance->w2c_0x5FZTIN10soundtouch14RateTransposerE = 262920u;
  instance->w2c_0x5FZTSN10soundtouch14RateTransposerE = 262844u;
  instance->w2c_0x5FZTSN10soundtouch13FIFOProcessorE = 262875u;
  instance->w2c_0x5FZTIN10soundtouch13FIFOProcessorE = 262908u;
  instance->w2c_0x5FZTSN10soundtouch14TransposerBaseE = 262932u;
  instance->w2c_0x5FZTVN10soundtouch10SoundTouchE = 263616u;
  instance->w2c_0x5FZTIN10soundtouch10SoundTouchE = 263696u;
  instance->w2c_0x5FZTSN10soundtouch10SoundTouchE = 263668u;
  instance->w2c_0x5FZTVN10soundtouch9TDStretchE = 263708u;
  instance->w2c_0x5FZTVN10soundtouch12TDStretchSSEE = 263864u;
  instance->w2c_0x5FZTIN10soundtouch9TDStretchE = 263820u;
  instance->w2c_0x5FZTSN10soundtouch9TDStretchE = 263792u;
  instance->w2c_0x5FZTVN10soundtouch12FIRFilterSSEE = 263832u;
  instance->w2c_0x5FZTIN10soundtouch12FIRFilterSSEE = 264024u;
  instance->w2c_0x5FZTIN10soundtouch12TDStretchSSEE = 263980u;
  instance->w2c_0x5FZTSN10soundtouch12TDStretchSSEE = 263948u;
  instance->w2c_0x5FZTSN10soundtouch12FIRFilterSSEE = 263992u;
  instance->w2c_0x5F_cxa_unexpected_handler = 273832u;
  instance->w2c_0x5F_cxa_terminate_handler = 273828u;
  instance->w2c_0x5F_cxa_new_handler = 274088u;
  instance->w2c_0x5FZTVSt9bad_alloc = 264036u;
  instance->w2c_0x5FZTVSt20bad_array_new_length = 264056u;
  instance->w2c_0x5FZTISt9bad_alloc = 264188u;
  instance->w2c_0x5FZTISt20bad_array_new_length = 264228u;
  instance->w2c_0x5FZTVSt9exception = 264076u;
  instance->w2c_0x5FZTISt9exception = 264112u;
  instance->w2c_0x5FZTSSt9exception = 264096u;
  instance->w2c_0x5FZTVSt13bad_exception = 264120u;
  instance->w2c_0x5FZTISt13bad_exception = 264160u;
  instance->w2c_0x5FZTSSt13bad_exception = 264140u;
  instance->w2c_0x5FZTSSt9bad_alloc = 264172u;
  instance->w2c_0x5FZTSSt20bad_array_new_length = 264200u;
  instance->w2c_0x5FZTVSt8bad_cast = 264240u;
  instance->w2c_0x5FZTVSt10bad_typeid = 264260u;
  instance->w2c_0x5FZTISt8bad_cast = 264332u;
  instance->w2c_0x5FZTISt10bad_typeid = 264360u;
  instance->w2c_0x5FZTVSt9type_info = 264280u;
  instance->w2c_0x5FZTISt9type_info = 264312u;
  instance->w2c_0x5FZTSSt9type_info = 264296u;
  instance->w2c_0x5FZTSSt8bad_cast = 264320u;
  instance->w2c_0x5FZTSSt10bad_typeid = 264344u;
  instance->w2c_stderr = 271616u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv116_0x5Fshim_type_infoE = 264408u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv117_0x5Fclass_type_infoE = 264456u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE = 264504u;
  instance->w2c_0x5FZTSDn = 264848u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE = 264552u;
  instance->w2c_0x5FZTSv = 264796u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE = 264604u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE = 264664u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv116_0x5Fshim_type_infoE = 264372u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv117_0x5Fclass_type_infoE = 264420u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE = 264468u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE = 264516u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE = 264564u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE = 264616u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv116_0x5Fshim_type_infoE = 264688u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE = 264716u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE = 264784u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE = 264744u;
  instance->w2c_0x5FZTIv = 264800u;
  instance->w2c_0x5FZTSPv = 264808u;
  instance->w2c_0x5FZTIPv = 264812u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE = 266548u;
  instance->w2c_0x5FZTSPKv = 264828u;
  instance->w2c_0x5FZTIPKv = 264832u;
  instance->w2c_0x5FZTIDn = 264852u;
  instance->w2c_0x5FZTSPDn = 264860u;
  instance->w2c_0x5FZTIPDn = 264864u;
  instance->w2c_0x5FZTSPKDn = 264880u;
  instance->w2c_0x5FZTIPKDn = 264888u;
  instance->w2c_0x5FZTSb = 264904u;
  instance->w2c_0x5FZTIb = 264908u;
  instance->w2c_0x5FZTSPb = 264916u;
  instance->w2c_0x5FZTIPb = 264920u;
  instance->w2c_0x5FZTSPKb = 264936u;
  instance->w2c_0x5FZTIPKb = 264940u;
  instance->w2c_0x5FZTSw = 264956u;
  instance->w2c_0x5FZTIw = 264960u;
  instance->w2c_0x5FZTSPw = 264968u;
  instance->w2c_0x5FZTIPw = 264972u;
  instance->w2c_0x5FZTSPKw = 264988u;
  instance->w2c_0x5FZTIPKw = 264992u;
  instance->w2c_0x5FZTSc = 265008u;
  instance->w2c_0x5FZTIc = 265012u;
  instance->w2c_0x5FZTSPc = 265020u;
  instance->w2c_0x5FZTIPc = 265024u;
  instance->w2c_0x5FZTSPKc = 265040u;
  instance->w2c_0x5FZTIPKc = 265044u;
  instance->w2c_0x5FZTSh = 265060u;
  instance->w2c_0x5FZTIh = 265064u;
  instance->w2c_0x5FZTSPh = 265072u;
  instance->w2c_0x5FZTIPh = 265076u;
  instance->w2c_0x5FZTSPKh = 265092u;
  instance->w2c_0x5FZTIPKh = 265096u;
  instance->w2c_0x5FZTSa = 265112u;
  instance->w2c_0x5FZTIa = 265116u;
  instance->w2c_0x5FZTSPa = 265124u;
  instance->w2c_0x5FZTIPa = 265128u;
  instance->w2c_0x5FZTSPKa = 265144u;
  instance->w2c_0x5FZTIPKa = 265148u;
  instance->w2c_0x5FZTSs = 265164u;
  instance->w2c_0x5FZTIs = 265168u;
  instance->w2c_0x5FZTSPs = 265176u;
  instance->w2c_0x5FZTIPs = 265180u;
  instance->w2c_0x5FZTSPKs = 265196u;
  instance->w2c_0x5FZTIPKs = 265200u;
  instance->w2c_0x5FZTSt = 265216u;
  instance->w2c_0x5FZTIt = 265220u;
  instance->w2c_0x5FZTSPt = 265228u;
  instance->w2c_0x5FZTIPt = 265232u;
  instance->w2c_0x5FZTSPKt = 265248u;
  instance->w2c_0x5FZTIPKt = 265252u;
  instance->w2c_0x5FZTSi = 265268u;
  instance->w2c_0x5FZTIi = 265272u;
  instance->w2c_0x5FZTSPi = 265280u;
  instance->w2c_0x5FZTIPi = 265284u;
  instance->w2c_0x5FZTSPKi = 265300u;
  instance->w2c_0x5FZTIPKi = 265304u;
  instance->w2c_0x5FZTSj = 265320u;
  instance->w2c_0x5FZTIj = 265324u;
  instance->w2c_0x5FZTSPj = 265332u;
  instance->w2c_0x5FZTIPj = 265336u;
  instance->w2c_0x5FZTSPKj = 265352u;
  instance->w2c_0x5FZTIPKj = 265356u;
  instance->w2c_0x5FZTSl = 265372u;
  instance->w2c_0x5FZTIl = 265376u;
  instance->w2c_0x5FZTSPl = 265384u;
  instance->w2c_0x5FZTIPl = 265388u;
  instance->w2c_0x5FZTSPKl = 265404u;
  instance->w2c_0x5FZTIPKl = 265408u;
  instance->w2c_0x5FZTSm = 265424u;
  instance->w2c_0x5FZTIm = 265428u;
  instance->w2c_0x5FZTSPm = 265436u;
  instance->w2c_0x5FZTIPm = 265440u;
  instance->w2c_0x5FZTSPKm = 265456u;
  instance->w2c_0x5FZTIPKm = 265460u;
  instance->w2c_0x5FZTSx = 265476u;
  instance->w2c_0x5FZTIx = 265480u;
  instance->w2c_0x5FZTSPx = 265488u;
  instance->w2c_0x5FZTIPx = 265492u;
  instance->w2c_0x5FZTSPKx = 265508u;
  instance->w2c_0x5FZTIPKx = 265512u;
  instance->w2c_0x5FZTSy = 265528u;
  instance->w2c_0x5FZTIy = 265532u;
  instance->w2c_0x5FZTSPy = 265540u;
  instance->w2c_0x5FZTIPy = 265544u;
  instance->w2c_0x5FZTSPKy = 265560u;
  instance->w2c_0x5FZTIPKy = 265564u;
  instance->w2c_0x5FZTSn = 265580u;
  instance->w2c_0x5FZTIn = 265584u;
  instance->w2c_0x5FZTSPn = 265592u;
  instance->w2c_0x5FZTIPn = 265596u;
  instance->w2c_0x5FZTSPKn = 265612u;
  instance->w2c_0x5FZTIPKn = 265616u;
  instance->w2c_0x5FZTSo = 265632u;
  instance->w2c_0x5FZTIo = 265636u;
  instance->w2c_0x5FZTSPo = 265644u;
  instance->w2c_0x5FZTIPo = 265648u;
  instance->w2c_0x5FZTSPKo = 265664u;
  instance->w2c_0x5FZTIPKo = 265668u;
  instance->w2c_0x5FZTSDh = 265684u;
  instance->w2c_0x5FZTIDh = 265688u;
  instance->w2c_0x5FZTSPDh = 265696u;
  instance->w2c_0x5FZTIPDh = 265700u;
  instance->w2c_0x5FZTSPKDh = 265716u;
  instance->w2c_0x5FZTIPKDh = 265724u;
  instance->w2c_0x5FZTSf = 265740u;
  instance->w2c_0x5FZTIf = 265744u;
  instance->w2c_0x5FZTSPf = 265752u;
  instance->w2c_0x5FZTIPf = 265756u;
  instance->w2c_0x5FZTSPKf = 265772u;
  instance->w2c_0x5FZTIPKf = 265776u;
  instance->w2c_0x5FZTSd = 265792u;
  instance->w2c_0x5FZTId = 265796u;
  instance->w2c_0x5FZTSPd = 265804u;
  instance->w2c_0x5FZTIPd = 265808u;
  instance->w2c_0x5FZTSPKd = 265824u;
  instance->w2c_0x5FZTIPKd = 265828u;
  instance->w2c_0x5FZTSe = 265844u;
  instance->w2c_0x5FZTIe = 265848u;
  instance->w2c_0x5FZTSPe = 265856u;
  instance->w2c_0x5FZTIPe = 265860u;
  instance->w2c_0x5FZTSPKe = 265876u;
  instance->w2c_0x5FZTIPKe = 265880u;
  instance->w2c_0x5FZTSg = 265896u;
  instance->w2c_0x5FZTIg = 265900u;
  instance->w2c_0x5FZTSPg = 265908u;
  instance->w2c_0x5FZTIPg = 265912u;
  instance->w2c_0x5FZTSPKg = 265928u;
  instance->w2c_0x5FZTIPKg = 265932u;
  instance->w2c_0x5FZTSDu = 265948u;
  instance->w2c_0x5FZTIDu = 265952u;
  instance->w2c_0x5FZTSPDu = 265960u;
  instance->w2c_0x5FZTIPDu = 265964u;
  instance->w2c_0x5FZTSPKDu = 265980u;
  instance->w2c_0x5FZTIPKDu = 265988u;
  instance->w2c_0x5FZTSDs = 266004u;
  instance->w2c_0x5FZTIDs = 266008u;
  instance->w2c_0x5FZTSPDs = 266016u;
  instance->w2c_0x5FZTIPDs = 266020u;
  instance->w2c_0x5FZTSPKDs = 266036u;
  instance->w2c_0x5FZTIPKDs = 266044u;
  instance->w2c_0x5FZTSDi = 266060u;
  instance->w2c_0x5FZTIDi = 266064u;
  instance->w2c_0x5FZTSPDi = 266072u;
  instance->w2c_0x5FZTIPDi = 266076u;
  instance->w2c_0x5FZTSPKDi = 266092u;
  instance->w2c_0x5FZTIPKDi = 266100u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv117_0x5Farray_type_infoE = 266116u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv117_0x5Farray_type_infoE = 266180u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv117_0x5Farray_type_infoE = 266144u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE = 266192u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv116_0x5Fenum_type_infoE = 266220u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv116_0x5Fenum_type_infoE = 266284u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv116_0x5Fenum_type_infoE = 266248u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE = 266416u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE = 266376u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE = 266428u;
  instance->w2c_0x5FZTIN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE = 266508u;
  instance->w2c_0x5FZTSN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE = 266468u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE = 266520u;
  instance->w2c_0x5FZTVN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE = 266576u;
  instance->w2c_0x5F_heap_end = 327680u;
  instance->w2c_0x5F_heap_base = 275680u;
  instance->w2c_errno = 274588u;
  instance->w2c_0x5F_progname = 275640u;
  instance->w2c_0x5F_progname_full = 275644u;
  instance->w2c_0x5F_libc = 275648u;
  instance->w2c_0x5F_hwcap = 275676u;
  instance->w2c_program_invocation_short_name = 275640u;
  instance->w2c_program_invocation_name = 275644u;
  instance->w2c_0x5F_exp_data = 269456u;
  instance->w2c_0x5F_stdin_used = 274592u;
  instance->w2c_0x5F_stdout_used = 274072u;
  instance->w2c_0x5F_stderr_used = 273952u;
  instance->w2c_0x5F_stdout_FILE = 273960u;
  instance->w2c_0x5F_stderr_FILE = 273840u;
  instance->w2c_stdout = 271620u;
  instance->w2c_0x5F_dso_handle = 262144u;
  instance->w2c_0x5F_data_end = 275680u;
  instance->w2c_0x5F_stack_low = 0u;
  instance->w2c_0x5F_stack_high = 262144u;
  instance->w2c_0x5F_global_base = 262144u;
  instance->w2c_0x5F_table_base = 1u;
}

static const u8 data_segment_data_w2c_rlboxsoundtouch_0x2Erodata[] = {
  0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
  0x08, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 
  0x0b, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 
  0x74, 0x6f, 0x75, 0x63, 0x68, 0x31, 0x36, 0x46, 0x49, 0x46, 0x4f, 0x53, 
  0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x45, 
  0x00, 0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 
  0x63, 0x68, 0x31, 0x34, 0x46, 0x49, 0x46, 0x4f, 0x53, 0x61, 0x6d, 0x70, 
  0x6c, 0x65, 0x50, 0x69, 0x70, 0x65, 0x45, 0x00, 0x40, 0x10, 0x04, 0x00, 
  0x55, 0x00, 0x04, 0x00, 0x68, 0x10, 0x04, 0x00, 0x34, 0x00, 0x04, 0x00, 
  0x74, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0x00, 0x04, 0x00, 
  0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 
  0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 
  0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 
  0x68, 0x39, 0x46, 0x49, 0x52, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 
  0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x04, 0x00, 0xa8, 0x00, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x04, 0x00, 0x12, 0x00, 0x00, 0x00, 
  0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 
  0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
  0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 
  0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 
  0x68, 0x31, 0x36, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 
  0x74, 0x65, 0x43, 0x75, 0x62, 0x69, 0x63, 0x45, 0x00, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0xfc, 0x00, 0x04, 0x00, 0x34, 0x03, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xb8, 0x01, 0x04, 0x00, 0x1c, 0x00, 0x00, 0x00, 
  0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 
  0x1f, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
  0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xec, 0x01, 0x04, 0x00, 0x23, 0x00, 0x00, 0x00, 
  0x24, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 
  0x26, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
  0x19, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 
  0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 
  0x68, 0x32, 0x34, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 
  0x74, 0x65, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x49, 0x6e, 0x74, 0x65, 
  0x67, 0x65, 0x72, 0x45, 0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x8c, 0x01, 0x04, 0x00, 0x34, 0x03, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x73, 
  0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x32, 0x32, 0x49, 
  0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x65, 0x4c, 0x69, 
  0x6e, 0x65, 0x61, 0x72, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x45, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0xc4, 0x01, 0x04, 0x00, 0x34, 0x03, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x4c, 0x02, 0x04, 0x00, 0x29, 0x00, 0x00, 0x00, 
  0x2a, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 
  0x2c, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
  0x19, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 
  0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 
  0x68, 0x31, 0x38, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 
  0x74, 0x65, 0x53, 0x68, 0x61, 0x6e, 0x6e, 0x6f, 0x6e, 0x45, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0x28, 0x02, 0x04, 0x00, 0x34, 0x03, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x08, 0x03, 0x04, 0x00, 0x2f, 0x00, 0x00, 0x00, 
  0x30, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 
  0x33, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 
  0x36, 0x00, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 
  0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x03, 0x04, 0x00, 
  0x3a, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 
  0x15, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 
  0x3a, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 
  0x74, 0x6f, 0x75, 0x63, 0x68, 0x31, 0x34, 0x52, 0x61, 0x74, 0x65, 0x54, 
  0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x45, 0x00, 0x4e, 
  0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 0x68, 
  0x31, 0x33, 0x46, 0x49, 0x46, 0x4f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 
  0x73, 0x6f, 0x72, 0x45, 0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0xdb, 0x02, 0x04, 0x00, 0x74, 0x00, 0x04, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0xbc, 0x02, 0x04, 0x00, 0xfc, 0x02, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x73, 
  0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x31, 0x34, 0x54, 
  0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x42, 0x61, 0x73, 
  0x65, 0x45, 0x00, 0x00, 0x40, 0x10, 0x04, 0x00, 0x14, 0x03, 0x04, 0x00, 
  0x2d, 0x2b, 0x20, 0x20, 0x20, 0x30, 0x58, 0x30, 0x78, 0x00, 0x2d, 0x30, 
  0x58, 0x2b, 0x30, 0x58, 0x20, 0x30, 0x58, 0x2d, 0x30, 0x78, 0x2b, 0x30, 
  0x78, 0x20, 0x30, 0x78, 0x00, 0x73, 0x74, 0x64, 0x3a, 0x3a, 0x62, 0x61, 
  0x64, 0x5f, 0x63, 0x61, 0x73, 0x74, 0x00, 0x25, 0x73, 0x3a, 0x25, 0x64, 
  0x3a, 0x20, 0x25, 0x73, 0x00, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 
  0x77, 0x61, 0x73, 0x69, 0x2d, 0x6c, 0x69, 0x62, 0x63, 0x2b, 0x2b, 0x2f, 
  0x73, 0x72, 0x63, 0x2f, 0x6c, 0x6c, 0x76, 0x6d, 0x2d, 0x70, 0x72, 0x6f, 
  0x6a, 0x65, 0x63, 0x74, 0x2d, 0x31, 0x39, 0x2e, 0x31, 0x2e, 0x36, 0x2e, 
  0x73, 0x72, 0x63, 0x2f, 0x6c, 0x69, 0x62, 0x63, 0x78, 0x78, 0x61, 0x62, 
  0x69, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 
  0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x63, 
  0x70, 0x70, 0x00, 0x73, 0x74, 0x64, 0x3a, 0x3a, 0x62, 0x61, 0x64, 0x5f, 
  0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x73, 0x74, 
  0x64, 0x3a, 0x3a, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 
  0x00, 0x6e, 0x61, 0x6e, 0x00, 0x62, 0x61, 0x64, 0x5f, 0x61, 0x72, 0x72, 
  0x61, 0x79, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 
  0x68, 0x00, 0x69, 0x6e, 0x66, 0x00, 0x62, 0x61, 0x64, 0x5f, 0x61, 0x6c, 
  0x6c, 0x6f, 0x63, 0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x72, 0x6f, 
  0x77, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x2d, 0x66, 0x6e, 0x6f, 0x2d, 0x65, 
  0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x6f, 
  0x64, 0x65, 0x00, 0x73, 0x74, 0x64, 0x3a, 0x3a, 0x62, 0x61, 0x64, 0x5f, 
  0x74, 0x79, 0x70, 0x65, 0x69, 0x64, 0x00, 0x74, 0x65, 0x72, 0x6d, 0x69, 
  0x6e, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 
  0x20, 0x75, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x6c, 
  0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x00, 0x75, 
  0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x61, 
  0x6e, 0x64, 0x6c, 0x65, 0x72, 0x20, 0x75, 0x6e, 0x65, 0x78, 0x70, 0x65, 
  0x63, 0x74, 0x65, 0x64, 0x6c, 0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 
  0x6e, 0x65, 0x64, 0x00, 0x73, 0x74, 0x64, 0x3a, 0x3a, 0x62, 0x61, 0x64, 
  0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x00, 0x4e, 0x41, 0x4e, 0x00, 0x49, 
  0x4e, 0x46, 0x00, 0x63, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x20, 
  0x61, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 
  0x6f, 0x75, 0x74, 0x20, 0x61, 0x6e, 0x20, 0x6f, 0x62, 0x6a, 0x65, 0x63, 
  0x74, 0x3f, 0x00, 0x32, 0x2e, 0x32, 0x00, 0x2e, 0x00, 0x28, 0x6e, 0x75, 
  0x6c, 0x6c, 0x29, 0x00, 0x50, 0x75, 0x72, 0x65, 0x20, 0x76, 0x69, 0x72, 
  0x74, 0x75, 0x61, 0x6c, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 
  0x6e, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x21, 0x00, 0x44, 0x65, 
  0x6c, 0x65, 0x74, 0x65, 0x64, 0x20, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 
  0x6c, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x63, 
  0x61, 0x6c, 0x6c, 0x65, 0x64, 0x21, 0x00, 0x6c, 0x69, 0x62, 0x63, 0x2b, 
  0x2b, 0x61, 0x62, 0x69, 0x3a, 0x20, 0x00, 0x53, 0x6f, 0x75, 0x6e, 0x64, 
  0x54, 0x6f, 0x75, 0x63, 0x68, 0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 
  0x6e, 0x3a, 0x20, 0x25, 0x73, 0x0a, 0x00, 0x53, 0x75, 0x70, 0x70, 0x6f, 
  0x72, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x61, 
  0x74, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x64, 
  0x6f, 0x75, 0x62, 0x6c, 0x65, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 
  0x20, 0x69, 0x73, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 
  0x79, 0x20, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x2e, 0x0a, 
  0x54, 0x6f, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x69, 0x74, 
  0x2c, 0x20, 0x61, 0x64, 0x64, 0x20, 0x2d, 0x6c, 0x63, 0x2d, 0x70, 0x72, 
  0x69, 0x6e, 0x74, 0x73, 0x63, 0x61, 0x6e, 0x2d, 0x6c, 0x6f, 0x6e, 0x67, 
  0x2d, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 
  0x68, 0x65, 0x20, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 
  0x61, 0x6e, 0x64, 0x2e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x10, 0x06, 0x04, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 
  0x31, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 
  0x40, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 
  0x42, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 
  0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 
  0x68, 0x31, 0x30, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x6f, 0x75, 0x63, 
  0x68, 0x45, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 0xf4, 0x05, 0x04, 0x00, 
  0xfc, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x06, 0x04, 0x00, 
  0x44, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 
  0x46, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 
  0x35, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x47, 0x00, 0x00, 0x00, 
  0x38, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 
  0x4a, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 
  0x4d, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 
  0x50, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 
  0x74, 0x6f, 0x75, 0x63, 0x68, 0x39, 0x54, 0x44, 0x53, 0x74, 0x72, 0x65, 
  0x74, 0x63, 0x68, 0x45, 0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x70, 0x06, 0x04, 0x00, 0xfc, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x58, 0x07, 0x04, 0x00, 0x51, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 
  0x0e, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00, 
  0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x07, 0x04, 0x00, 
  0x44, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 
  0x46, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 
  0x35, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x47, 0x00, 0x00, 0x00, 
  0x38, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x56, 0x00, 0x00, 0x00, 
  0x57, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 
  0x4d, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 
  0x50, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 
  0x74, 0x6f, 0x75, 0x63, 0x68, 0x31, 0x32, 0x54, 0x44, 0x53, 0x74, 0x72, 
  0x65, 0x74, 0x63, 0x68, 0x53, 0x53, 0x45, 0x45, 0x00, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0x0c, 0x07, 0x04, 0x00, 0x8c, 0x06, 0x04, 0x00, 
  0x4e, 0x31, 0x30, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x6f, 0x75, 0x63, 
  0x68, 0x31, 0x32, 0x46, 0x49, 0x52, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 
  0x53, 0x53, 0x45, 0x45, 0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x38, 0x07, 0x04, 0x00, 0xc4, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xfc, 0x07, 0x04, 0x00, 0x58, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00, 
  0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x08, 0x04, 0x00, 
  0x58, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xb0, 0x07, 0x04, 0x00, 0x58, 0x00, 0x00, 0x00, 
  0x5d, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x53, 0x74, 0x39, 0x65, 
  0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x00, 0x00, 
  0x40, 0x10, 0x04, 0x00, 0xa0, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xe0, 0x07, 0x04, 0x00, 0x58, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x00, 
  0x60, 0x00, 0x00, 0x00, 0x53, 0x74, 0x31, 0x33, 0x62, 0x61, 0x64, 0x5f, 
  0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0xcc, 0x07, 0x04, 0x00, 0xb0, 0x07, 0x04, 0x00, 
  0x53, 0x74, 0x39, 0x62, 0x61, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 
  0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 0xec, 0x07, 0x04, 0x00, 
  0xb0, 0x07, 0x04, 0x00, 0x53, 0x74, 0x32, 0x30, 0x62, 0x61, 0x64, 0x5f, 
  0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x6c, 0x65, 
  0x6e, 0x67, 0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x08, 0x08, 0x04, 0x00, 0xfc, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x8c, 0x08, 0x04, 0x00, 0x61, 0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00, 
  0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x08, 0x04, 0x00, 
  0x64, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x04, 0x00, 0x67, 0x00, 0x00, 0x00, 
  0x68, 0x00, 0x00, 0x00, 0x53, 0x74, 0x39, 0x74, 0x79, 0x70, 0x65, 0x5f, 
  0x69, 0x6e, 0x66, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x04, 0x00, 
  0x68, 0x08, 0x04, 0x00, 0x53, 0x74, 0x38, 0x62, 0x61, 0x64, 0x5f, 0x63, 
  0x61, 0x73, 0x74, 0x00, 0x68, 0x10, 0x04, 0x00, 0x80, 0x08, 0x04, 0x00, 
  0xb0, 0x07, 0x04, 0x00, 0x53, 0x74, 0x31, 0x30, 0x62, 0x61, 0x64, 0x5f, 
  0x74, 0x79, 0x70, 0x65, 0x69, 0x64, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x98, 0x08, 0x04, 0x00, 0xb0, 0x07, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x31, 0x36, 0x5f, 
  0x5f, 0x73, 0x68, 0x69, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 
  0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0xb4, 0x08, 0x04, 0x00, 0x78, 0x08, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x31, 0x37, 0x5f, 
  0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 
  0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0xe4, 0x08, 0x04, 0x00, 0xd8, 0x08, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x31, 0x37, 0x5f, 
  0x5f, 0x70, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 
  0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x14, 0x09, 0x04, 0x00, 0xd8, 0x08, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x31, 0x39, 0x5f, 
  0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 
  0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0x44, 0x09, 0x04, 0x00, 0x38, 0x09, 0x04, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x32, 0x30, 0x5f, 
  0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 
  0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0x74, 0x09, 0x04, 0x00, 0xd8, 0x08, 0x04, 0x00, 
  0x4e, 0x31, 0x30, 0x5f, 0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 
  0x31, 0x32, 0x39, 0x5f, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 
  0x5f, 0x74, 0x6f, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x74, 
  0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0xa8, 0x09, 0x04, 0x00, 0x38, 0x09, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xd8, 0x08, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 
  0x6a, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 
  0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x0a, 0x04, 0x00, 
  0x69, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 
  0x6c, 0x00, 0x00, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x32, 0x33, 0x5f, 
  0x5f, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 
  0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0x28, 0x0a, 0x04, 0x00, 0xd8, 0x08, 0x04, 0x00, 
  0x76, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0x5c, 0x0a, 0x04, 0x00, 
  0x50, 0x76, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x68, 0x0a, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x60, 0x0a, 0x04, 0x00, 0x50, 0x4b, 0x76, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x7c, 0x0a, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x60, 0x0a, 0x04, 0x00, 0x44, 0x6e, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0x90, 0x0a, 0x04, 0x00, 0x50, 0x44, 0x6e, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x9c, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x0a, 0x04, 0x00, 
  0x50, 0x4b, 0x44, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0xb0, 0x0a, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x94, 0x0a, 0x04, 0x00, 
  0x62, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0xc8, 0x0a, 0x04, 0x00, 
  0x50, 0x62, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xd4, 0x0a, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xcc, 0x0a, 0x04, 0x00, 0x50, 0x4b, 0x62, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0xe8, 0x0a, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0xcc, 0x0a, 0x04, 0x00, 0x77, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0xfc, 0x0a, 0x04, 0x00, 0x50, 0x77, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x08, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x04, 0x00, 
  0x50, 0x4b, 0x77, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x1c, 0x0b, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x04, 0x00, 0x63, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0x30, 0x0b, 0x04, 0x00, 0x50, 0x63, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x3c, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x34, 0x0b, 0x04, 0x00, 0x50, 0x4b, 0x63, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x50, 0x0b, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x34, 0x0b, 0x04, 0x00, 
  0x68, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0x64, 0x0b, 0x04, 0x00, 
  0x50, 0x68, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x70, 0x0b, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x68, 0x0b, 0x04, 0x00, 0x50, 0x4b, 0x68, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x84, 0x0b, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x68, 0x0b, 0x04, 0x00, 0x61, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0x98, 0x0b, 0x04, 0x00, 0x50, 0x61, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0xa4, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x0b, 0x04, 0x00, 
  0x50, 0x4b, 0x61, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xb8, 0x0b, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x9c, 0x0b, 0x04, 0x00, 0x73, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0xcc, 0x0b, 0x04, 0x00, 0x50, 0x73, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0xd8, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xd0, 0x0b, 0x04, 0x00, 0x50, 0x4b, 0x73, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0xec, 0x0b, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0xd0, 0x0b, 0x04, 0x00, 
  0x74, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0x00, 0x0c, 0x04, 0x00, 
  0x50, 0x74, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x0c, 0x0c, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x04, 0x00, 0x50, 0x4b, 0x74, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x20, 0x0c, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x04, 0x0c, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0x34, 0x0c, 0x04, 0x00, 0x50, 0x69, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x40, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x04, 0x00, 
  0x50, 0x4b, 0x69, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x54, 0x0c, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x04, 0x00, 0x6a, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0x68, 0x0c, 0x04, 0x00, 0x50, 0x6a, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x74, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x6c, 0x0c, 0x04, 0x00, 0x50, 0x4b, 0x6a, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x88, 0x0c, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x6c, 0x0c, 0x04, 0x00, 
  0x6c, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0x9c, 0x0c, 0x04, 0x00, 
  0x50, 0x6c, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xa8, 0x0c, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xa0, 0x0c, 0x04, 0x00, 0x50, 0x4b, 0x6c, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0xbc, 0x0c, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0xa0, 0x0c, 0x04, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0xd0, 0x0c, 0x04, 0x00, 0x50, 0x6d, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0xdc, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0x0c, 0x04, 0x00, 
  0x50, 0x4b, 0x6d, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xf0, 0x0c, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0xd4, 0x0c, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0x04, 0x0d, 0x04, 0x00, 0x50, 0x78, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x10, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x08, 0x0d, 0x04, 0x00, 0x50, 0x4b, 0x78, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x24, 0x0d, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0x0d, 0x04, 0x00, 
  0x79, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0x38, 0x0d, 0x04, 0x00, 
  0x50, 0x79, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x44, 0x0d, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x3c, 0x0d, 0x04, 0x00, 0x50, 0x4b, 0x79, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x58, 0x0d, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x3c, 0x0d, 0x04, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0x6c, 0x0d, 0x04, 0x00, 0x50, 0x6e, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x78, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x0d, 0x04, 0x00, 
  0x50, 0x4b, 0x6e, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x8c, 0x0d, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x70, 0x0d, 0x04, 0x00, 0x6f, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0xa0, 0x0d, 0x04, 0x00, 0x50, 0x6f, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0xac, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xa4, 0x0d, 0x04, 0x00, 0x50, 0x4b, 0x6f, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0xc0, 0x0d, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0xa4, 0x0d, 0x04, 0x00, 
  0x44, 0x68, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0xd4, 0x0d, 0x04, 0x00, 
  0x50, 0x44, 0x68, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xe0, 0x0d, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xd8, 0x0d, 0x04, 0x00, 0x50, 0x4b, 0x44, 0x68, 
  0x00, 0x00, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xf4, 0x0d, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0xd8, 0x0d, 0x04, 0x00, 0x66, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0x0c, 0x0e, 0x04, 0x00, 0x50, 0x66, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x18, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x10, 0x0e, 0x04, 0x00, 0x50, 0x4b, 0x66, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x2c, 0x0e, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x04, 0x00, 
  0x64, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0x40, 0x0e, 0x04, 0x00, 
  0x50, 0x64, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x4c, 0x0e, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x44, 0x0e, 0x04, 0x00, 0x50, 0x4b, 0x64, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x60, 0x0e, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x44, 0x0e, 0x04, 0x00, 0x65, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0x74, 0x0e, 0x04, 0x00, 0x50, 0x65, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x80, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0e, 0x04, 0x00, 
  0x50, 0x4b, 0x65, 0x00, 0x3c, 0x11, 0x04, 0x00, 0x94, 0x0e, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x78, 0x0e, 0x04, 0x00, 0x67, 0x00, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0xa8, 0x0e, 0x04, 0x00, 0x50, 0x67, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0xb4, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xac, 0x0e, 0x04, 0x00, 0x50, 0x4b, 0x67, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0xc8, 0x0e, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0xac, 0x0e, 0x04, 0x00, 
  0x44, 0x75, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 0xdc, 0x0e, 0x04, 0x00, 
  0x50, 0x44, 0x75, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xe8, 0x0e, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xe0, 0x0e, 0x04, 0x00, 0x50, 0x4b, 0x44, 0x75, 
  0x00, 0x00, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 0xfc, 0x0e, 0x04, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0xe0, 0x0e, 0x04, 0x00, 0x44, 0x73, 0x00, 0x00, 
  0x14, 0x0a, 0x04, 0x00, 0x14, 0x0f, 0x04, 0x00, 0x50, 0x44, 0x73, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x20, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x0f, 0x04, 0x00, 0x50, 0x4b, 0x44, 0x73, 0x00, 0x00, 0x00, 0x00, 
  0x3c, 0x11, 0x04, 0x00, 0x34, 0x0f, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x18, 0x0f, 0x04, 0x00, 0x44, 0x69, 0x00, 0x00, 0x14, 0x0a, 0x04, 0x00, 
  0x4c, 0x0f, 0x04, 0x00, 0x50, 0x44, 0x69, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x58, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x0f, 0x04, 0x00, 
  0x50, 0x4b, 0x44, 0x69, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x11, 0x04, 0x00, 
  0x6c, 0x0f, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x0f, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xc4, 0x0f, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 
  0x6f, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 
  0x70, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x5f, 0x5f, 0x63, 0x78, 0x78, 
  0x61, 0x62, 0x69, 0x76, 0x31, 0x31, 0x37, 0x5f, 0x5f, 0x61, 0x72, 0x72, 
  0x61, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 
  0x45, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 0xa0, 0x0f, 0x04, 0x00, 
  0xd8, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x09, 0x04, 0x00, 
  0x69, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 
  0x6c, 0x00, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x2c, 0x10, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00, 
  0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 
  0x4e, 0x31, 0x30, 0x5f, 0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 
  0x31, 0x31, 0x36, 0x5f, 0x5f, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x79, 
  0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0x08, 0x10, 0x04, 0x00, 0xd8, 0x08, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 
  0x75, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 
  0x76, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 
  0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x10, 0x04, 0x00, 
  0x69, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 
  0x6c, 0x00, 0x00, 0x00, 0x76, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x00, 0x00, 
  0x7c, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x5f, 
  0x5f, 0x63, 0x78, 0x78, 0x61, 0x62, 0x69, 0x76, 0x31, 0x32, 0x30, 0x5f, 
  0x5f, 0x73, 0x69, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x74, 0x79, 
  0x70, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x00, 
  0x68, 0x10, 0x04, 0x00, 0x88, 0x10, 0x04, 0x00, 0x08, 0x09, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x11, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 
  0x7e, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 
  0x76, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 
  0x81, 0x00, 0x00, 0x00, 0x4e, 0x31, 0x30, 0x5f, 0x5f, 0x63, 0x78, 0x78, 
  0x61, 0x62, 0x69, 0x76, 0x31, 0x32, 0x31, 0x5f, 0x5f, 0x76, 0x6d, 0x69, 
  0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 
  0x69, 0x6e, 0x66, 0x6f, 0x45, 0x00, 0x00, 0x00, 0x68, 0x10, 0x04, 0x00, 
  0xe4, 0x10, 0x04, 0x00, 0x08, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x38, 0x09, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 
  0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x68, 0x09, 0x04, 0x00, 0x69, 0x00, 0x00, 0x00, 
  0x84, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 
  0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x09, 0x04, 0x00, 
  0x69, 0x00, 0x00, 0x00, 0x86, 0x00, 0x00, 0x00, 0x6b, 0x00, 0x00, 0x00, 
  0x6c, 0x00, 0x00, 0x00, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x00, 0x00, 0x83, 0xf9, 0xa2, 0x00, 0x44, 0x4e, 0x6e, 0x00, 
  0xfc, 0x29, 0x15, 0x00, 0xd1, 0x57, 0x27, 0x00, 0xdd, 0x34, 0xf5, 0x00, 
  0x62, 0xdb, 0xc0, 0x00, 0x3c, 0x99, 0x95, 0x00, 0x41, 0x90, 0x43, 0x00, 
  0x63, 0x51, 0xfe, 0x00, 0xbb, 0xde, 0xab, 0x00, 0xb7, 0x61, 0xc5, 0x00, 
  0x3a, 0x6e, 0x24, 0x00, 0xd2, 0x4d, 0x42, 0x00, 0x49, 0x06, 0xe0, 0x00, 
  0x09, 0xea, 0x2e, 0x00, 0x1c, 0x92, 0xd1, 0x00, 0xeb, 0x1d, 0xfe, 0x00, 
  0x29, 0xb1, 0x1c, 0x00, 0xe8, 0x3e, 0xa7, 0x00, 0xf5, 0x35, 0x82, 0x00, 
  0x44, 0xbb, 0x2e, 0x00, 0x9c, 0xe9, 0x84, 0x00, 0xb4, 0x26, 0x70, 0x00, 
  0x41, 0x7e, 0x5f, 0x00, 0xd6, 0x91, 0x39, 0x00, 0x53, 0x83, 0x39, 0x00, 
  0x9c, 0xf4, 0x39, 0x00, 0x8b, 0x5f, 0x84, 0x00, 0x28, 0xf9, 0xbd, 0x00, 
  0xf8, 0x1f, 0x3b, 0x00, 0xde, 0xff, 0x97, 0x00, 0x0f, 0x98, 0x05, 0x00, 
  0x11, 0x2f, 0xef, 0x00, 0x0a, 0x5a, 0x8b, 0x00, 0x6d, 0x1f, 0x6d, 0x00, 
  0xcf, 0x7e, 0x36, 0x00, 0x09, 0xcb, 0x27, 0x00, 0x46, 0x4f, 0xb7, 0x00, 
  0x9e, 0x66, 0x3f, 0x00, 0x2d, 0xea, 0x5f, 0x00, 0xba, 0x27, 0x75, 0x00, 
  0xe5, 0xeb, 0xc7, 0x00, 0x3d, 0x7b, 0xf1, 0x00, 0xf7, 0x39, 0x07, 0x00, 
  0x92, 0x52, 0x8a, 0x00, 0xfb, 0x6b, 0xea, 0x00, 0x1f, 0xb1, 0x5f, 0x00, 
  0x08, 0x5d, 0x8d, 0x00, 0x30, 0x03, 0x56, 0x00, 0x7b, 0xfc, 0x46, 0x00, 
  0xf0, 0xab, 0x6b, 0x00, 0x20, 0xbc, 0xcf, 0x00, 0x36, 0xf4, 0x9a, 0x00, 
  0xe3, 0xa9, 0x1d, 0x00, 0x5e, 0x61, 0x91, 0x00, 0x08, 0x1b, 0xe6, 0x00, 
  0x85, 0x99, 0x65, 0x00, 0xa0, 0x14, 0x5f, 0x00, 0x8d, 0x40, 0x68, 0x00, 
  0x80, 0xd8, 0xff, 0x00, 0x27, 0x73, 0x4d, 0x00, 0x06, 0x06, 0x31, 0x00, 
  0xca, 0x56, 0x15, 0x00, 0xc9, 0xa8, 0x73, 0x00, 0x7b, 0xe2, 0x60, 0x00, 
  0x6b, 0x8c, 0xc0, 0x00, 0x19, 0xc4, 0x47, 0x00, 0xcd, 0x67, 0xc3, 0x00, 
  0x09, 0xe8, 0xdc, 0x00, 0x59, 0x83, 0x2a, 0x00, 0x8b, 0x76, 0xc4, 0x00, 
  0xa6, 0x1c, 0x96, 0x00, 0x44, 0xaf, 0xdd, 0x00, 0x19, 0x57, 0xd1, 0x00, 
  0xa5, 0x3e, 0x05, 0x00, 0x05, 0x07, 0xff, 0x00, 0x33, 0x7e, 0x3f, 0x00, 
  0xc2, 0x32, 0xe8, 0x00, 0x98, 0x4f, 0xde, 0x00, 0xbb, 0x7d, 0x32, 0x00, 
  0x26, 0x3d, 0xc3, 0x00, 0x1e, 0x6b, 0xef, 0x00, 0x9f, 0xf8, 0x5e, 0x00, 
  0x35, 0x1f, 0x3a, 0x00, 0x7f, 0xf2, 0xca, 0x00, 0xf1, 0x87, 0x1d, 0x00, 
  0x7c, 0x90, 0x21, 0x00, 0x6a, 0x24, 0x7c, 0x00, 0xd5, 0x6e, 0xfa, 0x00, 
  0x30, 0x2d, 0x77, 0x00, 0x15, 0x3b, 0x43, 0x00, 0xb5, 0x14, 0xc6, 0x00, 
  0xc3, 0x19, 0x9d, 0x00, 0xad, 0xc4, 0xc2, 0x00, 0x2c, 0x4d, 0x41, 0x00, 
  0x0c, 0x00, 0x5d, 0x00, 0x86, 0x7d, 0x46, 0x00, 0xe3, 0x71, 0x2d, 0x00, 
  0x9b, 0xc6, 0x9a, 0x00, 0x33, 0x62, 0x00, 0x00, 0xb4, 0xd2, 0x7c, 0x00, 
  0xb4, 0xa7, 0x97, 0x00, 0x37, 0x55, 0xd5, 0x00, 0xd7, 0x3e, 0xf6, 0x00, 
  0xa3, 0x10, 0x18, 0x00, 0x4d, 0x76, 0xfc, 0x00, 0x64, 0x9d, 0x2a, 0x00, 
  0x70, 0xd7, 0xab, 0x00, 0x63, 0x7c, 0xf8, 0x00, 0x7a, 0xb0, 0x57, 0x00, 
  0x17, 0x15, 0xe7, 0x00, 0xc0, 0x49, 0x56, 0x00, 0x3b, 0xd6, 0xd9, 0x00, 
  0xa7, 0x84, 0x38, 0x00, 0x24, 0x23, 0xcb, 0x00, 0xd6, 0x8a, 0x77, 0x00, 
  0x5a, 0x54, 0x23, 0x00, 0x00, 0x1f, 0xb9, 0x00, 0xf1, 0x0a, 0x1b, 0x00, 
  0x19, 0xce, 0xdf, 0x00, 0x9f, 0x31, 0xff, 0x00, 0x66, 0x1e, 0x6a, 0x00, 
  0x99, 0x57, 0x61, 0x00, 0xac, 0xfb, 0x47, 0x00, 0x7e, 0x7f, 0xd8, 0x00, 
  0x22, 0x65, 0xb7, 0x00, 0x32, 0xe8, 0x89, 0x00, 0xe6, 0xbf, 0x60, 0x00, 
  0xef, 0xc4, 0xcd, 0x00, 0x6c, 0x36, 0x09, 0x00, 0x5d, 0x3f, 0xd4, 0x00, 
  0x16, 0xde, 0xd7, 0x00, 0x58, 0x3b, 0xde, 0x00, 0xde, 0x9b, 0x92, 0x00, 
  0xd2, 0x22, 0x28, 0x00, 0x28, 0x86, 0xe8, 0x00, 0xe2, 0x58, 0x4d, 0x00, 
  0xc6, 0xca, 0x32, 0x00, 0x08, 0xe3, 0x16, 0x00, 0xe0, 0x7d, 0xcb, 0x00, 
  0x17, 0xc0, 0x50, 0x00, 0xf3, 0x1d, 0xa7, 0x00, 0x18, 0xe0, 0x5b, 0x00, 
  0x2e, 0x13, 0x34, 0x00, 0x83, 0x12, 0x62, 0x00, 0x83, 0x48, 0x01, 0x00, 
  0xf5, 0x8e, 0x5b, 0x00, 0xad, 0xb0, 0x7f, 0x00, 0x1e, 0xe9, 0xf2, 0x00, 
  0x48, 0x4a, 0x43, 0x00, 0x10, 0x67, 0xd3, 0x00, 0xaa, 0xdd, 0xd8, 0x00, 
  0xae, 0x5f, 0x42, 0x00, 0x6a, 0x61, 0xce, 0x00, 0x0a, 0x28, 0xa4, 0x00, 
  0xd3, 0x99, 0xb4, 0x00, 0x06, 0xa6, 0xf2, 0x00, 0x5c, 0x77, 0x7f, 0x00, 
  0xa3, 0xc2, 0x83, 0x00, 0x61, 0x3c, 0x88, 0x00, 0x8a, 0x73, 0x78, 0x00, 
  0xaf, 0x8c, 0x5a, 0x00, 0x6f, 0xd7, 0xbd, 0x00, 0x2d, 0xa6, 0x63, 0x00, 
  0xf4, 0xbf, 0xcb, 0x00, 0x8d, 0x81, 0xef, 0x00, 0x26, 0xc1, 0x67, 0x00, 
  0x55, 0xca, 0x45, 0x00, 0xca, 0xd9, 0x36, 0x00, 0x28, 0xa8, 0xd2, 0x00, 
  0xc2, 0x61, 0x8d, 0x00, 0x12, 0xc9, 0x77, 0x00, 0x04, 0x26, 0x14, 0x00, 
  0x12, 0x46, 0x9b, 0x00, 0xc4, 0x59, 0xc4, 0x00, 0xc8, 0xc5, 0x44, 0x00, 
  0x4d, 0xb2, 0x91, 0x00, 0x00, 0x17, 0xf3, 0x00, 0xd4, 0x43, 0xad, 0x00, 
  0x29, 0x49, 0xe5, 0x00, 0xfd, 0xd5, 0x10, 0x00, 0x00, 0xbe, 0xfc, 0x00, 
  0x1e, 0x94, 0xcc, 0x00, 0x70, 0xce, 0xee, 0x00, 0x13, 0x3e, 0xf5, 0x00, 
  0xec, 0xf1, 0x80, 0x00, 0xb3, 0xe7, 0xc3, 0x00, 0xc7, 0xf8, 0x28, 0x00, 
  0x93, 0x05, 0x94, 0x00, 0xc1, 0x71, 0x3e, 0x00, 0x2e, 0x09, 0xb3, 0x00, 
  0x0b, 0x45, 0xf3, 0x00, 0x88, 0x12, 0x9c, 0x00, 0xab, 0x20, 0x7b, 0x00, 
  0x2e, 0xb5, 0x9f, 0x00, 0x47, 0x92, 0xc2, 0x00, 0x7b, 0x32, 0x2f, 0x00, 
  0x0c, 0x55, 0x6d, 0x00, 0x72, 0xa7, 0x90, 0x00, 0x6b, 0xe7, 0x1f, 0x00, 
  0x31, 0xcb, 0x96, 0x00, 0x79, 0x16, 0x4a, 0x00, 0x41, 0x79, 0xe2, 0x00, 
  0xf4, 0xdf, 0x89, 0x00, 0xe8, 0x94, 0x97, 0x00, 0xe2, 0xe6, 0x84, 0x00, 
  0x99, 0x31, 0x97, 0x00, 0x88, 0xed, 0x6b, 0x00, 0x5f, 0x5f, 0x36, 0x00, 
  0xbb, 0xfd, 0x0e, 0x00, 0x48, 0x9a, 0xb4, 0x00, 0x67, 0xa4, 0x6c, 0x00, 
  0x71, 0x72, 0x42, 0x00, 0x8d, 0x5d, 0x32, 0x00, 0x9f, 0x15, 0xb8, 0x00, 
  0xbc, 0xe5, 0x09, 0x00, 0x8d, 0x31, 0x25, 0x00, 0xf7, 0x74, 0x39, 0x00, 
  0x30, 0x05, 0x1c, 0x00, 0x0d, 0x0c, 0x01, 0x00, 0x4b, 0x08, 0x68, 0x00, 
  0x2c, 0xee, 0x58, 0x00, 0x47, 0xaa, 0x90, 0x00, 0x74, 0xe7, 0x02, 0x00, 
  0xbd, 0xd6, 0x24, 0x00, 0xf7, 0x7d, 0xa6, 0x00, 0x6e, 0x48, 0x72, 0x00, 
  0x9f, 0x16, 0xef, 0x00, 0x8e, 0x94, 0xa6, 0x00, 0xb4, 0x91, 0xf6, 0x00, 
  0xd1, 0x53, 0x51, 0x00, 0xcf, 0x0a, 0xf2, 0x00, 0x20, 0x98, 0x33, 0x00, 
  0xf5, 0x4b, 0x7e, 0x00, 0xb2, 0x63, 0x68, 0x00, 0xdd, 0x3e, 0x5f, 0x00, 
  0x40, 0x5d, 0x03, 0x00, 0x85, 0x89, 0x7f, 0x00, 0x55, 0x52, 0x29, 0x00, 
  0x37, 0x64, 0xc0, 0x00, 0x6d, 0xd8, 0x10, 0x00, 0x32, 0x48, 0x32, 0x00, 
  0x5b, 0x4c, 0x75, 0x00, 0x4e, 0x71, 0xd4, 0x00, 0x45, 0x54, 0x6e, 0x00, 
  0x0b, 0x09, 0xc1, 0x00, 0x2a, 0xf5, 0x69, 0x00, 0x14, 0x66, 0xd5, 0x00, 
  0x27, 0x07, 0x9d, 0x00, 0x5d, 0x04, 0x50, 0x00, 0xb4, 0x3b, 0xdb, 0x00, 
  0xea, 0x76, 0xc5, 0x00, 0x87, 0xf9, 0x17, 0x00, 0x49, 0x6b, 0x7d, 0x00, 
  0x1d, 0x27, 0xba, 0x00, 0x96, 0x69, 0x29, 0x00, 0xc6, 0xcc, 0xac, 0x00, 
  0xad, 0x14, 0x54, 0x00, 0x90, 0xe2, 0x6a, 0x00, 0x88, 0xd9, 0x89, 0x00, 
  0x2c, 0x72, 0x50, 0x00, 0x04, 0xa4, 0xbe, 0x00, 0x77, 0x07, 0x94, 0x00, 
  0xf3, 0x30, 0x70, 0x00, 0x00, 0xfc, 0x27, 0x00, 0xea, 0x71, 0xa8, 0x00, 
  0x66, 0xc2, 0x49, 0x00, 0x64, 0xe0, 0x3d, 0x00, 0x97, 0xdd, 0x83, 0x00, 
  0xa3, 0x3f, 0x97, 0x00, 0x43, 0x94, 0xfd, 0x00, 0x0d, 0x86, 0x8c, 0x00, 
  0x31, 0x41, 0xde, 0x00, 0x92, 0x39, 0x9d, 0x00, 0xdd, 0x70, 0x8c, 0x00, 
  0x17, 0xb7, 0xe7, 0x00, 0x08, 0xdf, 0x3b, 0x00, 0x15, 0x37, 0x2b, 0x00, 
  0x5c, 0x80, 0xa0, 0x00, 0x5a, 0x80, 0x93, 0x00, 0x10, 0x11, 0x92, 0x00, 
  0x0f, 0xe8, 0xd8, 0x00, 0x6c, 0x80, 0xaf, 0x00, 0xdb, 0xff, 0x4b, 0x00, 
  0x38, 0x90, 0x0f, 0x00, 0x59, 0x18, 0x76, 0x00, 0x62, 0xa5, 0x15, 0x00, 
  0x61, 0xcb, 0xbb, 0x00, 0xc7, 0x89, 0xb9, 0x00, 0x10, 0x40, 0xbd, 0x00, 
  0xd2, 0xf2, 0x04, 0x00, 0x49, 0x75, 0x27, 0x00, 0xeb, 0xb6, 0xf6, 0x00, 
  0xdb, 0x22, 0xbb, 0x00, 0x0a, 0x14, 0xaa, 0x00, 0x89, 0x26, 0x2f, 0x00, 
  0x64, 0x83, 0x76, 0x00, 0x09, 0x3b, 0x33, 0x00, 0x0e, 0x94, 0x1a, 0x00, 
  0x51, 0x3a, 0xaa, 0x00, 0x1d, 0xa3, 0xc2, 0x00, 0xaf, 0xed, 0xae, 0x00, 
  0x5c, 0x26, 0x12, 0x00, 0x6d, 0xc2, 0x4d, 0x00, 0x2d, 0x7a, 0x9c, 0x00, 
  0xc0, 0x56, 0x97, 0x00, 0x03, 0x3f, 0x83, 0x00, 0x09, 0xf0, 0xf6, 0x00, 
  0x2b, 0x40, 0x8c, 0x00, 0x6d, 0x31, 0x99, 0x00, 0x39, 0xb4, 0x07, 0x00, 
  0x0c, 0x20, 0x15, 0x00, 0xd8, 0xc3, 0x5b, 0x00, 0xf5, 0x92, 0xc4, 0x00, 
  0xc6, 0xad, 0x4b, 0x00, 0x4e, 0xca, 0xa5, 0x00, 0xa7, 0x37, 0xcd, 0x00, 
  0xe6, 0xa9, 0x36, 0x00, 0xab, 0x92, 0x94, 0x00, 0xdd, 0x42, 0x68, 0x00, 
  0x19, 0x63, 0xde, 0x00, 0x76, 0x8c, 0xef, 0x00, 0x68, 0x8b, 0x52, 0x00, 
  0xfc, 0xdb, 0x37, 0x00, 0xae, 0xa1, 0xab, 0x00, 0xdf, 0x15, 0x31, 0x00, 
  0x00, 0xae, 0xa1, 0x00, 0x0c, 0xfb, 0xda, 0x00, 0x64, 0x4d, 0x66, 0x00, 
  0xed, 0x05, 0xb7, 0x00, 0x29, 0x65, 0x30, 0x00, 0x57, 0x56, 0xbf, 0x00, 
  0x47, 0xff, 0x3a, 0x00, 0x6a, 0xf9, 0xb9, 0x00, 0x75, 0xbe, 0xf3, 0x00, 
  0x28, 0x93, 0xdf, 0x00, 0xab, 0x80, 0x30, 0x00, 0x66, 0x8c, 0xf6, 0x00, 
  0x04, 0xcb, 0x15, 0x00, 0xfa, 0x22, 0x06, 0x00, 0xd9, 0xe4, 0x1d, 0x00, 
  0x3d, 0xb3, 0xa4, 0x00, 0x57, 0x1b, 0x8f, 0x00, 0x36, 0xcd, 0x09, 0x00, 
  0x4e, 0x42, 0xe9, 0x00, 0x13, 0xbe, 0xa4, 0x00, 0x33, 0x23, 0xb5, 0x00, 
  0xf0, 0xaa, 0x1a, 0x00, 0x4f, 0x65, 0xa8, 0x00, 0xd2, 0xc1, 0xa5, 0x00, 
  0x0b, 0x3f, 0x0f, 0x00, 0x5b, 0x78, 0xcd, 0x00, 0x23, 0xf9, 0x76, 0x00, 
  0x7b, 0x8b, 0x04, 0x00, 0x89, 0x17, 0x72, 0x00, 0xc6, 0xa6, 0x53, 0x00, 
  0x6f, 0x6e, 0xe2, 0x00, 0xef, 0xeb, 0x00, 0x00, 0x9b, 0x4a, 0x58, 0x00, 
  0xc4, 0xda, 0xb7, 0x00, 0xaa, 0x66, 0xba, 0x00, 0x76, 0xcf, 0xcf, 0x00, 
  0xd1, 0x02, 0x1d, 0x00, 0xb1, 0xf1, 0x2d, 0x00, 0x8c, 0x99, 0xc1, 0x00, 
  0xc3, 0xad, 0x77, 0x00, 0x86, 0x48, 0xda, 0x00, 0xf7, 0x5d, 0xa0, 0x00, 
  0xc6, 0x80, 0xf4, 0x00, 0xac, 0xf0, 0x2f, 0x00, 0xdd, 0xec, 0x9a, 0x00, 
  0x3f, 0x5c, 0xbc, 0x00, 0xd0, 0xde, 0x6d, 0x00, 0x90, 0xc7, 0x1f, 0x00, 
  0x2a, 0xdb, 0xb6, 0x00, 0xa3, 0x25, 0x3a, 0x00, 0x00, 0xaf, 0x9a, 0x00, 
  0xad, 0x53, 0x93, 0x00, 0xb6, 0x57, 0x04, 0x00, 0x29, 0x2d, 0xb4, 0x00, 
  0x4b, 0x80, 0x7e, 0x00, 0xda, 0x07, 0xa7, 0x00, 0x76, 0xaa, 0x0e, 0x00, 
  0x7b, 0x59, 0xa1, 0x00, 0x16, 0x12, 0x2a, 0x00, 0xdc, 0xb7, 0x2d, 0x00, 
  0xfa, 0xe5, 0xfd, 0x00, 0x89, 0xdb, 0xfe, 0x00, 0x89, 0xbe, 0xfd, 0x00, 
  0xe4, 0x76, 0x6c, 0x00, 0x06, 0xa9, 0xfc, 0x00, 0x3e, 0x80, 0x70, 0x00, 
  0x85, 0x6e, 0x15, 0x00, 0xfd, 0x87, 0xff, 0x00, 0x28, 0x3e, 0x07, 0x00, 
  0x61, 0x67, 0x33, 0x00, 0x2a, 0x18, 0x86, 0x00, 0x4d, 0xbd, 0xea, 0x00, 
  0xb3, 0xe7, 0xaf, 0x00, 0x8f, 0x6d, 0x6e, 0x00, 0x95, 0x67, 0x39, 0x00, 
  0x31, 0xbf, 0x5b, 0x00, 0x84, 0xd7, 0x48, 0x00, 0x30, 0xdf, 0x16, 0x00, 
  0xc7, 0x2d, 0x43, 0x00, 0x25, 0x61, 0x35, 0x00, 0xc9, 0x70, 0xce, 0x00, 
  0x30, 0xcb, 0xb8, 0x00, 0xbf, 0x6c, 0xfd, 0x00, 0xa4, 0x00, 0xa2, 0x00, 
  0x05, 0x6c, 0xe4, 0x00, 0x5a, 0xdd, 0xa0, 0x00, 0x21, 0x6f, 0x47, 0x00, 
  0x62, 0x12, 0xd2, 0x00, 0xb9, 0x5c, 0x84, 0x00, 0x70, 0x61, 0x49, 0x00, 
  0x6b, 0x56, 0xe0, 0x00, 0x99, 0x52, 0x01, 0x00, 0x50, 0x55, 0x37, 0x00, 
  0x1e, 0xd5, 0xb7, 0x00, 0x33, 0xf1, 0xc4, 0x00, 0x13, 0x6e, 0x5f, 0x00, 
  0x5d, 0x30, 0xe4, 0x00, 0x85, 0x2e, 0xa9, 0x00, 0x1d, 0xb2, 0xc3, 0x00, 
  0xa1, 0x32, 0x36, 0x00, 0x08, 0xb7, 0xa4, 0x00, 0xea, 0xb1, 0xd4, 0x00, 
  0x16, 0xf7, 0x21, 0x00, 0x8f, 0x69, 0xe4, 0x00, 0x27, 0xff, 0x77, 0x00, 
  0x0c, 0x03, 0x80, 0x00, 0x8d, 0x40, 0x2d, 0x00, 0x4f, 0xcd, 0xa0, 0x00, 
  0x20, 0xa5, 0x99, 0x00, 0xb3, 0xa2, 0xd3, 0x00, 0x2f, 0x5d, 0x0a, 0x00, 
  0xb4, 0xf9, 0x42, 0x00, 0x11, 0xda, 0xcb, 0x00, 0x7d, 0xbe, 0xd0, 0x00, 
  0x9b, 0xdb, 0xc1, 0x00, 0xab, 0x17, 0xbd, 0x00, 0xca, 0xa2, 0x81, 0x00, 
  0x08, 0x6a, 0x5c, 0x00, 0x2e, 0x55, 0x17, 0x00, 0x27, 0x00, 0x55, 0x00, 
  0x7f, 0x14, 0xf0, 0x00, 0xe1, 0x07, 0x86, 0x00, 0x14, 0x0b, 0x64, 0x00, 
  0x96, 0x41, 0x8d, 0x00, 0x87, 0xbe, 0xde, 0x00, 0xda, 0xfd, 0x2a, 0x00, 
  0x6b, 0x25, 0xb6, 0x00, 0x7b, 0x89, 0x34, 0x00, 0x05, 0xf3, 0xfe, 0x00, 
  0xb9, 0xbf, 0x9e, 0x00, 0x68, 0x6a, 0x4f, 0x00, 0x4a, 0x2a, 0xa8, 0x00, 
  0x4f, 0xc4, 0x5a, 0x00, 0x2d, 0xf8, 0xbc, 0x00, 0xd7, 0x5a, 0x98, 0x00, 
  0xf4, 0xc7, 0x95, 0x00, 0x0d, 0x4d, 0x8d, 0x00, 0x20, 0x3a, 0xa6, 0x00, 
  0xa4, 0x57, 0x5f, 0x00, 0x14, 0x3f, 0xb1, 0x00, 0x80, 0x38, 0x95, 0x00, 
  0xcc, 0x20, 0x01, 0x00, 0x71, 0xdd, 0x86, 0x00, 0xc9, 0xde, 0xb6, 0x00, 
  0xbf, 0x60, 0xf5, 0x00, 0x4d, 0x65, 0x11, 0x00, 0x01, 0x07, 0x6b, 0x00, 
  0x8c, 0xb0, 0xac, 0x00, 0xb2, 0xc0, 0xd0, 0x00, 0x51, 0x55, 0x48, 0x00, 
  0x1e, 0xfb, 0x0e, 0x00, 0x95, 0x72, 0xc3, 0x00, 0xa3, 0x06, 0x3b, 0x00, 
  0xc0, 0x40, 0x35, 0x00, 0x06, 0xdc, 0x7b, 0x00, 0xe0, 0x45, 0xcc, 0x00, 
  0x4e, 0x29, 0xfa, 0x00, 0xd6, 0xca, 0xc8, 0x00, 0xe8, 0xf3, 0x41, 0x00, 
  0x7c, 0x64, 0xde, 0x00, 0x9b, 0x64, 0xd8, 0x00, 0xd9, 0xbe, 0x31, 0x00, 
  0xa4, 0x97, 0xc3, 0x00, 0x77, 0x58, 0xd4, 0x00, 0x69, 0xe3, 0xc5, 0x00, 
  0xf0, 0xda, 0x13, 0x00, 0xba, 0x3a, 0x3c, 0x00, 0x46, 0x18, 0x46, 0x00, 
  0x55, 0x75, 0x5f, 0x00, 0xd2, 0xbd, 0xf5, 0x00, 0x6e, 0x92, 0xc6, 0x00, 
  0xac, 0x2e, 0x5d, 0x00, 0x0e, 0x44, 0xed, 0x00, 0x1c, 0x3e, 0x42, 0x00, 
  0x61, 0xc4, 0x87, 0x00, 0x29, 0xfd, 0xe9, 0x00, 0xe7, 0xd6, 0xf3, 0x00, 
  0x22, 0x7c, 0xca, 0x00, 0x6f, 0x91, 0x35, 0x00, 0x08, 0xe0, 0xc5, 0x00, 
  0xff, 0xd7, 0x8d, 0x00, 0x6e, 0x6a, 0xe2, 0x00, 0xb0, 0xfd, 0xc6, 0x00, 
  0x93, 0x08, 0xc1, 0x00, 0x7c, 0x5d, 0x74, 0x00, 0x6b, 0xad, 0xb2, 0x00, 
  0xcd, 0x6e, 0x9d, 0x00, 0x3e, 0x72, 0x7b, 0x00, 0xc6, 0x11, 0x6a, 0x00, 
  0xf7, 0xcf, 0xa9, 0x00, 0x29, 0x73, 0xdf, 0x00, 0xb5, 0xc9, 0xba, 0x00, 
  0xb7, 0x00, 0x51, 0x00, 0xe2, 0xb2, 0x0d, 0x00, 0x74, 0xba, 0x24, 0x00, 
  0xe5, 0x7d, 0x60, 0x00, 0x74, 0xd8, 0x8a, 0x00, 0x0d, 0x15, 0x2c, 0x00, 
  0x81, 0x18, 0x0c, 0x00, 0x7e, 0x66, 0x94, 0x00, 0x01, 0x29, 0x16, 0x00, 
  0x9f, 0x7a, 0x76, 0x00, 0xfd, 0xfd, 0xbe, 0x00, 0x56, 0x45, 0xef, 0x00, 
  0xd9, 0x7e, 0x36, 0x00, 0xec, 0xd9, 0x13, 0x00, 0x8b, 0xba, 0xb9, 0x00, 
  0xc4, 0x97, 0xfc, 0x00, 0x31, 0xa8, 0x27, 0x00, 0xf1, 0x6e, 0xc3, 0x00, 
  0x94, 0xc5, 0x36, 0x00, 0xd8, 0xa8, 0x56, 0x00, 0xb4, 0xa8, 0xb5, 0x00, 
  0xcf, 0xcc, 0x0e, 0x00, 0x12, 0x89, 0x2d, 0x00, 0x6f, 0x57, 0x34, 0x00, 
  0x2c, 0x56, 0x89, 0x00, 0x99, 0xce, 0xe3, 0x00, 0xd6, 0x20, 0xb9, 0x00, 
  0x6b, 0x5e, 0xaa, 0x00, 0x3e, 0x2a, 0x9c, 0x00, 0x11, 0x5f, 0xcc, 0x00, 
  0xfd, 0x0b, 0x4a, 0x00, 0xe1, 0xf4, 0xfb, 0x00, 0x8e, 0x3b, 0x6d, 0x00, 
  0xe2, 0x86, 0x2c, 0x00, 0xe9, 0xd4, 0x84, 0x00, 0xfc, 0xb4, 0xa9, 0x00, 
  0xef, 0xee, 0xd1, 0x00, 0x2e, 0x35, 0xc9, 0x00, 0x2f, 0x39, 0x61, 0x00, 
  0x38, 0x21, 0x44, 0x00, 0x1b, 0xd9, 0xc8, 0x00, 0x81, 0xfc, 0x0a, 0x00, 
  0xfb, 0x4a, 0x6a, 0x00, 0x2f, 0x1c, 0xd8, 0x00, 0x53, 0xb4, 0x84, 0x00, 
  0x4e, 0x99, 0x8c, 0x00, 0x54, 0x22, 0xcc, 0x00, 0x2a, 0x55, 0xdc, 0x00, 
  0xc0, 0xc6, 0xd6, 0x00, 0x0b, 0x19, 0x96, 0x00, 0x1a, 0x70, 0xb8, 0x00, 
  0x69, 0x95, 0x64, 0x00, 0x26, 0x5a, 0x60, 0x00, 0x3f, 0x52, 0xee, 0x00, 
  0x7f, 0x11, 0x0f, 0x00, 0xf4, 0xb5, 0x11, 0x00, 0xfc, 0xcb, 0xf5, 0x00, 
  0x34, 0xbc, 0x2d, 0x00, 0x34, 0xbc, 0xee, 0x00, 0xe8, 0x5d, 0xcc, 0x00, 
  0xdd, 0x5e, 0x60, 0x00, 0x67, 0x8e, 0x9b, 0x00, 0x92, 0x33, 0xef, 0x00, 
  0xc9, 0x17, 0xb8, 0x00, 0x61, 0x58, 0x9b, 0x00, 0xe1, 0x57, 0xbc, 0x00, 
  0x51, 0x83, 0xc6, 0x00, 0xd8, 0x3e, 0x10, 0x00, 0xdd, 0x71, 0x48, 0x00, 
  0x2d, 0x1c, 0xdd, 0x00, 0xaf, 0x18, 0xa1, 0x00, 0x21, 0x2c, 0x46, 0x00, 
  0x59, 0xf3, 0xd7, 0x00, 0xd9, 0x7a, 0x98, 0x00, 0x9e, 0x54, 0xc0, 0x00, 
  0x4f, 0x86, 0xfa, 0x00, 0x56, 0x06, 0xfc, 0x00, 0xe5, 0x79, 0xae, 0x00, 
  0x89, 0x22, 0x36, 0x00, 0x38, 0xad, 0x22, 0x00, 0x67, 0x93, 0xdc, 0x00, 
  0x55, 0xe8, 0xaa, 0x00, 0x82, 0x26, 0x38, 0x00, 0xca, 0xe7, 0x9b, 0x00, 
  0x51, 0x0d, 0xa4, 0x00, 0x99, 0x33, 0xb1, 0x00, 0xa9, 0xd7, 0x0e, 0x00, 
  0x69, 0x05, 0x48, 0x00, 0x65, 0xb2, 0xf0, 0x00, 0x7f, 0x88, 0xa7, 0x00, 
  0x88, 0x4c, 0x97, 0x00, 0xf9, 0xd1, 0x36, 0x00, 0x21, 0x92, 0xb3, 0x00, 
  0x7b, 0x82, 0x4a, 0x00, 0x98, 0xcf, 0x21, 0x00, 0x40, 0x9f, 0xdc, 0x00, 
  0xdc, 0x47, 0x55, 0x00, 0xe1, 0x74, 0x3a, 0x00, 0x67, 0xeb, 0x42, 0x00, 
  0xfe, 0x9d, 0xdf, 0x00, 0x5e, 0xd4, 0x5f, 0x00, 0x7b, 0x67, 0xa4, 0x00, 
  0xba, 0xac, 0x7a, 0x00, 0x55, 0xf6, 0xa2, 0x00, 0x2b, 0x88, 0x23, 0x00, 
  0x41, 0xba, 0x55, 0x00, 0x59, 0x6e, 0x08, 0x00, 0x21, 0x2a, 0x86, 0x00, 
  0x39, 0x47, 0x83, 0x00, 0x89, 0xe3, 0xe6, 0x00, 0xe5, 0x9e, 0xd4, 0x00, 
  0x49, 0xfb, 0x40, 0x00, 0xff, 0x56, 0xe9, 0x00, 0x1c, 0x0f, 0xca, 0x00, 
  0xc5, 0x59, 0x8a, 0x00, 0x94, 0xfa, 0x2b, 0x00, 0xd3, 0xc1, 0xc5, 0x00, 
  0x0f, 0xc5, 0xcf, 0x00, 0xdb, 0x5a, 0xae, 0x00, 0x47, 0xc5, 0x86, 0x00, 
  0x85, 0x43, 0x62, 0x00, 0x21, 0x86, 0x3b, 0x00, 0x2c, 0x79, 0x94, 0x00, 
  0x10, 0x61, 0x87, 0x00, 0x2a, 0x4c, 0x7b, 0x00, 0x80, 0x2c, 0x1a, 0x00, 
  0x43, 0xbf, 0x12, 0x00, 0x88, 0x26, 0x90, 0x00, 0x78, 0x3c, 0x89, 0x00, 
  0xa8, 0xc4, 0xe4, 0x00, 0xe5, 0xdb, 0x7b, 0x00, 0xc4, 0x3a, 0xc2, 0x00, 
  0x26, 0xf4, 0xea, 0x00, 0xf7, 0x67, 0x8a, 0x00, 0x0d, 0x92, 0xbf, 0x00, 
  0x65, 0xa3, 0x2b, 0x00, 0x3d, 0x93, 0xb1, 0x00, 0xbd, 0x7c, 0x0b, 0x00, 
  0xa4, 0x51, 0xdc, 0x00, 0x27, 0xdd, 0x63, 0x00, 0x69, 0xe1, 0xdd, 0x00, 
  0x9a, 0x94, 0x19, 0x00, 0xa8, 0x29, 0x95, 0x00, 0x68, 0xce, 0x28, 0x00, 
  0x09, 0xed, 0xb4, 0x00, 0x44, 0x9f, 0x20, 0x00, 0x4e, 0x98, 0xca, 0x00, 
  0x70, 0x82, 0x63, 0x00, 0x7e, 0x7c, 0x23, 0x00, 0x0f, 0xb9, 0x32, 0x00, 
  0xa7, 0xf5, 0x8e, 0x00, 0x14, 0x56, 0xe7, 0x00, 0x21, 0xf1, 0x08, 0x00, 
  0xb5, 0x9d, 0x2a, 0x00, 0x6f, 0x7e, 0x4d, 0x00, 0xa5, 0x19, 0x51, 0x00, 
  0xb5, 0xf9, 0xab, 0x00, 0x82, 0xdf, 0xd6, 0x00, 0x96, 0xdd, 0x61, 0x00, 
  0x16, 0x36, 0x02, 0x00, 0xc4, 0x3a, 0x9f, 0x00, 0x83, 0xa2, 0xa1, 0x00, 
  0x72, 0xed, 0x6d, 0x00, 0x39, 0x8d, 0x7a, 0x00, 0x82, 0xb8, 0xa9, 0x00, 
  0x6b, 0x32, 0x5c, 0x00, 0x46, 0x27, 0x5b, 0x00, 0x00, 0x34, 0xed, 0x00, 
  0xd2, 0x00, 0x77, 0x00, 0xfc, 0xf4, 0x55, 0x00, 0x01, 0x59, 0x4d, 0x00, 
  0xe0, 0x71, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x40, 0xfb, 0x21, 0xf9, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x2d, 0x44, 0x74, 0x3e, 0x00, 0x00, 0x00, 0x80, 0x98, 0x46, 0xf8, 0x3c, 
  0x00, 0x00, 0x00, 0x60, 0x51, 0xcc, 0x78, 0x3b, 0x00, 0x00, 0x00, 0x80, 
  0x83, 0x1b, 0xf0, 0x39, 0x00, 0x00, 0x00, 0x40, 0x20, 0x25, 0x7a, 0x38, 
  0x00, 0x00, 0x00, 0x80, 0x22, 0x82, 0xe3, 0x36, 0x00, 0x00, 0x00, 0x00, 
  0x1d, 0xf3, 0x69, 0x35, 0xfe, 0x82, 0x2b, 0x65, 0x47, 0x15, 0x67, 0x40, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x43, 0x00, 0x00, 0xfa, 0xfe, 
  0x42, 0x2e, 0x76, 0xbf, 0x3a, 0x3b, 0x9e, 0xbc, 0x9a, 0xf7, 0x0c, 0xbd, 
  0xbd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x3f, 0x3c, 0x54, 0x55, 0x55, 
  0x55, 0x55, 0xc5, 0x3f, 0x91, 0x2b, 0x17, 0xcf, 0x55, 0x55, 0xa5, 0x3f, 
  0x17, 0xd0, 0xa4, 0x67, 0x11, 0x11, 0x81, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xc8, 0x42, 0xef, 0x39, 0xfa, 0xfe, 0x42, 0x2e, 0xe6, 0x3f, 
  0x24, 0xc4, 0x82, 0xff, 0xbd, 0xbf, 0xce, 0x3f, 0xb5, 0xf4, 0x0c, 0xd7, 
  0x08, 0x6b, 0xac, 0x3f, 0xcc, 0x50, 0x46, 0xd2, 0xab, 0xb2, 0x83, 0x3f, 
  0x84, 0x3a, 0x4e, 0x9b, 0xe0, 0xd7, 0x55, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 
  0x6e, 0xbf, 0x88, 0x1a, 0x4f, 0x3b, 0x9b, 0x3c, 0x35, 0x33, 0xfb, 0xa9, 
  0x3d, 0xf6, 0xef, 0x3f, 0x5d, 0xdc, 0xd8, 0x9c, 0x13, 0x60, 0x71, 0xbc, 
  0x61, 0x80, 0x77, 0x3e, 0x9a, 0xec, 0xef, 0x3f, 0xd1, 0x66, 0x87, 0x10, 
  0x7a, 0x5e, 0x90, 0xbc, 0x85, 0x7f, 0x6e, 0xe8, 0x15, 0xe3, 0xef, 0x3f, 
  0x13, 0xf6, 0x67, 0x35, 0x52, 0xd2, 0x8c, 0x3c, 0x74, 0x85, 0x15, 0xd3, 
  0xb0, 0xd9, 0xef, 0x3f, 0xfa, 0x8e, 0xf9, 0x23, 0x80, 0xce, 0x8b, 0xbc, 
  0xde, 0xf6, 0xdd, 0x29, 0x6b, 0xd0, 0xef, 0x3f, 0x61, 0xc8, 0xe6, 0x61, 
  0x4e, 0xf7, 0x60, 0x3c, 0xc8, 0x9b, 0x75, 0x18, 0x45, 0xc7, 0xef, 0x3f, 
  0x99, 0xd3, 0x33, 0x5b, 0xe4, 0xa3, 0x90, 0x3c, 0x83, 0xf3, 0xc6, 0xca, 
  0x3e, 0xbe, 0xef, 0x3f, 0x6d, 0x7b, 0x83, 0x5d, 0xa6, 0x9a, 0x97, 0x3c, 
  0x0f, 0x89, 0xf9, 0x6c, 0x58, 0xb5, 0xef, 0x3f, 0xfc, 0xef, 0xfd, 0x92, 
  0x1a, 0xb5, 0x8e, 0x3c, 0xf7, 0x47, 0x72, 0x2b, 0x92, 0xac, 0xef, 0x3f, 
  0xd1, 0x9c, 0x2f, 0x70, 0x3d, 0xbe, 0x3e, 0x3c, 0xa2, 0xd1, 0xd3, 0x32, 
  0xec, 0xa3, 0xef, 0x3f, 0x0b, 0x6e, 0x90, 0x89, 0x34, 0x03, 0x6a, 0xbc, 
  0x1b, 0xd3, 0xfe, 0xaf, 0x66, 0x9b, 0xef, 0x3f, 0x0e, 0xbd, 0x2f, 0x2a, 
  0x52, 0x56, 0x95, 0xbc, 0x51, 0x5b, 0x12, 0xd0, 0x01, 0x93, 0xef, 0x3f, 
  0x55, 0xea, 0x4e, 0x8c, 0xef, 0x80, 0x50, 0xbc, 0xcc, 0x31, 0x6c, 0xc0, 
  0xbd, 0x8a, 0xef, 0x3f, 0x16, 0xf4, 0xd5, 0xb9, 0x23, 0xc9, 0x91, 0xbc, 
  0xe0, 0x2d, 0xa9, 0xae, 0x9a, 0x82, 0xef, 0x3f, 0xaf, 0x55, 0x5c, 0xe9, 
  0xe3, 0xd3, 0x80, 0x3c, 0x51, 0x8e, 0xa5, 0xc8, 0x98, 0x7a, 0xef, 0x3f, 
  0x48, 0x93, 0xa5, 0xea, 0x15, 0x1b, 0x80, 0xbc, 0x7b, 0x51, 0x7d, 0x3c, 
  0xb8, 0x72, 0xef, 0x3f, 0x3d, 0x32, 0xde, 0x55, 0xf0, 0x1f, 0x8f, 0xbc, 
  0xea, 0x8d, 0x8c, 0x38, 0xf9, 0x6a, 0xef, 0x3f, 0xbf, 0x53, 0x13, 0x3f, 
  0x8c, 0x89, 0x8b, 0x3c, 0x75, 0xcb, 0x6f, 0xeb, 0x5b, 0x63, 0xef, 0x3f, 
  0x26, 0xeb, 0x11, 0x76, 0x9c, 0xd9, 0x96, 0xbc, 0xd4, 0x5c, 0x04, 0x84, 
  0xe0, 0x5b, 0xef, 0x3f, 0x60, 0x2f, 0x3a, 0x3e, 0xf7, 0xec, 0x9a, 0x3c, 
  0xaa, 0xb9, 0x68, 0x31, 0x87, 0x54, 0xef, 0x3f, 0x9d, 0x38, 0x86, 0xcb, 
  0x82, 0xe7, 0x8f, 0xbc, 0x1d, 0xd9, 0xfc, 0x22, 0x50, 0x4d, 0xef, 0x3f, 
  0x8d, 0xc3, 0xa6, 0x44, 0x41, 0x6f, 0x8a, 0x3c, 0xd6, 0x8c, 0x62, 0x88, 
  0x3b, 0x46, 0xef, 0x3f, 0x7d, 0x04, 0xe4, 0xb0, 0x05, 0x7a, 0x80, 0x3c, 
  0x96, 0xdc, 0x7d, 0x91, 0x49, 0x3f, 0xef, 0x3f, 0x94, 0xa8, 0xa8, 0xe3, 
  0xfd, 0x8e, 0x96, 0x3c, 0x38, 0x62, 0x75, 0x6e, 0x7a, 0x38, 0xef, 0x3f, 
  0x7d, 0x48, 0x74, 0xf2, 0x18, 0x5e, 0x87, 0x3c, 0x3f, 0xa6, 0xb2, 0x4f, 
  0xce, 0x31, 0xef, 0x3f, 0xf2, 0xe7, 0x1f, 0x98, 0x2b, 0x47, 0x80, 0x3c, 
  0xdd, 0x7c, 0xe2, 0x65, 0x45, 0x2b, 0xef, 0x3f, 0x5e, 0x08, 0x71, 0x3f, 
  0x7b, 0xb8, 0x96, 0xbc, 0x81, 0x63, 0xf5, 0xe1, 0xdf, 0x24, 0xef, 0x3f, 
  0x31, 0xab, 0x09, 0x6d, 0xe1, 0xf7, 0x82, 0x3c, 0xe1, 0xde, 0x1f, 0xf5, 
  0x9d, 0x1e, 0xef, 0x3f, 0xfa, 0xbf, 0x6f, 0x1a, 0x9b, 0x21, 0x3d, 0xbc, 
  0x90, 0xd9, 0xda, 0xd0, 0x7f, 0x18, 0xef, 0x3f, 0xb4, 0x0a, 0x0c, 0x72, 
  0x82, 0x37, 0x8b, 0x3c, 0x0b, 0x03, 0xe4, 0xa6, 0x85, 0x12, 0xef, 0x3f, 
  0x8f, 0xcb, 0xce, 0x89, 0x92, 0x14, 0x6e, 0x3c, 0x56, 0x2f, 0x3e, 0xa9, 
  0xaf, 0x0c, 0xef, 0x3f, 0xb6, 0xab, 0xb0, 0x4d, 0x75, 0x4d, 0x83, 0x3c, 
  0x15, 0xb7, 0x31, 0x0a, 0xfe, 0x06, 0xef, 0x3f, 0x4c, 0x74, 0xac, 0xe2, 
  0x01, 0x42, 0x86, 0x3c, 0x31, 0xd8, 0x4c, 0xfc, 0x70, 0x01, 0xef, 0x3f, 
  0x4a, 0xf8, 0xd3, 0x5d, 0x39, 0xdd, 0x8f, 0x3c, 0xff, 0x16, 0x64, 0xb2, 
  0x08, 0xfc, 0xee, 0x3f, 0x04, 0x5b, 0x8e, 0x3b, 0x80, 0xa3, 0x86, 0xbc, 
  0xf1, 0x9f, 0x92, 0x5f, 0xc5, 0xf6, 0xee, 0x3f, 0x68, 0x50, 0x4b, 0xcc, 
  0xed, 0x4a, 0x92, 0xbc, 0xcb, 0xa9, 0x3a, 0x37, 0xa7, 0xf1, 0xee, 0x3f, 
  0x8e, 0x2d, 0x51, 0x1b, 0xf8, 0x07, 0x99, 0xbc, 0x66, 0xd8, 0x05, 0x6d, 
  0xae, 0xec, 0xee, 0x3f, 0xd2, 0x36, 0x94, 0x3e, 0xe8, 0xd1, 0x71, 0xbc, 
  0xf7, 0x9f, 0xe5, 0x34, 0xdb, 0xe7, 0xee, 0x3f, 0x15, 0x1b, 0xce, 0xb3, 
  0x19, 0x19, 0x99, 0xbc, 0xe5, 0xa8, 0x13, 0xc3, 0x2d, 0xe3, 0xee, 0x3f, 
  0x6d, 0x4c, 0x2a, 0xa7, 0x48, 0x9f, 0x85, 0x3c, 0x22, 0x34, 0x12, 0x4c, 
  0xa6, 0xde, 0xee, 0x3f, 0x8a, 0x69, 0x28, 0x7a, 0x60, 0x12, 0x93, 0xbc, 
  0x1c, 0x80, 0xac, 0x04, 0x45, 0xda, 0xee, 0x3f, 0x5b, 0x89, 0x17, 0x48, 
  0x8f, 0xa7, 0x58, 0xbc, 0x2a, 0x2e, 0xf7, 0x21, 0x0a, 0xd6, 0xee, 0x3f, 
  0x1b, 0x9a, 0x49, 0x67, 0x9b, 0x2c, 0x7c, 0xbc, 0x97, 0xa8, 0x50, 0xd9, 
  0xf5, 0xd1, 0xee, 0x3f, 0x11, 0xac, 0xc2, 0x60, 0xed, 0x63, 0x43, 0x3c, 
  0x2d, 0x89, 0x61, 0x60, 0x08, 0xce, 0xee, 0x3f, 0xef, 0x64, 0x06, 0x3b, 
  0x09, 0x66, 0x96, 0x3c, 0x57, 0x00, 0x1d, 0xed, 0x41, 0xca, 0xee, 0x3f, 
  0x79, 0x03, 0xa1, 0xda, 0xe1, 0xcc, 0x6e, 0x3c, 0xd0, 0x3c, 0xc1, 0xb5, 
  0xa2, 0xc6, 0xee, 0x3f, 0x30, 0x12, 0x0f, 0x3f, 0x8e, 0xff, 0x93, 0x3c, 
  0xde, 0xd3, 0xd7, 0xf0, 0x2a, 0xc3, 0xee, 0x3f, 0xb0, 0xaf, 0x7a, 0xbb, 
  0xce, 0x90, 0x76, 0x3c, 0x27, 0x2a, 0x36, 0xd5, 0xda, 0xbf, 0xee, 0x3f, 
  0x77, 0xe0, 0x54, 0xeb, 0xbd, 0x1d, 0x93, 0x3c, 0x0d, 0xdd, 0xfd, 0x99, 
  0xb2, 0xbc, 0xee, 0x3f, 0x8e, 0xa3, 0x71, 0x00, 0x34, 0x94, 0x8f, 0xbc, 
  0xa7, 0x2c, 0x9d, 0x76, 0xb2, 0xb9, 0xee, 0x3f, 0x49, 0xa3, 0x93, 0xdc, 
  0xcc, 0xde, 0x87, 0xbc, 0x42, 0x66, 0xcf, 0xa2, 0xda, 0xb6, 0xee, 0x3f, 
  0x5f, 0x38, 0x0f, 0xbd, 0xc6, 0xde, 0x78, 0xbc, 0x82, 0x4f, 0x9d, 0x56, 
  0x2b, 0xb4, 0xee, 0x3f, 0xf6, 0x5c, 0x7b, 0xec, 0x46, 0x12, 0x86, 0xbc, 
  0x0f, 0x92, 0x5d, 0xca, 0xa4, 0xb1, 0xee, 0x3f, 0x8e, 0xd7, 0xfd, 0x18, 
  0x05, 0x35, 0x93, 0x3c, 0xda, 0x27, 0xb5, 0x36, 0x47, 0xaf, 0xee, 0x3f, 
  0x05, 0x9b, 0x8a, 0x2f, 0xb7, 0x98, 0x7b, 0x3c, 0xfd, 0xc7, 0x97, 0xd4, 
  0x12, 0xad, 0xee, 0x3f, 0x09, 0x54, 0x1c, 0xe2, 0xe1, 0x63, 0x90, 0x3c, 
  0x29, 0x54, 0x48, 0xdd, 0x07, 0xab, 0xee, 0x3f, 0xea, 0xc6, 0x19, 0x50, 
  0x85, 0xc7, 0x34, 0x3c, 0xb7, 0x46, 0x59, 0x8a, 0x26, 0xa9, 0xee, 0x3f, 
  0x35, 0xc0, 0x64, 0x2b, 0xe6, 0x32, 0x94, 0x3c, 0x48, 0x21, 0xad, 0x15, 
  0x6f, 0xa7, 0xee, 0x3f, 0x9f, 0x76, 0x99, 0x61, 0x4a, 0xe4, 0x8c, 0xbc, 
  0x09, 0xdc, 0x76, 0xb9, 0xe1, 0xa5, 0xee, 0x3f, 0xa8, 0x4d, 0xef, 0x3b, 
  0xc5, 0x33, 0x8c, 0xbc, 0x85, 0x55, 0x3a, 0xb0, 0x7e, 0xa4, 0xee, 0x3f, 
  0xae, 0xe9, 0x2b, 0x89, 0x78, 0x53, 0x84, 0xbc, 0x20, 0xc3, 0xcc, 0x34, 
  0x46, 0xa3, 0xee, 0x3f, 0x58, 0x58, 0x56, 0x78, 0xdd, 0xce, 0x93, 0xbc, 
  0x25, 0x22, 0x55, 0x82, 0x38, 0xa2, 0xee, 0x3f, 0x64, 0x19, 0x7e, 0x80, 
  0xaa, 0x10, 0x57, 0x3c, 0x73, 0xa9, 0x4c, 0xd4, 0x55, 0xa1, 0xee, 0x3f, 
  0x28, 0x22, 0x5e, 0xbf, 0xef, 0xb3, 0x93, 0xbc, 0xcd, 0x3b, 0x7f, 0x66, 
  0x9e, 0xa0, 0xee, 0x3f, 0x82, 0xb9, 0x34, 0x87, 0xad, 0x12, 0x6a, 0xbc, 
  0xbf, 0xda, 0x0b, 0x75, 0x12, 0xa0, 0xee, 0x3f, 0xee, 0xa9, 0x6d, 0xb8, 
  0xef, 0x67, 0x63, 0xbc, 0x2f, 0x1a, 0x65, 0x3c, 0xb2, 0x9f, 0xee, 0x3f, 
  0x51, 0x88, 0xe0, 0x54, 0x3d, 0xdc, 0x80, 0xbc, 0x84, 0x94, 0x51, 0xf9, 
  0x7d, 0x9f, 0xee, 0x3f, 0xcf, 0x3e, 0x5a, 0x7e, 0x64, 0x1f, 0x78, 0xbc, 
  0x74, 0x5f, 0xec, 0xe8, 0x75, 0x9f, 0xee, 0x3f, 0xb0, 0x7d, 0x8b, 0xc0, 
  0x4a, 0xee, 0x86, 0xbc, 0x74, 0x81, 0xa5, 0x48, 0x9a, 0x9f, 0xee, 0x3f, 
  0x8a, 0xe6, 0x55, 0x1e, 0x32, 0x19, 0x86, 0xbc, 0xc9, 0x67, 0x42, 0x56, 
  0xeb, 0x9f, 0xee, 0x3f, 0xd3, 0xd4, 0x09, 0x5e, 0xcb, 0x9c, 0x90, 0x3c, 
  0x3f, 0x5d, 0xde, 0x4f, 0x69, 0xa0, 0xee, 0x3f, 0x1d, 0xa5, 0x4d, 0xb9, 
  0xdc, 0x32, 0x7b, 0xbc, 0x87, 0x01, 0xeb, 0x73, 0x14, 0xa1, 0xee, 0x3f, 
  0x6b, 0xc0, 0x67, 0x54, 0xfd, 0xec, 0x94, 0x3c, 0x32, 0xc1, 0x30, 0x01, 
  0xed, 0xa1, 0xee, 0x3f, 0x55, 0x6c, 0xd6, 0xab, 0xe1, 0xeb, 0x65, 0x3c, 
  0x62, 0x4e, 0xcf, 0x36, 0xf3, 0xa2, 0xee, 0x3f, 0x42, 0xcf, 0xb3, 0x2f, 
  0xc5, 0xa1, 0x88, 0xbc, 0x12, 0x1a, 0x3e, 0x54, 0x27, 0xa4, 0xee, 0x3f, 
  0x34, 0x37, 0x3b, 0xf1, 0xb6, 0x69, 0x93, 0xbc, 0x13, 0xce, 0x4c, 0x99, 
  0x89, 0xa5, 0xee, 0x3f, 0x1e, 0xff, 0x19, 0x3a, 0x84, 0x5e, 0x80, 0xbc, 
  0xad, 0xc7, 0x23, 0x46, 0x1a, 0xa7, 0xee, 0x3f, 0x6e, 0x57, 0x72, 0xd8, 
  0x50, 0xd4, 0x94, 0xbc, 0xed, 0x92, 0x44, 0x9b, 0xd9, 0xa8, 0xee, 0x3f, 
  0x00, 0x8a, 0x0e, 0x5b, 0x67, 0xad, 0x90, 0x3c, 0x99, 0x66, 0x8a, 0xd9, 
  0xc7, 0xaa, 0xee, 0x3f, 0xb4, 0xea, 0xf0, 0xc1, 0x2f, 0xb7, 0x8d, 0x3c, 
  0xdb, 0xa0, 0x2a, 0x42, 0xe5, 0xac, 0xee, 0x3f, 0xff, 0xe7, 0xc5, 0x9c, 
  0x60, 0xb6, 0x65, 0xbc, 0x8c, 0x44, 0xb5, 0x16, 0x32, 0xaf, 0xee, 0x3f, 
  0x44, 0x5f, 0xf3, 0x59, 0x83, 0xf6, 0x7b, 0x3c, 0x36, 0x77, 0x15, 0x99, 
  0xae, 0xb1, 0xee, 0x3f, 0x83, 0x3d, 0x1e, 0xa7, 0x1f, 0x09, 0x93, 0xbc, 
  0xc6, 0xff, 0x91, 0x0b, 0x5b, 0xb4, 0xee, 0x3f, 0x29, 0x1e, 0x6c, 0x8b, 
  0xb8, 0xa9, 0x5d, 0xbc, 0xe5, 0xc5, 0xcd, 0xb0, 0x37, 0xb7, 0xee, 0x3f, 
  0x59, 0xb9, 0x90, 0x7c, 0xf9, 0x23, 0x6c, 0xbc, 0x0f, 0x52, 0xc8, 0xcb, 
  0x44, 0xba, 0xee, 0x3f, 0xaa, 0xf9, 0xf4, 0x22, 0x43, 0x43, 0x92, 0xbc, 
  0x50, 0x4e, 0xde, 0x9f, 0x82, 0xbd, 0xee, 0x3f, 0x4b, 0x8e, 0x66, 0xd7, 
  0x6c, 0xca, 0x85, 0xbc, 0xba, 0x07, 0xca, 0x70, 0xf1, 0xc0, 0xee, 0x3f, 
  0x27, 0xce, 0x91, 0x2b, 0xfc, 0xaf, 0x71, 0x3c, 0x90, 0xf0, 0xa3, 0x82, 
  0x91, 0xc4, 0xee, 0x3f, 0xbb, 0x73, 0x0a, 0xe1, 0x35, 0xd2, 0x6d, 0x3c, 
  0x23, 0x23, 0xe3, 0x19, 0x63, 0xc8, 0xee, 0x3f, 0x63, 0x22, 0x62, 0x22, 
  0x04, 0xc5, 0x87, 0xbc, 0x65, 0xe5, 0x5d, 0x7b, 0x66, 0xcc, 0xee, 0x3f, 
  0xd5, 0x31, 0xe2, 0xe3, 0x86, 0x1c, 0x8b, 0x3c, 0x33, 0x2d, 0x4a, 0xec, 
  0x9b, 0xd0, 0xee, 0x3f, 0x15, 0xbb, 0xbc, 0xd3, 0xd1, 0xbb, 0x91, 0xbc, 
  0x5d, 0x25, 0x3e, 0xb2, 0x03, 0xd5, 0xee, 0x3f, 0xd2, 0x31, 0xee, 0x9c, 
  0x31, 0xcc, 0x90, 0x3c, 0x58, 0xb3, 0x30, 0x13, 0x9e, 0xd9, 0xee, 0x3f, 
  0xb3, 0x5a, 0x73, 0x6e, 0x84, 0x69, 0x84, 0x3c, 0xbf, 0xfd, 0x79, 0x55, 
  0x6b, 0xde, 0xee, 0x3f, 0xb4, 0x9d, 0x8e, 0x97, 0xcd, 0xdf, 0x82, 0xbc, 
  0x7a, 0xf3, 0xd3, 0xbf, 0x6b, 0xe3, 0xee, 0x3f, 0x87, 0x33, 0xcb, 0x92, 
  0x77, 0x1a, 0x8c, 0x3c, 0xad, 0xd3, 0x5a, 0x99, 0x9f, 0xe8, 0xee, 0x3f, 
  0xfa, 0xd9, 0xd1, 0x4a, 0x8f, 0x7b, 0x90, 0xbc, 0x66, 0xb6, 0x8d, 0x29, 
  0x07, 0xee, 0xee, 0x3f, 0xba, 0xae, 0xdc, 0x56, 0xd9, 0xc3, 0x55, 0xbc, 
  0xfb, 0x15, 0x4f, 0xb8, 0xa2, 0xf3, 0xee, 0x3f, 0x40, 0xf6, 0xa6, 0x3d, 
  0x0e, 0xa4, 0x90, 0xbc, 0x3a, 0x59, 0xe5, 0x8d, 0x72, 0xf9, 0xee, 0x3f, 
  0x34, 0x93, 0xad, 0x38, 0xf4, 0xd6, 0x68, 0xbc, 0x47, 0x5e, 0xfb, 0xf2, 
  0x76, 0xff, 0xee, 0x3f, 0x35, 0x8a, 0x58, 0x6b, 0xe2, 0xee, 0x91, 0xbc, 
  0x4a, 0x06, 0xa1, 0x30, 0xb0, 0x05, 0xef, 0x3f, 0xcd, 0xdd, 0x5f, 0x0a, 
  0xd7, 0xff, 0x74, 0x3c, 0xd2, 0xc1, 0x4b, 0x90, 0x1e, 0x0c, 0xef, 0x3f, 
  0xac, 0x98, 0x92, 0xfa, 0xfb, 0xbd, 0x91, 0xbc, 0x09, 0x1e, 0xd7, 0x5b, 
  0xc2, 0x12, 0xef, 0x3f, 0xb3, 0x0c, 0xaf, 0x30, 0xae, 0x6e, 0x73, 0x3c, 
  0x9c, 0x52, 0x85, 0xdd, 0x9b, 0x19, 0xef, 0x3f, 0x94, 0xfd, 0x9f, 0x5c, 
  0x32, 0xe3, 0x8e, 0x3c, 0x7a, 0xd0, 0xff, 0x5f, 0xab, 0x20, 0xef, 0x3f, 
  0xac, 0x59, 0x09, 0xd1, 0x8f, 0xe0, 0x84, 0x3c, 0x4b, 0xd1, 0x57, 0x2e, 
  0xf1, 0x27, 0xef, 0x3f, 0x67, 0x1a, 0x4e, 0x38, 0xaf, 0xcd, 0x63, 0x3c, 
  0xb5, 0xe7, 0x06, 0x94, 0x6d, 0x2f, 0xef, 0x3f, 0x68, 0x19, 0x92, 0x6c, 
  0x2c, 0x6b, 0x67, 0x3c, 0x69, 0x90, 0xef, 0xdc, 0x20, 0x37, 0xef, 0x3f, 
  0xd2, 0xb5, 0xcc, 0x83, 0x18, 0x8a, 0x80, 0xbc, 0xfa, 0xc3, 0x5d, 0x55, 
  0x0b, 0x3f, 0xef, 0x3f, 0x6f, 0xfa, 0xff, 0x3f, 0x5d, 0xad, 0x8f, 0xbc, 
  0x7c, 0x89, 0x07, 0x4a, 0x2d, 0x47, 0xef, 0x3f, 0x49, 0xa9, 0x75, 0x38, 
  0xae, 0x0d, 0x90, 0xbc, 0xf2, 0x89, 0x0d, 0x08, 0x87, 0x4f, 0xef, 0x3f, 
  0xa7, 0x07, 0x3d, 0xa6, 0x85, 0xa3, 0x74, 0x3c, 0x87, 0xa4, 0xfb, 0xdc, 
  0x18, 0x58, 0xef, 0x3f, 0x0f, 0x22, 0x40, 0x20, 0x9e, 0x91, 0x82, 0xbc, 
  0x98, 0x83, 0xc9, 0x16, 0xe3, 0x60, 0xef, 0x3f, 0xac, 0x92, 0xc1, 0xd5, 
  0x50, 0x5a, 0x8e, 0x3c, 0x85, 0x32, 0xdb, 0x03, 0xe6, 0x69, 0xef, 0x3f, 
  0x4b, 0x6b, 0x01, 0xac, 0x59, 0x3a, 0x84, 0x3c, 0x60, 0xb4, 0x01, 0xf3, 
  0x21, 0x73, 0xef, 0x3f, 0x1f, 0x3e, 0xb4, 0x07, 0x21, 0xd5, 0x82, 0xbc, 
  0x5f, 0x9b, 0x7b, 0x33, 0x97, 0x7c, 0xef, 0x3f, 0xc9, 0x0d, 0x47, 0x3b, 
  0xb9, 0x2a, 0x89, 0xbc, 0x29, 0xa1, 0xf5, 0x14, 0x46, 0x86, 0xef, 0x3f, 
  0xd3, 0x88, 0x3a, 0x60, 0x04, 0xb6, 0x74, 0x3c, 0xf6, 0x3f, 0x8b, 0xe7, 
  0x2e, 0x90, 0xef, 0x3f, 0x71, 0x72, 0x9d, 0x51, 0xec, 0xc5, 0x83, 0x3c, 
  0x83, 0x4c, 0xc7, 0xfb, 0x51, 0x9a, 0xef, 0x3f, 0xf0, 0x91, 0xd3, 0x8f, 
  0x12, 0xf7, 0x8f, 0xbc, 0xda, 0x90, 0xa4, 0xa2, 0xaf, 0xa4, 0xef, 0x3f, 
  0x7d, 0x74, 0x23, 0xe2, 0x98, 0xae, 0x8d, 0xbc, 0xf1, 0x67, 0x8e, 0x2d, 
  0x48, 0xaf, 0xef, 0x3f, 0x08, 0x20, 0xaa, 0x41, 0xbc, 0xc3, 0x8e, 0x3c, 
  0x27, 0x5a, 0x61, 0xee, 0x1b, 0xba, 0xef, 0x3f, 0x32, 0xeb, 0xa9, 0xc3, 
  0x94, 0x2b, 0x84, 0x3c, 0x97, 0xba, 0x6b, 0x37, 0x2b, 0xc5, 0xef, 0x3f, 
  0xee, 0x85, 0xd1, 0x31, 0xa9, 0x64, 0x8a, 0x3c, 0x40, 0x45, 0x6e, 0x5b, 
  0x76, 0xd0, 0xef, 0x3f, 0xed, 0xe3, 0x3b, 0xe4, 0xba, 0x37, 0x8e, 0xbc, 
  0x14, 0xbe, 0x9c, 0xad, 0xfd, 0xdb, 0xef, 0x3f, 0x9d, 0xcd, 0x91, 0x4d, 
  0x3b, 0x89, 0x77, 0x3c, 0xd8, 0x90, 0x9e, 0x81, 0xc1, 0xe7, 0xef, 0x3f, 
  0x89, 0xcc, 0x60, 0x41, 0xc1, 0x05, 0x53, 0x3c, 0xf1, 0x71, 0x8f, 0x2b, 
  0xc2, 0xf3, 0xef, 0x3f, 0xb0, 0x2d, 0x04, 0x00, 0x28, 0x2e, 0x04, 0x00, 
  0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x00, 0x49, 0x6c, 0x6c, 0x65, 
  0x67, 0x61, 0x6c, 0x20, 0x62, 0x79, 0x74, 0x65, 0x20, 0x73, 0x65, 0x71, 
  0x75, 0x65, 0x6e, 0x63, 0x65, 0x00, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 
  0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x00, 0x52, 0x65, 0x73, 0x75, 0x6c, 
  0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 
  0x65, 0x6e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x4e, 0x6f, 0x74, 0x20, 
  0x61, 0x20, 0x74, 0x74, 0x79, 0x00, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 
  0x73, 0x69, 0x6f, 0x6e, 0x20, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x00, 
  0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6e, 0x6f, 
  0x74, 0x20, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x00, 
  0x4e, 0x6f, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x66, 0x69, 0x6c, 0x65, 
  0x20, 0x6f, 0x72, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 
  0x79, 0x00, 0x4e, 0x6f, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x70, 0x72, 
  0x6f, 0x63, 0x65, 0x73, 0x73, 0x00, 0x46, 0x69, 0x6c, 0x65, 0x20, 0x65, 
  0x78, 0x69, 0x73, 0x74, 0x73, 0x00, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x20, 
  0x74, 0x6f, 0x6f, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x66, 0x6f, 
  0x72, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x74, 0x79, 0x70, 0x65, 0x00, 
  0x4e, 0x6f, 0x20, 0x73, 0x70, 0x61, 0x63, 0x65, 0x20, 0x6c, 0x65, 0x66, 
  0x74, 0x20, 0x6f, 0x6e, 0x20, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x00, 
  0x4f, 0x75, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 
  0x79, 0x00, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x62, 
  0x75, 0x73, 0x79, 0x00, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 
  0x74, 0x65, 0x64, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 0x63, 
  0x61, 0x6c, 0x6c, 0x00, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 
  0x20, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x69, 0x6c, 0x79, 
  0x20, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 
  0x00, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x73, 0x65, 0x65, 
  0x6b, 0x00, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x2d, 0x64, 0x65, 0x76, 0x69, 
  0x63, 0x65, 0x20, 0x6c, 0x69, 0x6e, 0x6b, 0x00, 0x52, 0x65, 0x61, 0x64, 
  0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x20, 0x73, 
  0x79, 0x73, 0x74, 0x65, 0x6d, 0x00, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 
  0x6f, 0x72, 0x79, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x65, 0x6d, 0x70, 0x74, 
  0x79, 0x00, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 
  0x20, 0x72, 0x65, 0x73, 0x65, 0x74, 0x20, 0x62, 0x79, 0x20, 0x70, 0x65, 
  0x65, 0x72, 0x00, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 
  0x20, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x00, 0x43, 
  0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 0x65, 
  0x66, 0x75, 0x73, 0x65, 0x64, 0x00, 0x48, 0x6f, 0x73, 0x74, 0x20, 0x69, 
  0x73, 0x20, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 
  0x65, 0x00, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x69, 0x6e, 
  0x20, 0x75, 0x73, 0x65, 0x00, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 
  0x70, 0x69, 0x70, 0x65, 0x00, 0x49, 0x2f, 0x4f, 0x20, 0x65, 0x72, 0x72, 
  0x6f, 0x72, 0x00, 0x4e, 0x6f, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x64, 
  0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x61, 0x64, 0x64, 
  0x72, 0x65, 0x73, 0x73, 0x00, 0x4e, 0x6f, 0x20, 0x73, 0x75, 0x63, 0x68, 
  0x20, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x00, 0x4e, 0x6f, 0x74, 0x20, 
  0x61, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x00, 
  0x49, 0x73, 0x20, 0x61, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 
  0x72, 0x79, 0x00, 0x54, 0x65, 0x78, 0x74, 0x20, 0x66, 0x69, 0x6c, 0x65, 
  0x20, 0x62, 0x75, 0x73, 0x79, 0x00, 0x45, 0x78, 0x65, 0x63, 0x20, 0x66, 
  0x6f, 0x72, 0x6d, 0x61, 0x74, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x00, 
  0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x61, 0x72, 0x67, 0x75, 
  0x6d, 0x65, 0x6e, 0x74, 0x00, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 
  0x74, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x74, 0x6f, 0x6f, 0x20, 0x6c, 
  0x6f, 0x6e, 0x67, 0x00, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x69, 0x63, 
  0x20, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x6c, 0x6f, 0x6f, 0x70, 0x00, 0x46, 
  0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x6f, 0x20, 
  0x6c, 0x6f, 0x6e, 0x67, 0x00, 0x54, 0x6f, 0x6f, 0x20, 0x6d, 0x61, 0x6e, 
  0x79, 0x20, 0x6f, 0x70, 0x65, 0x6e, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x73, 
  0x20, 0x69, 0x6e, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x00, 0x4e, 
  0x6f, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 
  0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 
  0x61, 0x62, 0x6c, 0x65, 0x00, 0x42, 0x61, 0x64, 0x20, 0x66, 0x69, 0x6c, 
  0x65, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 
  0x00, 0x4e, 0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x20, 0x70, 0x72, 
  0x6f, 0x63, 0x65, 0x73, 0x73, 0x00, 0x42, 0x61, 0x64, 0x20, 0x61, 0x64, 
  0x64, 0x72, 0x65, 0x73, 0x73, 0x00, 0x46, 0x69, 0x6c, 0x65, 0x20, 0x74, 
  0x6f, 0x6f, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x00, 0x54, 0x6f, 0x6f, 
  0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x00, 
  0x4e, 0x6f, 0x20, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x20, 0x61, 0x76, 0x61, 
  0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x52, 0x65, 0x73, 0x6f, 0x75, 
  0x72, 0x63, 0x65, 0x20, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x6f, 0x63, 0x6b, 
  0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6f, 0x63, 0x63, 0x75, 0x72, 
  0x00, 0x53, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x72, 
  0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x50, 
  0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x6f, 0x77, 0x6e, 0x65, 
  0x72, 0x20, 0x64, 0x69, 0x65, 0x64, 0x00, 0x4f, 0x70, 0x65, 0x72, 0x61, 
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x65, 
  0x64, 0x00, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6e, 
  0x6f, 0x74, 0x20, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 
  0x65, 0x64, 0x00, 0x4e, 0x6f, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 
  0x20, 0x74, 0x79, 0x70, 0x65, 0x00, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 
  0x66, 0x69, 0x65, 0x72, 0x20, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 
  0x00, 0x4c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 
  0x65, 0x6e, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x65, 0x64, 0x00, 0x50, 
  0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x20, 0x65, 0x72, 0x72, 0x6f, 
  0x72, 0x00, 0x42, 0x61, 0x64, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 
  0x65, 0x00, 0x4e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x73, 0x6f, 0x63, 0x6b, 
  0x65, 0x74, 0x00, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 
  0x6f, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x72, 
  0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x00, 0x4d, 0x65, 0x73, 0x73, 
  0x61, 0x67, 0x65, 0x20, 0x74, 0x6f, 0x6f, 0x20, 0x6c, 0x61, 0x72, 0x67, 
  0x65, 0x00, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x20, 0x77, 
  0x72, 0x6f, 0x6e, 0x67, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x66, 0x6f, 
  0x72, 0x20, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x00, 0x50, 0x72, 0x6f, 
  0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x76, 
  0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x50, 0x72, 0x6f, 0x74, 
  0x6f, 0x63, 0x6f, 0x6c, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x73, 0x75, 0x70, 
  0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x00, 0x4e, 0x6f, 0x74, 0x20, 0x73, 
  0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x00, 0x41, 0x64, 0x64, 
  0x72, 0x65, 0x73, 0x73, 0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 
  0x6e, 0x6f, 0x74, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 
  0x64, 0x20, 0x62, 0x79, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 
  0x6c, 0x00, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x6e, 0x6f, 
  0x74, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x00, 
  0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x69, 0x73, 0x20, 0x64, 
  0x6f, 0x77, 0x6e, 0x00, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 
  0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x00, 
  0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 
  0x65, 0x73, 0x65, 0x74, 0x20, 0x62, 0x79, 0x20, 0x6e, 0x65, 0x74, 0x77, 
  0x6f, 0x72, 0x6b, 0x00, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 
  0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x00, 0x4e, 
  0x6f, 0x20, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x20, 0x73, 0x70, 0x61, 
  0x63, 0x65, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 
  0x00, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x20, 0x69, 0x73, 0x20, 0x63, 
  0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x00, 0x53, 0x6f, 0x63, 
  0x6b, 0x65, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 
  0x65, 0x63, 0x74, 0x65, 0x64, 0x00, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 
  0x69, 0x6f, 0x6e, 0x20, 0x61, 0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x20, 
  0x69, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x00, 
  0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 
  0x20, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x00, 0x53, 0x74, 
  0x61, 0x6c, 0x65, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x20, 0x68, 0x61, 0x6e, 
  0x64, 0x6c, 0x65, 0x00, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x20, 0x65, 0x78, 
  0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x00, 0x4d, 0x75, 0x6c, 0x74, 0x69, 
  0x68, 0x6f, 0x70, 0x20, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x65, 
  0x64, 0x00, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 
  0x65, 0x73, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 
  0x65, 0x6e, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x75, 0x02, 0x4e, 0x00, 0xd6, 0x01, 0xe2, 0x04, 0xb9, 0x04, 
  0x18, 0x01, 0x8e, 0x05, 0xed, 0x02, 0x16, 0x04, 0xf2, 0x00, 0x97, 0x03, 
  0x01, 0x03, 0x38, 0x05, 0xaf, 0x01, 0x82, 0x01, 0x4f, 0x03, 0x2f, 0x04, 
  0x1e, 0x00, 0xd4, 0x05, 0xa2, 0x00, 0x12, 0x03, 0x1e, 0x03, 0xc2, 0x01, 
  0xde, 0x03, 0x08, 0x00, 0xac, 0x05, 0x00, 0x01, 0x64, 0x02, 0xf1, 0x01, 
  0x65, 0x05, 0x34, 0x02, 0x8c, 0x02, 0xcf, 0x02, 0x2d, 0x03, 0x4c, 0x04, 
  0xe3, 0x05, 0x9f, 0x02, 0xf8, 0x04, 0x1c, 0x05, 0x08, 0x05, 0xb1, 0x02, 
  0x4b, 0x05, 0x15, 0x02, 0x78, 0x00, 0x52, 0x02, 0x3c, 0x03, 0xf1, 0x03, 
  0xe4, 0x00, 0xc3, 0x03, 0x7d, 0x04, 0xcc, 0x00, 0xaa, 0x03, 0x79, 0x05, 
  0x24, 0x02, 0x6e, 0x01, 0x6d, 0x03, 0x22, 0x04, 0xab, 0x04, 0x44, 0x00, 
  0xfb, 0x01, 0xae, 0x00, 0x83, 0x03, 0x60, 0x00, 0xe5, 0x01, 0x07, 0x04, 
  0x94, 0x04, 0x5e, 0x04, 0x2b, 0x00, 0x58, 0x01, 0x39, 0x01, 0x92, 0x00, 
  0xc2, 0x05, 0x9b, 0x01, 0x43, 0x02, 0x46, 0x01, 0xf6, 0x05, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0a, 0x00, 0x19, 0x19, 0x19, 0x00, 
  0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 
  0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x19, 0x00, 0x11, 0x0a, 0x19, 0x19, 0x19, 0x03, 0x0a, 0x07, 0x00, 0x01, 
  0x1b, 0x09, 0x0b, 0x18, 0x00, 0x00, 0x09, 0x06, 0x0b, 0x00, 0x00, 0x0b, 
  0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x19, 0x19, 0x19, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 
  0x0a, 0x0d, 0x19, 0x19, 0x19, 0x00, 0x0d, 0x00, 0x00, 0x02, 0x00, 0x09, 
  0x0e, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 
  0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0c, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 
  0x00, 0x04, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x09, 0x10, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 
  0x11, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0x1a, 
  0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x1a, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
  0x00, 0x09, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x14, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x09, 
  0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x16, 0x00, 0x00, 
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 
  0x43, 0x44, 0x45, 0x46, 
};

static const u8 data_segment_data_w2c_rlboxsoundtouch_0x2Edata[] = {
  0x01, 0x00, 0x00, 0x00, 0x89, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x8b, 0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00, 0xb0, 0x30, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x2d, 0x04, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x8d, 0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00, 0xb8, 0x30, 0x04, 0x00, 
  0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x2e, 0x04, 0x00, 
  
};

static void init_memories(w2c_rlboxsoundtouch* instance) {
  LOAD_DATA((*instance->w2c_env_memory), 262144u, data_segment_data_w2c_rlboxsoundtouch_0x2Erodata, 11680);
  LOAD_DATA((*instance->w2c_env_memory), 273824u, data_segment_data_w2c_rlboxsoundtouch_0x2Edata, 252);
}

static void init_data_instances(w2c_rlboxsoundtouch *instance) {
}

static const wasm_elem_segment_expr_t elem_segment_exprs_w2c_rlboxsoundtouch_e0[] = {
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t4, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t6, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t0, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3A0x7EInterpolateCubic0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3Atranspose0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t9, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t4, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetChannels0x28int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AgetLatency0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AresetRegisters0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3A0x7EInterpolateLinearInteger0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t9, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AsetRate0x28double0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AgetLatency0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AresetRegisters0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3A0x7EInterpolateLinearFloat0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AgetLatency0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AresetRegisters0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3A0x7EInterpolateShannon0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AgetLatency0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AresetRegisters0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AptrBegin0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AnumSamples0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisEmpty0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3Aclear0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t9, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetRate0x28double0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t13, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual_0, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AisEmpty0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aclear0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AnumUnprocessedSamples0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aclear0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearCrossCorrState0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t10, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t10, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionFull0x28float0x20const0x2A0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionQuick0x28float0x20const0x2A0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t3, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPosition0x28float0x20const0x2A0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapStereo0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMono0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t7, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMulti0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t5, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t0, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3A0x7ETDStretchSSE0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t10, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t10, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t11, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t12, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t0, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t11, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t12, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t0, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t11, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t12, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t0, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t1, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t13, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_std0x3A0x3Aterminate0x280x29, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t13, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_abort_0, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t2, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_stdio_close_0, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_stdio_write_0, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t14, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_stdio_seek_0, {NULL}, 0},
  {RefFunc, w2c_rlboxsoundtouch_t8, (wasm_rt_function_ptr_t)wrap_w2c_rlboxsoundtouch_0x5F_stdout_write_0, {NULL}, 0},
};

static void init_tables(w2c_rlboxsoundtouch* instance) {
  funcref_table_init(instance->w2c_env_0x5F_indirect_function_table, elem_segment_exprs_w2c_rlboxsoundtouch_e0, 141, 1u, 0, 141, instance);
}

static void init_elem_instances(w2c_rlboxsoundtouch *instance) {
}

/* export: '__wasm_call_ctors' */
void w2c_rlboxsoundtouch_0x5F_wasm_call_ctors(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_wasm_call_ctors_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_start' */
void w2c_rlboxsoundtouch_0x5Fstart(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5Fstart_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__memory_base' */
u32* w2c_rlboxsoundtouch_0x5F_memory_base(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_memory_base;
}

/* export: '__main_void' */
u32 w2c_rlboxsoundtouch_0x5F_main_void(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_main_void_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasm_call_dtors' */
void w2c_rlboxsoundtouch_0x5F_wasm_call_dtors(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_wasm_call_dtors_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__wasi_proc_exit' */
void w2c_rlboxsoundtouch_0x5F_wasi_proc_exit(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_wasi_proc_exit_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__main_argc_argv' */
u32 w2c_rlboxsoundtouch_0x5F_main_argc_argv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_main(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'abort' */
void w2c_rlboxsoundtouch_abort(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_abort_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch8AAFilterC2Ej' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilterC2Ej(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AAAFilter0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilter11newInstanceEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilter11newInstanceEv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AnewInstance0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch8AAFilter15calculateCoeffsEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilter15calculateCoeffsEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AcalculateCoeffs0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch8AAFilter9setLengthEj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilter9setLengthEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetLength0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch8AAFilterD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilterD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3A0x7EAAFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch8AAFilter13setCutoffFreqEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilter13setCutoffFreqEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetCutoffFreq0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_Znam' */
u32 w2c_rlboxsoundtouch_0x5FZnam(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'sin' */
f64 w2c_rlboxsoundtouch_sin(w2c_rlboxsoundtouch* instance, f64 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_sin_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'cos' */
f64 w2c_rlboxsoundtouch_cos(w2c_rlboxsoundtouch* instance, f64 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_cos_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZdaPv' */
void w2c_rlboxsoundtouch_0x5FZdaPv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch8AAFilter8evaluateEPfPKfjj' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch8AAFilter8evaluateEPfPKfjj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilter8evaluateEPfPKfjj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilter8evaluateEPfPKfjj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch8AAFilter8evaluateERNS_16FIFOSampleBufferES2_' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch8AAFilter8evaluateERNS_16FIFOSampleBufferES20x5F(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer6ptrEndEj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer6ptrEndEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrEnd0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch8AAFilter9getLengthEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch8AAFilter9getLengthEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AgetLength0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch9FIRFilter9getLengthEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch9FIRFilter9getLengthEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AgetLength0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch8AAFilterC1Ej' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilterC1Ej(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AAAFilter0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch8AAFilterD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch8AAFilterD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3A0x7EAAFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBufferC2Ei' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBufferC2Ei(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch16FIFOSampleBufferE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch16FIFOSampleBufferE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch16FIFOSampleBufferE;
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer14ensureCapacityEj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer14ensureCapacityEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'memcpy' */
u32 w2c_rlboxsoundtouch_memcpy(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_memcpy_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'memmove' */
u32 w2c_rlboxsoundtouch_memmove(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_memmove_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBufferD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBufferD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBufferD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBufferD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdlPvm' */
void w2c_rlboxsoundtouch_0x5FZdlPvm(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer11setChannelsEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer11setChannelsEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer6rewindEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer6rewindEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Arewind0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer10putSamplesEPKfj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer10putSamplesEPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer10putSamplesEj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer10putSamplesEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer8ptrBeginEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer8ptrBeginEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch16FIFOSampleBuffer11getCapacityEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch16FIFOSampleBuffer11getCapacityEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AgetCapacity0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch16FIFOSampleBuffer10numSamplesEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch16FIFOSampleBuffer10numSamplesEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer14receiveSamplesEPfj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer14receiveSamplesEPfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer14receiveSamplesEj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer14receiveSamplesEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch16FIFOSampleBuffer7isEmptyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch16FIFOSampleBuffer7isEmptyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer5clearEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer5clearEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer21adjustAmountOfSamplesEj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer21adjustAmountOfSamplesEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBuffer9addSilentEj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBuffer9addSilentEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AaddSilent0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'memset' */
u32 w2c_rlboxsoundtouch_memset(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_memset_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch16FIFOSampleBufferE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch16FIFOSampleBufferE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch16FIFOSampleBufferE;
}

/* export: '_ZTSN10soundtouch16FIFOSampleBufferE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch16FIFOSampleBufferE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch16FIFOSampleBufferE;
}

/* export: '_ZTSN10soundtouch14FIFOSamplePipeE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch14FIFOSamplePipeE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch14FIFOSamplePipeE;
}

/* export: '_ZTIN10soundtouch14FIFOSamplePipeE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch14FIFOSamplePipeE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch14FIFOSamplePipeE;
}

/* export: '_ZTVN10__cxxabiv117__class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv117_0x5Fclass_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv117_0x5Fclass_type_infoE;
}

/* export: '_ZTVN10__cxxabiv120__si_class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE;
}

/* export: '_ZN10soundtouch16FIFOSampleBufferC1Ei' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBufferC1Ei(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16FIFOSampleBufferD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16FIFOSampleBufferD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilterC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilterC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AFIRFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch9FIRFilterE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch9FIRFilterE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch9FIRFilterE;
}

/* export: '_ZN10soundtouch9FIRFilterD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilterD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilterD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilterD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch9FIRFilter20evaluateFilterStereoEPfPKfj' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch9FIRFilter20evaluateFilterStereoEPfPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch9FIRFilter18evaluateFilterMonoEPfPKfj' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch9FIRFilter18evaluateFilterMonoEPfPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilter19evaluateFilterMultiEPfPKfjj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilter19evaluateFilterMultiEPfPKfjj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilter15setCoefficientsEPKfjj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilter15setCoefficientsEPKfjj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'ldexp' */
f64 w2c_rlboxsoundtouch_ldexp(w2c_rlboxsoundtouch* instance, f64 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_ldexp_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilternwEm' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilternwEm(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aoperator0x20new0x28unsigned0x20long0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_Z19detectCPUextensionsv' */
u32 w2c_rlboxsoundtouch_0x5FZ19detectCPUextensionsv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_detectCPUextensions0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_Znwm' */
u32 w2c_rlboxsoundtouch_0x5FZnwm(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch12FIRFilterSSEC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch12FIRFilterSSEC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AFIRFilterSSE0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch9FIRFilterE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch9FIRFilterE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch9FIRFilterE;
}

/* export: '_ZTSN10soundtouch9FIRFilterE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch9FIRFilterE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch9FIRFilterE;
}

/* export: '_ZN10soundtouch9FIRFilterC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilterC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AFIRFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9FIRFilterD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9FIRFilterD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16InterpolateCubicC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubicC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AInterpolateCubic0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14TransposerBaseC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBaseC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch16InterpolateCubicE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch16InterpolateCubicE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch16InterpolateCubicE;
}

/* export: '_ZN10soundtouch16InterpolateCubic14resetRegistersEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubic14resetRegistersEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AresetRegisters0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch16InterpolateCubic13transposeMonoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubic13transposeMonoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16InterpolateCubic15transposeStereoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubic15transposeStereoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16InterpolateCubic14transposeMultiEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubic14transposeMultiEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch16InterpolateCubicD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubicD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3A0x7EInterpolateCubic0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14TransposerBaseD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBaseD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch16InterpolateCubic10getLatencyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch16InterpolateCubic10getLatencyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AgetLatency0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch16InterpolateCubicE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch16InterpolateCubicE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch16InterpolateCubicE;
}

/* export: '_ZN10soundtouch14TransposerBase9transposeERNS_16FIFOSampleBufferES2_' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBase9transposeERNS_16FIFOSampleBufferES20x5F(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3Atranspose0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14TransposerBase7setRateEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBase7setRateEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14TransposerBase11setChannelsEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBase11setChannelsEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetChannels0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZTSN10soundtouch16InterpolateCubicE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch16InterpolateCubicE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch16InterpolateCubicE;
}

/* export: '_ZTIN10soundtouch14TransposerBaseE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch14TransposerBaseE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch14TransposerBaseE;
}

/* export: '_ZN10soundtouch16InterpolateCubicC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch16InterpolateCubicC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AInterpolateCubic0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch24InterpolateLinearIntegerC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearIntegerC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AInterpolateLinearInteger0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch24InterpolateLinearIntegerE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch24InterpolateLinearIntegerE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch24InterpolateLinearIntegerE;
}

/* export: '_ZN10soundtouch24InterpolateLinearInteger14resetRegistersEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearInteger14resetRegistersEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AresetRegisters0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch24InterpolateLinearInteger13transposeMonoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearInteger13transposeMonoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch24InterpolateLinearInteger15transposeStereoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearInteger15transposeStereoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch24InterpolateLinearInteger14transposeMultiEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearInteger14transposeMultiEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch24InterpolateLinearInteger7setRateEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearInteger7setRateEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AsetRate0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch22InterpolateLinearFloatC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloatC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AInterpolateLinearFloat0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch22InterpolateLinearFloatE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch22InterpolateLinearFloatE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch22InterpolateLinearFloatE;
}

/* export: '_ZN10soundtouch22InterpolateLinearFloat14resetRegistersEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloat14resetRegistersEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AresetRegisters0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch22InterpolateLinearFloat13transposeMonoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloat13transposeMonoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch22InterpolateLinearFloat15transposeStereoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloat15transposeStereoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch22InterpolateLinearFloat14transposeMultiEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloat14transposeMultiEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch24InterpolateLinearIntegerD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearIntegerD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3A0x7EInterpolateLinearInteger0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch24InterpolateLinearInteger10getLatencyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch24InterpolateLinearInteger10getLatencyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AgetLatency0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch22InterpolateLinearFloatD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloatD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3A0x7EInterpolateLinearFloat0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch22InterpolateLinearFloat10getLatencyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch22InterpolateLinearFloat10getLatencyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AgetLatency0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch24InterpolateLinearIntegerE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch24InterpolateLinearIntegerE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch24InterpolateLinearIntegerE;
}

/* export: '_ZTIN10soundtouch22InterpolateLinearFloatE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch22InterpolateLinearFloatE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch22InterpolateLinearFloatE;
}

/* export: '_ZTSN10soundtouch24InterpolateLinearIntegerE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch24InterpolateLinearIntegerE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch24InterpolateLinearIntegerE;
}

/* export: '_ZTSN10soundtouch22InterpolateLinearFloatE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch22InterpolateLinearFloatE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch22InterpolateLinearFloatE;
}

/* export: '_ZN10soundtouch24InterpolateLinearIntegerC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch24InterpolateLinearIntegerC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AInterpolateLinearInteger0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch22InterpolateLinearFloatC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch22InterpolateLinearFloatC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AInterpolateLinearFloat0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch18InterpolateShannonC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannonC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AInterpolateShannon0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch18InterpolateShannonE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch18InterpolateShannonE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch18InterpolateShannonE;
}

/* export: '_ZN10soundtouch18InterpolateShannon14resetRegistersEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannon14resetRegistersEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AresetRegisters0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch18InterpolateShannon13transposeMonoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannon13transposeMonoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch18InterpolateShannon15transposeStereoEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannon15transposeStereoEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch18InterpolateShannon14transposeMultiEPfPKfRi' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannon14transposeMultiEPfPKfRi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch18InterpolateShannonD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannonD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3A0x7EInterpolateShannon0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch18InterpolateShannon10getLatencyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch18InterpolateShannon10getLatencyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AgetLatency0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch18InterpolateShannonE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch18InterpolateShannonE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch18InterpolateShannonE;
}

/* export: '_ZTSN10soundtouch18InterpolateShannonE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch18InterpolateShannonE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch18InterpolateShannonE;
}

/* export: '_ZN10soundtouch18InterpolateShannonC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch18InterpolateShannonC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AInterpolateShannon0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'SetSampleRate' */
void w2c_rlboxsoundtouch_SetSampleRate(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_SetSampleRate_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch13setSampleRateEj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch13setSampleRateEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSampleRate0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'SetChannels' */
void w2c_rlboxsoundtouch_SetChannels(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_SetChannels_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch11setChannelsEj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch11setChannelsEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetChannels0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'SetPitch' */
void w2c_rlboxsoundtouch_SetPitch(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_SetPitch_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch8setPitchEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch8setPitchEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitch0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'SetSetting' */
void w2c_rlboxsoundtouch_SetSetting(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_SetSetting_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch10setSettingEii' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch10setSettingEii(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSetting0x28int0x2C0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'SetTempo' */
void w2c_rlboxsoundtouch_SetTempo(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_SetTempo_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch8setTempoEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch8setTempoEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempo0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'SetRate' */
void w2c_rlboxsoundtouch_SetRate(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_SetRate_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch7setRateEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch7setRateEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRate0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'NumChannels' */
u32 w2c_rlboxsoundtouch_NumChannels(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_NumChannels_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'NumSamples' */
u32 w2c_rlboxsoundtouch_NumSamples(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_NumSamples_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'NumUnprocessedSamples' */
u32 w2c_rlboxsoundtouch_NumUnprocessedSamples(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_NumUnprocessedSamples_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'PutSamples' */
void w2c_rlboxsoundtouch_PutSamples(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_PutSamples_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'ReceiveSamples' */
u32 w2c_rlboxsoundtouch_ReceiveSamples(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_ReceiveSamples_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'Flush' */
void w2c_rlboxsoundtouch_Flush(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_Flush_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch5flushEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch5flushEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aflush0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14RateTransposerC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposerC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3ARateTransposer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch14RateTransposerE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch14RateTransposerE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch14RateTransposerE;
}

/* export: '_ZN10soundtouch14TransposerBase11newInstanceEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBase11newInstanceEv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AnewInstance0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14TransposerBase9algorithmE' */
u32* w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBase9algorithmE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZN10soundtouch14TransposerBase9algorithmE;
}

/* export: '_ZN10soundtouch14RateTransposerD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposerD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14RateTransposerD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposerD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14RateTransposer14enableAAFilterEb' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer14enableAAFilterEb(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AenableAAFilter0x28bool0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch14RateTransposer17isAAFilterEnabledEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch14RateTransposer17isAAFilterEnabledEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisAAFilterEnabled0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14RateTransposer11getAAFilterEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer11getAAFilterEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetAAFilter0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14RateTransposer7setRateEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer7setRateEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetRate0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14RateTransposer10putSamplesEPKfj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer10putSamplesEPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14RateTransposer14processSamplesEPKfj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer14processSamplesEPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AprocessSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14RateTransposer11setChannelsEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer11setChannelsEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetChannels0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch14RateTransposer5clearEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposer5clearEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3Aclear0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch14RateTransposer10getLatencyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch14RateTransposer10getLatencyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetLatency0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch14RateTransposer7isEmptyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch14RateTransposer7isEmptyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisEmpty0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14TransposerBase12setAlgorithmENS0_9ALGORITHME' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBase12setAlgorithmENS0_9ALGORITHME(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetAlgorithm0x28soundtouch0x3A0x3ATransposerBase0x3A0x3AALGORITHM0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZTVN10soundtouch14TransposerBaseE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch14TransposerBaseE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch14TransposerBaseE;
}

/* export: '_ZN10soundtouch14TransposerBaseD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBaseD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch13FIFOProcessor8ptrBeginEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch13FIFOProcessor8ptrBeginEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AptrBegin0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch13FIFOProcessor14receiveSamplesEPfj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch13FIFOProcessor14receiveSamplesEPfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch13FIFOProcessor14receiveSamplesEj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch13FIFOProcessor14receiveSamplesEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch13FIFOProcessor10numSamplesEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch13FIFOProcessor10numSamplesEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AnumSamples0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch13FIFOProcessor21adjustAmountOfSamplesEj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch13FIFOProcessor21adjustAmountOfSamplesEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch14RateTransposerE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch14RateTransposerE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch14RateTransposerE;
}

/* export: '__cxa_pure_virtual' */
void w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZTSN10soundtouch14RateTransposerE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch14RateTransposerE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch14RateTransposerE;
}

/* export: '_ZTSN10soundtouch13FIFOProcessorE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch13FIFOProcessorE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch13FIFOProcessorE;
}

/* export: '_ZTIN10soundtouch13FIFOProcessorE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch13FIFOProcessorE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch13FIFOProcessorE;
}

/* export: '_ZTSN10soundtouch14TransposerBaseE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch14TransposerBaseE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch14TransposerBaseE;
}

/* export: '_ZN10soundtouch14RateTransposerC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposerC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3ARateTransposer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14RateTransposerD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14RateTransposerD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch14TransposerBaseD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch14TransposerBaseD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'soundtouch_ac_test' */
void w2c_rlboxsoundtouch_soundtouch_ac_test(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch_ac_test_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'printf' */
u32 w2c_rlboxsoundtouch_printf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_printf_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouchC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouchC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3ASoundTouch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch10SoundTouchE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch10SoundTouchE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch10SoundTouchE;
}

/* export: '_ZN10soundtouch9TDStretch11newInstanceEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch11newInstanceEv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AnewInstance0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch25calcEffectiveRateAndTempoEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch25calcEffectiveRateAndTempoEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch8setTempoEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch8setTempoEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetTempo0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouchD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouchD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouchD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouchD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch16getVersionStringEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch16getVersionStringEv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetVersionString0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch12getVersionIdEv' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch12getVersionIdEv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetVersionId0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretch11setChannelsEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch11setChannelsEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetChannels0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch13setRateChangeEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch13setRateChangeEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRateChange0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch14setTempoChangeEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch14setTempoChangeEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempoChange0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch15setPitchOctavesEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch15setPitchOctavesEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchOctaves0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'exp' */
f64 w2c_rlboxsoundtouch_exp(w2c_rlboxsoundtouch* instance, f64 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_exp_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch17setPitchSemiTonesEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch17setPitchSemiTonesEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchSemiTones0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch17setPitchSemiTonesEd' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch17setPitchSemiTonesEd(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchSemiTones0x28double0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch13setParametersEiiii' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch13setParametersEiiii(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch10SoundTouch10putSamplesEPKfj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch10putSamplesEPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch10clearInputEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch10clearInputEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearInput0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch9TDStretch13getParametersEPiS1_S1_S1_' */
void w2c_rlboxsoundtouch_0x5FZNK10soundtouch9TDStretch13getParametersEPiS1_S1_S10x5F(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch15enableQuickSeekEb' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch15enableQuickSeekEb(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AenableQuickSeek0x28bool0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch10SoundTouch10getSettingEi' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch10SoundTouch10getSettingEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetSetting0x28int0x290x20const(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch9TDStretch18isQuickSeekEnabledEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch9TDStretch18isQuickSeekEnabledEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AisQuickSeekEnabled0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch5clearEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch5clearEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aclear0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch10SoundTouch21numUnprocessedSamplesEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch10SoundTouch21numUnprocessedSamplesEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AnumUnprocessedSamples0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch14receiveSamplesEPfj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch14receiveSamplesEPfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch14receiveSamplesEj' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch14receiveSamplesEj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouch25getInputOutputSampleRatioEv' */
f64 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouch25getInputOutputSampleRatioEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetInputOutputSampleRatio0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10soundtouch13FIFOProcessor7isEmptyEv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch13FIFOProcessor7isEmptyEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AisEmpty0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch10SoundTouchE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch10SoundTouchE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch10SoundTouchE;
}

/* export: '_ZTSN10soundtouch10SoundTouchE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch10SoundTouchE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch10SoundTouchE;
}

/* export: '_ZN10soundtouch10SoundTouchC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouchC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3ASoundTouch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch10SoundTouchD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch10SoundTouchD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'createSoundTouchObj' */
u32 w2c_rlboxsoundtouch_createSoundTouchObj(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_createSoundTouchObj_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'destroySoundTouchObj' */
void w2c_rlboxsoundtouch_destroySoundTouchObj(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_destroySoundTouchObj_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretchC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretchC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3ATDStretch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch9TDStretchE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch9TDStretchE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch9TDStretchE;
}

/* export: '_ZN10soundtouch9TDStretch17calcSeqParametersEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch17calcSeqParametersEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch22acceptNewOverlapLengthEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch22acceptNewOverlapLengthEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AacceptNewOverlapLength0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretchD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretchD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretchD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretchD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch22calculateOverlapLengthEi' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch22calculateOverlapLengthEi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalculateOverlapLength0x28int0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch9TDStretch11overlapMonoEPfPKf' */
void w2c_rlboxsoundtouch_0x5FZNK10soundtouch9TDStretch11overlapMonoEPfPKf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMono0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch14clearMidBufferEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch14clearMidBufferEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearMidBuffer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch5clearEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch5clearEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aclear0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch23seekBestOverlapPositionEPKf' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch23seekBestOverlapPositionEPKf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPosition0x28float0x20const0x2A0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretch27seekBestOverlapPositionFullEPKf' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch27seekBestOverlapPositionFullEPKf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionFull0x28float0x20const0x2A0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretch28seekBestOverlapPositionQuickEPKf' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch28seekBestOverlapPositionQuickEPKf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionQuick0x28float0x20const0x2A0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretch15adaptNormalizerEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch15adaptNormalizerEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AadaptNormalizer0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch19clearCrossCorrStateEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch19clearCrossCorrStateEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearCrossCorrState0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch14processSamplesEv' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch14processSamplesEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AprocessSamples0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch10putSamplesEPKfj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch10putSamplesEPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretchnwEm' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretchnwEm(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aoperator0x20new0x28unsigned0x20long0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch12TDStretchSSEE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch12TDStretchSSEE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch12TDStretchSSEE;
}

/* export: '_ZNK10soundtouch9TDStretch13overlapStereoEPfPKf' */
void w2c_rlboxsoundtouch_0x5FZNK10soundtouch9TDStretch13overlapStereoEPfPKf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapStereo0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch9TDStretch12overlapMultiEPfPKf' */
void w2c_rlboxsoundtouch_0x5FZNK10soundtouch9TDStretch12overlapMultiEPfPKf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMulti0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch9TDStretch13calcCrossCorrEPKfS2_Rd' */
f64 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch13calcCrossCorrEPKfS2_Rd(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretch23calcCrossCorrAccumulateEPKfS2_Rd' */
f64 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretch23calcCrossCorrAccumulateEPKfS2_Rd(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10soundtouch9TDStretchE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch9TDStretchE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch9TDStretchE;
}

/* export: '_ZTSN10soundtouch9TDStretchE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch9TDStretchE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch9TDStretchE;
}

/* export: '_ZN10soundtouch9TDStretchC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretchC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3ATDStretch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch9TDStretchD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch9TDStretchD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_Z17disableExtensionsj' */
void w2c_rlboxsoundtouch_0x5FZ17disableExtensionsj(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_disableExtensions0x28unsigned0x20int0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch12TDStretchSSE13calcCrossCorrEPKfS2_Rd' */
f64 w2c_rlboxsoundtouch_0x5FZN10soundtouch12TDStretchSSE13calcCrossCorrEPKfS2_Rd(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch12TDStretchSSE23calcCrossCorrAccumulateEPKfS2_Rd' */
f64 w2c_rlboxsoundtouch_0x5FZN10soundtouch12TDStretchSSE23calcCrossCorrAccumulateEPKfS2_Rd(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch12FIRFilterSSEC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch12FIRFilterSSEC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AFIRFilterSSE0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVN10soundtouch12FIRFilterSSEE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10soundtouch12FIRFilterSSEE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10soundtouch12FIRFilterSSEE;
}

/* export: '_ZN10soundtouch12FIRFilterSSED2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch12FIRFilterSSED2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch12FIRFilterSSED0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch12FIRFilterSSED0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10soundtouch12FIRFilterSSE15setCoefficientsEPKfjj' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch12FIRFilterSSE15setCoefficientsEPKfjj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10soundtouch12FIRFilterSSE20evaluateFilterStereoEPfPKfj' */
u32 w2c_rlboxsoundtouch_0x5FZNK10soundtouch12FIRFilterSSE20evaluateFilterStereoEPfPKfj(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10soundtouch12TDStretchSSED0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10soundtouch12TDStretchSSED0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3A0x7ETDStretchSSE0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZTIN10soundtouch12FIRFilterSSEE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch12FIRFilterSSEE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch12FIRFilterSSEE;
}

/* export: '_ZTIN10soundtouch12TDStretchSSEE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10soundtouch12TDStretchSSEE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10soundtouch12TDStretchSSEE;
}

/* export: '_ZTSN10soundtouch12TDStretchSSEE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch12TDStretchSSEE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch12TDStretchSSEE;
}

/* export: '_ZTSN10soundtouch12FIRFilterSSEE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10soundtouch12FIRFilterSSEE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10soundtouch12FIRFilterSSEE;
}

/* export: '_ZN10soundtouch12FIRFilterSSED1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10soundtouch12FIRFilterSSED1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_xmalloc' */
u32 w2c_rlboxsoundtouch_moz_xmalloc(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_xmalloc_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'malloc' */
u32 w2c_rlboxsoundtouch_malloc(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_malloc_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_xcalloc' */
u32 w2c_rlboxsoundtouch_moz_xcalloc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_xcalloc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'calloc' */
u32 w2c_rlboxsoundtouch_calloc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_calloc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_xrealloc' */
u32 w2c_rlboxsoundtouch_moz_xrealloc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_xrealloc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'realloc' */
u32 w2c_rlboxsoundtouch_realloc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_realloc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_xstrdup' */
u32 w2c_rlboxsoundtouch_moz_xstrdup(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_xstrdup_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'strdup' */
u32 w2c_rlboxsoundtouch_strdup(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_strdup_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_xmemdup' */
u32 w2c_rlboxsoundtouch_moz_xmemdup(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_xmemdup_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_malloc_usable_size' */
u32 w2c_rlboxsoundtouch_moz_malloc_usable_size(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_malloc_usable_size_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_malloc_size_of' */
u32 w2c_rlboxsoundtouch_moz_malloc_size_of(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_malloc_size_of_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'moz_malloc_enclosing_size_of' */
u32 w2c_rlboxsoundtouch_moz_malloc_enclosing_size_of(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_moz_malloc_enclosing_size_of_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZSt14set_unexpectedPFvvE' */
u32 w2c_rlboxsoundtouch_0x5FZSt14set_unexpectedPFvvE(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aset_unexpected0x28void0x200x280x2A0x290x280x290x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__cxa_unexpected_handler' */
u32* w2c_rlboxsoundtouch_0x5F_cxa_unexpected_handler(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_cxa_unexpected_handler;
}

/* export: '_ZSt13set_terminatePFvvE' */
u32 w2c_rlboxsoundtouch_0x5FZSt13set_terminatePFvvE(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aset_terminate0x28void0x200x280x2A0x290x280x290x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__cxa_terminate_handler' */
u32* w2c_rlboxsoundtouch_0x5F_cxa_terminate_handler(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_cxa_terminate_handler;
}

/* export: '_ZSt15set_new_handlerPFvvE' */
u32 w2c_rlboxsoundtouch_0x5FZSt15set_new_handlerPFvvE(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aset_new_handler0x28void0x200x280x2A0x290x280x290x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__cxa_new_handler' */
u32* w2c_rlboxsoundtouch_0x5F_cxa_new_handler(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_cxa_new_handler;
}

/* export: '_ZSt14get_unexpectedv' */
u32 w2c_rlboxsoundtouch_0x5FZSt14get_unexpectedv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aget_unexpected0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZSt12__unexpectedPFvvE' */
void w2c_rlboxsoundtouch_0x5FZSt12_0x5FunexpectedPFvvE(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3A_0x5Funexpected0x28void0x200x280x2A0x290x280x290x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZSt10unexpectedv' */
void w2c_rlboxsoundtouch_0x5FZSt10unexpectedv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Aunexpected0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZSt13get_terminatev' */
u32 w2c_rlboxsoundtouch_0x5FZSt13get_terminatev(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aget_terminate0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZSt11__terminatePFvvE' */
void w2c_rlboxsoundtouch_0x5FZSt11_0x5FterminatePFvvE(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3A_0x5Fterminate0x28void0x200x280x2A0x290x280x290x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZSt9terminatev' */
void w2c_rlboxsoundtouch_0x5FZSt9terminatev(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Aterminate0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZSt15get_new_handlerv' */
u32 w2c_rlboxsoundtouch_0x5FZSt15get_new_handlerv(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aget_new_handler0x280x29(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'abort_message' */
void w2c_rlboxsoundtouch_abort_message(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_abort_message_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__cxa_deleted_virtual' */
void w2c_rlboxsoundtouch_0x5F_cxa_deleted_virtual(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxa_deleted_virtual_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt9exceptionD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9exceptionD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt9exceptionD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt9exceptionD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt9exceptionD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9exceptionD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNKSt9exception4whatEv' */
u32 w2c_rlboxsoundtouch_0x5FZNKSt9exception4whatEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt13bad_exceptionD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt13bad_exceptionD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt13bad_exceptionD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt13bad_exceptionD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNKSt13bad_exception4whatEv' */
u32 w2c_rlboxsoundtouch_0x5FZNKSt13bad_exception4whatEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt9bad_allocC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9bad_allocC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Abad_alloc0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVSt9bad_alloc' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt9bad_alloc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt9bad_alloc;
}

/* export: '_ZNSt9bad_allocD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt9bad_allocD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt9bad_allocD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9bad_allocD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNKSt9bad_alloc4whatEv' */
u32 w2c_rlboxsoundtouch_0x5FZNKSt9bad_alloc4whatEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt20bad_array_new_lengthC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt20bad_array_new_lengthC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Abad_array_new_length0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVSt20bad_array_new_length' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt20bad_array_new_length(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt20bad_array_new_length;
}

/* export: '_ZNSt20bad_array_new_lengthD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt20bad_array_new_lengthD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt20bad_array_new_lengthD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt20bad_array_new_lengthD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNKSt20bad_array_new_length4whatEv' */
u32 w2c_rlboxsoundtouch_0x5FZNKSt20bad_array_new_length4whatEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTISt9bad_alloc' */
u32* w2c_rlboxsoundtouch_0x5FZTISt9bad_alloc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt9bad_alloc;
}

/* export: '_ZTISt20bad_array_new_length' */
u32* w2c_rlboxsoundtouch_0x5FZTISt20bad_array_new_length(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt20bad_array_new_length;
}

/* export: '_ZTVSt9exception' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt9exception(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt9exception;
}

/* export: '_ZTISt9exception' */
u32* w2c_rlboxsoundtouch_0x5FZTISt9exception(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt9exception;
}

/* export: '_ZTSSt9exception' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt9exception(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt9exception;
}

/* export: '_ZTVSt13bad_exception' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt13bad_exception(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt13bad_exception;
}

/* export: '_ZTISt13bad_exception' */
u32* w2c_rlboxsoundtouch_0x5FZTISt13bad_exception(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt13bad_exception;
}

/* export: '_ZTSSt13bad_exception' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt13bad_exception(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt13bad_exception;
}

/* export: '_ZTSSt9bad_alloc' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt9bad_alloc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt9bad_alloc;
}

/* export: '_ZTSSt20bad_array_new_length' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt20bad_array_new_length(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt20bad_array_new_length;
}

/* export: '_ZNSt13bad_exceptionD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt13bad_exceptionD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt9bad_allocC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9bad_allocC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Abad_alloc0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt9bad_allocD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9bad_allocD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt20bad_array_new_lengthC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt20bad_array_new_lengthC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Abad_array_new_length0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt20bad_array_new_lengthD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt20bad_array_new_lengthD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt9type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt9type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt9type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt9type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt9type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt8bad_castC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt8bad_castC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Abad_cast0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVSt8bad_cast' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt8bad_cast(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt8bad_cast;
}

/* export: '_ZNSt8bad_castD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt8bad_castD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt8bad_castD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt8bad_castD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt8bad_castD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt8bad_castD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNKSt8bad_cast4whatEv' */
u32 w2c_rlboxsoundtouch_0x5FZNKSt8bad_cast4whatEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt10bad_typeidC2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt10bad_typeidC2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Abad_typeid0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTVSt10bad_typeid' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt10bad_typeid(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt10bad_typeid;
}

/* export: '_ZNSt10bad_typeidD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt10bad_typeidD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt10bad_typeidD0Ev' */
void w2c_rlboxsoundtouch_0x5FZNSt10bad_typeidD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNSt10bad_typeidD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt10bad_typeidD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNKSt10bad_typeid4whatEv' */
u32 w2c_rlboxsoundtouch_0x5FZNKSt10bad_typeid4whatEv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTISt8bad_cast' */
u32* w2c_rlboxsoundtouch_0x5FZTISt8bad_cast(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt8bad_cast;
}

/* export: '_ZTISt10bad_typeid' */
u32* w2c_rlboxsoundtouch_0x5FZTISt10bad_typeid(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt10bad_typeid;
}

/* export: '_ZTVSt9type_info' */
u32* w2c_rlboxsoundtouch_0x5FZTVSt9type_info(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVSt9type_info;
}

/* export: '_ZTISt9type_info' */
u32* w2c_rlboxsoundtouch_0x5FZTISt9type_info(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTISt9type_info;
}

/* export: '_ZTSSt9type_info' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt9type_info(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt9type_info;
}

/* export: '_ZTSSt8bad_cast' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt8bad_cast(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt8bad_cast;
}

/* export: '_ZTSSt10bad_typeid' */
u32* w2c_rlboxsoundtouch_0x5FZTSSt10bad_typeid(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSSt10bad_typeid;
}

/* export: '_ZNSt8bad_castC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt8bad_castC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Abad_cast0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNSt10bad_typeidC1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZNSt10bad_typeidC1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Abad_typeid0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'stderr' */
u32* w2c_rlboxsoundtouch_stderr(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_stderr;
}

/* export: 'fwrite' */
u32 w2c_rlboxsoundtouch_fwrite(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_fwrite_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'vfprintf' */
u32 w2c_rlboxsoundtouch_vfprintf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_vfprintf_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'fputc' */
u32 w2c_rlboxsoundtouch_fputc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_fputc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv116__shim_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv116_0x5Fshim_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv116__shim_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv116_0x5Fshim_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv116__shim_type_info5noop1Ev' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv116_0x5Fshim_type_info5noop1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv116__shim_type_info5noop2Ev' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv116_0x5Fshim_type_info5noop2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv123__fundamental_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv117__array_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Farray_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv120__function_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv120_0x5Ffunction_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv116__enum_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv116_0x5Fenum_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv117__class_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Fclass_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv120__si_class_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv121__vmi_class_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv117__pbase_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Fpbase_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv119__pointer_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv119_0x5Fpointer_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZN10__cxxabiv129__pointer_to_member_type_infoD0Ev' */
void w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoD0Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv123__fundamental_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv123_0x5Ffundamental_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv117__array_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Farray_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv120__function_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv120_0x5Ffunction_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv116__enum_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv116_0x5Fenum_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv117__class_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10__cxxabiv116__shim_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv116_0x5Fshim_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv116_0x5Fshim_type_infoE;
}

/* export: '_ZTIN10__cxxabiv117__class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv117_0x5Fclass_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv117_0x5Fclass_type_infoE;
}

/* export: '__dynamic_cast' */
u32 w2c_rlboxsoundtouch_0x5F_dynamic_cast(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv117__class_type_info24process_found_base_classEPNS_19__dynamic_cast_infoEPvi' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info24process_found_base_classEPNS_19_0x5Fdynamic_cast_infoEPvi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_found_base_class0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv117__class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info27has_unambiguous_public_baseEPNS_19_0x5Fdynamic_cast_infoEPvi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv120__si_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv120_0x5Fsi_class_type_info27has_unambiguous_public_baseEPNS_19_0x5Fdynamic_cast_infoEPvi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv122__base_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv122_0x5Fbase_class_type_info27has_unambiguous_public_baseEPNS_19_0x5Fdynamic_cast_infoEPvi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv121__vmi_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv121_0x5Fvmi_class_type_info27has_unambiguous_public_baseEPNS_19_0x5Fdynamic_cast_infoEPvi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv117__pbase_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fpbase_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10__cxxabiv117__pbase_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE;
}

/* export: '_ZNK10__cxxabiv119__pointer_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv119_0x5Fpointer_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTSDn' */
u32* w2c_rlboxsoundtouch_0x5FZTSDn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSDn;
}

/* export: '_ZTIN10__cxxabiv119__pointer_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE;
}

/* export: '_ZTSv' */
u32* w2c_rlboxsoundtouch_0x5FZTSv(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSv;
}

/* export: '_ZTIN10__cxxabiv120__function_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE;
}

/* export: '_ZNK10__cxxabiv119__pointer_type_info16can_catch_nestedEPKNS_16__shim_type_infoE' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv119_0x5Fpointer_type_info16can_catch_nestedEPKNS_16_0x5Fshim_type_infoE(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTIN10__cxxabiv129__pointer_to_member_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE;
}

/* export: '_ZNK10__cxxabiv129__pointer_to_member_type_info16can_catch_nestedEPKNS_16__shim_type_infoE' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_info16can_catch_nestedEPKNS_16_0x5Fshim_type_infoE(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv129__pointer_to_member_type_info9can_catchEPKNS_16__shim_type_infoERPv' */
u32 w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_info9can_catchEPKNS_16_0x5Fshim_type_infoERPv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZNK10__cxxabiv117__class_type_info29process_static_type_above_dstEPNS_19__dynamic_cast_infoEPKvS4_i' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info29process_static_type_above_dstEPNS_19_0x5Fdynamic_cast_infoEPKvS4_i(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv117__class_type_info29process_static_type_below_dstEPNS_19__dynamic_cast_infoEPKvi' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info29process_static_type_below_dstEPNS_19_0x5Fdynamic_cast_infoEPKvi(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv121__vmi_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv121_0x5Fvmi_class_type_info16search_below_dstEPNS_19_0x5Fdynamic_cast_infoEPKvib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv122__base_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv122_0x5Fbase_class_type_info16search_above_dstEPNS_19_0x5Fdynamic_cast_infoEPKvS4_ib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv122__base_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv122_0x5Fbase_class_type_info16search_below_dstEPNS_19_0x5Fdynamic_cast_infoEPKvib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv120__si_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv120_0x5Fsi_class_type_info16search_below_dstEPNS_19_0x5Fdynamic_cast_infoEPKvib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv117__class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info16search_below_dstEPNS_19_0x5Fdynamic_cast_infoEPKvib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv121__vmi_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv121_0x5Fvmi_class_type_info16search_above_dstEPNS_19_0x5Fdynamic_cast_infoEPKvS4_ib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv120__si_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv120_0x5Fsi_class_type_info16search_above_dstEPNS_19_0x5Fdynamic_cast_infoEPKvS4_ib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZNK10__cxxabiv117__class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib' */
void w2c_rlboxsoundtouch_0x5FZNK10_0x5Fcxxabiv117_0x5Fclass_type_info16search_above_dstEPNS_19_0x5Fdynamic_cast_infoEPKvS4_ib(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZTSN10__cxxabiv116__shim_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv116_0x5Fshim_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv116_0x5Fshim_type_infoE;
}

/* export: 'strcmp' */
u32 w2c_rlboxsoundtouch_strcmp(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_strcmp_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZTSN10__cxxabiv117__class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv117_0x5Fclass_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv117_0x5Fclass_type_infoE;
}

/* export: '_ZTSN10__cxxabiv117__pbase_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE;
}

/* export: '_ZTSN10__cxxabiv119__pointer_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE;
}

/* export: '_ZTSN10__cxxabiv120__function_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE;
}

/* export: '_ZTSN10__cxxabiv129__pointer_to_member_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE;
}

/* export: '_ZTVN10__cxxabiv116__shim_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv116_0x5Fshim_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv116_0x5Fshim_type_infoE;
}

/* export: '_ZTVN10__cxxabiv123__fundamental_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE;
}

/* export: '_ZTIN10__cxxabiv123__fundamental_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE;
}

/* export: '_ZTSN10__cxxabiv123__fundamental_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoE;
}

/* export: '_ZTIv' */
u32* w2c_rlboxsoundtouch_0x5FZTIv(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIv;
}

/* export: '_ZTSPv' */
u32* w2c_rlboxsoundtouch_0x5FZTSPv(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPv;
}

/* export: '_ZTIPv' */
u32* w2c_rlboxsoundtouch_0x5FZTIPv(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPv;
}

/* export: '_ZTVN10__cxxabiv119__pointer_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv119_0x5Fpointer_type_infoE;
}

/* export: '_ZTSPKv' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKv(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKv;
}

/* export: '_ZTIPKv' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKv(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKv;
}

/* export: '_ZTIDn' */
u32* w2c_rlboxsoundtouch_0x5FZTIDn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIDn;
}

/* export: '_ZTSPDn' */
u32* w2c_rlboxsoundtouch_0x5FZTSPDn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPDn;
}

/* export: '_ZTIPDn' */
u32* w2c_rlboxsoundtouch_0x5FZTIPDn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPDn;
}

/* export: '_ZTSPKDn' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKDn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKDn;
}

/* export: '_ZTIPKDn' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKDn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKDn;
}

/* export: '_ZTSb' */
u32* w2c_rlboxsoundtouch_0x5FZTSb(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSb;
}

/* export: '_ZTIb' */
u32* w2c_rlboxsoundtouch_0x5FZTIb(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIb;
}

/* export: '_ZTSPb' */
u32* w2c_rlboxsoundtouch_0x5FZTSPb(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPb;
}

/* export: '_ZTIPb' */
u32* w2c_rlboxsoundtouch_0x5FZTIPb(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPb;
}

/* export: '_ZTSPKb' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKb(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKb;
}

/* export: '_ZTIPKb' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKb(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKb;
}

/* export: '_ZTSw' */
u32* w2c_rlboxsoundtouch_0x5FZTSw(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSw;
}

/* export: '_ZTIw' */
u32* w2c_rlboxsoundtouch_0x5FZTIw(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIw;
}

/* export: '_ZTSPw' */
u32* w2c_rlboxsoundtouch_0x5FZTSPw(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPw;
}

/* export: '_ZTIPw' */
u32* w2c_rlboxsoundtouch_0x5FZTIPw(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPw;
}

/* export: '_ZTSPKw' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKw(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKw;
}

/* export: '_ZTIPKw' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKw(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKw;
}

/* export: '_ZTSc' */
u32* w2c_rlboxsoundtouch_0x5FZTSc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSc;
}

/* export: '_ZTIc' */
u32* w2c_rlboxsoundtouch_0x5FZTIc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIc;
}

/* export: '_ZTSPc' */
u32* w2c_rlboxsoundtouch_0x5FZTSPc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPc;
}

/* export: '_ZTIPc' */
u32* w2c_rlboxsoundtouch_0x5FZTIPc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPc;
}

/* export: '_ZTSPKc' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKc;
}

/* export: '_ZTIPKc' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKc;
}

/* export: '_ZTSh' */
u32* w2c_rlboxsoundtouch_0x5FZTSh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSh;
}

/* export: '_ZTIh' */
u32* w2c_rlboxsoundtouch_0x5FZTIh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIh;
}

/* export: '_ZTSPh' */
u32* w2c_rlboxsoundtouch_0x5FZTSPh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPh;
}

/* export: '_ZTIPh' */
u32* w2c_rlboxsoundtouch_0x5FZTIPh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPh;
}

/* export: '_ZTSPKh' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKh;
}

/* export: '_ZTIPKh' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKh;
}

/* export: '_ZTSa' */
u32* w2c_rlboxsoundtouch_0x5FZTSa(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSa;
}

/* export: '_ZTIa' */
u32* w2c_rlboxsoundtouch_0x5FZTIa(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIa;
}

/* export: '_ZTSPa' */
u32* w2c_rlboxsoundtouch_0x5FZTSPa(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPa;
}

/* export: '_ZTIPa' */
u32* w2c_rlboxsoundtouch_0x5FZTIPa(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPa;
}

/* export: '_ZTSPKa' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKa(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKa;
}

/* export: '_ZTIPKa' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKa(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKa;
}

/* export: '_ZTSs' */
u32* w2c_rlboxsoundtouch_0x5FZTSs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSs;
}

/* export: '_ZTIs' */
u32* w2c_rlboxsoundtouch_0x5FZTIs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIs;
}

/* export: '_ZTSPs' */
u32* w2c_rlboxsoundtouch_0x5FZTSPs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPs;
}

/* export: '_ZTIPs' */
u32* w2c_rlboxsoundtouch_0x5FZTIPs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPs;
}

/* export: '_ZTSPKs' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKs;
}

/* export: '_ZTIPKs' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKs;
}

/* export: '_ZTSt' */
u32* w2c_rlboxsoundtouch_0x5FZTSt(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSt;
}

/* export: '_ZTIt' */
u32* w2c_rlboxsoundtouch_0x5FZTIt(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIt;
}

/* export: '_ZTSPt' */
u32* w2c_rlboxsoundtouch_0x5FZTSPt(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPt;
}

/* export: '_ZTIPt' */
u32* w2c_rlboxsoundtouch_0x5FZTIPt(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPt;
}

/* export: '_ZTSPKt' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKt(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKt;
}

/* export: '_ZTIPKt' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKt(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKt;
}

/* export: '_ZTSi' */
u32* w2c_rlboxsoundtouch_0x5FZTSi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSi;
}

/* export: '_ZTIi' */
u32* w2c_rlboxsoundtouch_0x5FZTIi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIi;
}

/* export: '_ZTSPi' */
u32* w2c_rlboxsoundtouch_0x5FZTSPi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPi;
}

/* export: '_ZTIPi' */
u32* w2c_rlboxsoundtouch_0x5FZTIPi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPi;
}

/* export: '_ZTSPKi' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKi;
}

/* export: '_ZTIPKi' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKi;
}

/* export: '_ZTSj' */
u32* w2c_rlboxsoundtouch_0x5FZTSj(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSj;
}

/* export: '_ZTIj' */
u32* w2c_rlboxsoundtouch_0x5FZTIj(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIj;
}

/* export: '_ZTSPj' */
u32* w2c_rlboxsoundtouch_0x5FZTSPj(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPj;
}

/* export: '_ZTIPj' */
u32* w2c_rlboxsoundtouch_0x5FZTIPj(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPj;
}

/* export: '_ZTSPKj' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKj(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKj;
}

/* export: '_ZTIPKj' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKj(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKj;
}

/* export: '_ZTSl' */
u32* w2c_rlboxsoundtouch_0x5FZTSl(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSl;
}

/* export: '_ZTIl' */
u32* w2c_rlboxsoundtouch_0x5FZTIl(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIl;
}

/* export: '_ZTSPl' */
u32* w2c_rlboxsoundtouch_0x5FZTSPl(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPl;
}

/* export: '_ZTIPl' */
u32* w2c_rlboxsoundtouch_0x5FZTIPl(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPl;
}

/* export: '_ZTSPKl' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKl(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKl;
}

/* export: '_ZTIPKl' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKl(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKl;
}

/* export: '_ZTSm' */
u32* w2c_rlboxsoundtouch_0x5FZTSm(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSm;
}

/* export: '_ZTIm' */
u32* w2c_rlboxsoundtouch_0x5FZTIm(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIm;
}

/* export: '_ZTSPm' */
u32* w2c_rlboxsoundtouch_0x5FZTSPm(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPm;
}

/* export: '_ZTIPm' */
u32* w2c_rlboxsoundtouch_0x5FZTIPm(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPm;
}

/* export: '_ZTSPKm' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKm(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKm;
}

/* export: '_ZTIPKm' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKm(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKm;
}

/* export: '_ZTSx' */
u32* w2c_rlboxsoundtouch_0x5FZTSx(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSx;
}

/* export: '_ZTIx' */
u32* w2c_rlboxsoundtouch_0x5FZTIx(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIx;
}

/* export: '_ZTSPx' */
u32* w2c_rlboxsoundtouch_0x5FZTSPx(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPx;
}

/* export: '_ZTIPx' */
u32* w2c_rlboxsoundtouch_0x5FZTIPx(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPx;
}

/* export: '_ZTSPKx' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKx(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKx;
}

/* export: '_ZTIPKx' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKx(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKx;
}

/* export: '_ZTSy' */
u32* w2c_rlboxsoundtouch_0x5FZTSy(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSy;
}

/* export: '_ZTIy' */
u32* w2c_rlboxsoundtouch_0x5FZTIy(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIy;
}

/* export: '_ZTSPy' */
u32* w2c_rlboxsoundtouch_0x5FZTSPy(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPy;
}

/* export: '_ZTIPy' */
u32* w2c_rlboxsoundtouch_0x5FZTIPy(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPy;
}

/* export: '_ZTSPKy' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKy(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKy;
}

/* export: '_ZTIPKy' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKy(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKy;
}

/* export: '_ZTSn' */
u32* w2c_rlboxsoundtouch_0x5FZTSn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSn;
}

/* export: '_ZTIn' */
u32* w2c_rlboxsoundtouch_0x5FZTIn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIn;
}

/* export: '_ZTSPn' */
u32* w2c_rlboxsoundtouch_0x5FZTSPn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPn;
}

/* export: '_ZTIPn' */
u32* w2c_rlboxsoundtouch_0x5FZTIPn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPn;
}

/* export: '_ZTSPKn' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKn;
}

/* export: '_ZTIPKn' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKn(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKn;
}

/* export: '_ZTSo' */
u32* w2c_rlboxsoundtouch_0x5FZTSo(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSo;
}

/* export: '_ZTIo' */
u32* w2c_rlboxsoundtouch_0x5FZTIo(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIo;
}

/* export: '_ZTSPo' */
u32* w2c_rlboxsoundtouch_0x5FZTSPo(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPo;
}

/* export: '_ZTIPo' */
u32* w2c_rlboxsoundtouch_0x5FZTIPo(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPo;
}

/* export: '_ZTSPKo' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKo(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKo;
}

/* export: '_ZTIPKo' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKo(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKo;
}

/* export: '_ZTSDh' */
u32* w2c_rlboxsoundtouch_0x5FZTSDh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSDh;
}

/* export: '_ZTIDh' */
u32* w2c_rlboxsoundtouch_0x5FZTIDh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIDh;
}

/* export: '_ZTSPDh' */
u32* w2c_rlboxsoundtouch_0x5FZTSPDh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPDh;
}

/* export: '_ZTIPDh' */
u32* w2c_rlboxsoundtouch_0x5FZTIPDh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPDh;
}

/* export: '_ZTSPKDh' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKDh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKDh;
}

/* export: '_ZTIPKDh' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKDh(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKDh;
}

/* export: '_ZTSf' */
u32* w2c_rlboxsoundtouch_0x5FZTSf(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSf;
}

/* export: '_ZTIf' */
u32* w2c_rlboxsoundtouch_0x5FZTIf(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIf;
}

/* export: '_ZTSPf' */
u32* w2c_rlboxsoundtouch_0x5FZTSPf(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPf;
}

/* export: '_ZTIPf' */
u32* w2c_rlboxsoundtouch_0x5FZTIPf(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPf;
}

/* export: '_ZTSPKf' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKf(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKf;
}

/* export: '_ZTIPKf' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKf(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKf;
}

/* export: '_ZTSd' */
u32* w2c_rlboxsoundtouch_0x5FZTSd(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSd;
}

/* export: '_ZTId' */
u32* w2c_rlboxsoundtouch_0x5FZTId(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTId;
}

/* export: '_ZTSPd' */
u32* w2c_rlboxsoundtouch_0x5FZTSPd(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPd;
}

/* export: '_ZTIPd' */
u32* w2c_rlboxsoundtouch_0x5FZTIPd(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPd;
}

/* export: '_ZTSPKd' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKd(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKd;
}

/* export: '_ZTIPKd' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKd(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKd;
}

/* export: '_ZTSe' */
u32* w2c_rlboxsoundtouch_0x5FZTSe(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSe;
}

/* export: '_ZTIe' */
u32* w2c_rlboxsoundtouch_0x5FZTIe(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIe;
}

/* export: '_ZTSPe' */
u32* w2c_rlboxsoundtouch_0x5FZTSPe(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPe;
}

/* export: '_ZTIPe' */
u32* w2c_rlboxsoundtouch_0x5FZTIPe(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPe;
}

/* export: '_ZTSPKe' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKe(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKe;
}

/* export: '_ZTIPKe' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKe(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKe;
}

/* export: '_ZTSg' */
u32* w2c_rlboxsoundtouch_0x5FZTSg(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSg;
}

/* export: '_ZTIg' */
u32* w2c_rlboxsoundtouch_0x5FZTIg(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIg;
}

/* export: '_ZTSPg' */
u32* w2c_rlboxsoundtouch_0x5FZTSPg(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPg;
}

/* export: '_ZTIPg' */
u32* w2c_rlboxsoundtouch_0x5FZTIPg(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPg;
}

/* export: '_ZTSPKg' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKg(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKg;
}

/* export: '_ZTIPKg' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKg(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKg;
}

/* export: '_ZTSDu' */
u32* w2c_rlboxsoundtouch_0x5FZTSDu(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSDu;
}

/* export: '_ZTIDu' */
u32* w2c_rlboxsoundtouch_0x5FZTIDu(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIDu;
}

/* export: '_ZTSPDu' */
u32* w2c_rlboxsoundtouch_0x5FZTSPDu(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPDu;
}

/* export: '_ZTIPDu' */
u32* w2c_rlboxsoundtouch_0x5FZTIPDu(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPDu;
}

/* export: '_ZTSPKDu' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKDu(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKDu;
}

/* export: '_ZTIPKDu' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKDu(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKDu;
}

/* export: '_ZTSDs' */
u32* w2c_rlboxsoundtouch_0x5FZTSDs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSDs;
}

/* export: '_ZTIDs' */
u32* w2c_rlboxsoundtouch_0x5FZTIDs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIDs;
}

/* export: '_ZTSPDs' */
u32* w2c_rlboxsoundtouch_0x5FZTSPDs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPDs;
}

/* export: '_ZTIPDs' */
u32* w2c_rlboxsoundtouch_0x5FZTIPDs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPDs;
}

/* export: '_ZTSPKDs' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKDs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKDs;
}

/* export: '_ZTIPKDs' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKDs(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKDs;
}

/* export: '_ZTSDi' */
u32* w2c_rlboxsoundtouch_0x5FZTSDi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSDi;
}

/* export: '_ZTIDi' */
u32* w2c_rlboxsoundtouch_0x5FZTIDi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIDi;
}

/* export: '_ZTSPDi' */
u32* w2c_rlboxsoundtouch_0x5FZTSPDi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPDi;
}

/* export: '_ZTIPDi' */
u32* w2c_rlboxsoundtouch_0x5FZTIPDi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPDi;
}

/* export: '_ZTSPKDi' */
u32* w2c_rlboxsoundtouch_0x5FZTSPKDi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSPKDi;
}

/* export: '_ZTIPKDi' */
u32* w2c_rlboxsoundtouch_0x5FZTIPKDi(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIPKDi;
}

/* export: '_ZTVN10__cxxabiv117__array_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv117_0x5Farray_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv117_0x5Farray_type_infoE;
}

/* export: '_ZTIN10__cxxabiv117__array_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv117_0x5Farray_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv117_0x5Farray_type_infoE;
}

/* export: '_ZTSN10__cxxabiv117__array_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv117_0x5Farray_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv117_0x5Farray_type_infoE;
}

/* export: '_ZTVN10__cxxabiv120__function_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv120_0x5Ffunction_type_infoE;
}

/* export: '_ZTVN10__cxxabiv116__enum_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv116_0x5Fenum_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv116_0x5Fenum_type_infoE;
}

/* export: '_ZTIN10__cxxabiv116__enum_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv116_0x5Fenum_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv116_0x5Fenum_type_infoE;
}

/* export: '_ZTSN10__cxxabiv116__enum_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv116_0x5Fenum_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv116_0x5Fenum_type_infoE;
}

/* export: '_ZTIN10__cxxabiv120__si_class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE;
}

/* export: '_ZTSN10__cxxabiv120__si_class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoE;
}

/* export: '_ZTVN10__cxxabiv121__vmi_class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE;
}

/* export: '_ZTIN10__cxxabiv121__vmi_class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTIN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTIN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE;
}

/* export: '_ZTSN10__cxxabiv121__vmi_class_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTSN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTSN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoE;
}

/* export: '_ZTVN10__cxxabiv117__pbase_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv117_0x5Fpbase_type_infoE;
}

/* export: '_ZTVN10__cxxabiv129__pointer_to_member_type_infoE' */
u32* w2c_rlboxsoundtouch_0x5FZTVN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5FZTVN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoE;
}

/* export: '_ZN10__cxxabiv116__shim_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv116_0x5Fshim_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv123__fundamental_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv123__fundamental_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv123_0x5Ffundamental_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv117__array_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Farray_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv117__array_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Farray_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv120__function_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv120_0x5Ffunction_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv120__function_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv120_0x5Ffunction_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv116__enum_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv116_0x5Fenum_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv116__enum_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv116_0x5Fenum_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv117__class_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Fclass_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv117__class_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Fclass_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv120__si_class_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv120__si_class_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv120_0x5Fsi_class_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv121__vmi_class_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv121__vmi_class_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv121_0x5Fvmi_class_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv117__pbase_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Fpbase_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv117__pbase_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv117_0x5Fpbase_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv119__pointer_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv119_0x5Fpointer_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv119__pointer_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv119_0x5Fpointer_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv129__pointer_to_member_type_infoD2Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoD2Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZN10__cxxabiv129__pointer_to_member_type_infoD1Ev' */
u32 w2c_rlboxsoundtouch_0x5FZN10_0x5Fcxxabiv129_0x5Fpointer_to_member_type_infoD1Ev(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZnwmRKSt9nothrow_t' */
u32 w2c_rlboxsoundtouch_0x5FZnwmRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZnamRKSt9nothrow_t' */
u32 w2c_rlboxsoundtouch_0x5FZnamRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZdlPv' */
void w2c_rlboxsoundtouch_0x5FZdlPv(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x29(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'free' */
void w2c_rlboxsoundtouch_free(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_free_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdlPvRKSt9nothrow_t' */
void w2c_rlboxsoundtouch_0x5FZdlPvRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdaPvRKSt9nothrow_t' */
void w2c_rlboxsoundtouch_0x5FZdaPvRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdaPvm' */
void w2c_rlboxsoundtouch_0x5FZdaPvm(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZnwmSt11align_val_t' */
u32 w2c_rlboxsoundtouch_0x5FZnwmSt11align_val_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'aligned_alloc' */
u32 w2c_rlboxsoundtouch_aligned_alloc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_aligned_alloc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZnwmSt11align_val_tRKSt9nothrow_t' */
u32 w2c_rlboxsoundtouch_0x5FZnwmSt11align_val_tRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZnamSt11align_val_t' */
u32 w2c_rlboxsoundtouch_0x5FZnamSt11align_val_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZnamSt11align_val_tRKSt9nothrow_t' */
u32 w2c_rlboxsoundtouch_0x5FZnamSt11align_val_tRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_ZdlPvSt11align_val_t' */
void w2c_rlboxsoundtouch_0x5FZdlPvSt11align_val_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdlPvSt11align_val_tRKSt9nothrow_t' */
void w2c_rlboxsoundtouch_0x5FZdlPvSt11align_val_tRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdlPvmSt11align_val_t' */
void w2c_rlboxsoundtouch_0x5FZdlPvmSt11align_val_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdaPvSt11align_val_t' */
void w2c_rlboxsoundtouch_0x5FZdaPvSt11align_val_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdaPvSt11align_val_tRKSt9nothrow_t' */
void w2c_rlboxsoundtouch_0x5FZdaPvSt11align_val_tRKSt9nothrow_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_ZdaPvmSt11align_val_t' */
void w2c_rlboxsoundtouch_0x5FZdaPvmSt11align_val_t(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__heap_end' */
u32* w2c_rlboxsoundtouch_0x5F_heap_end(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_heap_end;
}

/* export: '__heap_base' */
u32* w2c_rlboxsoundtouch_0x5F_heap_base(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_heap_base;
}

/* export: 'errno' */
u32* w2c_rlboxsoundtouch_errno(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_errno;
}

/* export: 'sbrk' */
u32 w2c_rlboxsoundtouch_sbrk(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_sbrk_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'posix_memalign' */
u32 w2c_rlboxsoundtouch_posix_memalign(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_posix_memalign_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'malloc_usable_size' */
u32 w2c_rlboxsoundtouch_malloc_usable_size(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_malloc_usable_size_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__libc_malloc' */
u32 w2c_rlboxsoundtouch_0x5F_libc_malloc(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_malloc_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__libc_free' */
void w2c_rlboxsoundtouch_0x5F_libc_free(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_free_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__libc_calloc' */
u32 w2c_rlboxsoundtouch_0x5F_libc_calloc(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_calloc_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '_Exit' */
void w2c_rlboxsoundtouch_0x5FExit(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5FExit_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '_exit' */
void w2c_rlboxsoundtouch_0x5Fexit(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5FExit_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'writev' */
u32 w2c_rlboxsoundtouch_writev(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_writev_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__lseek' */
u64 w2c_rlboxsoundtouch_0x5F_lseek(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u64 ret = w2c_rlboxsoundtouch_0x5F_lseek_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'lseek' */
u64 w2c_rlboxsoundtouch_lseek(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u64 ret = w2c_rlboxsoundtouch_0x5F_lseek_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_args_sizes_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_args_sizes_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_args_sizes_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_args_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_args_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_args_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasilibc_fd_renumber' */
u32 w2c_rlboxsoundtouch_0x5F_wasilibc_fd_renumber(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasilibc_fd_renumber_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasilibc_populate_preopens' */
void w2c_rlboxsoundtouch_0x5F_wasilibc_populate_preopens(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_wasilibc_populate_preopens_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'close' */
u32 w2c_rlboxsoundtouch_close(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_close_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_environ_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_environ_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_environ_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_environ_sizes_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_environ_sizes_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_environ_sizes_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_clock_res_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_clock_res_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_clock_res_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_clock_time_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_clock_time_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_clock_time_get_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_advise' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_advise(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u64 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_advise_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_allocate' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_allocate(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u64 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_allocate_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_close' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_close(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_close_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_datasync' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_datasync(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_datasync_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_fdstat_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_fdstat_set_flags' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_set_flags(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_set_flags_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_fdstat_set_rights' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_set_rights(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u64 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_fdstat_set_rights_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_filestat_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_filestat_set_size' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_set_size(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_set_size_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_filestat_set_times' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_set_times(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u64 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_filestat_set_times_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_pread' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_pread(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u64 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_pread_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_prestat_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_prestat_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_prestat_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_prestat_dir_name' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_prestat_dir_name(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_prestat_dir_name_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_pwrite' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_pwrite(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u64 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_pwrite_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_read' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_read(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_read_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_readdir' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_readdir(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u64 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_readdir_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_renumber' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_renumber(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_renumber_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_seek' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_seek(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_seek_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_sync' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_sync(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_sync_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_tell' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_tell(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_tell_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_fd_write' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_fd_write(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_fd_write_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_create_directory' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_create_directory(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_create_directory_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'strlen' */
u32 w2c_rlboxsoundtouch_strlen(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_strlen_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_filestat_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_filestat_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_filestat_get_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_filestat_set_times' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_filestat_set_times(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u64 var_p3, u64 var_p4, u32 var_p5) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_filestat_set_times_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_link' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_link(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_link_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_open' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_open(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u64 var_p4, u64 var_p5, u32 var_p6, u32 var_p7) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_open_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5, var_p6, var_p7);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_readlink' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_readlink(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_readlink_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_remove_directory' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_remove_directory(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_remove_directory_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_rename' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_rename(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_rename_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_symlink' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_symlink(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_symlink_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_path_unlink_file' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_path_unlink_file(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_path_unlink_file_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_poll_oneoff' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_poll_oneoff(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_poll_oneoff_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_sched_yield' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_sched_yield(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_sched_yield_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_random_get' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_random_get(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_random_get_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_sock_accept' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_accept(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_sock_accept_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_sock_recv' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_recv(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_sock_recv_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4, var_p5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_sock_send' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_send(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_sock_send_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__wasi_sock_shutdown' */
u32 w2c_rlboxsoundtouch_0x5F_wasi_sock_shutdown(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_wasi_sock_shutdown_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__isatty' */
u32 w2c_rlboxsoundtouch_0x5F_isatty(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_isatty_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'isatty' */
u32 w2c_rlboxsoundtouch_isatty(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_isatty_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__strerror_l' */
u32 w2c_rlboxsoundtouch_0x5F_strerror_l(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_strerror_l_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'strerror' */
u32 w2c_rlboxsoundtouch_strerror(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_strerror_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'strerror_l' */
u32 w2c_rlboxsoundtouch_strerror_l(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_strerror_l_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__funcs_on_exit' */
void w2c_rlboxsoundtouch_0x5F_funcs_on_exit(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_dummy(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__stdio_exit' */
void w2c_rlboxsoundtouch_0x5F_stdio_exit(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_stdio_exit_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: 'exit' */
void w2c_rlboxsoundtouch_exit(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_exit_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__progname' */
u32* w2c_rlboxsoundtouch_0x5F_progname(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_progname;
}

/* export: '__progname_full' */
u32* w2c_rlboxsoundtouch_0x5F_progname_full(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_progname_full;
}

/* export: '__libc' */
u32* w2c_rlboxsoundtouch_0x5F_libc(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_libc;
}

/* export: '__hwcap' */
u32* w2c_rlboxsoundtouch_0x5F_hwcap(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_hwcap;
}

/* export: 'program_invocation_short_name' */
u32* w2c_rlboxsoundtouch_program_invocation_short_name(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_program_invocation_short_name;
}

/* export: 'program_invocation_name' */
u32* w2c_rlboxsoundtouch_program_invocation_name(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_program_invocation_name;
}

/* export: '__lctrans' */
u32 w2c_rlboxsoundtouch_0x5F_lctrans(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_lctrans_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__lctrans_impl' */
u32 w2c_rlboxsoundtouch_0x5F_lctrans_impl(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_dummy0x2E1(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__lctrans_cur' */
u32 w2c_rlboxsoundtouch_0x5F_lctrans_cur(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_lctrans_cur_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__cos' */
f64 w2c_rlboxsoundtouch_0x5F_cos(w2c_rlboxsoundtouch* instance, f64 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_0x5F_cos_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__math_oflow' */
f64 w2c_rlboxsoundtouch_0x5F_math_oflow(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_0x5F_math_oflow_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__math_uflow' */
f64 w2c_rlboxsoundtouch_0x5F_math_uflow(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_0x5F_math_uflow_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__math_xflow' */
f64 w2c_rlboxsoundtouch_0x5F_math_xflow(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_0x5F_math_xflow_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__rem_pio2' */
u32 w2c_rlboxsoundtouch_0x5F_rem_pio2(w2c_rlboxsoundtouch* instance, f64 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_rem_pio2_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__rem_pio2_large' */
u32 w2c_rlboxsoundtouch_0x5F_rem_pio2_large(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_rem_pio2_large_0(instance, var_p0, var_p1, var_p2, var_p3, var_p4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__sin' */
f64 w2c_rlboxsoundtouch_0x5F_sin(w2c_rlboxsoundtouch* instance, f64 var_p0, f64 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_0x5F_sin_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'scalbn' */
f64 w2c_rlboxsoundtouch_scalbn(w2c_rlboxsoundtouch* instance, f64 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_scalbn_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__exp_data' */
u32* w2c_rlboxsoundtouch_0x5F_exp_data(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_exp_data;
}

/* export: 'frexp' */
f64 w2c_rlboxsoundtouch_frexp(w2c_rlboxsoundtouch* instance, f64 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  f64 ret = w2c_rlboxsoundtouch_frexp_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'wcrtomb' */
u32 w2c_rlboxsoundtouch_wcrtomb(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_wcrtomb_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'wctomb' */
u32 w2c_rlboxsoundtouch_wctomb(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_wctomb_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__overflow' */
u32 w2c_rlboxsoundtouch_0x5F_overflow(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_overflow_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__stdio_close' */
u32 w2c_rlboxsoundtouch_0x5F_stdio_close(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_stdio_close_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__stdin_used' */
u32* w2c_rlboxsoundtouch_0x5F_stdin_used(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stdin_used;
}

/* export: '__stdout_used' */
u32* w2c_rlboxsoundtouch_0x5F_stdout_used(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stdout_used;
}

/* export: '__stderr_used' */
u32* w2c_rlboxsoundtouch_0x5F_stderr_used(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stderr_used;
}

/* export: '__stdio_exit_needed' */
void w2c_rlboxsoundtouch_0x5F_stdio_exit_needed(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_stdio_exit_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__stdio_seek' */
u64 w2c_rlboxsoundtouch_0x5F_stdio_seek(w2c_rlboxsoundtouch* instance, u32 var_p0, u64 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u64 ret = w2c_rlboxsoundtouch_0x5F_stdio_seek_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__stdio_write' */
u32 w2c_rlboxsoundtouch_0x5F_stdio_write(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_stdio_write_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__stdout_write' */
u32 w2c_rlboxsoundtouch_0x5F_stdout_write(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_stdout_write_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__towrite' */
u32 w2c_rlboxsoundtouch_0x5F_towrite(w2c_rlboxsoundtouch* instance, u32 var_p0) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_towrite_0(instance, var_p0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__towrite_needs_stdio_exit' */
void w2c_rlboxsoundtouch_0x5F_towrite_needs_stdio_exit(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_towrite_needs_stdio_exit_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__ofl_lock' */
u32 w2c_rlboxsoundtouch_0x5F_ofl_lock(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_ofl_lock_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'fputs' */
u32 w2c_rlboxsoundtouch_fputs(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_fputs_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'fputs_unlocked' */
u32 w2c_rlboxsoundtouch_fputs_unlocked(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_fputs_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__fwritex' */
u32 w2c_rlboxsoundtouch_0x5F_fwritex(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_0x5F_fwritex_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'fwrite_unlocked' */
u32 w2c_rlboxsoundtouch_fwrite_unlocked(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_fwrite_0(instance, var_p0, var_p1, var_p2, var_p3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__ofl_unlock' */
void w2c_rlboxsoundtouch_0x5F_ofl_unlock(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_ofl_unlock_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

/* export: '__stdout_FILE' */
u32* w2c_rlboxsoundtouch_0x5F_stdout_FILE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stdout_FILE;
}

/* export: 'iprintf' */
u32 w2c_rlboxsoundtouch_iprintf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_printf_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__small_printf' */
u32 w2c_rlboxsoundtouch_0x5F_small_printf(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_printf_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__stderr_FILE' */
u32* w2c_rlboxsoundtouch_0x5F_stderr_FILE(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stderr_FILE;
}

/* export: 'stdout' */
u32* w2c_rlboxsoundtouch_stdout(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_stdout;
}

/* export: 'strnlen' */
u32 w2c_rlboxsoundtouch_strnlen(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_strnlen_0(instance, var_p0, var_p1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: 'memchr' */
u32 w2c_rlboxsoundtouch_memchr(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  u32 ret = w2c_rlboxsoundtouch_memchr_0(instance, var_p0, var_p1, var_p2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
  return ret;
}

/* export: '__dso_handle' */
u32* w2c_rlboxsoundtouch_0x5F_dso_handle(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_dso_handle;
}

/* export: '__data_end' */
u32* w2c_rlboxsoundtouch_0x5F_data_end(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_data_end;
}

/* export: '__stack_low' */
u32* w2c_rlboxsoundtouch_0x5F_stack_low(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stack_low;
}

/* export: '__stack_high' */
u32* w2c_rlboxsoundtouch_0x5F_stack_high(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_stack_high;
}

/* export: '__global_base' */
u32* w2c_rlboxsoundtouch_0x5F_global_base(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_global_base;
}

/* export: '__table_base' */
u32* w2c_rlboxsoundtouch_0x5F_table_base(w2c_rlboxsoundtouch* instance) {
  return &instance->w2c_0x5F_table_base;
}

/* export: '__wasm_init_memory' */
void w2c_rlboxsoundtouch_0x5F_wasm_init_memory(w2c_rlboxsoundtouch* instance) {
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  w2c_rlboxsoundtouch_0x5F_wasm_init_memory_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

static void init_instance_import(w2c_rlboxsoundtouch* instance, struct w2c_env* w2c_env_instance, struct w2c_wasi__snapshot__preview1* w2c_wasi__snapshot__preview1_instance) {
  instance->w2c_env_instance = w2c_env_instance;
  instance->w2c_wasi__snapshot__preview1_instance = w2c_wasi__snapshot__preview1_instance;
  instance->w2c_env_0x5F_indirect_function_table = w2c_env_0x5F_indirect_function_table(w2c_env_instance);
  instance->w2c_env_memory = w2c_env_memory(w2c_env_instance);
}

const u32 wasm2c_rlboxsoundtouch_min_env_0x5F_indirect_function_table = 142;
const u32 wasm2c_rlboxsoundtouch_max_env_0x5F_indirect_function_table = 4294967295;
const u64 wasm2c_rlboxsoundtouch_min_env_memory = 5;
const u64 wasm2c_rlboxsoundtouch_max_env_memory = 65536;
const u8 wasm2c_rlboxsoundtouch_is64_env_memory = 0;

void wasm2c_rlboxsoundtouch_instantiate(w2c_rlboxsoundtouch* instance, struct w2c_env* w2c_env_instance, struct w2c_wasi__snapshot__preview1* w2c_wasi__snapshot__preview1_instance) {
  assert(wasm_rt_is_initialized());
  init_instance_import(instance, w2c_env_instance, w2c_wasi__snapshot__preview1_instance);
  init_globals(instance);
  init_tables(instance);
  init_memories(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
#if !WASM_RT_SEGUE_FREE_SEGMENT
  void* segue_saved_base = wasm_rt_segue_read_base();
#endif
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  init_elem_instances(instance);
  init_data_instances(instance);
  w2c_rlboxsoundtouch_0x5F_wasm_init_memory_0(instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && !WASM_RT_SEGUE_FREE_SEGMENT
  wasm_rt_segue_write_base(segue_saved_base);
#endif
}

void wasm2c_rlboxsoundtouch_free(w2c_rlboxsoundtouch* instance) {
}

wasm_rt_func_type_t wasm2c_rlboxsoundtouch_get_func_type(uint32_t param_count, uint32_t result_count, ...) {
  va_list args;
  
  if (param_count == 4 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t0;
    }
    va_end(args);
  }
  
  if (param_count == 1 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t1;
    }
    va_end(args);
  }
  
  if (param_count == 1 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t2;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t3;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t4;
    }
    va_end(args);
  }
  
  if (param_count == 4 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t5;
    }
    va_end(args);
  }
  
  if (param_count == 5 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t6;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t7;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t8;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t9;
    }
    va_end(args);
  }
  
  if (param_count == 4 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t10;
    }
    va_end(args);
  }
  
  if (param_count == 6 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t11;
    }
    va_end(args);
  }
  
  if (param_count == 5 && result_count == 0) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t12;
    }
    va_end(args);
  }
  
  if (param_count == 0 && result_count == 0) {
    va_start(args, result_count);
    if (true) {
      va_end(args);
      return w2c_rlboxsoundtouch_t13;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t14;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t15;
    }
    va_end(args);
  }
  
  if (param_count == 4 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t16;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t17;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t18;
    }
    va_end(args);
  }
  
  if (param_count == 5 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t19;
    }
    va_end(args);
  }
  
  if (param_count == 4 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t20;
    }
    va_end(args);
  }
  
  if (param_count == 7 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t21;
    }
    va_end(args);
  }
  
  if (param_count == 7 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t22;
    }
    va_end(args);
  }
  
  if (param_count == 9 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t23;
    }
    va_end(args);
  }
  
  if (param_count == 6 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t24;
    }
    va_end(args);
  }
  
  if (param_count == 0 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t25;
    }
    va_end(args);
  }
  
  if (param_count == 1 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t26;
    }
    va_end(args);
  }
  
  if (param_count == 6 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t27;
    }
    va_end(args);
  }
  
  if (param_count == 8 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t28;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t29;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32) {
      va_end(args);
      return w2c_rlboxsoundtouch_t30;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t31;
    }
    va_end(args);
  }
  
  if (param_count == 1 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t32;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t33;
    }
    va_end(args);
  }
  
  if (param_count == 3 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I64 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t34;
    }
    va_end(args);
  }
  
  if (param_count == 2 && result_count == 1) {
    va_start(args, result_count);
    if (true && va_arg(args, wasm_rt_type_t) == WASM_RT_F64 && va_arg(args, wasm_rt_type_t) == WASM_RT_I32 && va_arg(args, wasm_rt_type_t) == WASM_RT_F64) {
      va_end(args);
      return w2c_rlboxsoundtouch_t35;
    }
    va_end(args);
  }
  
  return NULL;
}

void w2c_rlboxsoundtouch_0x5F_wasm_call_ctors_0(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_wasm_init_memory_0(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = 274080u;
  var_i1 = 0u;
  var_i2 = 1600u;
  memory_fill(instance->w2c_env_memory, var_i0, var_i1, var_i2);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5Fstart_0(w2c_rlboxsoundtouch* instance) {
  u32 var_l0 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = instance->w2c_GOT0x2Edata0x2Einternal0x2E_0x5Fmemory_base;
  var_i1 = 274080u;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  if (var_i0) {goto var_B1;}
  var_i0 = instance->w2c_GOT0x2Edata0x2Einternal0x2E_0x5Fmemory_base;
  var_i1 = 274080u;
  var_i0 += var_i1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  w2c_rlboxsoundtouch_0x5F_wasm_call_ctors_0(instance);
  var_i0 = w2c_rlboxsoundtouch_0x5F_main_void_0(instance);
  var_l0 = var_i0;
  w2c_rlboxsoundtouch_0x5F_wasm_call_dtors_0(instance);
  var_i0 = var_l0;
  if (var_i0) {goto var_B0;}
  goto var_Bfunc;
  var_B1:;
  UNREACHABLE;
  var_B0:;
  var_i0 = var_l0;
  w2c_rlboxsoundtouch_0x5F_wasi_proc_exit_0(instance, var_i0);
  UNREACHABLE;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_main(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  w2c_rlboxsoundtouch_abort_0(instance);
  UNREACHABLE;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AAAFilter0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AnewInstance0x280x29(instance);
  var_l2 = var_i0;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p0;
  var_j1 = 4602678819172646912ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_j1);
  var_i0 = var_p0;
  var_i1 = var_l2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AcalculateCoeffs0x280x29(instance, var_i0);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AcalculateCoeffs0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0, var_l2 = 0, var_l3 = 0, var_l7 = 0, var_l8 = 0, var_l14 = 0;
  f64 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l9 = 0, var_l10 = 0, var_l11 = 0, var_l12 = 0, var_l13 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f1;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4, var_d5;
  var_i0 = 4294967295u;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_l1 = var_i1;
  var_i2 = 3u;
  var_i1 <<= (var_i2 & 31);
  var_i2 = var_l1;
  var_i3 = 536870911u;
  var_i2 = var_i2 > var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i0);
  var_l2 = var_i0;
  var_i0 = 4294967295u;
  var_i1 = var_l1;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i2 = var_l1;
  var_i3 = 1073741823u;
  var_i2 = var_i2 > var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i0);
  var_l3 = var_i0;
  var_i0 = var_l1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_d0 = 6.2831853071795862;
  var_i1 = var_l1;
  var_d1 = (f64)(var_i1);
  var_d0 /= var_d1;
  var_l4 = var_d0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_d1 = 6.2831853071795862;
  var_d0 *= var_d1;
  var_l5 = var_d0;
  var_i0 = var_l1;
  var_i1 = 1u;
  var_i0 >>= (var_i1 & 31);
  var_d0 = (f64)(var_i0);
  var_l6 = var_d0;
  var_i0 = var_l2;
  var_l7 = var_i0;
  var_i0 = var_l1;
  var_l8 = var_i0;
  var_d0 = 0.0;
  var_l9 = var_d0;
  var_d0 = 0.0;
  var_l10 = var_d0;
  var_L1: 
    var_d0 = 1.0;
    var_l11 = var_d0;
    var_d0 = var_l5;
    var_d1 = var_l9;
    var_d2 = var_l6;
    var_d1 -= var_d2;
    var_l12 = var_d1;
    var_d0 *= var_d1;
    var_l13 = var_d0;
    var_d1 = 0.0;
    var_i0 = var_d0 == var_d1;
    if (var_i0) {goto var_B2;}
    var_d0 = var_l13;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_d1 = var_l13;
    var_d0 /= var_d1;
    var_l11 = var_d0;
    var_B2:;
    var_i0 = var_l7;
    var_d1 = var_l4;
    var_d2 = var_l12;
    var_d1 *= var_d2;
    var_d1 = w2c_rlboxsoundtouch_cos_0(instance, var_d1);
    var_d2 = 0.46000000000000002;
    var_d1 *= var_d2;
    var_d2 = 0.54000000000000004;
    var_d1 += var_d2;
    var_d2 = var_l11;
    var_d1 *= var_d2;
    var_l11 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0), var_d1);
    var_i0 = var_l7;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_d0 = var_l9;
    var_d1 = 1.0;
    var_d0 += var_d1;
    var_l9 = var_d0;
    var_d0 = var_l10;
    var_d1 = var_l11;
    var_d0 += var_d1;
    var_l10 = var_d0;
    var_i0 = var_l8;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    var_l8 = var_i0;
    if (var_i0) {goto var_L1;}
  var_d0 = 16384.0;
  var_d1 = var_l10;
  var_d0 /= var_d1;
  var_l11 = var_d0;
  var_i0 = var_l2;
  var_l7 = var_i0;
  var_i0 = var_l3;
  var_l8 = var_i0;
  var_i0 = var_l1;
  var_l14 = var_i0;
  var_L3: 
    var_i0 = var_l8;
    var_d1 = var_l11;
    var_i2 = var_l7;
    var_d2 = f64_load(instance->w2c_env_memory, (u64)(var_i2));
    var_d1 *= var_d2;
    var_l9 = var_d1;
    var_d2 = 0.5;
    var_d3 = -0.5;
    var_d4 = var_l9;
    var_d5 = 0.0;
    var_i4 = var_d4 >= var_d5;
    var_d2 = var_i4 ? var_d2 : var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_l7;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_i0 = var_l8;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_l8 = var_i0;
    var_i0 = var_l14;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    var_l14 = var_i0;
    if (var_i0) {goto var_L3;}
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l7 = var_i0;
  var_i1 = var_l3;
  var_i2 = var_l1;
  var_i3 = 14u;
  var_i4 = var_l7;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l2;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_i0 = var_l3;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetLength0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AcalculateCoeffs0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3A0x7EAAFilter0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B0:;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetCutoffFreq0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AcalculateCoeffs0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_p4;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0, var_l5 = 0, var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l3 = var_i0;
  var_i0 = var_p2;
  var_i1 = var_p2;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l4 = var_i0;
  var_i0 = var_p2;
  var_i1 = var_p2;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l5 = var_i0;
  var_i0 = var_p1;
  var_i1 = var_l4;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrEnd0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_l6 = var_i0;
  var_i0 = var_p2;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i2 = var_l6;
  var_i3 = var_l5;
  var_i4 = var_l4;
  var_i5 = var_l3;
  var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_i1, var_i2, var_i3, var_i4, var_i5);
  var_l4 = var_i1;
  var_i2 = var_p2;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p1;
  var_i1 = var_l4;
  var_i2 = var_p1;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 40u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32), w2c_rlboxsoundtouch_t4, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AgetLength0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AgetLength0x280x290x20const(instance, var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  v128 var_o1;
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p0;
  var_i1 = 262152u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_o1 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  v128_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_o1);
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p0;
  var_i1 = 32u;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_l2 = var_i1;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i0 = DIV_U(var_i0, var_i1);
  var_i1 = var_p1;
  var_i0 = var_i0 >= var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_l2;
  var_i1 *= var_i2;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i2 = 4095u;
  var_i1 += var_i2;
  var_i2 = 4294963200u;
  var_i1 &= var_i2;
  var_p1 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_p1;
  var_i1 = 16u;
  var_i0 |= var_i1;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i0);
  var_l2 = var_i0;
  var_i1 = 15u;
  var_i0 += var_i1;
  var_i1 = 4294967280u;
  var_i0 &= var_i1;
  var_p1 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memcpy_0(instance, var_i0, var_i1, var_i2);
  var_B3:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l3 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B4;}
  var_i0 = var_l3;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B4:;
  var_i0 = var_p0;
  var_i1 = var_l2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_p0;
  var_i1 = 24u;
  var_i0 += var_i1;
  var_p1 = var_i0;
  goto var_B1;
  var_B2:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l2 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = 24u;
  var_i0 += var_i1;
  var_p1 = var_i0;
  var_i0 = var_l2;
  var_i1 = var_p0;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memmove_0(instance, var_i0, var_i1, var_i2);
  var_B1:;
  var_i0 = var_p1;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i1 = 262152u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B0:;
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_j1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 262152u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 28u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_i1 = 15u;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l2 = var_i0;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p0;
  var_i1 = var_l2;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_i1 *= var_i2;
  var_i2 = var_p1;
  var_i1 = DIV_U(var_i1, var_i2);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Arewind0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  var_i1 = var_p0;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memmove_0(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p2;
  var_i1 += var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_l3 = var_i1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_i1 *= var_i2;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_l3;
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memcpy_0(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p2;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrEnd0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p1;
  var_i1 += var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_i1 *= var_i2;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p1;
  var_i1 += var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p1;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  var_i1 *= var_i2;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AgetCapacity0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i0 = DIV_U(var_i0, var_i1);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l3 = var_i0;
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_l3;
  var_i3 = var_p2;
  var_i4 = var_l3;
  var_i5 = var_p2;
  var_i4 = var_i4 < var_i5;
  var_i2 = var_i4 ? var_i2 : var_i3;
  var_p2 = var_i2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memcpy_0(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = 0u;
  var_l2 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l3 = var_i0;
  var_i1 = var_p1;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_l3;
  var_p1 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i2 = var_p1;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_l3;
  var_i1 = var_p1;
  var_i0 -= var_i1;
  var_l2 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = var_l2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i0 = !(var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l2 = var_i0;
  var_i1 = var_p1;
  var_i0 = var_i0 <= var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p1;
  var_l2 = var_i0;
  var_B0:;
  var_i0 = var_l2;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AaddSilent0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p1;
  var_i1 += var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AensureCapacity0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_l2 = var_i1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_i1 *= var_i2;
  var_i2 = 2u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  var_i1 = 0u;
  var_i2 = var_p1;
  var_i3 = var_l2;
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i2 = var_p1;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AFIRFilter0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  v128 var_o1;
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_j1);
  var_i0 = var_p0;
  var_i1 = 262288u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i1 = 12u;
  var_i0 += var_i1;
  var_o1 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  v128_store(instance->w2c_env_memory, (u64)(var_i0), var_o1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 262288u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_l1;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B1:;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(instance, var_i0);
  var_i1 = 28u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l10 = 0, var_l11 = 0;
  v128 var_l9 = simde_wasm_i64x2_make(0, 0);
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  f32 var_f1;
  v128 var_o0, var_o1;
  var_i0 = var_p3;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i2 = 4294967288u;
  var_i1 &= var_i2;
  var_l4 = var_i1;
  var_i0 -= var_i1;
  var_l5 = var_i0;
  var_i1 = 1u;
  var_i0 <<= (var_i1 & 31);
  var_l6 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  var_l7 = var_i0;
  var_i0 = var_l4;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  var_l8 = var_i0;
  var_L1: 
    var_i0 = var_l8;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B3;}
    var_o0 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
    var_l9 = var_o0;
    goto var_B2;
    var_B3:;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_p3 = var_i0;
    var_o0 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
    var_l9 = var_o0;
    var_i0 = var_p2;
    var_l10 = var_i0;
    var_i0 = var_l4;
    var_l11 = var_i0;
    var_L4: 
      var_i0 = var_l10;
      var_o0 = v128_load64_zero(instance->w2c_env_memory, (u64)(var_i0));
      var_i1 = var_p3;
      var_o1 = v128_load64_zero(instance->w2c_env_memory, (u64)(var_i1));
      var_o0 = simde_wasm_f32x4_mul(var_o0, var_o1);
      var_o1 = var_l9;
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_l9 = var_o0;
      var_i0 = var_p3;
      var_i1 = 8u;
      var_i0 += var_i1;
      var_p3 = var_i0;
      var_i0 = var_l10;
      var_i1 = 8u;
      var_i0 += var_i1;
      var_l10 = var_i0;
      var_i0 = var_l11;
      var_i1 = 4294967295u;
      var_i0 += var_i1;
      var_l11 = var_i0;
      if (var_i0) {goto var_L4;}
    var_B2:;
    var_i0 = var_p1;
    var_i1 = var_l7;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p3 = var_i0;
    var_o1 = var_l9;
    var_f1 = v128_f32x4_extract_lane(var_o1, 0);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p3;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_o1 = var_l9;
    var_f1 = v128_f32x4_extract_lane(var_o1, 1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p2;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l7;
    var_i1 = 2u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_i1 = var_l6;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l9 = 0, var_l10 = 0;
  f32 var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  f32 var_f0, var_f1;
  var_i0 = var_p3;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i2 = 4294967288u;
  var_i1 &= var_i2;
  var_l4 = var_i1;
  var_i0 -= var_i1;
  var_l5 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  var_l6 = var_i0;
  var_i0 = var_l4;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  var_l7 = var_i0;
  var_L1: 
    var_i0 = var_l7;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B3;}
    var_f0 = 0;
    var_l8 = var_f0;
    goto var_B2;
    var_B3:;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
    var_p3 = var_i0;
    var_f0 = 0;
    var_l8 = var_f0;
    var_i0 = var_p2;
    var_l9 = var_i0;
    var_i0 = var_l4;
    var_l10 = var_i0;
    var_L4: 
      var_i0 = var_l9;
      var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
      var_i1 = var_p3;
      var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
      var_f0 *= var_f1;
      var_f1 = var_l8;
      var_f0 += var_f1;
      var_l8 = var_f0;
      var_i0 = var_l9;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_l9 = var_i0;
      var_i0 = var_p3;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_p3 = var_i0;
      var_i0 = var_l10;
      var_i1 = 4294967295u;
      var_i0 += var_i1;
      var_l10 = var_i0;
      if (var_i0) {goto var_L4;}
    var_B2:;
    var_i0 = var_p1;
    var_i1 = var_l6;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_f1 = var_l8;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p2;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l6;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l6 = var_i0;
    var_i1 = var_l5;
    var_i0 = var_i0 != var_i1;
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AevaluateFilterMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  u32 var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l9 = 0, var_l10 = 0, var_l11 = 0, var_l12 = 0, 
      var_l13 = 0, var_l14 = 0, var_l15 = 0, var_l17 = 0;
  f32 var_l16 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  f32 var_f0, var_f1, var_f2;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 64u;
  var_i0 -= var_i1;
  var_l5 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p3;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i2 = 4294967288u;
  var_i1 &= var_i2;
  var_l6 = var_i1;
  var_i0 -= var_i1;
  var_l7 = var_i0;
  var_i1 = var_p4;
  var_i0 *= var_i1;
  var_l8 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p4;
  var_i1 = 2u;
  var_i0 <<= (var_i1 & 31);
  var_l9 = var_i0;
  var_i0 = var_l6;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  var_l10 = var_i0;
  var_i0 = 0u;
  var_l11 = var_i0;
  var_i0 = 0u;
  var_l12 = var_i0;
  var_L1: 
    var_i0 = var_p4;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B2;}
    var_i0 = var_l5;
    var_i1 = 0u;
    var_i2 = var_l9;
    var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
    var_B2:;
    var_i0 = var_l10;
    if (var_i0) {goto var_B3;}
    var_i0 = var_p2;
    var_i1 = var_l12;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_l13 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
    var_l14 = var_i0;
    var_i0 = 0u;
    var_l15 = var_i0;
    var_L4: 
      var_i0 = var_p4;
      var_i0 = !(var_i0);
      if (var_i0) {goto var_B5;}
      var_i0 = var_l14;
      var_i1 = var_l15;
      var_i2 = 2u;
      var_i1 <<= (var_i2 & 31);
      var_i0 += var_i1;
      var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
      var_l16 = var_f0;
      var_i0 = var_l5;
      var_p3 = var_i0;
      var_i0 = var_p4;
      var_l17 = var_i0;
      var_L6: 
        var_i0 = var_p3;
        var_i1 = var_l13;
        var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
        var_f2 = var_l16;
        var_f1 *= var_f2;
        var_i2 = var_p3;
        var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
        var_f1 += var_f2;
        f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
        var_i0 = var_p3;
        var_i1 = 4u;
        var_i0 += var_i1;
        var_p3 = var_i0;
        var_i0 = var_l13;
        var_i1 = 4u;
        var_i0 += var_i1;
        var_l13 = var_i0;
        var_i0 = var_l17;
        var_i1 = 4294967295u;
        var_i0 += var_i1;
        var_l17 = var_i0;
        if (var_i0) {goto var_L6;}
      var_B5:;
      var_i0 = var_l15;
      var_i1 = 1u;
      var_i0 += var_i1;
      var_l15 = var_i0;
      var_i1 = var_l6;
      var_i0 = var_i0 != var_i1;
      if (var_i0) {goto var_L4;}
    var_B3:;
    var_i0 = var_p4;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B7;}
    var_i0 = var_p1;
    var_i1 = var_l9;
    var_i2 = var_l11;
    var_i1 *= var_i2;
    var_i0 += var_i1;
    var_i1 = var_l5;
    var_i2 = var_l9;
    var_i0 = w2c_rlboxsoundtouch_memcpy_0(instance, var_i0, var_i1, var_i2);
    var_B7:;
    var_i0 = var_l11;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l11 = var_i0;
    var_i0 = var_l12;
    var_i1 = var_p4;
    var_i0 += var_i1;
    var_l12 = var_i0;
    var_i1 = var_l8;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l5;
  var_i1 = 64u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l7;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l6 = 0, var_l7 = 0;
  f32 var_l5 = 0;
  f64 var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2;
  f64 var_d0, var_d1, var_d2;
  var_i0 = var_p0;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i2 = 3u;
  var_i1 >>= (var_i2 & 31);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i2 = 4294967288u;
  var_i1 &= var_i2;
  var_p2 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_d0 = 1.0;
  var_i1 = var_p3;
  var_d0 = w2c_rlboxsoundtouch_ldexp_0(instance, var_d0, var_i1);
  var_l4 = var_d0;
  var_i0 = var_p0;
  var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l5 = var_f0;
  var_i0 = var_p0;
  var_d1 = var_l4;
  var_f1 = (f32)wasm_quiet(var_d1);
  f32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_f1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_p3 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p3;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p2 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 4294967295u;
  var_i2 = var_p2;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i3 = var_p2;
  var_i4 = 1073741823u;
  var_i3 = var_i3 > var_i4;
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i1 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i1);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_p3 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p3;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p2 = var_i0;
  var_B1:;
  var_i0 = var_p0;
  var_i1 = 4294967295u;
  var_i2 = var_p2;
  var_i3 = 3u;
  var_i2 <<= (var_i3 & 31);
  var_i3 = var_p2;
  var_i4 = 1610612736u;
  var_i3 &= var_i4;
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i1 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i1);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p2;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B2;}
  var_d0 = 1.0;
  var_f1 = var_l5;
  var_d1 = (f64)wasm_quietf(var_f1);
  var_d0 /= var_d1;
  var_l4 = var_d0;
  var_i0 = 0u;
  var_p2 = var_i0;
  var_i0 = 4u;
  var_p3 = var_i0;
  var_i0 = 0u;
  var_l6 = var_i0;
  var_L3: 
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
    var_i1 = var_p2;
    var_i0 += var_i1;
    var_d1 = var_l4;
    var_i2 = var_p1;
    var_i3 = var_p2;
    var_i2 += var_i3;
    var_l7 = var_i2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_i1 = var_p3;
    var_i0 += var_i1;
    var_i1 = 4294967292u;
    var_i0 += var_i1;
    var_d1 = var_l4;
    var_i2 = var_l7;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_i1 = var_p3;
    var_i0 += var_i1;
    var_d1 = var_l4;
    var_i2 = var_l7;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p3;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p3 = var_i0;
    var_i0 = var_p2;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l6;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l6 = var_i0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L3;}
  var_B2:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AgetLength0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aevaluate0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  u32 var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p3;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l5 = var_i0;
  var_i0 = var_p4;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  switch (var_i0) {
    case 0: goto var_B3;
    case 1: goto var_B2;
    default: goto var_B1;
  }
  var_B3:;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_l5;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 4u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t5, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_l5;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t5, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_p4;
  var_i5 = var_l5;
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 8u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t6, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l5 = var_i0;
  var_B0:;
  var_i0 = var_l5;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3Aoperator0x20new0x28unsigned0x20long0x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AnewInstance0x280x29(instance);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AnewInstance0x280x29(w2c_rlboxsoundtouch* instance) {
  u32 var_l0 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  v128 var_o1;
  var_i0 = w2c_rlboxsoundtouch_detectCPUextensions0x280x29(instance);
  var_i1 = 8u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = 36u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AFIRFilterSSE0x280x29(instance, var_i0);
  goto var_Bfunc;
  var_B0:;
  var_i0 = 28u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_l0 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_j1);
  var_i0 = var_l0;
  var_i1 = 262288u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l0;
  var_i1 = 12u;
  var_i0 += var_i1;
  var_o1 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  v128_store(instance->w2c_env_memory, (u64)(var_i0), var_o1);
  var_i0 = var_l0;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AInterpolateCubic0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(instance, var_i0);
  var_p0 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  var_i0 = var_p0;
  var_i1 = 262356u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  u64 var_j1;
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  f32 var_l9 = 0, var_l10 = 0, var_l11 = 0, var_l12 = 0;
  f64 var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f1, var_f2, var_f3, var_f4, var_f5, var_f6, var_f7, var_f8;
  f64 var_d0, var_d1, var_d2;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 5u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967292u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l8 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_p1;
    var_d1 = var_l8;
    var_f1 = (f32)wasm_quiet(var_d1);
    var_l9 = var_f1;
    var_f2 = 0;
    var_f1 *= var_f2;
    var_l10 = var_f1;
    var_f2 = var_l9;
    var_f3 = var_l9;
    var_f2 *= var_f3;
    var_l11 = var_f2;
    var_f3 = var_l9;
    var_f2 *= var_f3;
    var_l12 = var_f2;
    var_f3 = 0.5;
    var_f2 *= var_f3;
    var_f3 = var_l11;
    var_f4 = -0.5;
    var_f3 *= var_f4;
    var_f2 += var_f3;
    var_f1 += var_f2;
    var_f2 = 0;
    var_f1 += var_f2;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 12u);
    var_f1 *= var_f2;
    var_f2 = var_l9;
    var_f3 = 0.5;
    var_f2 *= var_f3;
    var_f3 = var_l12;
    var_f4 = -1.5;
    var_f3 *= var_f4;
    var_f4 = var_l11;
    var_f5 = var_l11;
    var_f4 += var_f5;
    var_f3 += var_f4;
    var_f2 += var_f3;
    var_f3 = 0;
    var_f2 += var_f3;
    var_i3 = var_p2;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3) + 8u);
    var_f2 *= var_f3;
    var_f3 = var_l9;
    var_f4 = -0.5;
    var_f3 *= var_f4;
    var_f4 = var_l12;
    var_f5 = -0.5;
    var_f4 *= var_f5;
    var_f5 = var_l11;
    var_f4 += var_f5;
    var_f3 += var_f4;
    var_f4 = 0;
    var_f3 += var_f4;
    var_i4 = var_p2;
    var_f4 = f32_load(instance->w2c_env_memory, (u64)(var_i4));
    var_f3 *= var_f4;
    var_i4 = var_p2;
    var_f4 = f32_load(instance->w2c_env_memory, (u64)(var_i4) + 4u);
    var_f5 = var_l10;
    var_f6 = var_l12;
    var_f7 = 1.5;
    var_f6 *= var_f7;
    var_f7 = var_l11;
    var_f8 = -2.5;
    var_f7 *= var_f8;
    var_f6 += var_f7;
    var_f5 += var_f6;
    var_f6 = 1;
    var_f5 += var_f6;
    var_f4 *= var_f5;
    var_f3 += var_f4;
    var_f2 += var_f3;
    var_f1 += var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_d0 += var_d1;
    var_l8 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B3;}
    var_d0 = var_l8;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B2;
    var_B3:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B2:;
    var_i0 = var_p0;
    var_d1 = var_l8;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l8 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  f32 var_l9 = 0, var_l10 = 0, var_l11 = 0, var_l12 = 0, var_l13 = 0, var_l14 = 0, var_l15 = 0, var_l16 = 0, 
      var_l17 = 0, var_l18 = 0;
  f64 var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  f32 var_f0, var_f1, var_f2, var_f3, var_f4, var_f5, var_f6, var_f7;
  f64 var_d0, var_d1, var_d2;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 5u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967292u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l8 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_l9 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
    var_l10 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l11 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_l12 = var_f0;
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_d1 = var_l8;
    var_f1 = (f32)wasm_quiet(var_d1);
    var_l13 = var_f1;
    var_f2 = 0;
    var_f1 *= var_f2;
    var_l14 = var_f1;
    var_f2 = var_l13;
    var_f3 = var_l13;
    var_f2 *= var_f3;
    var_l15 = var_f2;
    var_f3 = var_l13;
    var_f2 *= var_f3;
    var_l16 = var_f2;
    var_f3 = 0.5;
    var_f2 *= var_f3;
    var_f3 = var_l15;
    var_f4 = -0.5;
    var_f3 *= var_f4;
    var_f2 += var_f3;
    var_f1 += var_f2;
    var_f2 = 0;
    var_f1 += var_f2;
    var_l17 = var_f1;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 28u);
    var_f1 *= var_f2;
    var_f2 = var_l13;
    var_f3 = 0.5;
    var_f2 *= var_f3;
    var_f3 = var_l16;
    var_f4 = -1.5;
    var_f3 *= var_f4;
    var_f4 = var_l15;
    var_f5 = var_l15;
    var_f4 += var_f5;
    var_f3 += var_f4;
    var_f2 += var_f3;
    var_f3 = 0;
    var_f2 += var_f3;
    var_l18 = var_f2;
    var_i3 = var_p2;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
    var_f2 *= var_f3;
    var_f3 = var_l13;
    var_f4 = -0.5;
    var_f3 *= var_f4;
    var_f4 = var_l16;
    var_f5 = -0.5;
    var_f4 *= var_f5;
    var_f5 = var_l15;
    var_f4 += var_f5;
    var_f3 += var_f4;
    var_f4 = 0;
    var_f3 += var_f4;
    var_l13 = var_f3;
    var_i4 = var_p2;
    var_f4 = f32_load(instance->w2c_env_memory, (u64)(var_i4) + 4u);
    var_f3 *= var_f4;
    var_f4 = var_l14;
    var_f5 = var_l16;
    var_f6 = 1.5;
    var_f5 *= var_f6;
    var_f6 = var_l15;
    var_f7 = -2.5;
    var_f6 *= var_f7;
    var_f5 += var_f6;
    var_f4 += var_f5;
    var_f5 = 1;
    var_f4 += var_f5;
    var_l15 = var_f4;
    var_i5 = var_p2;
    var_f5 = f32_load(instance->w2c_env_memory, (u64)(var_i5) + 12u);
    var_f4 *= var_f5;
    var_f3 += var_f4;
    var_f2 += var_f3;
    var_f1 += var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p1;
    var_f1 = var_l17;
    var_f2 = var_l9;
    var_f1 *= var_f2;
    var_f2 = var_l18;
    var_f3 = var_l10;
    var_f2 *= var_f3;
    var_f3 = var_l13;
    var_f4 = var_l11;
    var_f3 *= var_f4;
    var_f4 = var_l12;
    var_f5 = var_l15;
    var_f4 *= var_f5;
    var_f3 += var_f4;
    var_f2 += var_f3;
    var_f1 += var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_d0 += var_d1;
    var_l8 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B3;}
    var_d0 = var_l8;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B2;
    var_B3:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B2:;
    var_i0 = var_p0;
    var_d1 = var_l8;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l8 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_p1;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 3u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l16 = 0;
  f32 var_l10 = 0, var_l11 = 0, var_l12 = 0, var_l13 = 0, var_l14 = 0, var_l15 = 0;
  f64 var_l9 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6, var_i7;
  f32 var_f0, var_f1, var_f2, var_f3, var_f4, var_f5;
  f64 var_d0, var_d1, var_d2;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 5u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967292u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l8 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l9 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_l8;
    var_i1 = 1u;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_B2;}
    var_d0 = var_l9;
    var_f0 = (f32)wasm_quiet(var_d0);
    var_l10 = var_f0;
    var_f1 = 0;
    var_f0 *= var_f1;
    var_l11 = var_f0;
    var_f1 = var_l10;
    var_f2 = var_l10;
    var_f1 *= var_f2;
    var_l12 = var_f1;
    var_f2 = var_l10;
    var_f1 *= var_f2;
    var_l13 = var_f1;
    var_f2 = 0.5;
    var_f1 *= var_f2;
    var_f2 = var_l12;
    var_f3 = -0.5;
    var_f2 *= var_f3;
    var_f1 += var_f2;
    var_f0 += var_f1;
    var_f1 = 0;
    var_f0 += var_f1;
    var_l14 = var_f0;
    var_f0 = var_l10;
    var_f1 = 0.5;
    var_f0 *= var_f1;
    var_f1 = var_l13;
    var_f2 = -1.5;
    var_f1 *= var_f2;
    var_f2 = var_l12;
    var_f3 = var_l12;
    var_f2 += var_f3;
    var_f1 += var_f2;
    var_f0 += var_f1;
    var_f1 = 0;
    var_f0 += var_f1;
    var_l15 = var_f0;
    var_f0 = var_l11;
    var_f1 = var_l13;
    var_f2 = 1.5;
    var_f1 *= var_f2;
    var_f2 = var_l12;
    var_f3 = -2.5;
    var_f2 *= var_f3;
    var_f1 += var_f2;
    var_f0 += var_f1;
    var_f1 = 1;
    var_f0 += var_f1;
    var_l11 = var_f0;
    var_f0 = var_l10;
    var_f1 = -0.5;
    var_f0 *= var_f1;
    var_f1 = var_l13;
    var_f2 = -0.5;
    var_f1 *= var_f2;
    var_f2 = var_l12;
    var_f1 += var_f2;
    var_f0 += var_f1;
    var_f1 = 0;
    var_f0 += var_f1;
    var_l10 = var_f0;
    var_i0 = 0u;
    var_l16 = var_i0;
    var_i0 = var_p2;
    var_l6 = var_i0;
    var_L3: 
      var_i0 = var_p1;
      var_f1 = var_l14;
      var_i2 = var_l6;
      var_i3 = var_l8;
      var_i4 = 12u;
      var_i3 *= var_i4;
      var_i2 += var_i3;
      var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
      var_f1 *= var_f2;
      var_f2 = var_l15;
      var_i3 = var_l6;
      var_i4 = var_l8;
      var_i5 = 3u;
      var_i4 <<= (var_i5 & 31);
      var_i3 += var_i4;
      var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3));
      var_f2 *= var_f3;
      var_f3 = var_l10;
      var_i4 = var_l6;
      var_f4 = f32_load(instance->w2c_env_memory, (u64)(var_i4));
      var_f3 *= var_f4;
      var_f4 = var_l11;
      var_i5 = var_p2;
      var_i6 = var_l8;
      var_i7 = var_l16;
      var_i6 += var_i7;
      var_i7 = 2u;
      var_i6 <<= (var_i7 & 31);
      var_i5 += var_i6;
      var_f5 = f32_load(instance->w2c_env_memory, (u64)(var_i5));
      var_f4 *= var_f5;
      var_f3 += var_f4;
      var_f2 += var_f3;
      var_f1 += var_f2;
      f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
      var_i0 = var_l6;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_l6 = var_i0;
      var_i0 = var_p1;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_p1 = var_i0;
      var_i0 = var_l16;
      var_i1 = 1u;
      var_i0 += var_i1;
      var_l16 = var_i0;
      var_i1 = var_p0;
      var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
      var_l8 = var_i1;
      var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
      if (var_i0) {goto var_L3;}
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_l9 = var_d0;
    var_B2:;
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_d1 = var_l9;
    var_d0 += var_d1;
    var_l9 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B5;}
    var_d0 = var_l9;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B4;
    var_B5:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B4:;
    var_i0 = var_p0;
    var_d1 = var_l9;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l9 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l8;
    var_i2 = var_l6;
    var_i1 *= var_i2;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3A0x7EInterpolateCubic0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_i0);
  var_i1 = 32u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 1u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AInterpolateLinearInteger0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  f64 var_d1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(instance, var_i0);
  var_p0 = var_i0;
  var_j1 = 281474976710656ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_j1);
  var_i0 = var_p0;
  var_i1 = 262452u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_d1 = 1.0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(instance, var_i0, var_d1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f1, var_f2, var_f3;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l6 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_p1;
    var_i1 = 65536u;
    var_i2 = var_l6;
    var_i1 -= var_i2;
    var_f1 = (f32)(s32)(var_i1);
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_f1 *= var_f2;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 4u);
    var_i3 = var_l6;
    var_f3 = (f32)(s32)(var_i3);
    var_f2 *= var_f3;
    var_f1 += var_f2;
    var_f2 = 1.52587891e-05;
    var_f1 *= var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
    var_i1 += var_i2;
    var_l6 = var_i1;
    var_i2 = var_l6;
    var_i3 = 65536u;
    var_i2 = I32_DIV_S(var_i2, var_i3);
    var_l8 = var_i2;
    var_i3 = 16u;
    var_i2 <<= (var_i3 & 31);
    var_i1 -= var_i2;
    var_l6 = var_i1;
    i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l8;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l8;
    var_i1 = var_l4;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l12 = 0;
  f32 var_l8 = 0, var_l9 = 0, var_l10 = 0, var_l11 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f0, var_f1, var_f2, var_f3;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l6 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l8 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_l9 = var_f0;
    var_i0 = var_p1;
    var_i1 = 65536u;
    var_i2 = var_l6;
    var_i1 -= var_i2;
    var_f1 = (f32)(s32)(var_i1);
    var_l10 = var_f1;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 4u);
    var_f1 *= var_f2;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 12u);
    var_i3 = var_l6;
    var_f3 = (f32)(s32)(var_i3);
    var_l11 = var_f3;
    var_f2 *= var_f3;
    var_f1 += var_f2;
    var_f2 = 1.52587891e-05;
    var_f1 *= var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_f1);
    var_i0 = var_p1;
    var_f1 = var_l10;
    var_f2 = var_l8;
    var_f1 *= var_f2;
    var_f2 = var_l9;
    var_f3 = var_l11;
    var_f2 *= var_f3;
    var_f1 += var_f2;
    var_f2 = 1.52587891e-05;
    var_f1 *= var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
    var_i1 += var_i2;
    var_l6 = var_i1;
    var_i2 = var_l6;
    var_i3 = 65536u;
    var_i2 = I32_DIV_S(var_i2, var_i3);
    var_l12 = var_i2;
    var_i3 = 16u;
    var_i2 <<= (var_i3 & 31);
    var_i1 -= var_i2;
    var_l6 = var_i1;
    i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
    var_i0 = var_p1;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l12;
    var_i2 = 3u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l12;
    var_i1 = var_l4;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l10 = 0;
  f32 var_l9 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2, var_f3;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l8 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l6 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_l8;
    var_i1 = 1u;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_B2;}
    var_i0 = 65536u;
    var_i1 = var_l6;
    var_i0 -= var_i1;
    var_f0 = (f32)(s32)(var_i0);
    var_l9 = var_f0;
    var_i0 = 0u;
    var_l6 = var_i0;
    var_i0 = var_p2;
    var_l10 = var_i0;
    var_L3: 
      var_i0 = var_p1;
      var_f1 = var_l9;
      var_i2 = var_l10;
      var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
      var_f1 *= var_f2;
      var_i2 = var_p2;
      var_i3 = var_l8;
      var_i4 = var_l6;
      var_i3 += var_i4;
      var_i4 = 2u;
      var_i3 <<= (var_i4 & 31);
      var_i2 += var_i3;
      var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
      var_i3 = var_p0;
      var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
      var_f3 = (f32)(s32)(var_i3);
      var_f2 *= var_f3;
      var_f1 += var_f2;
      var_f2 = 1.52587891e-05;
      var_f1 *= var_f2;
      f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
      var_i0 = var_l10;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_l10 = var_i0;
      var_i0 = var_p1;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_p1 = var_i0;
      var_i0 = var_l6;
      var_i1 = 1u;
      var_i0 += var_i1;
      var_l6 = var_i0;
      var_i1 = var_p0;
      var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
      var_l8 = var_i1;
      var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
      if (var_i0) {goto var_L3;}
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
    var_l6 = var_i0;
    var_B2:;
    var_i0 = var_p0;
    var_i1 = var_l6;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
    var_i1 += var_i2;
    var_l6 = var_i1;
    var_i2 = var_l6;
    var_i3 = 65536u;
    var_i2 = I32_DIV_S(var_i2, var_i3);
    var_l10 = var_i2;
    var_i3 = 16u;
    var_i2 <<= (var_i3 & 31);
    var_i1 -= var_i2;
    var_l6 = var_i1;
    i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l10;
    var_i2 = var_l8;
    var_i1 *= var_i2;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l10;
    var_i1 = var_l4;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  u32 var_l3 = 0;
  f64 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  f64 var_d0, var_d1;
  var_d0 = var_p1;
  var_d1 = 65536.0;
  var_d0 *= var_d1;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l2 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_l2;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l3 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = 2147483648u;
  var_l3 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = var_l3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p0;
  var_d1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(instance, var_i0, var_d1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AInterpolateLinearFloat0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  f64 var_d1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(instance, var_i0);
  var_p0 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  var_i0 = var_p0;
  var_i1 = 262500u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_d1 = 1.0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(instance, var_i0, var_d1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  u64 var_j1;
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  f64 var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f1, var_f2, var_f3;
  f64 var_d0, var_d1, var_d2, var_d3;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l8 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_p1;
    var_d1 = 1.0;
    var_d2 = var_l8;
    var_d1 -= var_d2;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_d2 = var_l8;
    var_i3 = var_p2;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3) + 4u);
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_d0 += var_d1;
    var_l8 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B3;}
    var_d0 = var_l8;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B2;
    var_B3:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B2:;
    var_i0 = var_p0;
    var_d1 = var_l8;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l8 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  f32 var_l9 = 0, var_l10 = 0;
  f64 var_l8 = 0, var_l11 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f0, var_f1, var_f2, var_f3;
  f64 var_d0, var_d1, var_d2, var_d3;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l8 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l9 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_l10 = var_f0;
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_d1 = 1.0;
    var_d2 = var_l8;
    var_d1 -= var_d2;
    var_l11 = var_d1;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 4u);
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_d2 = var_l8;
    var_i3 = var_p2;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p1;
    var_d1 = var_l11;
    var_f2 = var_l9;
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_d2 = var_l8;
    var_f3 = var_l10;
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_d0 += var_d1;
    var_l8 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B3;}
    var_d0 = var_l8;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B2;
    var_B3:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B2:;
    var_i0 = var_p0;
    var_d1 = var_l8;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l8 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_p1;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 3u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l12 = 0;
  f32 var_l10 = 0, var_l11 = 0;
  f64 var_l9 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2, var_f3;
  f64 var_d0, var_d1, var_d2;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l8 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l9 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_i0 = var_l8;
    var_i1 = 1u;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_B2;}
    var_d0 = 1.0;
    var_d1 = var_l9;
    var_d0 -= var_d1;
    var_f0 = (f32)wasm_quiet(var_d0);
    var_l10 = var_f0;
    var_d0 = var_l9;
    var_f0 = (f32)wasm_quiet(var_d0);
    var_l11 = var_f0;
    var_i0 = 0u;
    var_l6 = var_i0;
    var_i0 = var_p2;
    var_l12 = var_i0;
    var_L3: 
      var_i0 = var_p1;
      var_f1 = var_l10;
      var_i2 = var_l12;
      var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
      var_f1 *= var_f2;
      var_i2 = var_p2;
      var_i3 = var_l8;
      var_i4 = var_l6;
      var_i3 += var_i4;
      var_i4 = 2u;
      var_i3 <<= (var_i4 & 31);
      var_i2 += var_i3;
      var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
      var_f3 = var_l11;
      var_f2 *= var_f3;
      var_f1 += var_f2;
      f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
      var_i0 = var_l12;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_l12 = var_i0;
      var_i0 = var_p1;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_p1 = var_i0;
      var_i0 = var_l6;
      var_i1 = 1u;
      var_i0 += var_i1;
      var_l6 = var_i0;
      var_i1 = var_p0;
      var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
      var_l8 = var_i1;
      var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
      if (var_i0) {goto var_L3;}
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_l9 = var_d0;
    var_B2:;
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_d1 = var_l9;
    var_d0 += var_d1;
    var_l9 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B5;}
    var_d0 = var_l9;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B4;
    var_B5:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B4:;
    var_i0 = var_p0;
    var_d1 = var_l9;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l9 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l8;
    var_i2 = var_l6;
    var_i1 *= var_i2;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3A0x7EInterpolateLinearInteger0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_i0);
  var_i1 = 32u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearInteger0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3A0x7EInterpolateLinearFloat0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_i0);
  var_i1 = 32u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AInterpolateShannon0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(instance, var_i0);
  var_p0 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  var_i0 = var_p0;
  var_i1 = 262656u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AresetRegisters0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  u64 var_j1;
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMono0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  f32 var_l11 = 0, var_l14 = 0, var_l19 = 0;
  f64 var_l8 = 0, var_l9 = 0, var_l10 = 0, var_l12 = 0, var_l13 = 0, var_l15 = 0, var_l16 = 0, var_l17 = 0, 
      var_l18 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  f32 var_f0, var_f1, var_f2, var_f3, var_f4, var_f5;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4, var_d5, var_d6;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 9u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967288u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l8 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_d0 = -3.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l9 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l10 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l11 = var_f0;
    var_d0 = -2.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l12 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l13 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_l14 = var_f0;
    var_d0 = -1.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l15 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_d1 = var_l15;
    var_d0 /= var_d1;
    var_i1 = var_p2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
    var_d1 = (f64)wasm_quietf(var_f1);
    var_d0 *= var_d1;
    var_d1 = 0.83508562409943998;
    var_d0 *= var_d1;
    var_d1 = var_l13;
    var_d2 = var_l12;
    var_d1 /= var_d2;
    var_f2 = var_l14;
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_d2 = 0.64888025049173004;
    var_d1 *= var_d2;
    var_d2 = var_l10;
    var_d3 = var_l9;
    var_d2 /= var_d3;
    var_f3 = var_l11;
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d3 = 0.41778693317813997;
    var_d2 *= var_d3;
    var_d1 += var_d2;
    var_d0 += var_d1;
    var_l10 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
    var_d0 = (f64)wasm_quietf(var_f0);
    var_l9 = var_d0;
    var_d0 = var_l8;
    var_d1 = 9.9999999999999995e-07;
    var_i0 = var_d0 < var_d1;
    if (var_i0) {goto var_B2;}
    var_d0 = var_l8;
    var_d1 = -3.1415926536000001;
    var_d0 *= var_d1;
    var_l12 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_d1 = var_l12;
    var_d0 /= var_d1;
    var_d1 = var_l9;
    var_d0 *= var_d1;
    var_l9 = var_d0;
    var_B2:;
    var_d0 = 2.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l12 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l13 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
    var_l11 = var_f0;
    var_d0 = 1.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l15 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l16 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
    var_l14 = var_f0;
    var_d0 = 3.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l17 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l18 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_l19 = var_f0;
    var_i0 = var_p1;
    var_d1 = 4.0;
    var_d2 = var_l8;
    var_d1 -= var_d2;
    var_d2 = 3.1415926536000001;
    var_d1 *= var_d2;
    var_l8 = var_d1;
    var_d1 = w2c_rlboxsoundtouch_sin_0(instance, var_d1);
    var_d2 = var_l8;
    var_d1 /= var_d2;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2) + 28u);
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 *= var_d2;
    var_d2 = 0.41778693317813997;
    var_d1 *= var_d2;
    var_d2 = var_l18;
    var_d3 = var_l17;
    var_d2 /= var_d3;
    var_f3 = var_l19;
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d3 = 0.64888025049173004;
    var_d2 *= var_d3;
    var_d3 = var_l13;
    var_d4 = var_l12;
    var_d3 /= var_d4;
    var_f4 = var_l11;
    var_d4 = (f64)wasm_quietf(var_f4);
    var_d3 *= var_d4;
    var_d4 = 0.83508562409943998;
    var_d3 *= var_d4;
    var_d4 = var_l16;
    var_d5 = var_l15;
    var_d4 /= var_d5;
    var_f5 = var_l14;
    var_d5 = (f64)wasm_quietf(var_f5);
    var_d4 *= var_d5;
    var_d5 = 0.93887857733411995;
    var_d4 *= var_d5;
    var_d5 = var_l9;
    var_d6 = 0.93887857733411995;
    var_d5 *= var_d6;
    var_d6 = var_l10;
    var_d5 += var_d6;
    var_d4 += var_d5;
    var_d3 += var_d4;
    var_d2 += var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_d0 += var_d1;
    var_l8 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B4;}
    var_d0 = var_l8;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B3;
    var_B4:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B3:;
    var_i0 = var_p0;
    var_d1 = var_l8;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l8 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l4;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l5;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l5;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  f32 var_l11 = 0, var_l14 = 0, var_l18 = 0, var_l21 = 0, var_l23 = 0, var_l24 = 0, var_l25 = 0, var_l26 = 0, 
      var_l27 = 0;
  f64 var_l8 = 0, var_l9 = 0, var_l10 = 0, var_l12 = 0, var_l13 = 0, var_l15 = 0, var_l16 = 0, var_l17 = 0, 
      var_l19 = 0, var_l20 = 0, var_l22 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f0, var_f1, var_f2, var_f3, var_f4, var_f5;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4, var_d5, var_d6, var_d7;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_i1 = 9u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l6;
  var_i1 = 4294967288u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l8 = var_d0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_L1: 
    var_d0 = -3.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l9 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l10 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_l11 = var_f0;
    var_d0 = -2.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l12 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l13 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
    var_l14 = var_f0;
    var_d0 = -1.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l15 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l16 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
    var_d0 = (f64)wasm_quietf(var_f0);
    var_d1 = var_l16;
    var_d2 = var_l15;
    var_d1 /= var_d2;
    var_d2 = 0.83508562409943998;
    var_d1 *= var_d2;
    var_l15 = var_d1;
    var_d0 *= var_d1;
    var_f1 = var_l14;
    var_d1 = (f64)wasm_quietf(var_f1);
    var_d2 = var_l13;
    var_d3 = var_l12;
    var_d2 /= var_d3;
    var_d3 = 0.64888025049173004;
    var_d2 *= var_d3;
    var_l12 = var_d2;
    var_d1 *= var_d2;
    var_d2 = var_l10;
    var_d3 = var_l9;
    var_d2 /= var_d3;
    var_d3 = 0.41778693317813997;
    var_d2 *= var_d3;
    var_l9 = var_d2;
    var_f3 = var_l11;
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d1 += var_d2;
    var_d0 += var_d1;
    var_l10 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
    var_d0 = (f64)wasm_quietf(var_f0);
    var_d1 = var_l15;
    var_d0 *= var_d1;
    var_i1 = var_p2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
    var_d1 = (f64)wasm_quietf(var_f1);
    var_d2 = var_l12;
    var_d1 *= var_d2;
    var_d2 = var_l9;
    var_i3 = var_p2;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3));
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d2 *= var_d3;
    var_d1 += var_d2;
    var_d0 += var_d1;
    var_l12 = var_d0;
    var_d0 = 1.0;
    var_l9 = var_d0;
    var_d0 = var_l8;
    var_d1 = 1.0000000000000001e-05;
    var_i0 = var_d0 < var_d1;
    if (var_i0) {goto var_B2;}
    var_d0 = var_l8;
    var_d1 = -3.1415926536000001;
    var_d0 *= var_d1;
    var_l9 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_d1 = var_l9;
    var_d0 /= var_d1;
    var_l9 = var_d0;
    var_B2:;
    var_d0 = 2.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l13 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l15 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 44u);
    var_l11 = var_f0;
    var_d0 = 1.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l16 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l17 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
    var_l14 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
    var_l18 = var_f0;
    var_d0 = 3.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l19 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l20 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 52u);
    var_l21 = var_f0;
    var_d0 = 4.0;
    var_d1 = var_l8;
    var_d0 -= var_d1;
    var_d1 = 3.1415926536000001;
    var_d0 *= var_d1;
    var_l8 = var_d0;
    var_d0 = w2c_rlboxsoundtouch_sin_0(instance, var_d0);
    var_l22 = var_d0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 56u);
    var_l23 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
    var_l24 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_l25 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 32u);
    var_l26 = var_f0;
    var_i0 = var_p2;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 40u);
    var_l27 = var_f0;
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_i1 = var_p2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1) + 60u);
    var_d1 = (f64)wasm_quietf(var_f1);
    var_d2 = var_l22;
    var_d3 = var_l8;
    var_d2 /= var_d3;
    var_d3 = 0.41778693317813997;
    var_d2 *= var_d3;
    var_l8 = var_d2;
    var_d1 *= var_d2;
    var_f2 = var_l21;
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d3 = var_l20;
    var_d4 = var_l19;
    var_d3 /= var_d4;
    var_d4 = 0.64888025049173004;
    var_d3 *= var_d4;
    var_l19 = var_d3;
    var_d2 *= var_d3;
    var_f3 = var_l11;
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d4 = var_l15;
    var_d5 = var_l13;
    var_d4 /= var_d5;
    var_d5 = 0.83508562409943998;
    var_d4 *= var_d5;
    var_l13 = var_d4;
    var_d3 *= var_d4;
    var_f4 = var_l14;
    var_d4 = (f64)wasm_quietf(var_f4);
    var_d5 = var_l17;
    var_d6 = var_l16;
    var_d5 /= var_d6;
    var_d6 = 0.93887857733411995;
    var_d5 *= var_d6;
    var_l15 = var_d5;
    var_d4 *= var_d5;
    var_f5 = var_l18;
    var_d5 = (f64)wasm_quietf(var_f5);
    var_d6 = var_l9;
    var_d7 = 0.93887857733411995;
    var_d6 *= var_d7;
    var_l9 = var_d6;
    var_d5 *= var_d6;
    var_d6 = var_l10;
    var_d5 += var_d6;
    var_d4 += var_d5;
    var_d3 += var_d4;
    var_d2 += var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p1;
    var_f1 = var_l23;
    var_d1 = (f64)wasm_quietf(var_f1);
    var_d2 = var_l8;
    var_d1 *= var_d2;
    var_f2 = var_l24;
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d3 = var_l19;
    var_d2 *= var_d3;
    var_f3 = var_l27;
    var_d3 = (f64)wasm_quietf(var_f3);
    var_d4 = var_l13;
    var_d3 *= var_d4;
    var_f4 = var_l26;
    var_d4 = (f64)wasm_quietf(var_f4);
    var_d5 = var_l15;
    var_d4 *= var_d5;
    var_f5 = var_l25;
    var_d5 = (f64)wasm_quietf(var_f5);
    var_d6 = var_l9;
    var_d5 *= var_d6;
    var_d6 = var_l12;
    var_d5 += var_d6;
    var_d4 += var_d5;
    var_d3 += var_d4;
    var_d2 += var_d3;
    var_d1 += var_d2;
    var_f1 = (f32)wasm_quiet(var_d1);
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_d0 += var_d1;
    var_l8 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B4;}
    var_d0 = var_l8;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l6 = var_i0;
    goto var_B3;
    var_B4:;
    var_i0 = 2147483648u;
    var_l6 = var_i0;
    var_B3:;
    var_i0 = var_p0;
    var_d1 = var_l8;
    var_i2 = var_l6;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l8 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
    var_i0 = var_p1;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_l4;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 3u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l5;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p3;
  var_i1 = var_l5;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AtransposeMulti0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20int0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3A0x7EInterpolateShannon0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(instance, var_i0);
  var_i1 = 32u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 3u;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_SetSampleRate_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSampleRate0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_SetChannels_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetChannels0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_SetPitch_0(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitch0x28double0x29(instance, var_i0, var_d1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_SetSetting_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSetting0x28int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_SetTempo_0(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempo0x28double0x29(instance, var_i0, var_d1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_SetRate_0(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRate0x28double0x29(instance, var_i0, var_d1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_NumChannels_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 60u);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_NumSamples_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_NumUnprocessedSamples_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_PutSamples_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_ReceiveSamples_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t8, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_Flush_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aflush0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3ARateTransposer0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = 262752u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i2 = 72u;
  var_i1 += var_i2;
  var_l1 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_i1 = 2u;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 44u;
  var_i0 += var_i1;
  var_i1 = 2u;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_l1;
  var_i1 = 2u;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 100, var_i1);
  var_i0 = var_p0;
  var_i1 = 24u;
  var_i1 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i1);
  var_i2 = 64u;
  var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AAAFilter0x28unsigned0x20int0x29(instance, var_i1, var_i2);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_p0;
  var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AnewInstance0x280x29(instance);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AnewInstance0x280x29(w2c_rlboxsoundtouch* instance) {
  u32 var_l0 = 0;
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  var_l0 = var_i0;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273824u);
  switch (var_i0) {
    case 0: goto var_B3;
    case 1: goto var_B2;
    case 2: goto var_B1;
    default: goto var_B0;
  }
  var_B3:;
  var_i0 = 32u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateLinearFloat0x3A0x3AInterpolateLinearFloat0x280x29(instance, var_i0);
  goto var_Bfunc;
  var_B2:;
  var_i0 = 32u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateCubic0x3A0x3AInterpolateCubic0x280x29(instance, var_i0);
  goto var_Bfunc;
  var_B1:;
  var_i0 = 32u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AInterpolateShannon0x3A0x3AInterpolateShannon0x280x29(instance, var_i0);
  var_l0 = var_i0;
  var_B0:;
  var_i0 = var_l0;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 262752u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3A0x7EAAFilter0x280x29(instance, var_i0);
  var_i1 = 24u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_l1;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B1:;
  var_i0 = var_p0;
  var_i1 = 72u;
  var_i0 += var_i1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 44u;
  var_i0 += var_i1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_i0);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3A0x7ERateTransposer0x280x29(instance, var_i0);
  var_i1 = 104u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AenableAAFilter0x28bool0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 100, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisAAFilterEnabled0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 100u);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetAAFilter0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i2;
  f64 var_d0, var_d1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l2 = var_i0;
  var_d1 = var_p1;
  var_i2 = var_l2;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, f64), w2c_rlboxsoundtouch_t9, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_d1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_d0 = var_p1;
  var_d1 = 1.0;
  var_i0 = var_d0 > var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = 0.5;
  var_d1 = var_p1;
  var_d0 /= var_d1;
  var_p1 = var_d0;
  goto var_B0;
  var_B1:;
  var_d0 = var_p1;
  var_d1 = 0.5;
  var_d0 *= var_d1;
  var_p1 = var_d0;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_d1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetCutoffFreq0x28double0x29(instance, var_i0, var_d1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AprocessSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_i0, var_i1, var_i2);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AprocessSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f64 var_d0, var_d1;
  var_i0 = var_p2;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l3 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_p2 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 100u);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p2;
  var_i1 = var_p0;
  var_i2 = 72u;
  var_i1 += var_i2;
  var_i2 = var_l3;
  var_i3 = var_p2;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t8, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p2;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_d1 = 1.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B2;}
  var_i0 = var_p2;
  var_i1 = var_p0;
  var_i2 = 44u;
  var_i1 += var_i2;
  var_p1 = var_i1;
  var_i2 = var_l3;
  var_i3 = var_p2;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t8, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = var_p0;
  var_i2 = 72u;
  var_i1 += var_i2;
  var_i2 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x290x20const(instance, var_i0, var_i1, var_i2);
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = var_p0;
  var_i2 = 44u;
  var_i1 += var_i2;
  var_p2 = var_i1;
  var_i2 = var_l3;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3Aevaluate0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x290x20const(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_p1 = var_i0;
  var_i1 = var_p0;
  var_i2 = 72u;
  var_i1 += var_i2;
  var_i2 = var_p2;
  var_i3 = var_p1;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t8, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_i1 = 15u;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l2 = var_i0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p1;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_l2;
  var_i1 = var_p1;
  var_i2 = var_l2;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 28u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32), w2c_rlboxsoundtouch_t4, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 44u;
  var_i0 += var_i1;
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 72u;
  var_i0 += var_i1;
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0, var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 72u;
  var_i0 += var_i1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 44u;
  var_i0 += var_i1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l1 = var_i0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l2 = var_i0;
  var_i1 = var_l2;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l1;
  var_i1 = var_p0;
  var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetLatency0x280x290x20const(instance, var_i1);
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AaddSilent0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetLatency0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0, var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l1 = var_i0;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l2 = var_i0;
  var_i0 = 0u;
  var_l1 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 100u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AgetLength0x280x290x20const(instance, var_i0);
  var_i1 = 1u;
  var_i0 >>= (var_i1 & 31);
  var_l1 = var_i0;
  var_B0:;
  var_i0 = var_l1;
  var_i1 = var_l2;
  var_i0 += var_i1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisEmpty0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l1 = var_i0;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 28u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AisEmpty0x280x290x20const(instance, var_i0);
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetAlgorithm0x28soundtouch0x3A0x3ATransposerBase0x3A0x3AALGORITHM0x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = 0u;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 273824, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3Atranspose0x28soundtouch0x3A0x3AFIFOSampleBuffer0x260x2C0x20soundtouch0x3A0x3AFIFOSampleBuffer0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0, var_l6 = 0, var_l7 = 0;
  f64 var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  f64 var_d0, var_d1;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l3 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l3;
  var_i1 = var_p2;
  var_i2 = var_p2;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l4 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_l4;
  var_d0 = (f64)(s32)(var_i0);
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_d0 /= var_d1;
  var_l5 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_l5;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l4 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = 2147483648u;
  var_l4 = var_i0;
  var_B0:;
  var_i0 = var_p2;
  var_i1 = var_p2;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l6 = var_i0;
  var_i0 = var_p1;
  var_i1 = var_l4;
  var_i2 = 8u;
  var_i1 += var_i2;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrEnd0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l4 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  switch (var_i0) {
    case 0: goto var_B2;
    case 1: goto var_B4;
    default: goto var_B3;
  }
  var_B4:;
  var_i0 = var_l4;
  var_i1 = 4u;
  var_i0 += var_i1;
  var_l4 = var_i0;
  goto var_B2;
  var_B3:;
  var_i0 = var_l4;
  var_i1 = 8u;
  var_i0 += var_i1;
  var_l4 = var_i0;
  var_B2:;
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i2 = var_l7;
  var_i3 = var_l6;
  var_i4 = var_l3;
  var_i5 = 12u;
  var_i4 += var_i5;
  var_i5 = var_l4;
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t5, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_p0 = var_i1;
  var_i2 = var_p1;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 40u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32), w2c_rlboxsoundtouch_t4, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p2;
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i2 = var_p2;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l3;
  var_i1 = 16u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3ATransposerBase0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p0;
  var_i1 = 262804u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_j1 = 4607182418800017408ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_j1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3A0x7ETransposerBase0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  UNREACHABLE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATransposerBase0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_d1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AptrBegin0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t8, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AnumSamples0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AadjustAmountOfSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 36u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch_ac_test_0(w2c_rlboxsoundtouch* instance) {
  u32 var_l0 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l0 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l0;
  var_i1 = 263371u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = 263459u;
  var_i1 = var_l0;
  var_i0 = w2c_rlboxsoundtouch_printf_0(instance, var_i0, var_i1);
  var_i0 = var_l0;
  var_i1 = 16u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3ASoundTouch0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  v128 var_l2 = simde_wasm_i64x2_make(0, 0);
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  v128 var_o1;
  var_i0 = var_p0;
  var_i1 = 263624u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_p0;
  var_i1 = 104u;
  var_i1 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i1);
  var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3ARateTransposer0x280x29(instance, var_i1);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_p0;
  var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AnewInstance0x280x29(instance);
  var_l1 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_p0;
  var_i1 = var_l1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_p0;
  var_o1 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  var_l2 = var_o1;
  v128_store(instance->w2c_env_memory, (u64)(var_i0) + 64, var_o1);
  var_i0 = var_p0;
  var_j1 = 4607182418800017408ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_j1);
  var_i0 = var_p0;
  var_o1 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f);
  v128_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_o1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 40, var_i1);
  var_i0 = var_p0;
  var_o1 = var_l2;
  v128_store(instance->w2c_env_memory, (u64)(var_i0) + 48, var_o1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0;
  f64 var_l1 = 0, var_l2 = 0, var_l3 = 0, var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f64 var_d0, var_d1, var_d2;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 72u);
  var_l1 = var_d0;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i2 = var_p0;
  var_d2 = f64_load(instance->w2c_env_memory, (u64)(var_i2) + 32u);
  var_l2 = var_d2;
  var_d1 /= var_d2;
  var_l3 = var_d1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 72, var_d1);
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 64u);
  var_l4 = var_d0;
  var_i0 = var_p0;
  var_d1 = var_l2;
  var_i2 = var_p0;
  var_d2 = f64_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_d1 *= var_d2;
  var_l2 = var_d1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 64, var_d1);
  var_d0 = var_l2;
  var_d1 = var_l4;
  var_d0 -= var_d1;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 1e-10;
  var_i0 = var_d0 < var_d1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l5 = var_i0;
  var_d1 = var_l2;
  var_i2 = var_l5;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 40u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, f64), w2c_rlboxsoundtouch_t9, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_d1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 72u);
  var_l3 = var_d0;
  var_B0:;
  var_d0 = var_l3;
  var_d1 = var_l1;
  var_d0 -= var_d1;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 1e-10;
  var_i0 = var_d0 < var_d1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_d1 = var_l3;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetTempo0x28double0x29(instance, var_i0, var_d1);
  var_B1:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l5 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 64u);
  var_d1 = 1.0;
  var_i0 = var_d0 <= var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B4;}
  var_i0 = var_l5;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_l6 = var_i1;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i1 = 12u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_l6;
  var_i1 = 100u;
  var_i0 += var_i1;
  var_l6 = var_i0;
  goto var_B3;
  var_B4:;
  var_i0 = var_l5;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_l6 = var_i1;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i1 = 8u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_l5;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l8 = var_i0;
  var_i0 = var_l6;
  var_i1 = 72u;
  var_i0 += var_i1;
  var_i1 = var_l5;
  var_i2 = var_l5;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_l8;
  var_i3 = var_l6;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 72u);
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l5;
  var_i1 = var_l8;
  var_i2 = var_l5;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = 128u;
  var_i0 += var_i1;
  var_l5 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l6 = var_i0;
  var_B3:;
  var_i0 = var_l5;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l8 = var_i0;
  var_i0 = var_l6;
  var_i1 = var_l5;
  var_i2 = var_l5;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_l8;
  var_i3 = var_l6;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l5;
  var_i1 = var_l8;
  var_i2 = var_l5;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i1 = var_l7;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_B2:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 263624u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_l1;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B1:;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3A0x7ESoundTouch0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 263624u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_l1;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B1:;
  var_i0 = var_p0;
  var_i1 = 80u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetVersionString0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263371u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetVersionId0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 20200u;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetChannels0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p1;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_i1 = 15u;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 60, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRate0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetRateChange0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1, var_d2;
  var_i0 = var_p0;
  var_d1 = var_p1;
  var_d2 = 0.01;
  var_d1 *= var_d2;
  var_d2 = 1.0;
  var_d1 += var_d2;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempo0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetTempoChange0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1, var_d2;
  var_i0 = var_p0;
  var_d1 = var_p1;
  var_d2 = 0.01;
  var_d1 *= var_d2;
  var_d2 = 1.0;
  var_d1 += var_d2;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitch0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1;
  var_i0 = var_p0;
  var_d1 = var_p1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchOctaves0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1, var_d2;
  var_i0 = var_p0;
  var_d1 = var_p1;
  var_d2 = 0.69314718056000002;
  var_d1 *= var_d2;
  var_d1 = w2c_rlboxsoundtouch_exp_0(instance, var_d1);
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchSemiTones0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  f64 var_d1, var_d2;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_d1 = (f64)(s32)(var_i1);
  var_d2 = 12.0;
  var_d1 /= var_d2;
  var_d2 = 0.69314718056000002;
  var_d1 *= var_d2;
  var_d1 = w2c_rlboxsoundtouch_exp_0(instance, var_d1);
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetPitchSemiTones0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0;
  f64 var_d1, var_d2;
  var_i0 = var_p0;
  var_d1 = var_p1;
  var_d2 = 12.0;
  var_d1 /= var_d2;
  var_d2 = 0.69314718056000002;
  var_d1 *= var_d2;
  var_d1 = w2c_rlboxsoundtouch_exp_0(instance, var_d1);
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AcalcEffectiveRateAndTempo0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSampleRate0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_p1;
  var_i2 = 4294967295u;
  var_i3 = 4294967295u;
  var_i4 = 4294967295u;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_i0 = var_p0;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 40, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l4 = 0;
  f64 var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 48u);
  var_i2 = var_p2;
  var_d2 = (f64)(var_i2);
  var_i3 = var_p0;
  var_d3 = f64_load(instance->w2c_env_memory, (u64)(var_i3) + 64u);
  var_l3 = var_d3;
  var_i4 = var_p0;
  var_d4 = f64_load(instance->w2c_env_memory, (u64)(var_i4) + 72u);
  var_d3 *= var_d4;
  var_d2 /= var_d3;
  var_d1 += var_d2;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 48, var_d1);
  var_d0 = var_l3;
  var_d1 = 1.0;
  var_i0 = var_d0 <= var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l4 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_l4;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i1 = 8u;
  var_i0 += var_i1;
  var_p1 = var_i0;
  var_i0 = 12u;
  var_p2 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l4 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_l4;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i1 = 12u;
  var_i0 += var_i1;
  var_p1 = var_i0;
  var_i0 = 8u;
  var_p2 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_p2 = var_i0;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_p0 = var_i0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_p1 = var_i0;
  var_i0 = var_p2;
  var_i1 = var_p0;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i2 = var_p1;
  var_i3 = var_p2;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aflush0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0, var_l2 = 0, var_l3 = 0, var_l5 = 0;
  f64 var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f64 var_d0, var_d1;
  var_i0 = 4294967295u;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 60u);
  var_l1 = var_i1;
  var_i2 = 9u;
  var_i1 <<= (var_i2 & 31);
  var_l2 = var_i1;
  var_i2 = var_l1;
  var_i3 = 25165824u;
  var_i2 &= var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i0);
  var_l1 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 56u);
  var_l3 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_l4 = var_d0;
  var_i0 = var_l1;
  var_i1 = 0u;
  var_i2 = var_l2;
  var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
  var_l5 = var_i0;
  var_d0 = var_l4;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l4 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_l4;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l1 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = 2147483648u;
  var_l1 = var_i0;
  var_B0:;
  var_i0 = var_l1;
  var_i1 = var_l3;
  var_i0 -= var_i1;
  var_l1 = var_i0;
  var_i1 = 0u;
  var_i2 = var_l1;
  var_i3 = 0u;
  var_i2 = (u32)((s32)var_i2 > (s32)var_i3);
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l3 = var_i0;
  var_i1 = var_p0;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = (u32)((s32)var_i0 <= (s32)var_i1);
  if (var_i0) {goto var_B2;}
  var_i0 = 0u;
  var_l1 = var_i0;
  var_L3: 
    var_i0 = var_p0;
    var_i1 = var_l5;
    var_i2 = 128u;
    var_i3 = var_p0;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 12u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_l3;
    var_i1 = var_p0;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
    var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = (u32)((s32)var_i0 <= (s32)var_i1);
    if (var_i0) {goto var_B2;}
    var_i0 = var_l1;
    var_i1 = 199u;
    var_i0 = var_i0 < var_i1;
    var_l2 = var_i0;
    var_i0 = var_l1;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l1 = var_i0;
    var_i0 = var_l2;
    if (var_i0) {goto var_L3;}
  var_B2:;
  var_i0 = var_p0;
  var_i1 = var_l3;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 36u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l5;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearInput0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AsetSetting0x28int0x2C0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l3 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_l3;
  var_i2 = 12u;
  var_i1 += var_i2;
  var_i2 = var_l3;
  var_i3 = 8u;
  var_i2 += var_i3;
  var_i3 = var_l3;
  var_i4 = 4u;
  var_i3 += var_i4;
  var_i4 = var_l3;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_p1;
  switch (var_i0) {
    case 0: goto var_B7;
    case 1: goto var_B6;
    case 2: goto var_B5;
    case 3: goto var_B4;
    case 4: goto var_B3;
    case 5: goto var_B2;
    default: goto var_B0;
  }
  var_B7:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = var_p2;
  var_i2 = 0u;
  var_i1 = var_i1 != var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AenableAAFilter0x28bool0x29(instance, var_i0, var_i1);
  goto var_B1;
  var_B6:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetAAFilter0x280x29(instance, var_i0);
  var_i1 = var_p2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AsetLength0x28unsigned0x20int0x29(instance, var_i0, var_i1);
  goto var_B1;
  var_B5:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_p2;
  var_i2 = 0u;
  var_i1 = var_i1 != var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AenableQuickSeek0x28bool0x29(instance, var_i0, var_i1);
  goto var_B1;
  var_B4:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i2 = var_p2;
  var_i3 = var_l3;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 4u);
  var_i4 = var_l3;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  goto var_B1;
  var_B3:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i2 = var_l3;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i3 = var_p2;
  var_i4 = var_l3;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  goto var_B1;
  var_B2:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i2 = var_l3;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i3 = var_l3;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 4u);
  var_i4 = var_p2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_B1:;
  var_i0 = 1u;
  var_l4 = var_i0;
  var_B0:;
  var_i0 = var_l3;
  var_i1 = 16u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetSetting0x28int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0;
  f64 var_l4 = 0, var_l5 = 0, var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  f64 var_d0, var_d1, var_d2;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l2 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = 0u;
  var_l3 = var_i0;
  var_i0 = var_p1;
  switch (var_i0) {
    case 0: goto var_B10;
    case 1: goto var_B9;
    case 2: goto var_B8;
    case 3: goto var_B7;
    case 4: goto var_B6;
    case 5: goto var_B5;
    case 6: goto var_B4;
    case 7: goto var_B3;
    case 8: goto var_B2;
    default: goto var_B0;
  }
  var_B10:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AisAAFilterEnabled0x280x290x20const(instance, var_i0);
  var_l3 = var_i0;
  goto var_B0;
  var_B9:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetAAFilter0x280x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AAAFilter0x3A0x3AgetLength0x280x290x20const(instance, var_i0);
  var_l3 = var_i0;
  goto var_B0;
  var_B8:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AisQuickSeekEnabled0x280x290x20const(instance, var_i0);
  var_l3 = var_i0;
  goto var_B0;
  var_B7:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = 0u;
  var_i2 = var_l2;
  var_i3 = 12u;
  var_i2 += var_i3;
  var_i3 = 0u;
  var_i4 = 0u;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_i0 = var_l2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l3 = var_i0;
  goto var_B0;
  var_B6:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = 0u;
  var_i2 = 0u;
  var_i3 = var_l2;
  var_i4 = 12u;
  var_i3 += var_i4;
  var_i4 = 0u;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_i0 = var_l2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l3 = var_i0;
  goto var_B0;
  var_B5:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i1 = 0u;
  var_i2 = 0u;
  var_i3 = 0u;
  var_i4 = var_l2;
  var_i5 = 12u;
  var_i4 += var_i5;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_i0 = var_l2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l3 = var_i0;
  goto var_B0;
  var_B4:;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 64u);
  var_l4 = var_d0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 72u);
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l5 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B12;}
  var_d0 = var_l5;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l3 = var_i0;
  goto var_B11;
  var_B12:;
  var_i0 = 2147483648u;
  var_l3 = var_i0;
  var_B11:;
  var_d0 = var_l4;
  var_d1 = 1.0;
  var_i0 = var_d0 <= var_d1;
  var_p0 = var_i0;
  var_i0 = var_l3;
  var_d0 = (f64)(s32)(var_i0);
  var_d1 = var_l4;
  var_d0 *= var_d1;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l4 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B14;}
  var_d0 = var_l4;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_p1 = var_i0;
  goto var_B13;
  var_B14:;
  var_i0 = 2147483648u;
  var_p1 = var_i0;
  var_B13:;
  var_i0 = var_p1;
  var_i1 = var_l3;
  var_i2 = var_p0;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l3 = var_i0;
  goto var_B0;
  var_B3:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l3 = var_i0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i0 -= var_i1;
  var_l3 = var_i0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 64u);
  var_l4 = var_d0;
  var_d1 = 1.0;
  var_i0 = var_d0 > var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l3;
  var_d0 = (f64)(s32)(var_i0);
  var_d1 = var_l4;
  var_d0 /= var_d1;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l4 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_l4;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l3 = var_i0;
  goto var_B0;
  var_B2:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_d0 = (f64)(s32)(var_i0);
  var_l4 = var_d0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ARateTransposer0x3A0x3AgetLatency0x280x290x20const(instance, var_i0);
  var_d0 = (f64)(s32)(var_i0);
  var_l5 = var_d0;
  var_i0 = var_p0;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 64u);
  var_l6 = var_d0;
  var_d1 = 1.0;
  var_i0 = var_d0 <= var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B16;}
  var_d0 = var_l6;
  var_d1 = var_l4;
  var_d2 = var_l5;
  var_d1 += var_d2;
  var_d0 *= var_d1;
  var_l4 = var_d0;
  goto var_B15;
  var_B16:;
  var_d0 = var_l5;
  var_d1 = var_l6;
  var_d0 /= var_d1;
  var_d1 = var_l4;
  var_d0 += var_d1;
  var_l4 = var_d0;
  var_B15:;
  var_d0 = var_l4;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l4 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_l4;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l3 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = 2147483648u;
  var_l3 = var_i0;
  var_B0:;
  var_i0 = var_l2;
  var_i1 = 16u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l3;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 48, var_j1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l1 = var_i0;
  var_i1 = var_l1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_p0 = var_i0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AnumUnprocessedSamples0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_p0 = var_i0;
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 128u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28float0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_l3 = var_i1;
  var_i2 = var_p1;
  var_i3 = var_p2;
  var_i4 = var_l3;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 16u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t8, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_p2 = var_i1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 56u);
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
  var_i0 = var_p2;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_l2 = var_i1;
  var_i2 = var_p1;
  var_i3 = var_l2;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 20u);
  var_i1 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_p1 = var_i1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 56u);
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
  var_i0 = var_p1;
  FUNC_EPILOGUE;
  return var_i0;
}

f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3AgetInputOutputSampleRatio0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i1, var_i2;
  f64 var_d0, var_d1, var_d2;
  var_d0 = 1.0;
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 72u);
  var_i2 = var_p0;
  var_d2 = f64_load(instance->w2c_env_memory, (u64)(var_i2) + 64u);
  var_d1 *= var_d2;
  var_d0 /= var_d1;
  FUNC_EPILOGUE;
  return var_d0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOProcessor0x3A0x3AisEmpty0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 28u);
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32), w2c_rlboxsoundtouch_t2, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_createSoundTouchObj_0(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 80u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ASoundTouch0x3A0x3ASoundTouch0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_destroySoundTouchObj_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B0:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3ATDStretch0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0, var_l2 = 0, var_l4 = 0;
  f64 var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  u64 var_j1;
  f64 var_d0, var_d1, var_d2;
  var_i0 = var_p0;
  var_i1 = 263716u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i2 = 100u;
  var_i1 += var_i2;
  var_l1 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_l1;
  var_i1 = 2u;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  var_i1 = 2u;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AFIFOSampleBuffer0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 92, var_j1);
  var_i0 = var_p0;
  var_i1 = 2u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_p0;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 90, var_i1);
  var_i0 = var_p0;
  var_i1 = 256u;
  i32_store16(instance->w2c_env_memory, (u64)(var_i0) + 88, var_i1);
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p0;
  var_j1 = 4607182418800017408ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 64, var_j1);
  var_i0 = var_p0;
  var_i1 = 44100u;
  var_i2 = 0u;
  var_i3 = 0u;
  var_i4 = 8u;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_i0 = var_p0;
  var_j1 = 4607182418800017408ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 64, var_j1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 64u);
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  var_l1 = var_i2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_l2 = var_i3;
  var_i2 -= var_i3;
  var_d2 = (f64)(s32)(var_i2);
  var_d1 *= var_d2;
  var_l3 = var_d1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 72, var_d1);
  var_d0 = var_l3;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l3 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_l3;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l4 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = 2147483648u;
  var_l4 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = var_l2;
  var_i2 = var_l4;
  var_i1 += var_i2;
  var_l2 = var_i1;
  var_i2 = var_l1;
  var_i3 = var_l2;
  var_i4 = var_l1;
  var_i3 = (u32)((s32)var_i3 > (s32)var_i4);
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  f64 var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0, var_d1, var_d2;
  var_i0 = var_p1;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 40, var_i1);
  var_B0:;
  var_i0 = var_p4;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_B1:;
  var_i0 = 1u;
  var_p1 = var_i0;
  var_i0 = var_p2;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B4;}
  var_i0 = var_p0;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_i0 = 0u;
  var_p1 = var_i0;
  goto var_B3;
  var_B4:;
  var_i0 = var_p2;
  if (var_i0) {goto var_B2;}
  var_B3:;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 89, var_i1);
  var_B2:;
  var_i0 = 1u;
  var_p2 = var_i0;
  var_i0 = var_p3;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B7;}
  var_i0 = var_p0;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 48, var_i1);
  var_i0 = 0u;
  var_p2 = var_i0;
  goto var_B6;
  var_B7:;
  var_i0 = var_p3;
  if (var_i0) {goto var_B5;}
  var_B6:;
  var_i0 = var_p0;
  var_i1 = var_p2;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 90, var_i1);
  var_B5:;
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 52u);
  var_i1 *= var_i2;
  var_i2 = 1000u;
  var_i1 = I32_DIV_S(var_i1, var_i2);
  var_p3 = var_i1;
  var_i2 = 16u;
  var_i3 = var_p3;
  var_i4 = 16u;
  var_i3 = (u32)((s32)var_i3 > (s32)var_i4);
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i2 = 2147483640u;
  var_i1 &= var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AacceptNewOverlapLength0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 64u);
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  var_p3 = var_i2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_p2 = var_i3;
  var_i2 -= var_i3;
  var_d2 = (f64)(s32)(var_i2);
  var_d1 *= var_d2;
  var_l5 = var_d1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 72, var_d1);
  var_d0 = var_l5;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_l5 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B9;}
  var_d0 = var_l5;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_p1 = var_i0;
  goto var_B8;
  var_B9:;
  var_i0 = 2147483648u;
  var_p1 = var_i0;
  var_B8:;
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i2 = var_p1;
  var_i1 += var_i2;
  var_p2 = var_i1;
  var_i2 = var_p3;
  var_i3 = var_p2;
  var_i4 = var_p3;
  var_i3 = (u32)((s32)var_i3 > (s32)var_i4);
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l2 = 0, var_l3 = 0;
  f64 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 89u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_d0 = 40.5;
  var_d1 = 90.0;
  var_i2 = var_p0;
  var_d2 = f64_load(instance->w2c_env_memory, (u64)(var_i2) + 64u);
  var_d3 = -33.333333333333336;
  var_d2 *= var_d3;
  var_d3 = 106.66666666666667;
  var_d2 += var_d3;
  var_l1 = var_d2;
  var_d3 = var_l1;
  var_d4 = 90.0;
  var_i3 = var_d3 > var_d4;
  var_d1 = var_i3 ? var_d1 : var_d2;
  var_d2 = 0.5;
  var_d1 += var_d2;
  var_d2 = var_l1;
  var_d3 = 40.0;
  var_i2 = var_d2 < var_d3;
  var_d0 = var_i2 ? var_d0 : var_d1;
  var_l1 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B2;}
  var_d0 = var_l1;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l2 = var_i0;
  goto var_B1;
  var_B2:;
  var_i0 = 2147483648u;
  var_l2 = var_i0;
  var_B1:;
  var_i0 = var_p0;
  var_i1 = var_l2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 90u);
  if (var_i0) {goto var_B4;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_l2 = var_i0;
  goto var_B3;
  var_B4:;
  var_d0 = 15.5;
  var_d1 = 20.0;
  var_i2 = var_p0;
  var_d2 = f64_load(instance->w2c_env_memory, (u64)(var_i2) + 64u);
  var_d3 = -3.3333333333333335;
  var_d2 *= var_d3;
  var_d3 = 21.666666666666668;
  var_d2 += var_d3;
  var_l1 = var_d2;
  var_d3 = var_l1;
  var_d4 = 20.0;
  var_i3 = var_d3 > var_d4;
  var_d1 = var_i3 ? var_d1 : var_d2;
  var_d2 = 0.5;
  var_d1 += var_d2;
  var_d2 = var_l1;
  var_d3 = 15.0;
  var_i2 = var_d2 < var_d3;
  var_d0 = var_i2 ? var_d0 : var_d1;
  var_l1 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B6;}
  var_d0 = var_l1;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l2 = var_i0;
  goto var_B5;
  var_B6:;
  var_i0 = 2147483648u;
  var_l2 = var_i0;
  var_B5:;
  var_i0 = var_p0;
  var_i1 = var_l2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 48, var_i1);
  var_B3:;
  var_i0 = var_p0;
  var_i1 = var_l2;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 40u);
  var_l3 = var_i2;
  var_i1 *= var_i2;
  var_i2 = 1000u;
  var_i1 = I32_DIV_S(var_i1, var_i2);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p0;
  var_i1 = var_l3;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 44u);
  var_i1 *= var_i2;
  var_i2 = 1000u;
  var_i1 = I32_DIV_S(var_i1, var_i2);
  var_l2 = var_i1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
  var_i3 = 1u;
  var_i2 <<= (var_i3 & 31);
  var_l3 = var_i2;
  var_i3 = var_l2;
  var_i4 = var_l3;
  var_i3 = (u32)((s32)var_i3 > (s32)var_i4);
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AacceptNewOverlapLength0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l2 = var_i0;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_l2;
  var_i1 = var_p1;
  var_i0 = (u32)((s32)var_i0 >= (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 96u);
  var_l2 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_l2;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_p1 = var_i0;
  var_B1:;
  var_i0 = var_p0;
  var_i1 = 4294967295u;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i3 = var_p1;
  var_i2 *= var_i3;
  var_p1 = var_i2;
  var_i3 = 4u;
  var_i2 += var_i3;
  var_l2 = var_i2;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i3 = var_l2;
  var_i4 = 1073741823u;
  var_i3 = var_i3 > var_i4;
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i1 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i1);
  var_l2 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 96, var_i1);
  var_i0 = var_p0;
  var_i1 = var_l2;
  var_i2 = 15u;
  var_i1 += var_i2;
  var_i2 = 4294967280u;
  var_i1 &= var_i2;
  var_l2 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 92, var_i1);
  var_i0 = var_l2;
  var_i1 = 0u;
  var_i2 = var_p1;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetTempo0x28double0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, f64 var_p1) {
  u32 var_l2 = 0, var_l3 = 0, var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0, var_d1, var_d2;
  var_i0 = var_p0;
  var_d1 = var_p1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 64, var_d1);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcSeqParameters0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 64u);
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
  var_l2 = var_i2;
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_l3 = var_i3;
  var_i2 -= var_i3;
  var_d2 = (f64)(s32)(var_i2);
  var_d1 *= var_d2;
  var_p1 = var_d1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0) + 72, var_d1);
  var_d0 = var_p1;
  var_d1 = 0.5;
  var_d0 += var_d1;
  var_p1 = var_d0;
  var_d0 = wasm_fabs(var_d0);
  var_d1 = 2147483648.0;
  var_i0 = var_d0 < var_d1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_d0 = var_p1;
  var_i0 = I32_TRUNC_S_F64(var_d0);
  var_l4 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = 2147483648u;
  var_l4 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i1 = var_l3;
  var_i2 = var_l4;
  var_i1 += var_i2;
  var_l3 = var_i1;
  var_i2 = var_l2;
  var_i3 = var_l3;
  var_i4 = var_l2;
  var_i3 = (u32)((s32)var_i3 > (s32)var_i4);
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = 263716u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 96u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 100u;
  var_i0 += var_i1;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3A0x7EFIFOSampleBuffer0x280x29(instance, var_i0);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(instance, var_i0);
  var_i1 = 160u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalculateOverlapLength0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i2 = var_p1;
  var_i1 *= var_i2;
  var_i2 = 1000u;
  var_i1 = I32_DIV_S(var_i1, var_i2);
  var_p1 = var_i1;
  var_i2 = 16u;
  var_i3 = var_p1;
  var_i4 = 16u;
  var_i3 = (u32)((s32)var_i3 > (s32)var_i4);
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i2 = 2147483640u;
  var_i1 &= var_i2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AacceptNewOverlapLength0x28int0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AgetParameters0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B0:;
  var_i0 = var_p2;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p2;
  var_i1 = 0u;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 44u);
  var_i3 = var_p0;
  var_i3 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i3) + 89u);
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B1:;
  var_i0 = var_p3;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B2;}
  var_i0 = var_p3;
  var_i1 = 0u;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 48u);
  var_i3 = var_p0;
  var_i3 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i3) + 90u);
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B2:;
  var_i0 = var_p4;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B3;}
  var_i0 = var_p4;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 52u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B3:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMono0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l6 = 0, var_l7 = 0;
  f32 var_l4 = 0, var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2, var_f3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l3 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l3;
  var_f0 = (f32)(var_i0);
  var_l4 = var_f0;
  var_f0 = 0;
  var_l5 = var_f0;
  var_i0 = 0u;
  var_l6 = var_i0;
  var_i0 = 0u;
  var_l7 = var_i0;
  var_L1: 
    var_i0 = var_p1;
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_i1 = var_p2;
    var_i2 = var_l6;
    var_i1 += var_i2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_f2 = var_l5;
    var_f1 *= var_f2;
    var_f2 = var_l4;
    var_i3 = var_p0;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 92u);
    var_i4 = var_l6;
    var_i3 += var_i4;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3));
    var_f2 *= var_f3;
    var_f1 += var_f2;
    var_i2 = var_l3;
    var_f2 = (f32)(s32)(var_i2);
    var_f1 /= var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_l6;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_l6 = var_i0;
    var_f0 = var_l4;
    var_f1 = -1;
    var_f0 += var_f1;
    var_l4 = var_f0;
    var_f0 = var_l5;
    var_f1 = 1;
    var_f0 += var_f1;
    var_l5 = var_f0;
    var_i0 = var_l7;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
    var_l3 = var_i1;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearMidBuffer0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 92u);
  var_i1 = 0u;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearInput0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  u64 var_j1;
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 92u);
  var_i1 = 0u;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 80, var_j1);
  var_i0 = var_p0;
  var_j1 = 5530064238082523136ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_j1);
  var_i0 = var_p0;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 91, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aclear0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  u64 var_j1;
  var_i0 = var_p0;
  var_i1 = 100u;
  var_i0 += var_i1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3Aclear0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 92u);
  var_i1 = 0u;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
  var_i3 = var_p0;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
  var_i2 *= var_i3;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i0 = w2c_rlboxsoundtouch_memset_0(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 80, var_j1);
  var_i0 = var_p0;
  var_j1 = 5530064238082523136ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_j1);
  var_i0 = var_p0;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 91, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AenableQuickSeek0x28bool0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 88, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AisQuickSeekEnabled0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 88u);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPosition0x28float0x20const0x2A0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i3 = 56u;
  var_i4 = 52u;
  var_i5 = var_p0;
  var_i5 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i5) + 88u);
  var_i3 = var_i5 ? var_i3 : var_i4;
  var_i2 += var_i3;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionFull0x28float0x20const0x2A0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l9 = 0;
  f64 var_l3 = 0, var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0, var_d1, var_d2, var_d3;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l2 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p0;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 92u);
  var_i3 = var_l2;
  var_i4 = 8u;
  var_i3 += var_i4;
  var_i4 = var_p0;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 44u);
  var_d0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), f64 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t10, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_l3 = var_d0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_d0 = var_l3;
  var_d1 = 0.10000000000000001;
  var_d0 += var_d1;
  var_d1 = 0.75;
  var_d0 *= var_d1;
  var_l3 = var_d0;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 2u;
  var_l5 = var_i0;
  var_i0 = 1u;
  var_l6 = var_i0;
  var_L1: 
    var_i0 = var_p0;
    var_i1 = var_p1;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
    var_i3 = var_l6;
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i1 += var_i2;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 92u);
    var_i3 = var_l2;
    var_i4 = 8u;
    var_i3 += var_i4;
    var_i4 = var_p0;
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 48u);
    var_d0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), f64 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t10, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_d1 = 0.10000000000000001;
    var_d0 += var_d1;
    var_i1 = var_l5;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
    var_l7 = var_i2;
    var_i1 -= var_i2;
    var_d1 = (f64)(s32)(var_i1);
    var_i2 = var_l7;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 /= var_d2;
    var_l8 = var_d1;
    var_d2 = -0.25;
    var_d1 *= var_d2;
    var_d2 = var_l8;
    var_d1 *= var_d2;
    var_d2 = 1.0;
    var_d1 += var_d2;
    var_d0 *= var_d1;
    var_l8 = var_d0;
    var_d1 = var_l3;
    var_d2 = var_l8;
    var_d3 = var_l3;
    var_i2 = var_d2 > var_d3;
    var_l9 = var_i2;
    var_d0 = var_i2 ? var_d0 : var_d1;
    var_l3 = var_d0;
    var_i0 = var_l6;
    var_i1 = var_l4;
    var_i2 = var_l9;
    var_i0 = var_i2 ? var_i0 : var_i1;
    var_l4 = var_i0;
    var_i0 = var_l5;
    var_i1 = 2u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_l6;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l6 = var_i0;
    var_i1 = var_l7;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l2;
  var_i1 = 16u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AseekBestOverlapPositionQuick0x28float0x20const0x2A0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0, var_l4 = 0, var_l6 = 0, var_l8 = 0, var_l9 = 0, var_l12 = 0, var_l13 = 0;
  f32 var_l5 = 0, var_l7 = 0, var_l10 = 0, var_l11 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2, var_f3;
  f64 var_d0;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l2 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l3 = var_i0;
  var_i1 = 26u;
  var_i0 = (u32)((s32)var_i0 >= (s32)var_i1);
  if (var_i0) {goto var_B1;}
  var_i0 = 8u;
  var_l4 = var_i0;
  var_f0 = -3.40282347e+38;
  var_l5 = var_f0;
  var_i0 = 8u;
  var_l6 = var_i0;
  goto var_B0;
  var_B1:;
  var_f0 = -3.40282347e+38;
  var_l7 = var_f0;
  var_i0 = 8u;
  var_l6 = var_i0;
  var_i0 = 31u;
  var_l8 = var_i0;
  var_i0 = 16u;
  var_l9 = var_i0;
  var_i0 = 8u;
  var_l4 = var_i0;
  var_f0 = -3.40282347e+38;
  var_l5 = var_f0;
  var_L2: 
    var_i0 = var_p0;
    var_i1 = var_p1;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
    var_i3 = var_l9;
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i1 += var_i2;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 92u);
    var_i3 = var_l2;
    var_i4 = 8u;
    var_i3 += var_i4;
    var_i4 = var_p0;
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 44u);
    var_d0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), f64 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t10, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_f0 = (f32)wasm_quiet(var_d0);
    var_f1 = 0.100000001;
    var_f0 += var_f1;
    var_i1 = var_l8;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
    var_l3 = var_i2;
    var_i1 -= var_i2;
    var_f1 = (f32)(s32)(var_i1);
    var_i2 = var_l3;
    var_f2 = (f32)(s32)(var_i2);
    var_f1 /= var_f2;
    var_l10 = var_f1;
    var_f2 = -0.25;
    var_f1 *= var_f2;
    var_f2 = var_l10;
    var_f1 *= var_f2;
    var_f2 = 1;
    var_f1 += var_f2;
    var_f0 *= var_f1;
    var_l10 = var_f0;
    var_f1 = var_l5;
    var_l11 = var_f1;
    var_i0 = var_f0 > var_f1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B4;}
    var_f0 = var_l10;
    var_l5 = var_f0;
    var_f0 = var_l11;
    var_l7 = var_f0;
    var_i0 = var_l6;
    var_l4 = var_i0;
    var_i0 = var_l9;
    var_l6 = var_i0;
    goto var_B3;
    var_B4:;
    var_f0 = var_l10;
    var_f1 = var_l7;
    var_i0 = var_f0 > var_f1;
    if (var_i0) {goto var_B5;}
    var_f0 = var_l11;
    var_l5 = var_f0;
    goto var_B3;
    var_B5:;
    var_f0 = var_l11;
    var_l5 = var_f0;
    var_f0 = var_l10;
    var_l7 = var_f0;
    var_i0 = var_l9;
    var_l4 = var_i0;
    var_B3:;
    var_i0 = var_l8;
    var_i1 = 32u;
    var_i0 += var_i1;
    var_l8 = var_i0;
    var_i0 = var_l9;
    var_i1 = 16u;
    var_i0 += var_i1;
    var_l9 = var_i0;
    var_i1 = var_l3;
    var_i2 = 4294967287u;
    var_i1 += var_i2;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L2;}
  var_B0:;
  var_i0 = var_l3;
  var_i1 = var_l6;
  var_i2 = 4294967288u;
  var_i1 += var_i2;
  var_l9 = var_i1;
  var_i0 = (u32)((s32)var_i0 <= (s32)var_i1);
  if (var_i0) {goto var_B6;}
  var_i0 = var_l6;
  var_i1 = 9u;
  var_i0 += var_i1;
  var_l8 = var_i0;
  var_i1 = var_l3;
  var_i2 = var_l8;
  var_i3 = var_l3;
  var_i2 = (u32)((s32)var_i2 < (s32)var_i3);
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l12 = var_i0;
  var_i0 = var_l6;
  var_i1 = 1u;
  var_i0 <<= (var_i1 & 31);
  var_i1 = 4294967279u;
  var_i0 += var_i1;
  var_l8 = var_i0;
  var_L7: 
    var_i0 = var_l9;
    var_i1 = var_l6;
    var_i0 = var_i0 == var_i1;
    if (var_i0) {goto var_B8;}
    var_i0 = var_p0;
    var_i1 = var_p1;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
    var_i3 = var_l9;
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i1 += var_i2;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 92u);
    var_i3 = var_l2;
    var_i4 = 8u;
    var_i3 += var_i4;
    var_i4 = var_p0;
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 44u);
    var_d0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), f64 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t10, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_f0 = (f32)wasm_quiet(var_d0);
    var_f1 = 0.100000001;
    var_f0 += var_f1;
    var_i1 = var_l8;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
    var_l3 = var_i2;
    var_i1 -= var_i2;
    var_f1 = (f32)(s32)(var_i1);
    var_i2 = var_l3;
    var_f2 = (f32)(s32)(var_i2);
    var_f1 /= var_f2;
    var_l10 = var_f1;
    var_f2 = -0.25;
    var_f1 *= var_f2;
    var_f2 = var_l10;
    var_f1 *= var_f2;
    var_f2 = 1;
    var_f1 += var_f2;
    var_f0 *= var_f1;
    var_l10 = var_f0;
    var_f1 = var_l5;
    var_f2 = var_l10;
    var_f3 = var_l5;
    var_i2 = var_f2 > var_f3;
    var_l13 = var_i2;
    var_f0 = var_i2 ? var_f0 : var_f1;
    var_l5 = var_f0;
    var_i0 = var_l9;
    var_i1 = var_l6;
    var_i2 = var_l13;
    var_i0 = var_i2 ? var_i0 : var_i1;
    var_l6 = var_i0;
    var_B8:;
    var_i0 = var_l8;
    var_i1 = 2u;
    var_i0 += var_i1;
    var_l8 = var_i0;
    var_i0 = var_l9;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l9 = var_i0;
    var_i1 = var_l12;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L7;}
  var_B6:;
  var_i0 = var_l3;
  var_i1 = var_l4;
  var_i2 = 4294967288u;
  var_i1 += var_i2;
  var_i0 = (u32)((s32)var_i0 <= (s32)var_i1);
  if (var_i0) {goto var_B9;}
  var_i0 = var_l4;
  var_i1 = 9u;
  var_i0 += var_i1;
  var_l9 = var_i0;
  var_i1 = var_l3;
  var_i2 = var_l9;
  var_i3 = var_l3;
  var_i2 = (u32)((s32)var_i2 < (s32)var_i3);
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l13 = var_i0;
  var_i0 = var_l4;
  var_i1 = 1u;
  var_i0 <<= (var_i1 & 31);
  var_i1 = 4294967279u;
  var_i0 += var_i1;
  var_l9 = var_i0;
  var_i0 = 4294967288u;
  var_l3 = var_i0;
  var_L10: 
    var_i0 = var_l3;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B11;}
    var_i0 = var_p0;
    var_i1 = var_p1;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
    var_i3 = var_l4;
    var_i4 = var_l3;
    var_i3 += var_i4;
    var_l8 = var_i3;
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i1 += var_i2;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 92u);
    var_i3 = var_l2;
    var_i4 = 8u;
    var_i3 += var_i4;
    var_i4 = var_p0;
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 44u);
    var_d0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), f64 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t10, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_f0 = (f32)wasm_quiet(var_d0);
    var_f1 = 0.100000001;
    var_f0 += var_f1;
    var_i1 = var_l9;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 20u);
    var_l12 = var_i2;
    var_i1 -= var_i2;
    var_f1 = (f32)(s32)(var_i1);
    var_i2 = var_l12;
    var_f2 = (f32)(s32)(var_i2);
    var_f1 /= var_f2;
    var_l10 = var_f1;
    var_f2 = -0.25;
    var_f1 *= var_f2;
    var_f2 = var_l10;
    var_f1 *= var_f2;
    var_f2 = 1;
    var_f1 += var_f2;
    var_f0 *= var_f1;
    var_l10 = var_f0;
    var_f1 = var_l5;
    var_f2 = var_l10;
    var_f3 = var_l5;
    var_i2 = var_f2 > var_f3;
    var_l12 = var_i2;
    var_f0 = var_i2 ? var_f0 : var_f1;
    var_l5 = var_f0;
    var_i0 = var_l8;
    var_i1 = var_l6;
    var_i2 = var_l12;
    var_i0 = var_i2 ? var_i0 : var_i1;
    var_l6 = var_i0;
    var_B11:;
    var_i0 = var_l9;
    var_i1 = 2u;
    var_i0 += var_i1;
    var_l9 = var_i0;
    var_i0 = var_l4;
    var_i1 = var_l3;
    var_i2 = 1u;
    var_i1 += var_i2;
    var_l3 = var_i1;
    var_i0 += var_i1;
    var_i1 = var_l13;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L10;}
  var_B9:;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32), w2c_rlboxsoundtouch_t1, var_i1, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i1].module_instance, var_i0);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l2;
  var_i1 = 16u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l6;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AadaptNormalizer0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l2 = 0, var_l3 = 0;
  f32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  f32 var_f0, var_f1, var_f2, var_f3;
  var_i0 = var_p0;
  var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 60u);
  var_l1 = var_f0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 56u);
  var_l2 = var_i0;
  var_i1 = 1000u;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B1;}
  var_f0 = var_l1;
  var_f1 = 40000000;
  var_i0 = var_f0 > var_f1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_B1:;
  var_i0 = var_p0;
  var_f1 = var_l1;
  var_f2 = 0.899999976;
  var_f1 *= var_f2;
  var_i2 = var_l2;
  var_f2 = (f32)(var_i2);
  var_f3 = 0.100000001;
  var_f2 *= var_f3;
  var_f1 += var_f2;
  var_l1 = var_f1;
  f32_store(instance->w2c_env_memory, (u64)(var_i0) + 60, var_f1);
  var_i0 = var_l2;
  var_i1 = 800000001u;
  var_i0 = var_i0 < var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_l3 = var_i0;
  var_i1 = 15u;
  var_i0 = (u32)((s32)var_i0 > (s32)var_i1);
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i1 = var_l3;
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  var_i0 = var_l2;
  var_i1 = 1600000001u;
  var_i0 = var_i0 < var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_l3;
  var_i2 = 2u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  goto var_B0;
  var_B2:;
  var_f0 = var_l1;
  var_f1 = 1000000;
  var_i0 = var_f0 < var_f1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_l2 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_l2;
  var_i2 = 4294967295u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AclearCrossCorrState0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetChannels0x28int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p1;
  var_i1 = 4294967295u;
  var_i0 += var_i1;
  var_i1 = 15u;
  var_i0 = var_i0 > var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = var_p1;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  var_i1 = var_p1;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 100u;
  var_i0 += var_i1;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AsetChannels0x28int0x29(instance, var_i0, var_i1);
  var_i0 = var_p0;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i2 = 4294967295u;
  var_i3 = 4294967295u;
  var_i4 = 4294967295u;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AsetParameters0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3, var_i4);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AprocessSamples0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0, var_l2 = 0, var_l3 = 0, var_l4 = 0, var_l5 = 0, var_l6 = 0;
  f64 var_l7 = 0, var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0, var_d1, var_d2;
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  var_l1 = var_i0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(instance, var_i0);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = 100u;
  var_i0 += var_i1;
  var_l2 = var_i0;
  var_i0 = 0u;
  var_l3 = var_i0;
  var_L1: 
    var_i0 = var_p0;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 91u);
    if (var_i0) {goto var_B3;}
    var_i0 = var_p0;
    var_i1 = var_l1;
    var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(instance, var_i1);
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 60u);
    var_i0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), u32 (*)(void*, u32, u32), w2c_rlboxsoundtouch_t3, var_i2, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i2].module_instance, var_i0, var_i1);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_l3 = var_i0;
    var_i0 = var_l2;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
    var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrEnd0x28unsigned0x20int0x29(instance, var_i0, var_i1);
    var_l4 = var_i0;
    var_i0 = var_l1;
    var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(instance, var_i0);
    var_l5 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_l6 = var_i0;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    switch (var_i0) {
      case 0: goto var_B7;
      case 1: goto var_B6;
      default: goto var_B5;
    }
    var_B7:;
    var_i0 = var_l5;
    var_i1 = var_l3;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = 68u;
    var_l6 = var_i0;
    goto var_B4;
    var_B6:;
    var_i0 = var_l5;
    var_i1 = var_l3;
    var_i2 = 3u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = 64u;
    var_l6 = var_i0;
    goto var_B4;
    var_B5:;
    var_i0 = var_l5;
    var_i1 = var_l6;
    var_i2 = var_l3;
    var_i1 *= var_i2;
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = 72u;
    var_l6 = var_i0;
    var_B4:;
    var_i0 = var_p0;
    var_i1 = var_l4;
    var_i2 = var_l5;
    var_i3 = var_p0;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
    var_i4 = var_l6;
    var_i3 += var_i4;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3));
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32), w2c_rlboxsoundtouch_t7, var_i3, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i3].module_instance, var_i0, var_i1, var_i2);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_l2;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
    w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28unsigned0x20int0x29(instance, var_i0, var_i1);
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
    var_i1 = var_l3;
    var_i0 += var_i1;
    var_l3 = var_i0;
    goto var_B2;
    var_B3:;
    var_i0 = var_p0;
    var_i1 = 0u;
    i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 91, var_i1);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 64u);
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
    var_d1 = (f64)(s32)(var_i1);
    var_d0 *= var_d1;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
    var_d1 = (f64)(s32)(var_i1);
    var_d2 = 0.5;
    var_d1 *= var_d2;
    var_d0 += var_d1;
    var_d1 = 0.5;
    var_d0 += var_d1;
    var_l7 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B9;}
    var_d0 = var_l7;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l4 = var_i0;
    goto var_B8;
    var_B9:;
    var_i0 = 2147483648u;
    var_l4 = var_i0;
    var_B8:;
    var_i0 = var_p0;
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 80u);
    var_i2 = var_l4;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    var_l7 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 80, var_d1);
    var_d0 = var_l7;
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 72u);
    var_d1 = -(var_d1);
    var_l8 = var_d1;
    var_i0 = var_d0 <= var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B2;}
    var_i0 = var_p0;
    var_d1 = var_l8;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 80, var_d1);
    var_B2:;
    var_i0 = var_l1;
    var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(instance, var_i0);
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 24u);
    var_l4 = var_i1;
    var_i2 = var_l3;
    var_i1 += var_i2;
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
    var_l5 = var_i2;
    var_i1 -= var_i2;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_B10;}
    var_i0 = var_l2;
    var_i1 = var_l1;
    var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(instance, var_i1);
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
    var_i3 = var_l3;
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i1 += var_i2;
    var_i2 = var_l4;
    var_i3 = var_l5;
    var_i4 = 1u;
    var_i3 <<= (var_i4 & 31);
    var_i2 -= var_i3;
    var_l4 = var_i2;
    w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_i0, var_i1, var_i2);
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 92u);
    var_i1 = var_l1;
    var_i1 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AptrBegin0x280x29(instance, var_i1);
    var_i2 = var_p0;
    var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
    var_l5 = var_i2;
    var_i3 = var_l4;
    var_i4 = var_l3;
    var_i3 += var_i4;
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i1 += var_i2;
    var_i2 = var_l5;
    var_i3 = var_p0;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 16u);
    var_i2 *= var_i3;
    var_i3 = 2u;
    var_i2 <<= (var_i3 & 31);
    var_i0 = w2c_rlboxsoundtouch_memcpy_0(instance, var_i0, var_i1, var_i2);
    var_i0 = var_p0;
    var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0) + 72u);
    var_i1 = var_p0;
    var_d1 = f64_load(instance->w2c_env_memory, (u64)(var_i1) + 80u);
    var_d0 += var_d1;
    var_l7 = var_d0;
    var_d0 = wasm_fabs(var_d0);
    var_d1 = 2147483648.0;
    var_i0 = var_d0 < var_d1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B12;}
    var_d0 = var_l7;
    var_i0 = I32_TRUNC_S_F64(var_d0);
    var_l4 = var_i0;
    goto var_B11;
    var_B12:;
    var_i0 = 2147483648u;
    var_l4 = var_i0;
    var_B11:;
    var_i0 = var_p0;
    var_d1 = var_l7;
    var_i2 = var_l4;
    var_d2 = (f64)(s32)(var_i2);
    var_d1 -= var_d2;
    f64_store(instance->w2c_env_memory, (u64)(var_i0) + 80, var_d1);
    var_i0 = var_l1;
    var_i1 = var_l4;
    var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AreceiveSamples0x28unsigned0x20int0x29(instance, var_i0, var_i1);
    var_B10:;
    var_i0 = var_l1;
    var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AnumSamples0x280x290x20const(instance, var_i0);
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
    var_i0 = (u32)((s32)var_i0 >= (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = 128u;
  var_i0 += var_i1;
  var_i1 = var_p1;
  var_i2 = var_p2;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIFOSampleBuffer0x3A0x3AputSamples0x28float0x20const0x2A0x2C0x20unsigned0x20int0x29(instance, var_i0, var_i1, var_i2);
  var_i0 = var_p0;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AprocessSamples0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3Aoperator0x20new0x28unsigned0x20long0x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AnewInstance0x280x29(instance);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AnewInstance0x280x29(w2c_rlboxsoundtouch* instance) {
  u32 var_l0 = 0, var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = w2c_rlboxsoundtouch_detectCPUextensions0x280x29(instance);
  var_l0 = var_i0;
  var_i0 = 160u;
  var_i0 = w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(instance, var_i0);
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3ATDStretch0x280x29(instance, var_i0);
  var_l1 = var_i0;
  var_i0 = var_l0;
  var_i1 = 8u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  var_i1 = 263864u;
  var_i2 = 8u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B0:;
  var_i0 = var_l1;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapStereo0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l7 = 0, var_l8 = 0, var_l9 = 0;
  f32 var_l4 = 0, var_l5 = 0, var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2, var_f3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l3 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_f0 = 1;
  var_l4 = var_f0;
  var_f0 = 1;
  var_i1 = var_l3;
  var_f1 = (f32)(s32)(var_i1);
  var_f0 /= var_f1;
  var_l5 = var_f0;
  var_f0 = 0;
  var_l6 = var_f0;
  var_i0 = 0u;
  var_l3 = var_i0;
  var_i0 = 0u;
  var_l7 = var_i0;
  var_L1: 
    var_i0 = var_p1;
    var_i1 = var_l3;
    var_i0 += var_i1;
    var_l8 = var_i0;
    var_i1 = var_p2;
    var_i2 = var_l3;
    var_i1 += var_i2;
    var_l9 = var_i1;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_f2 = var_l6;
    var_f1 *= var_f2;
    var_f2 = var_l4;
    var_i3 = var_p0;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 92u);
    var_i4 = var_l3;
    var_i3 += var_i4;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3));
    var_f2 *= var_f3;
    var_f1 += var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_l8;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_i1 = var_l9;
    var_i2 = 4u;
    var_i1 += var_i2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_f2 = var_l6;
    var_f1 *= var_f2;
    var_f2 = var_l4;
    var_i3 = var_p0;
    var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 92u);
    var_i4 = var_l3;
    var_i3 += var_i4;
    var_i4 = 4u;
    var_i3 += var_i4;
    var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3));
    var_f2 *= var_f3;
    var_f1 += var_f2;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_l3;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l3 = var_i0;
    var_f0 = var_l4;
    var_f1 = var_l5;
    var_f0 -= var_f1;
    var_l4 = var_f0;
    var_f0 = var_l5;
    var_f1 = var_l6;
    var_f0 += var_f1;
    var_l6 = var_f0;
    var_i0 = var_l7;
    var_i1 = 2u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
    var_i2 = 1u;
    var_i1 <<= (var_i2 & 31);
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AoverlapMulti0x28float0x2A0x2C0x20float0x20const0x2A0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l6 = 0, var_l8 = 0, var_l9 = 0, var_l10 = 0;
  f32 var_l4 = 0, var_l5 = 0, var_l7 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2, var_f3;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l3 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_f0 = 1;
  var_l4 = var_f0;
  var_f0 = 1;
  var_i1 = var_l3;
  var_f1 = (f32)(s32)(var_i1);
  var_f0 /= var_f1;
  var_l5 = var_f0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l6 = var_i0;
  var_f0 = 0;
  var_l7 = var_f0;
  var_i0 = 0u;
  var_l8 = var_i0;
  var_i0 = 0u;
  var_l9 = var_i0;
  var_L1: 
    var_i0 = var_l6;
    var_i1 = 1u;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_B2;}
    var_i0 = var_l9;
    var_i1 = 2u;
    var_i0 <<= (var_i1 & 31);
    var_l3 = var_i0;
    var_i0 = 0u;
    var_l10 = var_i0;
    var_L3: 
      var_i0 = var_p1;
      var_i1 = var_l3;
      var_i0 += var_i1;
      var_i1 = var_p2;
      var_i2 = var_l3;
      var_i1 += var_i2;
      var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
      var_f2 = var_l7;
      var_f1 *= var_f2;
      var_f2 = var_l4;
      var_i3 = var_p0;
      var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 92u);
      var_i4 = var_l3;
      var_i3 += var_i4;
      var_f3 = f32_load(instance->w2c_env_memory, (u64)(var_i3));
      var_f2 *= var_f3;
      var_f1 += var_f2;
      f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
      var_i0 = var_l3;
      var_i1 = 4u;
      var_i0 += var_i1;
      var_l3 = var_i0;
      var_i0 = var_l10;
      var_i1 = 1u;
      var_i0 += var_i1;
      var_l10 = var_i0;
      var_i1 = var_p0;
      var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
      var_l6 = var_i1;
      var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
      if (var_i0) {goto var_L3;}
    var_i0 = var_l9;
    var_i1 = var_l10;
    var_i0 += var_i1;
    var_l9 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
    var_l3 = var_i0;
    var_B2:;
    var_f0 = var_l4;
    var_f1 = var_l5;
    var_f0 -= var_f1;
    var_l4 = var_f0;
    var_f0 = var_l5;
    var_f1 = var_l7;
    var_f0 += var_f1;
    var_l7 = var_f0;
    var_i0 = var_l8;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l8 = var_i0;
    var_i1 = var_l3;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  FUNC_EPILOGUE;
}

f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  f32 var_l6 = 0, var_l7 = 0, var_l8 = 0;
  f64 var_l4 = 0, var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i3;
  f32 var_f0, var_f1;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i0 *= var_i1;
  var_i1 = 4294967288u;
  var_i0 &= var_i1;
  var_p0 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 >= (s32)var_i1);
  if (var_i0) {goto var_B1;}
  var_d0 = 0.0;
  var_l4 = var_d0;
  var_d0 = 0.0;
  var_l5 = var_d0;
  goto var_B0;
  var_B1:;
  var_f0 = 0;
  var_l6 = var_f0;
  var_f0 = 0;
  var_l7 = var_f0;
  var_L2: 
    var_i0 = var_p1;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l8 = var_f0;
    var_f1 = var_l8;
    var_f0 *= var_f1;
    var_f1 = var_l7;
    var_f0 += var_f1;
    var_l7 = var_f0;
    var_f0 = var_l8;
    var_i1 = var_p2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_f0 *= var_f1;
    var_f1 = var_l6;
    var_f0 += var_f1;
    var_l6 = var_f0;
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_p2;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_p0;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    var_p0 = var_i0;
    if (var_i0) {goto var_L2;}
  var_f0 = var_l6;
  var_d0 = (f64)wasm_quietf(var_f0);
  var_l5 = var_d0;
  var_f0 = var_l7;
  var_d0 = (f64)wasm_quietf(var_f0);
  var_l4 = var_d0;
  var_B0:;
  var_i0 = var_p3;
  var_d1 = var_l4;
  f64_store(instance->w2c_env_memory, (u64)(var_i0), var_d1);
  var_d0 = var_l5;
  var_d1 = 1.0;
  var_d2 = var_l4;
  var_d3 = var_l4;
  var_d4 = 1.0000000000000001e-09;
  var_i3 = var_d3 < var_d4;
  var_d1 = var_i3 ? var_d1 : var_d2;
  var_d1 = wasm_sqrt(var_d1);
  var_d0 /= var_d1;
  FUNC_EPILOGUE;
  return var_d0;
}

f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l7 = 0, var_l9 = 0;
  f32 var_l8 = 0;
  f64 var_l6 = 0, var_l10 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f0, var_f1, var_f2, var_f3;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l4 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 4294967292u;
  var_i0 += var_i1;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_d0;
  var_i0 = 0u;
  var_l7 = var_i0;
  var_L1: 
    var_i0 = var_p3;
    var_d1 = var_l6;
    var_i2 = var_l5;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_l8 = var_f2;
    var_f3 = var_l8;
    var_f2 *= var_f3;
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 -= var_d2;
    var_l6 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0), var_d1);
    var_i0 = var_l5;
    var_i1 = 4294967292u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_l7;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
    var_l4 = var_i1;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_l4;
  var_i0 *= var_i1;
  var_i1 = 4294967288u;
  var_i0 &= var_i1;
  var_l9 = var_i0;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 >= (s32)var_i1);
  if (var_i0) {goto var_B3;}
  var_d0 = 0.0;
  var_l10 = var_d0;
  var_i0 = 0u;
  var_l9 = var_i0;
  goto var_B2;
  var_B3:;
  var_f0 = 0;
  var_l8 = var_f0;
  var_i0 = var_p1;
  var_l5 = var_i0;
  var_i0 = var_l9;
  var_l7 = var_i0;
  var_L4: 
    var_i0 = var_l5;
    var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_p2;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_f0 *= var_f1;
    var_f1 = var_l8;
    var_f0 += var_f1;
    var_l8 = var_f0;
    var_i0 = var_l5;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i0 = var_p2;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l7;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    var_l7 = var_i0;
    if (var_i0) {goto var_L4;}
  var_f0 = var_l8;
  var_d0 = (f64)wasm_quietf(var_f0);
  var_l10 = var_d0;
  var_B2:;
  var_i0 = var_p3;
  var_d0 = f64_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_d0;
  var_i0 = var_l4;
  var_i1 = 1u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B5;}
  var_i0 = var_l9;
  var_i1 = 2u;
  var_i0 <<= (var_i1 & 31);
  var_i1 = var_p1;
  var_i0 += var_i1;
  var_i1 = 4294967292u;
  var_i0 += var_i1;
  var_p2 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_L6: 
    var_i0 = var_p3;
    var_d1 = var_l6;
    var_i2 = var_p2;
    var_f2 = f32_load(instance->w2c_env_memory, (u64)(var_i2));
    var_l8 = var_f2;
    var_f3 = var_l8;
    var_f2 *= var_f3;
    var_d2 = (f64)wasm_quietf(var_f2);
    var_d1 += var_d2;
    var_l6 = var_d1;
    f64_store(instance->w2c_env_memory, (u64)(var_i0), var_d1);
    var_i0 = var_p2;
    var_i1 = 4294967292u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_l5;
    var_i1 = 1u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L6;}
  var_B5:;
  var_d0 = var_l10;
  var_d1 = 1.0;
  var_d2 = var_l6;
  var_d3 = var_l6;
  var_d4 = 1.0000000000000001e-09;
  var_i3 = var_d3 < var_d4;
  var_d1 = var_i3 ? var_d1 : var_d2;
  var_d1 = wasm_sqrt(var_d1);
  var_d0 /= var_d1;
  FUNC_EPILOGUE;
  return var_d0;
}

void w2c_rlboxsoundtouch_disableExtensions0x28unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = 0u;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 274084, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_detectCPUextensions0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 274084u);
  var_i1 = 4294967295u;
  var_i0 ^= var_i1;
  var_i1 = 24u;
  var_i0 &= var_i1;
  FUNC_EPILOGUE;
  return var_i0;
}

f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorr0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0;
  f64 var_l11 = 0;
  v128 var_l5 = simde_wasm_i64x2_make(0, 0), var_l6 = simde_wasm_i64x2_make(0, 0), var_l7 = simde_wasm_i64x2_make(0, 0), var_l8 = simde_wasm_i64x2_make(0, 0), var_l9 = simde_wasm_i64x2_make(0, 0), var_l10 = simde_wasm_i64x2_make(0, 0);
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  f32 var_f0, var_f1, var_f2, var_f3, var_f4;
  f64 var_d0, var_d1, var_d2, var_d3, var_d4;
  v128 var_o0, var_o1, var_o2, var_o3, var_o4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i0 *= var_i1;
  var_l4 = var_i0;
  var_i1 = 16u;
  var_i0 = I32_DIV_S(var_i0, var_i1);
  var_p0 = var_i0;
  var_i0 = var_l4;
  var_i1 = 16u;
  var_i0 = (u32)((s32)var_i0 >= (s32)var_i1);
  if (var_i0) {goto var_B1;}
  var_o0 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  var_l5 = var_o0;
  var_l6 = var_o0;
  goto var_B0;
  var_B1:;
  var_o0 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  var_l6 = var_o0;
  var_l5 = var_o0;
  var_L2: 
    var_o0 = var_l5;
    var_i1 = var_p1;
    var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1));
    var_l7 = var_o1;
    var_i2 = var_p2;
    var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2));
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_i1 = var_p1;
    var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
    var_l8 = var_o1;
    var_i2 = var_p2;
    var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 16u);
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_i1 = var_p1;
    var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
    var_l9 = var_o1;
    var_i2 = var_p2;
    var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 32u);
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_i1 = var_p1;
    var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 48u);
    var_l10 = var_o1;
    var_i2 = var_p2;
    var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 48u);
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_l5 = var_o0;
    var_i0 = var_p2;
    var_i1 = 64u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    var_i0 = var_p1;
    var_i1 = 64u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_o0 = var_l6;
    var_o1 = var_l7;
    var_o2 = var_l7;
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_o1 = var_l8;
    var_o2 = var_l8;
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_o1 = var_l9;
    var_o2 = var_l9;
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_o1 = var_l10;
    var_o2 = var_l10;
    var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
    var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
    var_l6 = var_o0;
    var_i0 = var_p0;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    var_p0 = var_i0;
    if (var_i0) {goto var_L2;}
  var_B0:;
  var_i0 = var_p3;
  var_o1 = var_l6;
  var_f1 = v128_f32x4_extract_lane(var_o1, 3);
  var_o2 = var_l6;
  var_f2 = v128_f32x4_extract_lane(var_o2, 2);
  var_o3 = var_l6;
  var_f3 = v128_f32x4_extract_lane(var_o3, 0);
  var_o4 = var_l6;
  var_f4 = v128_f32x4_extract_lane(var_o4, 1);
  var_f3 += var_f4;
  var_f2 += var_f3;
  var_f1 += var_f2;
  var_d1 = (f64)wasm_quietf(var_f1);
  var_l11 = var_d1;
  f64_store(instance->w2c_env_memory, (u64)(var_i0), var_d1);
  var_o0 = var_l5;
  var_f0 = v128_f32x4_extract_lane(var_o0, 3);
  var_o1 = var_l5;
  var_f1 = v128_f32x4_extract_lane(var_o1, 2);
  var_o2 = var_l5;
  var_f2 = v128_f32x4_extract_lane(var_o2, 0);
  var_o3 = var_l5;
  var_f3 = v128_f32x4_extract_lane(var_o3, 1);
  var_f2 += var_f3;
  var_f1 += var_f2;
  var_f0 += var_f1;
  var_d0 = (f64)wasm_quietf(var_f0);
  var_d1 = 1.0;
  var_d2 = var_l11;
  var_d3 = var_l11;
  var_d4 = 1.0000000000000001e-09;
  var_i3 = var_d3 < var_d4;
  var_d1 = var_i3 ? var_d1 : var_d2;
  var_d1 = wasm_sqrt(var_d1);
  var_d0 /= var_d1;
  FUNC_EPILOGUE;
  return var_d0;
}

f64 w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3AcalcCrossCorrAccumulate0x28float0x20const0x2A0x2C0x20float0x20const0x2A0x2C0x20double0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f64 var_d0;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_p0;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 44u);
  var_d0 = CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), f64 (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t10, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
  return var_d0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AFIRFilterSSE0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AFIRFilter0x280x29(instance, var_i0);
  var_p0 = var_i0;
  var_i1 = 263840u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_j1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  u64 var_j1;
  var_i0 = var_p0;
  var_i1 = 263840u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_l1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B0:;
  var_i0 = var_p0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_j1);
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3A0x7EFIRFilter0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3A0x7EFIRFilterSSE0x280x29(instance, var_i0);
  var_i1 = 36u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  f32 var_l4 = 0, var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  f32 var_f0, var_f1, var_f2;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilter0x3A0x3AsetCoefficients0x28float0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(instance, var_i0, var_i1, var_i2, var_i3);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_p3 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p3;
  w2c_rlboxsoundtouch_operator0x20delete0x5B0x5D0x28void0x2A0x29(instance, var_i0);
  var_B0:;
  var_i0 = var_p0;
  var_i1 = 4294967295u;
  var_i2 = var_p2;
  var_i3 = 1u;
  var_i2 <<= (var_i3 & 31);
  var_i3 = 4u;
  var_i2 += var_i3;
  var_p3 = var_i2;
  var_i3 = 2u;
  var_i2 <<= (var_i3 & 31);
  var_i3 = var_p3;
  var_i4 = 1073741823u;
  var_i3 = var_i3 > var_i4;
  var_i1 = var_i3 ? var_i1 : var_i2;
  var_i1 = w2c_rlboxsoundtouch_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(instance, var_i1);
  var_p3 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  var_i0 = var_p0;
  var_i1 = var_p3;
  var_i2 = 15u;
  var_i1 += var_i2;
  var_i2 = 4294967280u;
  var_i1 &= var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  var_i0 = var_p2;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_f0 = f32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l4 = var_f0;
  var_i0 = 4u;
  var_p3 = var_i0;
  var_L2: 
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 32u);
    var_i1 = var_p3;
    var_i0 += var_i1;
    var_i1 = var_p1;
    var_f1 = f32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_f2 = var_l4;
    var_f1 /= var_f2;
    var_l5 = var_f1;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 32u);
    var_i1 = var_p3;
    var_i0 += var_i1;
    var_i1 = 4294967292u;
    var_i0 += var_i1;
    var_f1 = var_l5;
    f32_store(instance->w2c_env_memory, (u64)(var_i0), var_f1);
    var_i0 = var_p3;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p3 = var_i0;
    var_i0 = var_p1;
    var_i1 = 4u;
    var_i0 += var_i1;
    var_p1 = var_i0;
    var_i0 = var_p2;
    var_i1 = 4294967295u;
    var_i0 += var_i1;
    var_p2 = var_i0;
    if (var_i0) {goto var_L2;}
  var_B1:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_soundtouch0x3A0x3AFIRFilterSSE0x3A0x3AevaluateFilterStereo0x28float0x2A0x2C0x20float0x20const0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l10 = 0;
  v128 var_l8 = simde_wasm_i64x2_make(0, 0), var_l9 = simde_wasm_i64x2_make(0, 0), var_l11 = simde_wasm_i64x2_make(0, 0), var_l12 = simde_wasm_i64x2_make(0, 0), var_l13 = simde_wasm_i64x2_make(0, 0), var_l14 = simde_wasm_i64x2_make(0, 0);
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  v128 var_o0, var_o1, var_o2, var_o3;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_p3;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 -= var_i1;
  var_i1 = 4294967294u;
  var_i0 &= var_i1;
  var_l5 = var_i0;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  var_l6 = var_i0;
  var_L1: 
    var_i0 = var_p1;
    var_i1 = var_l6;
    var_i2 = 3u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_l7 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_l4 = var_i0;
    var_i1 = 8u;
    var_i0 = var_i0 >= var_i1;
    if (var_i0) {goto var_B3;}
    var_o0 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
    var_l8 = var_o0;
    var_l9 = var_o0;
    goto var_B2;
    var_B3:;
    var_i0 = var_l4;
    var_i1 = 3u;
    var_i0 >>= (var_i1 & 31);
    var_l10 = var_i0;
    var_i0 = var_p2;
    var_i1 = var_l6;
    var_i2 = 1u;
    var_i1 <<= (var_i2 & 31);
    var_i2 = 2u;
    var_i1 <<= (var_i2 & 31);
    var_i0 += var_i1;
    var_l4 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 32u);
    var_p3 = var_i0;
    var_o0 = v128_const(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
    var_l9 = var_o0;
    var_l8 = var_o0;
    var_L4: 
      var_o0 = var_l9;
      var_i1 = var_p3;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1));
      var_l11 = var_o1;
      var_i2 = var_l4;
      var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 8u);
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_i1 = var_p3;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
      var_l12 = var_o1;
      var_i2 = var_l4;
      var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 24u);
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_i1 = var_p3;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
      var_l13 = var_o1;
      var_i2 = var_l4;
      var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 40u);
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_i1 = var_p3;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 48u);
      var_l14 = var_o1;
      var_i2 = var_l4;
      var_o2 = v128_load(instance->w2c_env_memory, (u64)(var_i2) + 56u);
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_l9 = var_o0;
      var_o0 = var_l8;
      var_i1 = var_l4;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1));
      var_o2 = var_l11;
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_i1 = var_l4;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
      var_o2 = var_l12;
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_i1 = var_l4;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 32u);
      var_o2 = var_l13;
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_i1 = var_l4;
      var_o1 = v128_load(instance->w2c_env_memory, (u64)(var_i1) + 48u);
      var_o2 = var_l14;
      var_o1 = simde_wasm_f32x4_mul(var_o1, var_o2);
      var_o0 = simde_wasm_f32x4_add(var_o0, var_o1);
      var_l8 = var_o0;
      var_i0 = var_p3;
      var_i1 = 64u;
      var_i0 += var_i1;
      var_p3 = var_i0;
      var_i0 = var_l4;
      var_i1 = 64u;
      var_i0 += var_i1;
      var_l4 = var_i0;
      var_i0 = var_l10;
      var_i1 = 4294967295u;
      var_i0 += var_i1;
      var_l10 = var_i0;
      if (var_i0) {goto var_L4;}
    var_B2:;
    var_i0 = var_l7;
    var_o1 = var_l8;
    var_o2 = var_l9;
    var_o1 = v128_i8x16_shuffle(var_o1, var_o2, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23);
    var_o2 = var_l8;
    var_o3 = var_l9;
    var_o2 = v128_i8x16_shuffle(var_o2, var_o3, 0, 1, 2, 3, 4, 5, 6, 7, 24, 25, 26, 27, 28, 29, 30, 31);
    var_o1 = simde_wasm_f32x4_add(var_o1, var_o2);
    v128_store(instance->w2c_env_memory, (u64)(var_i0), var_o1);
    var_i0 = var_l6;
    var_i1 = 2u;
    var_i0 += var_i1;
    var_l6 = var_i0;
    var_i1 = var_l5;
    var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
    if (var_i0) {goto var_L1;}
  var_i0 = var_l5;
  var_l4 = var_i0;
  var_B0:;
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretchSSE0x3A0x3A0x7ETDStretchSSE0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_soundtouch0x3A0x3ATDStretch0x3A0x3A0x7ETDStretch0x280x29(instance, var_i0);
  var_i1 = 160u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_moz_xmalloc_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_malloc_0(instance, var_i0);
  var_l1 = var_i0;
  var_i0 = var_p0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l1;
  if (var_i0) {goto var_B0;}
  var_L1: 
    var_i0 = var_p0;
    w2c_env_mozalloc_handle_oom(instance->w2c_env_instance, var_i0);
    var_i0 = var_p0;
    var_i0 = w2c_rlboxsoundtouch_malloc_0(instance, var_i0);
    var_l1 = var_i0;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_xcalloc_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  u64 var_j2, var_j3;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_calloc_0(instance, var_i0, var_i1);
  var_l2 = var_i0;
  var_i0 = var_p1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l2;
  if (var_i0) {goto var_B0;}
  var_i0 = 4294967295u;
  var_i1 = var_p1;
  var_i2 = var_p0;
  var_i1 *= var_i2;
  var_i2 = var_p0;
  var_j2 = (u64)(var_i2);
  var_i3 = var_p1;
  var_j3 = (u64)(var_i3);
  var_j2 *= var_j3;
  var_j3 = 32ull;
  var_j2 >>= (var_j3 & 63);
  var_i2 = (u32)(var_j2);
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l3 = var_i0;
  var_L1: 
    var_i0 = var_l3;
    w2c_env_mozalloc_handle_oom(instance->w2c_env_instance, var_i0);
    var_i0 = var_p0;
    var_i1 = var_p1;
    var_i0 = w2c_rlboxsoundtouch_calloc_0(instance, var_i0, var_i1);
    var_l2 = var_i0;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l2;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_xrealloc_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_realloc_0(instance, var_i0, var_i1);
  var_l2 = var_i0;
  var_i0 = var_p1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l2;
  if (var_i0) {goto var_B0;}
  var_L1: 
    var_i0 = var_p1;
    w2c_env_mozalloc_handle_oom(instance->w2c_env_instance, var_i0);
    var_i0 = var_p0;
    var_i1 = var_p1;
    var_i0 = w2c_rlboxsoundtouch_realloc_0(instance, var_i0, var_i1);
    var_l2 = var_i0;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l2;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_xstrdup_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_strdup_0(instance, var_i0);
  var_l1 = var_i0;
  if (var_i0) {goto var_B0;}
  var_L1: 
    var_i0 = 0u;
    w2c_env_mozalloc_handle_oom(instance->w2c_env_instance, var_i0);
    var_i0 = var_p0;
    var_i0 = w2c_rlboxsoundtouch_strdup_0(instance, var_i0);
    var_l1 = var_i0;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_L1;}
  var_B0:;
  var_i0 = var_l1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_xmemdup_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_moz_xmalloc_0(instance, var_i0);
  var_i1 = var_p0;
  var_i2 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_memcpy_0(instance, var_i0, var_i1, var_i2);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_malloc_usable_size_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_malloc_size_of_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_moz_malloc_enclosing_size_of_0(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_0x5F_cxa_pure_virtual_0(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = 263384u;
  var_i1 = 0u;
  w2c_rlboxsoundtouch_abort_message_0(instance, var_i0, var_i1);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxa_deleted_virtual_0(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = 263414u;
  var_i1 = 0u;
  w2c_rlboxsoundtouch_abort_message_0(instance, var_i0, var_i1);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_abort_message_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 16u;
  var_i0 -= var_i1;
  var_l2 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = 263447u;
  var_i1 = 11u;
  var_i2 = 1u;
  var_i3 = 0u;
  var_i3 = i32_load(instance->w2c_env_memory, (u64)(var_i3) + 271616u);
  var_l3 = var_i3;
  var_i0 = w2c_rlboxsoundtouch_fwrite_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_i0 = var_l2;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_l3;
  var_i1 = var_p0;
  var_i2 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_vfprintf_0(instance, var_i0, var_i1, var_i2);
  var_i0 = 10u;
  var_i1 = var_l3;
  var_i0 = w2c_rlboxsoundtouch_fputc_0(instance, var_i0, var_i1);
  w2c_rlboxsoundtouch_abort_0(instance);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 4u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263126u;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 4u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263107u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Abad_alloc0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = 264036u;
  var_i2 = 8u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 4u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263312u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Abad_array_new_length0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = 264056u;
  var_i2 = 8u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 4u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263145u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 8u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Abad_cast0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = 264240u;
  var_i2 = 8u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 4u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263001u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Abad_typeid0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i1 = 264260u;
  var_i2 = 8u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_p0;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(instance, var_i0);
  var_i0 = var_p0;
  var_i1 = 4u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 263215u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  UNREACHABLE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 8u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 8u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 8u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 8u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 8u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 12u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 24u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 16u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 16u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(instance, var_i0);
  var_i1 = 20u;
  w2c_rlboxsoundtouch_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(instance, var_i0, var_i1);
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0, var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  u64 var_j1;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 80u;
  var_i0 -= var_i1;
  var_l3 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = 1u;
  var_l4 = var_i0;
  goto var_B1;
  var_B2:;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264456u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B1;}
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l4 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l3;
  var_i1 = 32u;
  var_i0 += var_i1;
  var_l5 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 72u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 64u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 56u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 48u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 40u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l5;
  var_i1 = 4294967295u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l3;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_j1);
  var_i0 = var_l3;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 75, var_i1);
  var_i0 = var_l3;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 68, var_i1);
  var_i0 = var_l3;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_l3;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  var_i0 = var_p1;
  var_i1 = var_l3;
  var_i2 = 20u;
  var_i1 += var_i2;
  var_i2 = var_l4;
  var_i3 = 1u;
  var_i4 = var_p1;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 28u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 44u);
  var_p1 = var_i0;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p2;
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B3:;
  var_i0 = var_p1;
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  var_l4 = var_i0;
  var_B1:;
  var_i0 = var_l3;
  var_i1 = 80u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l4;
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_l3;
  var_i1 = 263335u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_l3;
  var_i1 = 485u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_l3;
  var_i1 = 263025u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = 263015u;
  var_i1 = var_l3;
  w2c_rlboxsoundtouch_abort_message_0(instance, var_i0, var_i1);
  UNREACHABLE;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6;
  u64 var_j1;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 64u;
  var_i0 -= var_i1;
  var_l4 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p0;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_l5 = var_i1;
  var_i2 = 4294967288u;
  var_i1 += var_i2;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_l6 = var_i1;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_l5;
  var_i1 = 4294967292u;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l8 = var_i0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p2;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_p3;
  var_i1 = 0u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B2;}
  var_i0 = var_l7;
  var_i1 = 0u;
  var_i2 = 0u;
  var_i3 = var_p3;
  var_i2 -= var_i3;
  var_i3 = var_l6;
  var_i2 = var_i2 == var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l5 = var_i0;
  goto var_B0;
  var_B2:;
  var_i0 = var_p3;
  var_i1 = 4294967294u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_l4;
  var_i1 = 28u;
  var_i0 += var_i1;
  var_l5 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 36u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 44u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_j1);
  var_i0 = var_l4;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 60, var_i1);
  var_i0 = var_l4;
  var_j1 = 72057594037927937ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 52, var_j1);
  var_i0 = var_l4;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_p2;
  var_i1 = var_l4;
  var_i2 = 4u;
  var_i1 += var_i2;
  var_i2 = var_l7;
  var_i3 = var_l7;
  var_i4 = 1u;
  var_i5 = 0u;
  var_i6 = var_p2;
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l7;
  var_i1 = 0u;
  var_i2 = var_l5;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2));
  var_i3 = 1u;
  var_i2 = var_i2 == var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l5 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = var_p3;
  var_i1 = 0u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i1 = var_p3;
  var_i0 -= var_i1;
  var_l5 = var_i0;
  var_i1 = var_l7;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B3;}
  var_i0 = var_l4;
  var_i1 = 44u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 36u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 28u;
  var_i0 += var_i1;
  var_l6 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_j1);
  var_i0 = var_l4;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 60, var_i1);
  var_i0 = var_l4;
  var_j1 = 72057594037927937ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 52, var_j1);
  var_i0 = var_l4;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_l4;
  var_i1 = var_l5;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_l4;
  var_i1 = var_l8;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_l8;
  var_i1 = var_l4;
  var_i2 = 4u;
  var_i1 += var_i2;
  var_i2 = var_l7;
  var_i3 = var_l7;
  var_i4 = 1u;
  var_i5 = 0u;
  var_i6 = var_l8;
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l6;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  if (var_i0) {goto var_B0;}
  var_B3:;
  var_i0 = var_l4;
  var_i1 = 51u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 44u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 36u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 28u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_j1);
  var_i0 = var_l4;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 60, var_i1);
  var_i0 = var_l4;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 59, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_i1);
  var_i0 = var_l4;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_l8;
  var_i1 = var_l4;
  var_i2 = 4u;
  var_i1 += var_i2;
  var_i2 = var_l7;
  var_i3 = 1u;
  var_i4 = 0u;
  var_i5 = var_l8;
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 40u);
  switch (var_i0) {
    case 0: goto var_B5;
    case 1: goto var_B4;
    default: goto var_B0;
  }
  var_B5:;
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 0u;
  var_i2 = var_l4;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 36u);
  var_i3 = 1u;
  var_i2 = var_i2 == var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_i1 = 0u;
  var_i2 = var_l4;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 32u);
  var_i3 = 1u;
  var_i2 = var_i2 == var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_i1 = 0u;
  var_i2 = var_l4;
  var_i2 = i32_load(instance->w2c_env_memory, (u64)(var_i2) + 44u);
  var_i3 = 1u;
  var_i2 = var_i2 == var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l5 = var_i0;
  goto var_B0;
  var_B4:;
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B6;}
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 44u);
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B7;}
  var_i0 = 0u;
  var_l5 = var_i0;
  goto var_B0;
  var_B7:;
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 32u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B8;}
  var_i0 = 0u;
  var_l5 = var_i0;
  goto var_B0;
  var_B8:;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_B6:;
  var_i0 = var_l4;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l5 = var_i0;
  var_B0:;
  var_i0 = var_l4;
  var_i1 = 64u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l5;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_found_base_class0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_l4 = var_i0;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_i0 = var_p1;
  var_i1 = 2u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_l4;
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_B1:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_p0 = var_i0;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_i0 = var_p1;
  var_i1 = 2u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_p0 = var_i0;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  goto var_Bfunc;
  var_B3:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_i0 = var_p1;
  var_i1 = 2u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_p0;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 28u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l4 = var_i0;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_l5 = var_i0;
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 55u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_l4;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l6 = var_i0;
  var_i0 = var_l5;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_l6;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = var_l5;
  if (var_i0) {goto var_B2;}
  var_i0 = var_l4;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l6 = var_i0;
  goto var_B0;
  var_B2:;
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
  var_i0 = 0u;
  var_l6 = var_i0;
  var_i0 = 0u;
  var_p2 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_l6;
  var_i2 += var_i3;
  var_i3 = var_p3;
  var_i4 = 2u;
  var_i5 = var_l4;
  var_i6 = 2u;
  var_i5 &= var_i6;
  var_i3 = var_i5 ? var_i3 : var_i4;
  var_i4 = var_p0;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 28u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  u32 var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_p0 = var_i0;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 56u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  goto var_Bfunc;
  var_B3:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_i0 = var_p1;
  var_i1 = 2u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l4 = var_i0;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_l5 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l6 = var_i0;
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 55u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B5;}
  var_i0 = var_l4;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l7 = var_i0;
  var_i0 = var_l5;
  if (var_i0) {goto var_B6;}
  var_i0 = var_p2;
  var_l5 = var_i0;
  goto var_B4;
  var_B6:;
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_l7;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l7 = var_i0;
  var_i0 = var_p2;
  var_l5 = var_i0;
  goto var_B4;
  var_B5:;
  var_i0 = var_l5;
  if (var_i0) {goto var_B7;}
  var_i0 = var_l4;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l7 = var_i0;
  var_i0 = var_p2;
  var_l5 = var_i0;
  goto var_B4;
  var_B7:;
  var_i0 = var_p1;
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
  var_i0 = 0u;
  var_l7 = var_i0;
  var_i0 = 0u;
  var_l5 = var_i0;
  var_B4:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l8 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_l5;
  var_i3 = var_l7;
  var_i2 += var_i3;
  var_i3 = var_p3;
  var_i4 = 2u;
  var_i5 = var_l4;
  var_i6 = 2u;
  var_i5 &= var_i6;
  var_i3 = var_i5 ? var_i3 : var_i4;
  var_i4 = var_l8;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 28u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l6;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_l6;
  var_i2 = 3u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l8 = var_i0;
  var_i0 = var_p0;
  var_i1 = 24u;
  var_i0 += var_i1;
  var_p0 = var_i0;
  var_L8: 
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_l4 = var_i0;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_l7 = var_i0;
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 55u);
    var_i1 = 1u;
    var_i0 = var_i0 != var_i1;
    if (var_i0) {goto var_B10;}
    var_i0 = var_l4;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_l6 = var_i0;
    var_i0 = var_l7;
    if (var_i0) {goto var_B11;}
    var_i0 = var_p2;
    var_l7 = var_i0;
    goto var_B9;
    var_B11:;
    var_i0 = var_p2;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l6 = var_i0;
    var_i0 = var_p2;
    var_l7 = var_i0;
    goto var_B9;
    var_B10:;
    var_i0 = var_l7;
    if (var_i0) {goto var_B12;}
    var_i0 = var_l4;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_l6 = var_i0;
    var_i0 = var_p2;
    var_l7 = var_i0;
    goto var_B9;
    var_B12:;
    var_i0 = var_p1;
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
    i32_store(instance->w2c_env_memory, (u64)(var_i0) + 56, var_i1);
    var_i0 = 0u;
    var_l6 = var_i0;
    var_i0 = 0u;
    var_l7 = var_i0;
    var_B9:;
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l5 = var_i0;
    var_i1 = var_p1;
    var_i2 = var_l7;
    var_i3 = var_l6;
    var_i2 += var_i3;
    var_i3 = var_p3;
    var_i4 = 2u;
    var_i5 = var_l4;
    var_i6 = 2u;
    var_i5 &= var_i6;
    var_i3 = var_i5 ? var_i3 : var_i4;
    var_i4 = var_l5;
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
    var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 28u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 54u);
    if (var_i0) {goto var_B0;}
    var_i0 = var_p0;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_p0 = var_i0;
    var_i1 = var_l8;
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L8;}
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = 24u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = 0u;
  var_l3 = var_i0;
  var_i0 = var_p1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264504u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_l4 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l4;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = 24u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = 1u;
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  var_i0 = !(var_i0);
  var_l3 = var_i0;
  var_B0:;
  var_i0 = var_l3;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0, var_l5 = 0, var_l6 = 0, var_l7 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4;
  u64 var_j1;
  var_i0 = instance->w2c_0x5F_stack_pointer;
  var_i1 = 64u;
  var_i0 -= var_i1;
  var_l3 = var_i0;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l4 = var_i0;
  var_i1 = 264848u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p2;
  var_i1 = 0u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = 1u;
  var_l4 = var_i0;
  goto var_B0;
  var_B1:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l5 = var_i0;
  var_i1 = 24u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264504u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_l6 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B2;}
  var_i0 = var_l6;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = 24u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l4;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  goto var_B2;
  var_B4:;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l4;
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B2;}
  var_B3:;
  var_i0 = 1u;
  var_l4 = var_i0;
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_p1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p2;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  goto var_B0;
  var_B2:;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264552u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = 0u;
  var_l6 = var_i0;
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l7 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B5;}
  var_i0 = var_p2;
  var_i1 = var_l7;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_l6 = var_i1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B5:;
  var_i0 = var_l5;
  var_i1 = 4294967295u;
  var_i0 ^= var_i1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_l7 = var_i1;
  var_i0 &= var_i1;
  var_i1 = 7u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_l5;
  var_i1 = var_l7;
  var_i2 = 4294967295u;
  var_i1 ^= var_i2;
  var_i0 &= var_i1;
  var_i1 = 96u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l7 = var_i0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_p1 = var_i1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B6;}
  var_i0 = 1u;
  var_l4 = var_i0;
  goto var_B0;
  var_B6:;
  var_i0 = var_p0;
  var_i1 = 264796u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264604u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_i0 = !(var_i0);
  var_l4 = var_i0;
  goto var_B0;
  var_B7:;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_l7;
  var_i1 = 264408u;
  var_i2 = 264552u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p0 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B8;}
  var_i0 = var_l5;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(instance, var_i0, var_i1);
  var_l4 = var_i0;
  goto var_B0;
  var_B8:;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_l7;
  var_i1 = 264408u;
  var_i2 = 264664u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p0 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B9;}
  var_i0 = var_l5;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(instance, var_i0, var_i1);
  var_l4 = var_i0;
  goto var_B0;
  var_B9:;
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_l7;
  var_i1 = 264408u;
  var_i2 = 264456u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p0 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = 0u;
  var_l4 = var_i0;
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264456u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_l3;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l4 = var_i0;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 56u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 48u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 40u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 32u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l3;
  var_i1 = 24u;
  var_i0 += var_i1;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0), var_j1);
  var_i0 = var_l4;
  var_i1 = 4294967295u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = var_l3;
  var_j1 = 0ull;
  i64_store(instance->w2c_env_memory, (u64)(var_i0) + 8, var_j1);
  var_i0 = var_l3;
  var_i1 = var_l6;
  var_i2 = 0u;
  var_i1 = var_i1 != var_i2;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 59, var_i1);
  var_i0 = var_l3;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_l3;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 4, var_i1);
  var_i0 = var_l3;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 12, var_i1);
  var_i0 = var_p1;
  var_i1 = var_l3;
  var_i2 = 4u;
  var_i1 += var_i2;
  var_i2 = var_l6;
  var_i3 = 1u;
  var_i4 = var_p1;
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4));
  var_i4 = i32_load(instance->w2c_env_memory, (u64)(var_i4) + 28u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32), w2c_rlboxsoundtouch_t0, var_i4, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i4].module_instance, var_i0, var_i1, var_i2, var_i3);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_p1 = var_i0;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B10;}
  var_i0 = var_p2;
  var_i1 = var_l3;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 20u);
  var_i2 = 0u;
  var_i3 = var_l6;
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_B10:;
  var_i0 = var_p1;
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  var_l4 = var_i0;
  var_B0:;
  var_i0 = var_l3;
  var_i1 = 64u;
  var_i0 += var_i1;
  instance->w2c_0x5F_stack_pointer = var_i0;
  var_i0 = var_l4;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0, var_l3 = 0, var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_L1: 
    var_i0 = var_p1;
    if (var_i0) {goto var_B2;}
    var_i0 = 0u;
    goto var_Bfunc;
    var_B2:;
    var_i0 = 0u;
    var_l2 = var_i0;
    var_i0 = var_p1;
    var_i1 = 264408u;
    var_i2 = 264552u;
    var_i3 = 0u;
    var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
    var_p1 = var_i0;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B0;}
    var_i0 = var_p1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = var_p0;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
    var_l3 = var_i1;
    var_i2 = 4294967295u;
    var_i1 ^= var_i2;
    var_i0 &= var_i1;
    if (var_i0) {goto var_B0;}
    var_i0 = var_p0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
    var_l4 = var_i0;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_i1 = var_p1;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
    var_p1 = var_i1;
    var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
    var_i0 = var_i0 != var_i1;
    if (var_i0) {goto var_B3;}
    var_i0 = 1u;
    goto var_Bfunc;
    var_B3:;
    var_i0 = var_l3;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B0;}
    var_i0 = var_l4;
    var_i1 = 264408u;
    var_i2 = 264552u;
    var_i3 = 0u;
    var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
    var_p0 = var_i0;
    if (var_i0) {goto var_L1;}
  var_i0 = 0u;
  var_l2 = var_i0;
  var_i0 = var_l4;
  var_i1 = 264408u;
  var_i2 = 264664u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p0 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(instance, var_i0, var_i1);
  var_l2 = var_i0;
  var_B0:;
  var_i0 = var_l2;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = 0u;
  var_l2 = var_i0;
  var_i0 = var_p1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264664u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = var_p0;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_i2 = 4294967295u;
  var_i1 ^= var_i2;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  var_l2 = var_i0;
  var_B0:;
  var_i0 = var_l2;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2) {
  u32 var_l3 = 0, var_l4 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l3 = var_i0;
  var_i1 = 264848u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_p0 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B2;}
  var_i0 = 264676u;
  var_p1 = var_i0;
  var_i0 = var_p0;
  var_i1 = 264408u;
  var_i2 = 264604u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  if (var_i0) {goto var_B1;}
  var_B2:;
  var_i0 = 264684u;
  var_p1 = var_i0;
  var_B1:;
  var_i0 = var_p2;
  var_i1 = var_p1;
  i32_store(instance->w2c_env_memory, (u64)(var_i0), var_i1);
  var_i0 = 1u;
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l4 = var_i0;
  var_i1 = 24u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264504u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p2 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B4;}
  var_i0 = var_p2;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_i1 = 24u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l3;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = 1u;
  goto var_Bfunc;
  var_B5:;
  var_i0 = 1u;
  var_p2 = var_i0;
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l3;
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B3;}
  var_B4:;
  var_i0 = 0u;
  var_p2 = var_i0;
  var_i0 = var_p1;
  var_i1 = 264408u;
  var_i2 = 264664u;
  var_i3 = 0u;
  var_i0 = w2c_rlboxsoundtouch_0x5F_dynamic_cast_0(instance, var_i0, var_i1, var_i2, var_i3);
  var_p1 = var_i0;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B3;}
  var_i0 = var_l4;
  var_i1 = 4294967295u;
  var_i0 ^= var_i1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 8u);
  var_l3 = var_i1;
  var_i0 &= var_i1;
  var_i1 = 7u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_l4;
  var_i1 = var_l3;
  var_i2 = 4294967295u;
  var_i1 ^= var_i2;
  var_i0 &= var_i1;
  var_i1 = 96u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 12u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 16u);
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  var_p2 = var_i0;
  var_B3:;
  var_i0 = var_p2;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 53, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p3;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_p3 = var_i0;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p4;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  goto var_B0;
  var_B2:;
  var_i0 = var_p3;
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_p3 = var_i0;
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p4;
  var_p3 = var_i0;
  var_B4:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p3;
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  goto var_B0;
  var_B3:;
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_B1:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  u32 var_l5 = 0, var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l9 = 0, var_l10 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6, var_i7;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l5 = var_i0;
  var_i0 = var_p4;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l6 = var_i0;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_l6;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  goto var_B1;
  var_B5:;
  var_i0 = var_l5;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l6 = var_i0;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B3;}
  var_B4:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  goto var_Bfunc;
  var_B3:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l5 = var_i0;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_l6;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B1;}
  var_B2:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B6;}
  var_B7:;
  var_i0 = var_p3;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  goto var_Bfunc;
  var_B6:;
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 44u);
  var_i1 = 4u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B8;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l5 = var_i0;
  var_i1 = 0u;
  var_i0 = (u32)((s32)var_i0 > (s32)var_i1);
  if (var_i0) {goto var_B9;}
  var_i0 = var_p1;
  var_i1 = 4u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  goto var_B8;
  var_B9:;
  var_i0 = var_p0;
  var_i1 = var_l5;
  var_i2 = 3u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l5 = var_i0;
  var_i0 = 0u;
  var_l8 = var_i0;
  var_i0 = 0u;
  var_l9 = var_i0;
  var_L11: 
    var_i0 = var_p1;
    var_i1 = 0u;
    i32_store16(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_l6 = var_i0;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_p3 = var_i0;
    var_i0 = var_l6;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B12;}
    var_i0 = var_p2;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_p3;
    var_i0 += var_i1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_p3 = var_i0;
    var_B12:;
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l10 = var_i0;
    var_i1 = var_p1;
    var_i2 = var_p2;
    var_i3 = var_p2;
    var_i4 = var_p3;
    var_i3 += var_i4;
    var_i4 = 1u;
    var_i5 = 2u;
    var_i6 = var_l6;
    var_i7 = 2u;
    var_i6 &= var_i7;
    var_i4 = var_i6 ? var_i4 : var_i5;
    var_i5 = var_p4;
    var_i6 = var_l10;
    var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
    var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 54u);
    if (var_i0) {goto var_B13;}
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 53u);
    var_i1 = 1u;
    var_i0 = var_i0 != var_i1;
    if (var_i0) {goto var_B14;}
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 52u);
    var_i1 = 1u;
    var_i0 = var_i0 != var_i1;
    if (var_i0) {goto var_B15;}
    var_i0 = var_p1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_i1 = 1u;
    var_i0 = var_i0 == var_i1;
    if (var_i0) {goto var_B16;}
    var_i0 = 1u;
    var_l9 = var_i0;
    var_i0 = 1u;
    var_l8 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = 2u;
    var_i0 &= var_i1;
    if (var_i0) {goto var_B14;}
    var_B16:;
    var_i0 = var_p1;
    var_i1 = 3u;
    i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
    goto var_Bfunc;
    var_B15:;
    var_i0 = 1u;
    var_l9 = var_i0;
    var_i0 = var_p0;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B10;}
    var_B14:;
    var_i0 = var_l5;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_l7;
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L11;}
    var_B13:;
  var_i0 = var_p1;
  var_i1 = 3u;
  var_i2 = 4u;
  var_i3 = var_l9;
  var_i4 = 1u;
  var_i3 &= var_i4;
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_i0 = var_l8;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B8;}
  goto var_B0;
  var_B10:;
  var_i0 = var_p1;
  var_i1 = 3u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_i0 = var_l8;
  var_i1 = 1u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B0;}
  var_B8:;
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 40, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l5 = var_i0;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l6 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l10 = var_i0;
  var_i0 = var_l5;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B17;}
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_l6;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_B17:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l7 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_l6;
  var_i2 += var_i3;
  var_i3 = var_p3;
  var_i4 = 2u;
  var_i5 = var_l5;
  var_i6 = 2u;
  var_i5 &= var_i6;
  var_i3 = var_i5 ? var_i3 : var_i4;
  var_i4 = var_p4;
  var_i5 = var_l7;
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_l10;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p0;
  var_i1 = var_l10;
  var_i2 = 3u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l7 = var_i0;
  var_i0 = var_p0;
  var_i1 = 24u;
  var_i0 += var_i1;
  var_l5 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_p0 = var_i0;
  var_i1 = 2u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B19;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B18;}
  var_B19:;
  var_L20: 
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 54u);
    if (var_i0) {goto var_B0;}
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_p0 = var_i0;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_l6 = var_i0;
    var_i0 = var_p0;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B21;}
    var_i0 = var_p2;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l6 = var_i0;
    var_B21:;
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l10 = var_i0;
    var_i1 = var_p1;
    var_i2 = var_p2;
    var_i3 = var_l6;
    var_i2 += var_i3;
    var_i3 = var_p3;
    var_i4 = 2u;
    var_i5 = var_p0;
    var_i6 = 2u;
    var_i5 &= var_i6;
    var_i3 = var_i5 ? var_i3 : var_i4;
    var_i4 = var_p4;
    var_i5 = var_l10;
    var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
    var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_l5;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_l7;
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L20;}
    goto var_B0;
  var_B18:;
  var_i0 = var_p0;
  var_i1 = 1u;
  var_i0 &= var_i1;
  if (var_i0) {goto var_B22;}
  var_L23: 
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 54u);
    if (var_i0) {goto var_B0;}
    var_i0 = var_p1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
    var_i1 = 1u;
    var_i0 = var_i0 == var_i1;
    if (var_i0) {goto var_B0;}
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_p0 = var_i0;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_l6 = var_i0;
    var_i0 = var_p0;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B24;}
    var_i0 = var_p2;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l6 = var_i0;
    var_B24:;
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l10 = var_i0;
    var_i1 = var_p1;
    var_i2 = var_p2;
    var_i3 = var_l6;
    var_i2 += var_i3;
    var_i3 = var_p3;
    var_i4 = 2u;
    var_i5 = var_p0;
    var_i6 = 2u;
    var_i5 &= var_i6;
    var_i3 = var_i5 ? var_i3 : var_i4;
    var_i4 = var_p4;
    var_i5 = var_l10;
    var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
    var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_l5;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_l7;
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L23;}
    goto var_B0;
  var_B22:;
  var_L25: 
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 54u);
    if (var_i0) {goto var_B0;}
    var_i0 = var_p1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
    var_i1 = 1u;
    var_i0 = var_i0 != var_i1;
    if (var_i0) {goto var_B26;}
    var_i0 = var_p1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_i1 = 1u;
    var_i0 = var_i0 == var_i1;
    if (var_i0) {goto var_B0;}
    var_B26:;
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_p0 = var_i0;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_l6 = var_i0;
    var_i0 = var_p0;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B27;}
    var_i0 = var_p2;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_l6;
    var_i0 += var_i1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l6 = var_i0;
    var_B27:;
    var_i0 = var_l5;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l10 = var_i0;
    var_i1 = var_p1;
    var_i2 = var_p2;
    var_i3 = var_l6;
    var_i2 += var_i3;
    var_i3 = var_p3;
    var_i4 = 2u;
    var_i5 = var_p0;
    var_i6 = 2u;
    var_i5 &= var_i6;
    var_i3 = var_i5 ? var_i3 : var_i4;
    var_i4 = var_p4;
    var_i5 = var_l10;
    var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
    var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_l5;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l5 = var_i0;
    var_i1 = var_l7;
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L25;}
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
  u32 var_l6 = 0, var_l7 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6, var_i7;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l6 = var_i0;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l7 = var_i0;
  var_i0 = var_l6;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_l7;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l7 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_l7;
  var_i3 += var_i4;
  var_i4 = var_p4;
  var_i5 = 2u;
  var_i6 = var_l6;
  var_i7 = 2u;
  var_i6 &= var_i7;
  var_i4 = var_i6 ? var_i4 : var_i5;
  var_i5 = var_p5;
  var_i6 = var_p0;
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  u32 var_l5 = 0, var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l5 = var_i0;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l6 = var_i0;
  var_i0 = var_l5;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B0;}
  var_i0 = var_p2;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_l6;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l6 = var_i0;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_l6;
  var_i2 += var_i3;
  var_i3 = var_p3;
  var_i4 = 2u;
  var_i5 = var_l5;
  var_i6 = 2u;
  var_i5 &= var_i6;
  var_i3 = var_i5 ? var_i3 : var_i4;
  var_i4 = var_p4;
  var_i5 = var_p0;
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  u32 var_l5 = 0, var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l5 = var_i0;
  var_i0 = var_p4;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l6 = var_i0;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_l6;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  goto var_B0;
  var_B5:;
  var_i0 = var_l5;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_l6 = var_i0;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B3;}
  var_B4:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  goto var_Bfunc;
  var_B3:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l5 = var_i0;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_l6;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B0;}
  var_B2:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B6;}
  var_B7:;
  var_i0 = var_p3;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  goto var_Bfunc;
  var_B6:;
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 44u);
  var_i1 = 4u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B8;}
  var_i0 = var_p1;
  var_i1 = 0u;
  i32_store16(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p2;
  var_i4 = 1u;
  var_i5 = var_p4;
  var_i6 = var_p0;
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 53u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B9;}
  var_i0 = var_p1;
  var_i1 = 3u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 52u);
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B8;}
  goto var_B1;
  var_B9:;
  var_i0 = var_p1;
  var_i1 = 4u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_B8:;
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 40, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_B1:;
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_p4;
  var_i5 = var_p0;
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5));
  var_i5 = i32_load(instance->w2c_env_memory, (u64)(var_i5) + 24u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t12, var_i5, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i5].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4) {
  u32 var_l5 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l5 = var_i0;
  var_i0 = var_p4;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p0 = var_i0;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1));
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  goto var_B0;
  var_B4:;
  var_i0 = var_l5;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_p4 = var_i0;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B2;}
  var_B3:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 28u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 28, var_i1);
  goto var_Bfunc;
  var_B2:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l5 = var_i0;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p4;
  var_i1 = var_l5;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B0;}
  var_B1:;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_i1 = var_p2;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B6;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B5;}
  var_B6:;
  var_i0 = var_p3;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  goto var_Bfunc;
  var_B5:;
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 20, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p3;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 32, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 40u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 40, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 36u);
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_B7:;
  var_i0 = var_p1;
  var_i1 = 4u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 44, var_i1);
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
  u32 var_l6 = 0, var_l7 = 0, var_l8 = 0, var_l9 = 0, var_l10 = 0, var_l11 = 0, var_l12 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6, var_i7;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l6 = var_i0;
  var_i0 = var_p5;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l6;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  goto var_B1;
  var_B3:;
  var_i0 = var_l6;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l6;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B1;}
  var_B2:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 53, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p3;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l6 = var_i0;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p4;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  goto var_B0;
  var_B5:;
  var_i0 = var_l6;
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B6;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_l6 = var_i0;
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p4;
  var_l6 = var_i0;
  var_B7:;
  var_i0 = var_l6;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  goto var_B0;
  var_B6:;
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_B4:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  goto var_Bfunc;
  var_B1:;
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 53u);
  var_l7 = var_i0;
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 52u);
  var_l8 = var_i0;
  var_i0 = var_p1;
  var_i1 = 0u;
  i32_store16(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 20u);
  var_l6 = var_i0;
  var_i1 = 8u;
  var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
  var_l9 = var_i0;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 12u);
  var_l10 = var_i0;
  var_i0 = var_l6;
  var_i1 = 1u;
  var_i0 &= var_i1;
  var_i0 = !(var_i0);
  if (var_i0) {goto var_B8;}
  var_i0 = var_p3;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_i1 = var_l9;
  var_i0 += var_i1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
  var_l9 = var_i0;
  var_B8:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_l11 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_l9;
  var_i3 += var_i4;
  var_i4 = var_p4;
  var_i5 = 2u;
  var_i6 = var_l6;
  var_i7 = 2u;
  var_i6 &= var_i7;
  var_i4 = var_i6 ? var_i4 : var_i5;
  var_i5 = var_p5;
  var_i6 = var_l11;
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 52u);
  var_l9 = var_i0;
  var_i1 = var_l8;
  var_i0 |= var_i1;
  var_l11 = var_i0;
  var_i0 = var_p1;
  var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 53u);
  var_l8 = var_i0;
  var_i1 = var_l7;
  var_i0 |= var_i1;
  var_l7 = var_i0;
  var_i0 = var_l10;
  var_i1 = 2u;
  var_i0 = (u32)((s32)var_i0 < (s32)var_i1);
  if (var_i0) {goto var_B9;}
  var_i0 = var_p0;
  var_i1 = var_l10;
  var_i2 = 3u;
  var_i1 <<= (var_i2 & 31);
  var_i0 += var_i1;
  var_i1 = 16u;
  var_i0 += var_i1;
  var_l12 = var_i0;
  var_i0 = var_p0;
  var_i1 = 24u;
  var_i0 += var_i1;
  var_l6 = var_i0;
  var_L10: 
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 54u);
    if (var_i0) {goto var_B9;}
    var_i0 = var_l9;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B12;}
    var_i0 = var_p1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
    var_i1 = 1u;
    var_i0 = var_i0 == var_i1;
    if (var_i0) {goto var_B9;}
    var_i0 = var_p0;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = 2u;
    var_i0 &= var_i1;
    if (var_i0) {goto var_B11;}
    goto var_B9;
    var_B12:;
    var_i0 = var_l8;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B11;}
    var_i0 = var_p0;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 8u);
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B9;}
    var_B11:;
    var_i0 = var_p1;
    var_i1 = 0u;
    i32_store16(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
    var_i0 = var_l6;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
    var_l8 = var_i0;
    var_i1 = 8u;
    var_i0 = (u32)((s32)var_i0 >> (var_i1 & 31));
    var_l9 = var_i0;
    var_i0 = var_l8;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B13;}
    var_i0 = var_p3;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_i1 = var_l9;
    var_i0 += var_i1;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l9 = var_i0;
    var_B13:;
    var_i0 = var_l6;
    var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0));
    var_l10 = var_i0;
    var_i1 = var_p1;
    var_i2 = var_p2;
    var_i3 = var_p3;
    var_i4 = var_l9;
    var_i3 += var_i4;
    var_i4 = var_p4;
    var_i5 = 2u;
    var_i6 = var_l8;
    var_i7 = 2u;
    var_i6 &= var_i7;
    var_i4 = var_i6 ? var_i4 : var_i5;
    var_i5 = var_p5;
    var_i6 = var_l10;
    var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
    var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 53u);
    var_l8 = var_i0;
    var_i1 = var_l7;
    var_i0 |= var_i1;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_l7 = var_i0;
    var_i0 = var_p1;
    var_i0 = i32_load8_u(instance->w2c_env_memory, (u64)(var_i0) + 52u);
    var_l9 = var_i0;
    var_i1 = var_l11;
    var_i0 |= var_i1;
    var_i1 = 1u;
    var_i0 &= var_i1;
    var_l11 = var_i0;
    var_i0 = var_l6;
    var_i1 = 8u;
    var_i0 += var_i1;
    var_l6 = var_i0;
    var_i1 = var_l12;
    var_i0 = var_i0 < var_i1;
    if (var_i0) {goto var_L10;}
  var_B9:;
  var_i0 = var_p1;
  var_i1 = var_l7;
  var_i2 = 1u;
  var_i1 &= var_i2;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 53, var_i1);
  var_i0 = var_p1;
  var_i1 = var_l11;
  var_i2 = 1u;
  var_i1 &= var_i2;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_B0:;
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
  u32 var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3, var_i4, var_i5, var_i6;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l6 = var_i0;
  var_i0 = var_p5;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l6;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  goto var_B0;
  var_B2:;
  var_i0 = var_l6;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l6;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B0;}
  var_B1:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 53, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p3;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_p0 = var_i0;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p4;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  goto var_B3;
  var_B5:;
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B6;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_p0 = var_i0;
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B7;}
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p4;
  var_p0 = var_i0;
  var_B7:;
  var_i0 = var_p0;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B3;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B4;}
  goto var_B3;
  var_B6:;
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_B4:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_B3:;
  goto var_Bfunc;
  var_B0:;
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_p0 = var_i0;
  var_i1 = var_p1;
  var_i2 = var_p2;
  var_i3 = var_p3;
  var_i4 = var_p4;
  var_i5 = var_p5;
  var_i6 = var_p0;
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6));
  var_i6 = i32_load(instance->w2c_env_memory, (u64)(var_i6) + 20u);
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*, u32, u32, u32, u32, u32, u32), w2c_rlboxsoundtouch_t11, var_i6, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i6].module_instance, var_i0, var_i1, var_i2, var_i3, var_i4, var_i5);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_Bfunc:;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1, u32 var_p2, u32 var_p3, u32 var_p4, u32 var_p5) {
  u32 var_l6 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2;
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 8u);
  var_l6 = var_i0;
  var_i0 = var_p5;
  if (var_i0) {goto var_B2;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l6;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  goto var_B0;
  var_B2:;
  var_i0 = var_l6;
  var_i1 = var_p0;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B1;}
  var_i0 = var_p0;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_l6;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 4u);
  var_i0 = w2c_rlboxsoundtouch_strcmp_0(instance, var_i0, var_i1);
  if (var_i0) {goto var_B0;}
  var_B1:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 53, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 4u);
  var_i1 = var_p3;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 52, var_i1);
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 16u);
  var_p0 = var_i0;
  if (var_i0) {goto var_B4;}
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p1;
  var_i1 = var_p2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 16, var_i1);
  var_i0 = var_p4;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  goto var_B0;
  var_B4:;
  var_i0 = var_p0;
  var_i1 = var_p2;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B5;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 24u);
  var_p0 = var_i0;
  var_i1 = 2u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B6;}
  var_i0 = var_p1;
  var_i1 = var_p4;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 24, var_i1);
  var_i0 = var_p4;
  var_p0 = var_i0;
  var_B6:;
  var_i0 = var_p0;
  var_i1 = 1u;
  var_i0 = var_i0 != var_i1;
  if (var_i0) {goto var_B0;}
  var_i0 = var_p1;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 48u);
  var_i1 = 1u;
  var_i0 = var_i0 == var_i1;
  if (var_i0) {goto var_B3;}
  goto var_B0;
  var_B5:;
  var_i0 = var_p1;
  var_i1 = var_p1;
  var_i1 = i32_load(instance->w2c_env_memory, (u64)(var_i1) + 36u);
  var_i2 = 1u;
  var_i1 += var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 36, var_i1);
  var_B3:;
  var_i0 = var_p1;
  var_i1 = 1u;
  i32_store8(instance->w2c_env_memory, (u64)(var_i0) + 54, var_i1);
  var_B0:;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aset_unexpected0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273832u);
  var_l1 = var_i0;
  var_i0 = 0u;
  var_i1 = var_p0;
  var_i2 = 136u;
  var_i3 = var_p0;
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 273832, var_i1);
  var_i0 = var_l1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aset_terminate0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273828u);
  var_l1 = var_i0;
  var_i0 = 0u;
  var_i1 = var_p0;
  var_i2 = 137u;
  var_i3 = var_p0;
  var_i1 = var_i3 ? var_i1 : var_i2;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 273828, var_i1);
  var_i0 = var_l1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aset_new_handler0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 274088u);
  var_l1 = var_i0;
  var_i0 = 0u;
  var_i1 = var_p0;
  i32_store(instance->w2c_env_memory, (u64)(var_i0) + 274088, var_i1);
  var_i0 = var_l1;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aget_unexpected0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273832u);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3A_0x5Funexpected0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*), w2c_rlboxsoundtouch_t13, var_i0, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i0].module_instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = 263271u;
  var_i1 = 0u;
  w2c_rlboxsoundtouch_abort_message_0(instance, var_i0, var_i1);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_std0x3A0x3Aunexpected0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273832u);
  w2c_rlboxsoundtouch_std0x3A0x3A_0x5Funexpected0x28void0x200x280x2A0x290x280x290x29(instance, var_i0);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aget_terminate0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273828u);
  FUNC_EPILOGUE;
  return var_i0;
}

void w2c_rlboxsoundtouch_std0x3A0x3A_0x5Fterminate0x28void0x200x280x2A0x290x280x290x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  FUNC_PROLOGUE;
  u32 var_i0, var_i1;
  var_i0 = var_p0;
  CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*), w2c_rlboxsoundtouch_t13, var_i0, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i0].module_instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
  wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
  var_i0 = 263231u;
  var_i1 = 0u;
  w2c_rlboxsoundtouch_abort_message_0(instance, var_i0, var_i1);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

void w2c_rlboxsoundtouch_std0x3A0x3Aterminate0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 273828u);
  w2c_rlboxsoundtouch_std0x3A0x3A_0x5Fterminate0x28void0x200x280x2A0x290x280x290x29(instance, var_i0);
  UNREACHABLE;
  FUNC_EPILOGUE;
}

u32 w2c_rlboxsoundtouch_std0x3A0x3Aget_new_handler0x280x29(w2c_rlboxsoundtouch* instance) {
  FUNC_PROLOGUE;
  u32 var_i0;
  var_i0 = 0u;
  var_i0 = i32_load(instance->w2c_env_memory, (u64)(var_i0) + 274088u);
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x29(w2c_rlboxsoundtouch* instance, u32 var_p0) {
  u32 var_l1 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = 1u;
  var_i2 = var_p0;
  var_i3 = 1u;
  var_i2 = var_i2 > var_i3;
  var_i0 = var_i2 ? var_i0 : var_i1;
  var_l1 = var_i0;
  var_L2: 
    var_i0 = var_l1;
    var_i0 = w2c_rlboxsoundtouch_malloc_0(instance, var_i0);
    var_p0 = var_i0;
    if (var_i0) {goto var_B1;}
    var_i0 = w2c_rlboxsoundtouch_std0x3A0x3Aget_new_handler0x280x29(instance);
    var_p0 = var_i0;
    var_i0 = !(var_i0);
    if (var_i0) {goto var_B0;}
    var_i0 = var_p0;
    CALL_INDIRECT((*instance->w2c_env_0x5F_indirect_function_table), void (*)(void*), w2c_rlboxsoundtouch_t13, var_i0, (*instance->w2c_env_0x5F_indirect_function_table).data[var_i0].module_instance);
#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
    wasm_rt_segue_write_base((*instance->w2c_env_memory).data);
#endif
    goto var_L2;
  var_B1:;
  var_i0 = var_p0;
  goto var_Bfunc;
  var_B0:;
  var_i0 = 263170u;
  var_i1 = 0u;
  w2c_rlboxsoundtouch_abort_message_0(instance, var_i0, var_i1);
  UNREACHABLE;
  var_Bfunc:;
  FUNC_EPILOGUE;
  return var_i0;
}

u32 w2c_rlboxsoundtouch_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlboxsoundtouch* instance, u32 var_p0, u32 var_p1) {
  u32 var_l2 = 0;
  FUNC_PROLOGUE;
  u32 var_i0, var_i1, var_i2, var_i3;
  var_i0 = var_p0;
  var_i1 = 1u;
  var_i2 = var_p0;
  var