//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef RemoteWorkerTypes_h
#define RemoteWorkerTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/OriginTrialsIPCUtils.h"
#include "mozilla/StorageAccess.h"
#include "mozilla/dom/WorkerBinding.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "nsRFPService.h"
#include "mozilla/dom/ClientIPCTypes.h"
#include "mozilla/dom/IPCServiceWorkerDescriptor.h"
#include "mozilla/dom/IPCServiceWorkerRegistrationDescriptor.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"
#include "mozilla/ipc/URIParams.h"
#include "mozilla/dom/DOMTypes.h"
#include "mozilla/net/NeckoChannelParams.h"
#include "mozilla/ipc/ProtocolTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ServiceWorkerData|
//
namespace mozilla {
namespace dom {
class ServiceWorkerData final
{
private:
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;
    typedef ::mozilla::dom::IPCServiceWorkerRegistrationDescriptor IPCServiceWorkerRegistrationDescriptor;
    typedef ::nsString nsString;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ServiceWorkerData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ServiceWorkerData(
            const IPCServiceWorkerDescriptor& _descriptor,
            const IPCServiceWorkerRegistrationDescriptor& _registrationDescriptor,
            const nsString& _cacheName,
            const uint32_t& _loadFlags,
            const nsString& _id) :
        descriptor_(_descriptor),
        registrationDescriptor_(_registrationDescriptor),
        cacheName_(_cacheName),
        id_(_id),
        loadFlags_(_loadFlags)
    {
    }

    MOZ_IMPLICIT ServiceWorkerData(
            IPCServiceWorkerDescriptor&& _descriptor,
            IPCServiceWorkerRegistrationDescriptor&& _registrationDescriptor,
            nsString&& _cacheName,
            uint32_t&& _loadFlags,
            nsString&& _id) :
        descriptor_(std::move(_descriptor)),
        registrationDescriptor_(std::move(_registrationDescriptor)),
        cacheName_(std::move(_cacheName)),
        id_(std::move(_id)),
        loadFlags_(std::move(_loadFlags))
    {
    }

    IPCServiceWorkerDescriptor&
    descriptor()
    {
        return descriptor_;
    }
    const IPCServiceWorkerDescriptor&
    descriptor() const
    {
        return descriptor_;
    }

    IPCServiceWorkerRegistrationDescriptor&
    registrationDescriptor()
    {
        return registrationDescriptor_;
    }
    const IPCServiceWorkerRegistrationDescriptor&
    registrationDescriptor() const
    {
        return registrationDescriptor_;
    }

    nsString&
    cacheName()
    {
        return cacheName_;
    }
    const nsString&
    cacheName() const
    {
        return cacheName_;
    }

    uint32_t&
    loadFlags()
    {
        return loadFlags_;
    }
    const uint32_t&
    loadFlags() const
    {
        return loadFlags_;
    }

    nsString&
    id()
    {
        return id_;
    }
    const nsString&
    id() const
    {
        return id_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerDescriptor> descriptor_;
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerRegistrationDescriptor> registrationDescriptor_;
    ::mozilla::ipc::IPDLStructMember<nsString> cacheName_;
    ::mozilla::ipc::IPDLStructMember<nsString> id_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> loadFlags_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ServiceWorkerData>
{
    typedef ::mozilla::dom::ServiceWorkerData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OptionalServiceWorkerData|
//
namespace mozilla {
namespace dom {
class OptionalServiceWorkerData final
{
public:
    enum Type {
        T__None,
        Tvoid_t = 1,
        TServiceWorkerData,
        T__Last = TServiceWorkerData
    };

private:
    typedef ::mozilla::void_t void_t;
    typedef ::mozilla::dom::ServiceWorkerData ServiceWorkerData;
    typedef void_t void_t__tdef;
    typedef ServiceWorkerData ServiceWorkerData__tdef;

    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }
    ServiceWorkerData*
    ptr_ServiceWorkerData()
    {
        return (&(mVServiceWorkerData));
    }
    const ServiceWorkerData*
    constptr_ServiceWorkerData() const
    {
        return (&(mVServiceWorkerData));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OptionalServiceWorkerData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OptionalServiceWorkerData(const void_t& aOther);

    MOZ_IMPLICIT OptionalServiceWorkerData(void_t&& aOther);

    MOZ_IMPLICIT OptionalServiceWorkerData(const ServiceWorkerData& aOther);

    MOZ_IMPLICIT OptionalServiceWorkerData(ServiceWorkerData&& aOther);

    MOZ_IMPLICIT OptionalServiceWorkerData(const OptionalServiceWorkerData& aOther);

    MOZ_IMPLICIT OptionalServiceWorkerData(OptionalServiceWorkerData&& aOther);

    ~OptionalServiceWorkerData();

    Type
    type() const
    {
        return mType;
    }

    OptionalServiceWorkerData&
    operator=(const void_t& aRhs);

    OptionalServiceWorkerData&
    operator=(void_t&& aRhs);

    OptionalServiceWorkerData&
    operator=(const ServiceWorkerData& aRhs);

    OptionalServiceWorkerData&
    operator=(ServiceWorkerData&& aRhs);

    OptionalServiceWorkerData&
    operator=(const OptionalServiceWorkerData& aRhs);

    OptionalServiceWorkerData&
    operator=(OptionalServiceWorkerData&& aRhs);

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

    ServiceWorkerData&
    get_ServiceWorkerData()
    {
        AssertSanity(TServiceWorkerData);
        return (*(ptr_ServiceWorkerData()));
    }
    const ServiceWorkerData&
    get_ServiceWorkerData() const
    {
        AssertSanity(TServiceWorkerData);
        return (*(constptr_ServiceWorkerData()));
    }
    operator ServiceWorkerData&()
    {
        return get_ServiceWorkerData();
    }
    operator const ServiceWorkerData&() const
    {
        return get_ServiceWorkerData();
    }

private:
    union {
        void_t mVvoid_t;
        ServiceWorkerData mVServiceWorkerData;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::OptionalServiceWorkerData>
{
    typedef ::mozilla::dom::OptionalServiceWorkerData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct RemoteWorkerData|
//
namespace mozilla {
namespace dom {
class RemoteWorkerData final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::ipc::URIParams URIParams;
    typedef ::mozilla::dom::WorkerOptions WorkerOptions;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::net::CookieJarSettingsArgs CookieJarSettingsArgs;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::IPCClientInfo IPCClientInfo;
    typedef ::nsIReferrerInfo nsIReferrerInfo;
    typedef ::mozilla::StorageAccess StorageAccess;
    typedef ::mozilla::RFPTargetSet RFPTargetSet;
    typedef ::mozilla::OriginTrials OriginTrials;
    typedef ::mozilla::dom::OptionalServiceWorkerData OptionalServiceWorkerData;
    typedef ::nsID nsID;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    RemoteWorkerData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT RemoteWorkerData(
            const nsString& _originalScriptURL,
            const URIParams& _baseScriptURL,
            const URIParams& _resolvedScriptURL,
            const WorkerOptions& _workerOptions,
            const PrincipalInfo& _loadingPrincipalInfo,
            const PrincipalInfo& _principalInfo,
            const PrincipalInfo& _partitionedPrincipalInfo,
            const bool& _useRegularPrincipal,
            const bool& _usingStorageAccess,
            const CookieJarSettingsArgs& _cookieJarSettings,
            const nsCString& _domain,
            const bool& _isSecureContext,
            const mozilla::Maybe<IPCClientInfo>& _clientInfo,
            nsIReferrerInfo* _referrerInfo,
            const StorageAccess& _storageAccess,
            const bool& _isThirdPartyContext,
            const bool& _shouldResistFingerprinting,
            const mozilla::Maybe<RFPTargetSet>& _overriddenFingerprintingSettings,
            const bool& _isOn3PCBExceptionList,
            const OriginTrials& _originTrials,
            const OptionalServiceWorkerData& _serviceWorkerData,
            const nsID& _agentClusterId,
            const nsCString& _remoteType) :
        originalScriptURL_(_originalScriptURL),
        baseScriptURL_(_baseScriptURL),
        resolvedScriptURL_(_resolvedScriptURL),
        workerOptions_(_workerOptions),
        loadingPrincipalInfo_(_loadingPrincipalInfo),
        principalInfo_(_principalInfo),
        partitionedPrincipalInfo_(_partitionedPrincipalInfo),
        useRegularPrincipal_(_useRegularPrincipal),
        usingStorageAccess_(_usingStorageAccess),
        cookieJarSettings_(_cookieJarSettings),
        domain_(_domain),
        isSecureContext_(_isSecureContext),
        clientInfo_(_clientInfo),
        referrerInfo_(_referrerInfo),
        storageAccess_(_storageAccess),
        isThirdPartyContext_(_isThirdPartyContext),
        shouldResistFingerprinting_(_shouldResistFingerprinting),
        overriddenFingerprintingSettings_(_overriddenFingerprintingSettings),
        isOn3PCBExceptionList_(_isOn3PCBExceptionList),
        originTrials_(_originTrials),
        serviceWorkerData_(_serviceWorkerData),
        agentClusterId_(_agentClusterId),
        remoteType_(_remoteType)
    {
    }

    MOZ_IMPLICIT RemoteWorkerData(
            nsString&& _originalScriptURL,
            URIParams&& _baseScriptURL,
            URIParams&& _resolvedScriptURL,
            WorkerOptions&& _workerOptions,
            PrincipalInfo&& _loadingPrincipalInfo,
            PrincipalInfo&& _principalInfo,
            PrincipalInfo&& _partitionedPrincipalInfo,
            bool&& _useRegularPrincipal,
            bool&& _usingStorageAccess,
            CookieJarSettingsArgs&& _cookieJarSettings,
            nsCString&& _domain,
            bool&& _isSecureContext,
            mozilla::Maybe<IPCClientInfo>&& _clientInfo,
            RefPtr<nsIReferrerInfo>&& _referrerInfo,
            StorageAccess&& _storageAccess,
            bool&& _isThirdPartyContext,
            bool&& _shouldResistFingerprinting,
            mozilla::Maybe<RFPTargetSet>&& _overriddenFingerprintingSettings,
            bool&& _isOn3PCBExceptionList,
            OriginTrials&& _originTrials,
            OptionalServiceWorkerData&& _serviceWorkerData,
            nsID&& _agentClusterId,
            nsCString&& _remoteType) :
        originalScriptURL_(std::move(_originalScriptURL)),
        baseScriptURL_(std::move(_baseScriptURL)),
        resolvedScriptURL_(std::move(_resolvedScriptURL)),
        workerOptions_(std::move(_workerOptions)),
        loadingPrincipalInfo_(std::move(_loadingPrincipalInfo)),
        principalInfo_(std::move(_principalInfo)),
        partitionedPrincipalInfo_(std::move(_partitionedPrincipalInfo)),
        useRegularPrincipal_(std::move(_useRegularPrincipal)),
        usingStorageAccess_(std::move(_usingStorageAccess)),
        cookieJarSettings_(std::move(_cookieJarSettings)),
        domain_(std::move(_domain)),
        isSecureContext_(std::move(_isSecureContext)),
        clientInfo_(std::move(_clientInfo)),
        referrerInfo_(std::move(_referrerInfo)),
        storageAccess_(std::move(_storageAccess)),
        isThirdPartyContext_(std::move(_isThirdPartyContext)),
        shouldResistFingerprinting_(std::move(_shouldResistFingerprinting)),
        overriddenFingerprintingSettings_(std::move(_overriddenFingerprintingSettings)),
        isOn3PCBExceptionList_(std::move(_isOn3PCBExceptionList)),
        originTrials_(std::move(_originTrials)),
        serviceWorkerData_(std::move(_serviceWorkerData)),
        agentClusterId_(std::move(_agentClusterId)),
        remoteType_(std::move(_remoteType))
    {
    }

    nsString&
    originalScriptURL()
    {
        return originalScriptURL_;
    }
    const nsString&
    originalScriptURL() const
    {
        return originalScriptURL_;
    }

    URIParams&
    baseScriptURL()
    {
        return baseScriptURL_;
    }
    const URIParams&
    baseScriptURL() const
    {
        return baseScriptURL_;
    }

    URIParams&
    resolvedScriptURL()
    {
        return resolvedScriptURL_;
    }
    const URIParams&
    resolvedScriptURL() const
    {
        return resolvedScriptURL_;
    }

    WorkerOptions&
    workerOptions()
    {
        return workerOptions_;
    }
    const WorkerOptions&
    workerOptions() const
    {
        return workerOptions_;
    }

    PrincipalInfo&
    loadingPrincipalInfo()
    {
        return loadingPrincipalInfo_;
    }
    const PrincipalInfo&
    loadingPrincipalInfo() const
    {
        return loadingPrincipalInfo_;
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

    PrincipalInfo&
    partitionedPrincipalInfo()
    {
        return partitionedPrincipalInfo_;
    }
    const PrincipalInfo&
    partitionedPrincipalInfo() const
    {
        return partitionedPrincipalInfo_;
    }

    bool&
    useRegularPrincipal()
    {
        return useRegularPrincipal_;
    }
    const bool&
    useRegularPrincipal() const
    {
        return useRegularPrincipal_;
    }

    bool&
    usingStorageAccess()
    {
        return usingStorageAccess_;
    }
    const bool&
    usingStorageAccess() const
    {
        return usingStorageAccess_;
    }

    CookieJarSettingsArgs&
    cookieJarSettings()
    {
        return cookieJarSettings_;
    }
    const CookieJarSettingsArgs&
    cookieJarSettings() const
    {
        return cookieJarSettings_;
    }

    nsCString&
    domain()
    {
        return domain_;
    }
    const nsCString&
    domain() const
    {
        return domain_;
    }

    bool&
    isSecureContext()
    {
        return isSecureContext_;
    }
    const bool&
    isSecureContext() const
    {
        return isSecureContext_;
    }

    mozilla::Maybe<IPCClientInfo>&
    clientInfo()
    {
        return clientInfo_;
    }
    const mozilla::Maybe<IPCClientInfo>&
    clientInfo() const
    {
        return clientInfo_;
    }

    RefPtr<nsIReferrerInfo>&
    referrerInfo()
    {
        return referrerInfo_;
    }
    nsIReferrerInfo*
    referrerInfo() const
    {
        return referrerInfo_;
    }

    StorageAccess&
    storageAccess()
    {
        return storageAccess_;
    }
    const StorageAccess&
    storageAccess() const
    {
        return storageAccess_;
    }

    bool&
    isThirdPartyContext()
    {
        return isThirdPartyContext_;
    }
    const bool&
    isThirdPartyContext() const
    {
        return isThirdPartyContext_;
    }

    bool&
    shouldResistFingerprinting()
    {
        return shouldResistFingerprinting_;
    }
    const bool&
    shouldResistFingerprinting() const
    {
        return shouldResistFingerprinting_;
    }

    mozilla::Maybe<RFPTargetSet>&
    overriddenFingerprintingSettings()
    {
        return overriddenFingerprintingSettings_;
    }
    const mozilla::Maybe<RFPTargetSet>&
    overriddenFingerprintingSettings() const
    {
        return overriddenFingerprintingSettings_;
    }

    bool&
    isOn3PCBExceptionList()
    {
        return isOn3PCBExceptionList_;
    }
    const bool&
    isOn3PCBExceptionList() const
    {
        return isOn3PCBExceptionList_;
    }

    OriginTrials&
    originTrials()
    {
        return originTrials_;
    }
    const OriginTrials&
    originTrials() const
    {
        return originTrials_;
    }

    OptionalServiceWorkerData&
    serviceWorkerData()
    {
        return serviceWorkerData_;
    }
    const OptionalServiceWorkerData&
    serviceWorkerData() const
    {
        return serviceWorkerData_;
    }

    nsID&
    agentClusterId()
    {
        return agentClusterId_;
    }
    const nsID&
    agentClusterId() const
    {
        return agentClusterId_;
    }

    nsCString&
    remoteType()
    {
        return remoteType_;
    }
    const nsCString&
    remoteType() const
    {
        return remoteType_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> originalScriptURL_;
    ::mozilla::ipc::IPDLStructMember<URIParams> baseScriptURL_;
    ::mozilla::ipc::IPDLStructMember<URIParams> resolvedScriptURL_;
    ::mozilla::ipc::IPDLStructMember<WorkerOptions> workerOptions_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> loadingPrincipalInfo_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> partitionedPrincipalInfo_;
    ::mozilla::ipc::IPDLStructMember<bool> useRegularPrincipal_;
    ::mozilla::ipc::IPDLStructMember<bool> usingStorageAccess_;
    ::mozilla::ipc::IPDLStructMember<CookieJarSettingsArgs> cookieJarSettings_;
    ::mozilla::ipc::IPDLStructMember<nsCString> domain_;
    ::mozilla::ipc::IPDLStructMember<bool> isSecureContext_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<IPCClientInfo>> clientInfo_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIReferrerInfo>> referrerInfo_;
    ::mozilla::ipc::IPDLStructMember<StorageAccess> storageAccess_;
    ::mozilla::ipc::IPDLStructMember<bool> isThirdPartyContext_;
    ::mozilla::ipc::IPDLStructMember<bool> shouldResistFingerprinting_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<RFPTargetSet>> overriddenFingerprintingSettings_;
    ::mozilla::ipc::IPDLStructMember<bool> isOn3PCBExceptionList_;
    ::mozilla::ipc::IPDLStructMember<OriginTrials> originTrials_;
    ::mozilla::ipc::IPDLStructMember<OptionalServiceWorkerData> serviceWorkerData_;
    ::mozilla::ipc::IPDLStructMember<nsID> agentClusterId_;
    ::mozilla::ipc::IPDLStructMember<nsCString> remoteType_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::RemoteWorkerData>
{
    typedef ::mozilla::dom::RemoteWorkerData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ErrorDataNote|
//
namespace mozilla {
namespace dom {
class ErrorDataNote final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::nsString nsString;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ErrorDataNote() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ErrorDataNote(
            const uint32_t& _lineNumber,
            const uint32_t& _columnNumber,
            const nsString& _message,
            const nsCString& _filename) :
        message_(_message),
        filename_(_filename),
        lineNumber_(_lineNumber),
        columnNumber_(_columnNumber)
    {
    }

    MOZ_IMPLICIT ErrorDataNote(
            uint32_t&& _lineNumber,
            uint32_t&& _columnNumber,
            nsString&& _message,
            nsCString&& _filename) :
        message_(std::move(_message)),
        filename_(std::move(_filename)),
        lineNumber_(std::move(_lineNumber)),
        columnNumber_(std::move(_columnNumber))
    {
    }

    uint32_t&
    lineNumber()
    {
        return lineNumber_;
    }
    const uint32_t&
    lineNumber() const
    {
        return lineNumber_;
    }

    uint32_t&
    columnNumber()
    {
        return columnNumber_;
    }
    const uint32_t&
    columnNumber() const
    {
        return columnNumber_;
    }

    nsString&
    message()
    {
        return message_;
    }
    const nsString&
    message() const
    {
        return message_;
    }

    nsCString&
    filename()
    {
        return filename_;
    }
    const nsCString&
    filename() const
    {
        return filename_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsString> message_;
    ::mozilla::ipc::IPDLStructMember<nsCString> filename_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> lineNumber_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> columnNumber_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ErrorDataNote>
{
    typedef ::mozilla::dom::ErrorDataNote paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ErrorData|
//
namespace mozilla {
namespace dom {
class ErrorData final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::nsString nsString;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::ErrorDataNote ErrorDataNote;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ErrorData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ErrorData(
            const bool& _isWarning,
            const uint32_t& _lineNumber,
            const uint32_t& _columnNumber,
            const nsString& _message,
            const nsCString& _filename,
            const nsTArray<ErrorDataNote>& _notes) :
        isWarning_(_isWarning),
        message_(_message),
        filename_(_filename),
        notes_(_notes),
        lineNumber_(_lineNumber),
        columnNumber_(_columnNumber)
    {
    }

    MOZ_IMPLICIT ErrorData(
            bool&& _isWarning,
            uint32_t&& _lineNumber,
            uint32_t&& _columnNumber,
            nsString&& _message,
            nsCString&& _filename,
            nsTArray<ErrorDataNote>&& _notes) :
        isWarning_(std::move(_isWarning)),
        message_(std::move(_message)),
        filename_(std::move(_filename)),
        notes_(std::move(_notes)),
        lineNumber_(std::move(_lineNumber)),
        columnNumber_(std::move(_columnNumber))
    {
    }

    bool&
    isWarning()
    {
        return isWarning_;
    }
    const bool&
    isWarning() const
    {
        return isWarning_;
    }

    uint32_t&
    lineNumber()
    {
        return lineNumber_;
    }
    const uint32_t&
    lineNumber() const
    {
        return lineNumber_;
    }

    uint32_t&
    columnNumber()
    {
        return columnNumber_;
    }
    const uint32_t&
    columnNumber() const
    {
        return columnNumber_;
    }

    nsString&
    message()
    {
        return message_;
    }
    const nsString&
    message() const
    {
        return message_;
    }

    nsCString&
    filename()
    {
        return filename_;
    }
    const nsCString&
    filename() const
    {
        return filename_;
    }

    nsTArray<ErrorDataNote>&
    notes()
    {
        return notes_;
    }
    const nsTArray<ErrorDataNote>&
    notes() const
    {
        return notes_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<bool> isWarning_;
    ::mozilla::ipc::IPDLStructMember<nsString> message_;
    ::mozilla::ipc::IPDLStructMember<nsCString> filename_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<ErrorDataNote>> notes_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> lineNumber_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> columnNumber_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ErrorData>
{
    typedef ::mozilla::dom::ErrorData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CSPViolation|
//
namespace mozilla {
namespace dom {
class CSPViolation final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CSPViolation() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CSPViolation(const nsString& _json) :
        json_(_json)
    {
    }

    MOZ_IMPLICIT CSPViolation(nsString&& _json) :
        json_(std::move(_json))
    {
    }

    nsString&
    json()
    {
        return json_;
    }
    const nsString&
    json() const
    {
        return json_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> json_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::CSPViolation>
{
    typedef ::mozilla::dom::CSPViolation paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ErrorMismatchOptions|
//
namespace mozilla {
namespace dom {
class ErrorMismatchOptions final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ErrorMismatchOptions() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ErrorMismatchOptions>
{
    typedef ::mozilla::dom::ErrorMismatchOptions paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ErrorValue|
//
namespace mozilla {
namespace dom {
class ErrorValue final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TErrorData,
        TCSPViolation,
        TErrorMismatchOptions,
        Tvoid_t,
        T__Last = Tvoid_t
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::ErrorData ErrorData;
    typedef ::mozilla::dom::CSPViolation CSPViolation;
    typedef ::mozilla::dom::ErrorMismatchOptions ErrorMismatchOptions;
    typedef ::mozilla::void_t void_t;
    typedef nsresult nsresult__tdef;
    typedef ErrorData ErrorData__tdef;
    typedef CSPViolation CSPViolation__tdef;
    typedef ErrorMismatchOptions ErrorMismatchOptions__tdef;
    typedef void_t void_t__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    ErrorData*
    ptr_ErrorData()
    {
        return (&(mVErrorData));
    }
    const ErrorData*
    constptr_ErrorData() const
    {
        return (&(mVErrorData));
    }
    CSPViolation*
    ptr_CSPViolation()
    {
        return (&(mVCSPViolation));
    }
    const CSPViolation*
    constptr_CSPViolation() const
    {
        return (&(mVCSPViolation));
    }
    ErrorMismatchOptions*
    ptr_ErrorMismatchOptions()
    {
        return (&(mVErrorMismatchOptions));
    }
    const ErrorMismatchOptions*
    constptr_ErrorMismatchOptions() const
    {
        return (&(mVErrorMismatchOptions));
    }
    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ErrorValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ErrorValue(const nsresult& aOther);

    MOZ_IMPLICIT ErrorValue(nsresult&& aOther);

    MOZ_IMPLICIT ErrorValue(const ErrorData& aOther);

    MOZ_IMPLICIT ErrorValue(ErrorData&& aOther);

    MOZ_IMPLICIT ErrorValue(const CSPViolation& aOther);

    MOZ_IMPLICIT ErrorValue(CSPViolation&& aOther);

    MOZ_IMPLICIT ErrorValue(const ErrorMismatchOptions& aOther);

    MOZ_IMPLICIT ErrorValue(ErrorMismatchOptions&& aOther);

    MOZ_IMPLICIT ErrorValue(const void_t& aOther);

    MOZ_IMPLICIT ErrorValue(void_t&& aOther);

    MOZ_IMPLICIT ErrorValue(const ErrorValue& aOther);

    MOZ_IMPLICIT ErrorValue(ErrorValue&& aOther);

    ~ErrorValue();

    Type
    type() const
    {
        return mType;
    }

    ErrorValue&
    operator=(const nsresult& aRhs);

    ErrorValue&
    operator=(nsresult&& aRhs);

    ErrorValue&
    operator=(const ErrorData& aRhs);

    ErrorValue&
    operator=(ErrorData&& aRhs);

    ErrorValue&
    operator=(const CSPViolation& aRhs);

    ErrorValue&
    operator=(CSPViolation&& aRhs);

    ErrorValue&
    operator=(const ErrorMismatchOptions& aRhs);

    ErrorValue&
    operator=(ErrorMismatchOptions&& aRhs);

    ErrorValue&
    operator=(const void_t& aRhs);

    ErrorValue&
    operator=(void_t&& aRhs);

    ErrorValue&
    operator=(const ErrorValue& aRhs);

    ErrorValue&
    operator=(ErrorValue&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    ErrorData&
    get_ErrorData()
    {
        AssertSanity(TErrorData);
        return (*(ptr_ErrorData()));
    }
    const ErrorData&
    get_ErrorData() const
    {
        AssertSanity(TErrorData);
        return (*(constptr_ErrorData()));
    }
    operator ErrorData&()
    {
        return get_ErrorData();
    }
    operator const ErrorData&() const
    {
        return get_ErrorData();
    }

    CSPViolation&
    get_CSPViolation()
    {
        AssertSanity(TCSPViolation);
        return (*(ptr_CSPViolation()));
    }
    const CSPViolation&
    get_CSPViolation() const
    {
        AssertSanity(TCSPViolation);
        return (*(constptr_CSPViolation()));
    }
    operator CSPViolation&()
    {
        return get_CSPViolation();
    }
    operator const CSPViolation&() const
    {
        return get_CSPViolation();
    }

    ErrorMismatchOptions&
    get_ErrorMismatchOptions()
    {
        AssertSanity(TErrorMismatchOptions);
        return (*(ptr_ErrorMismatchOptions()));
    }
    const ErrorMismatchOptions&
    get_ErrorMismatchOptions() const
    {
        AssertSanity(TErrorMismatchOptions);
        return (*(constptr_ErrorMismatchOptions()));
    }
    operator ErrorMismatchOptions&()
    {
        return get_ErrorMismatchOptions();
    }
    operator const ErrorMismatchOptions&() const
    {
        return get_ErrorMismatchOptions();
    }

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

private:
    union {
        nsresult mVnsresult;
        ErrorData mVErrorData;
        CSPViolation mVCSPViolation;
        ErrorMismatchOptions mVErrorMismatchOptions;
        void_t mVvoid_t;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ErrorValue>
{
    typedef ::mozilla::dom::ErrorValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef RemoteWorkerTypes_h
