//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PFilePicker_h
#define PFilePicker_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/dom/IPCBlob.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct InputBlobs|
//
namespace mozilla {
namespace dom {
class InputBlobs final
{
private:
    typedef ::mozilla::dom::IPCBlob IPCBlob;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    InputBlobs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT InputBlobs(const nsTArray<IPCBlob>& _blobs) :
        blobs_(_blobs)
    {
    }

    MOZ_IMPLICIT InputBlobs(nsTArray<IPCBlob>&& _blobs) :
        blobs_(std::move(_blobs))
    {
    }

    nsTArray<IPCBlob>&
    blobs()
    {
        return blobs_;
    }
    const nsTArray<IPCBlob>&
    blobs() const
    {
        return blobs_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IPCBlob>> blobs_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::InputBlobs>
{
    typedef ::mozilla::dom::InputBlobs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct InputDirectory|
//
namespace mozilla {
namespace dom {
class InputDirectory final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::dom::IPCBlob IPCBlob;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    InputDirectory() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT InputDirectory(
            const nsString& _directoryPath,
            const nsTArray<IPCBlob>& _blobsInWebKitDirectory) :
        directoryPath_(_directoryPath),
        blobsInWebKitDirectory_(_blobsInWebKitDirectory)
    {
    }

    MOZ_IMPLICIT InputDirectory(
            nsString&& _directoryPath,
            nsTArray<IPCBlob>&& _blobsInWebKitDirectory) :
        directoryPath_(std::move(_directoryPath)),
        blobsInWebKitDirectory_(std::move(_blobsInWebKitDirectory))
    {
    }

    nsString&
    directoryPath()
    {
        return directoryPath_;
    }
    const nsString&
    directoryPath() const
    {
        return directoryPath_;
    }

    nsTArray<IPCBlob>&
    blobsInWebKitDirectory()
    {
        return blobsInWebKitDirectory_;
    }
    const nsTArray<IPCBlob>&
    blobsInWebKitDirectory() const
    {
        return blobsInWebKitDirectory_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> directoryPath_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IPCBlob>> blobsInWebKitDirectory_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::InputDirectory>
{
    typedef ::mozilla::dom::InputDirectory paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union MaybeInputData|
//
namespace mozilla {
namespace dom {
class MaybeInputData final
{
public:
    enum Type {
        T__None,
        TInputBlobs = 1,
        TInputDirectory,
        Tvoid_t,
        T__Last = Tvoid_t
    };

private:
    typedef ::mozilla::dom::InputBlobs InputBlobs;
    typedef ::mozilla::dom::InputDirectory InputDirectory;
    typedef ::mozilla::void_t void_t;
    typedef InputBlobs InputBlobs__tdef;
    typedef InputDirectory InputDirectory__tdef;
    typedef void_t void_t__tdef;

    InputBlobs*
    ptr_InputBlobs()
    {
        return (&(mVInputBlobs));
    }
    const InputBlobs*
    constptr_InputBlobs() const
    {
        return (&(mVInputBlobs));
    }
    InputDirectory*
    ptr_InputDirectory()
    {
        return (&(mVInputDirectory));
    }
    const InputDirectory*
    constptr_InputDirectory() const
    {
        return (&(mVInputDirectory));
    }
    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT MaybeInputData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT MaybeInputData(const InputBlobs& aOther);

    MOZ_IMPLICIT MaybeInputData(InputBlobs&& aOther);

    MOZ_IMPLICIT MaybeInputData(const InputDirectory& aOther);

    MOZ_IMPLICIT MaybeInputData(InputDirectory&& aOther);

    MOZ_IMPLICIT MaybeInputData(const void_t& aOther);

    MOZ_IMPLICIT MaybeInputData(void_t&& aOther);

    MOZ_IMPLICIT MaybeInputData(const MaybeInputData& aOther);

    MOZ_IMPLICIT MaybeInputData(MaybeInputData&& aOther);

    ~MaybeInputData();

    Type
    type() const
    {
        return mType;
    }

    MaybeInputData&
    operator=(const InputBlobs& aRhs);

    MaybeInputData&
    operator=(InputBlobs&& aRhs);

    MaybeInputData&
    operator=(const InputDirectory& aRhs);

    MaybeInputData&
    operator=(InputDirectory&& aRhs);

    MaybeInputData&
    operator=(const void_t& aRhs);

    MaybeInputData&
    operator=(void_t&& aRhs);

    MaybeInputData&
    operator=(const MaybeInputData& aRhs);

    MaybeInputData&
    operator=(MaybeInputData&& aRhs);

    InputBlobs&
    get_InputBlobs()
    {
        AssertSanity(TInputBlobs);
        return (*(ptr_InputBlobs()));
    }
    const InputBlobs&
    get_InputBlobs() const
    {
        AssertSanity(TInputBlobs);
        return (*(constptr_InputBlobs()));
    }
    operator InputBlobs&()
    {
        return get_InputBlobs();
    }
    operator const InputBlobs&() const
    {
        return get_InputBlobs();
    }

    InputDirectory&
    get_InputDirectory()
    {
        AssertSanity(TInputDirectory);
        return (*(ptr_InputDirectory()));
    }
    const InputDirectory&
    get_InputDirectory() const
    {
        AssertSanity(TInputDirectory);
        return (*(constptr_InputDirectory()));
    }
    operator InputDirectory&()
    {
        return get_InputDirectory();
    }
    operator const InputDirectory&() const
    {
        return get_InputDirectory();
    }

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

private:
    union {
        InputBlobs mVInputBlobs;
        InputDirectory mVInputDirectory;
        void_t mVvoid_t;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::MaybeInputData>
{
    typedef ::mozilla::dom::MaybeInputData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PFilePickerParent;
} // namespace dom
} // namespace mozilla
namespace mozilla {
namespace dom {
class PFilePickerChild;
} // namespace dom
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PFilePickerChild and PFilePickerParent
//
namespace mozilla {
namespace dom {
namespace PFilePicker {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::dom::PFilePickerParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::PFilePickerChild>* aChild);

enum MessageType {
    PFilePickerStart = PFilePickerMsgStart << 16,
    Msg_Open__ID,
    Msg___delete____ID,
    Reply___delete____ID,
    PFilePickerEnd
};

mozilla::UniquePtr<IPC::Message>
Msg_Open(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg___delete__(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply___delete__(int32_t routingId);



} // namespace PFilePicker
} // namespace dom
} // namespace mozilla

#endif // ifndef PFilePicker_h
