//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PCookieStore_h
#define PCookieStore_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "ipc/IPCMessageUtils.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CookieData|
//
namespace mozilla {
namespace dom {
class CookieData final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CookieData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CookieData(
            const nsString& _name,
            const nsString& _value) :
        name_(_name),
        value_(_value)
    {
    }

    MOZ_IMPLICIT CookieData(
            nsString&& _name,
            nsString&& _value) :
        name_(std::move(_name)),
        value_(std::move(_value))
    {
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    nsString&
    value()
    {
        return value_;
    }
    const nsString&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<nsString> value_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::CookieData>
{
    typedef ::mozilla::dom::CookieData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union MaybeCookieData|
//
namespace mozilla {
namespace dom {
class MaybeCookieData final
{
public:
    enum Type {
        T__None,
        TCookieData = 1,
        Tvoid_t,
        T__Last = Tvoid_t
    };

private:
    typedef ::mozilla::dom::CookieData CookieData;
    typedef ::mozilla::void_t void_t;
    typedef CookieData CookieData__tdef;
    typedef void_t void_t__tdef;

    CookieData*
    ptr_CookieData()
    {
        return (&(mVCookieData));
    }
    const CookieData*
    constptr_CookieData() const
    {
        return (&(mVCookieData));
    }
    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT MaybeCookieData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT MaybeCookieData(const CookieData& aOther);

    MOZ_IMPLICIT MaybeCookieData(CookieData&& aOther);

    MOZ_IMPLICIT MaybeCookieData(const void_t& aOther);

    MOZ_IMPLICIT MaybeCookieData(void_t&& aOther);

    MOZ_IMPLICIT MaybeCookieData(const MaybeCookieData& aOther);

    MOZ_IMPLICIT MaybeCookieData(MaybeCookieData&& aOther);

    ~MaybeCookieData();

    Type
    type() const
    {
        return mType;
    }

    MaybeCookieData&
    operator=(const CookieData& aRhs);

    MaybeCookieData&
    operator=(CookieData&& aRhs);

    MaybeCookieData&
    operator=(const void_t& aRhs);

    MaybeCookieData&
    operator=(void_t&& aRhs);

    MaybeCookieData&
    operator=(const MaybeCookieData& aRhs);

    MaybeCookieData&
    operator=(MaybeCookieData&& aRhs);

    CookieData&
    get_CookieData()
    {
        AssertSanity(TCookieData);
        return (*(ptr_CookieData()));
    }
    const CookieData&
    get_CookieData() const
    {
        AssertSanity(TCookieData);
        return (*(constptr_CookieData()));
    }
    operator CookieData&()
    {
        return get_CookieData();
    }
    operator const CookieData&() const
    {
        return get_CookieData();
    }

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

private:
    union {
        CookieData mVCookieData;
        void_t mVvoid_t;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::MaybeCookieData>
{
    typedef ::mozilla::dom::MaybeCookieData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CookieSubscription|
//
namespace mozilla {
namespace dom {
class CookieSubscription final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CookieSubscription() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CookieSubscription(
            const mozilla::Maybe<nsString>& _name,
            const nsString& _url) :
        name_(_name),
        url_(_url)
    {
    }

    MOZ_IMPLICIT CookieSubscription(
            mozilla::Maybe<nsString>&& _name,
            nsString&& _url) :
        name_(std::move(_name)),
        url_(std::move(_url))
    {
    }

    mozilla::Maybe<nsString>&
    name()
    {
        return name_;
    }
    const mozilla::Maybe<nsString>&
    name() const
    {
        return name_;
    }

    nsString&
    url()
    {
        return url_;
    }
    const nsString&
    url() const
    {
        return url_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsString>> name_;
    ::mozilla::ipc::IPDLStructMember<nsString> url_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::CookieSubscription>
{
    typedef ::mozilla::dom::CookieSubscription paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PCookieStoreParent;
} // namespace dom
} // namespace mozilla
namespace mozilla {
namespace dom {
class PCookieStoreChild;
} // namespace dom
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PCookieStoreChild and PCookieStoreParent
//
namespace mozilla {
namespace dom {
namespace PCookieStore {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::dom::PCookieStoreParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::PCookieStoreChild>* aChild);

enum MessageType {
    PCookieStoreStart = PCookieStoreMsgStart << 16,
    Msg_GetRequest__ID,
    Reply_GetRequest__ID,
    Msg_SetRequest__ID,
    Reply_SetRequest__ID,
    Msg_DeleteRequest__ID,
    Reply_DeleteRequest__ID,
    Msg_GetSubscriptionsRequest__ID,
    Reply_GetSubscriptionsRequest__ID,
    Msg_SubscribeOrUnsubscribeRequest__ID,
    Reply_SubscribeOrUnsubscribeRequest__ID,
    Msg_Close__ID,
    Msg___delete____ID,
    Reply___delete____ID,
    PCookieStoreEnd
};

mozilla::UniquePtr<IPC::Message>
Msg_GetRequest(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetRequest(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SetRequest(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_SetRequest(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_DeleteRequest(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_DeleteRequest(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_GetSubscriptionsRequest(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_GetSubscriptionsRequest(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_SubscribeOrUnsubscribeRequest(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_SubscribeOrUnsubscribeRequest(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg_Close(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg___delete__(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply___delete__(int32_t routingId);



} // namespace PCookieStore
} // namespace dom
} // namespace mozilla

#endif // ifndef PCookieStore_h
