//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef FetchTypes_h
#define FetchTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/FetchDriver.h"
#include "mozilla/dom/HeadersBinding.h"
#include "mozilla/dom/ReferrerPolicyBinding.h"
#include "mozilla/dom/RequestBinding.h"
#include "mozilla/dom/ResponseBinding.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "nsID.h"
#include "nsILoadInfo.h"
#include "nsITransportSecurityInfo.h"
#include "mozilla/ipc/IPCStream.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"
#include "mozilla/dom/PerformanceTimingTypes.h"
#include "mozilla/net/NeckoChannelParams.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct HeadersEntry|
//
namespace mozilla {
namespace dom {
class HeadersEntry final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    HeadersEntry() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT HeadersEntry(
            const nsCString& _name,
            const nsCString& _value) :
        name_(_name),
        value_(_value)
    {
    }

    MOZ_IMPLICIT HeadersEntry(
            nsCString&& _name,
            nsCString&& _value) :
        name_(std::move(_name)),
        value_(std::move(_value))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    nsCString&
    value()
    {
        return value_;
    }
    const nsCString&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<nsCString> value_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::HeadersEntry>
{
    typedef ::mozilla::dom::HeadersEntry paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentToParentStream|
//
namespace mozilla {
namespace dom {
class ParentToParentStream final
{
private:
    typedef ::nsID nsID;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentToParentStream() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentToParentStream(const nsID& _uuid) :
        uuid_(_uuid)
    {
    }

    MOZ_IMPLICIT ParentToParentStream(nsID&& _uuid) :
        uuid_(std::move(_uuid))
    {
    }

    nsID&
    uuid()
    {
        return uuid_;
    }
    const nsID&
    uuid() const
    {
        return uuid_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> uuid_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToParentStream>
{
    typedef ::mozilla::dom::ParentToParentStream paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ParentToChildStream|
//
namespace mozilla {
namespace dom {
class ParentToChildStream final
{
public:
    enum Type {
        T__None,
        TRemoteLazyInputStream = 1,
        TIPCStream,
        T__Last = TIPCStream
    };

private:
    typedef ::mozilla::RemoteLazyInputStream RemoteLazyInputStream;
    typedef ::mozilla::ipc::IPCStream IPCStream;
    typedef RefPtr<RemoteLazyInputStream> RemoteLazyInputStream__tdef;
    typedef IPCStream IPCStream__tdef;

    RefPtr<RemoteLazyInputStream>*
    ptr_RemoteLazyInputStream()
    {
        return (&(mVRemoteLazyInputStream));
    }
    const RefPtr<RemoteLazyInputStream>*
    constptr_RemoteLazyInputStream() const
    {
        return (&(mVRemoteLazyInputStream));
    }
    IPCStream*
    ptr_IPCStream()
    {
        return (&(mVIPCStream));
    }
    const IPCStream*
    constptr_IPCStream() const
    {
        return (&(mVIPCStream));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ParentToChildStream() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ParentToChildStream(RemoteLazyInputStream* aOther);

    MOZ_IMPLICIT ParentToChildStream(RefPtr<RemoteLazyInputStream>&& aOther);

    MOZ_IMPLICIT ParentToChildStream(const IPCStream& aOther);

    MOZ_IMPLICIT ParentToChildStream(IPCStream&& aOther);

    MOZ_IMPLICIT ParentToChildStream(const ParentToChildStream& aOther);

    MOZ_IMPLICIT ParentToChildStream(ParentToChildStream&& aOther);

    ~ParentToChildStream();

    Type
    type() const
    {
        return mType;
    }

    ParentToChildStream&
    operator=(RemoteLazyInputStream* aRhs);

    ParentToChildStream&
    operator=(RefPtr<RemoteLazyInputStream>&& aRhs);

    ParentToChildStream&
    operator=(const IPCStream& aRhs);

    ParentToChildStream&
    operator=(IPCStream&& aRhs);

    ParentToChildStream&
    operator=(const ParentToChildStream& aRhs);

    ParentToChildStream&
    operator=(ParentToChildStream&& aRhs);

    RefPtr<RemoteLazyInputStream>&
    get_RemoteLazyInputStream()
    {
        AssertSanity(TRemoteLazyInputStream);
        return (*(ptr_RemoteLazyInputStream()));
    }
    RemoteLazyInputStream*
    get_RemoteLazyInputStream() const
    {
        AssertSanity(TRemoteLazyInputStream);
        return (*(constptr_RemoteLazyInputStream()));
    }
    operator RefPtr<RemoteLazyInputStream>&()
    {
        return get_RemoteLazyInputStream();
    }
    operator RemoteLazyInputStream*() const
    {
        return get_RemoteLazyInputStream();
    }

    IPCStream&
    get_IPCStream()
    {
        AssertSanity(TIPCStream);
        return (*(ptr_IPCStream()));
    }
    const IPCStream&
    get_IPCStream() const
    {
        AssertSanity(TIPCStream);
        return (*(constptr_IPCStream()));
    }
    operator IPCStream&()
    {
        return get_IPCStream();
    }
    operator const IPCStream&() const
    {
        return get_IPCStream();
    }

private:
    union {
        RefPtr<RemoteLazyInputStream> mVRemoteLazyInputStream;
        IPCStream mVIPCStream;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToChildStream>
{
    typedef ::mozilla::dom::ParentToChildStream paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ChildToParentStream|
//
namespace mozilla {
namespace dom {
class ChildToParentStream final
{
private:
    typedef ::mozilla::ipc::IPCStream IPCStream;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ChildToParentStream() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ChildToParentStream(const IPCStream& _stream) :
        stream_(_stream)
    {
    }

    MOZ_IMPLICIT ChildToParentStream(IPCStream&& _stream) :
        stream_(std::move(_stream))
    {
    }

    IPCStream&
    stream()
    {
        return stream_;
    }
    const IPCStream&
    stream() const
    {
        return stream_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCStream> stream_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ChildToParentStream>
{
    typedef ::mozilla::dom::ChildToParentStream paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union BodyStreamVariant|
//
namespace mozilla {
namespace dom {
class BodyStreamVariant final
{
public:
    enum Type {
        T__None,
        TParentToParentStream = 1,
        TParentToChildStream,
        TChildToParentStream,
        T__Last = TChildToParentStream
    };

private:
    typedef ::mozilla::dom::ParentToParentStream ParentToParentStream;
    typedef ::mozilla::dom::ParentToChildStream ParentToChildStream;
    typedef ::mozilla::dom::ChildToParentStream ChildToParentStream;
    typedef ParentToParentStream ParentToParentStream__tdef;
    typedef ParentToChildStream ParentToChildStream__tdef;
    typedef ChildToParentStream ChildToParentStream__tdef;

    ParentToParentStream*
    ptr_ParentToParentStream()
    {
        return (&(mVParentToParentStream));
    }
    const ParentToParentStream*
    constptr_ParentToParentStream() const
    {
        return (&(mVParentToParentStream));
    }
    ParentToChildStream*
    ptr_ParentToChildStream()
    {
        return (&(mVParentToChildStream));
    }
    const ParentToChildStream*
    constptr_ParentToChildStream() const
    {
        return (&(mVParentToChildStream));
    }
    ChildToParentStream*
    ptr_ChildToParentStream()
    {
        return (&(mVChildToParentStream));
    }
    const ChildToParentStream*
    constptr_ChildToParentStream() const
    {
        return (&(mVChildToParentStream));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT BodyStreamVariant() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT BodyStreamVariant(const ParentToParentStream& aOther);

    MOZ_IMPLICIT BodyStreamVariant(ParentToParentStream&& aOther);

    MOZ_IMPLICIT BodyStreamVariant(const ParentToChildStream& aOther);

    MOZ_IMPLICIT BodyStreamVariant(ParentToChildStream&& aOther);

    MOZ_IMPLICIT BodyStreamVariant(const ChildToParentStream& aOther);

    MOZ_IMPLICIT BodyStreamVariant(ChildToParentStream&& aOther);

    MOZ_IMPLICIT BodyStreamVariant(const BodyStreamVariant& aOther);

    MOZ_IMPLICIT BodyStreamVariant(BodyStreamVariant&& aOther);

    ~BodyStreamVariant();

    Type
    type() const
    {
        return mType;
    }

    BodyStreamVariant&
    operator=(const ParentToParentStream& aRhs);

    BodyStreamVariant&
    operator=(ParentToParentStream&& aRhs);

    BodyStreamVariant&
    operator=(const ParentToChildStream& aRhs);

    BodyStreamVariant&
    operator=(ParentToChildStream&& aRhs);

    BodyStreamVariant&
    operator=(const ChildToParentStream& aRhs);

    BodyStreamVariant&
    operator=(ChildToParentStream&& aRhs);

    BodyStreamVariant&
    operator=(const BodyStreamVariant& aRhs);

    BodyStreamVariant&
    operator=(BodyStreamVariant&& aRhs);

    ParentToParentStream&
    get_ParentToParentStream()
    {
        AssertSanity(TParentToParentStream);
        return (*(ptr_ParentToParentStream()));
    }
    const ParentToParentStream&
    get_ParentToParentStream() const
    {
        AssertSanity(TParentToParentStream);
        return (*(constptr_ParentToParentStream()));
    }
    operator ParentToParentStream&()
    {
        return get_ParentToParentStream();
    }
    operator const ParentToParentStream&() const
    {
        return get_ParentToParentStream();
    }

    ParentToChildStream&
    get_ParentToChildStream()
    {
        AssertSanity(TParentToChildStream);
        return (*(ptr_ParentToChildStream()));
    }
    const ParentToChildStream&
    get_ParentToChildStream() const
    {
        AssertSanity(TParentToChildStream);
        return (*(constptr_ParentToChildStream()));
    }
    operator ParentToChildStream&()
    {
        return get_ParentToChildStream();
    }
    operator const ParentToChildStream&() const
    {
        return get_ParentToChildStream();
    }

    ChildToParentStream&
    get_ChildToParentStream()
    {
        AssertSanity(TChildToParentStream);
        return (*(ptr_ChildToParentStream()));
    }
    const ChildToParentStream&
    get_ChildToParentStream() const
    {
        AssertSanity(TChildToParentStream);
        return (*(constptr_ChildToParentStream()));
    }
    operator ChildToParentStream&()
    {
        return get_ChildToParentStream();
    }
    operator const ChildToParentStream&() const
    {
        return get_ChildToParentStream();
    }

private:
    union {
        ParentToParentStream mVParentToParentStream;
        ParentToChildStream mVParentToChildStream;
        ChildToParentStream mVChildToParentStream;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::BodyStreamVariant>
{
    typedef ::mozilla::dom::BodyStreamVariant paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCInternalRequest|
//
namespace mozilla {
namespace dom {
class IPCInternalRequest final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::HeadersGuardEnum HeadersGuardEnum;
    typedef ::mozilla::dom::HeadersEntry HeadersEntry;
    typedef ::mozilla::dom::BodyStreamVariant BodyStreamVariant;
    typedef ::int64_t int64_t;
    typedef ::uint32_t uint32_t;
    typedef ::int32_t int32_t;
    typedef ::mozilla::dom::ReferrerPolicy ReferrerPolicy;
    typedef ::mozilla::dom::RequestMode RequestMode;
    typedef ::mozilla::dom::RequestCredentials RequestCredentials;
    typedef ::mozilla::dom::RequestCache RequestCache;
    typedef ::mozilla::dom::RequestRedirect RequestRedirect;
    typedef ::mozilla::dom::RequestPriority RequestPriority;
    typedef ::nsString nsString;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::net::RedirectHistoryEntryInfo RedirectHistoryEntryInfo;
    typedef ::nsILoadInfo::CrossOriginEmbedderPolicy CrossOriginEmbedderPolicy;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCInternalRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCInternalRequest(
            const nsCString& _method,
            const nsTArray<nsCString>& _urlList,
            const HeadersGuardEnum& _headersGuard,
            const nsTArray<HeadersEntry>& _headers,
            const mozilla::Maybe<BodyStreamVariant>& _body,
            const int64_t& _bodySize,
            const nsCString& _preferredAlternativeDataType,
            const uint32_t& _contentPolicyType,
            const int32_t& _internalPriority,
            const nsCString& _referrer,
            const ReferrerPolicy& _referrerPolicy,
            const ReferrerPolicy& _environmentReferrerPolicy,
            const RequestMode& _requestMode,
            const RequestCredentials& _requestCredentials,
            const RequestCache& _cacheMode,
            const RequestRedirect& _requestRedirect,
            const RequestPriority& _requestPriority,
            const nsString& _integrity,
            const bool& _keepalive,
            const nsCString& _fragment,
            const mozilla::Maybe<PrincipalInfo>& _principalInfo,
            const mozilla::Maybe<PrincipalInfo>& _interceptionTriggeringPrincipalInfo,
            const uint32_t& _interceptionContentPolicyType,
            const nsTArray<RedirectHistoryEntryInfo>& _interceptionRedirectChain,
            const bool& _interceptionFromThirdParty,
            const CrossOriginEmbedderPolicy& _embedderPolicy) :
        method_(_method),
        urlList_(_urlList),
        headersGuard_(_headersGuard),
        headers_(_headers),
        body_(_body),
        preferredAlternativeDataType_(_preferredAlternativeDataType),
        referrer_(_referrer),
        referrerPolicy_(_referrerPolicy),
        environmentReferrerPolicy_(_environmentReferrerPolicy),
        requestMode_(_requestMode),
        requestCredentials_(_requestCredentials),
        cacheMode_(_cacheMode),
        requestRedirect_(_requestRedirect),
        requestPriority_(_requestPriority),
        integrity_(_integrity),
        keepalive_(_keepalive),
        fragment_(_fragment),
        principalInfo_(_principalInfo),
        interceptionTriggeringPrincipalInfo_(_interceptionTriggeringPrincipalInfo),
        interceptionRedirectChain_(_interceptionRedirectChain),
        interceptionFromThirdParty_(_interceptionFromThirdParty),
        embedderPolicy_(_embedderPolicy),
        bodySize_(_bodySize),
        contentPolicyType_(_contentPolicyType),
        internalPriority_(_internalPriority),
        interceptionContentPolicyType_(_interceptionContentPolicyType)
    {
    }

    MOZ_IMPLICIT IPCInternalRequest(
            nsCString&& _method,
            nsTArray<nsCString>&& _urlList,
            HeadersGuardEnum&& _headersGuard,
            nsTArray<HeadersEntry>&& _headers,
            mozilla::Maybe<BodyStreamVariant>&& _body,
            int64_t&& _bodySize,
            nsCString&& _preferredAlternativeDataType,
            uint32_t&& _contentPolicyType,
            int32_t&& _internalPriority,
            nsCString&& _referrer,
            ReferrerPolicy&& _referrerPolicy,
            ReferrerPolicy&& _environmentReferrerPolicy,
            RequestMode&& _requestMode,
            RequestCredentials&& _requestCredentials,
            RequestCache&& _cacheMode,
            RequestRedirect&& _requestRedirect,
            RequestPriority&& _requestPriority,
            nsString&& _integrity,
            bool&& _keepalive,
            nsCString&& _fragment,
            mozilla::Maybe<PrincipalInfo>&& _principalInfo,
            mozilla::Maybe<PrincipalInfo>&& _interceptionTriggeringPrincipalInfo,
            uint32_t&& _interceptionContentPolicyType,
            nsTArray<RedirectHistoryEntryInfo>&& _interceptionRedirectChain,
            bool&& _interceptionFromThirdParty,
            CrossOriginEmbedderPolicy&& _embedderPolicy) :
        method_(std::move(_method)),
        urlList_(std::move(_urlList)),
        headersGuard_(std::move(_headersGuard)),
        headers_(std::move(_headers)),
        body_(std::move(_body)),
        preferredAlternativeDataType_(std::move(_preferredAlternativeDataType)),
        referrer_(std::move(_referrer)),
        referrerPolicy_(std::move(_referrerPolicy)),
        environmentReferrerPolicy_(std::move(_environmentReferrerPolicy)),
        requestMode_(std::move(_requestMode)),
        requestCredentials_(std::move(_requestCredentials)),
        cacheMode_(std::move(_cacheMode)),
        requestRedirect_(std::move(_requestRedirect)),
        requestPriority_(std::move(_requestPriority)),
        integrity_(std::move(_integrity)),
        keepalive_(std::move(_keepalive)),
        fragment_(std::move(_fragment)),
        principalInfo_(std::move(_principalInfo)),
        interceptionTriggeringPrincipalInfo_(std::move(_interceptionTriggeringPrincipalInfo)),
        interceptionRedirectChain_(std::move(_interceptionRedirectChain)),
        interceptionFromThirdParty_(std::move(_interceptionFromThirdParty)),
        embedderPolicy_(std::move(_embedderPolicy)),
        bodySize_(std::move(_bodySize)),
        contentPolicyType_(std::move(_contentPolicyType)),
        internalPriority_(std::move(_internalPriority)),
        interceptionContentPolicyType_(std::move(_interceptionContentPolicyType))
    {
    }

    nsCString&
    method()
    {
        return method_;
    }
    const nsCString&
    method() const
    {
        return method_;
    }

    nsTArray<nsCString>&
    urlList()
    {
        return urlList_;
    }
    const nsTArray<nsCString>&
    urlList() const
    {
        return urlList_;
    }

    HeadersGuardEnum&
    headersGuard()
    {
        return headersGuard_;
    }
    const HeadersGuardEnum&
    headersGuard() const
    {
        return headersGuard_;
    }

    nsTArray<HeadersEntry>&
    headers()
    {
        return headers_;
    }
    const nsTArray<HeadersEntry>&
    headers() const
    {
        return headers_;
    }

    mozilla::Maybe<BodyStreamVariant>&
    body()
    {
        return body_;
    }
    const mozilla::Maybe<BodyStreamVariant>&
    body() const
    {
        return body_;
    }

    int64_t&
    bodySize()
    {
        return bodySize_;
    }
    const int64_t&
    bodySize() const
    {
        return bodySize_;
    }

    nsCString&
    preferredAlternativeDataType()
    {
        return preferredAlternativeDataType_;
    }
    const nsCString&
    preferredAlternativeDataType() const
    {
        return preferredAlternativeDataType_;
    }

    uint32_t&
    contentPolicyType()
    {
        return contentPolicyType_;
    }
    const uint32_t&
    contentPolicyType() const
    {
        return contentPolicyType_;
    }

    int32_t&
    internalPriority()
    {
        return internalPriority_;
    }
    const int32_t&
    internalPriority() const
    {
        return internalPriority_;
    }

    nsCString&
    referrer()
    {
        return referrer_;
    }
    const nsCString&
    referrer() const
    {
        return referrer_;
    }

    ReferrerPolicy&
    referrerPolicy()
    {
        return referrerPolicy_;
    }
    const ReferrerPolicy&
    referrerPolicy() const
    {
        return referrerPolicy_;
    }

    ReferrerPolicy&
    environmentReferrerPolicy()
    {
        return environmentReferrerPolicy_;
    }
    const ReferrerPolicy&
    environmentReferrerPolicy() const
    {
        return environmentReferrerPolicy_;
    }

    RequestMode&
    requestMode()
    {
        return requestMode_;
    }
    const RequestMode&
    requestMode() const
    {
        return requestMode_;
    }

    RequestCredentials&
    requestCredentials()
    {
        return requestCredentials_;
    }
    const RequestCredentials&
    requestCredentials() const
    {
        return requestCredentials_;
    }

    RequestCache&
    cacheMode()
    {
        return cacheMode_;
    }
    const RequestCache&
    cacheMode() const
    {
        return cacheMode_;
    }

    RequestRedirect&
    requestRedirect()
    {
        return requestRedirect_;
    }
    const RequestRedirect&
    requestRedirect() const
    {
        return requestRedirect_;
    }

    RequestPriority&
    requestPriority()
    {
        return requestPriority_;
    }
    const RequestPriority&
    requestPriority() const
    {
        return requestPriority_;
    }

    nsString&
    integrity()
    {
        return integrity_;
    }
    const nsString&
    integrity() const
    {
        return integrity_;
    }

    bool&
    keepalive()
    {
        return keepalive_;
    }
    const bool&
    keepalive() const
    {
        return keepalive_;
    }

    nsCString&
    fragment()
    {
        return fragment_;
    }
    const nsCString&
    fragment() const
    {
        return fragment_;
    }

    mozilla::Maybe<PrincipalInfo>&
    principalInfo()
    {
        return principalInfo_;
    }
    const mozilla::Maybe<PrincipalInfo>&
    principalInfo() const
    {
        return principalInfo_;
    }

    mozilla::Maybe<PrincipalInfo>&
    interceptionTriggeringPrincipalInfo()
    {
        return interceptionTriggeringPrincipalInfo_;
    }
    const mozilla::Maybe<PrincipalInfo>&
    interceptionTriggeringPrincipalInfo() const
    {
        return interceptionTriggeringPrincipalInfo_;
    }

    uint32_t&
    interceptionContentPolicyType()
    {
        return interceptionContentPolicyType_;
    }
    const uint32_t&
    interceptionContentPolicyType() const
    {
        return interceptionContentPolicyType_;
    }

    nsTArray<RedirectHistoryEntryInfo>&
    interceptionRedirectChain()
    {
        return interceptionRedirectChain_;
    }
    const nsTArray<RedirectHistoryEntryInfo>&
    interceptionRedirectChain() const
    {
        return interceptionRedirectChain_;
    }

    bool&
    interceptionFromThirdParty()
    {
        return interceptionFromThirdParty_;
    }
    const bool&
    interceptionFromThirdParty() const
    {
        return interceptionFromThirdParty_;
    }

    CrossOriginEmbedderPolicy&
    embedderPolicy()
    {
        return embedderPolicy_;
    }
    const CrossOriginEmbedderPolicy&
    embedderPolicy() const
    {
        return embedderPolicy_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsCString> method_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> urlList_;
    ::mozilla::ipc::IPDLStructMember<HeadersGuardEnum> headersGuard_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<HeadersEntry>> headers_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<BodyStreamVariant>> body_;
    ::mozilla::ipc::IPDLStructMember<nsCString> preferredAlternativeDataType_;
    ::mozilla::ipc::IPDLStructMember<nsCString> referrer_;
    ::mozilla::ipc::IPDLStructMember<ReferrerPolicy> referrerPolicy_;
    ::mozilla::ipc::IPDLStructMember<ReferrerPolicy> environmentReferrerPolicy_;
    ::mozilla::ipc::IPDLStructMember<RequestMode> requestMode_;
    ::mozilla::ipc::IPDLStructMember<RequestCredentials> requestCredentials_;
    ::mozilla::ipc::IPDLStructMember<RequestCache> cacheMode_;
    ::mozilla::ipc::IPDLStructMember<RequestRedirect> requestRedirect_;
    ::mozilla::ipc::IPDLStructMember<RequestPriority> requestPriority_;
    ::mozilla::ipc::IPDLStructMember<nsString> integrity_;
    ::mozilla::ipc::IPDLStructMember<bool> keepalive_;
    ::mozilla::ipc::IPDLStructMember<nsCString> fragment_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrincipalInfo>> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrincipalInfo>> interceptionTriggeringPrincipalInfo_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<RedirectHistoryEntryInfo>> interceptionRedirectChain_;
    ::mozilla::ipc::IPDLStructMember<bool> interceptionFromThirdParty_;
    ::mozilla::ipc::IPDLStructMember<CrossOriginEmbedderPolicy> embedderPolicy_;
    ::mozilla::ipc::IPDLStructMember<int64_t> bodySize_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> contentPolicyType_;
    ::mozilla::ipc::IPDLStructMember<int32_t> internalPriority_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> interceptionContentPolicyType_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCInternalRequest>
{
    typedef ::mozilla::dom::IPCInternalRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct InternalResponseMetadata|
//
namespace mozilla {
namespace dom {
class InternalResponseMetadata final
{
private:
    typedef ::mozilla::dom::ResponseType ResponseType;
    typedef ::nsCString nsCString;
    typedef ::uint16_t uint16_t;
    typedef ::mozilla::dom::HeadersGuardEnum HeadersGuardEnum;
    typedef ::mozilla::dom::HeadersEntry HeadersEntry;
    typedef ::nsresult nsresult;
    typedef ::nsITransportSecurityInfo nsITransportSecurityInfo;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::nsString nsString;
    typedef ::mozilla::dom::RequestCredentials RequestCredentials;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    InternalResponseMetadata() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT InternalResponseMetadata(
            const ResponseType& _type,
            const nsTArray<nsCString>& _urlList,
            const uint16_t& _status,
            const nsCString& _statusText,
            const HeadersGuardEnum& _headersGuard,
            const nsTArray<HeadersEntry>& _headers,
            const nsresult& _errorCode,
            const nsCString& _alternativeDataType,
            nsITransportSecurityInfo* _securityInfo,
            const mozilla::Maybe<PrincipalInfo>& _principalInfo,
            const nsCString& _bodyBlobURISpec,
            const nsString& _bodyLocalPath,
            const RequestCredentials& _credentialsMode) :
        type_(_type),
        urlList_(_urlList),
        statusText_(_statusText),
        headersGuard_(_headersGuard),
        headers_(_headers),
        errorCode_(_errorCode),
        alternativeDataType_(_alternativeDataType),
        securityInfo_(_securityInfo),
        principalInfo_(_principalInfo),
        bodyBlobURISpec_(_bodyBlobURISpec),
        bodyLocalPath_(_bodyLocalPath),
        credentialsMode_(_credentialsMode),
        status_(_status)
    {
    }

    MOZ_IMPLICIT InternalResponseMetadata(
            ResponseType&& _type,
            nsTArray<nsCString>&& _urlList,
            uint16_t&& _status,
            nsCString&& _statusText,
            HeadersGuardEnum&& _headersGuard,
            nsTArray<HeadersEntry>&& _headers,
            nsresult&& _errorCode,
            nsCString&& _alternativeDataType,
            RefPtr<nsITransportSecurityInfo>&& _securityInfo,
            mozilla::Maybe<PrincipalInfo>&& _principalInfo,
            nsCString&& _bodyBlobURISpec,
            nsString&& _bodyLocalPath,
            RequestCredentials&& _credentialsMode) :
        type_(std::move(_type)),
        urlList_(std::move(_urlList)),
        statusText_(std::move(_statusText)),
        headersGuard_(std::move(_headersGuard)),
        headers_(std::move(_headers)),
        errorCode_(std::move(_errorCode)),
        alternativeDataType_(std::move(_alternativeDataType)),
        securityInfo_(std::move(_securityInfo)),
        principalInfo_(std::move(_principalInfo)),
        bodyBlobURISpec_(std::move(_bodyBlobURISpec)),
        bodyLocalPath_(std::move(_bodyLocalPath)),
        credentialsMode_(std::move(_credentialsMode)),
        status_(std::move(_status))
    {
    }

    ResponseType&
    type()
    {
        return type_;
    }
    const ResponseType&
    type() const
    {
        return type_;
    }

    nsTArray<nsCString>&
    urlList()
    {
        return urlList_;
    }
    const nsTArray<nsCString>&
    urlList() const
    {
        return urlList_;
    }

    uint16_t&
    status()
    {
        return status_;
    }
    const uint16_t&
    status() const
    {
        return status_;
    }

    nsCString&
    statusText()
    {
        return statusText_;
    }
    const nsCString&
    statusText() const
    {
        return statusText_;
    }

    HeadersGuardEnum&
    headersGuard()
    {
        return headersGuard_;
    }
    const HeadersGuardEnum&
    headersGuard() const
    {
        return headersGuard_;
    }

    nsTArray<HeadersEntry>&
    headers()
    {
        return headers_;
    }
    const nsTArray<HeadersEntry>&
    headers() const
    {
        return headers_;
    }

    nsresult&
    errorCode()
    {
        return errorCode_;
    }
    const nsresult&
    errorCode() const
    {
        return errorCode_;
    }

    nsCString&
    alternativeDataType()
    {
        return alternativeDataType_;
    }
    const nsCString&
    alternativeDataType() const
    {
        return alternativeDataType_;
    }

    RefPtr<nsITransportSecurityInfo>&
    securityInfo()
    {
        return securityInfo_;
    }
    nsITransportSecurityInfo*
    securityInfo() const
    {
        return securityInfo_;
    }

    mozilla::Maybe<PrincipalInfo>&
    principalInfo()
    {
        return principalInfo_;
    }
    const mozilla::Maybe<PrincipalInfo>&
    principalInfo() const
    {
        return principalInfo_;
    }

    nsCString&
    bodyBlobURISpec()
    {
        return bodyBlobURISpec_;
    }
    const nsCString&
    bodyBlobURISpec() const
    {
        return bodyBlobURISpec_;
    }

    nsString&
    bodyLocalPath()
    {
        return bodyLocalPath_;
    }
    const nsString&
    bodyLocalPath() const
    {
        return bodyLocalPath_;
    }

    RequestCredentials&
    credentialsMode()
    {
        return credentialsMode_;
    }
    const RequestCredentials&
    credentialsMode() const
    {
        return credentialsMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ResponseType> type_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> urlList_;
    ::mozilla::ipc::IPDLStructMember<nsCString> statusText_;
    ::mozilla::ipc::IPDLStructMember<HeadersGuardEnum> headersGuard_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<HeadersEntry>> headers_;
    ::mozilla::ipc::IPDLStructMember<nsresult> errorCode_;
    ::mozilla::ipc::IPDLStructMember<nsCString> alternativeDataType_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsITransportSecurityInfo>> securityInfo_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrincipalInfo>> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<nsCString> bodyBlobURISpec_;
    ::mozilla::ipc::IPDLStructMember<nsString> bodyLocalPath_;
    ::mozilla::ipc::IPDLStructMember<RequestCredentials> credentialsMode_;
    ::mozilla::ipc::IPDLStructMember<uint16_t> status_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::InternalResponseMetadata>
{
    typedef ::mozilla::dom::InternalResponseMetadata paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentToParentInternalResponse|
//
namespace mozilla {
namespace dom {
class ParentToParentInternalResponse final
{
private:
    typedef ::mozilla::dom::InternalResponseMetadata InternalResponseMetadata;
    typedef ::mozilla::dom::ParentToParentStream ParentToParentStream;
    typedef ::int64_t int64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentToParentInternalResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentToParentInternalResponse(
            const InternalResponseMetadata& _metadata,
            const mozilla::Maybe<ParentToParentStream>& _body,
            const int64_t& _bodySize,
            const mozilla::Maybe<ParentToParentStream>& _alternativeBody) :
        metadata_(_metadata),
        body_(_body),
        alternativeBody_(_alternativeBody),
        bodySize_(_bodySize)
    {
    }

    MOZ_IMPLICIT ParentToParentInternalResponse(
            InternalResponseMetadata&& _metadata,
            mozilla::Maybe<ParentToParentStream>&& _body,
            int64_t&& _bodySize,
            mozilla::Maybe<ParentToParentStream>&& _alternativeBody) :
        metadata_(std::move(_metadata)),
        body_(std::move(_body)),
        alternativeBody_(std::move(_alternativeBody)),
        bodySize_(std::move(_bodySize))
    {
    }

    InternalResponseMetadata&
    metadata()
    {
        return metadata_;
    }
    const InternalResponseMetadata&
    metadata() const
    {
        return metadata_;
    }

    mozilla::Maybe<ParentToParentStream>&
    body()
    {
        return body_;
    }
    const mozilla::Maybe<ParentToParentStream>&
    body() const
    {
        return body_;
    }

    int64_t&
    bodySize()
    {
        return bodySize_;
    }
    const int64_t&
    bodySize() const
    {
        return bodySize_;
    }

    mozilla::Maybe<ParentToParentStream>&
    alternativeBody()
    {
        return alternativeBody_;
    }
    const mozilla::Maybe<ParentToParentStream>&
    alternativeBody() const
    {
        return alternativeBody_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<InternalResponseMetadata> metadata_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ParentToParentStream>> body_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ParentToParentStream>> alternativeBody_;
    ::mozilla::ipc::IPDLStructMember<int64_t> bodySize_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToParentInternalResponse>
{
    typedef ::mozilla::dom::ParentToParentInternalResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentToChildInternalResponse|
//
namespace mozilla {
namespace dom {
class ParentToChildInternalResponse final
{
private:
    typedef ::mozilla::dom::InternalResponseMetadata InternalResponseMetadata;
    typedef ::mozilla::dom::ParentToChildStream ParentToChildStream;
    typedef ::int64_t int64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentToChildInternalResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentToChildInternalResponse(
            const InternalResponseMetadata& _metadata,
            const mozilla::Maybe<ParentToChildStream>& _body,
            const int64_t& _bodySize,
            const mozilla::Maybe<ParentToChildStream>& _alternativeBody) :
        metadata_(_metadata),
        body_(_body),
        alternativeBody_(_alternativeBody),
        bodySize_(_bodySize)
    {
    }

    MOZ_IMPLICIT ParentToChildInternalResponse(
            InternalResponseMetadata&& _metadata,
            mozilla::Maybe<ParentToChildStream>&& _body,
            int64_t&& _bodySize,
            mozilla::Maybe<ParentToChildStream>&& _alternativeBody) :
        metadata_(std::move(_metadata)),
        body_(std::move(_body)),
        alternativeBody_(std::move(_alternativeBody)),
        bodySize_(std::move(_bodySize))
    {
    }

    InternalResponseMetadata&
    metadata()
    {
        return metadata_;
    }
    const InternalResponseMetadata&
    metadata() const
    {
        return metadata_;
    }

    mozilla::Maybe<ParentToChildStream>&
    body()
    {
        return body_;
    }
    const mozilla::Maybe<ParentToChildStream>&
    body() const
    {
        return body_;
    }

    int64_t&
    bodySize()
    {
        return bodySize_;
    }
    const int64_t&
    bodySize() const
    {
        return bodySize_;
    }

    mozilla::Maybe<ParentToChildStream>&
    alternativeBody()
    {
        return alternativeBody_;
    }
    const mozilla::Maybe<ParentToChildStream>&
    alternativeBody() const
    {
        return alternativeBody_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<InternalResponseMetadata> metadata_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ParentToChildStream>> body_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ParentToChildStream>> alternativeBody_;
    ::mozilla::ipc::IPDLStructMember<int64_t> bodySize_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentToChildInternalResponse>
{
    typedef ::mozilla::dom::ParentToChildInternalResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ChildToParentInternalResponse|
//
namespace mozilla {
namespace dom {
class ChildToParentInternalResponse final
{
private:
    typedef ::mozilla::dom::InternalResponseMetadata InternalResponseMetadata;
    typedef ::mozilla::dom::ChildToParentStream ChildToParentStream;
    typedef ::int64_t int64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ChildToParentInternalResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ChildToParentInternalResponse(
            const InternalResponseMetadata& _metadata,
            const mozilla::Maybe<ChildToParentStream>& _body,
            const int64_t& _bodySize,
            const mozilla::Maybe<ChildToParentStream>& _alternativeBody) :
        metadata_(_metadata),
        body_(_body),
        alternativeBody_(_alternativeBody),
        bodySize_(_bodySize)
    {
    }

    MOZ_IMPLICIT ChildToParentInternalResponse(
            InternalResponseMetadata&& _metadata,
            mozilla::Maybe<ChildToParentStream>&& _body,
            int64_t&& _bodySize,
            mozilla::Maybe<ChildToParentStream>&& _alternativeBody) :
        metadata_(std::move(_metadata)),
        body_(std::move(_body)),
        alternativeBody_(std::move(_alternativeBody)),
        bodySize_(std::move(_bodySize))
    {
    }

    InternalResponseMetadata&
    metadata()
    {
        return metadata_;
    }
    const InternalResponseMetadata&
    metadata() const
    {
        return metadata_;
    }

    mozilla::Maybe<ChildToParentStream>&
    body()
    {
        return body_;
    }
    const mozilla::Maybe<ChildToParentStream>&
    body() const
    {
        return body_;
    }

    int64_t&
    bodySize()
    {
        return bodySize_;
    }
    const int64_t&
    bodySize() const
    {
        return bodySize_;
    }

    mozilla::Maybe<ChildToParentStream>&
    alternativeBody()
    {
        return alternativeBody_;
    }
    const mozilla::Maybe<ChildToParentStream>&
    alternativeBody() const
    {
        return alternativeBody_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<InternalResponseMetadata> metadata_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ChildToParentStream>> body_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ChildToParentStream>> alternativeBody_;
    ::mozilla::ipc::IPDLStructMember<int64_t> bodySize_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ChildToParentInternalResponse>
{
    typedef ::mozilla::dom::ChildToParentInternalResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ResponseTiming|
//
namespace mozilla {
namespace dom {
class ResponseTiming final
{
private:
    typedef ::mozilla::dom::IPCPerformanceTimingData IPCPerformanceTimingData;
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ResponseTiming() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ResponseTiming(
            const IPCPerformanceTimingData& _timingData,
            const nsString& _initiatorType,
            const nsString& _entryName) :
        timingData_(_timingData),
        initiatorType_(_initiatorType),
        entryName_(_entryName)
    {
    }

    MOZ_IMPLICIT ResponseTiming(
            IPCPerformanceTimingData&& _timingData,
            nsString&& _initiatorType,
            nsString&& _entryName) :
        timingData_(std::move(_timingData)),
        initiatorType_(std::move(_initiatorType)),
        entryName_(std::move(_entryName))
    {
    }

    IPCPerformanceTimingData&
    timingData()
    {
        return timingData_;
    }
    const IPCPerformanceTimingData&
    timingData() const
    {
        return timingData_;
    }

    nsString&
    initiatorType()
    {
        return initiatorType_;
    }
    const nsString&
    initiatorType() const
    {
        return initiatorType_;
    }

    nsString&
    entryName()
    {
        return entryName_;
    }
    const nsString&
    entryName() const
    {
        return entryName_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCPerformanceTimingData> timingData_;
    ::mozilla::ipc::IPDLStructMember<nsString> initiatorType_;
    ::mozilla::ipc::IPDLStructMember<nsString> entryName_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ResponseTiming>
{
    typedef ::mozilla::dom::ResponseTiming paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ResponseEndArgs|
//
namespace mozilla {
namespace dom {
class ResponseEndArgs final
{
private:
    typedef ::mozilla::dom::FetchDriverObserver::EndReason EndReason;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ResponseEndArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ResponseEndArgs(const EndReason& _endReason) :
        endReason_(_endReason)
    {
    }

    MOZ_IMPLICIT ResponseEndArgs(EndReason&& _endReason) :
        endReason_(std::move(_endReason))
    {
    }

    EndReason&
    endReason()
    {
        return endReason_;
    }
    const EndReason&
    endReason() const
    {
        return endReason_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<EndReason> endReason_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ResponseEndArgs>
{
    typedef ::mozilla::dom::ResponseEndArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef FetchTypes_h
