//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef ClientIPCTypes_h
#define ClientIPCTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/ErrorResult.h"
#include "mozilla/StorageAccess.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/ClientBinding.h"
#include "mozilla/dom/ClientsBinding.h"
#include "mozilla/dom/DocumentBinding.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SideVariant.h"
#include "mozilla/dom/DOMTypes.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"
#include "mozilla/dom/IPCServiceWorkerDescriptor.h"
#include "mozilla/ipc/ProtocolTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientSourceConstructorArgs|
//
namespace mozilla {
namespace dom {
class ClientSourceConstructorArgs final
{
private:
    typedef ::nsID nsID;
    typedef ::mozilla::dom::ClientType ClientType;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::FrameType FrameType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientSourceConstructorArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientSourceConstructorArgs(
            const nsID& _id,
            const mozilla::Maybe<nsID>& _agentClusterId,
            const ClientType& _type,
            const PrincipalInfo& _principalInfo,
            const TimeStamp& _creationTime,
            const nsCString& _url,
            const FrameType& _frameType) :
        id_(_id),
        agentClusterId_(_agentClusterId),
        type_(_type),
        principalInfo_(_principalInfo),
        creationTime_(_creationTime),
        url_(_url),
        frameType_(_frameType)
    {
    }

    MOZ_IMPLICIT ClientSourceConstructorArgs(
            nsID&& _id,
            mozilla::Maybe<nsID>&& _agentClusterId,
            ClientType&& _type,
            PrincipalInfo&& _principalInfo,
            TimeStamp&& _creationTime,
            nsCString&& _url,
            FrameType&& _frameType) :
        id_(std::move(_id)),
        agentClusterId_(std::move(_agentClusterId)),
        type_(std::move(_type)),
        principalInfo_(std::move(_principalInfo)),
        creationTime_(std::move(_creationTime)),
        url_(std::move(_url)),
        frameType_(std::move(_frameType))
    {
    }

    nsID&
    id()
    {
        return id_;
    }
    const nsID&
    id() const
    {
        return id_;
    }

    mozilla::Maybe<nsID>&
    agentClusterId()
    {
        return agentClusterId_;
    }
    const mozilla::Maybe<nsID>&
    agentClusterId() const
    {
        return agentClusterId_;
    }

    ClientType&
    type()
    {
        return type_;
    }
    const ClientType&
    type() const
    {
        return type_;
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

    TimeStamp&
    creationTime()
    {
        return creationTime_;
    }
    const TimeStamp&
    creationTime() const
    {
        return creationTime_;
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    FrameType&
    frameType()
    {
        return frameType_;
    }
    const FrameType&
    frameType() const
    {
        return frameType_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> id_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsID>> agentClusterId_;
    ::mozilla::ipc::IPDLStructMember<ClientType> type_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> creationTime_;
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<FrameType> frameType_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientSourceConstructorArgs>
{
    typedef ::mozilla::dom::ClientSourceConstructorArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCClientInfo|
//
namespace mozilla {
namespace dom {
class IPCClientInfo final
{
private:
    typedef ::nsID nsID;
    typedef ::mozilla::dom::ClientType ClientType;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::FrameType FrameType;
    typedef ::mozilla::ipc::CSPInfo CSPInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCClientInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCClientInfo(
            const nsID& _id,
            const mozilla::Maybe<nsID>& _agentClusterId,
            const ClientType& _type,
            const PrincipalInfo& _principalInfo,
            const TimeStamp& _creationTime,
            const nsCString& _url,
            const FrameType& _frameType,
            const mozilla::Maybe<CSPInfo>& _cspInfo,
            const mozilla::Maybe<CSPInfo>& _preloadCspInfo) :
        id_(_id),
        agentClusterId_(_agentClusterId),
        type_(_type),
        principalInfo_(_principalInfo),
        creationTime_(_creationTime),
        url_(_url),
        frameType_(_frameType),
        cspInfo_(_cspInfo),
        preloadCspInfo_(_preloadCspInfo)
    {
    }

    MOZ_IMPLICIT IPCClientInfo(
            nsID&& _id,
            mozilla::Maybe<nsID>&& _agentClusterId,
            ClientType&& _type,
            PrincipalInfo&& _principalInfo,
            TimeStamp&& _creationTime,
            nsCString&& _url,
            FrameType&& _frameType,
            mozilla::Maybe<CSPInfo>&& _cspInfo,
            mozilla::Maybe<CSPInfo>&& _preloadCspInfo) :
        id_(std::move(_id)),
        agentClusterId_(std::move(_agentClusterId)),
        type_(std::move(_type)),
        principalInfo_(std::move(_principalInfo)),
        creationTime_(std::move(_creationTime)),
        url_(std::move(_url)),
        frameType_(std::move(_frameType)),
        cspInfo_(std::move(_cspInfo)),
        preloadCspInfo_(std::move(_preloadCspInfo))
    {
    }

    bool
    operator==(const IPCClientInfo& _o) const;

    bool
    operator!=(const IPCClientInfo& _o) const;

    nsID&
    id()
    {
        return id_;
    }
    const nsID&
    id() const
    {
        return id_;
    }

    mozilla::Maybe<nsID>&
    agentClusterId()
    {
        return agentClusterId_;
    }
    const mozilla::Maybe<nsID>&
    agentClusterId() const
    {
        return agentClusterId_;
    }

    ClientType&
    type()
    {
        return type_;
    }
    const ClientType&
    type() const
    {
        return type_;
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

    TimeStamp&
    creationTime()
    {
        return creationTime_;
    }
    const TimeStamp&
    creationTime() const
    {
        return creationTime_;
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    FrameType&
    frameType()
    {
        return frameType_;
    }
    const FrameType&
    frameType() const
    {
        return frameType_;
    }

    mozilla::Maybe<CSPInfo>&
    cspInfo()
    {
        return cspInfo_;
    }
    const mozilla::Maybe<CSPInfo>&
    cspInfo() const
    {
        return cspInfo_;
    }

    mozilla::Maybe<CSPInfo>&
    preloadCspInfo()
    {
        return preloadCspInfo_;
    }
    const mozilla::Maybe<CSPInfo>&
    preloadCspInfo() const
    {
        return preloadCspInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> id_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsID>> agentClusterId_;
    ::mozilla::ipc::IPDLStructMember<ClientType> type_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> creationTime_;
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<FrameType> frameType_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CSPInfo>> cspInfo_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CSPInfo>> preloadCspInfo_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCClientInfo>
{
    typedef ::mozilla::dom::IPCClientInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCClientWindowState|
//
namespace mozilla {
namespace dom {
class IPCClientWindowState final
{
private:
    typedef ::mozilla::dom::VisibilityState VisibilityState;
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::mozilla::StorageAccess StorageAccess;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCClientWindowState() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCClientWindowState(
            const VisibilityState& _visibilityState,
            const TimeStamp& _lastFocusTime,
            const StorageAccess& _storageAccess,
            const bool& _focused) :
        visibilityState_(_visibilityState),
        lastFocusTime_(_lastFocusTime),
        storageAccess_(_storageAccess),
        focused_(_focused)
    {
    }

    MOZ_IMPLICIT IPCClientWindowState(
            VisibilityState&& _visibilityState,
            TimeStamp&& _lastFocusTime,
            StorageAccess&& _storageAccess,
            bool&& _focused) :
        visibilityState_(std::move(_visibilityState)),
        lastFocusTime_(std::move(_lastFocusTime)),
        storageAccess_(std::move(_storageAccess)),
        focused_(std::move(_focused))
    {
    }

    VisibilityState&
    visibilityState()
    {
        return visibilityState_;
    }
    const VisibilityState&
    visibilityState() const
    {
        return visibilityState_;
    }

    TimeStamp&
    lastFocusTime()
    {
        return lastFocusTime_;
    }
    const TimeStamp&
    lastFocusTime() const
    {
        return lastFocusTime_;
    }

    StorageAccess&
    storageAccess()
    {
        return storageAccess_;
    }
    const StorageAccess&
    storageAccess() const
    {
        return storageAccess_;
    }

    bool&
    focused()
    {
        return focused_;
    }
    const bool&
    focused() const
    {
        return focused_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<VisibilityState> visibilityState_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> lastFocusTime_;
    ::mozilla::ipc::IPDLStructMember<StorageAccess> storageAccess_;
    ::mozilla::ipc::IPDLStructMember<bool> focused_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCClientWindowState>
{
    typedef ::mozilla::dom::IPCClientWindowState paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCClientWorkerState|
//
namespace mozilla {
namespace dom {
class IPCClientWorkerState final
{
private:
    typedef ::mozilla::StorageAccess StorageAccess;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCClientWorkerState() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCClientWorkerState(const StorageAccess& _storageAccess) :
        storageAccess_(_storageAccess)
    {
    }

    MOZ_IMPLICIT IPCClientWorkerState(StorageAccess&& _storageAccess) :
        storageAccess_(std::move(_storageAccess))
    {
    }

    StorageAccess&
    storageAccess()
    {
        return storageAccess_;
    }
    const StorageAccess&
    storageAccess() const
    {
        return storageAccess_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<StorageAccess> storageAccess_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCClientWorkerState>
{
    typedef ::mozilla::dom::IPCClientWorkerState paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union IPCClientState|
//
namespace mozilla {
namespace dom {
class IPCClientState final
{
public:
    enum Type {
        T__None,
        TIPCClientWindowState = 1,
        TIPCClientWorkerState,
        T__Last = TIPCClientWorkerState
    };

private:
    typedef ::mozilla::dom::IPCClientWindowState IPCClientWindowState;
    typedef ::mozilla::dom::IPCClientWorkerState IPCClientWorkerState;
    typedef IPCClientWindowState IPCClientWindowState__tdef;
    typedef IPCClientWorkerState IPCClientWorkerState__tdef;

    IPCClientWindowState*
    ptr_IPCClientWindowState()
    {
        return (&(mVIPCClientWindowState));
    }
    const IPCClientWindowState*
    constptr_IPCClientWindowState() const
    {
        return (&(mVIPCClientWindowState));
    }
    IPCClientWorkerState*
    ptr_IPCClientWorkerState()
    {
        return (&(mVIPCClientWorkerState));
    }
    const IPCClientWorkerState*
    constptr_IPCClientWorkerState() const
    {
        return (&(mVIPCClientWorkerState));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT IPCClientState() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT IPCClientState(const IPCClientWindowState& aOther);

    MOZ_IMPLICIT IPCClientState(IPCClientWindowState&& aOther);

    MOZ_IMPLICIT IPCClientState(const IPCClientWorkerState& aOther);

    MOZ_IMPLICIT IPCClientState(IPCClientWorkerState&& aOther);

    MOZ_IMPLICIT IPCClientState(const IPCClientState& aOther);

    MOZ_IMPLICIT IPCClientState(IPCClientState&& aOther);

    ~IPCClientState();

    Type
    type() const
    {
        return mType;
    }

    IPCClientState&
    operator=(const IPCClientWindowState& aRhs);

    IPCClientState&
    operator=(IPCClientWindowState&& aRhs);

    IPCClientState&
    operator=(const IPCClientWorkerState& aRhs);

    IPCClientState&
    operator=(IPCClientWorkerState&& aRhs);

    IPCClientState&
    operator=(const IPCClientState& aRhs);

    IPCClientState&
    operator=(IPCClientState&& aRhs);

    IPCClientWindowState&
    get_IPCClientWindowState()
    {
        AssertSanity(TIPCClientWindowState);
        return (*(ptr_IPCClientWindowState()));
    }
    const IPCClientWindowState&
    get_IPCClientWindowState() const
    {
        AssertSanity(TIPCClientWindowState);
        return (*(constptr_IPCClientWindowState()));
    }
    operator IPCClientWindowState&()
    {
        return get_IPCClientWindowState();
    }
    operator const IPCClientWindowState&() const
    {
        return get_IPCClientWindowState();
    }

    IPCClientWorkerState&
    get_IPCClientWorkerState()
    {
        AssertSanity(TIPCClientWorkerState);
        return (*(ptr_IPCClientWorkerState()));
    }
    const IPCClientWorkerState&
    get_IPCClientWorkerState() const
    {
        AssertSanity(TIPCClientWorkerState);
        return (*(constptr_IPCClientWorkerState()));
    }
    operator IPCClientWorkerState&()
    {
        return get_IPCClientWorkerState();
    }
    operator const IPCClientWorkerState&() const
    {
        return get_IPCClientWorkerState();
    }

private:
    union {
        IPCClientWindowState mVIPCClientWindowState;
        IPCClientWorkerState mVIPCClientWorkerState;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCClientState>
{
    typedef ::mozilla::dom::IPCClientState paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientInfoAndState|
//
namespace mozilla {
namespace dom {
class ClientInfoAndState final
{
private:
    typedef ::mozilla::dom::IPCClientInfo IPCClientInfo;
    typedef ::mozilla::dom::IPCClientState IPCClientState;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientInfoAndState() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientInfoAndState(
            const IPCClientInfo& _info,
            const IPCClientState& _state) :
        info_(_info),
        state_(_state)
    {
    }

    MOZ_IMPLICIT ClientInfoAndState(
            IPCClientInfo&& _info,
            IPCClientState&& _state) :
        info_(std::move(_info)),
        state_(std::move(_state))
    {
    }

    IPCClientInfo&
    info()
    {
        return info_;
    }
    const IPCClientInfo&
    info() const
    {
        return info_;
    }

    IPCClientState&
    state()
    {
        return state_;
    }
    const IPCClientState&
    state() const
    {
        return state_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCClientInfo> info_;
    ::mozilla::ipc::IPDLStructMember<IPCClientState> state_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientInfoAndState>
{
    typedef ::mozilla::dom::ClientInfoAndState paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union PostMessageSource|
//
namespace mozilla {
namespace dom {
class PostMessageSource final
{
public:
    enum Type {
        T__None,
        TClientInfoAndState = 1,
        TIPCServiceWorkerDescriptor,
        T__Last = TIPCServiceWorkerDescriptor
    };

private:
    typedef ::mozilla::dom::ClientInfoAndState ClientInfoAndState;
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;
    typedef ClientInfoAndState ClientInfoAndState__tdef;
    typedef IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor__tdef;

    ClientInfoAndState*
    ptr_ClientInfoAndState()
    {
        return (&(mVClientInfoAndState));
    }
    const ClientInfoAndState*
    constptr_ClientInfoAndState() const
    {
        return (&(mVClientInfoAndState));
    }
    IPCServiceWorkerDescriptor*
    ptr_IPCServiceWorkerDescriptor()
    {
        return (&(mVIPCServiceWorkerDescriptor));
    }
    const IPCServiceWorkerDescriptor*
    constptr_IPCServiceWorkerDescriptor() const
    {
        return (&(mVIPCServiceWorkerDescriptor));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT PostMessageSource() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT PostMessageSource(const ClientInfoAndState& aOther);

    MOZ_IMPLICIT PostMessageSource(ClientInfoAndState&& aOther);

    MOZ_IMPLICIT PostMessageSource(const IPCServiceWorkerDescriptor& aOther);

    MOZ_IMPLICIT PostMessageSource(IPCServiceWorkerDescriptor&& aOther);

    MOZ_IMPLICIT PostMessageSource(const PostMessageSource& aOther);

    MOZ_IMPLICIT PostMessageSource(PostMessageSource&& aOther);

    ~PostMessageSource();

    Type
    type() const
    {
        return mType;
    }

    PostMessageSource&
    operator=(const ClientInfoAndState& aRhs);

    PostMessageSource&
    operator=(ClientInfoAndState&& aRhs);

    PostMessageSource&
    operator=(const IPCServiceWorkerDescriptor& aRhs);

    PostMessageSource&
    operator=(IPCServiceWorkerDescriptor&& aRhs);

    PostMessageSource&
    operator=(const PostMessageSource& aRhs);

    PostMessageSource&
    operator=(PostMessageSource&& aRhs);

    ClientInfoAndState&
    get_ClientInfoAndState()
    {
        AssertSanity(TClientInfoAndState);
        return (*(ptr_ClientInfoAndState()));
    }
    const ClientInfoAndState&
    get_ClientInfoAndState() const
    {
        AssertSanity(TClientInfoAndState);
        return (*(constptr_ClientInfoAndState()));
    }
    operator ClientInfoAndState&()
    {
        return get_ClientInfoAndState();
    }
    operator const ClientInfoAndState&() const
    {
        return get_ClientInfoAndState();
    }

    IPCServiceWorkerDescriptor&
    get_IPCServiceWorkerDescriptor()
    {
        AssertSanity(TIPCServiceWorkerDescriptor);
        return (*(ptr_IPCServiceWorkerDescriptor()));
    }
    const IPCServiceWorkerDescriptor&
    get_IPCServiceWorkerDescriptor() const
    {
        AssertSanity(TIPCServiceWorkerDescriptor);
        return (*(constptr_IPCServiceWorkerDescriptor()));
    }
    operator IPCServiceWorkerDescriptor&()
    {
        return get_IPCServiceWorkerDescriptor();
    }
    operator const IPCServiceWorkerDescriptor&() const
    {
        return get_IPCServiceWorkerDescriptor();
    }

private:
    union {
        ClientInfoAndState mVClientInfoAndState;
        IPCServiceWorkerDescriptor mVIPCServiceWorkerDescriptor;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::PostMessageSource>
{
    typedef ::mozilla::dom::PostMessageSource paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientSourceExecutionReadyArgs|
//
namespace mozilla {
namespace dom {
class ClientSourceExecutionReadyArgs final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::FrameType FrameType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientSourceExecutionReadyArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientSourceExecutionReadyArgs(
            const nsCString& _url,
            const FrameType& _frameType) :
        url_(_url),
        frameType_(_frameType)
    {
    }

    MOZ_IMPLICIT ClientSourceExecutionReadyArgs(
            nsCString&& _url,
            FrameType&& _frameType) :
        url_(std::move(_url)),
        frameType_(std::move(_frameType))
    {
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    FrameType&
    frameType()
    {
        return frameType_;
    }
    const FrameType&
    frameType() const
    {
        return frameType_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<FrameType> frameType_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientSourceExecutionReadyArgs>
{
    typedef ::mozilla::dom::ClientSourceExecutionReadyArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientControlledArgs|
//
namespace mozilla {
namespace dom {
class ClientControlledArgs final
{
private:
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientControlledArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientControlledArgs(const IPCServiceWorkerDescriptor& _serviceWorker) :
        serviceWorker_(_serviceWorker)
    {
    }

    MOZ_IMPLICIT ClientControlledArgs(IPCServiceWorkerDescriptor&& _serviceWorker) :
        serviceWorker_(std::move(_serviceWorker))
    {
    }

    IPCServiceWorkerDescriptor&
    serviceWorker()
    {
        return serviceWorker_;
    }
    const IPCServiceWorkerDescriptor&
    serviceWorker() const
    {
        return serviceWorker_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerDescriptor> serviceWorker_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientControlledArgs>
{
    typedef ::mozilla::dom::ClientControlledArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientFocusArgs|
//
namespace mozilla {
namespace dom {
class ClientFocusArgs final
{
private:
    typedef ::mozilla::dom::CallerType CallerType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientFocusArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientFocusArgs(const CallerType& _callerType) :
        callerType_(_callerType)
    {
    }

    MOZ_IMPLICIT ClientFocusArgs(CallerType&& _callerType) :
        callerType_(std::move(_callerType))
    {
    }

    CallerType&
    callerType()
    {
        return callerType_;
    }
    const CallerType&
    callerType() const
    {
        return callerType_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CallerType> callerType_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientFocusArgs>
{
    typedef ::mozilla::dom::ClientFocusArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientNavigateArgs|
//
namespace mozilla {
namespace dom {
class ClientNavigateArgs final
{
private:
    typedef ::mozilla::dom::IPCClientInfo IPCClientInfo;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientNavigateArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientNavigateArgs(
            const IPCClientInfo& _target,
            const nsCString& _url,
            const nsCString& _baseURL,
            const IPCServiceWorkerDescriptor& _serviceWorker) :
        target_(_target),
        url_(_url),
        baseURL_(_baseURL),
        serviceWorker_(_serviceWorker)
    {
    }

    MOZ_IMPLICIT ClientNavigateArgs(
            IPCClientInfo&& _target,
            nsCString&& _url,
            nsCString&& _baseURL,
            IPCServiceWorkerDescriptor&& _serviceWorker) :
        target_(std::move(_target)),
        url_(std::move(_url)),
        baseURL_(std::move(_baseURL)),
        serviceWorker_(std::move(_serviceWorker))
    {
    }

    IPCClientInfo&
    target()
    {
        return target_;
    }
    const IPCClientInfo&
    target() const
    {
        return target_;
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    nsCString&
    baseURL()
    {
        return baseURL_;
    }
    const nsCString&
    baseURL() const
    {
        return baseURL_;
    }

    IPCServiceWorkerDescriptor&
    serviceWorker()
    {
        return serviceWorker_;
    }
    const IPCServiceWorkerDescriptor&
    serviceWorker() const
    {
        return serviceWorker_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCClientInfo> target_;
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<nsCString> baseURL_;
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerDescriptor> serviceWorker_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientNavigateArgs>
{
    typedef ::mozilla::dom::ClientNavigateArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientPostMessageArgs|
//
namespace mozilla {
namespace dom {
class ClientPostMessageArgs final
{
private:
    typedef ::mozilla::dom::ClonedMessageData ClonedMessageData;
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientPostMessageArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientPostMessageArgs(
            ClonedMessageData&& _clonedData,
            const IPCServiceWorkerDescriptor& _serviceWorker) :
        clonedData_(std::move(_clonedData)),
        serviceWorker_(_serviceWorker)
    {
    }

    MOZ_IMPLICIT ClientPostMessageArgs(
            ClonedMessageData&& _clonedData,
            IPCServiceWorkerDescriptor&& _serviceWorker) :
        clonedData_(std::move(_clonedData)),
        serviceWorker_(std::move(_serviceWorker))
    {
    }

    ClonedMessageData&
    clonedData()
    {
        return clonedData_;
    }
    const ClonedMessageData&
    clonedData() const
    {
        return clonedData_;
    }

    IPCServiceWorkerDescriptor&
    serviceWorker()
    {
        return serviceWorker_;
    }
    const IPCServiceWorkerDescriptor&
    serviceWorker() const
    {
        return serviceWorker_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ClonedMessageData> clonedData_;
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerDescriptor> serviceWorker_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientPostMessageArgs>
{
    typedef ::mozilla::dom::ClientPostMessageArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientMatchAllArgs|
//
namespace mozilla {
namespace dom {
class ClientMatchAllArgs final
{
private:
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;
    typedef ::mozilla::dom::ClientType ClientType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientMatchAllArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientMatchAllArgs(
            const IPCServiceWorkerDescriptor& _serviceWorker,
            const ClientType& _type,
            const bool& _includeUncontrolled) :
        serviceWorker_(_serviceWorker),
        type_(_type),
        includeUncontrolled_(_includeUncontrolled)
    {
    }

    MOZ_IMPLICIT ClientMatchAllArgs(
            IPCServiceWorkerDescriptor&& _serviceWorker,
            ClientType&& _type,
            bool&& _includeUncontrolled) :
        serviceWorker_(std::move(_serviceWorker)),
        type_(std::move(_type)),
        includeUncontrolled_(std::move(_includeUncontrolled))
    {
    }

    IPCServiceWorkerDescriptor&
    serviceWorker()
    {
        return serviceWorker_;
    }
    const IPCServiceWorkerDescriptor&
    serviceWorker() const
    {
        return serviceWorker_;
    }

    ClientType&
    type()
    {
        return type_;
    }
    const ClientType&
    type() const
    {
        return type_;
    }

    bool&
    includeUncontrolled()
    {
        return includeUncontrolled_;
    }
    const bool&
    includeUncontrolled() const
    {
        return includeUncontrolled_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerDescriptor> serviceWorker_;
    ::mozilla::ipc::IPDLStructMember<ClientType> type_;
    ::mozilla::ipc::IPDLStructMember<bool> includeUncontrolled_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientMatchAllArgs>
{
    typedef ::mozilla::dom::ClientMatchAllArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientClaimArgs|
//
namespace mozilla {
namespace dom {
class ClientClaimArgs final
{
private:
    typedef ::mozilla::dom::IPCServiceWorkerDescriptor IPCServiceWorkerDescriptor;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientClaimArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientClaimArgs(const IPCServiceWorkerDescriptor& _serviceWorker) :
        serviceWorker_(_serviceWorker)
    {
    }

    MOZ_IMPLICIT ClientClaimArgs(IPCServiceWorkerDescriptor&& _serviceWorker) :
        serviceWorker_(std::move(_serviceWorker))
    {
    }

    IPCServiceWorkerDescriptor&
    serviceWorker()
    {
        return serviceWorker_;
    }
    const IPCServiceWorkerDescriptor&
    serviceWorker() const
    {
        return serviceWorker_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCServiceWorkerDescriptor> serviceWorker_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientClaimArgs>
{
    typedef ::mozilla::dom::ClientClaimArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientGetInfoAndStateArgs|
//
namespace mozilla {
namespace dom {
class ClientGetInfoAndStateArgs final
{
private:
    typedef ::nsID nsID;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientGetInfoAndStateArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientGetInfoAndStateArgs(
            const nsID& _id,
            const PrincipalInfo& _principalInfo) :
        id_(_id),
        principalInfo_(_principalInfo)
    {
    }

    MOZ_IMPLICIT ClientGetInfoAndStateArgs(
            nsID&& _id,
            PrincipalInfo&& _principalInfo) :
        id_(std::move(_id)),
        principalInfo_(std::move(_principalInfo))
    {
    }

    nsID&
    id()
    {
        return id_;
    }
    const nsID&
    id() const
    {
        return id_;
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> id_;
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientGetInfoAndStateArgs>
{
    typedef ::mozilla::dom::ClientGetInfoAndStateArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientOpenWindowArgs|
//
namespace mozilla {
namespace dom {
class ClientOpenWindowArgs final
{
private:
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::ipc::CSPInfo CSPInfo;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientOpenWindowArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientOpenWindowArgs(
            const PrincipalInfo& _principalInfo,
            const mozilla::Maybe<CSPInfo>& _cspInfo,
            const nsCString& _url,
            const nsCString& _baseURL) :
        principalInfo_(_principalInfo),
        cspInfo_(_cspInfo),
        url_(_url),
        baseURL_(_baseURL)
    {
    }

    MOZ_IMPLICIT ClientOpenWindowArgs(
            PrincipalInfo&& _principalInfo,
            mozilla::Maybe<CSPInfo>&& _cspInfo,
            nsCString&& _url,
            nsCString&& _baseURL) :
        principalInfo_(std::move(_principalInfo)),
        cspInfo_(std::move(_cspInfo)),
        url_(std::move(_url)),
        baseURL_(std::move(_baseURL))
    {
    }

    PrincipalInfo&
    principalInfo()
    {
        return principalInfo_;
    }
    const PrincipalInfo&
    principalInfo() const
    {
        return principalInfo_;
    }

    mozilla::Maybe<CSPInfo>&
    cspInfo()
    {
        return cspInfo_;
    }
    const mozilla::Maybe<CSPInfo>&
    cspInfo() const
    {
        return cspInfo_;
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    nsCString&
    baseURL()
    {
        return baseURL_;
    }
    const nsCString&
    baseURL() const
    {
        return baseURL_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PrincipalInfo> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CSPInfo>> cspInfo_;
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<nsCString> baseURL_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientOpenWindowArgs>
{
    typedef ::mozilla::dom::ClientOpenWindowArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientEvictBFCacheArgs|
//
namespace mozilla {
namespace dom {
class ClientEvictBFCacheArgs final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientEvictBFCacheArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientEvictBFCacheArgs>
{
    typedef ::mozilla::dom::ClientEvictBFCacheArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ClientOpConstructorArgs|
//
namespace mozilla {
namespace dom {
class ClientOpConstructorArgs final
{
public:
    enum Type {
        T__None,
        TClientControlledArgs = 1,
        TClientFocusArgs,
        TClientNavigateArgs,
        TClientPostMessageArgs,
        TClientMatchAllArgs,
        TClientClaimArgs,
        TClientGetInfoAndStateArgs,
        TClientOpenWindowArgs,
        TClientEvictBFCacheArgs,
        T__Last = TClientEvictBFCacheArgs
    };

private:
    typedef ::mozilla::dom::ClientControlledArgs ClientControlledArgs;
    typedef ::mozilla::dom::ClientFocusArgs ClientFocusArgs;
    typedef ::mozilla::dom::ClientNavigateArgs ClientNavigateArgs;
    typedef ::mozilla::dom::ClientPostMessageArgs ClientPostMessageArgs;
    typedef ::mozilla::dom::ClientMatchAllArgs ClientMatchAllArgs;
    typedef ::mozilla::dom::ClientClaimArgs ClientClaimArgs;
    typedef ::mozilla::dom::ClientGetInfoAndStateArgs ClientGetInfoAndStateArgs;
    typedef ::mozilla::dom::ClientOpenWindowArgs ClientOpenWindowArgs;
    typedef ::mozilla::dom::ClientEvictBFCacheArgs ClientEvictBFCacheArgs;
    typedef ClientControlledArgs ClientControlledArgs__tdef;
    typedef ClientFocusArgs ClientFocusArgs__tdef;
    typedef ClientNavigateArgs ClientNavigateArgs__tdef;
    typedef ClientPostMessageArgs ClientPostMessageArgs__tdef;
    typedef ClientMatchAllArgs ClientMatchAllArgs__tdef;
    typedef ClientClaimArgs ClientClaimArgs__tdef;
    typedef ClientGetInfoAndStateArgs ClientGetInfoAndStateArgs__tdef;
    typedef ClientOpenWindowArgs ClientOpenWindowArgs__tdef;
    typedef ClientEvictBFCacheArgs ClientEvictBFCacheArgs__tdef;

    ClientControlledArgs*
    ptr_ClientControlledArgs()
    {
        return (&(mVClientControlledArgs));
    }
    const ClientControlledArgs*
    constptr_ClientControlledArgs() const
    {
        return (&(mVClientControlledArgs));
    }
    ClientFocusArgs*
    ptr_ClientFocusArgs()
    {
        return (&(mVClientFocusArgs));
    }
    const ClientFocusArgs*
    constptr_ClientFocusArgs() const
    {
        return (&(mVClientFocusArgs));
    }
    ClientNavigateArgs*
    ptr_ClientNavigateArgs()
    {
        return (&(mVClientNavigateArgs));
    }
    const ClientNavigateArgs*
    constptr_ClientNavigateArgs() const
    {
        return (&(mVClientNavigateArgs));
    }
    ClientPostMessageArgs*
    ptr_ClientPostMessageArgs()
    {
        return (&(mVClientPostMessageArgs));
    }
    const ClientPostMessageArgs*
    constptr_ClientPostMessageArgs() const
    {
        return (&(mVClientPostMessageArgs));
    }
    ClientMatchAllArgs*
    ptr_ClientMatchAllArgs()
    {
        return (&(mVClientMatchAllArgs));
    }
    const ClientMatchAllArgs*
    constptr_ClientMatchAllArgs() const
    {
        return (&(mVClientMatchAllArgs));
    }
    ClientClaimArgs*
    ptr_ClientClaimArgs()
    {
        return (&(mVClientClaimArgs));
    }
    const ClientClaimArgs*
    constptr_ClientClaimArgs() const
    {
        return (&(mVClientClaimArgs));
    }
    ClientGetInfoAndStateArgs*
    ptr_ClientGetInfoAndStateArgs()
    {
        return (&(mVClientGetInfoAndStateArgs));
    }
    const ClientGetInfoAndStateArgs*
    constptr_ClientGetInfoAndStateArgs() const
    {
        return (&(mVClientGetInfoAndStateArgs));
    }
    ClientOpenWindowArgs*
    ptr_ClientOpenWindowArgs()
    {
        return (&(mVClientOpenWindowArgs));
    }
    const ClientOpenWindowArgs*
    constptr_ClientOpenWindowArgs() const
    {
        return (&(mVClientOpenWindowArgs));
    }
    ClientEvictBFCacheArgs*
    ptr_ClientEvictBFCacheArgs()
    {
        return (&(mVClientEvictBFCacheArgs));
    }
    const ClientEvictBFCacheArgs*
    constptr_ClientEvictBFCacheArgs() const
    {
        return (&(mVClientEvictBFCacheArgs));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ClientOpConstructorArgs() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientControlledArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientControlledArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientFocusArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientFocusArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientNavigateArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientNavigateArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientPostMessageArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientMatchAllArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientMatchAllArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientClaimArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientClaimArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientGetInfoAndStateArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientGetInfoAndStateArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientOpenWindowArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientOpenWindowArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(const ClientEvictBFCacheArgs& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientEvictBFCacheArgs&& aOther);

    MOZ_IMPLICIT ClientOpConstructorArgs(ClientOpConstructorArgs&& aOther);

    ~ClientOpConstructorArgs();

    Type
    type() const
    {
        return mType;
    }

    ClientOpConstructorArgs&
    operator=(const ClientControlledArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientControlledArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientFocusArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientFocusArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientNavigateArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientNavigateArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientPostMessageArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientMatchAllArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientMatchAllArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientClaimArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientClaimArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientGetInfoAndStateArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientGetInfoAndStateArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientOpenWindowArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientOpenWindowArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(const ClientEvictBFCacheArgs& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientEvictBFCacheArgs&& aRhs);

    ClientOpConstructorArgs&
    operator=(ClientOpConstructorArgs&& aRhs);

    ClientControlledArgs&
    get_ClientControlledArgs()
    {
        AssertSanity(TClientControlledArgs);
        return (*(ptr_ClientControlledArgs()));
    }
    const ClientControlledArgs&
    get_ClientControlledArgs() const
    {
        AssertSanity(TClientControlledArgs);
        return (*(constptr_ClientControlledArgs()));
    }
    operator ClientControlledArgs&()
    {
        return get_ClientControlledArgs();
    }
    operator const ClientControlledArgs&() const
    {
        return get_ClientControlledArgs();
    }

    ClientFocusArgs&
    get_ClientFocusArgs()
    {
        AssertSanity(TClientFocusArgs);
        return (*(ptr_ClientFocusArgs()));
    }
    const ClientFocusArgs&
    get_ClientFocusArgs() const
    {
        AssertSanity(TClientFocusArgs);
        return (*(constptr_ClientFocusArgs()));
    }
    operator ClientFocusArgs&()
    {
        return get_ClientFocusArgs();
    }
    operator const ClientFocusArgs&() const
    {
        return get_ClientFocusArgs();
    }

    ClientNavigateArgs&
    get_ClientNavigateArgs()
    {
        AssertSanity(TClientNavigateArgs);
        return (*(ptr_ClientNavigateArgs()));
    }
    const ClientNavigateArgs&
    get_ClientNavigateArgs() const
    {
        AssertSanity(TClientNavigateArgs);
        return (*(constptr_ClientNavigateArgs()));
    }
    operator ClientNavigateArgs&()
    {
        return get_ClientNavigateArgs();
    }
    operator const ClientNavigateArgs&() const
    {
        return get_ClientNavigateArgs();
    }

    ClientPostMessageArgs&
    get_ClientPostMessageArgs()
    {
        AssertSanity(TClientPostMessageArgs);
        return (*(ptr_ClientPostMessageArgs()));
    }
    const ClientPostMessageArgs&
    get_ClientPostMessageArgs() const
    {
        AssertSanity(TClientPostMessageArgs);
        return (*(constptr_ClientPostMessageArgs()));
    }
    operator ClientPostMessageArgs&()
    {
        return get_ClientPostMessageArgs();
    }
    operator const ClientPostMessageArgs&() const
    {
        return get_ClientPostMessageArgs();
    }

    ClientMatchAllArgs&
    get_ClientMatchAllArgs()
    {
        AssertSanity(TClientMatchAllArgs);
        return (*(ptr_ClientMatchAllArgs()));
    }
    const ClientMatchAllArgs&
    get_ClientMatchAllArgs() const
    {
        AssertSanity(TClientMatchAllArgs);
        return (*(constptr_ClientMatchAllArgs()));
    }
    operator ClientMatchAllArgs&()
    {
        return get_ClientMatchAllArgs();
    }
    operator const ClientMatchAllArgs&() const
    {
        return get_ClientMatchAllArgs();
    }

    ClientClaimArgs&
    get_ClientClaimArgs()
    {
        AssertSanity(TClientClaimArgs);
        return (*(ptr_ClientClaimArgs()));
    }
    const ClientClaimArgs&
    get_ClientClaimArgs() const
    {
        AssertSanity(TClientClaimArgs);
        return (*(constptr_ClientClaimArgs()));
    }
    operator ClientClaimArgs&()
    {
        return get_ClientClaimArgs();
    }
    operator const ClientClaimArgs&() const
    {
        return get_ClientClaimArgs();
    }

    ClientGetInfoAndStateArgs&
    get_ClientGetInfoAndStateArgs()
    {
        AssertSanity(TClientGetInfoAndStateArgs);
        return (*(ptr_ClientGetInfoAndStateArgs()));
    }
    const ClientGetInfoAndStateArgs&
    get_ClientGetInfoAndStateArgs() const
    {
        AssertSanity(TClientGetInfoAndStateArgs);
        return (*(constptr_ClientGetInfoAndStateArgs()));
    }
    operator ClientGetInfoAndStateArgs&()
    {
        return get_ClientGetInfoAndStateArgs();
    }
    operator const ClientGetInfoAndStateArgs&() const
    {
        return get_ClientGetInfoAndStateArgs();
    }

    ClientOpenWindowArgs&
    get_ClientOpenWindowArgs()
    {
        AssertSanity(TClientOpenWindowArgs);
        return (*(ptr_ClientOpenWindowArgs()));
    }
    const ClientOpenWindowArgs&
    get_ClientOpenWindowArgs() const
    {
        AssertSanity(TClientOpenWindowArgs);
        return (*(constptr_ClientOpenWindowArgs()));
    }
    operator ClientOpenWindowArgs&()
    {
        return get_ClientOpenWindowArgs();
    }
    operator const ClientOpenWindowArgs&() const
    {
        return get_ClientOpenWindowArgs();
    }

    ClientEvictBFCacheArgs&
    get_ClientEvictBFCacheArgs()
    {
        AssertSanity(TClientEvictBFCacheArgs);
        return (*(ptr_ClientEvictBFCacheArgs()));
    }
    const ClientEvictBFCacheArgs&
    get_ClientEvictBFCacheArgs() const
    {
        AssertSanity(TClientEvictBFCacheArgs);
        return (*(constptr_ClientEvictBFCacheArgs()));
    }
    operator ClientEvictBFCacheArgs&()
    {
        return get_ClientEvictBFCacheArgs();
    }
    operator const ClientEvictBFCacheArgs&() const
    {
        return get_ClientEvictBFCacheArgs();
    }

private:
    union {
        ClientControlledArgs mVClientControlledArgs;
        ClientFocusArgs mVClientFocusArgs;
        ClientNavigateArgs mVClientNavigateArgs;
        ClientPostMessageArgs mVClientPostMessageArgs;
        ClientMatchAllArgs mVClientMatchAllArgs;
        ClientClaimArgs mVClientClaimArgs;
        ClientGetInfoAndStateArgs mVClientGetInfoAndStateArgs;
        ClientOpenWindowArgs mVClientOpenWindowArgs;
        ClientEvictBFCacheArgs mVClientEvictBFCacheArgs;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientOpConstructorArgs>
{
    typedef ::mozilla::dom::ClientOpConstructorArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientList|
//
namespace mozilla {
namespace dom {
class ClientList final
{
private:
    typedef ::mozilla::dom::ClientInfoAndState ClientInfoAndState;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientList() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientList(const nsTArray<ClientInfoAndState>& _values) :
        values_(_values)
    {
    }

    MOZ_IMPLICIT ClientList(nsTArray<ClientInfoAndState>&& _values) :
        values_(std::move(_values))
    {
    }

    nsTArray<ClientInfoAndState>&
    values()
    {
        return values_;
    }
    const nsTArray<ClientInfoAndState>&
    values() const
    {
        return values_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<ClientInfoAndState>> values_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientList>
{
    typedef ::mozilla::dom::ClientList paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PClientSourceParent;
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class PClientSourceChild;
} // namespace dom
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClientNavigateOpConstructorArgs|
//
namespace mozilla {
namespace dom {
class ClientNavigateOpConstructorArgs final
{
private:
    typedef ::mozilla::dom::PClientSourceParent PClientSourceParent;
    typedef ::mozilla::dom::PClientSourceChild PClientSourceChild;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClientNavigateOpConstructorArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClientNavigateOpConstructorArgs(
            const mozilla::NotNull<::mozilla::ipc::SideVariant<PClientSourceParent*, PClientSourceChild*>>& _target,
            const nsCString& _url,
            const nsCString& _baseURL) :
        target_(_target),
        url_(_url),
        baseURL_(_baseURL)
    {
    }

    MOZ_IMPLICIT ClientNavigateOpConstructorArgs(
            mozilla::NotNull<::mozilla::ipc::SideVariant<PClientSourceParent*, PClientSourceChild*>>&& _target,
            nsCString&& _url,
            nsCString&& _baseURL) :
        target_(std::move(_target)),
        url_(std::move(_url)),
        baseURL_(std::move(_baseURL))
    {
    }

    mozilla::NotNull<::mozilla::ipc::SideVariant<PClientSourceParent*, PClientSourceChild*>>&
    target()
    {
        return target_;
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PClientSourceParent*, PClientSourceChild*>>&
    target() const
    {
        return target_;
    }

    nsCString&
    url()
    {
        return url_;
    }
    const nsCString&
    url() const
    {
        return url_;
    }

    nsCString&
    baseURL()
    {
        return baseURL_;
    }
    const nsCString&
    baseURL() const
    {
        return baseURL_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<::mozilla::ipc::SideVariant<PClientSourceParent*, PClientSourceChild*>>> target_;
    ::mozilla::ipc::IPDLStructMember<nsCString> url_;
    ::mozilla::ipc::IPDLStructMember<nsCString> baseURL_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientNavigateOpConstructorArgs>
{
    typedef ::mozilla::dom::ClientNavigateOpConstructorArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ClientOpResult|
//
namespace mozilla {
namespace dom {
class ClientOpResult final
{
public:
    enum Type {
        T__None,
        TCopyableErrorResult = 1,
        TIPCClientState,
        TClientInfoAndState,
        TClientList,
        T__Last = TClientList
    };

private:
    typedef ::mozilla::CopyableErrorResult CopyableErrorResult;
    typedef ::mozilla::dom::IPCClientState IPCClientState;
    typedef ::mozilla::dom::ClientInfoAndState ClientInfoAndState;
    typedef ::mozilla::dom::ClientList ClientList;
    typedef CopyableErrorResult CopyableErrorResult__tdef;
    typedef IPCClientState IPCClientState__tdef;
    typedef ClientInfoAndState ClientInfoAndState__tdef;
    typedef ClientList ClientList__tdef;

    CopyableErrorResult*
    ptr_CopyableErrorResult()
    {
        return (&(mVCopyableErrorResult));
    }
    const CopyableErrorResult*
    constptr_CopyableErrorResult() const
    {
        return (&(mVCopyableErrorResult));
    }
    IPCClientState*
    ptr_IPCClientState()
    {
        return (&(mVIPCClientState));
    }
    const IPCClientState*
    constptr_IPCClientState() const
    {
        return (&(mVIPCClientState));
    }
    ClientInfoAndState*
    ptr_ClientInfoAndState()
    {
        return (&(mVClientInfoAndState));
    }
    const ClientInfoAndState*
    constptr_ClientInfoAndState() const
    {
        return (&(mVClientInfoAndState));
    }
    ClientList*
    ptr_ClientList()
    {
        return (&(mVClientList));
    }
    const ClientList*
    constptr_ClientList() const
    {
        return (&(mVClientList));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ClientOpResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ClientOpResult(const CopyableErrorResult& aOther);

    MOZ_IMPLICIT ClientOpResult(CopyableErrorResult&& aOther);

    MOZ_IMPLICIT ClientOpResult(const IPCClientState& aOther);

    MOZ_IMPLICIT ClientOpResult(IPCClientState&& aOther);

    MOZ_IMPLICIT ClientOpResult(const ClientInfoAndState& aOther);

    MOZ_IMPLICIT ClientOpResult(ClientInfoAndState&& aOther);

    MOZ_IMPLICIT ClientOpResult(const ClientList& aOther);

    MOZ_IMPLICIT ClientOpResult(ClientList&& aOther);

    MOZ_IMPLICIT ClientOpResult(const ClientOpResult& aOther);

    MOZ_IMPLICIT ClientOpResult(ClientOpResult&& aOther);

    ~ClientOpResult();

    Type
    type() const
    {
        return mType;
    }

    ClientOpResult&
    operator=(const CopyableErrorResult& aRhs);

    ClientOpResult&
    operator=(CopyableErrorResult&& aRhs);

    ClientOpResult&
    operator=(const IPCClientState& aRhs);

    ClientOpResult&
    operator=(IPCClientState&& aRhs);

    ClientOpResult&
    operator=(const ClientInfoAndState& aRhs);

    ClientOpResult&
    operator=(ClientInfoAndState&& aRhs);

    ClientOpResult&
    operator=(const ClientList& aRhs);

    ClientOpResult&
    operator=(ClientList&& aRhs);

    ClientOpResult&
    operator=(const ClientOpResult& aRhs);

    ClientOpResult&
    operator=(ClientOpResult&& aRhs);

    CopyableErrorResult&
    get_CopyableErrorResult()
    {
        AssertSanity(TCopyableErrorResult);
        return (*(ptr_CopyableErrorResult()));
    }
    const CopyableErrorResult&
    get_CopyableErrorResult() const
    {
        AssertSanity(TCopyableErrorResult);
        return (*(constptr_CopyableErrorResult()));
    }
    operator CopyableErrorResult&()
    {
        return get_CopyableErrorResult();
    }
    operator const CopyableErrorResult&() const
    {
        return get_CopyableErrorResult();
    }

    IPCClientState&
    get_IPCClientState()
    {
        AssertSanity(TIPCClientState);
        return (*(ptr_IPCClientState()));
    }
    const IPCClientState&
    get_IPCClientState() const
    {
        AssertSanity(TIPCClientState);
        return (*(constptr_IPCClientState()));
    }
    operator IPCClientState&()
    {
        return get_IPCClientState();
    }
    operator const IPCClientState&() const
    {
        return get_IPCClientState();
    }

    ClientInfoAndState&
    get_ClientInfoAndState()
    {
        AssertSanity(TClientInfoAndState);
        return (*(ptr_ClientInfoAndState()));
    }
    const ClientInfoAndState&
    get_ClientInfoAndState() const
    {
        AssertSanity(TClientInfoAndState);
        return (*(constptr_ClientInfoAndState()));
    }
    operator ClientInfoAndState&()
    {
        return get_ClientInfoAndState();
    }
    operator const ClientInfoAndState&() const
    {
        return get_ClientInfoAndState();
    }

    ClientList&
    get_ClientList()
    {
        AssertSanity(TClientList);
        return (*(ptr_ClientList()));
    }
    const ClientList&
    get_ClientList() const
    {
        AssertSanity(TClientList);
        return (*(constptr_ClientList()));
    }
    operator ClientList&()
    {
        return get_ClientList();
    }
    operator const ClientList&() const
    {
        return get_ClientList();
    }

private:
    union {
        CopyableErrorResult mVCopyableErrorResult;
        IPCClientState mVIPCClientState;
        ClientInfoAndState mVClientInfoAndState;
        ClientList mVClientList;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClientOpResult>
{
    typedef ::mozilla::dom::ClientOpResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef ClientIPCTypes_h
