//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PHeapSnapshotTempFileHelper_h
#define PHeapSnapshotTempFileHelper_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/ipc/IPDLStructMember.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpenedFile|
//
namespace mozilla {
namespace devtools {
class OpenedFile final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::ipc::FileDescriptor FileDescriptor;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpenedFile() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpenedFile(
            const nsString& _path,
            const nsString& _snapshotId,
            const FileDescriptor& _descriptor) :
        path_(_path),
        snapshotId_(_snapshotId),
        descriptor_(_descriptor)
    {
    }

    MOZ_IMPLICIT OpenedFile(
            nsString&& _path,
            nsString&& _snapshotId,
            FileDescriptor&& _descriptor) :
        path_(std::move(_path)),
        snapshotId_(std::move(_snapshotId)),
        descriptor_(std::move(_descriptor))
    {
    }

    nsString&
    path()
    {
        return path_;
    }
    const nsString&
    path() const
    {
        return path_;
    }

    nsString&
    snapshotId()
    {
        return snapshotId_;
    }
    const nsString&
    snapshotId() const
    {
        return snapshotId_;
    }

    FileDescriptor&
    descriptor()
    {
        return descriptor_;
    }
    const FileDescriptor&
    descriptor() const
    {
        return descriptor_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> path_;
    ::mozilla::ipc::IPDLStructMember<nsString> snapshotId_;
    ::mozilla::ipc::IPDLStructMember<FileDescriptor> descriptor_;
};
} // namespace devtools
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::devtools::OpenedFile>
{
    typedef ::mozilla::devtools::OpenedFile paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OpenHeapSnapshotTempFileResponse|
//
namespace mozilla {
namespace devtools {
class OpenHeapSnapshotTempFileResponse final
{
public:
    enum Type {
        T__None,
        Tnsresult = 1,
        TOpenedFile,
        T__Last = TOpenedFile
    };

private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::devtools::OpenedFile OpenedFile;
    typedef nsresult nsresult__tdef;
    typedef OpenedFile OpenedFile__tdef;

    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }
    OpenedFile*
    ptr_OpenedFile()
    {
        return (&(mVOpenedFile));
    }
    const OpenedFile*
    constptr_OpenedFile() const
    {
        return (&(mVOpenedFile));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse(const nsresult& aOther);

    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse(nsresult&& aOther);

    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse(const OpenedFile& aOther);

    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse(OpenedFile&& aOther);

    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse(const OpenHeapSnapshotTempFileResponse& aOther);

    MOZ_IMPLICIT OpenHeapSnapshotTempFileResponse(OpenHeapSnapshotTempFileResponse&& aOther);

    ~OpenHeapSnapshotTempFileResponse();

    Type
    type() const
    {
        return mType;
    }

    OpenHeapSnapshotTempFileResponse&
    operator=(const nsresult& aRhs);

    OpenHeapSnapshotTempFileResponse&
    operator=(nsresult&& aRhs);

    OpenHeapSnapshotTempFileResponse&
    operator=(const OpenedFile& aRhs);

    OpenHeapSnapshotTempFileResponse&
    operator=(OpenedFile&& aRhs);

    OpenHeapSnapshotTempFileResponse&
    operator=(const OpenHeapSnapshotTempFileResponse& aRhs);

    OpenHeapSnapshotTempFileResponse&
    operator=(OpenHeapSnapshotTempFileResponse&& aRhs);

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

    OpenedFile&
    get_OpenedFile()
    {
        AssertSanity(TOpenedFile);
        return (*(ptr_OpenedFile()));
    }
    const OpenedFile&
    get_OpenedFile() const
    {
        AssertSanity(TOpenedFile);
        return (*(constptr_OpenedFile()));
    }
    operator OpenedFile&()
    {
        return get_OpenedFile();
    }
    operator const OpenedFile&() const
    {
        return get_OpenedFile();
    }

private:
    union {
        nsresult mVnsresult;
        OpenedFile mVOpenedFile;
    };
    Type mType;
};
} // namespace devtools
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::devtools::OpenHeapSnapshotTempFileResponse>
{
    typedef ::mozilla::devtools::OpenHeapSnapshotTempFileResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace devtools {
class PHeapSnapshotTempFileHelperParent;
} // namespace devtools
} // namespace mozilla
namespace mozilla {
namespace devtools {
class PHeapSnapshotTempFileHelperChild;
} // namespace devtools
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PHeapSnapshotTempFileHelperChild and PHeapSnapshotTempFileHelperParent
//
namespace mozilla {
namespace devtools {
namespace PHeapSnapshotTempFileHelper {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::devtools::PHeapSnapshotTempFileHelperParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::devtools::PHeapSnapshotTempFileHelperChild>* aChild);

enum MessageType {
    PHeapSnapshotTempFileHelperStart = PHeapSnapshotTempFileHelperMsgStart << 16,
    Msg_OpenHeapSnapshotTempFile__ID,
    Reply_OpenHeapSnapshotTempFile__ID,
    Msg___delete____ID,
    Reply___delete____ID,
    PHeapSnapshotTempFileHelperEnd
};

mozilla::UniquePtr<IPC::Message>
Msg_OpenHeapSnapshotTempFile(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply_OpenHeapSnapshotTempFile(int32_t routingId);

mozilla::UniquePtr<IPC::Message>
Msg___delete__(int32_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply___delete__(int32_t routingId);



} // namespace PHeapSnapshotTempFileHelper
} // namespace devtools
} // namespace mozilla

#endif // ifndef PHeapSnapshotTempFileHelper_h
