//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebrtcGlobalParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/RTCStatsReportBinding.h"
#include "mozilla/media/webrtc/WebrtcGlobal.h"

#include "mozilla/dom/PContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PWebrtcGlobalParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PWebrtcGlobalParent::PWebrtcGlobalParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebrtcGlobalParent);
}

PWebrtcGlobalParent::~PWebrtcGlobalParent()
{
    MOZ_COUNT_DTOR(PWebrtcGlobalParent);
}

auto PWebrtcGlobalParent::ActorAlloc() -> void
{
}

auto PWebrtcGlobalParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PWebrtcGlobalParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebrtcGlobalParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebrtcGlobalParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebrtcGlobalParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PWebrtcGlobalParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebrtcGlobalParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebrtcGlobalParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebrtcGlobalParent::SendGetStats(
        const nsAString& aPcIdFilter,
        mozilla::ipc::ResolveCallback<nsTArray<RTCStatsReportInternal>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_GetStats(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPcIdFilter);
    // Sentinel = 'aPcIdFilter'
    ((&(writer__)))->WriteSentinel(399377448);




    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_GetStats", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebrtcGlobal::Reply_GetStats__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__stats = IPC::ReadParam<nsTArray<RTCStatsReportInternal>>(aReader);
            if (!maybe__stats) {
                (aReader)->FatalError("Error deserializing 'RTCStatsReportInternal[]'");
                return MsgValueError;

            }
            auto& stats = *maybe__stats;
            // Sentinel = 'stats'
            if ((!((aReader)->ReadSentinel(110232112)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RTCStatsReportInternal[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(stats));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebrtcGlobalParent::SendGetStats(const nsAString& aPcIdFilter) -> RefPtr<GetStatsPromise>
{
    RefPtr<MozPromise<nsTArray<RTCStatsReportInternal>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<RTCStatsReportInternal>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetStats(std::move(aPcIdFilter), [promise__](nsTArray<RTCStatsReportInternal>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebrtcGlobalParent::SendClearStats() -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_ClearStats(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_ClearStats", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebrtcGlobalParent::SendGetLog(
        mozilla::ipc::ResolveCallback<WebrtcGlobalLog>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_GetLog(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_GetLog", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebrtcGlobal::Reply_GetLog__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__logs = IPC::ReadParam<WebrtcGlobalLog>(aReader);
            if (!maybe__logs) {
                (aReader)->FatalError("Error deserializing 'WebrtcGlobalLog'");
                return MsgValueError;

            }
            auto& logs = *maybe__logs;
            // Sentinel = 'logs'
            if ((!((aReader)->ReadSentinel(71434678)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebrtcGlobalLog'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(logs));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebrtcGlobalParent::SendGetLog() -> RefPtr<GetLogPromise>
{
    RefPtr<MozPromise<WebrtcGlobalLog, ResponseRejectReason, true>::Private> promise__ = new MozPromise<WebrtcGlobalLog, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetLog([promise__](WebrtcGlobalLog&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebrtcGlobalParent::SendClearLog() -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_ClearLog(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_ClearLog", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebrtcGlobalParent::SendSetAecLogging(const bool& aEnable) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_SetAecLogging(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aEnable);
    // Sentinel = 'aEnable'
    ((&(writer__)))->WriteSentinel(173605545);




    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_SetAecLogging", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebrtcGlobalParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebrtcGlobalParent::OnMessageReceived(const Message& msg__) -> PWebrtcGlobalParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_PeerConnectionCreated__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_PeerConnectionCreated", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPcId = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aPcId) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aPcId = *maybe__aPcId;
            // Sentinel = 'aPcId'
            if ((!(((&(reader__)))->ReadSentinel(88670658)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__aIsLongTermStatsDisabled = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aIsLongTermStatsDisabled) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aIsLongTermStatsDisabled = *maybe__aIsLongTermStatsDisabled;
            // Sentinel = 'aIsLongTermStatsDisabled'
            if ((!(((&(reader__)))->ReadSentinel(1953368429)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPeerConnectionCreated(std::move(aPcId), std::move(aIsLongTermStatsDisabled));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_PeerConnectionDestroyed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_PeerConnectionDestroyed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPcId = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aPcId) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aPcId = *maybe__aPcId;
            // Sentinel = 'aPcId'
            if ((!(((&(reader__)))->ReadSentinel(88670658)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPeerConnectionDestroyed(std::move(aPcId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_PeerConnectionFinalStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_PeerConnectionFinalStats", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFinalStats = IPC::ReadParam<RTCStatsReportInternal>((&(reader__)));
            if (!maybe__aFinalStats) {
                FatalError("Error deserializing 'RTCStatsReportInternal'");
                return MsgValueError;

            }
            auto& aFinalStats = *maybe__aFinalStats;
            // Sentinel = 'aFinalStats'
            if ((!(((&(reader__)))->ReadSentinel(422511707)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RTCStatsReportInternal'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPeerConnectionFinalStats(std::move(aFinalStats));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Reply_GetStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_GetStats", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebrtcGlobal::Reply_GetLog__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_GetLog", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebrtcGlobalParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebrtcGlobalParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebrtcGlobalParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PWebrtcGlobalParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebrtcGlobal", PWebrtcGlobalMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PWebrtcGlobalParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
