//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebrtcGlobalChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/RTCStatsReportBinding.h"
#include "mozilla/media/webrtc/WebrtcGlobal.h"

#include "mozilla/dom/PContentChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PWebrtcGlobalChild::PWebrtcGlobalChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PWebrtcGlobalChild);
}

PWebrtcGlobalChild::~PWebrtcGlobalChild()
{
    MOZ_COUNT_DTOR(PWebrtcGlobalChild);
}

auto PWebrtcGlobalChild::ActorAlloc() -> void
{
}

auto PWebrtcGlobalChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PWebrtcGlobalChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebrtcGlobalChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebrtcGlobalChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebrtcGlobalChild::Manager() const -> PContentChild*
{
    return static_cast<PContentChild*>(IProtocol::Manager());
}

auto PWebrtcGlobalChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebrtcGlobalChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebrtcGlobalChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebrtcGlobalChild::Send__delete__(PWebrtcGlobalChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebrtcGlobalChild::SendPeerConnectionCreated(
        const nsAString& aPcId,
        const bool& aIsLongTermStatsDisabled) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_PeerConnectionCreated(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPcId);
    // Sentinel = 'aPcId'
    ((&(writer__)))->WriteSentinel(88670658);
    IPC::WriteParam((&(writer__)), aIsLongTermStatsDisabled);
    // Sentinel = 'aIsLongTermStatsDisabled'
    ((&(writer__)))->WriteSentinel(1953368429);




    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_PeerConnectionCreated", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebrtcGlobalChild::SendPeerConnectionDestroyed(const nsAString& aPcId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_PeerConnectionDestroyed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPcId);
    // Sentinel = 'aPcId'
    ((&(writer__)))->WriteSentinel(88670658);




    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_PeerConnectionDestroyed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebrtcGlobalChild::SendPeerConnectionFinalStats(const RTCStatsReportInternal& aFinalStats) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebrtcGlobal::Msg_PeerConnectionFinalStats(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aFinalStats);
    // Sentinel = 'aFinalStats'
    ((&(writer__)))->WriteSentinel(422511707);




    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebrtcGlobalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_PeerConnectionFinalStats", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebrtcGlobalChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebrtcGlobalChild::OnMessageReceived(const Message& msg__) -> PWebrtcGlobalChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebrtcGlobal::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_GetStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_GetStats", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPcIdFilter = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aPcIdFilter) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aPcIdFilter = *maybe__aPcIdFilter;
            // Sentinel = 'aPcIdFilter'
            if ((!(((&(reader__)))->ReadSentinel(399377448)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebrtcGlobal::Reply_GetStats(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetStatsResolver resolver = [resolver__ = std::move(resolver__)](mozilla::Span<RTCStatsReportInternal const> aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'stats'
                    ((&(writer__)))->WriteSentinel(110232112);

                    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebrtcGlobalChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetStats(std::move(aPcIdFilter), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_ClearStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_ClearStats", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClearStats();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_GetLog__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_GetLog", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebrtcGlobal::Reply_GetLog(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetLogResolver resolver = [resolver__ = std::move(resolver__)](const WebrtcGlobalLog& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'logs'
                    ((&(writer__)))->WriteSentinel(71434678);

                    if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebrtcGlobalChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetLog(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_ClearLog__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_ClearLog", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClearLog();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebrtcGlobal::Msg_SetAecLogging__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebrtcGlobal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebrtcGlobalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebrtcGlobal::Msg_SetAecLogging", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aEnable = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aEnable) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aEnable = *maybe__aEnable;
            // Sentinel = 'aEnable'
            if ((!(((&(reader__)))->ReadSentinel(173605545)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetAecLogging(std::move(aEnable));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebrtcGlobalChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebrtcGlobalChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebrtcGlobalChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PWebrtcGlobalChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebrtcGlobal", PWebrtcGlobalMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PWebrtcGlobalChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
