//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/layers/PWebRenderBridgeParent.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/gfx/2D.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "nsPoint.h"
#include "nsRect.h"

#include "mozilla/layers/PCompositorBridgeParent.h"
#include "mozilla/layers/PTextureParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace layers {


MOZ_IMPLICIT PWebRenderBridgeParent::PWebRenderBridgeParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebRenderBridgeParent);
}

PWebRenderBridgeParent::~PWebRenderBridgeParent()
{
    MOZ_COUNT_DTOR(PWebRenderBridgeParent);
}

auto PWebRenderBridgeParent::ActorAlloc() -> void
{
}

auto PWebRenderBridgeParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PWebRenderBridgeParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebRenderBridgeParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebRenderBridgeParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebRenderBridgeParent::Manager() const -> PCompositorBridgeParent*
{
    return static_cast<PCompositorBridgeParent*>(IProtocol::Manager());
}

auto PWebRenderBridgeParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebRenderBridgeParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebRenderBridgeParent::SendWrUpdated(
        const IdNamespace& aNewIdNamespace,
        const TextureFactoryIdentifier& textureFactoryIdentifier) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebRenderBridge::Msg_WrUpdated(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aNewIdNamespace);
    // Sentinel = 'aNewIdNamespace'
    ((&(writer__)))->WriteSentinel(757990854);
    IPC::WriteParam((&(writer__)), textureFactoryIdentifier);
    // Sentinel = 'textureFactoryIdentifier'
    ((&(writer__)))->WriteSentinel(2096630253);




    if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebRenderBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_WrUpdated", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebRenderBridgeParent::SendWrReleasedImages(mozilla::Span<ExternalImageKeyPair const> pairs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebRenderBridge::Msg_WrReleasedImages(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pairs);
    // Sentinel = 'pairs'
    ((&(writer__)))->WriteSentinel(105579040);




    if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebRenderBridgeParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_WrReleasedImages", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebRenderBridgeParent::Send__delete__(PWebRenderBridgeParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebRenderBridge::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebRenderBridgeParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebRenderBridge::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebRenderBridgeParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebRenderBridgeParent::OnMessageReceived(const Message& msg__) -> PWebRenderBridgeParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_NewCompositable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_NewCompositable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle = IPC::ReadParam<CompositableHandle>((&(reader__)));
            if (!maybe__handle) {
                FatalError("Error deserializing 'CompositableHandle'");
                return MsgValueError;

            }
            auto& handle = *maybe__handle;
            // Sentinel = 'handle'
            if ((!(((&(reader__)))->ReadSentinel(142344813)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositableHandle'");
                return MsgValueError;
            }
            auto maybe__info = IPC::ReadParam<TextureInfo>((&(reader__)));
            if (!maybe__info) {
                FatalError("Error deserializing 'TextureInfo'");
                return MsgValueError;

            }
            auto& info = *maybe__info;
            // Sentinel = 'info'
            if ((!(((&(reader__)))->ReadSentinel(70058413)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TextureInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNewCompositable(std::move(handle), std::move(info));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_ReleaseCompositable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_ReleaseCompositable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__compositable = IPC::ReadParam<CompositableHandle>((&(reader__)));
            if (!maybe__compositable) {
                FatalError("Error deserializing 'CompositableHandle'");
                return MsgValueError;

            }
            auto& compositable = *maybe__compositable;
            // Sentinel = 'compositable'
            if ((!(((&(reader__)))->ReadSentinel(551879939)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositableHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReleaseCompositable(std::move(compositable));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_DeleteCompositorAnimations__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_DeleteCompositorAnimations", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIds = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__aIds) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& aIds = *maybe__aIds;
            // Sentinel = 'aIds'
            if ((!(((&(reader__)))->ReadSentinel(60686722)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteCompositorAnimations(std::move(aIds));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetDisplayList__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetDisplayList", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__displayList = IPC::ReadParam<DisplayListData>((&(reader__)));
            if (!maybe__displayList) {
                FatalError("Error deserializing 'DisplayListData'");
                return MsgValueError;

            }
            auto& displayList = *maybe__displayList;
            // Sentinel = 'displayList'
            if ((!(((&(reader__)))->ReadSentinel(458753171)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DisplayListData'");
                return MsgValueError;
            }
            auto maybe__toDestroy = IPC::ReadParam<nsTArray<OpDestroy>>((&(reader__)));
            if (!maybe__toDestroy) {
                FatalError("Error deserializing 'OpDestroy[]'");
                return MsgValueError;

            }
            auto& toDestroy = *maybe__toDestroy;
            // Sentinel = 'toDestroy'
            if ((!(((&(reader__)))->ReadSentinel(311100366)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpDestroy[]'");
                return MsgValueError;
            }
            auto maybe__fwdTransactionId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__fwdTransactionId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& fwdTransactionId = *maybe__fwdTransactionId;
            // Sentinel = 'fwdTransactionId'
            if ((!(((&(reader__)))->ReadSentinel(930940533)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__transactionId = IPC::ReadParam<TransactionId>((&(reader__)));
            if (!maybe__transactionId) {
                FatalError("Error deserializing 'TransactionId'");
                return MsgValueError;

            }
            auto& transactionId = *maybe__transactionId;
            // Sentinel = 'transactionId'
            if ((!(((&(reader__)))->ReadSentinel(642319700)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TransactionId'");
                return MsgValueError;
            }
            auto maybe__containsSVGGroup = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__containsSVGGroup) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& containsSVGGroup = *maybe__containsSVGGroup;
            // Sentinel = 'containsSVGGroup'
            if ((!(((&(reader__)))->ReadSentinel(914163293)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__vsyncId = IPC::ReadParam<VsyncId>((&(reader__)));
            if (!maybe__vsyncId) {
                FatalError("Error deserializing 'VsyncId'");
                return MsgValueError;

            }
            auto& vsyncId = *maybe__vsyncId;
            // Sentinel = 'vsyncId'
            if ((!(((&(reader__)))->ReadSentinel(203883233)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VsyncId'");
                return MsgValueError;
            }
            auto maybe__vsyncStartTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__vsyncStartTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& vsyncStartTime = *maybe__vsyncStartTime;
            // Sentinel = 'vsyncStartTime'
            if ((!(((&(reader__)))->ReadSentinel(747177425)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__refreshStartTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__refreshStartTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& refreshStartTime = *maybe__refreshStartTime;
            // Sentinel = 'refreshStartTime'
            if ((!(((&(reader__)))->ReadSentinel(941753997)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__txnStartTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__txnStartTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& txnStartTime = *maybe__txnStartTime;
            // Sentinel = 'txnStartTime'
            if ((!(((&(reader__)))->ReadSentinel(551290104)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__txnURL = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__txnURL) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& txnURL = *maybe__txnURL;
            // Sentinel = 'txnURL'
            if ((!(((&(reader__)))->ReadSentinel(146604622)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__fwdTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__fwdTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& fwdTime = *maybe__fwdTime;
            // Sentinel = 'fwdTime'
            if ((!(((&(reader__)))->ReadSentinel(190382801)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__payloads = IPC::ReadParam<nsTArray<CompositionPayload>>((&(reader__)));
            if (!maybe__payloads) {
                FatalError("Error deserializing 'CompositionPayload[]'");
                return MsgValueError;

            }
            auto& payloads = *maybe__payloads;
            // Sentinel = 'payloads'
            if ((!(((&(reader__)))->ReadSentinel(255525726)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositionPayload[]'");
                return MsgValueError;
            }
            auto maybe__renderOffscreen = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__renderOffscreen) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& renderOffscreen = *maybe__renderOffscreen;
            // Sentinel = 'renderOffscreen'
            if ((!(((&(reader__)))->ReadSentinel(820315676)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetDisplayList(std::move(displayList), std::move(toDestroy), std::move(fwdTransactionId), std::move(transactionId), std::move(containsSVGGroup), std::move(vsyncId), std::move(vsyncStartTime), std::move(refreshStartTime), std::move(txnStartTime), std::move(txnURL), std::move(fwdTime), std::move(payloads), std::move(renderOffscreen));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_EmptyTransaction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_EmptyTransaction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__focusTarget = IPC::ReadParam<FocusTarget>((&(reader__)));
            if (!maybe__focusTarget) {
                FatalError("Error deserializing 'FocusTarget'");
                return MsgValueError;

            }
            auto& focusTarget = *maybe__focusTarget;
            // Sentinel = 'focusTarget'
            if ((!(((&(reader__)))->ReadSentinel(455279752)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FocusTarget'");
                return MsgValueError;
            }
            auto maybe__transationData = IPC::ReadParam<MaybeTransactionData>((&(reader__)));
            if (!maybe__transationData) {
                FatalError("Error deserializing 'MaybeTransactionData'");
                return MsgValueError;

            }
            auto& transationData = *maybe__transationData;
            // Sentinel = 'transationData'
            if ((!(((&(reader__)))->ReadSentinel(739771838)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MaybeTransactionData'");
                return MsgValueError;
            }
            auto maybe__toDestroy = IPC::ReadParam<nsTArray<OpDestroy>>((&(reader__)));
            if (!maybe__toDestroy) {
                FatalError("Error deserializing 'OpDestroy[]'");
                return MsgValueError;

            }
            auto& toDestroy = *maybe__toDestroy;
            // Sentinel = 'toDestroy'
            if ((!(((&(reader__)))->ReadSentinel(311100366)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpDestroy[]'");
                return MsgValueError;
            }
            auto maybe__fwdTransactionId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__fwdTransactionId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& fwdTransactionId = *maybe__fwdTransactionId;
            // Sentinel = 'fwdTransactionId'
            if ((!(((&(reader__)))->ReadSentinel(930940533)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__transactionId = IPC::ReadParam<TransactionId>((&(reader__)));
            if (!maybe__transactionId) {
                FatalError("Error deserializing 'TransactionId'");
                return MsgValueError;

            }
            auto& transactionId = *maybe__transactionId;
            // Sentinel = 'transactionId'
            if ((!(((&(reader__)))->ReadSentinel(642319700)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TransactionId'");
                return MsgValueError;
            }
            auto maybe__vsyncId = IPC::ReadParam<VsyncId>((&(reader__)));
            if (!maybe__vsyncId) {
                FatalError("Error deserializing 'VsyncId'");
                return MsgValueError;

            }
            auto& vsyncId = *maybe__vsyncId;
            // Sentinel = 'vsyncId'
            if ((!(((&(reader__)))->ReadSentinel(203883233)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VsyncId'");
                return MsgValueError;
            }
            auto maybe__vsyncStartTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__vsyncStartTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& vsyncStartTime = *maybe__vsyncStartTime;
            // Sentinel = 'vsyncStartTime'
            if ((!(((&(reader__)))->ReadSentinel(747177425)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__refreshStartTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__refreshStartTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& refreshStartTime = *maybe__refreshStartTime;
            // Sentinel = 'refreshStartTime'
            if ((!(((&(reader__)))->ReadSentinel(941753997)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__txnStartTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__txnStartTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& txnStartTime = *maybe__txnStartTime;
            // Sentinel = 'txnStartTime'
            if ((!(((&(reader__)))->ReadSentinel(551290104)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__txnURL = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__txnURL) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& txnURL = *maybe__txnURL;
            // Sentinel = 'txnURL'
            if ((!(((&(reader__)))->ReadSentinel(146604622)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__fwdTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__fwdTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& fwdTime = *maybe__fwdTime;
            // Sentinel = 'fwdTime'
            if ((!(((&(reader__)))->ReadSentinel(190382801)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__payloads = IPC::ReadParam<nsTArray<CompositionPayload>>((&(reader__)));
            if (!maybe__payloads) {
                FatalError("Error deserializing 'CompositionPayload[]'");
                return MsgValueError;

            }
            auto& payloads = *maybe__payloads;
            // Sentinel = 'payloads'
            if ((!(((&(reader__)))->ReadSentinel(255525726)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositionPayload[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvEmptyTransaction(std::move(focusTarget), std::move(transationData), std::move(toDestroy), std::move(fwdTransactionId), std::move(transactionId), std::move(vsyncId), std::move(vsyncStartTime), std::move(refreshStartTime), std::move(txnStartTime), std::move(txnURL), std::move(fwdTime), std::move(payloads));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetFocusTarget__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetFocusTarget", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__focusTarget = IPC::ReadParam<FocusTarget>((&(reader__)));
            if (!maybe__focusTarget) {
                FatalError("Error deserializing 'FocusTarget'");
                return MsgValueError;

            }
            auto& focusTarget = *maybe__focusTarget;
            // Sentinel = 'focusTarget'
            if ((!(((&(reader__)))->ReadSentinel(455279752)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FocusTarget'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetFocusTarget(std::move(focusTarget));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_UpdateResources__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_UpdateResources", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIdNamespace = IPC::ReadParam<IdNamespace>((&(reader__)));
            if (!maybe__aIdNamespace) {
                FatalError("Error deserializing 'IdNamespace'");
                return MsgValueError;

            }
            auto& aIdNamespace = *maybe__aIdNamespace;
            // Sentinel = 'aIdNamespace'
            if ((!(((&(reader__)))->ReadSentinel(487523484)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IdNamespace'");
                return MsgValueError;
            }
            auto maybe__aResourceUpdates = IPC::ReadParam<nsTArray<OpUpdateResource>>((&(reader__)));
            if (!maybe__aResourceUpdates) {
                FatalError("Error deserializing 'OpUpdateResource[]'");
                return MsgValueError;

            }
            auto& aResourceUpdates = *maybe__aResourceUpdates;
            // Sentinel = 'aResourceUpdates'
            if ((!(((&(reader__)))->ReadSentinel(916522624)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpUpdateResource[]'");
                return MsgValueError;
            }
            auto maybe__aSmallShmems = IPC::ReadParam<nsTArray<RefCountedShmem>>((&(reader__)));
            if (!maybe__aSmallShmems) {
                FatalError("Error deserializing 'RefCountedShmem[]'");
                return MsgValueError;

            }
            auto& aSmallShmems = *maybe__aSmallShmems;
            // Sentinel = 'aSmallShmems'
            if ((!(((&(reader__)))->ReadSentinel(508691656)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RefCountedShmem[]'");
                return MsgValueError;
            }
            auto maybe__aLargeShmems = IPC::ReadParam<nsTArray<Shmem>>((&(reader__)));
            if (!maybe__aLargeShmems) {
                FatalError("Error deserializing 'Shmem[]'");
                return MsgValueError;

            }
            auto& aLargeShmems = *maybe__aLargeShmems;
            // Sentinel = 'aLargeShmems'
            if ((!(((&(reader__)))->ReadSentinel(499975354)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvUpdateResources(std::move(aIdNamespace), std::move(aResourceUpdates), std::move(aSmallShmems), std::move(aLargeShmems));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_ParentCommands__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_ParentCommands", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIdNamespace = IPC::ReadParam<IdNamespace>((&(reader__)));
            if (!maybe__aIdNamespace) {
                FatalError("Error deserializing 'IdNamespace'");
                return MsgValueError;

            }
            auto& aIdNamespace = *maybe__aIdNamespace;
            // Sentinel = 'aIdNamespace'
            if ((!(((&(reader__)))->ReadSentinel(487523484)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IdNamespace'");
                return MsgValueError;
            }
            auto maybe__commands = IPC::ReadParam<nsTArray<WebRenderParentCommand>>((&(reader__)));
            if (!maybe__commands) {
                FatalError("Error deserializing 'WebRenderParentCommand[]'");
                return MsgValueError;

            }
            auto& commands = *maybe__commands;
            // Sentinel = 'commands'
            if ((!(((&(reader__)))->ReadSentinel(249627475)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebRenderParentCommand[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvParentCommands(std::move(aIdNamespace), std::move(commands));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_ClearCachedResources__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_ClearCachedResources", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClearCachedResources();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_ClearAnimationResources__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_ClearAnimationResources", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClearAnimationResources();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetDefaultClearColor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetDefaultClearColor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aColor = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aColor) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aColor = *maybe__aColor;
            // Sentinel = 'aColor'
            if ((!(((&(reader__)))->ReadSentinel(132842081)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetDefaultClearColor(std::move(aColor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_InvalidateRenderedFrame__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_InvalidateRenderedFrame", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvInvalidateRenderedFrame();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_ScheduleComposite__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_ScheduleComposite", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aReasons = IPC::ReadParam<RenderReasons>((&(reader__)));
            if (!maybe__aReasons) {
                FatalError("Error deserializing 'RenderReasons'");
                return MsgValueError;

            }
            auto& aReasons = *maybe__aReasons;
            // Sentinel = 'aReasons'
            if ((!(((&(reader__)))->ReadSentinel(234423101)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RenderReasons'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvScheduleComposite(std::move(aReasons));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_Capture__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_Capture", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvCapture();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_StartCaptureSequence__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_StartCaptureSequence", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aPath = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aPath) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aPath = *maybe__aPath;
            // Sentinel = 'aPath'
            if ((!(((&(reader__)))->ReadSentinel(94175727)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aFlags = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aFlags) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aFlags = *maybe__aFlags;
            // Sentinel = 'aFlags'
            if ((!(((&(reader__)))->ReadSentinel(129892943)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvStartCaptureSequence(std::move(aPath), std::move(aFlags));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_StopCaptureSequence__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_StopCaptureSequence", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvStopCaptureSequence();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetConfirmedTargetAPZC__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetConfirmedTargetAPZC", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aInputBlockId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aInputBlockId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aInputBlockId = *maybe__aInputBlockId;
            // Sentinel = 'aInputBlockId'
            if ((!(((&(reader__)))->ReadSentinel(595657994)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aTargets = IPC::ReadParam<nsTArray<ScrollableLayerGuid>>((&(reader__)));
            if (!maybe__aTargets) {
                FatalError("Error deserializing 'ScrollableLayerGuid[]'");
                return MsgValueError;

            }
            auto& aTargets = *maybe__aTargets;
            // Sentinel = 'aTargets'
            if ((!(((&(reader__)))->ReadSentinel(235012924)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ScrollableLayerGuid[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetConfirmedTargetAPZC(std::move(aInputBlockId), std::move(aTargets));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_FlushApzRepaints__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_FlushApzRepaints", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvFlushApzRepaints();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_Shutdown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvShutdown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebRenderBridge::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebRenderBridgeParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebRenderBridgeParent::Result
{
    switch (msg__.type()) {
    case PWebRenderBridge::Msg_EnsureConnected__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_EnsureConnected", OTHER);

            int32_t id__ = Id();
            TextureFactoryIdentifier textureFactoryIdentifier{};
            MaybeIdNamespace maybeIdNamespace{};
            nsCString error{};
            mozilla::ipc::IPCResult __ok = (this)->RecvEnsureConnected((&(textureFactoryIdentifier)), (&(maybeIdNamespace)), (&(error)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_EnsureConnected(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), textureFactoryIdentifier);
            // Sentinel = 'textureFactoryIdentifier'
            ((&(writer__)))->WriteSentinel(2096630253);
            IPC::WriteParam((&(writer__)), maybeIdNamespace);
            // Sentinel = 'maybeIdNamespace'
            ((&(writer__)))->WriteSentinel(895092297);
            IPC::WriteParam((&(writer__)), error);
            // Sentinel = 'error'
            ((&(writer__)))->WriteSentinel(107741739);

            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_GetSnapshot__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_GetSnapshot", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__texture = IPC::ReadParam<mozilla::NotNull<PTextureParent*>>((&(reader__)));
            if (!maybe__texture) {
                FatalError("Error deserializing 'NotNull<PTexture>'");
                return MsgValueError;

            }
            auto& texture = *maybe__texture;
            // Sentinel = 'texture'
            if ((!(((&(reader__)))->ReadSentinel(207684370)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PTexture>'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            bool aNeedsYFlip{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetSnapshot(texture, (&(aNeedsYFlip)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_GetSnapshot(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), aNeedsYFlip);
            // Sentinel = 'aNeedsYFlip'
            ((&(writer__)))->WriteSentinel(415237173);

            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SyncWithCompositor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SyncWithCompositor", OTHER);

            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvSyncWithCompositor();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_SyncWithCompositor(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetTestSampleTime__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetTestSampleTime", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__sampleTime = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__sampleTime) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& sampleTime = *maybe__sampleTime;
            // Sentinel = 'sampleTime'
            if ((!(((&(reader__)))->ReadSentinel(380896274)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetTestSampleTime(std::move(sampleTime));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_SetTestSampleTime(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_LeaveTestMode__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_LeaveTestMode", OTHER);

            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvLeaveTestMode();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_LeaveTestMode(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_GetAnimationValue__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_GetAnimationValue", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aCompositorAnimationsId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aCompositorAnimationsId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aCompositorAnimationsId = *maybe__aCompositorAnimationsId;
            // Sentinel = 'aCompositorAnimationsId'
            if ((!(((&(reader__)))->ReadSentinel(1874397521)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            OMTAValue value{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetAnimationValue(std::move(aCompositorAnimationsId), (&(value)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_GetAnimationValue(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), value);
            // Sentinel = 'value'
            ((&(writer__)))->WriteSentinel(107610654);

            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetAsyncScrollOffset__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetAsyncScrollOffset", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__scrollId = IPC::ReadParam<ViewID>((&(reader__)));
            if (!maybe__scrollId) {
                FatalError("Error deserializing 'ViewID'");
                return MsgValueError;

            }
            auto& scrollId = *maybe__scrollId;
            // Sentinel = 'scrollId'
            if ((!(((&(reader__)))->ReadSentinel(253100861)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ViewID'");
                return MsgValueError;
            }
            auto maybe__x = IPC::ReadParam<float>((&(reader__)));
            if (!maybe__x) {
                FatalError("Error deserializing 'float'");
                return MsgValueError;

            }
            auto& x = *maybe__x;
            // Sentinel = 'x'
            if ((!(((&(reader__)))->ReadSentinel(7929977)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'float'");
                return MsgValueError;
            }
            auto maybe__y = IPC::ReadParam<float>((&(reader__)));
            if (!maybe__y) {
                FatalError("Error deserializing 'float'");
                return MsgValueError;

            }
            auto& y = *maybe__y;
            // Sentinel = 'y'
            if ((!(((&(reader__)))->ReadSentinel(7995514)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'float'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetAsyncScrollOffset(std::move(scrollId), std::move(x), std::move(y));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_SetAsyncScrollOffset(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_SetAsyncZoom__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_SetAsyncZoom", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__scrollId = IPC::ReadParam<ViewID>((&(reader__)));
            if (!maybe__scrollId) {
                FatalError("Error deserializing 'ViewID'");
                return MsgValueError;

            }
            auto& scrollId = *maybe__scrollId;
            // Sentinel = 'scrollId'
            if ((!(((&(reader__)))->ReadSentinel(253100861)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ViewID'");
                return MsgValueError;
            }
            auto maybe__zoom = IPC::ReadParam<float>((&(reader__)));
            if (!maybe__zoom) {
                FatalError("Error deserializing 'float'");
                return MsgValueError;

            }
            auto& zoom = *maybe__zoom;
            // Sentinel = 'zoom'
            if ((!(((&(reader__)))->ReadSentinel(75760070)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'float'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetAsyncZoom(std::move(scrollId), std::move(zoom));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_SetAsyncZoom(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_GetAPZTestData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_GetAPZTestData", OTHER);

            int32_t id__ = Id();
            APZTestData data{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetAPZTestData((&(data)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_GetAPZTestData(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), data);
            // Sentinel = 'data'
            ((&(writer__)))->WriteSentinel(67109275);

            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_GetFrameUniformity__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_GetFrameUniformity", OTHER);

            int32_t id__ = Id();
            FrameUniformityData data{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetFrameUniformity((&(data)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_GetFrameUniformity(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), data);
            // Sentinel = 'data'
            ((&(writer__)))->WriteSentinel(67109275);

            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebRenderBridge::Msg_ShutdownSync__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebRenderBridge::Msg_ShutdownSync", OTHER);

            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvShutdownSync();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebRenderBridge::Reply_ShutdownSync(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebRenderBridge", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebRenderBridgeParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace layers
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::layers::PWebRenderBridgeParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::layers::PWebRenderBridgeParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebRenderBridge", PWebRenderBridgeMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::layers::PWebRenderBridgeParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
