//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/webgpu/PWebGPUParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "mozilla/webgpu/WebGPUParent.h"
#include "mozilla/webgpu/WebGPUSerialize.h"

#include "mozilla/gfx/PCanvasManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace webgpu {


MOZ_IMPLICIT PWebGPUParent::PWebGPUParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebGPUParent);
}

PWebGPUParent::~PWebGPUParent()
{
    MOZ_COUNT_DTOR(PWebGPUParent);
}

auto PWebGPUParent::ActorAlloc() -> void
{
    AddRef();
}

auto PWebGPUParent::ActorDealloc() -> void
{
    Release();
}

auto PWebGPUParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebGPUParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebGPUParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebGPUParent::Manager() const -> PCanvasManagerParent*
{
    return static_cast<PCanvasManagerParent*>(IProtocol::Manager());
}

auto PWebGPUParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebGPUParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebGPUParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebGPUParent::SendUncapturedError(
        const mozilla::Maybe<RawId>& aDeviceId,
        const nsACString& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_UncapturedError(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_UncapturedError", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUParent::SendDropAction(ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DropAction(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DropAction", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUParent::SendDeviceLost(
        const RawId& aDeviceId,
        const mozilla::Maybe<uint8_t>& reason,
        const nsACString& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceLost(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), reason);
    // Sentinel = 'reason'
    ((&(writer__)))->WriteSentinel(148112009);
    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceLost", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUParent::Send__delete__(PWebGPUParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebGPUParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebGPUParent::OnMessageReceived(const Message& msg__) -> PWebGPUParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceAction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceAction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceAction(std::move(selfId), std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceActionWithAck__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceActionWithAck", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_DeviceActionWithAck(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            DeviceActionWithAckResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'dummy'
                    ((&(writer__)))->WriteSentinel(107414061);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceActionWithAck(std::move(selfId), std::move(buf), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_TextureAction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureAction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvTextureAction(std::move(selfId), std::move(aDeviceId), std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_CommandEncoderAction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_CommandEncoderAction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvCommandEncoderAction(std::move(selfId), std::move(aDeviceId), std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_RenderPass__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_RenderPass", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvRenderPass(std::move(selfId), std::move(aDeviceId), std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_ComputePass__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_ComputePass", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvComputePass(std::move(selfId), std::move(aDeviceId), std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BumpImplicitBindGroupLayout__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BumpImplicitBindGroupLayout", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pipelineId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__pipelineId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& pipelineId = *maybe__pipelineId;
            // Sentinel = 'pipelineId'
            if ((!(((&(reader__)))->ReadSentinel(382731268)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__isCompute = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__isCompute) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& isCompute = *maybe__isCompute;
            // Sentinel = 'isCompute'
            if ((!(((&(reader__)))->ReadSentinel(307102650)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__index = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__index) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& index = *maybe__index;
            // Sentinel = 'index'
            if ((!(((&(reader__)))->ReadSentinel(104333849)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__assignId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__assignId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& assignId = *maybe__assignId;
            // Sentinel = 'assignId'
            if ((!(((&(reader__)))->ReadSentinel(248513331)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBumpImplicitBindGroupLayout(std::move(pipelineId), std::move(isCompute), std::move(index), std::move(assignId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceCreateBuffer__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateBuffer", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__deviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__bufferId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__bufferId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& bufferId = *maybe__bufferId;
            // Sentinel = 'bufferId'
            if ((!(((&(reader__)))->ReadSentinel(244122408)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__desc = IPC::ReadParam<GPUBufferDescriptor>((&(reader__)));
            if (!maybe__desc) {
                FatalError("Error deserializing 'GPUBufferDescriptor'");
                return MsgValueError;

            }
            auto& desc = *maybe__desc;
            // Sentinel = 'desc'
            if ((!(((&(reader__)))->ReadSentinel(67895712)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GPUBufferDescriptor'");
                return MsgValueError;
            }
            auto maybe__shm = IPC::ReadParam<MutableSharedMemoryHandle>((&(reader__)));
            if (!maybe__shm) {
                FatalError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;

            }
            auto& shm = *maybe__shm;
            // Sentinel = 'shm'
            if ((!(((&(reader__)))->ReadSentinel(43581769)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceCreateBuffer(std::move(deviceId), std::move(bufferId), std::move(desc), std::move(shm));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_InstanceRequestAdapter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_InstanceRequestAdapter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__options = IPC::ReadParam<GPURequestAdapterOptions>((&(reader__)));
            if (!maybe__options) {
                FatalError("Error deserializing 'GPURequestAdapterOptions'");
                return MsgValueError;

            }
            auto& options = *maybe__options;
            // Sentinel = 'options'
            if ((!(((&(reader__)))->ReadSentinel(204735245)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GPURequestAdapterOptions'");
                return MsgValueError;
            }
            auto maybe__aAdapterId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aAdapterId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aAdapterId = *maybe__aAdapterId;
            // Sentinel = 'aAdapterId'
            if ((!(((&(reader__)))->ReadSentinel(346555344)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_InstanceRequestAdapter(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InstanceRequestAdapterResolver resolver = [resolver__ = std::move(resolver__)](ByteBuf&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'byteBuf'
                    ((&(writer__)))->WriteSentinel(192479954);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvInstanceRequestAdapter(std::move(options), std::move(aAdapterId), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_AdapterRequestDevice__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_AdapterRequestDevice", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__adapterId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__adapterId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& adapterId = *maybe__adapterId;
            // Sentinel = 'adapterId'
            if ((!(((&(reader__)))->ReadSentinel(301794191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__descriptorBuf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__descriptorBuf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& descriptorBuf = *maybe__descriptorBuf;
            // Sentinel = 'descriptorBuf'
            if ((!(((&(reader__)))->ReadSentinel(633800029)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            auto maybe__newDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__newDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& newDeviceId = *maybe__newDeviceId;
            // Sentinel = 'newDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(441123912)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__newQueueId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__newQueueId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& newQueueId = *maybe__newQueueId;
            // Sentinel = 'newQueueId'
            if ((!(((&(reader__)))->ReadSentinel(377619453)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_AdapterRequestDevice(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            AdapterRequestDeviceResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'success'
                    ((&(writer__)))->WriteSentinel(200082170);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvAdapterRequestDevice(std::move(adapterId), std::move(descriptorBuf), std::move(newDeviceId), std::move(newQueueId), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_AdapterDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_AdapterDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvAdapterDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceCreateShaderModule__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateShaderModule", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__bufferId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__bufferId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& bufferId = *maybe__bufferId;
            // Sentinel = 'bufferId'
            if ((!(((&(reader__)))->ReadSentinel(244122408)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__label = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__label) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& label = *maybe__label;
            // Sentinel = 'label'
            if ((!(((&(reader__)))->ReadSentinel(100729345)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__code = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__code) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& code = *maybe__code;
            // Sentinel = 'code'
            if ((!(((&(reader__)))->ReadSentinel(67764636)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_DeviceCreateShaderModule(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            DeviceCreateShaderModuleResolver resolver = [resolver__ = std::move(resolver__)](mozilla::Span<WebGPUCompilationMessage const> aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'messages'
                    ((&(writer__)))->WriteSentinel(253363033);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceCreateShaderModule(std::move(selfId), std::move(bufferId), std::move(label), std::move(code), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BufferMap__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferMap", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__deviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__bufferId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__bufferId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& bufferId = *maybe__bufferId;
            // Sentinel = 'bufferId'
            if ((!(((&(reader__)))->ReadSentinel(244122408)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aMode = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aMode) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aMode = *maybe__aMode;
            // Sentinel = 'aMode'
            if ((!(((&(reader__)))->ReadSentinel(93848039)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__offset = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__offset) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& offset = *maybe__offset;
            // Sentinel = 'offset'
            if ((!(((&(reader__)))->ReadSentinel(147653256)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__size = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__size) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& size = *maybe__size;
            // Sentinel = 'size'
            if ((!(((&(reader__)))->ReadSentinel(73662908)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_BufferMap(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            BufferMapResolver resolver = [resolver__ = std::move(resolver__)](const BufferMapResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBufferMap(std::move(deviceId), std::move(bufferId), std::move(aMode), std::move(offset), std::move(size), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BufferUnmap__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferUnmap", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__deviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__bufferId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__bufferId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& bufferId = *maybe__bufferId;
            // Sentinel = 'bufferId'
            if ((!(((&(reader__)))->ReadSentinel(244122408)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__flush = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__flush) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& flush = *maybe__flush;
            // Sentinel = 'flush'
            if ((!(((&(reader__)))->ReadSentinel(106955299)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBufferUnmap(std::move(deviceId), std::move(bufferId), std::move(flush));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BufferDestroy__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferDestroy", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBufferDestroy(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BufferDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBufferDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_TextureDestroy__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureDestroy", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__deviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvTextureDestroy(std::move(selfId), std::move(deviceId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_TextureDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvTextureDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_TextureViewDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureViewDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvTextureViewDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_SamplerDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_SamplerDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvSamplerDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_QuerySetDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_QuerySetDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvQuerySetDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceDestroy__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceDestroy", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceDestroy(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_CommandEncoderFinish__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_CommandEncoderFinish", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__deviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__desc = IPC::ReadParam<GPUCommandBufferDescriptor>((&(reader__)));
            if (!maybe__desc) {
                FatalError("Error deserializing 'GPUCommandBufferDescriptor'");
                return MsgValueError;

            }
            auto& desc = *maybe__desc;
            // Sentinel = 'desc'
            if ((!(((&(reader__)))->ReadSentinel(67895712)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GPUCommandBufferDescriptor'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvCommandEncoderFinish(std::move(selfId), std::move(deviceId), std::move(desc));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_CommandEncoderDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_CommandEncoderDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvCommandEncoderDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_RenderBundleDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_RenderBundleDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvRenderBundleDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_QueueSubmit__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueSubmit", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__commandBuffers = IPC::ReadParam<nsTArray<RawId>>((&(reader__)));
            if (!maybe__commandBuffers) {
                FatalError("Error deserializing 'RawId[]'");
                return MsgValueError;

            }
            auto& commandBuffers = *maybe__commandBuffers;
            // Sentinel = 'commandBuffers'
            if ((!(((&(reader__)))->ReadSentinel(710280621)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId[]'");
                return MsgValueError;
            }
            auto maybe__textureIds = IPC::ReadParam<nsTArray<RawId>>((&(reader__)));
            if (!maybe__textureIds) {
                FatalError("Error deserializing 'RawId[]'");
                return MsgValueError;

            }
            auto& textureIds = *maybe__textureIds;
            // Sentinel = 'textureIds'
            if ((!(((&(reader__)))->ReadSentinel(397214770)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvQueueSubmit(std::move(selfId), std::move(aDeviceId), std::move(commandBuffers), std::move(textureIds));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_QueueOnSubmittedWorkDone__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueOnSubmittedWorkDone", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_QueueOnSubmittedWorkDone(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            QueueOnSubmittedWorkDoneResolver resolver = [resolver__ = std::move(resolver__)](const void_t& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'ok'
                    ((&(writer__)))->WriteSentinel(21692635);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvQueueOnSubmittedWorkDone(std::move(selfId), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_QueueWriteAction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueWriteAction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            auto maybe__shmem = IPC::ReadParam<MutableSharedMemoryHandle>((&(reader__)));
            if (!maybe__shmem) {
                FatalError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;

            }
            auto& shmem = *maybe__shmem;
            // Sentinel = 'shmem'
            if ((!(((&(reader__)))->ReadSentinel(107086363)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutableSharedMemoryHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvQueueWriteAction(std::move(selfId), std::move(aDeviceId), std::move(buf), std::move(shmem));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BindGroupLayoutDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BindGroupLayoutDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBindGroupLayoutDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_PipelineLayoutDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_PipelineLayoutDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvPipelineLayoutDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_BindGroupDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_BindGroupDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvBindGroupDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_ShaderModuleDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_ShaderModuleDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvShaderModuleDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_ComputePipelineDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_ComputePipelineDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvComputePipelineDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_RenderPipelineDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_RenderPipelineDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvRenderPipelineDrop(std::move(selfId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_ImplicitLayoutDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_ImplicitLayoutDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__implicitPlId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__implicitPlId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& implicitPlId = *maybe__implicitPlId;
            // Sentinel = 'implicitPlId'
            if ((!(((&(reader__)))->ReadSentinel(537134277)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__implicitBglIds = IPC::ReadParam<nsTArray<RawId>>((&(reader__)));
            if (!maybe__implicitBglIds) {
                FatalError("Error deserializing 'RawId[]'");
                return MsgValueError;

            }
            auto& implicitBglIds = *maybe__implicitBglIds;
            // Sentinel = 'implicitBglIds'
            if ((!(((&(reader__)))->ReadSentinel(714540433)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvImplicitLayoutDrop(std::move(implicitPlId), std::move(implicitBglIds));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceCreateSwapChain__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateSwapChain", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__queueId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__queueId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& queueId = *maybe__queueId;
            // Sentinel = 'queueId'
            if ((!(((&(reader__)))->ReadSentinel(198050515)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__desc = IPC::ReadParam<RGBDescriptor>((&(reader__)));
            if (!maybe__desc) {
                FatalError("Error deserializing 'RGBDescriptor'");
                return MsgValueError;

            }
            auto& desc = *maybe__desc;
            // Sentinel = 'desc'
            if ((!(((&(reader__)))->ReadSentinel(67895712)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RGBDescriptor'");
                return MsgValueError;
            }
            auto maybe__bufferIds = IPC::ReadParam<nsTArray<RawId>>((&(reader__)));
            if (!maybe__bufferIds) {
                FatalError("Error deserializing 'RawId[]'");
                return MsgValueError;

            }
            auto& bufferIds = *maybe__bufferIds;
            // Sentinel = 'bufferIds'
            if ((!(((&(reader__)))->ReadSentinel(304612251)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId[]'");
                return MsgValueError;
            }
            auto maybe__ownerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__ownerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& ownerId = *maybe__ownerId;
            // Sentinel = 'ownerId'
            if ((!(((&(reader__)))->ReadSentinel(199230169)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            auto maybe__useExternalTextureInSwapChain = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__useExternalTextureInSwapChain) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& useExternalTextureInSwapChain = *maybe__useExternalTextureInSwapChain;
            // Sentinel = 'useExternalTextureInSwapChain'
            if ((!(((&(reader__)))->ReadSentinel(2989493175)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDeviceCreateSwapChain(std::move(selfId), std::move(queueId), std::move(desc), std::move(bufferIds), std::move(ownerId), std::move(useExternalTextureInSwapChain));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_SwapChainPresent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_SwapChainPresent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__textureId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__textureId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& textureId = *maybe__textureId;
            // Sentinel = 'textureId'
            if ((!(((&(reader__)))->ReadSentinel(326828991)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__commandEncoderId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__commandEncoderId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& commandEncoderId = *maybe__commandEncoderId;
            // Sentinel = 'commandEncoderId'
            if ((!(((&(reader__)))->ReadSentinel(913180237)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__remoteTextureId = IPC::ReadParam<RemoteTextureId>((&(reader__)));
            if (!maybe__remoteTextureId) {
                FatalError("Error deserializing 'RemoteTextureId'");
                return MsgValueError;

            }
            auto& remoteTextureId = *maybe__remoteTextureId;
            // Sentinel = 'remoteTextureId'
            if ((!(((&(reader__)))->ReadSentinel(843056683)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureId'");
                return MsgValueError;
            }
            auto maybe__remoteTextureOwnerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__remoteTextureOwnerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& remoteTextureOwnerId = *maybe__remoteTextureOwnerId;
            // Sentinel = 'remoteTextureOwnerId'
            if ((!(((&(reader__)))->ReadSentinel(1471744054)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvSwapChainPresent(std::move(textureId), std::move(commandEncoderId), std::move(remoteTextureId), std::move(remoteTextureOwnerId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_SwapChainDrop__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_SwapChainDrop", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__ownerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__ownerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& ownerId = *maybe__ownerId;
            // Sentinel = 'ownerId'
            if ((!(((&(reader__)))->ReadSentinel(199230169)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            auto maybe__txnType = IPC::ReadParam<RemoteTextureTxnType>((&(reader__)));
            if (!maybe__txnType) {
                FatalError("Error deserializing 'RemoteTextureTxnType'");
                return MsgValueError;

            }
            auto& txnType = *maybe__txnType;
            // Sentinel = 'txnType'
            if ((!(((&(reader__)))->ReadSentinel(204014333)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureTxnType'");
                return MsgValueError;
            }
            auto maybe__txnId = IPC::ReadParam<RemoteTextureTxnId>((&(reader__)));
            if (!maybe__txnId) {
                FatalError("Error deserializing 'RemoteTextureTxnId'");
                return MsgValueError;

            }
            auto& txnId = *maybe__txnId;
            // Sentinel = 'txnId'
            if ((!(((&(reader__)))->ReadSentinel(107545096)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureTxnId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvSwapChainDrop(std::move(ownerId), std::move(txnType), std::move(txnId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DevicePushErrorScope__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DevicePushErrorScope", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aFilter = IPC::ReadParam<GPUErrorFilter>((&(reader__)));
            if (!maybe__aFilter) {
                FatalError("Error deserializing 'GPUErrorFilter'");
                return MsgValueError;

            }
            auto& aFilter = *maybe__aFilter;
            // Sentinel = 'aFilter'
            if ((!(((&(reader__)))->ReadSentinel(178717384)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GPUErrorFilter'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDevicePushErrorScope(std::move(selfId), std::move(aFilter));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DevicePopErrorScope__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DevicePopErrorScope", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__selfId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__selfId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& selfId = *maybe__selfId;
            // Sentinel = 'selfId'
            if ((!(((&(reader__)))->ReadSentinel(143196760)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGPU::Reply_DevicePopErrorScope(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            DevicePopErrorScopeResolver resolver = [resolver__ = std::move(resolver__)](const PopErrorScopeResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGPUParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvDevicePopErrorScope(std::move(selfId), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_GenerateError__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_GenerateError", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__deviceId = IPC::ReadParam<mozilla::Maybe<RawId>>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId?'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId?'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<GPUErrorFilter>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'GPUErrorFilter'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GPUErrorFilter'");
                return MsgValueError;
            }
            auto maybe__message = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvGenerateError(std::move(deviceId), std::move(type), std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebGPUParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebGPUParent::Result
{
    return MsgNotKnown;
}



} // namespace webgpu
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::webgpu::PWebGPUParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::webgpu::PWebGPUParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebGPU", PWebGPUMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::webgpu::PWebGPUParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
