//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/webgpu/PWebGPUChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "mozilla/webgpu/WebGPUChild.h"
#include "mozilla/webgpu/WebGPUSerialize.h"

#include "mozilla/gfx/PCanvasManagerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace webgpu {


auto PWebGPUChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PWebGPUChild::PWebGPUChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PWebGPUChild);
}

PWebGPUChild::~PWebGPUChild()
{
    MOZ_COUNT_DTOR(PWebGPUChild);
}

auto PWebGPUChild::ActorAlloc() -> void
{
    AddRef();
}

auto PWebGPUChild::ActorDealloc() -> void
{
    Release();
}

auto PWebGPUChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebGPUChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebGPUChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebGPUChild::Manager() const -> PCanvasManagerChild*
{
    return static_cast<PCanvasManagerChild*>(IProtocol::Manager());
}

auto PWebGPUChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebGPUChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebGPUChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebGPUChild::SendDeviceAction(
        const RawId& selfId,
        ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceAction(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceAction", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDeviceActionWithAck(
        const RawId& selfId,
        ByteBuf&& buf,
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceActionWithAck(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceActionWithAck", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_DeviceActionWithAck__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__dummy = IPC::ReadParam<bool>(aReader);
            if (!maybe__dummy) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& dummy = *maybe__dummy;
            // Sentinel = 'dummy'
            if ((!((aReader)->ReadSentinel(107414061)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(dummy));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendDeviceActionWithAck(
        const RawId& selfId,
        ByteBuf&& buf) -> RefPtr<DeviceActionWithAckPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendDeviceActionWithAck(std::move(selfId), std::move(buf), [promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendTextureAction(
        const RawId& selfId,
        const RawId& aDeviceId,
        ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_TextureAction(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureAction", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendCommandEncoderAction(
        const RawId& selfId,
        const RawId& aDeviceId,
        ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_CommandEncoderAction(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_CommandEncoderAction", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendRenderPass(
        const RawId& selfId,
        const RawId& aDeviceId,
        ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_RenderPass(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_RenderPass", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendComputePass(
        const RawId& selfId,
        const RawId& aDeviceId,
        ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_ComputePass(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_ComputePass", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendBumpImplicitBindGroupLayout(
        const RawId& pipelineId,
        const bool& isCompute,
        const uint32_t& index,
        const RawId& assignId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BumpImplicitBindGroupLayout(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pipelineId);
    // Sentinel = 'pipelineId'
    ((&(writer__)))->WriteSentinel(382731268);
    IPC::WriteParam((&(writer__)), isCompute);
    // Sentinel = 'isCompute'
    ((&(writer__)))->WriteSentinel(307102650);
    IPC::WriteParam((&(writer__)), index);
    // Sentinel = 'index'
    ((&(writer__)))->WriteSentinel(104333849);
    IPC::WriteParam((&(writer__)), assignId);
    // Sentinel = 'assignId'
    ((&(writer__)))->WriteSentinel(248513331);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BumpImplicitBindGroupLayout", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDeviceCreateBuffer(
        const RawId& deviceId,
        const RawId& bufferId,
        const GPUBufferDescriptor& desc,
        MutableSharedMemoryHandle&& shm) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceCreateBuffer(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);
    IPC::WriteParam((&(writer__)), bufferId);
    // Sentinel = 'bufferId'
    ((&(writer__)))->WriteSentinel(244122408);
    IPC::WriteParam((&(writer__)), desc);
    // Sentinel = 'desc'
    ((&(writer__)))->WriteSentinel(67895712);
    IPC::WriteParam((&(writer__)), std::move(shm));
    // Sentinel = 'shm'
    ((&(writer__)))->WriteSentinel(43581769);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateBuffer", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendInstanceRequestAdapter(
        const GPURequestAdapterOptions& options,
        const RawId& aAdapterId,
        mozilla::ipc::ResolveCallback<ByteBuf>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_InstanceRequestAdapter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), options);
    // Sentinel = 'options'
    ((&(writer__)))->WriteSentinel(204735245);
    IPC::WriteParam((&(writer__)), aAdapterId);
    // Sentinel = 'aAdapterId'
    ((&(writer__)))->WriteSentinel(346555344);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_InstanceRequestAdapter", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_InstanceRequestAdapter__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__byteBuf = IPC::ReadParam<ByteBuf>(aReader);
            if (!maybe__byteBuf) {
                (aReader)->FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& byteBuf = *maybe__byteBuf;
            // Sentinel = 'byteBuf'
            if ((!((aReader)->ReadSentinel(192479954)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(byteBuf));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendInstanceRequestAdapter(
        const GPURequestAdapterOptions& options,
        const RawId& aAdapterId) -> RefPtr<InstanceRequestAdapterPromise>
{
    RefPtr<MozPromise<ByteBuf, ResponseRejectReason, true>::Private> promise__ = new MozPromise<ByteBuf, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendInstanceRequestAdapter(std::move(options), std::move(aAdapterId), [promise__](ByteBuf&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendAdapterRequestDevice(
        const RawId& adapterId,
        ByteBuf&& descriptorBuf,
        const RawId& newDeviceId,
        const RawId& newQueueId,
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_AdapterRequestDevice(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), adapterId);
    // Sentinel = 'adapterId'
    ((&(writer__)))->WriteSentinel(301794191);
    IPC::WriteParam((&(writer__)), std::move(descriptorBuf));
    // Sentinel = 'descriptorBuf'
    ((&(writer__)))->WriteSentinel(633800029);
    IPC::WriteParam((&(writer__)), newDeviceId);
    // Sentinel = 'newDeviceId'
    ((&(writer__)))->WriteSentinel(441123912);
    IPC::WriteParam((&(writer__)), newQueueId);
    // Sentinel = 'newQueueId'
    ((&(writer__)))->WriteSentinel(377619453);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_AdapterRequestDevice", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_AdapterRequestDevice__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__success = IPC::ReadParam<bool>(aReader);
            if (!maybe__success) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& success = *maybe__success;
            // Sentinel = 'success'
            if ((!((aReader)->ReadSentinel(200082170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(success));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendAdapterRequestDevice(
        const RawId& adapterId,
        ByteBuf&& descriptorBuf,
        const RawId& newDeviceId,
        const RawId& newQueueId) -> RefPtr<AdapterRequestDevicePromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendAdapterRequestDevice(std::move(adapterId), std::move(descriptorBuf), std::move(newDeviceId), std::move(newQueueId), [promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendAdapterDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_AdapterDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_AdapterDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDeviceCreateShaderModule(
        const RawId& selfId,
        const RawId& bufferId,
        const nsAString& label,
        const nsACString& code,
        mozilla::ipc::ResolveCallback<nsTArray<WebGPUCompilationMessage>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceCreateShaderModule(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), bufferId);
    // Sentinel = 'bufferId'
    ((&(writer__)))->WriteSentinel(244122408);
    IPC::WriteParam((&(writer__)), label);
    // Sentinel = 'label'
    ((&(writer__)))->WriteSentinel(100729345);
    IPC::WriteParam((&(writer__)), code);
    // Sentinel = 'code'
    ((&(writer__)))->WriteSentinel(67764636);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateShaderModule", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_DeviceCreateShaderModule__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__messages = IPC::ReadParam<nsTArray<WebGPUCompilationMessage>>(aReader);
            if (!maybe__messages) {
                (aReader)->FatalError("Error deserializing 'WebGPUCompilationMessage[]'");
                return MsgValueError;

            }
            auto& messages = *maybe__messages;
            // Sentinel = 'messages'
            if ((!((aReader)->ReadSentinel(253363033)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebGPUCompilationMessage[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(messages));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendDeviceCreateShaderModule(
        const RawId& selfId,
        const RawId& bufferId,
        const nsAString& label,
        const nsACString& code) -> RefPtr<DeviceCreateShaderModulePromise>
{
    RefPtr<MozPromise<nsTArray<WebGPUCompilationMessage>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<WebGPUCompilationMessage>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendDeviceCreateShaderModule(std::move(selfId), std::move(bufferId), std::move(label), std::move(code), [promise__](nsTArray<WebGPUCompilationMessage>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendBufferMap(
        const RawId& deviceId,
        const RawId& bufferId,
        const uint32_t& aMode,
        const uint64_t& offset,
        const uint64_t& size,
        mozilla::ipc::ResolveCallback<BufferMapResult>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BufferMap(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);
    IPC::WriteParam((&(writer__)), bufferId);
    // Sentinel = 'bufferId'
    ((&(writer__)))->WriteSentinel(244122408);
    IPC::WriteParam((&(writer__)), aMode);
    // Sentinel = 'aMode'
    ((&(writer__)))->WriteSentinel(93848039);
    IPC::WriteParam((&(writer__)), offset);
    // Sentinel = 'offset'
    ((&(writer__)))->WriteSentinel(147653256);
    IPC::WriteParam((&(writer__)), size);
    // Sentinel = 'size'
    ((&(writer__)))->WriteSentinel(73662908);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferMap", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_BufferMap__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__result = IPC::ReadParam<BufferMapResult>(aReader);
            if (!maybe__result) {
                (aReader)->FatalError("Error deserializing 'BufferMapResult'");
                return MsgValueError;

            }
            auto& result = *maybe__result;
            // Sentinel = 'result'
            if ((!((aReader)->ReadSentinel(153223840)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BufferMapResult'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(result));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendBufferMap(
        const RawId& deviceId,
        const RawId& bufferId,
        const uint32_t& aMode,
        const uint64_t& offset,
        const uint64_t& size) -> RefPtr<BufferMapPromise>
{
    RefPtr<MozPromise<BufferMapResult, ResponseRejectReason, true>::Private> promise__ = new MozPromise<BufferMapResult, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendBufferMap(std::move(deviceId), std::move(bufferId), std::move(aMode), std::move(offset), std::move(size), [promise__](BufferMapResult&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendBufferUnmap(
        const RawId& deviceId,
        const RawId& bufferId,
        const bool& flush) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BufferUnmap(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);
    IPC::WriteParam((&(writer__)), bufferId);
    // Sentinel = 'bufferId'
    ((&(writer__)))->WriteSentinel(244122408);
    IPC::WriteParam((&(writer__)), flush);
    // Sentinel = 'flush'
    ((&(writer__)))->WriteSentinel(106955299);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferUnmap", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendBufferDestroy(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BufferDestroy(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferDestroy", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendBufferDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BufferDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendTextureDestroy(
        const RawId& selfId,
        const RawId& deviceId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_TextureDestroy(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureDestroy", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendTextureDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_TextureDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendTextureViewDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_TextureViewDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_TextureViewDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendSamplerDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_SamplerDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_SamplerDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendQuerySetDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_QuerySetDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_QuerySetDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDeviceDestroy(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceDestroy(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceDestroy", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDeviceDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendCommandEncoderFinish(
        const RawId& selfId,
        const RawId& deviceId,
        const GPUCommandBufferDescriptor& desc) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_CommandEncoderFinish(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);
    IPC::WriteParam((&(writer__)), desc);
    // Sentinel = 'desc'
    ((&(writer__)))->WriteSentinel(67895712);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_CommandEncoderFinish", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendCommandEncoderDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_CommandEncoderDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_CommandEncoderDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendRenderBundleDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_RenderBundleDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_RenderBundleDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendQueueSubmit(
        const RawId& selfId,
        const RawId& aDeviceId,
        mozilla::Span<RawId const> commandBuffers,
        mozilla::Span<RawId const> textureIds) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_QueueSubmit(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), commandBuffers);
    // Sentinel = 'commandBuffers'
    ((&(writer__)))->WriteSentinel(710280621);
    IPC::WriteParam((&(writer__)), textureIds);
    // Sentinel = 'textureIds'
    ((&(writer__)))->WriteSentinel(397214770);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueSubmit", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendQueueOnSubmittedWorkDone(
        const RawId& selfId,
        mozilla::ipc::ResolveCallback<void_t>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_QueueOnSubmittedWorkDone(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueOnSubmittedWorkDone", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_QueueOnSubmittedWorkDone__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__ok = IPC::ReadParam<void_t>(aReader);
            if (!maybe__ok) {
                (aReader)->FatalError("Error deserializing 'void_t'");
                return MsgValueError;

            }
            auto& ok = *maybe__ok;
            // Sentinel = 'ok'
            if ((!((aReader)->ReadSentinel(21692635)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'void_t'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(ok));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendQueueOnSubmittedWorkDone(const RawId& selfId) -> RefPtr<QueueOnSubmittedWorkDonePromise>
{
    RefPtr<MozPromise<void_t, ResponseRejectReason, true>::Private> promise__ = new MozPromise<void_t, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendQueueOnSubmittedWorkDone(std::move(selfId), [promise__](void_t&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendQueueWriteAction(
        const RawId& selfId,
        const RawId& aDeviceId,
        ByteBuf&& buf,
        MutableSharedMemoryHandle&& shmem) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_QueueWriteAction(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);
    IPC::WriteParam((&(writer__)), std::move(shmem));
    // Sentinel = 'shmem'
    ((&(writer__)))->WriteSentinel(107086363);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueWriteAction", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendBindGroupLayoutDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BindGroupLayoutDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BindGroupLayoutDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendPipelineLayoutDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_PipelineLayoutDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_PipelineLayoutDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendBindGroupDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_BindGroupDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_BindGroupDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendShaderModuleDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_ShaderModuleDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_ShaderModuleDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendComputePipelineDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_ComputePipelineDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_ComputePipelineDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendRenderPipelineDrop(const RawId& selfId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_RenderPipelineDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_RenderPipelineDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendImplicitLayoutDrop(
        const RawId& implicitPlId,
        mozilla::Span<RawId const> implicitBglIds) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_ImplicitLayoutDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), implicitPlId);
    // Sentinel = 'implicitPlId'
    ((&(writer__)))->WriteSentinel(537134277);
    IPC::WriteParam((&(writer__)), implicitBglIds);
    // Sentinel = 'implicitBglIds'
    ((&(writer__)))->WriteSentinel(714540433);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_ImplicitLayoutDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDeviceCreateSwapChain(
        const RawId& selfId,
        const RawId& queueId,
        const RGBDescriptor& desc,
        mozilla::Span<RawId const> bufferIds,
        const RemoteTextureOwnerId& ownerId,
        const bool& useExternalTextureInSwapChain) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceCreateSwapChain(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), queueId);
    // Sentinel = 'queueId'
    ((&(writer__)))->WriteSentinel(198050515);
    IPC::WriteParam((&(writer__)), desc);
    // Sentinel = 'desc'
    ((&(writer__)))->WriteSentinel(67895712);
    IPC::WriteParam((&(writer__)), bufferIds);
    // Sentinel = 'bufferIds'
    ((&(writer__)))->WriteSentinel(304612251);
    IPC::WriteParam((&(writer__)), ownerId);
    // Sentinel = 'ownerId'
    ((&(writer__)))->WriteSentinel(199230169);
    IPC::WriteParam((&(writer__)), useExternalTextureInSwapChain);
    // Sentinel = 'useExternalTextureInSwapChain'
    ((&(writer__)))->WriteSentinel(2989493175);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateSwapChain", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendSwapChainPresent(
        const RawId& textureId,
        const RawId& commandEncoderId,
        const RemoteTextureId& remoteTextureId,
        const RemoteTextureOwnerId& remoteTextureOwnerId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_SwapChainPresent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), textureId);
    // Sentinel = 'textureId'
    ((&(writer__)))->WriteSentinel(326828991);
    IPC::WriteParam((&(writer__)), commandEncoderId);
    // Sentinel = 'commandEncoderId'
    ((&(writer__)))->WriteSentinel(913180237);
    IPC::WriteParam((&(writer__)), remoteTextureId);
    // Sentinel = 'remoteTextureId'
    ((&(writer__)))->WriteSentinel(843056683);
    IPC::WriteParam((&(writer__)), remoteTextureOwnerId);
    // Sentinel = 'remoteTextureOwnerId'
    ((&(writer__)))->WriteSentinel(1471744054);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_SwapChainPresent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendSwapChainDrop(
        const RemoteTextureOwnerId& ownerId,
        const RemoteTextureTxnType& txnType,
        const RemoteTextureTxnId& txnId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_SwapChainDrop(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), ownerId);
    // Sentinel = 'ownerId'
    ((&(writer__)))->WriteSentinel(199230169);
    IPC::WriteParam((&(writer__)), txnType);
    // Sentinel = 'txnType'
    ((&(writer__)))->WriteSentinel(204014333);
    IPC::WriteParam((&(writer__)), txnId);
    // Sentinel = 'txnId'
    ((&(writer__)))->WriteSentinel(107545096);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_SwapChainDrop", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDevicePushErrorScope(
        const RawId& selfId,
        const GPUErrorFilter& aFilter) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DevicePushErrorScope(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);
    IPC::WriteParam((&(writer__)), aFilter);
    // Sentinel = 'aFilter'
    ((&(writer__)))->WriteSentinel(178717384);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DevicePushErrorScope", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendDevicePopErrorScope(
        const RawId& selfId,
        mozilla::ipc::ResolveCallback<PopErrorScopeResult>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DevicePopErrorScope(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), selfId);
    // Sentinel = 'selfId'
    ((&(writer__)))->WriteSentinel(143196760);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DevicePopErrorScope", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGPU::Reply_DevicePopErrorScope__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__result = IPC::ReadParam<PopErrorScopeResult>(aReader);
            if (!maybe__result) {
                (aReader)->FatalError("Error deserializing 'PopErrorScopeResult'");
                return MsgValueError;

            }
            auto& result = *maybe__result;
            // Sentinel = 'result'
            if ((!((aReader)->ReadSentinel(153223840)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PopErrorScopeResult'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(result));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGPUChild::SendDevicePopErrorScope(const RawId& selfId) -> RefPtr<DevicePopErrorScopePromise>
{
    RefPtr<MozPromise<PopErrorScopeResult, ResponseRejectReason, true>::Private> promise__ = new MozPromise<PopErrorScopeResult, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendDevicePopErrorScope(std::move(selfId), [promise__](PopErrorScopeResult&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGPUChild::SendGenerateError(
        const mozilla::Maybe<RawId>& deviceId,
        const GPUErrorFilter& type,
        const nsACString& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_GenerateError(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);
    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);
    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);




    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_GenerateError", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebGPUChild::OnMessageReceived(const Message& msg__) -> PWebGPUChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebGPU::Reply_DeviceActionWithAck__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceActionWithAck", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Reply_InstanceRequestAdapter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_InstanceRequestAdapter", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Reply_AdapterRequestDevice__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_AdapterRequestDevice", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Reply_DeviceCreateShaderModule__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceCreateShaderModule", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Reply_BufferMap__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_BufferMap", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Reply_QueueOnSubmittedWorkDone__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_QueueOnSubmittedWorkDone", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Reply_DevicePopErrorScope__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGPU::Msg_DevicePopErrorScope", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGPU::Msg_UncapturedError__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_UncapturedError", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aDeviceId = IPC::ReadParam<mozilla::Maybe<RawId>>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId?'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId?'");
                return MsgValueError;
            }
            auto maybe__message = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->RecvUncapturedError(std::move(aDeviceId), std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DropAction__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DropAction", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->RecvDropAction(std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceLost__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceLost", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__reason = IPC::ReadParam<mozilla::Maybe<uint8_t>>((&(reader__)));
            if (!maybe__reason) {
                FatalError("Error deserializing 'uint8_t?'");
                return MsgValueError;

            }
            auto& reason = *maybe__reason;
            // Sentinel = 'reason'
            if ((!(((&(reader__)))->ReadSentinel(148112009)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t?'");
                return MsgValueError;
            }
            auto maybe__message = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->RecvDeviceLost(std::move(aDeviceId), std::move(reason), std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebGPUChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebGPUChild::Result
{
    return MsgNotKnown;
}



} // namespace webgpu
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::webgpu::PWebGPUChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::webgpu::PWebGPUChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebGPU", PWebGPUMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::webgpu::PWebGPUChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
