//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebGLParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/WebGLParent.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/gfx/PCanvasManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PWebGLParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PWebGLParent::PWebGLParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebGLParent);
}

PWebGLParent::~PWebGLParent()
{
    MOZ_COUNT_DTOR(PWebGLParent);
}

auto PWebGLParent::ActorAlloc() -> void
{
    AddRef();
}

auto PWebGLParent::ActorDealloc() -> void
{
    Release();
}

auto PWebGLParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebGLParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebGLParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebGLParent::Manager() const -> PCanvasManagerParent*
{
    return static_cast<PCanvasManagerParent*>(IProtocol::Manager());
}

auto PWebGLParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebGLParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebGLParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebGLParent::SendJsWarning(const string& text) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_JsWarning(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), text);
    // Sentinel = 'text'
    ((&(writer__)))->WriteSentinel(73859526);




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_JsWarning", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGLParent::SendOnContextLoss(const ContextLossReason& aReason) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_OnContextLoss(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aReason);
    // Sentinel = 'aReason'
    ((&(writer__)))->WriteSentinel(180093642);




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_OnContextLoss", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGLParent::SendOnSyncComplete(const uint64_t& id) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_OnSyncComplete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_OnSyncComplete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGLParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebGLParent::OnMessageReceived(const Message& msg__) -> PWebGLParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebGL::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PWebGL::Msg_WaitForTxn__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_WaitForTxn", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__ownerId = IPC::ReadParam<RemoteTextureOwnerId>((&(reader__)));
            if (!maybe__ownerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;

            }
            auto& ownerId = *maybe__ownerId;
            // Sentinel = 'ownerId'
            if ((!(((&(reader__)))->ReadSentinel(199230169)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId'");
                return MsgValueError;
            }
            auto maybe__txnType = IPC::ReadParam<RemoteTextureTxnType>((&(reader__)));
            if (!maybe__txnType) {
                FatalError("Error deserializing 'RemoteTextureTxnType'");
                return MsgValueError;

            }
            auto& txnType = *maybe__txnType;
            // Sentinel = 'txnType'
            if ((!(((&(reader__)))->ReadSentinel(204014333)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureTxnType'");
                return MsgValueError;
            }
            auto maybe__txnId = IPC::ReadParam<RemoteTextureTxnId>((&(reader__)));
            if (!maybe__txnId) {
                FatalError("Error deserializing 'RemoteTextureTxnId'");
                return MsgValueError;

            }
            auto& txnId = *maybe__txnId;
            // Sentinel = 'txnId'
            if ((!(((&(reader__)))->ReadSentinel(107545096)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureTxnId'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvWaitForTxn(std::move(ownerId), std::move(txnType), std::move(txnId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGL::Msg_DispatchCommands__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_DispatchCommands", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__commands = IPC::ReadParam<BigBuffer>((&(reader__)));
            if (!maybe__commands) {
                FatalError("Error deserializing 'BigBuffer'");
                return MsgValueError;

            }
            auto& commands = *maybe__commands;
            // Sentinel = 'commands'
            if ((!(((&(reader__)))->ReadSentinel(249627475)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BigBuffer'");
                return MsgValueError;
            }
            auto maybe__size = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__size) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& size = *maybe__size;
            // Sentinel = 'size'
            if ((!(((&(reader__)))->ReadSentinel(73662908)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvDispatchCommands(std::move(commands), std::move(size));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGL::Msg_Ping__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_Ping", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebGL::Reply_Ping(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            PingResolver resolver = [resolver__ = std::move(resolver__)](const void_t& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'ok'
                    ((&(writer__)))->WriteSentinel(21692635);

                    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebGLParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvPing(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGL::Msg_TexImage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_TexImage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__level = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__level) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& level = *maybe__level;
            // Sentinel = 'level'
            if ((!(((&(reader__)))->ReadSentinel(105710105)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__respecFormat = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__respecFormat) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& respecFormat = *maybe__respecFormat;
            // Sentinel = 'respecFormat'
            if ((!(((&(reader__)))->ReadSentinel(538576108)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__offset = IPC::ReadParam<uvec3>((&(reader__)));
            if (!maybe__offset) {
                FatalError("Error deserializing 'uvec3'");
                return MsgValueError;

            }
            auto& offset = *maybe__offset;
            // Sentinel = 'offset'
            if ((!(((&(reader__)))->ReadSentinel(147653256)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uvec3'");
                return MsgValueError;
            }
            auto maybe__pi = IPC::ReadParam<PackingInfo>((&(reader__)));
            if (!maybe__pi) {
                FatalError("Error deserializing 'PackingInfo'");
                return MsgValueError;

            }
            auto& pi = *maybe__pi;
            // Sentinel = 'pi'
            if ((!(((&(reader__)))->ReadSentinel(21692634)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PackingInfo'");
                return MsgValueError;
            }
            auto maybe__src = IPC::ReadParam<TexUnpackBlobDesc>((&(reader__)));
            if (!maybe__src) {
                FatalError("Error deserializing 'TexUnpackBlobDesc'");
                return MsgValueError;

            }
            auto& src = *maybe__src;
            // Sentinel = 'src'
            if ((!(((&(reader__)))->ReadSentinel(44237129)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TexUnpackBlobDesc'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvTexImage(std::move(level), std::move(respecFormat), std::move(offset), std::move(pi), std::move(src));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebGLParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebGLParent::Result
{
    switch (msg__.type()) {
    case PWebGL::Msg_Initialize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_Initialize", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__desc = IPC::ReadParam<InitContextDesc>((&(reader__)));
            if (!maybe__desc) {
                FatalError("Error deserializing 'InitContextDesc'");
                return MsgValueError;

            }
            auto& desc = *maybe__desc;
            // Sentinel = 'desc'
            if ((!(((&(reader__)))->ReadSentinel(67895712)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'InitContextDesc'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            InitContextResult res{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvInitialize(std::move(desc), (&(res)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_Initialize(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), res);
            // Sentinel = 'res'
            ((&(writer__)))->WriteSentinel(43385163);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_SyncPing__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_SyncPing", OTHER);

            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvSyncPing();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_SyncPing(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetBufferSubData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetBufferSubData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__target = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__target) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& target = *maybe__target;
            // Sentinel = 'target'
            if ((!(((&(reader__)))->ReadSentinel(148767368)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__srcByteOffset = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__srcByteOffset) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& srcByteOffset = *maybe__srcByteOffset;
            // Sentinel = 'srcByteOffset'
            if ((!(((&(reader__)))->ReadSentinel(616301892)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__byteSize = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__byteSize) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& byteSize = *maybe__byteSize;
            // Sentinel = 'byteSize'
            if ((!(((&(reader__)))->ReadSentinel(251134800)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            Shmem ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetBufferSubData(std::move(target), std::move(srcByteOffset), std::move(byteSize), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetBufferSubData(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), std::move(ret));
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetFrontBufferSnapshot__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetFrontBufferSnapshot", OTHER);

            int32_t id__ = Id();
            FrontBufferSnapshotIpc ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetFrontBufferSnapshot((&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetFrontBufferSnapshot(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_ReadPixels__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_ReadPixels", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__desc = IPC::ReadParam<ReadPixelsDesc>((&(reader__)));
            if (!maybe__desc) {
                FatalError("Error deserializing 'ReadPixelsDesc'");
                return MsgValueError;

            }
            auto& desc = *maybe__desc;
            // Sentinel = 'desc'
            if ((!(((&(reader__)))->ReadSentinel(67895712)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ReadPixelsDesc'");
                return MsgValueError;
            }
            auto maybe__buffer = IPC::ReadParam<ReadPixelsBuffer>((&(reader__)));
            if (!maybe__buffer) {
                FatalError("Error deserializing 'ReadPixelsBuffer'");
                return MsgValueError;

            }
            auto& buffer = *maybe__buffer;
            // Sentinel = 'buffer'
            if ((!(((&(reader__)))->ReadSentinel(144769659)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ReadPixelsBuffer'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            ReadPixelsResultIpc ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvReadPixels(std::move(desc), std::move(buffer), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_ReadPixels(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_CheckFramebufferStatus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_CheckFramebufferStatus", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__target = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__target) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& target = *maybe__target;
            // Sentinel = 'target'
            if ((!(((&(reader__)))->ReadSentinel(148767368)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            uint32_t ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvCheckFramebufferStatus(std::move(target), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_CheckFramebufferStatus(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_ClientWaitSync__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_ClientWaitSync", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__timeout = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__timeout) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& timeout = *maybe__timeout;
            // Sentinel = 'timeout'
            if ((!(((&(reader__)))->ReadSentinel(201917192)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            uint32_t ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvClientWaitSync(std::move(id), std::move(flags), std::move(timeout), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_ClientWaitSync(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_CreateOpaqueFramebuffer__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_CreateOpaqueFramebuffer", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__options = IPC::ReadParam<OpaqueFramebufferOptions>((&(reader__)));
            if (!maybe__options) {
                FatalError("Error deserializing 'OpaqueFramebufferOptions'");
                return MsgValueError;

            }
            auto& options = *maybe__options;
            // Sentinel = 'options'
            if ((!(((&(reader__)))->ReadSentinel(204735245)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpaqueFramebufferOptions'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            bool ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvCreateOpaqueFramebuffer(std::move(id), std::move(options), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_CreateOpaqueFramebuffer(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_DrawingBufferSize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_DrawingBufferSize", OTHER);

            int32_t id__ = Id();
            uvec2 ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvDrawingBufferSize((&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_DrawingBufferSize(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_Finish__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_Finish", OTHER);

            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvFinish();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_Finish(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetBufferParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetBufferParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__target = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__target) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& target = *maybe__target;
            // Sentinel = 'target'
            if ((!(((&(reader__)))->ReadSentinel(148767368)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetBufferParameter(std::move(target), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetBufferParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetCompileResult__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetCompileResult", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            CompileResult ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetCompileResult(std::move(id), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetCompileResult(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetError__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetError", OTHER);

            int32_t id__ = Id();
            uint32_t ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetError((&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetError(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetFragDataLocation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetFragDataLocation", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__name = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__name) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& name = *maybe__name;
            // Sentinel = 'name'
            if ((!(((&(reader__)))->ReadSentinel(69075362)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            int32_t ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetFragDataLocation(std::move(id), std::move(name), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetFragDataLocation(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetFramebufferAttachmentParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetFramebufferAttachmentParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__attachment = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__attachment) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& attachment = *maybe__attachment;
            // Sentinel = 'attachment'
            if ((!(((&(reader__)))->ReadSentinel(381420586)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetFramebufferAttachmentParameter(std::move(id), std::move(attachment), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetFramebufferAttachmentParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetFrontBuffer__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetFrontBuffer", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__fb = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__fb) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& fb = *maybe__fb;
            // Sentinel = 'fb'
            if ((!(((&(reader__)))->ReadSentinel(19923145)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__vr = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__vr) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& vr = *maybe__vr;
            // Sentinel = 'vr'
            if ((!(((&(reader__)))->ReadSentinel(23068905)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<SurfaceDescriptor> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetFrontBuffer(std::move(fb), std::move(vr), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetFrontBuffer(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetIndexedParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetIndexedParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__target = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__target) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& target = *maybe__target;
            // Sentinel = 'target'
            if ((!(((&(reader__)))->ReadSentinel(148767368)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__index = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__index) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& index = *maybe__index;
            // Sentinel = 'index'
            if ((!(((&(reader__)))->ReadSentinel(104333849)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetIndexedParameter(std::move(target), std::move(index), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetIndexedParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetInternalformatParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetInternalformatParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__target = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__target) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& target = *maybe__target;
            // Sentinel = 'target'
            if ((!(((&(reader__)))->ReadSentinel(148767368)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__internalFormat = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__internalFormat) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& internalFormat = *maybe__internalFormat;
            // Sentinel = 'internalFormat'
            if ((!(((&(reader__)))->ReadSentinel(730531271)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<Int32Vector> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetInternalformatParameter(std::move(target), std::move(internalFormat), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetInternalformatParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetLinkResult__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetLinkResult", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            LinkResult ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetLinkResult(std::move(id), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetLinkResult(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetNumber__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetNumber", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetNumber(std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetNumber(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetQueryParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetQueryParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetQueryParameter(std::move(id), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetQueryParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetRenderbufferParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetRenderbufferParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetRenderbufferParameter(std::move(id), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetRenderbufferParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetSamplerParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetSamplerParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetSamplerParameter(std::move(id), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetSamplerParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetString__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetString", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<string> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetString(std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetString(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetTexParameter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetTexParameter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetTexParameter(std::move(id), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetTexParameter(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetUniform__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetUniform", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__loc = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__loc) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& loc = *maybe__loc;
            // Sentinel = 'loc'
            if ((!(((&(reader__)))->ReadSentinel(42467647)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            GetUniformData ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetUniform(std::move(id), std::move(loc), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetUniform(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_GetVertexAttrib__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_GetVertexAttrib", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__index = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__index) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& index = *maybe__index;
            // Sentinel = 'index'
            if ((!(((&(reader__)))->ReadSentinel(104333849)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__pname = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__pname) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& pname = *maybe__pname;
            // Sentinel = 'pname'
            if ((!(((&(reader__)))->ReadSentinel(105841170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            mozilla::Maybe<double> ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvGetVertexAttrib(std::move(index), std::move(pname), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_GetVertexAttrib(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_OnMemoryPressure__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_OnMemoryPressure", OTHER);

            int32_t id__ = Id();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvOnMemoryPressure();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_OnMemoryPressure(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};


            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PWebGL::Msg_ValidateProgram__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_ValidateProgram", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            bool ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLParent*>(this))->RecvValidateProgram(std::move(id), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PWebGL::Reply_ValidateProgram(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);

            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebGLParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PWebGLParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebGL", PWebGLMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PWebGLParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
