//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebGLChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/dom/WebGLChild.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/gfx/PCanvasManagerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PWebGLChild::PWebGLChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PWebGLChild);
}

PWebGLChild::~PWebGLChild()
{
    MOZ_COUNT_DTOR(PWebGLChild);
}

auto PWebGLChild::ActorAlloc() -> void
{
    AddRef();
}

auto PWebGLChild::ActorDealloc() -> void
{
    Release();
}

auto PWebGLChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebGLChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebGLChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebGLChild::Manager() const -> PCanvasManagerChild*
{
    return static_cast<PCanvasManagerChild*>(IProtocol::Manager());
}

auto PWebGLChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebGLChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebGLChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebGLChild::SendInitialize(
        const InitContextDesc& desc,
        InitContextResult* res) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_Initialize(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), desc);
    // Sentinel = 'desc'
    ((&(writer__)))->WriteSentinel(67895712);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_Initialize", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_Initialize", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__res__reply = IPC::ReadParam<InitContextResult>((&(reader__)));
    if (!maybe__res__reply) {
        FatalError("Error deserializing 'InitContextResult'");
        return false;

    }
    auto& res__reply = *maybe__res__reply;
    // Sentinel = 'res'
    if ((!(((&(reader__)))->ReadSentinel(43385163)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'InitContextResult'");
        return false;
    }
    (*(res)) = std::move(res__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::Send__delete__(PWebGLChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebGLChild::SendWaitForTxn(
        const RemoteTextureOwnerId& ownerId,
        const RemoteTextureTxnType& txnType,
        const RemoteTextureTxnId& txnId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_WaitForTxn(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), ownerId);
    // Sentinel = 'ownerId'
    ((&(writer__)))->WriteSentinel(199230169);
    IPC::WriteParam((&(writer__)), txnType);
    // Sentinel = 'txnType'
    ((&(writer__)))->WriteSentinel(204014333);
    IPC::WriteParam((&(writer__)), txnId);
    // Sentinel = 'txnId'
    ((&(writer__)))->WriteSentinel(107545096);




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_WaitForTxn", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGLChild::SendDispatchCommands(
        BigBuffer&& commands,
        const uint64_t& size) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_DispatchCommands(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(commands));
    // Sentinel = 'commands'
    ((&(writer__)))->WriteSentinel(249627475);
    IPC::WriteParam((&(writer__)), size);
    // Sentinel = 'size'
    ((&(writer__)))->WriteSentinel(73662908);




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_DispatchCommands", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGLChild::SendPing(
        mozilla::ipc::ResolveCallback<void_t>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_Ping(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_Ping", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebGL::Reply_Ping__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__ok = IPC::ReadParam<void_t>(aReader);
            if (!maybe__ok) {
                (aReader)->FatalError("Error deserializing 'void_t'");
                return MsgValueError;

            }
            auto& ok = *maybe__ok;
            // Sentinel = 'ok'
            if ((!((aReader)->ReadSentinel(21692635)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'void_t'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(ok));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebGLChild::SendPing() -> RefPtr<PingPromise>
{
    RefPtr<MozPromise<void_t, ResponseRejectReason, true>::Private> promise__ = new MozPromise<void_t, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendPing([promise__](void_t&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebGLChild::SendSyncPing() -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_SyncPing(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};




    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_SyncPing", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_SyncPing", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PWebGLChild::SendTexImage(
        const uint32_t& level,
        const uint32_t& respecFormat,
        const uvec3& offset,
        const PackingInfo& pi,
        TexUnpackBlobDesc&& src) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_TexImage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), level);
    // Sentinel = 'level'
    ((&(writer__)))->WriteSentinel(105710105);
    IPC::WriteParam((&(writer__)), respecFormat);
    // Sentinel = 'respecFormat'
    ((&(writer__)))->WriteSentinel(538576108);
    IPC::WriteParam((&(writer__)), offset);
    // Sentinel = 'offset'
    ((&(writer__)))->WriteSentinel(147653256);
    IPC::WriteParam((&(writer__)), pi);
    // Sentinel = 'pi'
    ((&(writer__)))->WriteSentinel(21692634);
    IPC::WriteParam((&(writer__)), std::move(src));
    // Sentinel = 'src'
    ((&(writer__)))->WriteSentinel(44237129);




    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_TexImage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGLChild::SendGetBufferSubData(
        const uint32_t& target,
        const uint64_t& srcByteOffset,
        const uint64_t& byteSize,
        Shmem* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetBufferSubData(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), target);
    // Sentinel = 'target'
    ((&(writer__)))->WriteSentinel(148767368);
    IPC::WriteParam((&(writer__)), srcByteOffset);
    // Sentinel = 'srcByteOffset'
    ((&(writer__)))->WriteSentinel(616301892);
    IPC::WriteParam((&(writer__)), byteSize);
    // Sentinel = 'byteSize'
    ((&(writer__)))->WriteSentinel(251134800);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetBufferSubData", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetBufferSubData", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<Shmem>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'Shmem'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetFrontBufferSnapshot(FrontBufferSnapshotIpc* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetFrontBufferSnapshot(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};




    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetFrontBufferSnapshot", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetFrontBufferSnapshot", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<FrontBufferSnapshotIpc>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'FrontBufferSnapshotIpc'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'FrontBufferSnapshotIpc'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendReadPixels(
        const ReadPixelsDesc& desc,
        const ReadPixelsBuffer& buffer,
        ReadPixelsResultIpc* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_ReadPixels(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), desc);
    // Sentinel = 'desc'
    ((&(writer__)))->WriteSentinel(67895712);
    IPC::WriteParam((&(writer__)), buffer);
    // Sentinel = 'buffer'
    ((&(writer__)))->WriteSentinel(144769659);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_ReadPixels", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_ReadPixels", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<ReadPixelsResultIpc>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'ReadPixelsResultIpc'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'ReadPixelsResultIpc'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendCheckFramebufferStatus(
        const uint32_t& target,
        uint32_t* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_CheckFramebufferStatus(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), target);
    // Sentinel = 'target'
    ((&(writer__)))->WriteSentinel(148767368);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_CheckFramebufferStatus", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_CheckFramebufferStatus", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<uint32_t>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'uint32_t'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendClientWaitSync(
        const uint64_t& id,
        const uint32_t& flags,
        const uint64_t& timeout,
        uint32_t* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_ClientWaitSync(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), flags);
    // Sentinel = 'flags'
    ((&(writer__)))->WriteSentinel(102171150);
    IPC::WriteParam((&(writer__)), timeout);
    // Sentinel = 'timeout'
    ((&(writer__)))->WriteSentinel(201917192);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_ClientWaitSync", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_ClientWaitSync", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<uint32_t>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'uint32_t'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendCreateOpaqueFramebuffer(
        const uint64_t& id,
        const OpaqueFramebufferOptions& options,
        bool* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_CreateOpaqueFramebuffer(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), options);
    // Sentinel = 'options'
    ((&(writer__)))->WriteSentinel(204735245);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_CreateOpaqueFramebuffer", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_CreateOpaqueFramebuffer", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<bool>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'bool'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendDrawingBufferSize(uvec2* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_DrawingBufferSize(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};




    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_DrawingBufferSize", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_DrawingBufferSize", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<uvec2>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'uvec2'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'uvec2'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendFinish() -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_Finish(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};




    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_Finish", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_Finish", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PWebGLChild::SendGetBufferParameter(
        const uint32_t& target,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetBufferParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), target);
    // Sentinel = 'target'
    ((&(writer__)))->WriteSentinel(148767368);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetBufferParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetBufferParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetCompileResult(
        const uint64_t& id,
        CompileResult* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetCompileResult(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetCompileResult", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetCompileResult", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<CompileResult>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'CompileResult'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'CompileResult'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetError(uint32_t* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetError(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};




    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetError", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetError", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<uint32_t>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'uint32_t'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetFragDataLocation(
        const uint64_t& id,
        const string& name,
        int32_t* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetFragDataLocation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), name);
    // Sentinel = 'name'
    ((&(writer__)))->WriteSentinel(69075362);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetFragDataLocation", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetFragDataLocation", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<int32_t>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'int32_t'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetFramebufferAttachmentParameter(
        const uint64_t& id,
        const uint32_t& attachment,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetFramebufferAttachmentParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), attachment);
    // Sentinel = 'attachment'
    ((&(writer__)))->WriteSentinel(381420586);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetFramebufferAttachmentParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetFramebufferAttachmentParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetFrontBuffer(
        const uint64_t& fb,
        const bool& vr,
        mozilla::Maybe<SurfaceDescriptor>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetFrontBuffer(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), fb);
    // Sentinel = 'fb'
    ((&(writer__)))->WriteSentinel(19923145);
    IPC::WriteParam((&(writer__)), vr);
    // Sentinel = 'vr'
    ((&(writer__)))->WriteSentinel(23068905);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetFrontBuffer", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetFrontBuffer", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<SurfaceDescriptor>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'SurfaceDescriptor?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'SurfaceDescriptor?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetIndexedParameter(
        const uint32_t& target,
        const uint32_t& index,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetIndexedParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), target);
    // Sentinel = 'target'
    ((&(writer__)))->WriteSentinel(148767368);
    IPC::WriteParam((&(writer__)), index);
    // Sentinel = 'index'
    ((&(writer__)))->WriteSentinel(104333849);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetIndexedParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetIndexedParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetInternalformatParameter(
        const uint32_t& target,
        const uint32_t& internalFormat,
        const uint32_t& pname,
        mozilla::Maybe<Int32Vector>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetInternalformatParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), target);
    // Sentinel = 'target'
    ((&(writer__)))->WriteSentinel(148767368);
    IPC::WriteParam((&(writer__)), internalFormat);
    // Sentinel = 'internalFormat'
    ((&(writer__)))->WriteSentinel(730531271);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetInternalformatParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetInternalformatParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<Int32Vector>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'Int32Vector?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'Int32Vector?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetLinkResult(
        const uint64_t& id,
        LinkResult* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetLinkResult(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetLinkResult", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetLinkResult", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<LinkResult>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'LinkResult'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'LinkResult'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetNumber(
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetNumber(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetNumber", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetNumber", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetQueryParameter(
        const uint64_t& id,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetQueryParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetQueryParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetQueryParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetRenderbufferParameter(
        const uint64_t& id,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetRenderbufferParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetRenderbufferParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetRenderbufferParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetSamplerParameter(
        const uint64_t& id,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetSamplerParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetSamplerParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetSamplerParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetString(
        const uint32_t& pname,
        mozilla::Maybe<string>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetString(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetString", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetString", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<string>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'string?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'string?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetTexParameter(
        const uint64_t& id,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetTexParameter(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetTexParameter", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetTexParameter", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetUniform(
        const uint64_t& id,
        const uint32_t& loc,
        GetUniformData* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetUniform(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), loc);
    // Sentinel = 'loc'
    ((&(writer__)))->WriteSentinel(42467647);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetUniform", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetUniform", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<GetUniformData>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'GetUniformData'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'GetUniformData'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendGetVertexAttrib(
        const uint32_t& index,
        const uint32_t& pname,
        mozilla::Maybe<double>* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_GetVertexAttrib(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), index);
    // Sentinel = 'index'
    ((&(writer__)))->WriteSentinel(104333849);
    IPC::WriteParam((&(writer__)), pname);
    // Sentinel = 'pname'
    ((&(writer__)))->WriteSentinel(105841170);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_GetVertexAttrib", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_GetVertexAttrib", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<mozilla::Maybe<double>>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'double?'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'double?'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::SendOnMemoryPressure() -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_OnMemoryPressure(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};




    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_OnMemoryPressure", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_OnMemoryPressure", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PWebGLChild::SendValidateProgram(
        const uint64_t& id,
        bool* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGL::Msg_ValidateProgram(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGL::Msg_ValidateProgram", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PWebGL::Msg_ValidateProgram", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGLChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<bool>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'bool'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PWebGLChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebGLChild::OnMessageReceived(const Message& msg__) -> PWebGLChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebGL::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PWebGL::Reply_Ping__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebGL::Msg_Ping", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebGL::Msg_JsWarning__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_JsWarning", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__text = IPC::ReadParam<string>((&(reader__)));
            if (!maybe__text) {
                FatalError("Error deserializing 'string'");
                return MsgValueError;

            }
            auto& text = *maybe__text;
            // Sentinel = 'text'
            if ((!(((&(reader__)))->ReadSentinel(73859526)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'string'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLChild*>(this))->RecvJsWarning(std::move(text));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGL::Msg_OnContextLoss__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_OnContextLoss", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aReason = IPC::ReadParam<ContextLossReason>((&(reader__)));
            if (!maybe__aReason) {
                FatalError("Error deserializing 'ContextLossReason'");
                return MsgValueError;

            }
            auto& aReason = *maybe__aReason;
            // Sentinel = 'aReason'
            if ((!(((&(reader__)))->ReadSentinel(180093642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ContextLossReason'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLChild*>(this))->RecvOnContextLoss(std::move(aReason));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGL::Msg_OnSyncComplete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGL", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGLChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGL::Msg_OnSyncComplete", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGLChild*>(this))->RecvOnSyncComplete(std::move(id));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebGLChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebGLChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebGLChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PWebGLChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebGL", PWebGLMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PWebGLChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
