//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/PWebBrowserPersistResourcesParent.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/PWebBrowserPersistDocumentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {


MOZ_IMPLICIT PWebBrowserPersistResourcesParent::PWebBrowserPersistResourcesParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebBrowserPersistResourcesParent);
}

PWebBrowserPersistResourcesParent::~PWebBrowserPersistResourcesParent()
{
    MOZ_COUNT_DTOR(PWebBrowserPersistResourcesParent);
}

auto PWebBrowserPersistResourcesParent::ActorAlloc() -> void
{
}

auto PWebBrowserPersistResourcesParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PWebBrowserPersistResourcesParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebBrowserPersistResourcesParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebBrowserPersistResourcesParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebBrowserPersistResourcesParent::Manager() const -> PWebBrowserPersistDocumentParent*
{
    return static_cast<PWebBrowserPersistDocumentParent*>(IProtocol::Manager());
}

auto PWebBrowserPersistResourcesParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebBrowserPersistResourcesParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebBrowserPersistResourcesParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebBrowserPersistResourcesParent::OnMessageReceived(const Message& msg__) -> PWebBrowserPersistResourcesParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebBrowserPersistResources::Msg_VisitResource__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebBrowserPersistResources", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebBrowserPersistResourcesParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebBrowserPersistResources::Msg_VisitResource", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aURI = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aURI) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aURI = *maybe__aURI;
            // Sentinel = 'aURI'
            if ((!(((&(reader__)))->ReadSentinel(57934162)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aContentPolicyType = IPC::ReadParam<nsContentPolicyType>((&(reader__)));
            if (!maybe__aContentPolicyType) {
                FatalError("Error deserializing 'nsContentPolicyType'");
                return MsgValueError;

            }
            auto& aContentPolicyType = *maybe__aContentPolicyType;
            // Sentinel = 'aContentPolicyType'
            if ((!(((&(reader__)))->ReadSentinel(1145767759)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsContentPolicyType'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvVisitResource(std::move(aURI), std::move(aContentPolicyType));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebBrowserPersistResources::Msg_VisitDocument__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebBrowserPersistResources", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebBrowserPersistResourcesParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebBrowserPersistResources::Msg_VisitDocument", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSubDocument = IPC::ReadParam<mozilla::NotNull<PWebBrowserPersistDocumentParent*>>((&(reader__)));
            if (!maybe__aSubDocument) {
                FatalError("Error deserializing 'NotNull<PWebBrowserPersistDocument>'");
                return MsgValueError;

            }
            auto& aSubDocument = *maybe__aSubDocument;
            // Sentinel = 'aSubDocument'
            if ((!(((&(reader__)))->ReadSentinel(505677003)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PWebBrowserPersistDocument>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvVisitDocument(aSubDocument);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebBrowserPersistResources::Msg_VisitBrowsingContext__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebBrowserPersistResources", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebBrowserPersistResourcesParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebBrowserPersistResources::Msg_VisitBrowsingContext", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aContext = IPC::ReadParam<MaybeDiscardedBrowsingContext>((&(reader__)));
            if (!maybe__aContext) {
                FatalError("Error deserializing 'MaybeDiscardedBrowsingContext'");
                return MsgValueError;

            }
            auto& aContext = *maybe__aContext;
            // Sentinel = 'aContext'
            if ((!(((&(reader__)))->ReadSentinel(235406151)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MaybeDiscardedBrowsingContext'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvVisitBrowsingContext(std::move(aContext));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebBrowserPersistResources::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebBrowserPersistResources", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebBrowserPersistResourcesParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebBrowserPersistResources::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStatus = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__aStatus) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& aStatus = *maybe__aStatus;
            // Sentinel = 'aStatus'
            if ((!(((&(reader__)))->ReadSentinel(186712806)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__(std::move(aStatus));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebBrowserPersistResourcesParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebBrowserPersistResourcesParent::Result
{
    return MsgNotKnown;
}



} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::PWebBrowserPersistResourcesParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::PWebBrowserPersistResourcesParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebBrowserPersistResources", PWebBrowserPersistResourcesMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::PWebBrowserPersistResourcesParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
