//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebAuthnTransactionParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/WebAuthnTransactionParent.h"

#include "mozilla/dom/PWindowGlobalParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PWebAuthnTransactionParent::PWebAuthnTransactionParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebAuthnTransactionParent);
}

PWebAuthnTransactionParent::~PWebAuthnTransactionParent()
{
    MOZ_COUNT_DTOR(PWebAuthnTransactionParent);
}

auto PWebAuthnTransactionParent::ActorAlloc() -> void
{
    AddRef();
}

auto PWebAuthnTransactionParent::ActorDealloc() -> void
{
    Release();
}

auto PWebAuthnTransactionParent::Manager() const -> PWindowGlobalParent*
{
    return static_cast<PWindowGlobalParent*>(IProtocol::Manager());
}

auto PWebAuthnTransactionParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebAuthnTransactionParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebAuthnTransactionParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebAuthnTransactionParent::Send__delete__(PWebAuthnTransactionParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebAuthnTransaction::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebAuthnTransactionParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebAuthnTransaction::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebAuthnTransactionParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebAuthnTransactionParent::OnMessageReceived(const Message& msg__) -> PWebAuthnTransactionParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebAuthnTransaction::Msg_RequestRegister__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebAuthnTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebAuthnTransaction::Msg_RequestRegister", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTransactionInfo = IPC::ReadParam<WebAuthnMakeCredentialInfo>((&(reader__)));
            if (!maybe__aTransactionInfo) {
                FatalError("Error deserializing 'WebAuthnMakeCredentialInfo'");
                return MsgValueError;

            }
            auto& aTransactionInfo = *maybe__aTransactionInfo;
            // Sentinel = 'aTransactionInfo'
            if ((!(((&(reader__)))->ReadSentinel(914032244)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebAuthnMakeCredentialInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebAuthnTransaction::Reply_RequestRegister(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RequestRegisterResolver resolver = [resolver__ = std::move(resolver__)](const WebAuthnMakeCredentialResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebAuthnTransactionParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebAuthnTransactionParent*>(this))->RecvRequestRegister(std::move(aTransactionInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebAuthnTransaction::Msg_RequestSign__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebAuthnTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebAuthnTransaction::Msg_RequestSign", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTransactionInfo = IPC::ReadParam<WebAuthnGetAssertionInfo>((&(reader__)));
            if (!maybe__aTransactionInfo) {
                FatalError("Error deserializing 'WebAuthnGetAssertionInfo'");
                return MsgValueError;

            }
            auto& aTransactionInfo = *maybe__aTransactionInfo;
            // Sentinel = 'aTransactionInfo'
            if ((!(((&(reader__)))->ReadSentinel(914032244)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WebAuthnGetAssertionInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebAuthnTransaction::Reply_RequestSign(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RequestSignResolver resolver = [resolver__ = std::move(resolver__)](const WebAuthnGetAssertionResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebAuthnTransactionParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebAuthnTransactionParent*>(this))->RecvRequestSign(std::move(aTransactionInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebAuthnTransaction::Msg_RequestIsUVPAA__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebAuthnTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebAuthnTransaction::Msg_RequestIsUVPAA", OTHER);

            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebAuthnTransaction::Reply_RequestIsUVPAA(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RequestIsUVPAAResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'available'
                    ((&(writer__)))->WriteSentinel(306316194);

                    if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebAuthnTransactionParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebAuthnTransactionParent*>(this))->RecvRequestIsUVPAA(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebAuthnTransaction::Msg_RequestCancel__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebAuthnTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebAuthnTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebAuthnTransaction::Msg_RequestCancel", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<WebAuthnTransactionParent*>(this))->RecvRequestCancel();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebAuthnTransaction::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebAuthnTransactionParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebAuthnTransactionParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebAuthnTransactionParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PWebAuthnTransactionParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PWebAuthnTransaction", PWebAuthnTransactionMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PWebAuthnTransactionParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
