//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PUDPSocketChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/network/UDPSocketChild.h"
#include "mozilla/dom/network/UDPSocketParent.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/net/DNS.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "prio.h"

#include "mozilla/net/PNeckoChild.h"
#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PUDPSocketChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PUDPSocketChild::PUDPSocketChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PUDPSocketChild);
}

PUDPSocketChild::~PUDPSocketChild()
{
    MOZ_COUNT_DTOR(PUDPSocketChild);
}

auto PUDPSocketChild::ActorAlloc() -> void
{
}

auto PUDPSocketChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PUDPSocketChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PUDPSocketChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PUDPSocketChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PUDPSocketChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PUDPSocketChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PUDPSocketChild::SendBind(
        const UDPAddressInfo& addressInfo,
        const bool& addressReuse,
        const bool& loopback,
        const uint32_t& recvBufferSize,
        const uint32_t& sendBufferSize) -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_Bind(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), addressInfo);
    // Sentinel = 'addressInfo'
    ((&(writer__)))->WriteSentinel(445580403);
    IPC::WriteParam((&(writer__)), addressReuse);
    // Sentinel = 'addressReuse'
    ((&(writer__)))->WriteSentinel(530908395);
    IPC::WriteParam((&(writer__)), loopback);
    // Sentinel = 'loopback'
    ((&(writer__)))->WriteSentinel(253166412);
    IPC::WriteParam((&(writer__)), recvBufferSize);
    // Sentinel = 'recvBufferSize'
    ((&(writer__)))->WriteSentinel(709100966);
    IPC::WriteParam((&(writer__)), sendBufferSize);
    // Sentinel = 'sendBufferSize'
    ((&(writer__)))->WriteSentinel(705693088);




    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_Bind", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::SendConnect(const UDPAddressInfo& addressInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_Connect(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), addressInfo);
    // Sentinel = 'addressInfo'
    ((&(writer__)))->WriteSentinel(445580403);




    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_Connect", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::SendOutgoingData(
        const UDPData& data,
        const UDPSocketAddr& addr) -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_OutgoingData(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), data);
    // Sentinel = 'data'
    ((&(writer__)))->WriteSentinel(67109275);
    IPC::WriteParam((&(writer__)), addr);
    // Sentinel = 'addr'
    ((&(writer__)))->WriteSentinel(65929628);




    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_OutgoingData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::SendJoinMulticast(
        const nsACString& multicastAddress,
        const nsACString& iface) -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_JoinMulticast(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), multicastAddress);
    // Sentinel = 'multicastAddress'
    ((&(writer__)))->WriteSentinel(948700829);
    IPC::WriteParam((&(writer__)), iface);
    // Sentinel = 'iface'
    ((&(writer__)))->WriteSentinel(100139513);




    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_JoinMulticast", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::SendLeaveMulticast(
        const nsACString& multicastAddress,
        const nsACString& iface) -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_LeaveMulticast(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), multicastAddress);
    // Sentinel = 'multicastAddress'
    ((&(writer__)))->WriteSentinel(948700829);
    IPC::WriteParam((&(writer__)), iface);
    // Sentinel = 'iface'
    ((&(writer__)))->WriteSentinel(100139513);




    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_LeaveMulticast", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::SendClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_Close(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_Close", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::SendRequestDelete() -> bool
{
    UniquePtr<IPC::Message> msg__ = PUDPSocket::Msg_RequestDelete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PUDPSocketChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PUDPSocket::Msg_RequestDelete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PUDPSocketChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PUDPSocketChild::OnMessageReceived(const Message& msg__) -> PUDPSocketChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PUDPSocket::Msg_CallbackOpened__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PUDPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PUDPSocket::Msg_CallbackOpened", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__addressInfo = IPC::ReadParam<UDPAddressInfo>((&(reader__)));
            if (!maybe__addressInfo) {
                FatalError("Error deserializing 'UDPAddressInfo'");
                return MsgValueError;

            }
            auto& addressInfo = *maybe__addressInfo;
            // Sentinel = 'addressInfo'
            if ((!(((&(reader__)))->ReadSentinel(445580403)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'UDPAddressInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::UDPSocketChild*>(this))->RecvCallbackOpened(std::move(addressInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PUDPSocket::Msg_CallbackConnected__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PUDPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PUDPSocket::Msg_CallbackConnected", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__addressInfo = IPC::ReadParam<UDPAddressInfo>((&(reader__)));
            if (!maybe__addressInfo) {
                FatalError("Error deserializing 'UDPAddressInfo'");
                return MsgValueError;

            }
            auto& addressInfo = *maybe__addressInfo;
            // Sentinel = 'addressInfo'
            if ((!(((&(reader__)))->ReadSentinel(445580403)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'UDPAddressInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::UDPSocketChild*>(this))->RecvCallbackConnected(std::move(addressInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PUDPSocket::Msg_CallbackClosed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PUDPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PUDPSocket::Msg_CallbackClosed", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::UDPSocketChild*>(this))->RecvCallbackClosed();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PUDPSocket::Msg_CallbackReceivedData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PUDPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PUDPSocket::Msg_CallbackReceivedData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__addressInfo = IPC::ReadParam<UDPAddressInfo>((&(reader__)));
            if (!maybe__addressInfo) {
                FatalError("Error deserializing 'UDPAddressInfo'");
                return MsgValueError;

            }
            auto& addressInfo = *maybe__addressInfo;
            // Sentinel = 'addressInfo'
            if ((!(((&(reader__)))->ReadSentinel(445580403)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'UDPAddressInfo'");
                return MsgValueError;
            }
            auto maybe__data = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::UDPSocketChild*>(this))->RecvCallbackReceivedData(std::move(addressInfo), std::move(data));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PUDPSocket::Msg_CallbackError__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PUDPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PUDPSocket::Msg_CallbackError", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__message = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__filename = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__filename) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& filename = *maybe__filename;
            // Sentinel = 'filename'
            if ((!(((&(reader__)))->ReadSentinel(246547266)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__lineNumber = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__lineNumber) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& lineNumber = *maybe__lineNumber;
            // Sentinel = 'lineNumber'
            if ((!(((&(reader__)))->ReadSentinel(374932498)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::UDPSocketChild*>(this))->RecvCallbackError(std::move(message), std::move(filename), std::move(lineNumber));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PUDPSocket::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PUDPSocket", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PUDPSocketChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PUDPSocket::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<mozilla::dom::UDPSocketChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PUDPSocketChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PUDPSocketChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PUDPSocketChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PUDPSocketChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PUDPSocket", PUDPSocketMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PUDPSocketChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
