//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/ipc/PTestShellParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/TestShellParent.h"

#include "mozilla/dom/PContentParent.h"
#include "mozilla/ipc/PTestShellCommandParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace ipc {


MOZ_IMPLICIT PTestShellParent::PTestShellParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PTestShellParent);
}

PTestShellParent::~PTestShellParent()
{
    MOZ_COUNT_DTOR(PTestShellParent);
}

auto PTestShellParent::ActorAlloc() -> void
{
    AddRef();
}

auto PTestShellParent::ActorDealloc() -> void
{
    Release();
}

auto PTestShellParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PTestShellParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PTestShellParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PTestShellParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PTestShellParent::ManagedPTestShellCommandParent(nsTArray<PTestShellCommandParent*>& aArr) const -> void
{
    mManagedPTestShellCommandParent.ToArray(aArr);
}

auto PTestShellParent::ManagedPTestShellCommandParent() const -> const ManagedContainer<PTestShellCommandParent>&
{
    return mManagedPTestShellCommandParent;
}

auto PTestShellParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PTestShellCommandMsgStart
    };
    return sIds;
}

auto PTestShellParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PTestShellCommandMsgStart:
        return (&(mManagedPTestShellCommandParent));
    default:
        return nullptr;
    }
}

auto PTestShellParent::OpenPTestShellCommandEndpoint(PTestShellCommandParent* aActor) -> ManagedEndpoint<PTestShellCommandChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTestShellCommandParent actor");
        return ManagedEndpoint<PTestShellCommandChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTestShellCommandParent actor");
        return ManagedEndpoint<PTestShellCommandChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTestShellCommandChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PTestShellParent::BindPTestShellCommandEndpoint(
        ManagedEndpoint<PTestShellCommandParent> aEndpoint,
        PTestShellCommandParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PTestShellParent::Send__delete__(PTestShellParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PTestShell::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PTestShell", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTestShellParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTestShell::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PTestShellParent::SendExecuteCommand(const nsAString& aCommand) -> bool
{
    UniquePtr<IPC::Message> msg__ = PTestShell::Msg_ExecuteCommand(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aCommand);
    // Sentinel = 'aCommand'
    ((&(writer__)))->WriteSentinel(230097697);




    if (mozilla::ipc::LoggingEnabledFor("PTestShell", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTestShellParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTestShell::Msg_ExecuteCommand", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTestShellParent::SendPTestShellCommandConstructor(const nsAString& aCommand) -> PTestShellCommandParent*
{
    PTestShellCommandParent* actor = (static_cast<TestShellParent*>(this))->AllocPTestShellCommandParent(aCommand);
    return SendPTestShellCommandConstructor(std::move(actor), std::move(aCommand));
}

auto PTestShellParent::SendPTestShellCommandConstructor(
        PTestShellCommandParent* actor,
        const nsAString& aCommand) -> PTestShellCommandParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PTestShellCommandParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTestShellCommandParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PTestShell::Msg_PTestShellCommandConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), aCommand);
    // Sentinel = 'aCommand'
    ((&(writer__)))->WriteSentinel(230097697);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PTestShell", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTestShellParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTestShell::Msg_PTestShellCommandConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PTestShellCommandParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PTestShellParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PTestShellCommandMsgStart:
        static_cast<TestShellParent*>(this)->DeallocPTestShellCommandParent(static_cast<PTestShellCommandParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PTestShellParent::OnMessageReceived(const Message& msg__) -> PTestShellParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PTestShell::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PTestShell::Reply_PTestShellCommandConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PTestShellParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PTestShellParent::Result
{
    return MsgNotKnown;
}



} // namespace ipc
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::ipc::PTestShellParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::ipc::PTestShellParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PTestShell", PTestShellMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::ipc::PTestShellParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
