//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PTemporaryIPCBlobChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/TemporaryIPCBlobChild.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PTemporaryIPCBlobChild::PTemporaryIPCBlobChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PTemporaryIPCBlobChild);
}

PTemporaryIPCBlobChild::~PTemporaryIPCBlobChild()
{
    MOZ_COUNT_DTOR(PTemporaryIPCBlobChild);
}

auto PTemporaryIPCBlobChild::ActorAlloc() -> void
{
}

auto PTemporaryIPCBlobChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PTemporaryIPCBlobChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PTemporaryIPCBlobChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PTemporaryIPCBlobChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PTemporaryIPCBlobChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PTemporaryIPCBlobChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PTemporaryIPCBlobChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PTemporaryIPCBlobChild::SendOperationFailed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PTemporaryIPCBlob::Msg_OperationFailed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PTemporaryIPCBlob", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTemporaryIPCBlobChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTemporaryIPCBlob::Msg_OperationFailed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTemporaryIPCBlobChild::SendOperationDone(
        const nsACString& aContentType,
        const FileDescriptor& aFD) -> bool
{
    UniquePtr<IPC::Message> msg__ = PTemporaryIPCBlob::Msg_OperationDone(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aContentType);
    // Sentinel = 'aContentType'
    ((&(writer__)))->WriteSentinel(518522079);
    IPC::WriteParam((&(writer__)), aFD);
    // Sentinel = 'aFD'
    ((&(writer__)))->WriteSentinel(32899308);




    if (mozilla::ipc::LoggingEnabledFor("PTemporaryIPCBlob", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTemporaryIPCBlobChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTemporaryIPCBlob::Msg_OperationDone", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PTemporaryIPCBlobChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PTemporaryIPCBlobChild::OnMessageReceived(const Message& msg__) -> PTemporaryIPCBlobChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PTemporaryIPCBlob::Msg_FileDesc__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PTemporaryIPCBlob", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PTemporaryIPCBlobChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PTemporaryIPCBlob::Msg_FileDesc", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFD = IPC::ReadParam<FileDescriptor>((&(reader__)));
            if (!maybe__aFD) {
                FatalError("Error deserializing 'FileDescriptor'");
                return MsgValueError;

            }
            auto& aFD = *maybe__aFD;
            // Sentinel = 'aFD'
            if ((!(((&(reader__)))->ReadSentinel(32899308)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileDescriptor'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<TemporaryIPCBlobChild*>(this))->RecvFileDesc(std::move(aFD));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PTemporaryIPCBlob::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PTemporaryIPCBlob", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PTemporaryIPCBlobChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PTemporaryIPCBlob::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aBlobOrError = IPC::ReadParam<IPCBlobOrError>((&(reader__)));
            if (!maybe__aBlobOrError) {
                FatalError("Error deserializing 'IPCBlobOrError'");
                return MsgValueError;

            }
            auto& aBlobOrError = *maybe__aBlobOrError;
            // Sentinel = 'aBlobOrError'
            if ((!(((&(reader__)))->ReadSentinel(490276012)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCBlobOrError'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<TemporaryIPCBlobChild*>(this))->Recv__delete__(std::move(aBlobOrError));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PTemporaryIPCBlobChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PTemporaryIPCBlobChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PTemporaryIPCBlobChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PTemporaryIPCBlobChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PTemporaryIPCBlob", PTemporaryIPCBlobMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PTemporaryIPCBlobChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
