//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PSocketProcessChild.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/SocketProcessChild.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsID.h"
#include "nsIPropertyBag2.h"

#include "mozilla/net/PDNSRequestChild.h"
#include "mozilla/net/PSocketProcessBridgeChild.h"
#include "mozilla/PProfilerChild.h"
#include "mozilla/net/PWebrtcTCPSocketChild.h"
#include "mozilla/net/PHttpTransactionChild.h"
#include "mozilla/net/PHttpConnectionMgrChild.h"
#include "mozilla/net/PInputChannelThrottleQueueChild.h"
#include "mozilla/net/PAltServiceChild.h"
#include "mozilla/net/PAltSvcTransactionChild.h"
#include "mozilla/net/PTRRServiceChild.h"
#include "mozilla/net/PProxyConfigLookupChild.h"
#include "mozilla/net/PNativeDNSResolverOverrideChild.h"
#include "mozilla/net/PProxyAutoConfigChild.h"
#include "mozilla/net/PSocketProcessBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PSocketProcessChild::RecvPHttpTransactionConstructor(PHttpTransactionChild* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::RecvPHttpConnectionMgrConstructor(
        PHttpConnectionMgrChild* actor,
        const HttpHandlerInitArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::RecvPInputChannelThrottleQueueConstructor(
        PInputChannelThrottleQueueChild* actor,
        const uint32_t& meanBytesPerSecond,
        const uint32_t& maxBytesPerSecond) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::RecvPAltSvcTransactionConstructor(
        PAltSvcTransactionChild* actor,
        const HttpConnectionInfoCloneArgs& aConnInfo,
        const uint32_t& aCaps) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::RecvPTRRServiceConstructor(
        PTRRServiceChild* actor,
        const bool& aCaptiveIsPassed,
        const bool& aParentalControlEnabled,
        nsTArray<nsCString>&& aDNSSuffixList) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::RecvPNativeDNSResolverOverrideConstructor(PNativeDNSResolverOverrideChild* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::RecvPDNSRequestConstructor(
        PDNSRequestChild* actor,
        const nsACString& hostName,
        const nsACString& trrServer,
        const int32_t& port,
        const uint16_t& type,
        const OriginAttributes& originAttributes,
        const DNSFlags& flags) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PSocketProcessChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PSocketProcessChild::PSocketProcessChild() :
    mozilla::ipc::IToplevelProtocol("PSocketProcessChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PSocketProcessChild);
}

PSocketProcessChild::~PSocketProcessChild()
{
    MOZ_COUNT_DTOR(PSocketProcessChild);
}

auto PSocketProcessChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsSocketProcess(), "Invalid process for `PSocketProcessChild'");
    AddRef();
}

auto PSocketProcessChild::ActorDealloc() -> void
{
    Release();
}

auto PSocketProcessChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PSocketProcessChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PSocketProcessChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PSocketProcessChild::ManagedPDNSRequestChild(nsTArray<PDNSRequestChild*>& aArr) const -> void
{
    mManagedPDNSRequestChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPDNSRequestChild() const -> const ManagedContainer<PDNSRequestChild>&
{
    return mManagedPDNSRequestChild;
}

auto PSocketProcessChild::ManagedPWebrtcTCPSocketChild(nsTArray<PWebrtcTCPSocketChild*>& aArr) const -> void
{
    mManagedPWebrtcTCPSocketChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPWebrtcTCPSocketChild() const -> const ManagedContainer<PWebrtcTCPSocketChild>&
{
    return mManagedPWebrtcTCPSocketChild;
}

auto PSocketProcessChild::ManagedPHttpTransactionChild(nsTArray<PHttpTransactionChild*>& aArr) const -> void
{
    mManagedPHttpTransactionChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPHttpTransactionChild() const -> const ManagedContainer<PHttpTransactionChild>&
{
    return mManagedPHttpTransactionChild;
}

auto PSocketProcessChild::ManagedPHttpConnectionMgrChild(nsTArray<PHttpConnectionMgrChild*>& aArr) const -> void
{
    mManagedPHttpConnectionMgrChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPHttpConnectionMgrChild() const -> const ManagedContainer<PHttpConnectionMgrChild>&
{
    return mManagedPHttpConnectionMgrChild;
}

auto PSocketProcessChild::ManagedPInputChannelThrottleQueueChild(nsTArray<PInputChannelThrottleQueueChild*>& aArr) const -> void
{
    mManagedPInputChannelThrottleQueueChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPInputChannelThrottleQueueChild() const -> const ManagedContainer<PInputChannelThrottleQueueChild>&
{
    return mManagedPInputChannelThrottleQueueChild;
}

auto PSocketProcessChild::ManagedPAltServiceChild(nsTArray<PAltServiceChild*>& aArr) const -> void
{
    mManagedPAltServiceChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPAltServiceChild() const -> const ManagedContainer<PAltServiceChild>&
{
    return mManagedPAltServiceChild;
}

auto PSocketProcessChild::ManagedPAltSvcTransactionChild(nsTArray<PAltSvcTransactionChild*>& aArr) const -> void
{
    mManagedPAltSvcTransactionChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPAltSvcTransactionChild() const -> const ManagedContainer<PAltSvcTransactionChild>&
{
    return mManagedPAltSvcTransactionChild;
}

auto PSocketProcessChild::ManagedPTRRServiceChild(nsTArray<PTRRServiceChild*>& aArr) const -> void
{
    mManagedPTRRServiceChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPTRRServiceChild() const -> const ManagedContainer<PTRRServiceChild>&
{
    return mManagedPTRRServiceChild;
}

auto PSocketProcessChild::ManagedPProxyConfigLookupChild(nsTArray<PProxyConfigLookupChild*>& aArr) const -> void
{
    mManagedPProxyConfigLookupChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPProxyConfigLookupChild() const -> const ManagedContainer<PProxyConfigLookupChild>&
{
    return mManagedPProxyConfigLookupChild;
}

auto PSocketProcessChild::ManagedPNativeDNSResolverOverrideChild(nsTArray<PNativeDNSResolverOverrideChild*>& aArr) const -> void
{
    mManagedPNativeDNSResolverOverrideChild.ToArray(aArr);
}

auto PSocketProcessChild::ManagedPNativeDNSResolverOverrideChild() const -> const ManagedContainer<PNativeDNSResolverOverrideChild>&
{
    return mManagedPNativeDNSResolverOverrideChild;
}

auto PSocketProcessChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PDNSRequestMsgStart,
        PWebrtcTCPSocketMsgStart,
        PHttpTransactionMsgStart,
        PHttpConnectionMgrMsgStart,
        PInputChannelThrottleQueueMsgStart,
        PAltServiceMsgStart,
        PAltSvcTransactionMsgStart,
        PTRRServiceMsgStart,
        PProxyConfigLookupMsgStart,
        PNativeDNSResolverOverrideMsgStart
    };
    return sIds;
}

auto PSocketProcessChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PDNSRequestMsgStart:
        return (&(mManagedPDNSRequestChild));
    case PWebrtcTCPSocketMsgStart:
        return (&(mManagedPWebrtcTCPSocketChild));
    case PHttpTransactionMsgStart:
        return (&(mManagedPHttpTransactionChild));
    case PHttpConnectionMgrMsgStart:
        return (&(mManagedPHttpConnectionMgrChild));
    case PInputChannelThrottleQueueMsgStart:
        return (&(mManagedPInputChannelThrottleQueueChild));
    case PAltServiceMsgStart:
        return (&(mManagedPAltServiceChild));
    case PAltSvcTransactionMsgStart:
        return (&(mManagedPAltSvcTransactionChild));
    case PTRRServiceMsgStart:
        return (&(mManagedPTRRServiceChild));
    case PProxyConfigLookupMsgStart:
        return (&(mManagedPProxyConfigLookupChild));
    case PNativeDNSResolverOverrideMsgStart:
        return (&(mManagedPNativeDNSResolverOverrideChild));
    default:
        return nullptr;
    }
}

auto PSocketProcessChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PSocketProcessChild::OpenPDNSRequestEndpoint(PDNSRequestChild* aActor) -> ManagedEndpoint<PDNSRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PDNSRequestChild actor");
        return ManagedEndpoint<PDNSRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PDNSRequestChild actor");
        return ManagedEndpoint<PDNSRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PDNSRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPDNSRequestEndpoint(
        ManagedEndpoint<PDNSRequestChild> aEndpoint,
        PDNSRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPWebrtcTCPSocketEndpoint(PWebrtcTCPSocketChild* aActor) -> ManagedEndpoint<PWebrtcTCPSocketParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebrtcTCPSocketChild actor");
        return ManagedEndpoint<PWebrtcTCPSocketParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebrtcTCPSocketChild actor");
        return ManagedEndpoint<PWebrtcTCPSocketParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebrtcTCPSocketParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPWebrtcTCPSocketEndpoint(
        ManagedEndpoint<PWebrtcTCPSocketChild> aEndpoint,
        PWebrtcTCPSocketChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPHttpTransactionEndpoint(PHttpTransactionChild* aActor) -> ManagedEndpoint<PHttpTransactionParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PHttpTransactionChild actor");
        return ManagedEndpoint<PHttpTransactionParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpTransactionChild actor");
        return ManagedEndpoint<PHttpTransactionParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PHttpTransactionParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPHttpTransactionEndpoint(
        ManagedEndpoint<PHttpTransactionChild> aEndpoint,
        PHttpTransactionChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPHttpConnectionMgrEndpoint(PHttpConnectionMgrChild* aActor) -> ManagedEndpoint<PHttpConnectionMgrParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PHttpConnectionMgrChild actor");
        return ManagedEndpoint<PHttpConnectionMgrParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpConnectionMgrChild actor");
        return ManagedEndpoint<PHttpConnectionMgrParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PHttpConnectionMgrParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPHttpConnectionMgrEndpoint(
        ManagedEndpoint<PHttpConnectionMgrChild> aEndpoint,
        PHttpConnectionMgrChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPInputChannelThrottleQueueEndpoint(PInputChannelThrottleQueueChild* aActor) -> ManagedEndpoint<PInputChannelThrottleQueueParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PInputChannelThrottleQueueChild actor");
        return ManagedEndpoint<PInputChannelThrottleQueueParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PInputChannelThrottleQueueChild actor");
        return ManagedEndpoint<PInputChannelThrottleQueueParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PInputChannelThrottleQueueParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPInputChannelThrottleQueueEndpoint(
        ManagedEndpoint<PInputChannelThrottleQueueChild> aEndpoint,
        PInputChannelThrottleQueueChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPAltServiceEndpoint(PAltServiceChild* aActor) -> ManagedEndpoint<PAltServiceParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAltServiceChild actor");
        return ManagedEndpoint<PAltServiceParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltServiceChild actor");
        return ManagedEndpoint<PAltServiceParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAltServiceParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPAltServiceEndpoint(
        ManagedEndpoint<PAltServiceChild> aEndpoint,
        PAltServiceChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPAltSvcTransactionEndpoint(PAltSvcTransactionChild* aActor) -> ManagedEndpoint<PAltSvcTransactionParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAltSvcTransactionChild actor");
        return ManagedEndpoint<PAltSvcTransactionParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltSvcTransactionChild actor");
        return ManagedEndpoint<PAltSvcTransactionParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAltSvcTransactionParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPAltSvcTransactionEndpoint(
        ManagedEndpoint<PAltSvcTransactionChild> aEndpoint,
        PAltSvcTransactionChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPTRRServiceEndpoint(PTRRServiceChild* aActor) -> ManagedEndpoint<PTRRServiceParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTRRServiceChild actor");
        return ManagedEndpoint<PTRRServiceParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTRRServiceChild actor");
        return ManagedEndpoint<PTRRServiceParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTRRServiceParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPTRRServiceEndpoint(
        ManagedEndpoint<PTRRServiceChild> aEndpoint,
        PTRRServiceChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPProxyConfigLookupEndpoint(PProxyConfigLookupChild* aActor) -> ManagedEndpoint<PProxyConfigLookupParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PProxyConfigLookupChild actor");
        return ManagedEndpoint<PProxyConfigLookupParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PProxyConfigLookupChild actor");
        return ManagedEndpoint<PProxyConfigLookupParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PProxyConfigLookupParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPProxyConfigLookupEndpoint(
        ManagedEndpoint<PProxyConfigLookupChild> aEndpoint,
        PProxyConfigLookupChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::OpenPNativeDNSResolverOverrideEndpoint(PNativeDNSResolverOverrideChild* aActor) -> ManagedEndpoint<PNativeDNSResolverOverrideParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PNativeDNSResolverOverrideChild actor");
        return ManagedEndpoint<PNativeDNSResolverOverrideParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PNativeDNSResolverOverrideChild actor");
        return ManagedEndpoint<PNativeDNSResolverOverrideParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PNativeDNSResolverOverrideParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessChild::BindPNativeDNSResolverOverrideEndpoint(
        ManagedEndpoint<PNativeDNSResolverOverrideChild> aEndpoint,
        PNativeDNSResolverOverrideChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessChild::SendInitCrashReporter(const NativeThreadId& threadId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_InitCrashReporter(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), threadId);
    // Sentinel = 'threadId'
    ((&(writer__)))->WriteSentinel(248185638);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitCrashReporter", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendAddMemoryReport(const MemoryReport& aReport) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_AddMemoryReport(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aReport);
    // Sentinel = 'aReport'
    ((&(writer__)))->WriteSentinel(184025822);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_AddMemoryReport", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendAccumulateChildHistograms(mozilla::Span<HistogramAccumulation const> accumulations) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_AccumulateChildHistograms(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), accumulations);
    // Sentinel = 'accumulations'
    ((&(writer__)))->WriteSentinel(632030585);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_AccumulateChildHistograms", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendAccumulateChildKeyedHistograms(mozilla::Span<KeyedHistogramAccumulation const> accumulations) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_AccumulateChildKeyedHistograms(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), accumulations);
    // Sentinel = 'accumulations'
    ((&(writer__)))->WriteSentinel(632030585);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_AccumulateChildKeyedHistograms", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendUpdateChildScalars(mozilla::Span<ScalarAction const> actions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_UpdateChildScalars(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actions);
    // Sentinel = 'actions'
    ((&(writer__)))->WriteSentinel(193200882);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_UpdateChildScalars", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendUpdateChildKeyedScalars(mozilla::Span<KeyedScalarAction const> actions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_UpdateChildKeyedScalars(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actions);
    // Sentinel = 'actions'
    ((&(writer__)))->WriteSentinel(193200882);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_UpdateChildKeyedScalars", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendRecordChildEvents(mozilla::Span<ChildEventData const> events) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_RecordChildEvents(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), events);
    // Sentinel = 'events'
    ((&(writer__)))->WriteSentinel(149619350);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecordChildEvents", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendRecordDiscardedData(const DiscardedData& data) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_RecordDiscardedData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), data);
    // Sentinel = 'data'
    ((&(writer__)))->WriteSentinel(67109275);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecordDiscardedData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendPWebrtcTCPSocketConstructor(const mozilla::Maybe<TabId>& tabId) -> PWebrtcTCPSocketChild*
{
    PWebrtcTCPSocketChild* actor = (static_cast<SocketProcessChild*>(this))->AllocPWebrtcTCPSocketChild(tabId);
    return SendPWebrtcTCPSocketConstructor(std::move(actor), std::move(tabId));
}

auto PSocketProcessChild::SendPWebrtcTCPSocketConstructor(
        PWebrtcTCPSocketChild* actor,
        const mozilla::Maybe<TabId>& tabId) -> PWebrtcTCPSocketChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PWebrtcTCPSocketChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebrtcTCPSocketChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PWebrtcTCPSocketConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), tabId);
    // Sentinel = 'tabId'
    ((&(writer__)))->WriteSentinel(99156453);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PWebrtcTCPSocketConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PWebrtcTCPSocketChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessChild::SendObserveHttpActivity(
        const HttpActivityArgs& aActivityArgs,
        const uint32_t& aActivityType,
        const uint32_t& aActivitySubtype,
        const PRTime& aTimestamp,
        const uint64_t& aExtraSizeData,
        const nsACString& aExtraStringData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_ObserveHttpActivity(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aActivityArgs);
    // Sentinel = 'aActivityArgs'
    ((&(writer__)))->WriteSentinel(599721276);
    IPC::WriteParam((&(writer__)), aActivityType);
    // Sentinel = 'aActivityType'
    ((&(writer__)))->WriteSentinel(606340433);
    IPC::WriteParam((&(writer__)), aActivitySubtype);
    // Sentinel = 'aActivitySubtype'
    ((&(writer__)))->WriteSentinel(916326043);
    IPC::WriteParam((&(writer__)), aTimestamp);
    // Sentinel = 'aTimestamp'
    ((&(writer__)))->WriteSentinel(367330326);
    IPC::WriteParam((&(writer__)), aExtraSizeData);
    // Sentinel = 'aExtraSizeData'
    ((&(writer__)))->WriteSentinel(689833339);
    IPC::WriteParam((&(writer__)), aExtraStringData);
    // Sentinel = 'aExtraStringData'
    ((&(writer__)))->WriteSentinel(905315927);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_ObserveHttpActivity", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendInitSocketBackground(Endpoint<::mozilla::net::PSocketProcessBackgroundParent>&& aEndpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_InitSocketBackground(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(aEndpoint));
    // Sentinel = 'aEndpoint'
    ((&(writer__)))->WriteSentinel(292225955);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitSocketBackground", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendPAltServiceConstructor(PAltServiceChild* actor) -> PAltServiceChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PAltServiceChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltServiceChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PAltServiceConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PAltServiceConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PAltServiceChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessChild::SendPProxyConfigLookupConstructor(
        PProxyConfigLookupChild* actor,
        nsIURI* aUri,
        const uint32_t& aFlags) -> PProxyConfigLookupChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PProxyConfigLookupChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PProxyConfigLookupChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PProxyConfigLookupConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), aUri);
    // Sentinel = 'aUri'
    ((&(writer__)))->WriteSentinel(64225682);
    IPC::WriteParam((&(writer__)), aFlags);
    // Sentinel = 'aFlags'
    ((&(writer__)))->WriteSentinel(129892943);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PProxyConfigLookupConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PProxyConfigLookupChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessChild::SendCachePushCheck(
        nsIURI* aPushedURL,
        const OriginAttributes& aOriginAttributes,
        const nsACString& aRequestString,
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_CachePushCheck(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPushedURL);
    // Sentinel = 'aPushedURL'
    ((&(writer__)))->WriteSentinel(358155198);
    IPC::WriteParam((&(writer__)), aOriginAttributes);
    // Sentinel = 'aOriginAttributes'
    ((&(writer__)))->WriteSentinel(1021839089);
    IPC::WriteParam((&(writer__)), aRequestString);
    // Sentinel = 'aRequestString'
    ((&(writer__)))->WriteSentinel(712771010);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_CachePushCheck", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_CachePushCheck__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aAccepted = IPC::ReadParam<bool>(aReader);
            if (!maybe__aAccepted) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aAccepted = *maybe__aAccepted;
            // Sentinel = 'aAccepted'
            if ((!((aReader)->ReadSentinel(281281403)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aAccepted));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessChild::SendCachePushCheck(
        nsIURI* aPushedURL,
        const OriginAttributes& aOriginAttributes,
        const nsACString& aRequestString) -> RefPtr<CachePushCheckPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendCachePushCheck(std::move(aPushedURL), std::move(aOriginAttributes), std::move(aRequestString), [promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessChild::SendExcludeHttp2OrHttp3(const HttpConnectionInfoCloneArgs& aArgs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_ExcludeHttp2OrHttp3(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_ExcludeHttp2OrHttp3", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendOnConsoleMessage(const nsAString& aMessage) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_OnConsoleMessage(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aMessage);
    // Sentinel = 'aMessage'
    ((&(writer__)))->WriteSentinel(233440039);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnConsoleMessage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendFOGData(ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_FOGData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);




    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_FOGData", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessChild::SendPDNSRequestConstructor(
        PDNSRequestChild* actor,
        const nsACString& hostName,
        const nsACString& trrServer,
        const int32_t& port,
        const uint16_t& type,
        const OriginAttributes& originAttributes,
        const DNSFlags& flags) -> PDNSRequestChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PDNSRequestChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PDNSRequestChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PDNSRequestConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), hostName);
    // Sentinel = 'hostName'
    ((&(writer__)))->WriteSentinel(249627456);
    IPC::WriteParam((&(writer__)), trrServer);
    // Sentinel = 'trrServer'
    ((&(writer__)))->WriteSentinel(320603088);
    IPC::WriteParam((&(writer__)), port);
    // Sentinel = 'port'
    ((&(writer__)))->WriteSentinel(73990598);
    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);
    IPC::WriteParam((&(writer__)), originAttributes);
    // Sentinel = 'originAttributes'
    ((&(writer__)))->WriteSentinel(947259056);
    IPC::WriteParam((&(writer__)), flags);
    // Sentinel = 'flags'
    ((&(writer__)))->WriteSentinel(102171150);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PDNSRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PDNSRequestChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PWebrtcTCPSocketMsgStart:
        static_cast<SocketProcessChild*>(this)->DeallocPWebrtcTCPSocketChild(static_cast<PWebrtcTCPSocketChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PSocketProcessChild::OnMessageReceived(const Message& msg__) -> PSocketProcessChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PSocketProcess::Reply_PWebrtcTCPSocketConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_PAltServiceConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_PProxyConfigLookupConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_CachePushCheck__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_CachePushCheck", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Msg_Init__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_Init", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aAttributes = IPC::ReadParam<SocketPorcessInitAttributes>((&(reader__)));
            if (!maybe__aAttributes) {
                FatalError("Error deserializing 'SocketPorcessInitAttributes'");
                return MsgValueError;

            }
            auto& aAttributes = *maybe__aAttributes;
            // Sentinel = 'aAttributes'
            if ((!(((&(reader__)))->ReadSentinel(442434697)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SocketPorcessInitAttributes'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvInit(std::move(aAttributes));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PreferenceUpdate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PreferenceUpdate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pref = IPC::ReadParam<Pref>((&(reader__)));
            if (!maybe__pref) {
                FatalError("Error deserializing 'Pref'");
                return MsgValueError;

            }
            auto& pref = *maybe__pref;
            // Sentinel = 'pref'
            if ((!(((&(reader__)))->ReadSentinel(71958958)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Pref'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPreferenceUpdate(std::move(pref));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_RequestMemoryReport__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_RequestMemoryReport", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__generation = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__generation) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& generation = *maybe__generation;
            // Sentinel = 'generation'
            if ((!(((&(reader__)))->ReadSentinel(381158445)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__anonymize = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__anonymize) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& anonymize = *maybe__anonymize;
            // Sentinel = 'anonymize'
            if ((!(((&(reader__)))->ReadSentinel(321127387)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__minimizeMemoryUsage = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__minimizeMemoryUsage) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& minimizeMemoryUsage = *maybe__minimizeMemoryUsage;
            // Sentinel = 'minimizeMemoryUsage'
            if ((!(((&(reader__)))->ReadSentinel(1321600977)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__DMDFile = IPC::ReadParam<mozilla::Maybe<FileDescriptor>>((&(reader__)));
            if (!maybe__DMDFile) {
                FatalError("Error deserializing 'FileDescriptor?'");
                return MsgValueError;

            }
            auto& DMDFile = *maybe__DMDFile;
            // Sentinel = 'DMDFile'
            if ((!(((&(reader__)))->ReadSentinel(143983190)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileDescriptor?'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_RequestMemoryReport(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RequestMemoryReportResolver resolver = [resolver__ = std::move(resolver__)](const uint32_t& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aGeneration'
                    ((&(writer__)))->WriteSentinel(430179438);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvRequestMemoryReport(std::move(generation), std::move(anonymize), std::move(minimizeMemoryUsage), std::move(DMDFile), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_SetOffline__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_SetOffline", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__offline = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__offline) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& offline = *maybe__offline;
            // Sentinel = 'offline'
            if ((!(((&(reader__)))->ReadSentinel(194904804)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvSetOffline(std::move(offline));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_SetConnectivity__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_SetConnectivity", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__connectivity = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__connectivity) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& connectivity = *maybe__connectivity;
            // Sentinel = 'connectivity'
            if ((!(((&(reader__)))->ReadSentinel(548734240)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvSetConnectivity(std::move(connectivity));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_InitLinuxSandbox__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitLinuxSandbox", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__sandboxBroker = IPC::ReadParam<mozilla::Maybe<FileDescriptor>>((&(reader__)));
            if (!maybe__sandboxBroker) {
                FatalError("Error deserializing 'FileDescriptor?'");
                return MsgValueError;

            }
            auto& sandboxBroker = *maybe__sandboxBroker;
            // Sentinel = 'sandboxBroker'
            if ((!(((&(reader__)))->ReadSentinel(625149269)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileDescriptor?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvInitLinuxSandbox(std::move(sandboxBroker));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_InitSocketProcessBridgeParent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitSocketProcessBridgeParent", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__processId = IPC::ReadParam<ProcessId>((&(reader__)));
            if (!maybe__processId) {
                FatalError("Error deserializing 'ProcessId'");
                return MsgValueError;

            }
            auto& processId = *maybe__processId;
            // Sentinel = 'processId'
            if ((!(((&(reader__)))->ReadSentinel(318243757)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ProcessId'");
                return MsgValueError;
            }
            auto maybe__endpoint = IPC::ReadParam<Endpoint<::mozilla::net::PSocketProcessBridgeParent>>((&(reader__)));
            if (!maybe__endpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::net::PSocketProcessBridgeParent>'");
                return MsgValueError;

            }
            auto& endpoint = *maybe__endpoint;
            // Sentinel = 'endpoint'
            if ((!(((&(reader__)))->ReadSentinel(251724642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::net::PSocketProcessBridgeParent>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvInitSocketProcessBridgeParent(std::move(processId), std::move(endpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_InitProfiler__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitProfiler", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aEndpoint = IPC::ReadParam<Endpoint<::mozilla::PProfilerChild>>((&(reader__)));
            if (!maybe__aEndpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::PProfilerChild>'");
                return MsgValueError;

            }
            auto& aEndpoint = *maybe__aEndpoint;
            // Sentinel = 'aEndpoint'
            if ((!(((&(reader__)))->ReadSentinel(292225955)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::PProfilerChild>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvInitProfiler(std::move(aEndpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_SocketProcessTelemetryPing__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_SocketProcessTelemetryPing", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvSocketProcessTelemetryPing();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PHttpTransactionConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PHttpTransactionConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PHttpTransactionChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPHttpTransactionChild();
            if (!actor) {
                NS_WARNING("Cannot bind null PHttpTransactionChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PHttpTransactionChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPHttpTransactionConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PHttpConnectionMgrConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PHttpConnectionMgrConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<HttpHandlerInitArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'HttpHandlerInitArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpHandlerInitArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PHttpConnectionMgrChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPHttpConnectionMgrChild(aArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PHttpConnectionMgrChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PHttpConnectionMgrChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPHttpConnectionMgrConstructor(actor, std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_UpdateDeviceModelId__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_UpdateDeviceModelId", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aModelId = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aModelId) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aModelId = *maybe__aModelId;
            // Sentinel = 'aModelId'
            if ((!(((&(reader__)))->ReadSentinel(226951936)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvUpdateDeviceModelId(std::move(aModelId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_OnHttpActivityDistributorActivated__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnHttpActivityDistributorActivated", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIsActivated = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aIsActivated) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aIsActivated = *maybe__aIsActivated;
            // Sentinel = 'aIsActivated'
            if ((!(((&(reader__)))->ReadSentinel(496501939)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvOnHttpActivityDistributorActivated(std::move(aIsActivated));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_OnHttpActivityDistributorObserveProxyResponse__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnHttpActivityDistributorObserveProxyResponse", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIsEnabled = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aIsEnabled) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aIsEnabled = *maybe__aIsEnabled;
            // Sentinel = 'aIsEnabled'
            if ((!(((&(reader__)))->ReadSentinel(340984777)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvOnHttpActivityDistributorObserveProxyResponse(std::move(aIsEnabled));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_OnHttpActivityDistributorObserveConnection__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnHttpActivityDistributorObserveConnection", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aIsEnabled = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aIsEnabled) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aIsEnabled = *maybe__aIsEnabled;
            // Sentinel = 'aIsEnabled'
            if ((!(((&(reader__)))->ReadSentinel(340984777)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvOnHttpActivityDistributorObserveConnection(std::move(aIsEnabled));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PInputChannelThrottleQueueConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PInputChannelThrottleQueueConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__meanBytesPerSecond = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__meanBytesPerSecond) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& meanBytesPerSecond = *maybe__meanBytesPerSecond;
            // Sentinel = 'meanBytesPerSecond'
            if ((!(((&(reader__)))->ReadSentinel(1142097708)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__maxBytesPerSecond = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__maxBytesPerSecond) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& maxBytesPerSecond = *maybe__maxBytesPerSecond;
            // Sentinel = 'maxBytesPerSecond'
            if ((!(((&(reader__)))->ReadSentinel(1032193745)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PInputChannelThrottleQueueChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPInputChannelThrottleQueueChild(meanBytesPerSecond, maxBytesPerSecond);
            if (!actor) {
                NS_WARNING("Cannot bind null PInputChannelThrottleQueueChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PInputChannelThrottleQueueChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPInputChannelThrottleQueueConstructor(actor, std::move(meanBytesPerSecond), std::move(maxBytesPerSecond));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PAltSvcTransactionConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PAltSvcTransactionConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aConnInfo = IPC::ReadParam<HttpConnectionInfoCloneArgs>((&(reader__)));
            if (!maybe__aConnInfo) {
                FatalError("Error deserializing 'HttpConnectionInfoCloneArgs'");
                return MsgValueError;

            }
            auto& aConnInfo = *maybe__aConnInfo;
            // Sentinel = 'aConnInfo'
            if ((!(((&(reader__)))->ReadSentinel(284558204)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpConnectionInfoCloneArgs'");
                return MsgValueError;
            }
            auto maybe__aCaps = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aCaps) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aCaps = *maybe__aCaps;
            // Sentinel = 'aCaps'
            if ((!(((&(reader__)))->ReadSentinel(90964457)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PAltSvcTransactionChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPAltSvcTransactionChild(aConnInfo, aCaps);
            if (!actor) {
                NS_WARNING("Cannot bind null PAltSvcTransactionChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PAltSvcTransactionChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPAltSvcTransactionConstructor(actor, std::move(aConnInfo), std::move(aCaps));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_ClearSessionCache__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_ClearSessionCache", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_ClearSessionCache(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ClearSessionCacheResolver resolver = [resolver__ = std::move(resolver__)](const void_t& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'ok'
                    ((&(writer__)))->WriteSentinel(21692635);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvClearSessionCache(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PTRRServiceConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PTRRServiceConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__aCaptiveIsPassed = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aCaptiveIsPassed) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aCaptiveIsPassed = *maybe__aCaptiveIsPassed;
            // Sentinel = 'aCaptiveIsPassed'
            if ((!(((&(reader__)))->ReadSentinel(883689034)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__aParentalControlEnabled = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aParentalControlEnabled) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aParentalControlEnabled = *maybe__aParentalControlEnabled;
            // Sentinel = 'aParentalControlEnabled'
            if ((!(((&(reader__)))->ReadSentinel(1835010341)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__aDNSSuffixList = IPC::ReadParam<nsTArray<nsCString>>((&(reader__)));
            if (!maybe__aDNSSuffixList) {
                FatalError("Error deserializing 'nsCString[]'");
                return MsgValueError;

            }
            auto& aDNSSuffixList = *maybe__aDNSSuffixList;
            // Sentinel = 'aDNSSuffixList'
            if ((!(((&(reader__)))->ReadSentinel(636552536)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PTRRServiceChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPTRRServiceChild(aCaptiveIsPassed, aParentalControlEnabled, aDNSSuffixList);
            if (!actor) {
                NS_WARNING("Cannot bind null PTRRServiceChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PTRRServiceChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPTRRServiceConstructor(actor, std::move(aCaptiveIsPassed), std::move(aParentalControlEnabled), std::move(aDNSSuffixList));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PNativeDNSResolverOverrideConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PNativeDNSResolverOverrideConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PNativeDNSResolverOverrideChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPNativeDNSResolverOverrideChild();
            if (!actor) {
                NS_WARNING("Cannot bind null PNativeDNSResolverOverrideChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PNativeDNSResolverOverrideChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPNativeDNSResolverOverrideConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_NotifyObserver__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_NotifyObserver", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTopic = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aTopic) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aTopic = *maybe__aTopic;
            // Sentinel = 'aTopic'
            if ((!(((&(reader__)))->ReadSentinel(137429601)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aData = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aData) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aData = *maybe__aData;
            // Sentinel = 'aData'
            if ((!(((&(reader__)))->ReadSentinel(90571228)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvNotifyObserver(std::move(aTopic), std::move(aData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_GetSocketData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetSocketData", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_GetSocketData(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetSocketDataResolver resolver = [resolver__ = std::move(resolver__)](const SocketDataArgs& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'data'
                    ((&(writer__)))->WriteSentinel(67109275);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvGetSocketData(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_GetDNSCacheEntries__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetDNSCacheEntries", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_GetDNSCacheEntries(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetDNSCacheEntriesResolver resolver = [resolver__ = std::move(resolver__)](mozilla::Span<DNSCacheEntries const> aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'entries'
                    ((&(writer__)))->WriteSentinel(199361275);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvGetDNSCacheEntries(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_GetHttpConnectionData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetHttpConnectionData", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_GetHttpConnectionData(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetHttpConnectionDataResolver resolver = [resolver__ = std::move(resolver__)](mozilla::Span<HttpRetParams const> aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'params'
                    ((&(writer__)))->WriteSentinel(146997893);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvGetHttpConnectionData(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_InitProxyAutoConfigChild__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitProxyAutoConfigChild", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__endpoint = IPC::ReadParam<Endpoint<::mozilla::net::PProxyAutoConfigChild>>((&(reader__)));
            if (!maybe__endpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::net::PProxyAutoConfigChild>'");
                return MsgValueError;

            }
            auto& endpoint = *maybe__endpoint;
            // Sentinel = 'endpoint'
            if ((!(((&(reader__)))->ReadSentinel(251724642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::net::PProxyAutoConfigChild>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvInitProxyAutoConfigChild(std::move(endpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_RecheckIPConnectivity__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecheckIPConnectivity", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvRecheckIPConnectivity();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_RecheckDNS__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecheckDNS", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvRecheckDNS();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_FlushFOGData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_FlushFOGData", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_FlushFOGData(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            FlushFOGDataResolver resolver = [resolver__ = std::move(resolver__)](ByteBuf&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'buf'
                    ((&(writer__)))->WriteSentinel(41484606);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvFlushFOGData(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_TestTriggerMetrics__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_TestTriggerMetrics", OTHER);

            int32_t id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PSocketProcess::Reply_TestTriggerMetrics(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            TestTriggerMetricsResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'unused'
                    ((&(writer__)))->WriteSentinel(155517589);

                    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PSocketProcessChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvTestTriggerMetrics(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_AddNetAddrOverride__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_AddNetAddrOverride", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFrom = IPC::ReadParam<NetAddr>((&(reader__)));
            if (!maybe__aFrom) {
                FatalError("Error deserializing 'NetAddr'");
                return MsgValueError;

            }
            auto& aFrom = *maybe__aFrom;
            // Sentinel = 'aFrom'
            if ((!(((&(reader__)))->ReadSentinel(94568950)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NetAddr'");
                return MsgValueError;
            }
            auto maybe__aTo = IPC::ReadParam<NetAddr>((&(reader__)));
            if (!maybe__aTo) {
                FatalError("Error deserializing 'NetAddr'");
                return MsgValueError;

            }
            auto& aTo = *maybe__aTo;
            // Sentinel = 'aTo'
            if ((!(((&(reader__)))->ReadSentinel(37552421)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NetAddr'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvAddNetAddrOverride(std::move(aFrom), std::move(aTo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_ClearNetAddrOverrides__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_ClearNetAddrOverrides", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvClearNetAddrOverrides();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Reply_PDNSRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Msg_PDNSRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PDNSRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__hostName = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__hostName) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& hostName = *maybe__hostName;
            // Sentinel = 'hostName'
            if ((!(((&(reader__)))->ReadSentinel(249627456)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__trrServer = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__trrServer) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& trrServer = *maybe__trrServer;
            // Sentinel = 'trrServer'
            if ((!(((&(reader__)))->ReadSentinel(320603088)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__port = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__port) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& port = *maybe__port;
            // Sentinel = 'port'
            if ((!(((&(reader__)))->ReadSentinel(73990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<DNSFlags>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'DNSFlags'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSFlags'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PDNSRequestChild> actor = (static_cast<SocketProcessChild*>(this))->AllocPDNSRequestChild(hostName, trrServer, port, type, originAttributes, flags);
            if (!actor) {
                NS_WARNING("Cannot bind null PDNSRequestChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PDNSRequestChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessChild*>(this))->RecvPDNSRequestConstructor(actor, std::move(hostName), std::move(trrServer), std::move(port), std::move(type), std::move(originAttributes), std::move(flags));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PSocketProcessChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PSocketProcessChild::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PSocketProcessChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PSocketProcessChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PSocketProcess", PSocketProcessMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PSocketProcessChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
