//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PSimpleChannelChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PSimpleChannelChild::PSimpleChannelChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PSimpleChannelChild);
}

PSimpleChannelChild::~PSimpleChannelChild()
{
    MOZ_COUNT_DTOR(PSimpleChannelChild);
}

auto PSimpleChannelChild::ActorAlloc() -> void
{
}

auto PSimpleChannelChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PSimpleChannelChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PSimpleChannelChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PSimpleChannelChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PSimpleChannelChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PSimpleChannelChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PSimpleChannelChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PSimpleChannelChild::Send__delete__(PSimpleChannelChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PSimpleChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PSimpleChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSimpleChannelChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSimpleChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PSimpleChannelChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PSimpleChannelChild::OnMessageReceived(const Message& msg__) -> PSimpleChannelChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PSimpleChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PSimpleChannelChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PSimpleChannelChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PSimpleChannelChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::net::PSimpleChannelChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PSimpleChannel", PSimpleChannelMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::net::PSimpleChannelChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
