//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PSharedWorkerChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SharedWorkerChild.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PSharedWorkerChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PSharedWorkerChild::PSharedWorkerChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PSharedWorkerChild);
}

PSharedWorkerChild::~PSharedWorkerChild()
{
    MOZ_COUNT_DTOR(PSharedWorkerChild);
}

auto PSharedWorkerChild::ActorAlloc() -> void
{
}

auto PSharedWorkerChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PSharedWorkerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PSharedWorkerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PSharedWorkerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PSharedWorkerChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PSharedWorkerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PSharedWorkerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PSharedWorkerChild::SendClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSharedWorker::Msg_Close(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSharedWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSharedWorker::Msg_Close", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSharedWorkerChild::SendSuspend() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSharedWorker::Msg_Suspend(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSharedWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSharedWorker::Msg_Suspend", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSharedWorkerChild::SendResume() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSharedWorker::Msg_Resume(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSharedWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSharedWorker::Msg_Resume", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSharedWorkerChild::SendFreeze() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSharedWorker::Msg_Freeze(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSharedWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSharedWorker::Msg_Freeze", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSharedWorkerChild::SendThaw() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSharedWorker::Msg_Thaw(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSharedWorkerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSharedWorker::Msg_Thaw", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSharedWorkerChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PSharedWorkerChild::OnMessageReceived(const Message& msg__) -> PSharedWorkerChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PSharedWorker::Msg_Error__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSharedWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSharedWorker::Msg_Error", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__value = IPC::ReadParam<ErrorValue>((&(reader__)));
            if (!maybe__value) {
                FatalError("Error deserializing 'ErrorValue'");
                return MsgValueError;

            }
            auto& value = *maybe__value;
            // Sentinel = 'value'
            if ((!(((&(reader__)))->ReadSentinel(107610654)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ErrorValue'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SharedWorkerChild*>(this))->RecvError(std::move(value));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSharedWorker::Msg_NotifyLock__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSharedWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSharedWorker::Msg_NotifyLock", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aCreated = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aCreated) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aCreated = *maybe__aCreated;
            // Sentinel = 'aCreated'
            if ((!(((&(reader__)))->ReadSentinel(228066074)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SharedWorkerChild*>(this))->RecvNotifyLock(std::move(aCreated));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSharedWorker::Msg_NotifyWebTransport__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSharedWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSharedWorker::Msg_NotifyWebTransport", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aCreated = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aCreated) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aCreated = *maybe__aCreated;
            // Sentinel = 'aCreated'
            if ((!(((&(reader__)))->ReadSentinel(228066074)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SharedWorkerChild*>(this))->RecvNotifyWebTransport(std::move(aCreated));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSharedWorker::Msg_Terminate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSharedWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSharedWorker::Msg_Terminate", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<SharedWorkerChild*>(this))->RecvTerminate();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSharedWorker::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSharedWorker", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSharedWorkerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSharedWorker::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<SharedWorkerChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PSharedWorkerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PSharedWorkerChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PSharedWorkerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PSharedWorkerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PSharedWorker", PSharedWorkerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PSharedWorkerChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
