//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PSessionStorageObserverParent.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/dom/PContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PSessionStorageObserverParent::PSessionStorageObserverParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PSessionStorageObserverParent);
}

PSessionStorageObserverParent::~PSessionStorageObserverParent()
{
    MOZ_COUNT_DTOR(PSessionStorageObserverParent);
}

auto PSessionStorageObserverParent::ActorAlloc() -> void
{
}

auto PSessionStorageObserverParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PSessionStorageObserverParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PSessionStorageObserverParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PSessionStorageObserverParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PSessionStorageObserverParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PSessionStorageObserverParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PSessionStorageObserverParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PSessionStorageObserverParent::Send__delete__(PSessionStorageObserverParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PSessionStorageObserver::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PSessionStorageObserver", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSessionStorageObserverParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSessionStorageObserver::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PSessionStorageObserverParent::SendObserve(
        const nsACString& topic,
        const nsAString& originAttributesPattern,
        const nsACString& originScope) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSessionStorageObserver::Msg_Observe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), topic);
    // Sentinel = 'topic'
    ((&(writer__)))->WriteSentinel(109707808);
    IPC::WriteParam((&(writer__)), originAttributesPattern);
    // Sentinel = 'originAttributesPattern'
    ((&(writer__)))->WriteSentinel(1917913486);
    IPC::WriteParam((&(writer__)), originScope);
    // Sentinel = 'originScope'
    ((&(writer__)))->WriteSentinel(459080835);




    if (mozilla::ipc::LoggingEnabledFor("PSessionStorageObserver", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSessionStorageObserverParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSessionStorageObserver::Msg_Observe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSessionStorageObserverParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PSessionStorageObserverParent::OnMessageReceived(const Message& msg__) -> PSessionStorageObserverParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PSessionStorageObserver::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSessionStorageObserver", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSessionStorageObserverParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSessionStorageObserver::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSessionStorageObserver::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PSessionStorageObserverParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PSessionStorageObserverParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PSessionStorageObserverParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PSessionStorageObserverParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PSessionStorageObserver", PSessionStorageObserverMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PSessionStorageObserverParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
