//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PServiceWorkerParent.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/CSPMessageUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/DocShellMessageUtils.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PermissionMessageUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/TabMessageUtils.h"
#include "mozilla/dom/notification/IPCUtils.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/SerializedStructuredCloneBuffer.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsIContentSecurityPolicy.h"
#include "nsIPrincipal.h"
#include "nsIReferrerInfo.h"
#include "nsIURI.h"
#include "nsIVariant.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PServiceWorkerParent::PServiceWorkerParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PServiceWorkerParent);
}

PServiceWorkerParent::~PServiceWorkerParent()
{
    MOZ_COUNT_DTOR(PServiceWorkerParent);
}

auto PServiceWorkerParent::ActorAlloc() -> void
{
    AddRef();
}

auto PServiceWorkerParent::ActorDealloc() -> void
{
    Release();
}

auto PServiceWorkerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PServiceWorkerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PServiceWorkerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PServiceWorkerParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PServiceWorkerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PServiceWorkerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PServiceWorkerParent::Send__delete__(PServiceWorkerParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PServiceWorker::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PServiceWorker", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PServiceWorkerParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PServiceWorker::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PServiceWorkerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PServiceWorkerParent::OnMessageReceived(const Message& msg__) -> PServiceWorkerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PServiceWorker::Msg_Teardown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorker", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorker::Msg_Teardown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvTeardown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PServiceWorker::Msg_PostMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorker", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorker::Msg_PostMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClonedData = IPC::ReadParam<ClonedOrErrorMessageData>((&(reader__)));
            if (!maybe__aClonedData) {
                FatalError("Error deserializing 'ClonedOrErrorMessageData'");
                return MsgValueError;

            }
            auto& aClonedData = *maybe__aClonedData;
            // Sentinel = 'aClonedData'
            if ((!(((&(reader__)))->ReadSentinel(417858609)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClonedOrErrorMessageData'");
                return MsgValueError;
            }
            auto maybe__aSource = IPC::ReadParam<PostMessageSource>((&(reader__)));
            if (!maybe__aSource) {
                FatalError("Error deserializing 'PostMessageSource'");
                return MsgValueError;

            }
            auto& aSource = *maybe__aSource;
            // Sentinel = 'aSource'
            if ((!(((&(reader__)))->ReadSentinel(186647251)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PostMessageSource'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPostMessage(std::move(aClonedData), std::move(aSource));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PServiceWorker::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PServiceWorkerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PServiceWorkerParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PServiceWorkerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PServiceWorkerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PServiceWorker", PServiceWorkerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PServiceWorkerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
