//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PServiceWorkerContainerParent.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/ServiceWorkerIPCUtils.h"

#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PServiceWorkerContainerParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PServiceWorkerContainerParent::PServiceWorkerContainerParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PServiceWorkerContainerParent);
}

PServiceWorkerContainerParent::~PServiceWorkerContainerParent()
{
    MOZ_COUNT_DTOR(PServiceWorkerContainerParent);
}

auto PServiceWorkerContainerParent::ActorAlloc() -> void
{
    AddRef();
}

auto PServiceWorkerContainerParent::ActorDealloc() -> void
{
    Release();
}

auto PServiceWorkerContainerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PServiceWorkerContainerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PServiceWorkerContainerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PServiceWorkerContainerParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PServiceWorkerContainerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PServiceWorkerContainerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PServiceWorkerContainerParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PServiceWorkerContainerParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PServiceWorkerContainerParent::OnMessageReceived(const Message& msg__) -> PServiceWorkerContainerParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PServiceWorkerContainer::Msg_Register__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerContainerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorkerContainer::Msg_Register", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            auto maybe__aScopeURL = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aScopeURL) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aScopeURL = *maybe__aScopeURL;
            // Sentinel = 'aScopeURL'
            if ((!(((&(reader__)))->ReadSentinel(285999951)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aScriptURL = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aScriptURL) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aScriptURL = *maybe__aScriptURL;
            // Sentinel = 'aScriptURL'
            if ((!(((&(reader__)))->ReadSentinel(358220746)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__aUpdateViaCache = IPC::ReadParam<ServiceWorkerUpdateViaCache>((&(reader__)));
            if (!maybe__aUpdateViaCache) {
                FatalError("Error deserializing 'ServiceWorkerUpdateViaCache'");
                return MsgValueError;

            }
            auto& aUpdateViaCache = *maybe__aUpdateViaCache;
            // Sentinel = 'aUpdateViaCache'
            if ((!(((&(reader__)))->ReadSentinel(772408761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ServiceWorkerUpdateViaCache'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PServiceWorkerContainer::Reply_Register(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            RegisterResolver resolver = [resolver__ = std::move(resolver__)](const IPCServiceWorkerRegistrationDescriptorOrCopyableErrorResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aResult'
                    ((&(writer__)))->WriteSentinel(185205473);

                    if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PServiceWorkerContainerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvRegister(std::move(aClientInfo), std::move(aScopeURL), std::move(aScriptURL), std::move(aUpdateViaCache), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PServiceWorkerContainer::Msg_GetRegistration__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerContainerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorkerContainer::Msg_GetRegistration", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            auto maybe__aURL = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aURL) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aURL = *maybe__aURL;
            // Sentinel = 'aURL'
            if ((!(((&(reader__)))->ReadSentinel(58130773)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PServiceWorkerContainer::Reply_GetRegistration(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetRegistrationResolver resolver = [resolver__ = std::move(resolver__)](const IPCServiceWorkerRegistrationDescriptorOrCopyableErrorResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aResult'
                    ((&(writer__)))->WriteSentinel(185205473);

                    if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PServiceWorkerContainerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetRegistration(std::move(aClientInfo), std::move(aURL), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PServiceWorkerContainer::Msg_GetRegistrations__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerContainerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorkerContainer::Msg_GetRegistrations", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PServiceWorkerContainer::Reply_GetRegistrations(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetRegistrationsResolver resolver = [resolver__ = std::move(resolver__)](const IPCServiceWorkerRegistrationDescriptorListOrCopyableErrorResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aResult'
                    ((&(writer__)))->WriteSentinel(185205473);

                    if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PServiceWorkerContainerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetRegistrations(std::move(aClientInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PServiceWorkerContainer::Msg_GetReady__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerContainerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorkerContainer::Msg_GetReady", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            int32_t id__ = Id();
            UniquePtr<IPC::Message> reply__(PServiceWorkerContainer::Reply_GetReady(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetReadyResolver resolver = [resolver__ = std::move(resolver__)](const IPCServiceWorkerRegistrationDescriptorOrCopyableErrorResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aResult'
                    ((&(writer__)))->WriteSentinel(185205473);

                    if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PServiceWorkerContainerParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvGetReady(std::move(aClientInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PServiceWorkerContainer::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PServiceWorkerContainer", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PServiceWorkerContainerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PServiceWorkerContainer::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PServiceWorkerContainerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PServiceWorkerContainerParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PServiceWorkerContainerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PServiceWorkerContainerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PServiceWorkerContainer", PServiceWorkerContainerMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PServiceWorkerContainerParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
