//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/loader/PScriptCacheParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/loader/ScriptCacheActors.h"

#include "mozilla/dom/PContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace loader {


MOZ_IMPLICIT PScriptCacheParent::PScriptCacheParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PScriptCacheParent);
}

PScriptCacheParent::~PScriptCacheParent()
{
    MOZ_COUNT_DTOR(PScriptCacheParent);
}

auto PScriptCacheParent::ActorAlloc() -> void
{
}

auto PScriptCacheParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PScriptCacheParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PScriptCacheParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PScriptCacheParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PScriptCacheParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PScriptCacheParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PScriptCacheParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PScriptCacheParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PScriptCacheParent::OnMessageReceived(const Message& msg__) -> PScriptCacheParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PScriptCache::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PScriptCache", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PScriptCacheParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PScriptCache::Msg___delete__", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__scripts = IPC::ReadParam<nsTArray<ScriptData>>((&(reader__)));
            if (!maybe__scripts) {
                FatalError("Error deserializing 'ScriptData[]'");
                return MsgValueError;

            }
            auto& scripts = *maybe__scripts;
            // Sentinel = 'scripts'
            if ((!(((&(reader__)))->ReadSentinel(201786121)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ScriptData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<ScriptCacheParent*>(this))->Recv__delete__(std::move(scripts));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PScriptCacheParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PScriptCacheParent::Result
{
    return MsgNotKnown;
}



} // namespace loader
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::loader::PScriptCacheParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::loader::PScriptCacheParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PScriptCache", PScriptCacheMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::loader::PScriptCacheParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
