//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PRemoteWorkerServiceParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/RemoteWorkerServiceParent.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "nsID.h"

#include "mozilla/dom/PRemoteWorkerParent.h"
#include "mozilla/dom/PRemoteWorkerNonLifeCycleOpControllerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PRemoteWorkerServiceParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PRemoteWorkerServiceParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PRemoteWorkerServiceParent::PRemoteWorkerServiceParent() :
    mozilla::ipc::IToplevelProtocol("PRemoteWorkerServiceParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PRemoteWorkerServiceParent);
}

PRemoteWorkerServiceParent::~PRemoteWorkerServiceParent()
{
    MOZ_COUNT_DTOR(PRemoteWorkerServiceParent);
}

auto PRemoteWorkerServiceParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess(), "Invalid process for `PRemoteWorkerServiceParent'");
    AddRef();
}

auto PRemoteWorkerServiceParent::ActorDealloc() -> void
{
    Release();
}

auto PRemoteWorkerServiceParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteWorkerServiceParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteWorkerServiceParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteWorkerServiceParent::ManagedPRemoteWorkerParent(nsTArray<PRemoteWorkerParent*>& aArr) const -> void
{
    mManagedPRemoteWorkerParent.ToArray(aArr);
}

auto PRemoteWorkerServiceParent::ManagedPRemoteWorkerParent() const -> const ManagedContainer<PRemoteWorkerParent>&
{
    return mManagedPRemoteWorkerParent;
}

auto PRemoteWorkerServiceParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PRemoteWorkerMsgStart
    };
    return sIds;
}

auto PRemoteWorkerServiceParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PRemoteWorkerMsgStart:
        return (&(mManagedPRemoteWorkerParent));
    default:
        return nullptr;
    }
}

auto PRemoteWorkerServiceParent::OpenPRemoteWorkerEndpoint(PRemoteWorkerParent* aActor) -> ManagedEndpoint<PRemoteWorkerChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PRemoteWorkerParent actor");
        return ManagedEndpoint<PRemoteWorkerChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteWorkerParent actor");
        return ManagedEndpoint<PRemoteWorkerChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PRemoteWorkerChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteWorkerServiceParent::BindPRemoteWorkerEndpoint(
        ManagedEndpoint<PRemoteWorkerParent> aEndpoint,
        PRemoteWorkerParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteWorkerServiceParent::SendPRemoteWorkerConstructor(
        PRemoteWorkerParent* actor,
        const RemoteWorkerData& data,
        Endpoint<::mozilla::dom::PRemoteWorkerNonLifeCycleOpControllerChild>&& childEp) -> PRemoteWorkerParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PRemoteWorkerParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteWorkerParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PRemoteWorkerService::Msg_PRemoteWorkerConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), data);
    // Sentinel = 'data'
    ((&(writer__)))->WriteSentinel(67109275);
    IPC::WriteParam((&(writer__)), std::move(childEp));
    // Sentinel = 'childEp'
    ((&(writer__)))->WriteSentinel(185533114);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerService", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteWorkerServiceParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteWorkerService::Msg_PRemoteWorkerConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PRemoteWorkerParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PRemoteWorkerServiceParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PRemoteWorkerServiceParent::OnMessageReceived(const Message& msg__) -> PRemoteWorkerServiceParent::Result
{
    int32_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteWorkerService", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteWorkerServiceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PRemoteWorkerService::Reply_PRemoteWorkerConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PRemoteWorkerServiceParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteWorkerServiceParent::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PRemoteWorkerServiceParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::PRemoteWorkerServiceParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PRemoteWorkerService", PRemoteWorkerServiceMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::PRemoteWorkerServiceParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
